<HTML>
<HEAD>
<TITLE>SRC Modula-3: videovbt/src/VideoVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>videovbt/src/VideoVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> this VBT attaches itself to a stream from a JVideo source and displays
   the image stream when it is mapped 

<P><PRE>INTERFACE <interface><A HREF="VideoVBT.m3">VideoVBT</A></interface>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../jvideo/src/JVDecomp.i3">JVDecomp</A>, <A HREF="../../jvideo/src/JVSink.i3">JVSink</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="VideoVBT.m3#T">T</A> &lt;: Public;
  Public =
    VBT.Leaf OBJECT
    METHODS
      &lt;*  LL =&lt; {v} *&gt;
      init (sourceHost   : TEXT;
            quality      : JVSink.Quality;
            ncolours     : CARDINAL         := 50;
            width        : CARDINAL         := 320;
            height       : CARDINAL         := 240;
            synchronous                     := FALSE;
            fixedSize                       := FALSE;
            minFrameMSecs: CARDINAL         := 0      ): T;
      (* initial setup.  Describes the connection we want.  /ncolours/ is
         the number of cells requested for the colourmap.  /width/ and
         /height/ are the requested size of the image, the JVideo card may
         round these values up.  If the image is larger than the VBT, the
         lower right sides will be clipped.  If /synchronous/ then the
         paint loop waits until the image buffer is free before starting to
         paint the next frame, otherwise it tries to overlap its activity
         some.  If /fixedSize/ then the VBT will attempt to remain the same
         size as its video images, otherwise it will attempt to fit the
         video to its current size.  /minFrameMSecs/ specifies the minimum
         number of milliseconds a video frame will take.  This allows the
         caller to slow the video stream down. *)

      (* procedures to set values *)
      &lt;* LL &lt; v *&gt;
      setQuality       (quality: JVSink.Quality);
      setSize          (width, height: CARDINAL);
      setMinFrameMSecs (msecs: CARDINAL);
      setSynchronous   (synchronous: BOOLEAN);
      setFixedSize     (fixedSize : BOOLEAN);

      getDecomp (): JVDecomp.T;
      (* return the JVDecomp.T associated with the T.  May return NIL *)

      getSize (VAR width, height: CARDINAL);
      (* return the size of the video images *)

      setPaused (paused := FALSE);
      (* stop or start the VBT without breaking any connections *)

      (* JVConverter-like statistics *)
      startStats ();
      stopStats  ();
      getStats   (): JVDecomp.Statistics;
    END;

END VideoVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
