<HTML>
<HEAD>
<TITLE>SRC Modula-3: videovbt/src/VideoVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>videovbt/src/VideoVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Freeman 

<P><PRE>UNSAFE MODULE <module>VideoVBT</module> EXPORTS <A HREF="VideoVBT.i3"><implements>VideoVBT</A></implements>, <A HREF="VideoVBTRep.i3"><implements>VideoVBTRep</A></implements>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="#x1">BasicCtypes</A>, <A HREF="../../rw/src/Common/IO.i3">IO</A>, <A HREF="../../jvideo/src/JVBuffer.i3">JVBuffer</A>, <A HREF="../../jvideo/src/JVConverter.i3">JVConverter</A>,
       <A HREF="../../jvideo/src/JVFromDecomp.i3">JVFromDecomp</A>, <A HREF="../../jvideo/src/JVDecomp.i3">JVDecomp</A>, <A HREF="../../jvideo/src/JVDecompPool.i3">JVDecompPool</A>, <A HREF="../../jvideo/src/Jvs.i3">Jvs</A>, <A HREF="../../jvideo/src/JvsBuffer.i3">JvsBuffer</A>, <A HREF="../../jvideo/src/JVSink.i3">JVSink</A>,
       <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="#x2">Picture</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/ScreenType.i3">ScreenType</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>,
       <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Tick.i3">Tick</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/xvbt/TrestleOnX.i3">TrestleOnX</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../ui/src/xvbt/XScreenType.i3">XScreenType</A>, <A HREF="../../ui/src/xvbt/XScrnCmap.i3">XScrnCmap</A>;

&lt;*PRAGMA LL*&gt;
</PRE> {{{ -- Buffer -- 

<P><PRE>REVEAL
  <A NAME="Buffer">Buffer</A> = BufferPublic BRANDED OBJECT
             st           : VBT.ScreenType        := NIL;
             width, height: CARDINAL              := 0;
             pic          : Picture.T             := NIL;
             shmInfo      : Picture.SharedMemInfo := NIL;
           OVERRIDES
             init    := BInit;
             picture := BPicture;
           END;

PROCEDURE <A NAME="BInit"><procedure>BInit</procedure></A> (b: Buffer; shmid: BasicCtypes.int; address: ADDRESS):
  JVBuffer.T RAISES {OSError.E} =
  BEGIN
    TRY
      EVAL JVFromDecomp.T.init(b, shmid, address);
      IF b.st # NIL THEN
        &lt;* ASSERT b.addr # NIL *&gt;
        LOCK b DO
          b.shmInfo :=
            NEW(Picture.SharedMemInfo, id := b.shmid, address := address);
          b.pic := Picture.New(b.st, b.width, b.height);
          Picture.AttachData(b.pic, address, b.shmInfo);
        END;
      END;
    EXCEPT
    | Picture.TrestleFail =&gt;
        RAISE
          OSError.E(AtomList.List2(Atom.FromText(&quot;VideoVBT.Init&quot;),
                                   Atom.FromText(&quot;Picture.TrestleFail&quot;)));
    | Picture.ScreenTypeNotSupported =&gt;
        RAISE OSError.E(
                AtomList.List2(Atom.FromText(&quot;VideoVBT.Init&quot;),
                               Atom.FromText(&quot;Picture.BadScreenType&quot;)));
    END;
    RETURN b;
  END BInit;

PROCEDURE <A NAME="BPicture"><procedure>BPicture</procedure></A> (b: Buffer): Picture.T =
  BEGIN
    RETURN b.pic;
  END BPicture;
</PRE> }}} 
 {{{ -- factory -- 

<P><PRE>REVEAL
  <A NAME="Factory">Factory</A> = PublicFactory BRANDED OBJECT
              st           : VBT.ScreenType := NIL;
              width, height: CARDINAL;
            OVERRIDES
              preInit := FPreInit;
              reset   := FReset;
              newBuf  := FNewBuf;
              destroy := FDestroy;
            END;

PROCEDURE <A NAME="FPreInit"><procedure>FPreInit</procedure></A> (f: Factory; st: VBT.ScreenType; width, height: CARDINAL)
  RAISES {Picture.ScreenTypeNotSupported, OSError.E} =
  VAR params: Jvs.DcmpParams;
  BEGIN
    IF NOT Picture.Supported(st) THEN
      RAISE Picture.ScreenTypeNotSupported;
    END;

    (* get nearest output width and height *)
    params.inX := width;
    params.inY := height;
    params.reqX := width;
    params.reqY := height;
    TRY
      WITH jvs = NEW(Jvs.T).init() DO
        EVAL jvs.setDecompress(params);
        jvs.close();
      END;
    EXCEPT
    | Thread.Alerted =&gt;          (* skip *)
    END;

    f.st := st;
    f.width := params.outX;
    f.height := params.outY;
  END FPreInit;

PROCEDURE <A NAME="FNewBuf"><procedure>FNewBuf</procedure></A> (fac: JvsBuffer.Factory): JvsBuffer.T =
  BEGIN
    WITH f = NARROW(fac, Factory) DO
      RETURN NEW(Buffer, st := f.st, width := f.width, height := f.height);
    END;
  END FNewBuf;

PROCEDURE <A NAME="FReset"><procedure>FReset</procedure></A> (f: JVBuffer.Factory; b: JVBuffer.T) =
  BEGIN
    (* reset the dimensions of the XImage structure.  The shared memory
       buffers all have a fixed size. *)
    WITH fac   = NARROW(f, Factory),
         buf   = NARROW(b, Buffer),
         image = Picture.Image(buf.pic) DO
      buf.width := fac.width;
      buf.height := fac.height;
      image.width := fac.width;
      image.height := fac.height;
    END;
  END FReset;

PROCEDURE <A NAME="FDestroy"><procedure>FDestroy</procedure></A> (fac: JVBuffer.Factory; buf: JVBuffer.T)
  RAISES {Thread.Alerted, OSError.E} =
  BEGIN
    (* drop the Picture data structures, but keep the shared memory
       segment *)
    TYPECASE buf OF
    | Buffer (b) =&gt;
        TRY
          LOCK b DO
            Picture.DetachData(b.pic);
            JvsBuffer.FreeBuffer(Jvs.BufferType.Decompress, b.shmInfo.id);
          END;
        EXCEPT
        | Picture.TrestleFail =&gt;
            IO.Put(
              &quot;VideoVBT.Picture.DetachData.TrestleFail\n&quot;, Stdio.stderr);
        END;
    ELSE
      JVFromDecomp.Factory.destroy(fac, buf);
    END;
  END FDestroy;
</PRE> }}} 
 {{{ -- the T -- 

<P><PRE>CONST DefaultMaxBuffers = 2;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        offset                         := Point.Origin;
        sourceHost: TEXT;
        quality   : JVSink.Quality;
        dparams                        := Jvs.DefaultDecompress;
        cmap      : Jvs.ColormapInfo;
        sinkBuffers, decompBuffers: CARDINAL := DefaultMaxBuffers;
        synchronous                          := FALSE;
        fixedSize                            := FALSE;
        minFrameMSecs             : CARDINAL := 0;
        minFrameSecs              : LONGREAL := 0.0d0;

        (* start a thread when nothing running and reshape from empty to
           not empty and suitable screen type.  a thread when reshape to
           empty.  stop a thread when rescreen.  Thread cleans up fields in
           v when it is alerted *)
        starting                         := FALSE;
        input      : JVBuffer.Pool       := NIL;
        decomp     : JVDecomp.T          := NIL;
        thread     : Thread.T            := NIL;
        pauseEvent : Thread.Condition;
        paused                           := FALSE;
        statistics : JVDecomp.Statistics := NIL;
        stopEvent  : Thread.Condition;
        startThread: Thread.T            := NIL;
        (* used to avoid locking the VBT tree when starting up a new
           connection *)
        vis := TrestleOnX.VisibilityUnobscured;
      OVERRIDES
        init     := Init;
        repaint  := Repaint;
        reshape  := Reshape;
        rescreen := Rescreen;
        shape    := Shape;
        discard  := Discard;
        misc     := Misc;

        setQuality       := SetQuality;
        setSize          := SetSize;
        setMinFrameMSecs := SetMinFrameMSecs;
        setSynchronous   := SetSynchronous;
        setFixedSize     := SetFixedSize;

        getDecomp  := GetDecomp;
        getSize    := GetSize;
        setPaused  := SetPaused;
        startStats := StartStats;
        stopStats  := StopStats;
        getStats   := GetStats;
      END;
</PRE> }}} 
 {{{ -- methods -- 

<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v            : T;
                sourceHost   : TEXT;
                quality      : JVSink.Quality;
                ncolours     : CARDINAL         := 50;
                width        : CARDINAL         := 320;
                height       : CARDINAL         := 240;
                synchronous                     := FALSE;
                fixedSize                       := FALSE;
                minFrameMSecs: CARDINAL         := 0      ): T =
  BEGIN
    v.sourceHost := sourceHost;
    v.quality := quality;
    v.cmap.nColors := ncolours;
    v.dparams.reqX := width;
    v.dparams.outX := width;
    v.dparams.reqY := height;
    v.dparams.outY := height;
    v.synchronous := synchronous;
    v.fixedSize := fixedSize;
    v.minFrameMSecs := minFrameMSecs;

    IF minFrameMSecs &gt; 0 THEN
      v.minFrameSecs := FLOAT(minFrameMSecs, LONGREAL) / 1000.0d0;
    END;

    v.pauseEvent := NEW(Thread.Condition);
    v.stopEvent := NEW(Thread.Condition);
    RETURN v;
  END Init;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY rgn: Region.T) =
  VAR buff: Buffer := NIL;
  BEGIN
    IF v.st # NIL AND v.input # NIL THEN
      LOCK v DO
        buff := NARROW(v.input.getCurrentBuffer(), Buffer);
        IF buff = NIL THEN RETURN; END;
      END;
      TRY
        IF buff.pic # NIL THEN
          Picture.Paint(v, buff.pic, rgn.r, delta := v.offset);
        END;
      EXCEPT
      | Thread.Alerted =&gt;        (*skip *)
      END;
      &lt;* ASSERT buff # NIL *&gt;
      buff.free();
    END;
  END Repaint;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (v: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    LOCK v DO v.offset := Rect.NorthWest(v.domain); END;

    IF Rect.Congruent(cd.prev, cd.new) OR v.st = NIL THEN
      (* there's no video work to do *)
      VBT.Leaf.reshape(v, cd);
      RETURN;
    END;

    IF cd.new = Rect.Empty THEN
      (* think about closing down the thread *)
      Stop(v);
    ELSE
      IF cd.prev = Rect.Empty AND v.thread = NIL THEN
        (* try to start a new connection *)
        TYPECASE v.st OF
        | XScreenType.T (xst) =&gt;
            WITH trsl = Trestle.ScreenOf(v, Point.Origin).trsl,
                 id   = XScrnCmap.ColorMapID(xst.cmap.standard()) DO
              IF trsl # NIL AND id # Jvs.IdNone THEN
                LOCK v DO
                  IF NOT v.fixedSize THEN
                    v.dparams.reqX := Rect.HorSize(cd.new);
                    v.dparams.outX := v.dparams.reqX;
                    v.dparams.reqY := Rect.VerSize(cd.new);
                    v.dparams.outY := v.dparams.reqY;
                  END;
                  v.cmap.id := id;
                  v.cmap.displayName := trsl.trestleId();
                  v.starting := FALSE;
                END;
                Start(v);
              END;
            END;
        ELSE                     (* we don't understand this type *)
        END;

      ELSE
        IF NOT v.fixedSize THEN
          (* change the size of the image *)
          Stop(v);
          LOCK v DO
            v.dparams.reqX := Rect.HorSize(cd.new);
            v.dparams.outX := v.dparams.reqX;
            v.dparams.reqY := Rect.VerSize(cd.new);
            v.dparams.outY := v.dparams.reqY;
          END;
          Start(v);
        END;
        IF cd.prev = Rect.Empty THEN Thread.Signal(v.pauseEvent); END;
      END;
    END;
    VBT.Leaf.reshape(v, cd);
  END Reshape;

&lt;* FATAL TrestleComm.Failure *&gt;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    Stop(v);
    (* if we need to restart it will be done in the reshape *)
    IF cd.st # NIL THEN LOCK v DO v.starting := TRUE; END; END;
    VBT.Leaf.rescreen(v, cd);
  END Rescreen;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: T; ax: Axis.T; &lt;*UNUSED*&gt; n: CARDINAL): VBT.SizeRange =
  VAR res := VBT.DefaultShape;
  BEGIN
    IF v.st # NIL THEN
      LOCK v DO
        IF v.fixedSize THEN
          CASE ax OF
          | Axis.T.Hor =&gt;
              (* the JVboard wastes 12 pixels on the end of each line *)
              res.pref := MAX(v.dparams.outX - 12, 0);
          | Axis.T.Ver =&gt; res.pref := v.dparams.outY;
          END;
        END;
      END;
    END;
    RETURN res;
  END Shape;

PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (v: T) =
  BEGIN
    Stop(v);
    VBT.Leaf.discard(v);
  END Discard;

PROCEDURE <A NAME="Misc"><procedure>Misc</procedure></A> (v: T; READONLY cd: VBT.MiscRec) =
  BEGIN
    IF cd.type = VBT.Deleted OR cd.type = VBT.Disconnected THEN
      Discard(v);
    END;
    IF cd.type = TrestleOnX.Visibility THEN
      v.vis := cd.detail[0];
      Thread.Signal(v.pauseEvent);
    END;
    VBT.Leaf.misc(v, cd);
  END Misc;

PROCEDURE <A NAME="SetQuality"><procedure>SetQuality</procedure></A> (v: T; quality: JVSink.Quality) =
  BEGIN
    SetPictureParams(v, v.sourceHost, quality, v.dparams, v.cmap);
  END SetQuality;

PROCEDURE <A NAME="SetSize"><procedure>SetSize</procedure></A> (v: T; width, height: CARDINAL) =
  VAR dparams := v.dparams;
  BEGIN
    dparams.reqX := width;
    dparams.reqY := height;
    SetPictureParams(v, v.sourceHost, v.quality, dparams, v.cmap);
  END SetSize;

PROCEDURE <A NAME="SetMinFrameMSecs"><procedure>SetMinFrameMSecs</procedure></A> (v: T; msecs: CARDINAL) =
  BEGIN
    Stop(v);
    LOCK v DO
      v.minFrameMSecs := msecs;
      v.minFrameSecs := FLOAT(msecs, LONGREAL) / 1000.0d0;
    END;
    IF v.st # NIL THEN
      TYPECASE v.st OF XScreenType.T =&gt; Start(v) ELSE END
    END
  END SetMinFrameMSecs;

PROCEDURE <A NAME="SetSynchronous"><procedure>SetSynchronous</procedure></A> (v: T; synchronous: BOOLEAN) =
  BEGIN
    LOCK v DO v.synchronous := synchronous; END;
  END SetSynchronous;

PROCEDURE <A NAME="SetFixedSize"><procedure>SetFixedSize</procedure></A> (v: T; fixedSize: BOOLEAN) =
  BEGIN
    LOCK v DO v.fixedSize := fixedSize; END;
    VBT.NewShape(v);
  END SetFixedSize;

PROCEDURE <A NAME="GetDecomp"><procedure>GetDecomp</procedure></A> (v: T): JVDecomp.T =
  BEGIN
    RETURN v.decomp;
  END GetDecomp;

PROCEDURE <A NAME="GetSize"><procedure>GetSize</procedure></A> (v: T; VAR width, height: CARDINAL) =
  BEGIN
    LOCK v DO width := v.dparams.outX; height := v.dparams.outY; END;
  END GetSize;

PROCEDURE <A NAME="SetPaused"><procedure>SetPaused</procedure></A> (v: T; paused := FALSE) =
  BEGIN
    LOCK v DO v.paused := paused; END;
    Thread.Signal(v.pauseEvent);
  END SetPaused;
</PRE> }}} 
 {{{ -- statistics -- 

<P><PRE>PROCEDURE <A NAME="StartStats"><procedure>StartStats</procedure></A> (t: T) =
  BEGIN
    LOCK t DO
      IF t.statistics = NIL THEN
        t.statistics := NEW(JVDecomp.Statistics);
      END;
      WITH s = t.statistics DO
        s.framesStarted := 0;
        s.framesProcessed := 0;
        s.timesBlocked := 0;
        s.cumLatency := 0;
      END;
    END;
  END StartStats;

PROCEDURE <A NAME="StopStats"><procedure>StopStats</procedure></A> (t: T) =
  BEGIN
    LOCK t DO t.statistics := NIL; END;
  END StopStats;

PROCEDURE <A NAME="GetStats"><procedure>GetStats</procedure></A> (t: T): JVDecomp.Statistics =
  BEGIN
    RETURN t.statistics;
  END GetStats;
</PRE> }}} 
 {{{ -- exported in VideoVBTRep.i3 -- 

<P><PRE>PROCEDURE <A NAME="SetPictureParams"><procedure>SetPictureParams</procedure></A> (         v         : T;
                                     sourceHost: TEXT;
                                     quality   : JVSink.Quality;
                            READONLY dparams   : Jvs.DcmpParams;
                            READONLY cmap      : Jvs.ColormapInfo) =
  VAR
    name: TEXT;
    id  : Jvs.Id;
  BEGIN
    Stop(v);

    LOCK v DO
      v.sourceHost := sourceHost;
      v.quality := quality;
      v.dparams := dparams;
      v.cmap := cmap;
    END;
    IF v.st # NIL THEN
      TYPECASE v.st OF
      | XScreenType.T (xst) =&gt;
          WITH trsl = Trestle.ScreenOf(v, Point.Origin).trsl DO
            IF trsl # NIL THEN
              name := trsl.trestleId();
              id := XScrnCmap.ColorMapID(xst.cmap.standard());
              IF id # Jvs.IdNone THEN
                LOCK v DO v.cmap.id := id; v.cmap.displayName := name; END;
                IF NOT v.fixedSize THEN
                  VBT.NewShape(v);
                ELSE
                  Start(v);
                END;
              END;
            END;
          END;
      ELSE                       (* skip *)
      END;
    END;
  END SetPictureParams;

PROCEDURE <A NAME="GetPictureParams"><procedure>GetPictureParams</procedure></A> (    v         : T;
                            VAR sourceHost: TEXT;
                            VAR quality   : JVSink.Quality;
                            VAR dparams   : Jvs.DcmpParams;
                            VAR cmap      : Jvs.ColormapInfo) =
  BEGIN
    LOCK v DO
      sourceHost := v.sourceHost;
      quality := v.quality;
      dparams := v.dparams;
      cmap := v.cmap;
    END;
  END GetPictureParams;
</PRE> }}} 
 {{{ -- local procedures -- 

<P><PRE>PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> (v: T) =
  VAR oldt := v.startThread;
  BEGIN
    IF oldt # NIL THEN Thread.Alert(oldt); END;
    LOCK v DO v.startThread := Thread.Fork(NEW(StartClosure, v := v)); END;
  END Start;

PROCEDURE <A NAME="Stop"><procedure>Stop</procedure></A> (v: T) =
  VAR oldstart := v.startThread;
  BEGIN
    IF oldstart # NIL THEN Thread.Alert(oldstart); END;
    (* v.thread is set to NIL at the end of Apply() *)
    IF v.thread # NIL THEN
      LOCK v DO
        WHILE v.thread # NIL DO
          Thread.Alert(v.thread);
          Thread.Wait(v, v.stopEvent);
        END;
      END;
    END;
  END Stop;
</PRE> }}} 
 {{{ -- Picture.Paint callback -- 

<P><PRE>PROCEDURE <A NAME="FreeProc"><procedure>FreeProc</procedure></A> (param: REFANY) =
  BEGIN
    NARROW(param, Buffer).free();
  END FreeProc;
</PRE> }}} 
 {{{ -- paint thread -- 

<P><PRE>TYPE Closure = Thread.Closure OBJECT v: T;  OVERRIDES apply := Apply; END;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (cl: Closure): REFANY =
  VAR
    buff            : Buffer := NIL;
    v                        := cl.v;
    input                    := v.input;
    inDecomp, paused         := FALSE;
    lastFrameTime            := Time.Now();
  BEGIN
    TRY
      v.decomp.join();
      inDecomp := TRUE;
      input.join();

      TRY
        LOOP
          IF v.paused OR v.domain = Rect.Empty
               OR v.vis = TrestleOnX.VisibilityFullyObscured THEN
            v.decomp.setPaused(TRUE);
            paused := TRUE;

            LOCK v DO
              IF v.statistics # NIL THEN
                INC(v.statistics.timesBlocked);
              END;
              WHILE v.paused OR v.domain = Rect.Empty
                      OR v.vis = TrestleOnX.VisibilityFullyObscured DO
                Thread.AlertWait(v, v.pauseEvent);
              END;
            END;
            v.decomp.setPaused(FALSE);
            paused := FALSE;
          END;

          IF v.minFrameMSecs &gt; 0 THEN
            WITH waitTime = v.minFrameSecs + lastFrameTime - Time.Now() DO
              IF waitTime &gt; 0.0d0 THEN Thread.AlertPause(waitTime); END;
            END;
          END;

          IF Thread.TestAlert() THEN RAISE Thread.Alerted; END;

          buff := NARROW(input.waitForChange(), Buffer);
          lastFrameTime := Time.Now();
          IF buff.pic # NIL THEN
            LOCK v DO
              IF v.statistics # NIL THEN
                INC(v.statistics.framesStarted);
                v.statistics.cumLatency :=
                  Word.Plus(v.statistics.cumLatency,
                            Word.Minus(Tick.Now(), buff.localTime));
              END;
            END;
            IF v.synchronous THEN
              Picture.Paint(v, buff.pic, delta := v.offset);
              IF buff.ready # NIL THEN
                buff.ready.endToEnd := TRUE;
                buff.ready.apply();
              END;
              buff.free();
            ELSE
              Picture.Paint(v, buff.pic, freeProc := FreeProc,
                            freeParam := buff, delta := v.offset);
              IF buff.ready # NIL THEN
                buff.ready.endToEnd := TRUE;
                buff.ready.apply();
              END;
            END;
          END;
          buff := NIL;
        END;
      EXCEPT
      | Thread.Alerted, JVBuffer.Closed =&gt; (* skip *)
      END;

      IF buff # NIL AND v.synchronous THEN buff.free(); END;
      IF input # NIL THEN input.leave(); END;
      IF paused THEN v.decomp.setPaused(FALSE); END;
      LOCK v DO
        (* clean up vbt fields *)
        v.thread := NIL;
        v.input := NIL;
        IF inDecomp AND v.decomp # NIL THEN v.decomp.leave(); END;
      END;
    EXCEPT
    | JVConverter.Error (e) =&gt;
        VAR etext := &quot;&quot;;
        BEGIN
          IF e # NIL AND e.head # NIL THEN
            etext := RdUtils.FailureText(e);
          END;
          JVConverter.ReportError(&quot;VideoVBT.Apply &quot; &amp; etext);
        END;
    | Thread.Alerted =&gt;          (*skip *)
    END;
    LOCK v DO v.decomp := NIL; v.input := NIL; v.thread := NIL; END;
    Thread.Signal(v.stopEvent);
    RETURN NIL;
  END Apply;
</PRE> }}} 
 {{{ -- Start thread -- 

<P><PRE>TYPE
  StartClosure =
    Thread.Closure OBJECT v: T;  OVERRIDES apply := StartApply; END;

PROCEDURE <A NAME="StartApply"><procedure>StartApply</procedure></A> (cl: StartClosure): REFANY =
  VAR
    v                   := cl.v;
    decomp : JVDecomp.T;
    jvs    : Jvs.T;
    factory: Factory;
    failed              := TRUE;
  BEGIN
    TRY
      decomp :=
        JVDecompPool.GetDecomp(
          v.sourceHost, v.quality, v.dparams, v.cmap, FALSE, v.sinkBuffers,
          v.decompBuffers, delay := v.minFrameMSecs);
      IF decomp = NIL THEN
        jvs := NEW(Jvs.T).init();
        factory := NEW(Factory);
        factory.preInit(v.st, v.dparams.reqX, v.dparams.reqY);
        EVAL factory.init(jvs);
        decomp :=
          JVDecompPool.GetDecomp(
            v.sourceHost, v.quality, v.dparams, v.cmap, TRUE,
            v.sinkBuffers, v.decompBuffers, factory, jvs, v.minFrameMSecs);
      END;

      LOCK v DO
        v.decomp := decomp;
        v.input := decomp.getOutput();
        &lt;* ASSERT v.input # NIL *&gt;
        v.thread := Thread.Fork(NEW(Closure, v := v));
      END;
      failed := FALSE;
    EXCEPT
    | OSError.E (e) =&gt;
        VAR etext := &quot;&quot;;
        BEGIN
          IF e # NIL AND e.head # NIL THEN
            etext := RdUtils.FailureText(e);
          END;
          JVConverter.ReportError(&quot;VideoVBT.Start &quot; &amp; etext);
        END;
    | Picture.ScreenTypeNotSupported =&gt;
        JVConverter.ReportError(&quot;VideoVBT.Start.BadScreenType&quot;);
    | Thread.Alerted =&gt;          (* skip *)
    END;

    LOCK v DO v.startThread := NIL; END;
    IF failed THEN LOCK v DO v.decomp := NIL; v.input := NIL; END; END;

    RETURN NIL;
  END StartApply;
</PRE> }}} 
<PRE>BEGIN
  EVAL JVConverter.RegisterErrorReporter(JVConverter.toStderr);
END VideoVBT.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface BasicCtypes is in:
</A><UL>
<LI><A HREF="../../C/src/32BITS/BasicCtypes.i3#0TOP0">C/src/32BITS/BasicCtypes.i3</A>
<LI><A HREF="../../C/src/64BITS/BasicCtypes.i3#0TOP0">C/src/64BITS/BasicCtypes.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Picture is in:
</A><UL>
<LI><A HREF="../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="../../ui/src/picture/Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
