<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="VT.i3">VT</A></implements></module>;

IMPORT <A HREF="VTInterval.i3">VTInterval</A>, <A HREF="VTMarker.i3">VTMarker</A>, <A HREF="VTView.i3">VTView</A>, <A HREF="VTVirtual.i3">VTVirtual</A>, <A HREF="VTCaret.i3">VTCaret</A>, <A HREF="VTTexture.i3">VTTexture</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>,
         <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="VTDef.i3">VTDef</A>;

FROM <A HREF="VTDef.i3">VTDef</A> IMPORT Interval, Marker, T, View;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (mtext: MText.T): T RAISES {VTDef.Error} =
  VAR vt: T;
  BEGIN
    IF mtext = NIL THEN RAISE VTDef.Error (VTDef.ErrorCode.IsNil) END;
    vt := NEW (T);
    vt.mutex := NEW (MUTEX);
    vt.closed := FALSE;
    vt.mtext := mtext;
    vt.length := MText.Length (mtext);
    vt.intervals := NIL;
    VTCaret.Init (vt);
    vt.rdDirty := TRUE;
    vt.views := NIL;
    VTTexture.Init ();
    RETURN vt
  END New;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (vt: T; begin, end: CARDINAL; text: TEXT)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR oldLength: CARDINAL;
  BEGIN
    oldLength := vt.length;
    MText.Replace (vt.mtext, begin, end, text);
    Invalidate (vt, begin, end,
                MText.Length (vt.mtext) - (oldLength - (end - begin)))
  END Replace;

PROCEDURE <A NAME="ReplaceChars"><procedure>ReplaceChars</procedure></A> (         vt        : T;
                                 begin, end: CARDINAL;
                        READONLY str       : ARRAY OF CHAR)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR oldLength: CARDINAL;
  BEGIN
    oldLength := vt.length;
    MText.ReplaceChars (vt.mtext, begin, end, str);
    Invalidate (
      vt, begin, end, MText.Length (vt.mtext) - (oldLength - (end - begin)))
  END ReplaceChars;

PROCEDURE <A NAME="ReplaceFile"><procedure>ReplaceFile</procedure></A> (vt        : T;
                       begin, end: CARDINAL;
                       file      : Rd.T;
                       start     : CARDINAL          := 0;
                       numChars  : CARDINAL          := LAST (CARDINAL))
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR oldLength: CARDINAL;
  BEGIN
    oldLength := vt.length;
    MText.ReplaceFile (vt.mtext, begin, end, file, start, numChars);
    Invalidate (vt, begin, end,
                MText.Length (vt.mtext) - (oldLength - (end - begin)))
  END ReplaceFile;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (vt: T) = &lt;* LL = vt.mutex *&gt;
  VAR
    v0, v1: View;
    i0, i1: Interval;
    m0, m1: Marker;
  BEGIN
    vt.closed := TRUE;
    VTCaret.Close (vt);
    v0 := vt.views;
    WHILE v0 # NIL DO v1 := v0.next; VTView.Close (v0); v0 := v1 END;
    i0 := vt.intervals;
    WHILE i0 # NIL DO i1 := i0.next; VTInterval.Close (i0); i0 := i1 END;
    m0 := vt.markers;
    WHILE m0 # NIL DO m1 := m0.next; VTMarker.Close (m0); m0 := m1 END;
    vt.mtext := NIL;
    &lt;* ASSERT (vt.intervals = NIL) *&gt;
    &lt;* ASSERT (vt.markers = NIL) *&gt;
    vt.caret.blinker := NIL;
    (* vt.rd.instance := NIL; vt.rrd.instance := NIL; *)
    &lt;* ASSERT (vt.views = NIL) *&gt;
  END Close;

PROCEDURE <A NAME="Invalidate"><procedure>Invalidate</procedure></A> (vt: T; b, e, l: CARDINAL)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR
    interval: Interval;
    marker  : Marker;
  BEGIN
    vt.rdDirty := TRUE;
    VTVirtual.Change (vt, b, e, b + l);
    (* update caret *)
    IF e &lt;= vt.caret.index THEN
      vt.caret.index := vt.caret.index + (l - (e - b))
    ELSIF b &lt;= vt.caret.index THEN
      vt.caret.index := b + l
    END;
    (* update intervals *)
    interval := vt.intervals;
    WHILE interval # NIL DO
      IF e &lt;= interval.l THEN
        interval.l := interval.l + (l - (e - b))
      ELSIF b &lt;= interval.l THEN
        interval.l := b + l
      END;
      IF e &lt;= interval.r THEN
        interval.r := interval.r + (l - (e - b))
      ELSIF b &lt;= interval.r THEN
        interval.r := b + l
      END;
      interval := interval.next
    END;
    (* update markers *)
    marker := vt.markers;
    WHILE marker # NIL DO
      IF e &lt;= marker.index THEN
        marker.index := marker.index + (l - (e - b))
      ELSIF b &lt;= marker.index THEN
        marker.index := b + l
      END;
      marker := marker.next
    END
  END Invalidate;

BEGIN
END VT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
