<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VTBase.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VTBase.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> This module contains VTView operations that investigate the buffer's
   representation on the screen. 

<P><PRE>INTERFACE <interface><A HREF="VTBase.m3">VTBase</A></interface>;

IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="VTDef.i3">VTDef</A>;

TYPE
  View = VTDef.View;
  Pixels = VTDef.Pixels;
  I = VTDef.I;
  LineNo = VTDef.LineNo;
  VirtualStart = VTDef.VirtualStart;

PROCEDURE <A HREF="VTBase.m3#ComputeLine">ComputeLine</A> (             view  : View;
                                    avail : Pixels;
                                    from  : I;
                       VAR (* OUT*) max   : I;
                       VAR (* OUT*) turned: BOOLEAN;
                       VAR (* OUT*) width : Pixels    ): I
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE> Computes the characteristics of a screen line starting at <CODE>from</CODE>;
   returns the index after the end. (<CODE>From</CODE> is believed to be at the
   beginning of a screen line.) <CODE>Avail</CODE> is the available width in pixels.
<P>
   <CODE>Max</CODE> is set to the index after the last character examined to make the
   decision (the first was <CODE>from</CODE>). <CODE>Turned</CODE> is set to whether the end of
   the screen line is turned (if the screen line does not end in a new-line
   and is not at the end of the buffer). <CODE>Width</CODE> is set to the width in
   pixels needed to display the text. 

<P>
<P><PRE>PROCEDURE <A HREF="VTBase.m3#Up">Up</A> (             view : View;
                           avail: Pixels;
                           place: I;
                           n    : CARDINAL;
              VAR (* OUT*) start: VirtualStart)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE> Computes the beginning of the screen line <CODE>n</CODE> lines above the screen
   line that <CODE>place</CODE> is on. (<CODE>Place</CODE> is not believed to be at the beginning
   of a screen line.) <CODE>Avail</CODE> is the available width in pixels. <CODE>Min</CODE> and
   <CODE>max</CODE> are set to a half-open interval that includes a set of buffer
   positions that imply this result.
<P>
   <CODE>Turned</CODE> is set to whether the beginning of that screen line is turned
   (if the screen line is not preceded by a new-line and is not at the
   beginning of the buffer). If fewer than <CODE>n</CODE> screen lines exist, the
   beginning of the buffer is returned. The array <CODE>line</CODE> is filled in with
   the virtual line info for the lines up to and including <CODE>place</CODE>; <CODE>lines</CODE>
   &lt;= <CODE>n</CODE>. 

<P>
<P><PRE>PROCEDURE <A HREF="VTBase.m3#Down">Down</A> (view: View; from: I; n: CARDINAL): I
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE> Computes the beginning of the screen line <CODE>n</CODE> lines below the screen
   line that <CODE>from</CODE> is on. (<CODE>From</CODE> is believed to be at the beginning of a
   screen line.) If fewer than <CODE>n</CODE> screen lines exist, the end of the
   buffer is returned. 

<P><PRE>PROCEDURE <A HREF="VTBase.m3#UnsafeLocateLine">UnsafeLocateLine</A> (view: View; place: I): INTEGER RAISES {};
</PRE> Computes the screen line number in the view that <CODE>place</CODE> is on (i.e., if
   there were a caret at <CODE>place</CODE>, the screen line on which it would
   appear). (Place is not believed to be at the beginning of a screen
   line.) If <CODE>place</CODE> is above the view, -1 is returned; if <CODE>place</CODE> is below
   the view, -2 is returned. UnsafeLocateLine can be called only when the
   <CODE>virtual</CODE> structure is not dirty, hence its name. 

<P>
<P><PRE>PROCEDURE <A HREF="VTBase.m3#UnsafeLocatePoint">UnsafeLocatePoint</A> (             view : View;
                                          place: I;
                             VAR (* OUT*) p    : Point.T;
                                          off  : CARDINAL  := 1)
  RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE> Computes the position in the view that <CODE>place</CODE> appears (i.e., if there
   were a caret at <CODE>place</CODE>, the screen line on which it would appear).
   (Place is not believed to be at the beginning of a screen line.) The
   coordinate is in absolute screen coordinates, and refers to the
   northwest corner of the character at <CODE>place</CODE>. If <CODE>place</CODE> is above the
   view, p.v is set to -1 and p.h is arbitrary; if <CODE>place</CODE> is below the
   view, p.v is set to -2 and p.h is arbitrary. UnsafeLocatePoint can be
   called only when the <CODE>virtual</CODE> structure is not dirty, hence its name.
   If <CODE>off</CODE> is zero, UnsafeLocatePoint returns the right edge of the
   character instead of the left. 
   
<P><PRE>END VTBase.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
