<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VTDef.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VTDef.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Modified On Mon Sep 25 15:09:34 PDT 1989 by brooks 

<P><PRE>INTERFACE <interface>VTDef</interface>;

IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="../../mtext/src/MTextRd.i3">MTextRd</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/ScrnFont.i3">ScrnFont</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  T = REF RECORD
            mutex    : MUTEX;
            closed   : BOOLEAN;
            mtext    : MText.T;
            length   : CARDINAL;
            intervals: Interval;
            markers  : Marker;
            caret: RECORD
                     index  : I;
                     state  : OnOffState;
                     mutex  : MUTEX;
                     black  : BOOLEAN;
                     blinker: Thread.T;
                   END;
            rd, rrd: MTextRd.T := NIL;
            rdDirty: BOOLEAN;
            views  : View;
          END;

  Interval &lt;: PublicInterval;
  PublicInterval = OBJECT
              METHODS
                left  (): INTEGER;
                right (): INTEGER;
                getOptions (): IntervalOptions
              END;

  View = REF RECORD
               vt         : T;
               vbt        : VBT.T;
               vScreenFont: VScreenFont;
               rect: RECORD full, clip, text, textClip, bad: Rect.T;  END;
               vOptions   : VOptions;
               lineSpacing: Pixels;     (* leading plus character height *)
               lineWidth  : Pixels;     (* available for displaying text *)
               nLines     : INTEGER;   (* number of lines displayed *)
               virtual, newVirtual: Virtual;
               real               : Real;
               caret: RECORD
                        rect             : Rect.T;
                        lineNo           : LineNo;
                        deactivationCount: CARDINAL;
                        black            : BOOLEAN;
                      END;
               next, previous: View;
             END;

TYPE
  IntervalStylePrecedence =
    REF ARRAY [IntervalStyle.HighlightStyle .. IntervalStyle.BoxStyle],
          [IntervalStyle.HighlightStyle .. IntervalStyle.BoxStyle] OF
          BOOLEAN;

  Marker = REF RECORD
                 vt     : T;
                 index  : INTEGER;
                 options: MarkerOptions;
                 state  : OnOffState;
                 next   : Marker;
               END;

  Index = CARDINAL;
  I = INTEGER;
  (* This used to be [(FIRST (Index) - 1) ..  (LAST (Index) + 1)], but now
     that Index = CARDINAL, that won't work.  jdd suggested making this
     INTEGER and see what happens.  So far, so good. *)

  Points = REAL;
  Pixels = INTEGER;
  LineNo = INTEGER;

  IntervalStyle = {NoStyle,     (* ordinary text appearance *)
                   HighlightStyle, (* just applies style colors as
                                      specified *)
                   InverseStyle, (* applies style colors with fg/bg
                                    inverted *)
                   GrayStyle,   (* grayed-out text *)
                   UnderlineStyle, (* 2-pixel thick underline *)
                   ThinUnderlineStyle, (* 1-pixel thick underline *)
                   GrayUnderlineStyle,
                   (* 1-pixel thick gray-textured underline *)
                   BoxStyle,    (* box around the text *)
                   SlugStyle,   (* solid black - illegible *)
                   OverlapStyle}; (* stippled over *)
  OnOffState = {Off, On};
  SelectionMode = {CharSelection, WordSelection, LineSelection,
                   ParagraphSelection, AllSelection};
  TriState = {True, False, Unknown};

  Block = RECORD
            old, new: LineNo;
            length  : CARDINAL;
          END;
  BlockArray = REF ARRAY OF RECORD block: Block END;
  Blocks = RECORD
             n    : CARDINAL;
             block: BlockArray
           END;

  RealLine = RECORD
               valid        : BOOLEAN;
               from, to     : I;
               width        : Pixels;
               turned       : ARRAY [0 .. 1] OF TriState;
               allWhiteBelow: BOOLEAN;
             END;
  RealLines = REF ARRAY OF RECORD realLine: RealLine;  END;
  RealStart = RECORD
                at    : I;
                turned: BOOLEAN;
              END;
  Real = RECORD
           start                 : RealStart;
           dirty                 : BOOLEAN;
           firstDirty, firstAfter: LineNo;
           lines                 : CARDINAL;
           line                  : RealLines;
           blocks                : Blocks;
         END;

  VirtualLine = RECORD
                  valid        : BOOLEAN;
                  from, to, max: I;
                  turned       : BOOLEAN;
                  width        : Pixels;
                END;
  VirtualLines = REF ARRAY OF RECORD virtualLine: VirtualLine;  END;
  VirtualStart = RECORD
                   at, min, max: I;
                   turned      : BOOLEAN;
                 END;
  Virtual = RECORD
              start                 : VirtualStart;
              dirty, bodyDirty      : BOOLEAN;
              firstDirty, firstAfter: LineNo;
              lines                 : CARDINAL;
              line                  : VirtualLines;
            END;

  WordCode = {Special, WhiteSpace, AlphaNumeric};

  VFont = REF RECORD
                handedOut: CARDINAL;
                vFont: RECORD
                         font     : Font.T;
                         printable: SET OF CHAR;
                         whiteTabs: BOOLEAN;
                       END;
              END;

  VScreenFont = REF RECORD
                      vScreenFont: RECORD
                                     vFont      : VFont;
                                     metrics    : ScrnFont.Metrics;
                                     box        : Rect.T;
                                     width      : ARRAY CHAR OF Pixels;
                                     defined    : SET OF CHAR;
                                     paintOpaque: BOOLEAN;
                                   END;
                    END;

  Tint = PaintOp.T;
  ColorScheme = PaintOp.ColorScheme;

  VOptions = RECORD
               vFontxxx      : VFont;
               leftMarginPts : Points;  (* left margin *)
               rightMarginPts: Points;  (* right margin *)
               leftOffsetPts : Points;  (* negative indentation for text *)
               topMarginPts  : Points;  (* top margin of every region *)
               leadingPts    : Points;  (* how many pixels between lines *)
               turnMarginPts: Points;  (* margin for displaying turning
                                          indicator *)
               (* For grubby historical reasons, we keep integer
                  equivalents of these quantities. *)
               leftMargin : Pixels;
               rightMargin: Pixels;
               leftOffset : Pixels;
               topMargin  : Pixels;
               leading    : Pixels;
               turnMargin : Pixels;

               whiteBlack, whiteStroke: ColorScheme;
               wrap: BOOLEAN;   (* perform line-wrapping? *)
               eob : BOOLEAN;   (* display visible end-of-buffer? *)
               intervalStylePrecedence: IntervalStylePrecedence;
               (* if non-NIL, defines style precedence *)
             END;

  IntervalOptions = RECORD
                      style                  : IntervalStyle;
                      whiteBlack, whiteStroke: ColorScheme;
                      leading                : Tint;
                    END;

  MarkerOptions = RECORD
                    whichEnd   : WhichEnd;
                    top, bottom: BOOLEAN;
                    stroke     : Tint;
                  END;
  WhichEnd = {Left, Right};

TYPE
  ErrorCode = {IsNil, IllegalIndex, IllegalRegion, IllegalCoord,
                IllegalDividers, IllegalFont, Closed};
</PRE> <P>
   IsNil is raised if the vtext passed to a procedure is NIL.
   IllegalIndex indicates a range error (e.g., begin &gt; end).
   IllegalRegion indicates a bad region number or too many regions.
   IllegalCoord indicates a problem with coordinates, such as trying to
       create a region smaller than the minimum height.
   IllegalDividers indicates not enough dividers on a call to Rearrange.
   IllegalFont means an illegal font was used.
   Closed is raised if the vtext has been closed.


<P><PRE>EXCEPTION Error(ErrorCode);

CONST
  ErrorCodeTexts =               (* Be sure to keep these in sync! *)
  ARRAY ErrorCode OF
    TEXT {
    &quot;The vtext passed to a procedure was NIL.&quot;,
    &quot;Range error, e.g., begin &gt; end.&quot;,
    &quot;Bad region number, or too many regions.&quot;,
    &quot;Problem with coordinates, e.g., creating a region smaller than the minimum height.&quot;,
    &quot;Not enough dividers on a call to Rearrange.&quot;,
    &quot;An illegal font was used.&quot;, &quot;The vtext has been closed.&quot;};

END VTDef.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
