<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VTInterval.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VTInterval.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="VTInterval.m3">VTInterval</A></interface>;

IMPORT <A HREF="VTDef.i3">VTDef</A>, <A HREF="VText.i3">VText</A>;

TYPE
  T = VTDef.T;
  ColorScheme = VTDef.ColorScheme;
  I = VTDef.I;
  Index = VTDef.Index;
  Interval = VText.Interval;
  IntervalOptions = VTDef.IntervalOptions;
  IntervalStyle = VTDef.IntervalStyle;
  OnOffState = VTDef.OnOffState;
  Tint = VTDef.Tint;
  View = VTDef.View;

  Private = VTDef.PublicInterval OBJECT
              l, r: I;
              next: Interval := NIL
            END;

REVEAL Interval &lt;: Private;

PROCEDURE <A HREF="VTInterval.m3#New">New</A> (vt: T; iL, iR: Index; READONLY options: IntervalOptions):
  Interval;

PROCEDURE <A HREF="VTInterval.m3#ExplodeInterval">ExplodeInterval</A> (READONLY     interval      : Interval;
                           VAR (* OUT*) indexL, indexR: Index;
                           VAR (* OUT*) options       : IntervalOptions;
                           VAR (* OUT*) state         : OnOffState       );

PROCEDURE <A HREF="VTInterval.m3#MakeOptions">MakeOptions</A> (style                  : IntervalStyle;
                       whiteBlack, whiteStroke: ColorScheme;
                       leading                : Tint           ):
  IntervalOptions;

PROCEDURE <A HREF="VTInterval.m3#Switch">Switch</A> (interval: Interval; state: OnOffState) RAISES {VTDef.Error};

PROCEDURE <A HREF="VTInterval.m3#Move">Move</A> (interval: Interval; iL, iR: Index) RAISES {VTDef.Error};

PROCEDURE <A HREF="VTInterval.m3#ChangeOptions">ChangeOptions</A> (interval: Interval; READONLY options: IntervalOptions)
  RAISES {VTDef.Error};

PROCEDURE <A HREF="VTInterval.m3#Delete">Delete</A> (interval: Interval) RAISES {VTDef.Error};

PROCEDURE <A HREF="VTInterval.m3#Close">Close</A> (interval: Interval);

PROCEDURE <A HREF="VTInterval.m3#Fix">Fix</A> (vt: T);

PROCEDURE <A HREF="VTInterval.m3#CurrentOptions">CurrentOptions</A> (view: View; at: I; VAR (*OUT*) from, to: I):
  IntervalOptions;

END VTInterval.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
