<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VTInterval.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VTInterval.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>      Modified On Tue Dec 18 09:18:23 1990 by jdd 
<PRE>&lt;* PRAGMA LL *&gt;
</PRE> Management of VT intervals. 

<P><PRE>MODULE <module><implements><A HREF="VTInterval.i3">VTInterval</A></implements></module>;

IMPORT <A HREF="VTDef.i3">VTDef</A>, <A HREF="VTReal.i3">VTReal</A>;

REVEAL
  <A NAME="Interval">Interval</A> = Private BRANDED OBJECT
               vt     : T;
               options: IntervalOptions;
               state                      := OnOffState.Off
             OVERRIDES
               left       := Left;
               right      := Right;
               getOptions := GetOptions
             END;

PROCEDURE <A NAME="Left"><procedure>Left</procedure></A> (i: Interval): I =
  BEGIN
    RETURN i.l
  END Left;

PROCEDURE <A NAME="Right"><procedure>Right</procedure></A> (i: Interval): I =
  BEGIN
    RETURN i.r
  END Right;

PROCEDURE <A NAME="GetOptions"><procedure>GetOptions</procedure></A> (i: Interval): IntervalOptions =
  BEGIN
    RETURN i.options
  END GetOptions;

PROCEDURE <A NAME="ExplodeInterval"><procedure>ExplodeInterval</procedure></A> (READONLY      interval      : Interval;
                           VAR (* OUT *) indexL, indexR: Index;
                           VAR (* OUT *) options       : IntervalOptions;
                           VAR (* OUT *) state         : OnOffState       ) =
  BEGIN
    indexL := interval.l;
    indexR := interval.r;
    options := interval.options;
    state := interval.state;
  END ExplodeInterval;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (vt: T; hl, hr: Index; READONLY options: IntervalOptions):
  Interval =
  VAR
    interval := NEW (Interval, vt := vt, l := hl, r := hr, options := options);
  BEGIN
    Insert (interval);
    RETURN interval;
  END New;

PROCEDURE <A NAME="MakeOptions"><procedure>MakeOptions</procedure></A> (style                  : IntervalStyle;
                       whiteBlack, whiteStroke: ColorScheme;
                       leading                : Tint           ):
  IntervalOptions  =
  VAR options: IntervalOptions;
  BEGIN
    options.style := style;
    options.whiteBlack := whiteBlack;
    options.whiteStroke := whiteStroke;
    options.leading := leading;
    RETURN options;
  END MakeOptions;

PROCEDURE <A NAME="Switch"><procedure>Switch</procedure></A> (interval: Interval; state: OnOffState)
  RAISES {VTDef.Error} =
  VAR vt := interval.vt;
  BEGIN
    LOCK vt.mutex DO
      IF vt.closed THEN
        RAISE VTDef.Error (VTDef.ErrorCode.Closed)
      ELSE
        LockedSwitch (interval, state)
      END
    END
  END Switch;

PROCEDURE <A NAME="LockedSwitch"><procedure>LockedSwitch</procedure></A> (interval: Interval; state: OnOffState) =
  &lt;* LL = interval.vt.mutex *&gt;
  BEGIN
    IF interval.state # state THEN
      Invalidate (interval.vt, interval.l, interval.r);
      interval.state := state;
    END
  END LockedSwitch;

PROCEDURE <A NAME="Move"><procedure>Move</procedure></A> (interval: Interval; indexL, indexR: Index)
  RAISES {VTDef.Error} =
  VAR vt := interval.vt;
  VAR oldLeft, oldRight, newLeft, newRight: I;
  BEGIN
    LOCK vt.mutex DO
      IF vt.closed THEN RAISE VTDef.Error (VTDef.ErrorCode.Closed) END;
      newLeft := MIN (indexL, interval.vt.length);
      newRight := MIN (indexR, interval.vt.length);
      IF indexL &gt; interval.vt.length THEN indexL := interval.vt.length; END;
      IF indexR &gt; interval.vt.length THEN indexR := interval.vt.length; END;
      IF newLeft &gt; newRight THEN
        RAISE VTDef.Error (VTDef.ErrorCode.IllegalIndex)
      END;
      oldLeft := interval.l;
      oldRight := interval.r;
      IF newLeft = oldLeft AND newRight = oldRight THEN RETURN END;
      interval.l := newLeft;
      interval.r := newRight;
      IF interval.state = OnOffState.On
           AND interval.options.style # IntervalStyle.NoStyle THEN
        IF newLeft &gt;= oldRight OR newRight &lt;= oldLeft THEN
          Invalidate (interval.vt, oldLeft, oldRight);
          Invalidate (interval.vt, newLeft, newRight);
        ELSE
          IF newLeft &gt; oldLeft THEN
            Invalidate (interval.vt, oldLeft, newLeft);
          ELSIF newLeft &lt; oldLeft THEN
            Invalidate (interval.vt, newLeft, oldLeft);
          END;
          IF newRight &gt; oldRight THEN
            Invalidate (interval.vt, oldRight, newRight);
          ELSIF newRight &lt; oldRight THEN
            Invalidate (interval.vt, newRight, oldRight);
          END
        END
      END
    END
  END Move;

PROCEDURE <A NAME="ChangeOptions"><procedure>ChangeOptions</procedure></A> (interval: Interval; READONLY options: IntervalOptions)
  RAISES {VTDef.Error} =
  VAR vt := interval.vt;
  BEGIN
    LOCK vt.mutex DO
      IF vt.closed THEN
        RAISE VTDef.Error (VTDef.ErrorCode.Closed)
      ELSIF interval.state = OnOffState.On THEN
        Invalidate (interval.vt, interval.l, interval.r);
      END;
      interval.options := options
    END
  END ChangeOptions;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (interval: Interval) RAISES {VTDef.Error} =
  VAR vt := interval.vt;
  BEGIN
    LOCK vt.mutex DO
      IF vt.closed THEN RAISE VTDef.Error (VTDef.ErrorCode.Closed) END;
      Close (interval)
    END
  END Delete;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (interval: Interval) = &lt;* LL = interval.vt.mutex *&gt;
  BEGIN
    LockedSwitch (interval, OnOffState.Off);
    Remove (interval)
  END Close;
</PRE> internal VT operations 
 Fix bubble-sorts the intervals into order by start. 

<P><PRE>PROCEDURE <A NAME="Fix"><procedure>Fix</procedure></A> (vt: T) =
  VAR
    i, ii, iii: Interval;
    needScan  : BOOLEAN;
  BEGIN
    i := vt.intervals;
    needScan := TRUE;
    WHILE needScan DO
      needScan := FALSE;
      i := vt.intervals;
      ii := NIL;
      iii := NIL;
      WHILE i # NIL DO
        IF (ii # NIL) AND (ii.l &gt; i.l) THEN
          IF iii = NIL THEN
            vt.intervals := i;
            ii.next := i.next;
            i.next := ii;
          ELSE
            iii.next := i;
            ii.next := i.next;
            i.next := ii;
          END;
          needScan := TRUE;
          iii := i;
          i := ii.next;
        ELSE
          iii := ii;
          ii := i;
          i := i.next;
        END;
      END;
    END;
  END Fix;

PROCEDURE <A NAME="CurrentOptions"><procedure>CurrentOptions</procedure></A> (view: View; at: I; VAR (*OUT*) from, to: I):
  IntervalOptions =
  VAR
    interval: Interval;
    opt     : IntervalOptions;
  BEGIN
    opt.style := IntervalStyle.NoStyle;
    from := 0;
    to := view.vt.length;
    interval := view.vt.intervals;
    WHILE interval # NIL DO
      IF interval.state = OnOffState.On THEN
        IF (interval.l &lt;= at) THEN from := MAX (interval.l, from); END;
        IF (interval.r &lt;= at) THEN from := MAX (interval.r, from); END;
        IF (at &lt; interval.l) THEN to := MIN (interval.l, to); END;
        IF (at &lt; interval.r) THEN to := MIN (interval.r, to); END;
        IF (interval.l &lt;= at) THEN
          IF (at &lt; interval.r) THEN
            IF opt.style = IntervalStyle.NoStyle THEN
              opt := interval.options;
            ELSIF interval.options.style = IntervalStyle.NoStyle THEN
            ELSIF (opt.style = IntervalStyle.SlugStyle)
                    OR (opt.style = IntervalStyle.OverlapStyle) THEN
            ELSIF (interval.options.style = IntervalStyle.SlugStyle)
                    OR (interval.options.style = IntervalStyle.OverlapStyle) THEN
              opt := interval.options;
            ELSIF view.vOptions.intervalStylePrecedence # NIL THEN
              IF view.vOptions.intervalStylePrecedence [
                   opt.style, interval.options.style] THEN
              ELSIF view.vOptions.intervalStylePrecedence [
                      interval.options.style, opt.style] THEN
                opt := interval.options;
              ELSE
                opt.style := IntervalStyle.OverlapStyle;
              END;
            ELSE
              opt.style := IntervalStyle.OverlapStyle;
            END;
          END;
        ELSE
          RETURN opt;
        END;
      END;
      interval := interval.next;
    END;
    RETURN opt;
  END CurrentOptions;
</PRE> Internal procedures to manipulate the list of intervals. 

<P><PRE>PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (interval: Interval) =
  BEGIN
    interval.next := interval.vt.intervals;
    interval.vt.intervals := interval
  END Insert;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (interval: Interval) =
  VAR i: Interval;
  BEGIN
    i := interval.vt.intervals;
    IF i = interval THEN
      interval.vt.intervals := i.next;
    ELSE
      WHILE i.next # interval DO i := i.next; END;
      i.next := i.next.next;
    END;
    interval.next := NIL
  END Remove;
</PRE>**********************************************************************
		              (Utility) 				
**********************************************************************

<P><PRE>PROCEDURE <A NAME="Invalidate"><procedure>Invalidate</procedure></A> (vt: T; b, e: I) =
  BEGIN
    VTReal.Change (vt, b, e, e);
  END Invalidate;

BEGIN
END VTInterval.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
