<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VText.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VText.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> A Visible Text or VText combines an MText and a rectangular screen
   area for displaying it. VText provides a mechanism to maintain the
   correspondence between the MText and the screen, as is needed in
   implementing a display-oriented text editor.
<P>
   A VText is not an opaque REF. This allows the VText client to read
   certain parts of it. However, the client must call VText procedures
   to change a VText's state; it must not modify the VText
   representation directly.
<P>
   The VText client can call VText to divide the rectangular screen area
   into several regions, each independently positioned to view the same
   or different portions of the underlying MText. Regions are dynamic;
   they can be created and destroyed at will, and the amount of screen
   devoted to each region may be changed. The size of the entire VText
   screen area may also be changed.
<P>
   The display will appear as follows: text will be displayed in
   horizontal lines in the specified font. Each line of text is preceded
   by leading pixel rows of blank space. Line turning is performed as
   described in the Ivy spec. As many lines are displayed as possible;
   if the end of the text is reached, or less than a line's height of
   space remains at the bottom of the vbt, or the maximum number of
   lines are being displayed, then the remaining space at the bottom of
   the window is blank. The first character of the text is never
   displayed below the first line; if the text is nonempty, at least one
   character of it is always displayed (the last character is never
   <CODE>displayed above the first line</CODE>).
<P>
   The state of a VText includes a Caret (an Index and an on/off state
   bit), zero or more Intervals (a pair of Indexes, an on/off state bit,
   and a style). and zero or more Markers (a Index, an on/off state bit,
   and a style). The Caret is designed to show a text editor's type-in
   point; Intervals are designed to provide feedback for text selections
   and items in forms. If the Caret is on, a blinking Caret appears at
   the position of the Caret's Index. If an Interval is on, all
   characters between the two indexes are displayed with the Interval's
   style. If a Marker is on, that character position displayed in the
   Marker's style.
<P>
   Finally, a VText procedure maps from a screen location to the
   position in the MText of the character displayed there. This is
   designed to support mouse input for making text selections.
<P>
   (Unlike earlier versions of VText, all coordinates are screen
   coordinates.)
<P>
   Screen updating is decoupled from changes to the VText. The only
   VText operations that change the screen are Update and
   ConcurrentUpdate (which completely update the display), and
   SplitRegion, MergeRegion, and Move (which may draw some portion of
   the display if called with scroll = TRUE). A blinking caret also
   updates concurrently. However, all operations that return information
   act as though the screen were constantly kept up-to-date.
<P>
   The ConcurrentUpdate operation may modify the screen asynchronously.
   To wait until an operation has finished, use Quiesce. While an
   asynchronous updating operation is in progress, it is not safe to use
   the VText or the MText.
<P>
   VTexts are not necessarily monitored. Higher-level synchronization
   must be used to avoid consistency problems if several threads must
   access the same VText, or the MText on which it is based. 

<P><PRE>INTERFACE <interface><A HREF="VText.m3">VText</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../mtext/src/MText.i3">MText</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VTDef.i3">VTDef</A>, <A HREF="VTextDef.i3">VTextDef</A>;

TYPE
  T = VTextDef.T;
  ColorScheme = VTDef.ColorScheme;
  ErrorCode = VTDef.ErrorCode;
  Index = VTDef.Index;
  Interval = VTDef.Interval;
  IntervalOptions = VTDef.IntervalOptions;
  IntervalStyle = VTDef.IntervalStyle;
  IntervalStylePrecedence = VTDef.IntervalStylePrecedence;
  Marker = VTDef.Marker;
  MarkerOptions = VTDef.MarkerOptions;
  OnOffState = VTDef.OnOffState;
  Pixels = VTDef.Pixels;         (* INTEGER *)
  Points = VTDef.Points;         (* REAL *)
  Region = VTextDef.Region;
  SelectionMode = VTDef.SelectionMode;
  Tint = VTDef.Tint;
  VFont = VTDef.VFont;
  VOptions = VTDef.VOptions;
  WhichEnd = VTDef.WhichEnd;

EXCEPTION
  Error (ErrorCode);
</PRE>**********************************************************************
				 Creation				
**********************************************************************

<P>
<P><PRE>PROCEDURE <A HREF="VText.m3#New">New</A> (         mtext   : MText.T;
                        vbt     : VBT.T;
               READONLY rect    : Rect.T;
               READONLY vOptions: VOptions ): T
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Creates a new VText, with mtext as its initial contents, to be displayed
   in the VBT vbt in the rectangle rect. The caller passes control of this
   rectangle to the VText package, and must not paint into it until the
   VText is Closed. The VText returned by New has regionMax = 0, caretState
   = Off, an empty set of Intervals, and an empty set of Markers. New does
   not paint the display. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeVText">ExplodeVText</A> (READONLY     vtext   : T;
                        VAR (* OUT*) mtext   : MText.T;
                        VAR (* OUT*) vbt     : VBT.T;
                        VAR (* OUT*) rect    : Rect.T;
                        VAR (* OUT*) vOptions: VOptions ) RAISES {};
</PRE><BLOCKQUOTE><EM> Given a VText, return its components </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MakeVFont">MakeVFont</A> (         font     : Font.T;
                     READONLY printable: SET OF CHAR;
                              whiteTabs: BOOLEAN      ): VFont
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Creates a VFont, which is a massaged version of a Font.T. If a character
   exists in the font and is in <CODE>printable</CODE> and is not a tab or new-line,
   it will be displayed from the font. If '\t' is not in printable, tabs
   will display as \011. If '\t' is in printable, then tabs will display as
   white-space to the next tab-stop (multiple of 8 space-widths) if
   whiteTabs is true, or as a special glyph of that width if whiteTabs is
   false. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeVFont">ExplodeVFont</A> (READONLY     vFont    : VFont;
                        VAR (* OUT*) font     : Font.T;
                        VAR (* OUT*) printable: SET OF CHAR;
                        VAR (* OUT*) whiteTabs: BOOLEAN      ) RAISES {};
</PRE><BLOCKQUOTE><EM> Given a VFont, returns its components </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MakeVOptions">MakeVOptions</A> (vFont: VFont;
                        leftMargin, rightMargin, turnMargin, topMargin,
                          leading: Points;
                        whiteBlack, whiteStroke: ColorScheme;
                        leftOffset             : Points;
                        wrap: BOOLEAN;  (* do line-wrapping *)
                        eob: BOOLEAN (* display a visible end-of-buffer *);
                        intervalStylePrecedence: IntervalStylePrecedence := NIL):
  VOptions RAISES {};
</PRE><BLOCKQUOTE><EM> Creates a VOptions, which encapsulates some VText options </EM></BLOCKQUOTE><PRE>
</PRE> If intervalStylePrecedence is non-NIL and intervalStylePrecedence[i,j]
   is TRUE, then an overlap of style i and style j is painted as i;
   otherwise, it is painted as OverlapStyle. Regardless, NoStyle has lower
   precedence than any style, and SlugStyle and OverlapStyle have higher
   precedence. Margin, leading and offset values given in points.

<P>
<P><PRE>PROCEDURE <A HREF="VText.m3#ExplodeVOptions">ExplodeVOptions</A> (READONLY     vOptions: VOptions;
                           VAR (* OUT*) vFont   : VFont;
                           VAR (* OUT*) leftMargin, rightMargin, turnMargin,
                                        topMargin, leading: Points;
                           VAR (* OUT*) whiteBlack, whiteStroke: ColorScheme;
                           VAR (* OUT*) leftOffset: Points;
                           VAR (* OUT*) wrap: BOOLEAN;
                           VAR (* OUT*) eob: BOOLEAN;
                           VAR (* OUT*) intervalStylePrecedence:
                                            IntervalStylePrecedence)
  RAISES {};
</PRE><BLOCKQUOTE><EM> Given a VOptions, return its components </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ChangeVOptions">ChangeVOptions</A> (vtext: T; READONLY vOptions: VOptions)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Changes the VOptions for a VText </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Close">Close</A> (vtext: T) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Destroy a VText. This vtext will not paint in its vbt any more. The
   display of the text is not erased. </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
				 Regions				
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#SplitRegion">SplitRegion</A> (vtext : T;
                       r     : Region;
                       v     : Pixels;
                       scroll: BOOLEAN  := TRUE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Splits region r to create two Regions. Other Regions are unaffected,
   except that region numbers are reassigned to preserve the property that
   they increase from the top of the screen towards the bottom. The Region
   being split will be divided by a horizontal black line, one pixel high,
   v pixels below top of the existing Region. If scroll is TRUE, screen
   bits may be moved to reduce the cost of later Updates.
<P>
   SplitRegion raises Error if a new Region cannot be created (because
   vtext.regionMax = LAST(Region)). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MergeRegion">MergeRegion</A> (vtext: T; i, j: Region; scroll: BOOLEAN := TRUE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Destroys Region i and assigns its screen area to Region j, which must be
   adjacent to i (j = i+1 or j = i-1). Other Regions are unaffected, except
   that region numbers are reassigned to preserve the property that they
   increase from the top of the screen towards the bottom. The top line of
   region j remains the same.
<P>
   If scroll is TRUE, screen bits may be moved to reduce the cost of later
   Updates.
<P>
   MergeRegion raises Error if i and j are not adjacent. </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
 Moving 
**********************************************************************

<P>
<P><PRE>PROCEDURE <A HREF="VText.m3#Move">Move</A> (         vtext             : T;
                READONLY newRect, savedRect: Rect.T;
                READONLY dividers          : ARRAY OF Pixels;
                         scroll            : BOOLEAN          := TRUE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Moves the display rectangle or the region dividers within it, or both.
   The dividers array tells the new v coordinate (absolute) of the divider
   below each region except the last. If scroll is TRUE, screen bits may be
   moved to reduce the cost of later Updates. Move raises Error if
   NUMBER(dividers) &lt; vtext^.regionMax. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Rescreen">Rescreen</A> (vtext: T; READONLY cd: VBT.RescreenRec) RAISES {};
</PRE><BLOCKQUOTE><EM> Passes a Rescreen event to a VText.  VBT.mu must be locked, but not
   exclusively for this activation.  </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
				 Drawing				
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#Update">Update</A> (vtext: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Paints the display to make it consistent with the state of vtext </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ConcurrentUpdate">ConcurrentUpdate</A> (vtext: T)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Like Update, but may return before finished </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Quiesce">Quiesce</A> (vtext: T) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Returns only after any outstanding ConcurrentUpdate has completed </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Bad">Bad</A> (vtext: T; READONLY bad: Rect.T) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Specifies that a given rectangle is bad, and should be completely
   redrawn at the next Update </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
			        Editing   				
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#Replace">Replace</A> (vtext: T; begin, end: Index; newText: TEXT)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Replaces the text between <CODE>begin</CODE> and <CODE>end</CODE> with <CODE>newText</CODE>.  If <CODE>begin</CODE> and
   <CODE>end</CODE> are at the same place, this is a pure insertion; if <CODE>newText</CODE> is
   empty, this is a pure deletion. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ReplaceChars">ReplaceChars</A> (         vtext     : T;
                                 begin, end: Index;
                        READONLY str       : ARRAY OF CHAR)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> <CODE> = Replace (vtext, begin, end, Text.FromChars (str)) </CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ReplaceFile">ReplaceFile</A> (vtext     : T;
                       begin, end: Index;
                       file      : Rd.T;
                       start     : Index   := 0;
                       numChars  : Index   := LAST(Index))
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Inserts a file into the text at h. The whole file might not be read in
   at once; some reading may be delayed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Invalidate">Invalidate</A> (vtext: T; begin, oldEnd, newEnd: Index)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> An excessively low-level interface; tells VText that the underlying
   MText has has the interval [begin,oldEnd) replaced by [begin,newEnd). </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
 The Caret 
**********************************************************************

<P>
<P><PRE>PROCEDURE <A HREF="VText.m3#SwitchCaret">SwitchCaret</A> (vtext: T; state: OnOffState)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Sets vtext's caretState := state </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MoveCaret">MoveCaret</A> (vtext: T; place: Index)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Moves caret to place </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#CaretIndex">CaretIndex</A> (vtext: T): Index RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Returns the caret's index </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
 Intervals 
**********************************************************************

<P> Clients should beware of creating a needlessly large number of Intervals
   - they may make redisplaying slower. If two Intervals with state = On
   and different styles overlap, the resulting highlight will be displayed
   in OverlapStyle. The NoHighlight and OverlapStyle styles should not be
   used by client programs. 

<P>
<P><PRE>PROCEDURE <A HREF="VText.m3#CreateInterval">CreateInterval</A> (         vtext         : T;
                                   indexL, indexR: Index;
                          READONLY options       : IntervalOptions):
  Interval RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Creates an Interval with indexL = begin, indexR = end, style = style,
   and state = Off </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeInterval">ExplodeInterval</A> (READONLY     interval      : Interval;
                           VAR (* OUT*) indexL, indexR: Index;
                           VAR (* OUT*) options: IntervalOptions;
                           VAR (* OUT*) state: OnOffState) RAISES {};
</PRE><BLOCKQUOTE><EM> Explodes an Interval </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MakeIntervalOptions">MakeIntervalOptions</A> (style                  : IntervalStyle;
                               whiteBlack, whiteStroke: ColorScheme;
                               leading                : Tint           ):
  IntervalOptions RAISES {};
</PRE><BLOCKQUOTE><EM> Makes a IntervalOptions </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeIntervalOptions">ExplodeIntervalOptions</A> (READONLY intervalOptions: IntervalOptions;
                                  VAR (* OUT*) style: IntervalStyle;
                                  VAR (* OUT*) whiteBlack, whiteStroke:
                                                   ColorScheme;
                                  VAR (* OUT*) leading: Tint) RAISES {};
</PRE><BLOCKQUOTE><EM> Explodes a IntervalOptions </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#SwitchInterval">SwitchInterval</A> (interval: Interval; state: OnOffState)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Sets interval's state := state </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MoveInterval">MoveInterval</A> (interval: Interval; indexL, indexR: Index)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Moves the interval </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ChangeIntervalOptions">ChangeIntervalOptions</A> (         interval: Interval;
                                 READONLY options : IntervalOptions)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Re-sets interval's options </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#DeleteInterval">DeleteInterval</A> (interval: Interval) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Sets interval's state = Off and then deletes interval from the set of
   intervals associated with the VText </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
			     Markers					
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#CreateMarker">CreateMarker</A> (vtext: T; at: Index; options: MarkerOptions):
  Marker RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Creates an Marker at the character position with state = Off </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeMarker">ExplodeMarker</A> (READONLY      marker: Marker;
                         VAR (* OUT *) at    : Index;
                         VAR (* OUT *) options: MarkerOptions;
                         VAR (* OUT*) state: OnOffState) RAISES {};
</PRE><BLOCKQUOTE><EM> Explodes a Marker </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MakeMarkerOptions">MakeMarkerOptions</A> (whichEnd   : WhichEnd;
                             top, bottom: BOOLEAN;
                             stroke     : Tint      ): MarkerOptions
  RAISES {};
</PRE><BLOCKQUOTE><EM> Makes a MarkerOptions </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ExplodeMarkerOptions">ExplodeMarkerOptions</A> (READONLY     markerOptions: MarkerOptions;
                                VAR (* OUT*) whichEnd     : WhichEnd;
                                VAR (* OUT*) top, bottom  : BOOLEAN;
                                VAR (* OUT*) stroke       : Tint           )
  RAISES {};
</PRE><BLOCKQUOTE><EM> Explodes a MarkerOptions </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#SwitchMarker">SwitchMarker</A> (marker: Marker; state: OnOffState)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Sets marker's state := state </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#ChangeMarkerOptions">ChangeMarkerOptions</A> (marker: Marker; options: MarkerOptions)
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Re-sets marker's options </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#MoveMarker">MoveMarker</A> (marker: Marker; place: Index) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Moves the marker to the character position </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#DeleteMarker">DeleteMarker</A> (marker: Marker) RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Sets marker's state = Off and then deletes marker from the set of
   markers associated with the VText </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
		                Scrolling				
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#Scroll">Scroll</A> (vtext: T; r: Region; displacement: INTEGER)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Scrolls the display within region r. The displacement parameter encodes
   both the direction and distance to scroll. If displacement &gt; 0 the
   region scrolls displacement lines toward-end-of-file; if displacement &lt;
   0 the region scrolls -displacement lines toward-start-of-file; if
   displacement = 0 nothing happens. This procedure enforces the
   constraints on text display as described under New. After calling
   Scroll, the client can call StartIndex to see precisely what
   happened. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#SetStart">SetStart</A> (vtext  : T;
                    r      : Region;
                    place  : Index;
                    upLines: CARDINAL := 0;
                    force  : BOOLEAN  := FALSE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Scrolls the display within region r. The place parameter indicates a
   character position that should be displayed in the line upLines from the
   top of the display, if possible, after scrolling. If place does not
   correspond to the start of a line, according to the line-breaking
   algorithm, then place will not be displayed at the start of a line. If
   force is TRUE AND upLines is zero, display is constrained to occur at
   the given place; otherwise, this procedure enforces the constraints on
   text display as described under New; after calling SetStart, the client
   can call StartIndex to see precisely what happened. </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
 Line-Breaking 
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#LinesBetween">LinesBetween</A> (vtext     : T;
                        begin, end: Index;
                        max       : CARDINAL;
                        avail     : Pixels      := UseCurrentWidth; ):
  INTEGER RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE> Returns the number of lines that would appear between the two indexes if
   they were both visible on the screen. <CODE>Avail</CODE> is the available screen
   width; if avail=UseCurrentWidth (below), the current screen width is
   used. Returns 0 if they would be on the same line, 1 if they would be on
   adjacent lines, and <CODE>max</CODE> if they would be more than <CODE>max</CODE> lines apart.
   Returns -1 if the second would be before the first. 

<P><PRE>CONST UseCurrentWidth = -1;

PROCEDURE <A HREF="VText.m3#ComputeLine">ComputeLine</A> (              vtext : T;
                                     from  : Index;
                       VAR (* OUT *) max   : Index;
                       VAR (* OUT *) turned: BOOLEAN;
                       VAR (* OUT *) width : Pixels    ): Index
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Computes the characteristics of a screen line starting at <CODE>from</CODE>;
   returns the index after the end. (<CODE>From</CODE> is trusted to be at the
   beginning of a screen line.) ComputeLine pretends that an end-of-file
   character exists following the characters in the mtext, so the input and
   the output index may exceed the length of the mtext by 1. <CODE>Max</CODE> is set
   to the index after the last character examined to make the decision (the
   first was <CODE>from</CODE>). <CODE>Turned</CODE> is set to whether the end of the screen line
   is turned (if the screen line does not end in a new-line and is not at
   the end of the buffer). <CODE>Width</CODE> is set to the width in pixels needed to
   display the text. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#UpLines">UpLines</A> (vtext: T; place: Index; n: CARDINAL; r: Region := 0):
  Index
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Find the beginning of the nth line above place. If n=0, find the
   beginning of the line containing place. </EM></BLOCKQUOTE><PRE>
</PRE>**********************************************************************
 Locations 
**********************************************************************

<P><PRE>PROCEDURE <A HREF="VText.m3#StartIndex">StartIndex</A> (vtext: T; r: Region): Index RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Returns the start of the region, as an index </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#LineIndex">LineIndex</A> (vtext: T; r: Region; n: CARDINAL): Index
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Returns the index of the position displayed at the beginning of line n.
   N &gt;= 0. If n &gt;= the number of lines in the region, the index of the
   first character following the region is returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#CharsInRegion">CharsInRegion</A> (vtext: T; r: Region): CARDINAL
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};

PROCEDURE <A HREF="VText.m3#Locate">Locate</A> (              vtext: T;
                                r    : Region;
                                place: Index;
                  VAR (* OUT *) h, v : INTEGER )
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Sets h and v to the position specified by place, which will be on a
   baseline. If place is not visible, v will be set to a negative
   number. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#InRegion">InRegion</A> (vtext: T; r: Region; place: Index): BOOLEAN
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Returns TRUE iff the position specified by place is visible in the
   region. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#WhichLine">WhichLine</A> (vtext: T; r: Region; v: Pixels): CARDINAL
  RAISES {VTDef.Error};
</PRE><BLOCKQUOTE><EM> Returns the line number of the line in region r which contains v. V is
   relative to the top of region r. It does not matter whether there is
   actually any text at that line; the result of WhichLine depends only on
   v, the height of r, and the font being used by vtext. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#Pounce">Pounce</A> (              vtext                 : T;
                                r                     : Region;
                                p                     : Point.T;
                                mode                  : SelectionMode;
                  VAR (* OUT *) indexL, indexM, indexR: Index;
                  VAR (* OUT *) cage                  : Rect.T         ):
  WhichEnd
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Maps a screen location to the run of characters <CODE>pointed to</CODE> by (h, v).
   Pounce sets indexL and indexR to the left and right character
   boundaries, in units of mode, of the smallest run of characters
   bracketing the given location. The <CODE>unit</CODE> of each SelectionMode is
   described in the Ivy spec. The result of Pounce indicates which end is
   <CODE>closer</CODE> to the location. The distance metric is: if both are on the
   same line, h-distance in pixels, with ties returning Left; if both are
   on two different lines, v-distance in lines, with ties returning Left.
   <CODE>indexM</CODE> is set to a pleasant insertion point near to that end. A cage
   is returned, but in the screen co-ordinate system. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#PounceLocate">PounceLocate</A> (              vtext         : T;
                                      r             : Region;
                                      p             : Point.T;
                        VAR (* OUT *) indexL, indexR: Index;
                        VAR (* OUT *) lineNumber    : CARDINAL;
                        VAR (* OUT *) c             : CHAR      )
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Performs the Locate part of Pounce. The input point <CODE>p</CODE> is in screen
   coordinates. The out indexes <CODE>indexL</CODE> and <CODE>indexR</CODE> will be at most one
   character apart; they define the position pointed to. The output
   <CODE>lineNumber</CODE> is the screen line number pointed to in the view. The
   output <CODE>c</CODE> is the character pointed to, if indexL &lt; indexR. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#PounceExtend">PounceExtend</A> (                vtext         : T;
                                        r             : Region;
                        VAR (* INOUT *) indexL, indexR: Index;
                                        lineNumber    : CARDINAL;
                                        c             : CHAR;
                                        mode          : SelectionMode)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Performs the Extend part of Pounce. The input values <CODE>indexL</CODE>, <CODE>indexR</CODE>,
   <CODE>lineNumber</CODE>, and <CODE>c</CODE> are as returned by PounceLocate. The output values
   <CODE>indexL</CODE> and <CODE>indexR</CODE> are the new bounds for the selection as dictated
   by <CODE>mode</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VText.m3#PounceEncage">PounceEncage</A> (             vtext : T;
                                     r     : Region;
                                     p     : Point.T;
                                     indexL: Index;
                        VAR (* OUT*) indexM: Index;
                                     indexR: Index;
                        VAR (* OUT*) cage  : Rect.T   ): WhichEnd
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Performs the Encage part of Pounce. The input point <CODE>p</CODE> is the input to
   PounceLocate. The inputs <CODE>indexL</CODE> and <CODE>indexR</CODE> are the outputs of
   PounceLocate or PounceExtend. The output <CODE>indexM</CODE> is a reasonable
   insertion point for the selection; the output <CODE>cage</CODE> is the cage of
   values <CODE>p</CODE> for which the Pounce functions will return the same
   values. </EM></BLOCKQUOTE><PRE>

END VText.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
