<HTML>
<HEAD>
<TITLE>SRC Modula-3: vtext/src/VTextRegion.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>vtext/src/VTextRegion.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> This file includes the VText operations that involve Regions. These will
   change when VText supports Regions using Trestle subwindows. 

<P><PRE>INTERFACE <interface><A HREF="VTextRegion.m3">VTextRegion</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="VTDef.i3">VTDef</A>, <A HREF="VTextDef.i3">VTextDef</A>;

TYPE
  T = VTextDef.T; (* A vtext *)
  Pixels = VTDef.Pixels; (* A screen coordinate *)
  ErrorCode = VTDef.ErrorCode;
  I = VTDef.I;
  Region = VTextDef.Region;

EXCEPTION
  Error (ErrorCode)(*! = VTDef.Error !*);

PROCEDURE <A HREF="VTextRegion.m3#SplitRegion">SplitRegion</A> (vtext : T;
                       r     : Region;
                       v     : Pixels;
                       scroll: BOOLEAN  := TRUE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};

PROCEDURE <A HREF="VTextRegion.m3#MergeRegion">MergeRegion</A> (vtext: T; i, j: Region; scroll: BOOLEAN := TRUE)
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};

PROCEDURE <A HREF="VTextRegion.m3#Move">Move</A> (         vtext             : T;
                READONLY newRect, savedRect: Rect.T;
                READONLY dividers          : ARRAY OF Pixels;
                         scroll            : BOOLEAN         )
  RAISES {VTDef.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted};

PROCEDURE <A HREF="VTextRegion.m3#SetupRegion">SetupRegion</A>
  (vtext: T; r: Region; north: Pixels; height: CARDINAL; startIndex: I)
   RAISES {Rd.EndOfFile, Rd.Failure, Thread.Alerted};

PROCEDURE <A HREF="VTextRegion.m3#Bad">Bad</A> (vtext: T; READONLY where: Rect.T) RAISES {};

PROCEDURE <A HREF="VTextRegion.m3#UpdateDividers">UpdateDividers</A> (vtext: T) RAISES {};

END VTextRegion.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
