<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinBase.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinBase.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P> I added the constant STARTF_USESTDHANDLES and the hStdInput,
   hStdOutput, and hStdError fields to _STARTUPINFOA and _STARTUPINFOW
   record types. PMcJ 7/1/93 

<P><PRE>INTERFACE <interface>WinBase</interface>;
</PRE> Corresponds to build version 0001 of <CODE>winbase.h</CODE>.
   See that file for details.
<P>
   This module defines the 32-Bit Windows Base APIs.


<P><PRE>IMPORT <A HREF="WinNT.i3">WinNT</A>;

FROM <A HREF="../../word/src/Word.i3">Word</A> IMPORT Or, Shift;
FROM <A HREF="WinDef.i3">WinDef</A> IMPORT ULONG, DWORD, LPVOID, BOOL, WORD, BYTE, LPLONG, LONG,
                   HGLOBAL, HINSTANCE, UINT, FARPROC, HLOCAL, PDWORD,
                   LPDWORD, USHORT, LPHANDLE, HRSRC, ATOM, PLONG, LPWORD,
                   HFILE, LPBYTE, MAX_PATH, LPBOOL, HMODULE, UCHAR, PUCHAR;
FROM <A HREF="WinNT.i3">WinNT</A> IMPORT WCHAR, LPSTR, LPCSTR, LPWSTR, LPCWSTR, LPTSTR, LPCTSTR,
                  PSID, PACL, PVOID, PLUID, LARGE_INTEGER, HANDLE, PHANDLE;
FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char, int, void_star;
</PRE><P>
 * Compatability macros
 

<P><PRE>CONST
  INVALID_HANDLE_VALUE (*???: HANDLE*) = -1;
  FILE_BEGIN                           = 0;
  FILE_CURRENT                         = 1;
  FILE_END                             = 2;

  WAIT_OBJECT_0 = ((WinNT.STATUS_WAIT_0) + 0);

  WAIT_ABANDONED   = ((WinNT.STATUS_ABANDONED_WAIT_0) + 0);
  WAIT_ABANDONED_0 = ((WinNT.STATUS_ABANDONED_WAIT_0) + 0);

  WAIT_TIMEOUT                    = WinNT.STATUS_TIMEOUT;
  WAIT_IO_COMPLETION              = WinNT.STATUS_USER_APC;
  STILL_ACTIVE                    = WinNT.STATUS_PENDING;
  EXCEPTION_ACCESS_VIOLATION      = WinNT.STATUS_ACCESS_VIOLATION;
  EXCEPTION_DATATYPE_MISALIGNMENT = WinNT.STATUS_DATATYPE_MISALIGNMENT;
  EXCEPTION_BREAKPOINT            = WinNT.STATUS_BREAKPOINT;
  EXCEPTION_SINGLE_STEP           = WinNT.STATUS_SINGLE_STEP;
  EXCEPTION_ARRAY_BOUNDS_EXCEEDED = WinNT.STATUS_ARRAY_BOUNDS_EXCEEDED;
  EXCEPTION_FLT_DENORMAL_OPERAND  = WinNT.STATUS_FLOAT_DENORMAL_OPERAND;
  EXCEPTION_FLT_DIVIDE_BY_ZERO    = WinNT.STATUS_FLOAT_DIVIDE_BY_ZERO;
  EXCEPTION_FLT_INEXACT_RESULT    = WinNT.STATUS_FLOAT_INEXACT_RESULT;
  EXCEPTION_FLT_INVALID_OPERATION = WinNT.STATUS_FLOAT_INVALID_OPERATION;
  EXCEPTION_FLT_OVERFLOW          = WinNT.STATUS_FLOAT_OVERFLOW;
  EXCEPTION_FLT_STACK_CHECK       = WinNT.STATUS_FLOAT_STACK_CHECK;
  EXCEPTION_FLT_UNDERFLOW         = WinNT.STATUS_FLOAT_UNDERFLOW;
  EXCEPTION_INT_DIVIDE_BY_ZERO    = WinNT.STATUS_INTEGER_DIVIDE_BY_ZERO;
  EXCEPTION_INT_OVERFLOW          = WinNT.STATUS_INTEGER_OVERFLOW;
  EXCEPTION_PRIV_INSTRUCTION      = WinNT.STATUS_PRIVILEGED_INSTRUCTION;
  CONTROL_C_EXIT                  = WinNT.STATUS_CONTROL_C_EXIT;
</PRE> File creation flags must start at the high end since they 
 are combined with the attributes 

<P><PRE>CONST
  FILE_FLAG_WRITE_THROUGH    = 16_80000000;
  FILE_FLAG_OVERLAPPED       = 16_40000000;
  FILE_FLAG_NO_BUFFERING     = 16_20000000;
  FILE_FLAG_RANDOM_ACCESS    = 16_10000000;
  FILE_FLAG_SEQUENTIAL_SCAN  = 16_08000000;
  FILE_FLAG_DELETE_ON_CLOSE  = 16_04000000;
  FILE_FLAG_BACKUP_SEMANTICS = 16_02000000;
  FILE_FLAG_POSIX_SEMANTICS  = 16_01000000;

  CREATE_NEW        = 1;
  CREATE_ALWAYS     = 2;
  OPEN_EXISTING     = 3;
  OPEN_ALWAYS       = 4;
  TRUNCATE_EXISTING = 5;
</PRE> Define the NamedPipe definitions 

<P>
<P> Define the dwOpenMode values for CreateNamedPipe 

<P><PRE>CONST
  PIPE_ACCESS_INBOUND  = 16_00000001;
  PIPE_ACCESS_OUTBOUND = 16_00000002;
  PIPE_ACCESS_DUPLEX   = 16_00000003;
</PRE> Define the Named Pipe End flags for GetNamedPipeInfo 

<P><PRE>CONST
  PIPE_CLIENT_END = 16_00000000;
  PIPE_SERVER_END = 16_00000001;
</PRE> Define the dwPipeMode values for CreateNamedPipe 

<P><PRE>CONST
  PIPE_WAIT             = 16_00000000;
  PIPE_NOWAIT           = 16_00000001;
  PIPE_READMODE_BYTE    = 16_00000000;
  PIPE_READMODE_MESSAGE = 16_00000002;
  PIPE_TYPE_BYTE        = 16_00000000;
  PIPE_TYPE_MESSAGE     = 16_00000004;
</PRE> Define the well known values for CreateNamedPipe nMaxInstances 

<P><PRE>CONST PIPE_UNLIMITED_INSTANCES = 255;
</PRE> Define the Security Quality of Service bits to be passed 
 into CreateFile 

<P><PRE>CONST
  SECURITY_ANONYMOUS      = Shift(WinNT.SecurityAnonymous, 16);
  SECURITY_IDENTIFICATION = Shift(WinNT.SecurityIdentification, 16);
  SECURITY_IMPERSONATION  = Shift(WinNT.SecurityImpersonation, 16);
  SECURITY_DELEGATION     = Shift(WinNT.SecurityDelegation, 16);

  SECURITY_CONTEXT_TRACKING = 16_00040000;
  SECURITY_EFFECTIVE_ONLY   = 16_00080000;

  SECURITY_SQOS_PRESENT     = 16_00100000;
  SECURITY_VALID_SQOS_FLAGS = 16_001F0000;
</PRE> Special values for mailslot information. 

<P> Special value for NextMessageSize to indicate that there is no next 
 message. 

<P><PRE>CONST MAILSLOT_NO_MESSAGE: ULONG = -1;
</PRE> Special value for read timeout to indicate that mailslot reads should 
 never timeout. 

<P><PRE>CONST MAILSLOT_WAIT_FOREVER: ULONG = -1;
</PRE> File structures 

<P><PRE>TYPE
  LPOVERLAPPED = UNTRACED REF OVERLAPPED;
  OVERLAPPED = RECORD
    Internal    : DWORD;
    InternalHigh: DWORD;
    Offset      : DWORD;
    OffsetHigh  : DWORD;
    hEvent      : HANDLE;
  END;

  PSECURITY_ATTRIBUTES = UNTRACED REF SECURITY_ATTRIBUTES;
  LPSECURITY_ATTRIBUTES = UNTRACED REF SECURITY_ATTRIBUTES;
  SECURITY_ATTRIBUTES = RECORD
    nLength             : DWORD;
    lpSecurityDescriptor: LPVOID;
    bInheritHandle      : BOOL;
  END;

  PPROCESS_INFORMATION = UNTRACED REF PROCESS_INFORMATION;
  LPPROCESS_INFORMATION = UNTRACED REF PROCESS_INFORMATION;
  PROCESS_INFORMATION = RECORD
    hProcess   : HANDLE;
    hThread    : HANDLE;
    dwProcessId: DWORD;
    dwThreadId : DWORD;
  END;
</PRE> File System time stamps are represented with the following structure: 

<P><PRE>TYPE
  PFILETIME = UNTRACED REF FILETIME;
  LPFILETIME = UNTRACED REF FILETIME;
  FILETIME = RECORD
    dwLowDateTime : DWORD;
    dwHighDateTime: DWORD;
  END;
</PRE> System time is represented with the following structure: 

<P><PRE>TYPE
  PSYSTEMTIME = UNTRACED REF SYSTEMTIME;
  LPSYSTEMTIME = UNTRACED REF SYSTEMTIME;
  SYSTEMTIME = RECORD
    wYear        : WORD;
    wMonth       : WORD;
    wDayOfWeek   : WORD;
    wDay         : WORD;
    wHour        : WORD;
    wMinute      : WORD;
    wSecond      : WORD;
    wMilliseconds: WORD;
  END;

  PTHREAD_START_ROUTINE = &lt;*WINAPI*&gt; PROCEDURE
                             (lpThreadParameter: LPVOID): DWORD;

  LPTHREAD_START_ROUTINE = PTHREAD_START_ROUTINE;

  CRITICAL_SECTION = WinNT.RTL_CRITICAL_SECTION;
  PCRITICAL_SECTION = WinNT.PRTL_CRITICAL_SECTION;
  LPCRITICAL_SECTION = WinNT.PRTL_CRITICAL_SECTION;

  CRITICAL_SECTION_DEBUG = WinNT.RTL_CRITICAL_SECTION_DEBUG;
  PCRITICAL_SECTION_DEBUG = WinNT.PRTL_CRITICAL_SECTION_DEBUG;
  LPCRITICAL_SECTION_DEBUG = WinNT.PRTL_CRITICAL_SECTION_DEBUG;

  LPLDT_ENTRY = LPVOID;

CONST
  MUTEX_MODIFY_STATE = WinNT.MUTANT_QUERY_STATE;
  MUTEX_ALL_ACCESS   = WinNT.MUTANT_ALL_ACCESS;
</PRE> Serial provider type. 

<P><PRE>CONST SP_SERIALCOMM: DWORD = 16_00000001;
</PRE> Provider SubTypes 

<P><PRE>CONST
  PST_UNSPECIFIED   : DWORD = 16_00000000;
  PST_RS232         : DWORD = 16_00000001;
  PST_PARALLELPORT  : DWORD = 16_00000002;
  PST_RS422         : DWORD = 16_00000003;
  PST_RS423         : DWORD = 16_00000004;
  PST_RS449         : DWORD = 16_00000005;
  PST_FAX           : DWORD = 16_00000021;
  PST_SCANNER       : DWORD = 16_00000022;
  PST_NETWORK_BRIDGE: DWORD = 16_00000100;
  PST_LAT           : DWORD = 16_00000101;
  PST_TCPIP_TELNET  : DWORD = 16_00000102;
  PST_X25           : DWORD = 16_00000103;
</PRE> Provider capabilities flags. 

<P><PRE>CONST
  PCF_DTRDSR       : DWORD = 16_0001;
  PCF_RTSCTS       : DWORD = 16_0002;
  PCF_RLSD         : DWORD = 16_0004;
  PCF_PARITY_CHECK : DWORD = 16_0008;
  PCF_XONXOFF      : DWORD = 16_0010;
  PCF_SETXCHAR     : DWORD = 16_0020;
  PCF_TOTALTIMEOUTS: DWORD = 16_0040;
  PCF_INTTIMEOUTS  : DWORD = 16_0080;
  PCF_SPECIALCHARS : DWORD = 16_0100;
  PCF_16BITMODE    : DWORD = 16_0200;
</PRE> Comm provider settable parameters. 

<P><PRE>CONST
  SP_PARITY      : DWORD = 16_0001;
  SP_BAUD        : DWORD = 16_0002;
  SP_DATABITS    : DWORD = 16_0004;
  SP_STOPBITS    : DWORD = 16_0008;
  SP_HANDSHAKING : DWORD = 16_0010;
  SP_PARITY_CHECK: DWORD = 16_0020;
  SP_RLSD        : DWORD = 16_0040;
</PRE> Settable baud rates in the provider. 

<P><PRE>CONST
  BAUD_075  : DWORD = 16_00000001;
  BAUD_110  : DWORD = 16_00000002;
  BAUD_134_5: DWORD = 16_00000004;
  BAUD_150  : DWORD = 16_00000008;
  BAUD_300  : DWORD = 16_00000010;
  BAUD_600  : DWORD = 16_00000020;
  BAUD_1200 : DWORD = 16_00000040;
  BAUD_1800 : DWORD = 16_00000080;
  BAUD_2400 : DWORD = 16_00000100;
  BAUD_4800 : DWORD = 16_00000200;
  BAUD_7200 : DWORD = 16_00000400;
  BAUD_9600 : DWORD = 16_00000800;
  BAUD_14400: DWORD = 16_00001000;
  BAUD_19200: DWORD = 16_00002000;
  BAUD_38400: DWORD = 16_00004000;
  BAUD_56K  : DWORD = 16_00008000;
  BAUD_128K : DWORD = 16_00010000;
  BAUD_USER : DWORD = 16_10000000;
</PRE> Settable Data Bits 

<P><PRE>CONST
  DATABITS_5  : WORD = 16_0001;
  DATABITS_6  : WORD = 16_0002;
  DATABITS_7  : WORD = 16_0004;
  DATABITS_8  : WORD = 16_0008;
  DATABITS_16 : WORD = 16_0010;
  DATABITS_16X: WORD = 16_0020;
</PRE> Settable Stop and Parity bits. 

<P><PRE>CONST
  STOPBITS_10 : WORD = 16_0001;
  STOPBITS_15 : WORD = 16_0002;
  STOPBITS_20 : WORD = 16_0004;
  PARITY_NONE : WORD = 16_0100;
  PARITY_ODD  : WORD = 16_0200;
  PARITY_EVEN : WORD = 16_0400;
  PARITY_MARK : WORD = 16_0800;
  PARITY_SPACE: WORD = 16_1000;

TYPE
  Int1  = BITS  1 FOR [0..1];
  Int2  = BITS  2 FOR [0..3];
  Int17 = BITS 17 FOR [0..16_1ffff];

  LPCOMMPROP = UNTRACED REF COMMPROP;
  COMMPROP = RECORD
    wPacketLength      : WORD;
    wPacketVersion     : WORD;
    dwServiceMask      : DWORD;
    dwReserved1        : DWORD;
    dwMaxTxQueue       : DWORD;
    dwMaxRxQueue       : DWORD;
    dwMaxBaud          : DWORD;
    dwProvSubType      : DWORD;
    dwProvCapabilities : DWORD;
    dwSettableParams   : DWORD;
    dwSettableBaud     : DWORD;
    wSettableData      : WORD;
    wSettableStopParity: WORD;
    dwCurrentTxQueue   : DWORD;
    dwCurrentRxQueue   : DWORD;
    dwProvSpec1        : DWORD;
    dwProvSpec2        : DWORD;
    wcProvChar         : ARRAY [0 .. 0] OF WCHAR;
  END;

  LPCOMSTAT = UNTRACED REF COMSTAT;
  COMSTAT = RECORD
    fCtsHold : Int1;
    fDsrHold : Int1;
    fRlsdHold: Int1;
    fXoffHold: Int1;
    fXoffSent: Int1;
    fEof     : Int1;
    fTxim    : Int1;
    fReserved: Int17;
    cbInQue  : DWORD;
    cbOutQue : DWORD;
  END;
</PRE> DTR Control Flow Values. 
<PRE>CONST
  DTR_CONTROL_DISABLE   = 16_00;
  DTR_CONTROL_ENABLE    = 16_01;
  DTR_CONTROL_HANDSHAKE = 16_02;
</PRE> RTS Control Flow Values 
<PRE>CONST
  RTS_CONTROL_DISABLE   = 16_00;
  RTS_CONTROL_ENABLE    = 16_01;
  RTS_CONTROL_HANDSHAKE = 16_02;
  RTS_CONTROL_TOGGLE    = 16_03;

TYPE
  LPDCB = UNTRACED REF DCB;
  DCB = RECORD
    DCBlength         : DWORD; (* sizeof(DCB) *)
    BaudRate          : DWORD; (* Baudrate at which running *)
    fBinary           : Int1;  (* Binary Mode (skip EOF check) *)
    fParity           : Int1;  (* Enable parity checking *)
    fOutxCtsFlow      : Int1;  (* CTS handshaking on output *)
    fOutxDsrFlow      : Int1;  (* DSR handshaking on output *)
    fDtrControl       : Int2;  (* DTR Flow control *)
    fDsrSensitivity   : Int1;  (* DSR Sensitivity *)
    fTXContinueOnXoff : Int1;  (* Continue TX when Xoff sent *)
    fOutX             : Int1;  (* Enable output X-ON/X-OFF *)
    fInX              : Int1;  (* Enable input X-ON/X-OFF *)
    fErrorChar        : Int1;  (* Enable Err Replacement *)
    fNull             : Int1;  (* Enable Null stripping *)
    fRtsControl       : Int2;  (* Rts Flow control *)
    fAbortOnError     : Int1;  (* Abort all reads and writes on Error *)
    fDummy2           : Int1;  (* Reserved *)
    wReserved         : WORD;  (* Not currently used *)
    XonLim            : WORD;  (* Transmit X-ON threshold *)
    XoffLim           : WORD;  (* Transmit X-OFF threshold *)
    ByteSize          : BYTE;  (* Number of bits/byte, 4-8 *)
    Parity            : BYTE;  (* 0-4=None,Odd,Even,Mark,Space *)
    StopBits          : BYTE;  (* 0,1,2 = 1, 1.5, 2 *)
    XonChar           : char;  (* Tx and Rx X-ON character *)
    XoffChar          : char;  (* Tx and Rx X-OFF character *)
    ErrorChar         : char;  (* Error replacement char *)
    EofChar           : char;  (* End of Input character *)
    EvtChar           : char;  (* Recieved Event character *)
  END;

  LPCOMMTIMEOUTS = UNTRACED REF COMMTIMEOUTS;
  COMMTIMEOUTS = RECORD
    ReadIntervalTimeout        : DWORD;  (* Max time between read chars. *)
    ReadTotalTimeoutMultiplier : DWORD;  (* Multiplier of characters. *)
    ReadTotalTimeoutConstant   : DWORD;  (* Constant in milliseconds. *)
    WriteTotalTimeoutMultiplier: DWORD;  (* Multiplier of characters. *)
    WriteTotalTimeoutConstant  : DWORD;  (* Constant in milliseconds. *)
  END;

  LPSYSTEM_INFO = UNTRACED REF SYSTEM_INFO;
  SYSTEM_INFO = RECORD
    dwOemId                    : DWORD;
    dwPageSize                 : DWORD;
    lpMinimumApplicationAddress: LPVOID;
    lpMaximumApplicationAddress: LPVOID;
    dwActiveProcessorMask      : DWORD;
    dwNumberOfProcessors       : DWORD;
    dwProcessorType            : DWORD;
    dwReserved1                : DWORD;
    dwReserved2                : DWORD;
  END;
</PRE>???  #define FreeModule(hLibModule) FreeLibrary((hLibModule)) #define
   MakeProcInstance(lpProc,hInstance) (lpProc) #define
   FreeProcInstance(lpProc) (lpProc) 

<P> Global Memory Flags 
<PRE>CONST
  GMEM_FIXED          = 16_0000;
  GMEM_MOVEABLE       = 16_0002;
  GMEM_NOCOMPACT      = 16_0010;
  GMEM_NODISCARD      = 16_0020;
  GMEM_ZEROINIT       = 16_0040;
  GMEM_MODIFY         = 16_0080;
  GMEM_DISCARDABLE    = 16_0100;
  GMEM_NOT_BANKED     = 16_1000;
  GMEM_SHARE          = 16_2000;
  GMEM_DDESHARE       = 16_2000;
  GMEM_NOTIFY         = 16_4000;
  GMEM_LOWER          = GMEM_NOT_BANKED;
  GMEM_VALID_FLAGS    = 16_7F72;
  GMEM_INVALID_HANDLE = 16_8000;

  GHND = Or(GMEM_MOVEABLE, GMEM_ZEROINIT);
  GPTR = Or(GMEM_FIXED, GMEM_ZEROINIT);
</PRE>???  #define GlobalLRUNewest( h ) (HANDLE)(h) #define GlobalLRUOldest( h
   ) (HANDLE)(h) #define GlobalDiscard( h ) GlobalReAlloc( (h), 0,
   GMEM_MOVEABLE ) 

<P> Flags returned by GlobalFlags (in addition to GMEM_DISCARDABLE) 
<PRE>CONST
  GMEM_DISCARDED = 16_4000;
  GMEM_LOCKCOUNT = 16_00FF;

TYPE
  LPMEMORYSTATUS = UNTRACED REF MEMORYSTATUS;
  MEMORYSTATUS = RECORD
    dwLength       : DWORD;
    dwMemoryLoad   : DWORD;
    dwTotalPhys    : DWORD;
    dwAvailPhys    : DWORD;
    dwTotalPageFile: DWORD;
    dwAvailPageFile: DWORD;
    dwTotalVirtual : DWORD;
    dwAvailVirtual : DWORD;
  END;
</PRE> Local Memory Flags 
<PRE>CONST
  LMEM_FIXED          = 16_0000;
  LMEM_MOVEABLE       = 16_0002;
  LMEM_NOCOMPACT      = 16_0010;
  LMEM_NODISCARD      = 16_0020;
  LMEM_ZEROINIT       = 16_0040;
  LMEM_MODIFY         = 16_0080;
  LMEM_DISCARDABLE    = 16_0F00;
  LMEM_VALID_FLAGS    = 16_0F72;
  LMEM_INVALID_HANDLE = 16_8000;

  LHND = Or(LMEM_MOVEABLE, LMEM_ZEROINIT);
  LPTR = Or(LMEM_FIXED, LMEM_ZEROINIT);

  NONZEROLHND = (LMEM_MOVEABLE);
  NONZEROLPTR = (LMEM_FIXED);
</PRE>???  #define LocalDiscard( h ) LocalReAlloc( (h), 0, LMEM_MOVEABLE ) 

<P> Flags returned by LocalFlags (in addition to LMEM_DISCARDABLE) 
<PRE>CONST
  LMEM_DISCARDED = 16_4000;
  LMEM_LOCKCOUNT = 16_00FF;
</PRE> dwCreationFlag values 

<P><PRE>CONST
  DEBUG_PROCESS           = 16_00000001;
  DEBUG_ONLY_THIS_PROCESS = 16_00000002;

  CREATE_SUSPENDED = 16_00000004;

  DETACHED_PROCESS = 16_00000008;

  CREATE_NEW_CONSOLE = 16_00000010;

  NORMAL_PRIORITY_CLASS   = 16_00000020;
  IDLE_PRIORITY_CLASS     = 16_00000040;
  HIGH_PRIORITY_CLASS     = 16_00000080;
  REALTIME_PRIORITY_CLASS = 16_00000100;

  CREATE_NEW_PROCESS_GROUP = 16_00000200;

  CREATE_NO_WINDOW = 16_08000000;

  PROFILE_USER   = 16_10000000;
  PROFILE_KERNEL = 16_20000000;
  PROFILE_SERVER = 16_40000000;

  THREAD_PRIORITY_LOWEST       = WinNT.THREAD_BASE_PRIORITY_MIN;
  THREAD_PRIORITY_BELOW_NORMAL = (THREAD_PRIORITY_LOWEST + 1);
  THREAD_PRIORITY_NORMAL       = 0;
  THREAD_PRIORITY_HIGHEST      = WinNT.THREAD_BASE_PRIORITY_MAX;
  THREAD_PRIORITY_ABOVE_NORMAL = (THREAD_PRIORITY_HIGHEST - 1);
  THREAD_PRIORITY_ERROR_RETURN = (WinNT.MAXLONG);

  THREAD_PRIORITY_TIME_CRITICAL = WinNT.THREAD_BASE_PRIORITY_LOWRT;
  THREAD_PRIORITY_IDLE          = WinNT.THREAD_BASE_PRIORITY_IDLE;
</PRE> Debug APIs 
<PRE>CONST
  EXCEPTION_DEBUG_EVENT      = 1;
  CREATE_THREAD_DEBUG_EVENT  = 2;
  CREATE_PROCESS_DEBUG_EVENT = 3;
  EXIT_THREAD_DEBUG_EVENT    = 4;
  EXIT_PROCESS_DEBUG_EVENT   = 5;
  LOAD_DLL_DEBUG_EVENT       = 6;
  UNLOAD_DLL_DEBUG_EVENT     = 7;
  OUTPUT_DEBUG_STRING_EVENT  = 8;
  RIP_EVENT                  = 9;

TYPE
  LPEXCEPTION_DEBUG_INFO = UNTRACED REF EXCEPTION_DEBUG_INFO;
  EXCEPTION_DEBUG_INFO = RECORD
    ExceptionRecord: WinNT.EXCEPTION_RECORD;
    dwFirstChance  : DWORD;
  END;

  LPCREATE_THREAD_DEBUG_INFO = UNTRACED REF CREATE_THREAD_DEBUG_INFO;
  CREATE_THREAD_DEBUG_INFO = RECORD
    hThread       : HANDLE;
    lpStartAddress: LPTHREAD_START_ROUTINE;
  END;

  LPCREATE_PROCESS_DEBUG_INFO = UNTRACED REF CREATE_PROCESS_DEBUG_INFO;
  CREATE_PROCESS_DEBUG_INFO = RECORD
    hFile                : HANDLE;
    hProcess             : HANDLE;
    hThread              : HANDLE;
    lpBaseOfImage        : LPVOID;
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize       : DWORD;
    lpStartAddress       : LPTHREAD_START_ROUTINE;
  END;

  EXIT_THREAD_DEBUG_INFO = RECORD dwExitCode: DWORD;  END;
  LPEXIT_THREAD_DEBUG_INFO = UNTRACED REF EXIT_THREAD_DEBUG_INFO;

  EXIT_PROCESS_DEBUG_INFO = RECORD dwExitCode: DWORD;  END;
  LPEXIT_PROCESS_DEBUG_INFO = UNTRACED REF EXIT_PROCESS_DEBUG_INFO;

  LPLOAD_DLL_DEBUG_INFO = UNTRACED REF LOAD_DLL_DEBUG_INFO;
  LOAD_DLL_DEBUG_INFO = RECORD
    hFile                : HANDLE;
    lpBaseOfDll          : LPVOID;
    dwDebugInfoFileOffset: DWORD;
    nDebugInfoSize       : DWORD;
  END;

  UNLOAD_DLL_DEBUG_INFO = RECORD lpBaseOfDll: LPVOID;  END;
  LPUNLOAD_DLL_DEBUG_INFO = UNTRACED REF UNLOAD_DLL_DEBUG_INFO;

  LPOUTPUT_DEBUG_STRING_INFO = UNTRACED REF OUTPUT_DEBUG_STRING_INFO;
  OUTPUT_DEBUG_STRING_INFO = RECORD
    lpDebugStringData : LPSTR;
    fUnicode          : WORD;
    nDebugStringLength: WORD;
  END;

  LPRIP_INFO = UNTRACED REF RIP_INFO;
  RIP_INFO = RECORD
    dwError: DWORD;
    dwType : DWORD;
  END;

CONST
  MAX_DEBUG_EVENT = MAX (BYTESIZE (EXCEPTION_DEBUG_INFO),
                    MAX (BYTESIZE (CREATE_THREAD_DEBUG_INFO),
                    MAX (BYTESIZE (CREATE_PROCESS_DEBUG_INFO),
                    MAX (BYTESIZE (EXIT_THREAD_DEBUG_INFO),
                    MAX (BYTESIZE (EXIT_PROCESS_DEBUG_INFO),
                    MAX (BYTESIZE (LOAD_DLL_DEBUG_INFO),
                    MAX (BYTESIZE (UNLOAD_DLL_DEBUG_INFO),
                    MAX (BYTESIZE (OUTPUT_DEBUG_STRING_INFO),
                    MAX (BYTESIZE (RIP_INFO),
                         0 )))))))));

TYPE
  LPDEBUG_EVENT = UNTRACED REF DEBUG_EVENT;
  DEBUG_EVENT = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    u               : ARRAY [0..MAX_DEBUG_EVENT-1] OF CHAR;
    (*!!!
      union {
        EXCEPTION_DEBUG_INFO Exception;
        CREATE_THREAD_DEBUG_INFO CreateThread;
        CREATE_PROCESS_DEBUG_INFO CreateProcessInfo;
        EXIT_THREAD_DEBUG_INFO ExitThread;
        EXIT_PROCESS_DEBUG_INFO ExitProcess;
        LOAD_DLL_DEBUG_INFO LoadDll;
        UNLOAD_DLL_DEBUG_INFO UnloadDll;
        OUTPUT_DEBUG_STRING_INFO DebugString;
        RIP_INFO RipInfo;
      } u;
    *)
  END;

  LPDEBUG_EXCEPTION = UNTRACED REF DEBUG_EXCEPTION;
  DEBUG_EXCEPTION = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    Exception       : EXCEPTION_DEBUG_INFO;
  END;

  LPDEBUG_CREATE_THREAD = UNTRACED REF DEBUG_CREATE_THREAD;
  DEBUG_CREATE_THREAD = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    CreateThread    : CREATE_THREAD_DEBUG_INFO;
  END;

  LPDEBUG_CREATE_PROCESS = UNTRACED REF DEBUG_CREATE_PROCESS;
  DEBUG_CREATE_PROCESS = RECORD
    dwDebugEventCode : DWORD;
    dwProcessId      : DWORD;
    dwThreadId       : DWORD;
    CreateProcessInfo: CREATE_PROCESS_DEBUG_INFO;
  END;

  LPDEBUG_EXIT_THREAD = UNTRACED REF DEBUG_EXIT_THREAD;
  DEBUG_EXIT_THREAD = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    ExitThread      : EXIT_THREAD_DEBUG_INFO;
  END;

  LPDEBUG_EXIT_PROCESS = UNTRACED REF DEBUG_EXIT_PROCESS;
  DEBUG_EXIT_PROCESS = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    ExitProcess     : EXIT_PROCESS_DEBUG_INFO;
  END;

  LPDEBUG_LOAD_DLL = UNTRACED REF DEBUG_LOAD_DLL;
  DEBUG_LOAD_DLL = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    LoadDll         : LOAD_DLL_DEBUG_INFO;
  END;

  LPDEBUG_UNLOAD_DLL = UNTRACED REF DEBUG_UNLOAD_DLL;
  DEBUG_UNLOAD_DLL = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    UnloadDll       : UNLOAD_DLL_DEBUG_INFO;
  END;

  LPDEBUG_OUTPUT_STRING = UNTRACED REF DEBUG_OUTPUT_STRING;
  DEBUG_OUTPUT_STRING = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    DebugString     : OUTPUT_DEBUG_STRING_INFO;
  END;

  LPDEBUG_RIP = UNTRACED REF DEBUG_RIP;
  DEBUG_RIP = RECORD
    dwDebugEventCode: DWORD;
    dwProcessId     : DWORD;
    dwThreadId      : DWORD;
    RipInfo         : RIP_INFO;
  END;

TYPE
  LPCONTEXT = ADDRESS;          (*!!!PCONTEXT*)
  LPEXCEPTION_RECORD = WinNT.PEXCEPTION_RECORD;
  LPEXCEPTION_POINTERS = WinNT.PEXCEPTION_POINTERS;

CONST
  DRIVE_REMOVABLE = 2;
  DRIVE_FIXED     = 3;
  DRIVE_REMOTE    = 4;
  DRIVE_CDROM     = 5;
  DRIVE_RAMDISK   = 6;
</PRE>???  #define GetFreeSpace(w) (16_100000L) 

<P><PRE>CONST
  FILE_TYPE_UNKNOWN = 16_0000;
  FILE_TYPE_DISK    = 16_0001;
  FILE_TYPE_CHAR    = 16_0002;
  FILE_TYPE_PIPE    = 16_0003;
  FILE_TYPE_REMOTE  = 16_8000;

  STD_INPUT_HANDLE : DWORD = -10;
  STD_OUTPUT_HANDLE: DWORD = -11;
  STD_ERROR_HANDLE : DWORD = -12;

  NOPARITY    = 0;
  ODDPARITY   = 1;
  EVENPARITY  = 2;
  MARKPARITY  = 3;
  SPACEPARITY = 4;

  ONESTOPBIT   = 0;
  ONE5STOPBITS = 1;
  TWOSTOPBITS  = 2;

  IGNORE   = 0;                 (* Ignore signal *)
  INFINITE = 16_FFFFFFFF;       (* Infinite timeout *)
</PRE> Basud rates at which the communication device operates 

<P><PRE>CONST
  CBR_110    = 110;
  CBR_300    = 300;
  CBR_600    = 600;
  CBR_1200   = 1200;
  CBR_2400   = 2400;
  CBR_4800   = 4800;
  CBR_9600   = 9600;
  CBR_14400  = 14400;
  CBR_19200  = 19200;
  CBR_38400  = 38400;
  CBR_56000  = 56000;
  CBR_128000 = 128000;
  CBR_256000 = 256000;
</PRE> Error Flags 

<P><PRE>CONST
  CE_RXOVER   = 16_0001;        (* Receive Queue overflow *)
  CE_OVERRUN  = 16_0002;        (* Receive Overrun Error *)
  CE_RXPARITY = 16_0004;        (* Receive Parity Error *)
  CE_FRAME    = 16_0008;        (* Receive Framing error *)
  CE_BREAK    = 16_0010;        (* Break Detected *)
  CE_TXFULL   = 16_0100;        (* TX Queue is full *)
  CE_PTO      = 16_0200;        (* LPTx Timeout *)
  CE_IOE      = 16_0400;        (* LPTx I/O Error *)
  CE_DNS      = 16_0800;        (* LPTx Device not selected *)
  CE_OOP      = 16_1000;        (* LPTx Out-Of-Paper *)
  CE_MODE     = 16_8000;        (* Requested mode unsupported *)

  IE_BADID    = (-1);           (* Invalid or unsupported id *)
  IE_OPEN     = (-2);           (* Device Already Open *)
  IE_NOPEN    = (-3);           (* Device Not Open *)
  IE_MEMORY   = (-4);           (* Unable to allocate queues *)
  IE_DEFAULT  = (-5);           (* Error in default parameters *)
  IE_HARDWARE = (-10);          (* Hardware Not Present *)
  IE_BYTESIZE = (-11);          (* Illegal Byte Size *)
  IE_BAUDRATE = (-12);          (* Unsupported BaudRate *)
</PRE> Events 

<P><PRE>CONST
  EV_RXCHAR   = 16_0001;        (* Any Character received *)
  EV_RXFLAG   = 16_0002;        (* Received certain character *)
  EV_TXEMPTY  = 16_0004;        (* Transmitt Queue Empty *)
  EV_CTS      = 16_0008;        (* CTS changed state *)
  EV_DSR      = 16_0010;        (* DSR changed state *)
  EV_RLSD     = 16_0020;        (* RLSD changed state *)
  EV_BREAK    = 16_0040;        (* BREAK received *)
  EV_ERR      = 16_0080;        (* Line status error occurred *)
  EV_RING     = 16_0100;        (* Ring signal detected *)
  EV_PERR     = 16_0200;        (* Printer error occured *)
  EV_RX80FULL = 16_0400;        (* Receive buffer is 80 percent full *)
  EV_EVENT1   = 16_0800;        (* Provider specific event 1 *)
  EV_EVENT2   = 16_1000;        (* Provider specific event 2 *)
</PRE> Escape Functions 

<P><PRE>CONST
  SETXOFF  = 1;                 (* Simulate XOFF received *)
  SETXON   = 2;                 (* Simulate XON received *)
  SETRTS   = 3;                 (* Set RTS high *)
  CLRRTS   = 4;                 (* Set RTS low *)
  SETDTR   = 5;                 (* Set DTR high *)
  CLRDTR   = 6;                 (* Set DTR low *)
  RESETDEV = 7;                 (* Reset device if possible *)
  SETBREAK = 8;                 (* Set the device break line. *)
  CLRBREAK = 9;                 (* Clear the device break line. *)
</PRE> PURGE function flags. 
<PRE>CONST
  PURGE_TXABORT = 16_0001;      (* Kill the pending/current writes to the
                                   comm port. *)
  PURGE_RXABORT = 16_0002;      (* Kill the pending/current reads to the
                                   comm port. *)
  PURGE_TXCLEAR = 16_0004;      (* Kill the transmit queue if there. *)
  PURGE_RXCLEAR = 16_0008;      (* Kill the typeahead buffer if there. *)

  LPTx = 16_80;                 (* Set if ID is for LPT device *)
</PRE> Modem Status Flags 
<PRE>CONST
  MS_CTS_ON : DWORD = 16_0010;
  MS_DSR_ON : DWORD = 16_0020;
  MS_RING_ON: DWORD = 16_0040;
  MS_RLSD_ON: DWORD = 16_0080;
</PRE> WaitSoundState() Constants 

<P><PRE>CONST
  S_QUEUEEMPTY   = 0;
  S_THRESHOLD    = 1;
  S_ALLTHRESHOLD = 2;
</PRE> Accent Modes 

<P><PRE>CONST
  S_NORMAL   = 0;
  S_LEGATO   = 1;
  S_STACCATO = 2;
</PRE> SetSoundNoise() Sources 

<P><PRE>CONST
  S_PERIOD512 = 0;              (* Freq = N/512 high pitch, less coarse
                                   hiss *)
  S_PERIOD1024 = 1;             (* Freq = N/1024 *)
  S_PERIOD2048 = 2;             (* Freq = N/2048 low pitch, more coarse
                                   hiss *)
  S_PERIODVOICE = 3;            (* Source is frequency from voice channel
                                   (3) *)
  S_WHITE512 = 4;               (* Freq = N/512 high pitch, less coarse
                                   hiss *)
  S_WHITE1024 = 5;              (* Freq = N/1024 *)
  S_WHITE2048 = 6;              (* Freq = N/2048 low pitch, more coarse
                                   hiss *)
  S_WHITEVOICE = 7;             (* Source is frequency from voice channel
                                   (3) *)

  S_SERDVNA = (-1);             (* Device not available *)
  S_SEROFM  = (-2);             (* Out of memory *)
  S_SERMACT = (-3);             (* Music active *)
  S_SERQFUL = (-4);             (* Queue full *)
  S_SERBDNT = (-5);             (* Invalid note *)
  S_SERDLN  = (-6);             (* Invalid note length *)
  S_SERDCC  = (-7);             (* Invalid note count *)
  S_SERDTP  = (-8);             (* Invalid tempo *)
  S_SERDVL  = (-9);             (* Invalid volume *)
  S_SERDMD  = (-10);            (* Invalid mode *)
  S_SERDSH  = (-11);            (* Invalid shape *)
  S_SERDPT  = (-12);            (* Invalid pitch *)
  S_SERDFQ  = (-13);            (* Invalid frequency *)
  S_SERDDR  = (-14);            (* Invalid duration *)
  S_SERDSR  = (-15);            (* Invalid source *)
  S_SERDST  = (-16);            (* Invalid state *)

  NMPWAIT_WAIT_FOREVER     = 16_ffffffff;
  NMPWAIT_NOWAIT           = 16_00000001;
  NMPWAIT_USE_DEFAULT_WAIT = 16_00000000;

  FS_CASE_IS_PRESERVED      = WinNT.FILE_CASE_PRESERVED_NAMES;
  FS_CASE_SENSITIVE         = WinNT.FILE_CASE_SENSITIVE_SEARCH;
  FS_UNICODE_STORED_ON_DISK = WinNT.FILE_UNICODE_ON_DISK;

  FILE_MAP_WRITE      = WinNT.SECTION_MAP_WRITE;
  FILE_MAP_READ       = WinNT.SECTION_MAP_READ;
  FILE_MAP_ALL_ACCESS = WinNT.SECTION_ALL_ACCESS;

  OF_READ             = 16_00000000;
  OF_WRITE            = 16_00000001;
  OF_READWRITE        = 16_00000002;
  OF_SHARE_COMPAT     = 16_00000000;
  OF_SHARE_EXCLUSIVE  = 16_00000010;
  OF_SHARE_DENY_WRITE = 16_00000020;
  OF_SHARE_DENY_READ  = 16_00000030;
  OF_SHARE_DENY_NONE  = 16_00000040;
  OF_PARSE            = 16_00000100;
  OF_DELETE           = 16_00000200;
  OF_VERIFY           = 16_00000400;
  OF_CANCEL           = 16_00000800;
  OF_CREATE           = 16_00001000;
  OF_PROMPT           = 16_00002000;
  OF_EXIST            = 16_00004000;
  OF_REOPEN           = 16_00008000;

  OFS_MAXPATHNAME = 128;

TYPE
  POFSTRUCT = UNTRACED REF OFSTRUCT;
  LPOFSTRUCT = UNTRACED REF OFSTRUCT;
  OFSTRUCT = RECORD
    cBytes    : BYTE;
    fFixedDisk: BYTE;
    nErrCode  : WORD;
    Reserved1 : WORD;
    Reserved2 : WORD;
    szPathName: ARRAY [0 .. OFS_MAXPATHNAME - 1] OF BYTE;
  END;

&lt;*EXTERNAL InterlockedIncrement:WINAPI*&gt;
PROCEDURE InterlockedIncrement (lpAddend: LPLONG): LONG;

&lt;*EXTERNAL InterlockedDecrement:WINAPI*&gt;
PROCEDURE InterlockedDecrement (lpAddend: LPLONG): LONG;

&lt;*EXTERNAL FreeResource:WINAPI*&gt;
PROCEDURE FreeResource (hResData: HGLOBAL): BOOL;

&lt;*EXTERNAL LockResource:WINAPI*&gt;
PROCEDURE LockResource (hResData: HGLOBAL): LPVOID;
</PRE>???  #define UnlockResource(hResData) ((hResData), 0) 

<P><PRE>CONST MAXINTATOM = 16_C000;
</PRE>???  #define MAKEINTATOM(i) (LPTSTR)((DWORD)((WORD)(i))) INVALID_ATOM =
   ((ATOM)0); 

<P><PRE>&lt;*EXTERNAL WinMain:WINAPI*&gt;
PROCEDURE WinMain (hInstance    : HINSTANCE;
                   hPrevInstance: HINSTANCE;
                   lpCmdLine    : LPSTR;
                   nShowCmd     : int        ): int;

&lt;*EXTERNAL FreeLibrary:WINAPI*&gt;
PROCEDURE FreeLibrary (hLibModule: HINSTANCE): BOOL;

&lt;*EXTERNAL GetProcAddress:WINAPI*&gt;
PROCEDURE GetProcAddress (hModule: HINSTANCE; lpProcName: LPCSTR): FARPROC;

&lt;*EXTERNAL GetVersion:WINAPI*&gt;
PROCEDURE GetVersion (): DWORD;

&lt;*EXTERNAL GlobalAlloc:WINAPI*&gt;
PROCEDURE GlobalAlloc (uFlags: UINT; dwBytes: DWORD): HGLOBAL;

&lt;*EXTERNAL GlobalReAlloc:WINAPI*&gt;
PROCEDURE GlobalReAlloc (hMem: HGLOBAL; dwBytes: DWORD; uFlags: UINT): HGLOBAL;

&lt;*EXTERNAL GlobalSize:WINAPI*&gt;
PROCEDURE GlobalSize (hMem: HGLOBAL): DWORD;

&lt;*EXTERNAL GlobalFlags:WINAPI*&gt;
PROCEDURE GlobalFlags (hMem: HGLOBAL): UINT;

&lt;*EXTERNAL GlobalLock:WINAPI*&gt;
PROCEDURE GlobalLock (hMem: HGLOBAL): LPVOID;
</PRE>!!!MWH My version win31 = DWORD WINAPI GlobalHandle(UINT) 
<PRE>&lt;*EXTERNAL GlobalHandle:WINAPI*&gt;
PROCEDURE GlobalHandle (pMem: LPVOID): HGLOBAL;

&lt;*EXTERNAL GlobalUnlock:WINAPI*&gt;
PROCEDURE GlobalUnlock (hMem: HGLOBAL): BOOL;

&lt;*EXTERNAL GlobalFree:WINAPI*&gt;
PROCEDURE GlobalFree (hMem: HGLOBAL): HGLOBAL;

&lt;*EXTERNAL GlobalCompact:WINAPI*&gt;
PROCEDURE GlobalCompact (dwMinFree: DWORD): UINT;

&lt;*EXTERNAL GlobalFix:WINAPI*&gt;
PROCEDURE GlobalFix (hMem: HGLOBAL);

&lt;*EXTERNAL GlobalUnfix:WINAPI*&gt;
PROCEDURE GlobalUnfix (hMem: HGLOBAL);

&lt;*EXTERNAL GlobalWire:WINAPI*&gt;
PROCEDURE GlobalWire (hMem: HGLOBAL): LPVOID;

&lt;*EXTERNAL GlobalUnWire:WINAPI*&gt;
PROCEDURE GlobalUnWire (hMem: HGLOBAL): BOOL;

&lt;*EXTERNAL GlobalMemoryStatus:WINAPI*&gt;
PROCEDURE GlobalMemoryStatus (lpBuffer: LPMEMORYSTATUS);

&lt;*EXTERNAL LocalAlloc:WINAPI*&gt;
PROCEDURE LocalAlloc (uFlags: UINT; uBytes: UINT): HLOCAL;

&lt;*EXTERNAL LocalReAlloc:WINAPI*&gt;
PROCEDURE LocalReAlloc (hMem: HLOCAL; uBytes: UINT; uFlags: UINT): HLOCAL;

&lt;*EXTERNAL LocalLock:WINAPI*&gt;
PROCEDURE LocalLock (hMem: HLOCAL): LPVOID;

&lt;*EXTERNAL LocalHandle:WINAPI*&gt;
PROCEDURE LocalHandle (pMem: LPVOID): HLOCAL;

&lt;*EXTERNAL LocalUnlock:WINAPI*&gt;
PROCEDURE LocalUnlock (hMem: HLOCAL): BOOL;

&lt;*EXTERNAL LocalSize:WINAPI*&gt;
PROCEDURE LocalSize (hMem: HLOCAL): UINT;

&lt;*EXTERNAL LocalFlags:WINAPI*&gt;
PROCEDURE LocalFlags (hMem: HLOCAL): UINT;

&lt;*EXTERNAL LocalFree:WINAPI*&gt;
PROCEDURE LocalFree (hMem: HLOCAL): HLOCAL;

&lt;*EXTERNAL LocalShrink:WINAPI*&gt;
PROCEDURE LocalShrink (hMem: HLOCAL; cbNewSize: UINT): UINT;

&lt;*EXTERNAL LocalCompact:WINAPI*&gt;
PROCEDURE LocalCompact (uMinFree: UINT): UINT;

&lt;*EXTERNAL FlushInstructionCache:WINAPI*&gt;
PROCEDURE FlushInstructionCache (hProcess     : HANDLE;
                                 lpBaseAddress: LPVOID;
                                 dwSize       : DWORD   ): BOOL;

&lt;*EXTERNAL VirtualAlloc:WINAPI*&gt;
PROCEDURE VirtualAlloc (lpAddress       : LPVOID;
                        dwSize          : DWORD;
                        flAllocationType: DWORD;
                        flProtect       : DWORD   ): LPVOID;

&lt;*EXTERNAL VirtualFree:WINAPI*&gt;
PROCEDURE VirtualFree (lpAddress : LPVOID;
                       dwSize    : DWORD;
                       dwFreeType: DWORD   ): BOOL;

&lt;*EXTERNAL VirtualProtect:WINAPI*&gt;
PROCEDURE VirtualProtect (lpAddress     : LPVOID;
                          dwSize        : DWORD;
                          flNewProtect  : DWORD;
                          lpflOldProtect: PDWORD  ): BOOL;

&lt;*EXTERNAL VirtualQuery:WINAPI*&gt;
PROCEDURE VirtualQuery (lpAddress: LPVOID;
                        lpBuffer : WinNT.PMEMORY_BASIC_INFORMATION;
                        dwLength : DWORD                            ): DWORD;

&lt;*EXTERNAL VirtualProtectEx:WINAPI*&gt;
PROCEDURE VirtualProtectEx (hProcess      : HANDLE;
                            lpAddress     : LPVOID;
                            dwSize        : DWORD;
                            flNewProtect  : DWORD;
                            lpflOldProtect: PDWORD  ): BOOL;

&lt;*EXTERNAL VirtualQueryEx:WINAPI*&gt;
PROCEDURE VirtualQueryEx (hProcess : HANDLE;
                          lpAddress: LPVOID;
                          lpBuffer : WinNT.PMEMORY_BASIC_INFORMATION;
                          dwLength : DWORD                            ): DWORD;

&lt;*EXTERNAL HeapCreate:WINAPI*&gt;
PROCEDURE HeapCreate (flOptions    : DWORD;
                        dwInitialSize: DWORD;
                        dwMaximumSize: DWORD  ): HANDLE;

&lt;*EXTERNAL HeapDestroy:WINAPI*&gt;
PROCEDURE HeapDestroy (hHeap: HANDLE): BOOL;

&lt;*EXTERNAL HeapAlloc:WINAPI*&gt;
PROCEDURE HeapAlloc (hHeap: HANDLE; dwBytes: DWORD): LPSTR;

&lt;*EXTERNAL HeapFree:WINAPI*&gt;
PROCEDURE HeapFree (hHeap: HANDLE; lpMem: LPSTR): BOOL;

&lt;*EXTERNAL HeapSize:WINAPI*&gt;
PROCEDURE HeapSize (hHeap: HANDLE; lpMem: LPSTR): DWORD;

&lt;*EXTERNAL OpenProcess:WINAPI*&gt;
PROCEDURE OpenProcess (dwDesiredAccess: DWORD;
                         bInheritHandle : BOOL;
                         dwProcessId    : DWORD  ): HANDLE;

&lt;*EXTERNAL GetCurrentProcess:WINAPI*&gt;
PROCEDURE GetCurrentProcess (): HANDLE;

&lt;*EXTERNAL GetCurrentProcessId:WINAPI*&gt;
PROCEDURE GetCurrentProcessId (): DWORD;

&lt;*EXTERNAL ExitProcess:WINAPI*&gt;
PROCEDURE ExitProcess (uExitCode: UINT);

&lt;*EXTERNAL TerminateProcess:WINAPI*&gt;
PROCEDURE TerminateProcess (hProcess: HANDLE; uExitCode: UINT): BOOL;

&lt;*EXTERNAL GetExitCodeProcess:WINAPI*&gt;
PROCEDURE GetExitCodeProcess (hProcess: HANDLE; lpExitCode: LPDWORD): BOOL;

&lt;*EXTERNAL FatalExit:WINAPI*&gt;
PROCEDURE FatalExit (ExitCode: int);

&lt;*EXTERNAL GetEnvironmentStrings:WINAPI*&gt;
PROCEDURE GetEnvironmentStrings (): LPVOID;

&lt;*EXTERNAL RaiseException:WINAPI*&gt;
PROCEDURE RaiseException (dwExceptionCode   : DWORD;
                          dwExceptionFlags  : DWORD;
                          nNumberOfArguments: DWORD;
                          lpArguments       : LPDWORD);
</PRE>???
&lt;*EXTERNAL UnhandledExceptionFilter:WINAPI*&gt;
PROCEDURE UnhandledExceptionFilter(
  ExceptionInfo: UNTRACED REF WinNT.EXCEPTION_POINTERS):
    WinNT.EXCEPTION_DISPOSITION;


<P><PRE>&lt;*EXTERNAL CreateThread:WINAPI*&gt;
PROCEDURE CreateThread (lpThreadAttributes: LPSECURITY_ATTRIBUTES;
                        dwStackSize       : DWORD;
                        lpStartAddress    : LPTHREAD_START_ROUTINE;
                        lpParameter       : LPVOID;
                        dwCreationFlags   : DWORD;
                        lpThreadId        : LPDWORD                 ): HANDLE;

&lt;*EXTERNAL CreateRemoteThread:WINAPI*&gt;
PROCEDURE CreateRemoteThread (hProcess          : HANDLE;
                              lpThreadAttributes: LPSECURITY_ATTRIBUTES;
                              dwStackSize       : DWORD;
                              lpStartAddress : LPTHREAD_START_ROUTINE;
                              lpParameter    : LPVOID;
                              dwCreationFlags: DWORD;
                              lpThreadId     : LPDWORD              ): HANDLE;

&lt;*EXTERNAL GetCurrentThread:WINAPI*&gt;
PROCEDURE GetCurrentThread (): HANDLE;

&lt;*EXTERNAL GetCurrentThreadId:WINAPI*&gt;
PROCEDURE GetCurrentThreadId (): DWORD;

&lt;*EXTERNAL SetThreadPriority:WINAPI*&gt;
PROCEDURE SetThreadPriority (hThread: HANDLE; nPriority: int): BOOL;

&lt;*EXTERNAL GetThreadPriority:WINAPI*&gt;
PROCEDURE GetThreadPriority (hThread: HANDLE): int;

&lt;*EXTERNAL ExitThread:WINAPI*&gt;
PROCEDURE ExitThread (dwExitCode: DWORD);

&lt;*EXTERNAL TerminateThread:WINAPI*&gt;
PROCEDURE TerminateThread (hThread: HANDLE; dwExitCode: DWORD): BOOL;

&lt;*EXTERNAL GetExitCodeThread:WINAPI*&gt;
PROCEDURE GetExitCodeThread (hThread: HANDLE; lpExitCode: LPDWORD): BOOL;

&lt;*EXTERNAL GetThreadSelectorEntry:WINAPI*&gt;
PROCEDURE GetThreadSelectorEntry (hThread        : HANDLE;
                                  dwSelector     : DWORD;
                                  lpSelectorEntry: LPLDT_ENTRY): BOOL;

&lt;*EXTERNAL GetLastError:WINAPI*&gt;
PROCEDURE GetLastError (): DWORD;

&lt;*EXTERNAL SetLastError:WINAPI*&gt;
PROCEDURE SetLastError (dwErrCode: DWORD);
</PRE> SetLastErrorEx() types. 
<PRE>CONST
  SLE_ERROR      = 16_00000001;
  SLE_MINORERROR = 16_00000002;
  SLE_WARNING    = 16_00000003;

&lt;*EXTERNAL SetLastErrorEx:WINAPI*&gt;
PROCEDURE SetLastErrorEx (dwErrCode: DWORD; dwType: DWORD);

&lt;*EXTERNAL GetOverlappedResult:WINAPI*&gt;
PROCEDURE GetOverlappedResult (hFile                     : HANDLE;
                               lpOverlapped              : LPOVERLAPPED;
                               lpNumberOfBytesTransferred: LPDWORD;
                               bWait                     : BOOL        ): BOOL;

CONST
  SEM_FAILCRITICALERRORS = 16_0001;
  SEM_NOGPFAULTERRORBOX  = 16_0002;
  SEM_NOOPENFILEERRORBOX = 16_8000;

&lt;*EXTERNAL SetDebugErrorLevel:WINAPI*&gt;
PROCEDURE SetDebugErrorLevel (dwLevel: DWORD);

&lt;*EXTERNAL SetErrorMode:WINAPI*&gt;
PROCEDURE SetErrorMode (uMode: UINT): UINT;

&lt;*EXTERNAL ReadProcessMemory:WINAPI*&gt;
PROCEDURE ReadProcessMemory (hProcess           : HANDLE;
                             lpBaseAddress      : LPVOID;
                             lpBuffer           : LPVOID;
                             nSize              : DWORD;
                             lpNumberOfBytesRead: LPDWORD ): BOOL;

&lt;*EXTERNAL WriteProcessMemory:WINAPI*&gt;
PROCEDURE WriteProcessMemory (hProcess              : HANDLE;
                              lpBaseAddress         : LPVOID;
                              lpBuffer              : LPVOID;
                              nSize                 : DWORD;
                              lpNumberOfBytesWritten: LPDWORD ): BOOL;

&lt;*EXTERNAL GetThreadContext:WINAPI*&gt;
PROCEDURE GetThreadContext (hThread: HANDLE; lpContext: LPCONTEXT): BOOL;

&lt;*EXTERNAL SetThreadContext:WINAPI*&gt;
PROCEDURE SetThreadContext (hThread: HANDLE; lpContext: LPCONTEXT): BOOL;

&lt;*EXTERNAL SuspendThread:WINAPI*&gt;
PROCEDURE SuspendThread (hThread: HANDLE): DWORD;

&lt;*EXTERNAL ResumeThread:WINAPI*&gt;
PROCEDURE ResumeThread (hThread: HANDLE): DWORD;

&lt;*EXTERNAL DebugBreak:WINAPI*&gt;
PROCEDURE DebugBreak ();

&lt;*EXTERNAL WaitForDebugEvent:WINAPI*&gt;
PROCEDURE WaitForDebugEvent (lpDebugEvent  : LPDEBUG_EVENT;
                             dwMilliseconds: DWORD          ): BOOL;

&lt;*EXTERNAL ContinueDebugEvent:WINAPI*&gt;
PROCEDURE ContinueDebugEvent (dwProcessId     : DWORD;
                              dwThreadId      : DWORD;
                              dwContinueStatus: DWORD  ): BOOL;

&lt;*EXTERNAL DebugActiveProcess:WINAPI*&gt;
PROCEDURE DebugActiveProcess (dwProcessId: DWORD): BOOL;

&lt;*EXTERNAL DebugSnapShotProcessHeaps:WINAPI*&gt;
PROCEDURE DebugSnapShotProcessHeaps (dwProcessId: DWORD): HANDLE;

TYPE
  PDEBUG_HEAP_BACKTRACE = UNTRACED REF DEBUG_HEAP_BACKTRACE;
  DEBUG_HEAP_BACKTRACE = RECORD
    Depth          : DWORD;
    ReturnAddresses: ARRAY [0 .. 0] OF DWORD;
  END;

  PDEBUG_HEAP_ALLOCATOR = UNTRACED REF DEBUG_HEAP_ALLOCATOR;
  DEBUG_HEAP_ALLOCATOR = RECORD
    TotalBytesAllocated: DWORD;
    OffsetToBackTrace  : DWORD;
  END;

  PDEBUG_HEAP_ENTRY = UNTRACED REF DEBUG_HEAP_ENTRY;
  DEBUG_HEAP_ENTRY = RECORD
    Address  : DWORD;
    Size     : USHORT;
    Allocator: USHORT;
  END;

CONST
  DEBUG_HEAP_ENTRY_FREE (*!!!:USHORT*) = -1;

TYPE
  PDEBUG_HEAP_INFO = UNTRACED REF DEBUG_HEAP_INFO;
  DEBUG_HEAP_INFO = RECORD
    Creator                : USHORT;
    HeaderSizeLog2         : USHORT;
    ReservedPages          : USHORT;
    CommittedPages         : USHORT;
    AllocatorReservedPages : USHORT;
    AllocatorCommittedPages: USHORT;
    NumberOfEntries        : DWORD;
    Entries: ARRAY [0 .. 0] OF DEBUG_HEAP_ENTRY;
  END;

  PDEBUG_HEAP_DUMP = UNTRACED REF DEBUG_HEAP_DUMP;
  DEBUG_HEAP_DUMP = RECORD
    OffsetToAllocatorTable: DWORD;
    NumberOfHeaps         : DWORD;
    HeapInfo: ARRAY [0 .. 0] OF DEBUG_HEAP_INFO;
  END;

&lt;*EXTERNAL InitializeCriticalSection:WINAPI*&gt;
PROCEDURE InitializeCriticalSection (lpCriticalSection: LPCRITICAL_SECTION);

&lt;*EXTERNAL EnterCriticalSection:WINAPI*&gt;
PROCEDURE EnterCriticalSection (lpCriticalSection: LPCRITICAL_SECTION);

&lt;*EXTERNAL LeaveCriticalSection:WINAPI*&gt;
PROCEDURE LeaveCriticalSection (lpCriticalSection: LPCRITICAL_SECTION);

&lt;*EXTERNAL DeleteCriticalSection:WINAPI*&gt;
PROCEDURE DeleteCriticalSection (lpCriticalSection: LPCRITICAL_SECTION);

&lt;*EXTERNAL SetEvent:WINAPI*&gt;
PROCEDURE SetEvent (hEvent: HANDLE): BOOL;

&lt;*EXTERNAL ResetEvent:WINAPI*&gt;
PROCEDURE ResetEvent (hEvent: HANDLE): BOOL;

&lt;*EXTERNAL PulseEvent:WINAPI*&gt;
PROCEDURE PulseEvent (hEvent: HANDLE): BOOL;

&lt;*EXTERNAL ReleaseSemaphore:WINAPI*&gt;
PROCEDURE ReleaseSemaphore (hSemaphore     : HANDLE;
                            lReleaseCount  : LONG;
                            lpPreviousCount: LPLONG  ): BOOL;

&lt;*EXTERNAL ReleaseMutex:WINAPI*&gt;
PROCEDURE ReleaseMutex (hMutex: HANDLE): BOOL;

&lt;*EXTERNAL WaitForSingleObject:WINAPI*&gt;
PROCEDURE WaitForSingleObject (hHandle: HANDLE; dwMilliseconds: DWORD): DWORD;

&lt;*EXTERNAL WaitForMultipleObjects:WINAPI*&gt;
PROCEDURE WaitForMultipleObjects (nCount        : DWORD;
                                  lpHandles     : LPHANDLE;
                                  bWaitAll      : BOOL;
                                  dwMilliseconds: DWORD     ): DWORD;

&lt;*EXTERNAL Sleep:WINAPI*&gt;
PROCEDURE Sleep (dwMilliseconds: DWORD);

&lt;*EXTERNAL LoadResource:WINAPI*&gt;
PROCEDURE LoadResource (hModule: HINSTANCE; hResInfo: HRSRC): HRSRC;

&lt;*EXTERNAL SizeofResource:WINAPI*&gt;
PROCEDURE SizeofResource (hModule: HINSTANCE; hResInfo: HRSRC): DWORD;

&lt;*EXTERNAL CloseProfileUserMapping:WINAPI*&gt;
PROCEDURE CloseProfileUserMapping (): BOOLEAN;

&lt;*EXTERNAL OpenProfileUserMapping:WINAPI*&gt;
PROCEDURE OpenProfileUserMapping (): BOOLEAN;

&lt;*EXTERNAL GlobalDeleteAtom:WINAPI*&gt;
PROCEDURE GlobalDeleteAtom (nAtom: ATOM): ATOM;

&lt;*EXTERNAL InitAtomTable:WINAPI*&gt;
PROCEDURE InitAtomTable (nSize: DWORD): BOOL;

&lt;*EXTERNAL DeleteAtom:WINAPI*&gt;
PROCEDURE DeleteAtom (nAtom: ATOM): ATOM;

&lt;*EXTERNAL SetHandleCount:WINAPI*&gt;
PROCEDURE SetHandleCount (uNumber: UINT): UINT;

&lt;*EXTERNAL GetLogicalDrives:WINAPI*&gt;
PROCEDURE GetLogicalDrives (): DWORD;

&lt;*EXTERNAL LockFile:WINAPI*&gt;
PROCEDURE LockFile (hFile                   : HANDLE;
                    dwFileOffsetLow         : DWORD;
                    dwFileOffsetHigh        : DWORD;
                    nNumberOfBytesToLockLow : DWORD;
                    nNumberOfBytesToLockHigh: DWORD   ): BOOL;

&lt;*EXTERNAL UnlockFile:WINAPI*&gt;
PROCEDURE UnlockFile (hFile                     : HANDLE;
                      dwFileOffsetLow           : DWORD;
                      dwFileOffsetHigh          : DWORD;
                      nNumberOfBytesToUnlockLow : DWORD;
                      nNumberOfBytesToUnlockHigh: DWORD   ): BOOL;

TYPE
  PBY_HANDLE_FILE_INFORMATION = UNTRACED REF BY_HANDLE_FILE_INFORMATION;
  LPBY_HANDLE_FILE_INFORMATION = UNTRACED REF BY_HANDLE_FILE_INFORMATION;
  BY_HANDLE_FILE_INFORMATION = RECORD
    dwFileAttributes    : DWORD;
    ftCreationTime      : FILETIME;
    ftLastAccessTime    : FILETIME;
    ftLastWriteTime     : FILETIME;
    dwVolumeSerialNumber: DWORD;
    nFileSizeHigh       : DWORD;
    nFileSizeLow        : DWORD;
    nNumberOfLinks      : DWORD;
    nFileIndexHigh      : DWORD;
    nFileIndexLow       : DWORD;
  END;

&lt;*EXTERNAL GetFileInformationByHandle:WINAPI*&gt;
PROCEDURE GetFileInformationByHandle (hFile: HANDLE;
              lpFileInformation: LPBY_HANDLE_FILE_INFORMATION): BOOL;

&lt;*EXTERNAL GetFileType:WINAPI*&gt;
PROCEDURE GetFileType (hFile: HANDLE): DWORD;

&lt;*EXTERNAL GetFileSize:WINAPI*&gt;
PROCEDURE GetFileSize (hFile: HANDLE; lpFileSizeHigh: LPDWORD): DWORD;

&lt;*EXTERNAL GetStdHandle:WINAPI*&gt;
PROCEDURE GetStdHandle (nStdHandle: DWORD): HANDLE;

&lt;*EXTERNAL SetStdHandle:WINAPI*&gt;
PROCEDURE SetStdHandle (nStdHandle: DWORD; hHandle: HANDLE): BOOL;

&lt;*EXTERNAL WriteFile:WINAPI*&gt;
PROCEDURE WriteFile (hFile                 : HANDLE;
                     lpBuffer              : void_star;
                     nNumberOfBytesToWrite : DWORD;
                     lpNumberOfBytesWritten: LPDWORD;
                     lpOverlapped          : LPOVERLAPPED): BOOL;

&lt;*EXTERNAL ReadFile:WINAPI*&gt;
PROCEDURE ReadFile (hFile               : HANDLE;
                    lpBuffer            : LPVOID;
                    nNumberOfBytesToRead: DWORD;
                    lpNumberOfBytesRead : LPDWORD;
                    lpOverlapped        : LPOVERLAPPED): BOOL;

&lt;*EXTERNAL FlushFileBuffers:WINAPI*&gt;
PROCEDURE FlushFileBuffers (hFile: HANDLE): BOOL;

&lt;*EXTERNAL DeviceIoControl:WINAPI*&gt;
PROCEDURE DeviceIoControl (hDevice        : HANDLE;
                           dwIoControlCode: DWORD;
                           lpInBuffer     : LPVOID;
                           nInBufferSize  : DWORD;
                           lpOutBuffer    : LPVOID;
                           nOutBufferSize : DWORD;
                           lpBytesReturned: LPDWORD;
                           lpOverlapped   : LPOVERLAPPED): BOOL;

&lt;*EXTERNAL SetEndOfFile:WINAPI*&gt;
PROCEDURE SetEndOfFile (hFile: HANDLE): BOOL;

&lt;*EXTERNAL SetFilePointer:WINAPI*&gt;
PROCEDURE SetFilePointer (hFile               : HANDLE;
                          lDistanceToMove     : LONG;
                          lpDistanceToMoveHigh: PLONG;
                          dwMoveMethod        : DWORD   ): DWORD;

&lt;*EXTERNAL FindClose:WINAPI*&gt;
PROCEDURE FindClose (hFindFile: HANDLE): BOOL;

&lt;*EXTERNAL GetFileTime:WINAPI*&gt;
PROCEDURE GetFileTime (hFile           : HANDLE;
                       lpCreationTime  : LPFILETIME;
                       lpLastAccessTime: LPFILETIME;
                       lpLastWriteTime : LPFILETIME  ): BOOL;

&lt;*EXTERNAL SetFileTime:WINAPI*&gt;
PROCEDURE SetFileTime (hFile           : HANDLE;
                       lpCreationTime  : LPFILETIME;
                       lpLastAccessTime: LPFILETIME;
                       lpLastWriteTime : LPFILETIME  ): BOOL;

&lt;*EXTERNAL CloseHandle:WINAPI*&gt;
PROCEDURE CloseHandle (hObject: HANDLE): BOOL;

&lt;*EXTERNAL DuplicateHandle:WINAPI*&gt;
PROCEDURE DuplicateHandle (hSourceProcessHandle: HANDLE;
                           hSourceHandle       : HANDLE;
                           hTargetProcessHandle: HANDLE;
                           lpTargetHandle      : LPHANDLE;
                           dwDesiredAccess     : DWORD;
                           bInheritHandle      : BOOL;
                           dwOptions           : DWORD     ): BOOL;

&lt;*EXTERNAL LoadModule:WINAPI*&gt;
PROCEDURE LoadModule (lpModuleName: LPCSTR; lpParameterBlock: LPVOID): DWORD;

&lt;*EXTERNAL WinExec:WINAPI*&gt;
PROCEDURE WinExec (lpCmdLine: LPCSTR; uCmdShow: UINT): UINT;
</PRE>???  Redefined later--sjrh &lt;*EXTERNAL BuildCommDCB:WINAPI*&gt;
PROCEDURE BuildCommDCB( lpDef: LPSTR; lpDCB: LPDCB ):BOOL;


<P><PRE>&lt;*EXTERNAL ClearCommBreak:WINAPI*&gt;
PROCEDURE ClearCommBreak (hFile: HANDLE): BOOL;

&lt;*EXTERNAL ClearCommError:WINAPI*&gt;
PROCEDURE ClearCommError (hFile   : HANDLE;
                          lpErrors: LPDWORD;
                          lpStat  : LPCOMSTAT): BOOL;

&lt;*EXTERNAL SetupComm:WINAPI*&gt;
PROCEDURE SetupComm (hFile: HANDLE; dwInQueue: DWORD; dwOutQueue: DWORD): BOOL;

&lt;*EXTERNAL EscapeCommFunction:WINAPI*&gt;
PROCEDURE EscapeCommFunction (hFile: HANDLE; dwFunc: DWORD): BOOL;

&lt;*EXTERNAL GetCommMask:WINAPI*&gt;
PROCEDURE GetCommMask (hFile: HANDLE; lpEvtMask: LPDWORD): BOOL;

&lt;*EXTERNAL GetCommProperties:WINAPI*&gt;
PROCEDURE GetCommProperties (hFile: HANDLE; lpCommProp: LPCOMMPROP): BOOL;

&lt;*EXTERNAL GetCommModemStatus:WINAPI*&gt;
PROCEDURE GetCommModemStatus (hFile: HANDLE; lpModemStat: LPDWORD): BOOL;

&lt;*EXTERNAL GetCommState:WINAPI*&gt;
PROCEDURE GetCommState (hFile: HANDLE; lpDCB: LPDCB): BOOL;

&lt;*EXTERNAL GetCommTimeouts:WINAPI*&gt;
PROCEDURE GetCommTimeouts (hFile: HANDLE; lpCommTimeouts: LPCOMMTIMEOUTS):BOOL;

&lt;*EXTERNAL PurgeComm:WINAPI*&gt;
PROCEDURE PurgeComm (hFile: HANDLE; dwFlags: DWORD): BOOL;

&lt;*EXTERNAL SetCommBreak:WINAPI*&gt;
PROCEDURE SetCommBreak (hFile: HANDLE): BOOL;

&lt;*EXTERNAL SetCommMask:WINAPI*&gt;
PROCEDURE SetCommMask (hFile: HANDLE; dwEvtMask: DWORD): BOOL;

&lt;*EXTERNAL SetCommState:WINAPI*&gt;
PROCEDURE SetCommState (hFile: HANDLE; lpDCB: LPDCB): BOOL;

&lt;*EXTERNAL SetCommTimeouts:WINAPI*&gt;
PROCEDURE SetCommTimeouts (hFile: HANDLE; lpCommTimeouts: LPCOMMTIMEOUTS):BOOL;

&lt;*EXTERNAL TransmitCommChar:WINAPI*&gt;
PROCEDURE TransmitCommChar (hFile: HANDLE; cChar: char): BOOL;

&lt;*EXTERNAL WaitCommEvent:WINAPI*&gt;
PROCEDURE WaitCommEvent (hFile       : HANDLE;
                         lpEvtMask   : LPDWORD;
                         lpOverlapped: LPOVERLAPPED): BOOL;

&lt;*EXTERNAL SetTapePosition:WINAPI*&gt;
PROCEDURE SetTapePosition (hDevice         : HANDLE;
                           dwPositionMethod: DWORD;
                           dwPartition     : DWORD;
                           dwOffsetLow     : DWORD;
                           dwOffsetHigh    : DWORD   ): DWORD;

&lt;*EXTERNAL GetTapePosition:WINAPI*&gt;
PROCEDURE GetTapePosition (hDevice       : HANDLE;
                           dwPositionType: DWORD;
                           lpdwPartition : LPDWORD;
                           lpdwOffsetLow : LPDWORD;
                           lpdwOffsetHigh: LPDWORD  ): DWORD;

&lt;*EXTERNAL PrepareTape:WINAPI*&gt;
PROCEDURE PrepareTape (hDevice: HANDLE; dwOperation: DWORD): DWORD;

&lt;*EXTERNAL EraseTape:WINAPI*&gt;
PROCEDURE EraseTape (hDevice: HANDLE; dwEraseType: DWORD): DWORD;

&lt;*EXTERNAL CreateTapePartition:WINAPI*&gt;
PROCEDURE CreateTapePartition (hDevice          : HANDLE;
                               dwPartitionMethod: DWORD;
                               dwCount          : DWORD;
                               dwSize           : DWORD   ): DWORD;

&lt;*EXTERNAL WriteTapemark:WINAPI*&gt;
PROCEDURE WriteTapemark (hDevice        : HANDLE;
                         dwTapemarkType : DWORD;
                         dwTapemarkCount: DWORD   ): DWORD;

&lt;*EXTERNAL GetTapeStatus:WINAPI*&gt;
PROCEDURE GetTapeStatus (hDevice: HANDLE): DWORD;

&lt;*EXTERNAL GetTapeParameters:WINAPI*&gt;
PROCEDURE GetTapeParameters (hDevice          : HANDLE;
                             dwOperation      : DWORD;
                             lpdwSize         : LPDWORD;
                             lpTapeInformation: LPVOID   ): DWORD;

CONST
  GET_TAPE_MEDIA_INFORMATION = 0;
  GET_TAPE_DRIVE_INFORMATION = 1;

&lt;*EXTERNAL SetTapeParameters:WINAPI*&gt;
PROCEDURE SetTapeParameters (hDevice          : HANDLE;
                             dwOperation      : DWORD;
                             lpTapeInformation: LPVOID  ): DWORD;

CONST
  SET_TAPE_MEDIA_INFORMATION = 0;
  SET_TAPE_DRIVE_INFORMATION = 1;

&lt;*EXTERNAL Beep:WINAPI*&gt;
PROCEDURE Beep (dwFreq: DWORD; dwDuration: DWORD): BOOL;

&lt;*EXTERNAL OpenSound:WINAPI*&gt;
PROCEDURE OpenSound ();

&lt;*EXTERNAL CloseSound:WINAPI*&gt;
PROCEDURE CloseSound ();

&lt;*EXTERNAL StartSound:WINAPI*&gt;
PROCEDURE StartSound ();

&lt;*EXTERNAL StopSound:WINAPI*&gt;
PROCEDURE StopSound ();

&lt;*EXTERNAL WaitSoundState:WINAPI*&gt;
PROCEDURE WaitSoundState (nState: DWORD): DWORD;

&lt;*EXTERNAL SyncAllVoices:WINAPI*&gt;
PROCEDURE SyncAllVoices (): DWORD;

&lt;*EXTERNAL CountVoiceNotes:WINAPI*&gt;
PROCEDURE CountVoiceNotes (nVoice: DWORD): DWORD;

&lt;*EXTERNAL GetThresholdEvent:WINAPI*&gt;
PROCEDURE GetThresholdEvent (): LPDWORD;

&lt;*EXTERNAL GetThresholdStatus:WINAPI*&gt;
PROCEDURE GetThresholdStatus (): DWORD;

&lt;*EXTERNAL SetSoundNoise:WINAPI*&gt;
PROCEDURE SetSoundNoise (nSource: DWORD; nDuration: DWORD): DWORD;

&lt;*EXTERNAL SetVoiceAccent:WINAPI*&gt;
PROCEDURE SetVoiceAccent (nVoice : DWORD;
                          nTempo : DWORD;
                          nVolume: DWORD;
                          nMode  : DWORD;
                          nPitch : DWORD  ): DWORD;

&lt;*EXTERNAL SetVoiceEnvelope:WINAPI*&gt;
PROCEDURE SetVoiceEnvelope (nVoice, nShape, nRepeat: DWORD): DWORD;

&lt;*EXTERNAL SetVoiceNote:WINAPI*&gt;
PROCEDURE SetVoiceNote (nVoice, nValue, nLength, nCdots: DWORD): DWORD;

&lt;*EXTERNAL SetVoiceQueueSize:WINAPI*&gt;
PROCEDURE SetVoiceQueueSize (nVoice: DWORD; nBytes: DWORD): DWORD;

&lt;*EXTERNAL SetVoiceSound:WINAPI*&gt;
PROCEDURE SetVoiceSound (nVoice, Frequency, nDuration: DWORD): DWORD;

&lt;*EXTERNAL SetVoiceThreshold:WINAPI*&gt;
PROCEDURE SetVoiceThreshold (nVoice: DWORD; nNotes: DWORD): DWORD;

&lt;*EXTERNAL MulDiv:WINAPI*&gt;
PROCEDURE MulDiv (nNumber: int; nNumerator: int; nDenominator: int): int;

&lt;*EXTERNAL GetSystemTime:WINAPI*&gt;
PROCEDURE GetSystemTime (lpSystemTime: LPSYSTEMTIME);

&lt;*EXTERNAL SetSystemTime:WINAPI*&gt;
PROCEDURE SetSystemTime (lpSystemTime: LPSYSTEMTIME): BOOL;

&lt;*EXTERNAL GetLocalTime:WINAPI*&gt;
PROCEDURE GetLocalTime (lpSystemTime: LPSYSTEMTIME);

&lt;*EXTERNAL SetLocalTime:WINAPI*&gt;
PROCEDURE SetLocalTime (lpSystemTime: LPSYSTEMTIME): BOOL;

&lt;*EXTERNAL GetSystemInfo:WINAPI*&gt;
PROCEDURE GetSystemInfo (lpSystemInfo: LPSYSTEM_INFO);

TYPE
  PTIME_ZONE_INFORMATION = UNTRACED REF TIME_ZONE_INFORMATION;
  LPTIME_ZONE_INFORMATION = UNTRACED REF TIME_ZONE_INFORMATION;
  TIME_ZONE_INFORMATION = RECORD
    Bias        : LONG;
    StandardName: ARRAY [0 .. 31] OF WCHAR;
    StandardDate: SYSTEMTIME;
    StandardBias: LONG;
    DaylightName: ARRAY [0 .. 31] OF WCHAR;
    DaylightDate: SYSTEMTIME;
    DaylightBias: LONG;
  END;

&lt;*EXTERNAL GetTimeZoneInformation:WINAPI*&gt;
PROCEDURE GetTimeZoneInformation
            (lpTimeZoneInformation: LPTIME_ZONE_INFORMATION): DWORD;

&lt;*EXTERNAL SetTimeZoneInformation:WINAPI*&gt;
PROCEDURE SetTimeZoneInformation
            (lpTimeZoneInformation: LPTIME_ZONE_INFORMATION): BOOL;
</PRE> Routines to convert back and forth between system time and file time 

<P><PRE>&lt;*EXTERNAL SystemTimeToFileTime:WINAPI*&gt;
PROCEDURE SystemTimeToFileTime (lpSystemTime: LPSYSTEMTIME;
                                lpFileTime  : LPFILETIME    ): BOOL;

&lt;*EXTERNAL FileTimeToLocalFileTime:WINAPI*&gt;
PROCEDURE FileTimeToLocalFileTime (lpFileTime     : LPFILETIME;
                                   lpLocalFileTime: LPFILETIME  ): BOOL;

&lt;*EXTERNAL LocalFileTimeToFileTime:WINAPI*&gt;
PROCEDURE LocalFileTimeToFileTime (lpLocalFileTime: LPFILETIME;
                                   lpFileTime     : LPFILETIME  ): BOOL;

&lt;*EXTERNAL FileTimeToSystemTime:WINAPI*&gt;
PROCEDURE FileTimeToSystemTime (lpFileTime  : LPFILETIME;
                                lpSystemTime: LPSYSTEMTIME): BOOL;

&lt;*EXTERNAL CompareFileTime:WINAPI*&gt;
PROCEDURE CompareFileTime (lpFileTime1: LPFILETIME;
                           lpFileTime2: LPFILETIME  ): LONG;

&lt;*EXTERNAL FileTimeToDosDateTime:WINAPI*&gt;
PROCEDURE FileTimeToDosDateTime (lpFileTime: LPFILETIME;
                                 lpFatDate : LPWORD;
                                 lpFatTime : LPWORD      ): BOOL;

&lt;*EXTERNAL DosDateTimeToFileTime:WINAPI*&gt;
PROCEDURE DosDateTimeToFileTime (wFatDate  : WORD;
                                 wFatTime  : WORD;
                                 lpFileTime: LPFILETIME): BOOL;

&lt;*EXTERNAL GetTickCount:WINAPI*&gt;
PROCEDURE GetTickCount (): DWORD;

&lt;*EXTERNAL FormatMessageA:WINAPI*&gt;
PROCEDURE FormatMessageA (dwFlags     : DWORD;
                          lpSource    : LPVOID;
                          dwMessageId : DWORD;
                          dwLanguageId: DWORD;
                          lpBuffer    : LPSTR;
                          nSize       : DWORD;
                          lpArguments : LPVOID  ): DWORD;

&lt;*EXTERNAL FormatMessageW:WINAPI*&gt;
PROCEDURE FormatMessageW (dwFlags     : DWORD;
                          lpSource    : LPVOID;
                          dwMessageId : DWORD;
                          dwLanguageId: DWORD;
                          lpBuffer    : LPWSTR;
                          nSize       : DWORD;
                          lpArguments : LPVOID  ): DWORD;

CONST FormatMessage = FormatMessageA;

CONST
  FORMAT_MESSAGE_ALLOCATE_BUFFER = 16_00000100;
  FORMAT_MESSAGE_IGNORE_INSERTS  = 16_00000200;
  FORMAT_MESSAGE_FROM_STRING     = 16_00000400;
  FORMAT_MESSAGE_FROM_HMODULE    = 16_00000800;
  FORMAT_MESSAGE_FROM_SYSTEM     = 16_00001000;
  FORMAT_MESSAGE_MAX_WIDTH_MASK  = 16_000000FF;

&lt;*EXTERNAL CreatePipe:WINAPI*&gt;
PROCEDURE CreatePipe (hReadPipe       : PHANDLE;
                      hWritePipe      : PHANDLE;
                      lpPipeAttributes: LPSECURITY_ATTRIBUTES;
                      nSize           : DWORD                  ): BOOL;

&lt;*EXTERNAL ConnectNamedPipe:WINAPI*&gt;
PROCEDURE ConnectNamedPipe (hNamedPipe  : HANDLE;
                            lpOverlapped: LPOVERLAPPED): BOOL;

&lt;*EXTERNAL DisconnectNamedPipe:WINAPI*&gt;
PROCEDURE DisconnectNamedPipe (hNamedPipe: HANDLE): BOOL;

&lt;*EXTERNAL SetNamedPipeHandleState:WINAPI*&gt;
PROCEDURE SetNamedPipeHandleState (hNamedPipe          : HANDLE;
                                   lpMode              : LPDWORD;
                                   lpMaxCollectionCount: LPDWORD;
                                   lpCollectDataTimeout: LPDWORD  ): BOOL;

&lt;*EXTERNAL GetNamedPipeInfo:WINAPI*&gt;
PROCEDURE GetNamedPipeInfo (hNamedPipe     : HANDLE;
                            lpFlags        : LPDWORD;
                            lpOutBufferSize: LPDWORD;
                            lpInBufferSize : LPDWORD;
                            lpMaxInstances : LPDWORD  ): BOOL;

&lt;*EXTERNAL PeekNamedPipe:WINAPI*&gt;
PROCEDURE PeekNamedPipe (hNamedPipe            : HANDLE;
                         lpBuffer              : LPVOID;
                         nBufferSize           : DWORD;
                         lpBytesRead           : LPDWORD;
                         lpTotalBytesAvail     : LPDWORD;
                         lpBytesLeftThisMessage: LPDWORD  ): BOOL;

&lt;*EXTERNAL TransactNamedPipe:WINAPI*&gt;
PROCEDURE TransactNamedPipe (hNamedPipe    : HANDLE;
                             lpInBuffer    : LPVOID;
                             nInBufferSize : DWORD;
                             lpOutBuffer   : LPVOID;
                             nOutBufferSize: DWORD;
                             lpBytesRead   : LPDWORD;
                             lpOverlapped  : LPOVERLAPPED): BOOL;

&lt;*EXTERNAL CreateMailslotA:WINAPI*&gt;
PROCEDURE CreateMailslotA (lpName              : LPSTR;
                           nMaxMessageSize     : DWORD;
                           lReadTimeout        : DWORD;
                           lpSecurityAttributes: LPSECURITY_ATTRIBUTES):HANDLE;

&lt;*EXTERNAL CreateMailslotW:WINAPI*&gt;
PROCEDURE CreateMailslotW (lpName              : LPWSTR;
                           nMaxMessageSize     : DWORD;
                           lReadTimeout        : DWORD;
                           lpSecurityAttributes: LPSECURITY_ATTRIBUTES):HANDLE;

CONST CreateMailslot = CreateMailslotA;

&lt;*EXTERNAL GetMailslotInfo:WINAPI*&gt;
PROCEDURE GetMailslotInfo (hMailslot       : HANDLE;
                           lpMaxMessageSize: LPDWORD;
                           lpNextSize      : LPDWORD;
                           lpMessageCount  : LPDWORD;
                           lpReadTimeout   : LPDWORD  ): BOOL;

&lt;*EXTERNAL SetMailslotInfo:WINAPI*&gt;
PROCEDURE SetMailslotInfo (hMailslot: HANDLE; lReadTimeout: DWORD): BOOL;

&lt;*EXTERNAL MapViewOfFile:WINAPI*&gt;
PROCEDURE MapViewOfFile (hFileMappingObject  : HANDLE;
                         dwDesiredAccess     : DWORD;
                         dwFileOffsetHigh    : DWORD;
                         dwFileOffsetLow     : DWORD;
                         dwNumberOfBytesToMap: DWORD   ): LPVOID;

&lt;*EXTERNAL FlushViewOfFile:WINAPI*&gt;
PROCEDURE FlushViewOfFile (lpBaseAddress         : LPVOID;
                           dwNumberOfBytesToFlush: DWORD   ): BOOL;

&lt;*EXTERNAL UnmapViewOfFile:WINAPI*&gt;
PROCEDURE UnmapViewOfFile (lpBaseAddress: LPVOID): BOOL;
</PRE> _l Compat Functions 

<P><PRE>&lt;*EXTERNAL lstrcmpA:WINAPI*&gt;
PROCEDURE lstrcmpA (lpString1: LPCSTR; lpString2: LPCSTR): int;
&lt;*EXTERNAL lstrcmpW:WINAPI*&gt;
PROCEDURE lstrcmpW (lpString1: LPCWSTR; lpString2: LPCWSTR): int;

CONST lstrcmp = lstrcmpA;

&lt;*EXTERNAL lstrcmpiA:WINAPI*&gt;
PROCEDURE lstrcmpiA (lpString1: LPCSTR; lpString2: LPCSTR): int;
&lt;*EXTERNAL lstrcmpiW:WINAPI*&gt;
PROCEDURE lstrcmpiW (lpString1: LPCWSTR; lpString2: LPCWSTR): int;

CONST lstrcmpi = lstrcmpiA;

&lt;*EXTERNAL lstrcpyA:WINAPI*&gt;
PROCEDURE lstrcpyA (lpString1: LPSTR; lpString2: LPCSTR): LPSTR;
&lt;*EXTERNAL lstrcpyW:WINAPI*&gt;
PROCEDURE lstrcpyW (lpString1: LPWSTR; lpString2: LPCWSTR): LPWSTR;

CONST lstrcpy = lstrcpyA;

&lt;*EXTERNAL lstrcatA:WINAPI*&gt;
PROCEDURE lstrcatA (lpString1: LPSTR; lpString2: LPCSTR): LPSTR;
&lt;*EXTERNAL lstrcatW:WINAPI*&gt;
PROCEDURE lstrcatW (lpString1: LPWSTR; lpString2: LPCWSTR): LPWSTR;
CONST lstrcat = lstrcatA;

&lt;*EXTERNAL lstrlenA:WINAPI*&gt;
PROCEDURE lstrlenA (lpString: LPCSTR): int;
&lt;*EXTERNAL lstrlenW:WINAPI*&gt;
PROCEDURE lstrlenW (lpString: LPCWSTR): int;
CONST lstrlen = lstrlenA;

&lt;*EXTERNAL OpenFile:WINAPI*&gt;
PROCEDURE OpenFile (lpFileName  : LPCSTR;
                    lpReOpenBuff: LPOFSTRUCT;
                    uStyle      : UINT        ): HFILE;

&lt;*EXTERNAL &quot;_lopen&quot;:WINAPI*&gt;
PROCEDURE lopen (lpPathName: LPCSTR; iReadWrite: int): HFILE;

&lt;*EXTERNAL &quot;_lcreat&quot;:WINAPI*&gt;
PROCEDURE lcreat (lpPathName: LPCSTR; iAttribute: int): HFILE;

&lt;*EXTERNAL &quot;_lread&quot;:WINAPI*&gt;
PROCEDURE lread (hFile: HFILE; lpBuffer: LPVOID; uBytes: UINT): UINT;

&lt;*EXTERNAL &quot;_lwrite&quot;:WINAPI*&gt;
PROCEDURE lwrite (hFile: HFILE; lpBuffer: LPCSTR; uBytes: UINT): UINT;

&lt;*EXTERNAL &quot;_lclose&quot;:WINAPI*&gt;
PROCEDURE lclose (hFile: HFILE): HFILE;

&lt;*EXTERNAL &quot;_llseek&quot;:WINAPI*&gt;
PROCEDURE llseek (hFile: HFILE; lOffset: LONG; iOrigin: int): LONG;

&lt;*EXTERNAL TlsAlloc:WINAPI*&gt;
PROCEDURE TlsAlloc (): DWORD;

&lt;*EXTERNAL TlsGetValue:WINAPI*&gt;
PROCEDURE TlsGetValue (dwTlsIndex: DWORD): LPVOID;

&lt;*EXTERNAL TlsSetValue:WINAPI*&gt;
PROCEDURE TlsSetValue (dwTlsIndex: DWORD; lpTlsValue: LPVOID): BOOL;

&lt;*EXTERNAL TlsFree:WINAPI*&gt;
PROCEDURE TlsFree (dwTlsIndex: DWORD): BOOL;

TYPE
  LPOVERLAPPED_COMPLETION_ROUTINE =
    &lt;*WINAPI*&gt; PROCEDURE (dwErrorCode              : DWORD;
                          dwNumberOfBytesTransfered: DWORD;
                          lpOverlapped             : LPOVERLAPPED);

&lt;*EXTERNAL SleepEx:WINAPI*&gt;
PROCEDURE SleepEx (dwMilliseconds: DWORD; bAlertable: BOOL): DWORD;

&lt;*EXTERNAL WaitForSingleObjectEx:WINAPI*&gt;
PROCEDURE WaitForSingleObjectEx (hHandle       : HANDLE;
                                 dwMilliseconds: DWORD;
                                 bAlertable    : BOOL    ): DWORD;

&lt;*EXTERNAL WaitForMultipleObjectsEx:WINAPI*&gt;
PROCEDURE WaitForMultipleObjectsEx (nCount        : DWORD;
                                    lpHandles     : LPHANDLE;
                                    bWaitAll      : BOOL;
                                    dwMilliseconds: DWORD;
                                      bAlertable    : BOOL      ): DWORD;

&lt;*EXTERNAL ReadFileEx:WINAPI*&gt;
PROCEDURE ReadFileEx (hFile               : HANDLE;
                      lpBuffer            : LPVOID;
                      nNumberOfBytesToRead: DWORD;
                      lpOverlapped        : LPOVERLAPPED;
                      lpCompletionRoutine : LPOVERLAPPED_COMPLETION_ROUTINE): BOOL;

&lt;*EXTERNAL WriteFileEx:WINAPI*&gt;
PROCEDURE WriteFileEx (hFile                : HANDLE;
                       lpBuffer             : LPVOID;
                       nNumberOfBytesToWrite: DWORD;
                       lpOverlapped         : LPOVERLAPPED;
                       lpCompletionRoutine: LPOVERLAPPED_COMPLETION_ROUTINE): BOOL;

&lt;*EXTERNAL BackupRead:WINAPI*&gt;
PROCEDURE BackupRead (hFile               : HANDLE;
                      lpBuffer            : LPBYTE;
                      nNumberOfBytesToRead: DWORD;
                      lpNumberOfBytesRead : LPDWORD;
                      bAbort              : BOOL;
                      bProcessSecurity    : BOOL;
                      lpContext           : UNTRACED REF LPVOID; ): BOOL;

&lt;*EXTERNAL BackupWrite:WINAPI*&gt;
PROCEDURE BackupWrite (hFile                 : HANDLE;
                       lpBuffer              : LPBYTE;
                       nNumberOfBytesToWrite : DWORD;
                       lpNumberOfBytesWritten: LPDWORD;
                       bAbort                : BOOL;
                       bProcessSecurity      : BOOL;
                       lpContext             : UNTRACED REF LPVOID; ): BOOL;
</PRE> Dual Mode API below this line.  Dual Mode Structures also included. 

<P><PRE>CONST
  STARTF_USESHOWWINDOW    = 16_00000001;
  STARTF_USESIZE          = 16_00000002;
  STARTF_USEPOSITION      = 16_00000004;
  STARTF_USECOUNTCHARS    = 16_00000008;
  STARTF_USEFILLATTRIBUTE = 16_00000010;
  STARTF_RUNFULLSCREEN    = 16_00000020; (* ignored for non-x86 platforms *)
  STARTF_FORCEONFEEDBACK  = 16_00000040;
  STARTF_FORCEOFFFEEDBACK = 16_00000080;
  STARTF_USESTDHANDLES    = 16_00000100;

TYPE
  LPSTARTUPINFOA = UNTRACED REF STARTUPINFOA;
  STARTUPINFOA = RECORD
    cb             : DWORD;
    lpReserved     : LPSTR;
    lpDesktop      : LPSTR;
    lpTitle        : LPSTR;
    dwX            : DWORD;
    dwY            : DWORD;
    dwXSize        : DWORD;
    dwYSize        : DWORD;
    dwXCountChars  : DWORD;
    dwYCountChars  : DWORD;
    dwFillAttribute: DWORD;
    dwFlags        : DWORD;
    wShowWindow    : WORD;
    cbReserved2    : WORD;
    lpReserved2    : LPBYTE;
    hStdInput      : HANDLE;
    hStdOutput     : HANDLE;
    hStdError      : HANDLE;
  END;

  LPSTARTUPINFOW = UNTRACED REF STARTUPINFOW;
  STARTUPINFOW = RECORD
    cb             : DWORD;
    lpReserved     : LPWSTR;
    lpDesktop      : LPWSTR;
    lpTitle        : LPWSTR;
    dwX            : DWORD;
    dwY            : DWORD;
    dwXSize        : DWORD;
    dwYSize        : DWORD;
    dwXCountChars  : DWORD;
    dwYCountChars  : DWORD;
    dwFillAttribute: DWORD;
    dwFlags        : DWORD;
    wShowWindow    : WORD;
    cbReserved2    : WORD;
    lpReserved2    : LPBYTE;
    hStdInput      : HANDLE;
    hStdOutput     : HANDLE;
    hStdError      : HANDLE;
  END;

  STARTUPINFO   = STARTUPINFOA;
  LPSTARTUPINFO = LPSTARTUPINFOA;

CONST SHUTDOWN_NORETRY = 16_00000001;

TYPE
  PWIN32_FIND_DATAA = UNTRACED REF WIN32_FIND_DATAA;
  LPWIN32_FIND_DATAA = UNTRACED REF WIN32_FIND_DATAA;
  WIN32_FIND_DATAA = RECORD
    dwFileAttributes  : DWORD;
    ftCreationTime    : FILETIME;
    ftLastAccessTime  : FILETIME;
    ftLastWriteTime   : FILETIME;
    nFileSizeHigh     : DWORD;
    nFileSizeLow      : DWORD;
    dwReserved0       : DWORD;
    dwReserved1       : DWORD;
    cFileName         : ARRAY [0 .. MAX_PATH - 1] OF CHAR;
    cAlternateFileName: ARRAY [0 .. 14 - 1] OF CHAR;
  END;

  PWIN32_FIND_DATAW = UNTRACED REF WIN32_FIND_DATAW;
  LPWIN32_FIND_DATAW = UNTRACED REF WIN32_FIND_DATAW;
  WIN32_FIND_DATAW = RECORD
    dwFileAttributes  : DWORD;
    ftCreationTime    : FILETIME;
    ftLastAccessTime  : FILETIME;
    ftLastWriteTime   : FILETIME;
    nFileSizeHigh     : DWORD;
    nFileSizeLow      : DWORD;
    dwReserved0       : DWORD;
    dwReserved1       : DWORD;
    cFileName         : ARRAY [0 .. MAX_PATH - 1] OF WCHAR;
    cAlternateFileName: ARRAY [0 .. 14 - 1] OF WCHAR;
  END;

  WIN32_FIND_DATA   = WIN32_FIND_DATAA;
  PWIN32_FIND_DATA  = PWIN32_FIND_DATAA;
  LPWIN32_FIND_DATA = LPWIN32_FIND_DATAA;

&lt;*EXTERNAL CreateMutexA:WINAPI*&gt;
PROCEDURE CreateMutexA (lpMutexAttributes: LPSECURITY_ATTRIBUTES;
                        bInitialOwner    : BOOL;
                        lpName           : LPSTR                  ): HANDLE;

&lt;*EXTERNAL CreateMutexW:WINAPI*&gt;
PROCEDURE CreateMutexW (lpMutexAttributes: LPSECURITY_ATTRIBUTES;
                        bInitialOwner    : BOOL;
                        lpName           : LPWSTR                 ): HANDLE;

CONST CreateMutex = CreateMutexA;

&lt;*EXTERNAL OpenMutexA:WINAPI*&gt;
PROCEDURE OpenMutexA (dwDesiredAccess: DWORD;
                      bInheritHandle : BOOL;
                      lpName         : LPSTR  ): HANDLE;

&lt;*EXTERNAL OpenMutexW:WINAPI*&gt;
PROCEDURE OpenMutexW (dwDesiredAccess: DWORD;
                      bInheritHandle : BOOL;
                      lpName         : LPWSTR ): HANDLE;

CONST OpenMutex = OpenMutexA;

&lt;*EXTERNAL CreateEventA:WINAPI*&gt;
PROCEDURE CreateEventA (lpEventAttributes: LPSECURITY_ATTRIBUTES;
                        bManualReset     : BOOL;
                        bInitialState    : BOOL;
                        lpName           : LPSTR                  ): HANDLE;

&lt;*EXTERNAL CreateEventW:WINAPI*&gt;
PROCEDURE CreateEventW (lpEventAttributes: LPSECURITY_ATTRIBUTES;
                        bManualReset     : BOOL;
                        bInitialState    : BOOL;
                        lpName           : LPWSTR                 ): HANDLE;

CONST CreateEvent = CreateEventA;

&lt;*EXTERNAL OpenEventA:WINAPI*&gt;
PROCEDURE OpenEventA (dwDesiredAccess: DWORD;
                      bInheritHandle : BOOL;
                      lpName         : LPSTR  ): HANDLE;

&lt;*EXTERNAL OpenEventW:WINAPI*&gt;
PROCEDURE OpenEventW (dwDesiredAccess: DWORD;
                      bInheritHandle : BOOL;
                      lpName         : LPWSTR ): HANDLE;

CONST OpenEvent = OpenEventA;

&lt;*EXTERNAL CreateSemaphoreA:WINAPI*&gt;
PROCEDURE CreateSemaphoreA (lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES;
                            lInitialCount: LONG;
                            lMaximumCount: LONG;
                            lpName       : LPSTR ): HANDLE;

&lt;*EXTERNAL CreateSemaphoreW:WINAPI*&gt;
PROCEDURE CreateSemaphoreW (lpSemaphoreAttributes: LPSECURITY_ATTRIBUTES;
                            lInitialCount: LONG;
                            lMaximumCount: LONG;
                            lpName       : LPWSTR): HANDLE;

CONST CreateSemaphore = CreateSemaphoreA;

&lt;*EXTERNAL OpenSemaphoreA:WINAPI*&gt;
PROCEDURE OpenSemaphoreA (dwDesiredAccess: DWORD;
                          bInheritHandle : BOOL;
                          lpName         : LPSTR  ): HANDLE;

&lt;*EXTERNAL OpenSemaphoreW:WINAPI*&gt;
PROCEDURE OpenSemaphoreW (dwDesiredAccess: DWORD;
                          bInheritHandle : BOOL;
                          lpName         : LPWSTR ): HANDLE;

CONST OpenSemaphore = OpenSemaphoreA;

&lt;*EXTERNAL CreateFileMappingA:WINAPI*&gt;
PROCEDURE CreateFileMappingA (hFile: HANDLE;
                              lpFileMappingAttributes: LPSECURITY_ATTRIBUTES;
                              flProtect        : DWORD;
                              dwMaximumSizeHigh: DWORD;
                              dwMaximumSizeLow : DWORD;
                              lpName           : LPSTR  ): HANDLE;

&lt;*EXTERNAL CreateFileMappingW:WINAPI*&gt;
PROCEDURE CreateFileMappingW (hFile: HANDLE;
                              lpFileMappingAttributes: LPSECURITY_ATTRIBUTES;
                              flProtect        : DWORD;
                              dwMaximumSizeHigh: DWORD;
                              dwMaximumSizeLow : DWORD;
                              lpName           : LPWSTR ): HANDLE;

CONST CreateFileMapping = CreateFileMappingA;

&lt;*EXTERNAL OpenFileMappingA:WINAPI*&gt;
PROCEDURE OpenFileMappingA (dwDesiredAccess: DWORD;
                            bInheritHandle : BOOL;
                            lpName         : LPSTR  ): HANDLE;

&lt;*EXTERNAL OpenFileMappingW:WINAPI*&gt;
PROCEDURE OpenFileMappingW (dwDesiredAccess: DWORD;
                            bInheritHandle : BOOL;
                            lpName         : LPWSTR ): HANDLE;

CONST OpenFileMapping = OpenFileMappingA;

&lt;*EXTERNAL GetLogicalDriveStringsA:WINAPI*&gt;
PROCEDURE GetLogicalDriveStringsA(nBufferLength: DWORD; lpBuffer: LPSTR):DWORD;

&lt;*EXTERNAL GetLogicalDriveStringsW:WINAPI*&gt;
PROCEDURE GetLogicalDriveStringsW(nBufferLength: DWORD; lpBuffer:LPWSTR):DWORD;

CONST GetLogicalDriveStrings = GetLogicalDriveStringsA;

&lt;*EXTERNAL LoadLibraryA:WINAPI*&gt;
PROCEDURE LoadLibraryA (lpLibFileName: LPCSTR): HINSTANCE;

&lt;*EXTERNAL LoadLibraryW:WINAPI*&gt;
PROCEDURE LoadLibraryW (lpLibFileName: LPCWSTR): HINSTANCE;

CONST LoadLibrary = LoadLibraryA;

&lt;*EXTERNAL LoadLibraryExA:WINAPI*&gt;
PROCEDURE LoadLibraryExA (lpLibFileName: LPCSTR;
                          hFile        : HANDLE;
                          dwFlags      : DWORD   ): HINSTANCE;

&lt;*EXTERNAL LoadLibraryExW:WINAPI*&gt;
PROCEDURE LoadLibraryExW (lpLibFileName: LPCWSTR;
                          hFile        : HANDLE;
                          dwFlags      : DWORD    ): HINSTANCE;

CONST LoadLibraryEx = LoadLibraryExA;

CONST DONT_RESOLVE_DLL_REFERENCES = 16_00000001;

&lt;*EXTERNAL GetModuleFileNameA:WINAPI*&gt;
PROCEDURE GetModuleFileNameA (hModule   : HINSTANCE;
                              lpFilename: LPSTR;
                              nSize     : DWORD      ): DWORD;

&lt;*EXTERNAL GetModuleFileNameW:WINAPI*&gt;
PROCEDURE GetModuleFileNameW (hModule   : HINSTANCE;
                              lpFilename: LPWSTR;
                              nSize     : DWORD      ): DWORD;

CONST GetModuleFileName = GetModuleFileNameA;

&lt;*EXTERNAL GetModuleHandleA:WINAPI*&gt;
PROCEDURE GetModuleHandleA (lpModuleName: LPCSTR): HMODULE;

&lt;*EXTERNAL GetModuleHandleW:WINAPI*&gt;
PROCEDURE GetModuleHandleW (lpModuleName: LPCWSTR): HMODULE;

CONST GetModuleHandle = GetModuleHandleA;

&lt;*EXTERNAL CreateProcessA:WINAPI*&gt;
PROCEDURE CreateProcessA (lpApplicationName   : LPCSTR;
                          lpCommandLine       : LPCSTR;
                          lpProcessAttributes : LPSECURITY_ATTRIBUTES;
                          lpThreadAttributes  : LPSECURITY_ATTRIBUTES;
                          bInheritHandles     : BOOL;
                          dwCreationFlags     : DWORD;
                          lpEnvironment       : LPVOID;
                          lpCurrentDirectory  : LPSTR;
                          lpStartupInfo       : LPSTARTUPINFOA;
                          lpProcessInformation: LPPROCESS_INFORMATION  ): BOOL;

&lt;*EXTERNAL CreateProcessW:WINAPI*&gt;
PROCEDURE CreateProcessW (lpApplicationName   : LPCWSTR;
                          lpCommandLine       : LPCWSTR;
                          lpProcessAttributes : LPSECURITY_ATTRIBUTES;
                          lpThreadAttributes  : LPSECURITY_ATTRIBUTES;
                          bInheritHandles     : BOOL;
                          dwCreationFlags     : DWORD;
                          lpEnvironment       : LPVOID;
                          lpCurrentDirectory  : LPWSTR;
                          lpStartupInfo       : LPSTARTUPINFOW;
                          lpProcessInformation: LPPROCESS_INFORMATION  ): BOOL;

CONST CreateProcess = CreateProcessA;

&lt;*EXTERNAL SetProcessShutdownParameters:WINAPI*&gt;
PROCEDURE SetProcessShutdownParameters (dwLevel: DWORD; dwFlags: DWORD): BOOL;

&lt;*EXTERNAL GetProcessShutdownParameters:WINAPI*&gt;
PROCEDURE GetProcessShutdownParameters (lpdwLevel: LPDWORD;
                                        lpdwFlags: LPDWORD  ): BOOL;

&lt;*EXTERNAL FatalAppExitA:WINAPI*&gt;
PROCEDURE FatalAppExitA (uAction: UINT; lpMessageText: LPCSTR);

&lt;*EXTERNAL FatalAppExitW:WINAPI*&gt;
PROCEDURE FatalAppExitW (uAction: UINT; lpMessageText: LPCWSTR);

CONST FatalAppExit = FatalAppExitA;

&lt;*EXTERNAL GetStartupInfoA:WINAPI*&gt;
PROCEDURE GetStartupInfoA (lpStartupInfo: LPSTARTUPINFOA);

&lt;*EXTERNAL GetStartupInfoW:WINAPI*&gt;
PROCEDURE GetStartupInfoW (lpStartupInfo: LPSTARTUPINFOW);

CONST GetStartupInfo = GetStartupInfoA;

&lt;*EXTERNAL GetCommandLineA:WINAPI*&gt;
PROCEDURE GetCommandLineA (): LPSTR;

&lt;*EXTERNAL GetCommandLineW:WINAPI*&gt;
PROCEDURE GetCommandLineW (): LPWSTR;

CONST GetCommandLine = GetCommandLineA;

&lt;*EXTERNAL GetEnvironmentVariableA:WINAPI*&gt;
PROCEDURE GetEnvironmentVariableA (lpName  : LPSTR;
                                   lpBuffer: LPSTR;
                                   nSize   : DWORD  ): DWORD;

&lt;*EXTERNAL GetEnvironmentVariableW:WINAPI*&gt;
PROCEDURE GetEnvironmentVariableW (lpName  : LPWSTR;
                                   lpBuffer: LPWSTR;
                                   nSize   : DWORD   ): DWORD;

CONST GetEnvironmentVariable = GetEnvironmentVariableA;

&lt;*EXTERNAL SetEnvironmentVariableA:WINAPI*&gt;
PROCEDURE SetEnvironmentVariableA (lpName: LPSTR; lpValue: LPSTR): BOOL;

&lt;*EXTERNAL SetEnvironmentVariableW:WINAPI*&gt;
PROCEDURE SetEnvironmentVariableW (lpName: LPWSTR; lpValue: LPWSTR): BOOL;

CONST SetEnvironmentVariable = SetEnvironmentVariableA;

&lt;*EXTERNAL ExpandEnvironmentStringsA:WINAPI*&gt;
PROCEDURE ExpandEnvironmentStringsA (lpSrc: LPCSTR;
                                     lpDst: LPSTR;
                                     nSize: DWORD   ): DWORD;

&lt;*EXTERNAL ExpandEnvironmentStringsW:WINAPI*&gt;
PROCEDURE ExpandEnvironmentStringsW (lpSrc: LPCWSTR;
                                     lpDst: LPWSTR;
                                     nSize: DWORD    ): DWORD;

CONST ExpandEnvironmentStrings = ExpandEnvironmentStringsA;

&lt;*EXTERNAL OutputDebugStringA:WINAPI*&gt;
PROCEDURE OutputDebugStringA (lpOutputString: LPCSTR);

&lt;*EXTERNAL OutputDebugStringW:WINAPI*&gt;
PROCEDURE OutputDebugStringW (lpOutputString: LPCWSTR);

CONST OutputDebugString = OutputDebugStringA;

&lt;*EXTERNAL FindResourceA:WINAPI*&gt;
PROCEDURE FindResourceA (hModule: HINSTANCE;
                         lpName : LPCSTR;
                         lpType : LPCSTR     ): HRSRC;

&lt;*EXTERNAL FindResourceW:WINAPI*&gt;
PROCEDURE FindResourceW (hModule: HINSTANCE;
                         lpName : LPCWSTR;
                         lpType : LPCWSTR    ): HRSRC;

CONST FindResource = FindResourceA;

&lt;*EXTERNAL FindResourceExA:WINAPI*&gt;
PROCEDURE FindResourceExA (hModule  : HINSTANCE;
                           lpType   : LPCSTR;
                           lpName   : LPCSTR;
                           wLanguage: WORD       ): HRSRC;

&lt;*EXTERNAL FindResourceExW:WINAPI*&gt;
PROCEDURE FindResourceExW (hModule  : HINSTANCE;
                           lpType   : LPCWSTR;
                           lpName   : LPCWSTR;
                           wLanguage: WORD       ): HRSRC;

CONST FindResourceEx = FindResourceExA;

TYPE
  ENUMRESTYPEPROC = &lt;*CALLBACK*&gt; PROCEDURE (hModule: HINSTANCE;
                                            lpType : LPTSTR;
                                            lParam : LONG      ): BOOL;

  ENUMRESNAMEPROC = &lt;*CALLBACK*&gt; PROCEDURE (hModule: HINSTANCE;
                                            lpType : LPCTSTR;
                                            lpName : LPTSTR;
                                            lParam : LONG      ): BOOL;

  ENUMRESLANGPROC = &lt;*CALLBACK*&gt; PROCEDURE (hModule  : HINSTANCE;
                                            lpType   : LPCTSTR;
                                            lpName   : LPCTSTR;
                                            wLanguage: WORD;
                                            lParam   : LONG       ): BOOL;

&lt;*EXTERNAL EnumResourceTypesA:WINAPI*&gt;
PROCEDURE EnumResourceTypesA (hModule   : HINSTANCE;
                              lpEnumFunc: ENUMRESTYPEPROC;
                              lParam    : LONG             ): BOOL;

&lt;*EXTERNAL EnumResourceTypesW:WINAPI*&gt;
PROCEDURE EnumResourceTypesW (hModule   : HINSTANCE;
                              lpEnumFunc: ENUMRESTYPEPROC;
                              lParam    : LONG             ): BOOL;

CONST EnumResourceTypes = EnumResourceTypesA;

&lt;*EXTERNAL EnumResourceNamesA:WINAPI*&gt;
PROCEDURE EnumResourceNamesA (hModule   : HINSTANCE;
                              lpType    : LPCSTR;
                              lpEnumFunc: ENUMRESNAMEPROC;
                              lParam    : LONG             ): BOOL;

&lt;*EXTERNAL EnumResourceNamesW:WINAPI*&gt;
PROCEDURE EnumResourceNamesW (hModule   : HINSTANCE;
                              lpType    : LPCWSTR;
                              lpEnumFunc: ENUMRESNAMEPROC;
                              lParam    : LONG             ): BOOL;

CONST EnumResourceNames = EnumResourceNamesA;

&lt;*EXTERNAL EnumResourceLanguagesA:WINAPI*&gt;
PROCEDURE EnumResourceLanguagesA (hModule   : HINSTANCE;
                                  lpType    : LPCSTR;
                                  lpName    : LPCSTR;
                                  lpEnumFunc: ENUMRESLANGPROC;
                                  lParam    : LONG             ): BOOL;

&lt;*EXTERNAL EnumResourceLanguagesW:WINAPI*&gt;
PROCEDURE EnumResourceLanguagesW (hModule   : HINSTANCE;
                                  lpType    : LPCWSTR;
                                  lpName    : LPCWSTR;
                                  lpEnumFunc: ENUMRESLANGPROC;
                                  lParam    : LONG             ): BOOL;

CONST EnumResourceLanguages = EnumResourceLanguagesA;

&lt;*EXTERNAL BeginUpdateResourceA:WINAPI*&gt;
PROCEDURE BeginUpdateResourceA (pFileName               : LPSTR;
                                bDeleteExistingResources: BOOL   ): HANDLE;

&lt;*EXTERNAL BeginUpdateResourceW:WINAPI*&gt;
PROCEDURE BeginUpdateResourceW (pFileName               : LPWSTR;
                                bDeleteExistingResources: BOOL    ): HANDLE;

CONST BeginUpdateResource = BeginUpdateResourceA;

&lt;*EXTERNAL UpdateResourceA:WINAPI*&gt;
PROCEDURE UpdateResourceA (hUpdate  : HANDLE;
                           lpType   : LPSTR;
                           lpName   : LPSTR;
                           wLanguage: WORD;
                           lpData   : LPVOID;
                           cbData   : DWORD   ): BOOL;

&lt;*EXTERNAL UpdateResourceW:WINAPI*&gt;
PROCEDURE UpdateResourceW (hUpdate  : HANDLE;
                           lpType   : LPWSTR;
                           lpName   : LPWSTR;
                           wLanguage: WORD;
                           lpData   : LPVOID;
                           cbData   : DWORD   ): BOOL;

CONST UpdateResource = UpdateResourceA;

&lt;*EXTERNAL EndUpdateResourceA:WINAPI*&gt;
PROCEDURE EndUpdateResourceA (hUpdate: HANDLE; fDiscard: BOOL): BOOL;

&lt;*EXTERNAL EndUpdateResourceW:WINAPI*&gt;
PROCEDURE EndUpdateResourceW (hUpdate: HANDLE; fDiscard: BOOL): BOOL;

CONST EndUpdateResource = EndUpdateResourceA;

&lt;*EXTERNAL GlobalAddAtomA:WINAPI*&gt;
PROCEDURE GlobalAddAtomA (lpString: LPCSTR): ATOM;

&lt;*EXTERNAL GlobalAddAtomW:WINAPI*&gt;
PROCEDURE GlobalAddAtomW (lpString: LPCWSTR): ATOM;

CONST GlobalAddAtom = GlobalAddAtomA;

&lt;*EXTERNAL GlobalFindAtomA:WINAPI*&gt;
PROCEDURE GlobalFindAtomA (lpString: LPCSTR): ATOM;

&lt;*EXTERNAL GlobalFindAtomW:WINAPI*&gt;
PROCEDURE GlobalFindAtomW (lpString: LPCWSTR): ATOM;

CONST GlobalFindAtom = GlobalFindAtomA;

&lt;*EXTERNAL GlobalGetAtomNameA:WINAPI*&gt;
PROCEDURE GlobalGetAtomNameA (nAtom: ATOM; lpBuffer: LPSTR; nSize: int): UINT;

&lt;*EXTERNAL GlobalGetAtomNameW:WINAPI*&gt;
PROCEDURE GlobalGetAtomNameW (nAtom: ATOM; lpBuffer: LPWSTR; nSize: int): UINT;

CONST GlobalGetAtomName = GlobalGetAtomNameA;

&lt;*EXTERNAL AddAtomA:WINAPI*&gt;
PROCEDURE AddAtomA (lpString: LPCSTR): ATOM;

&lt;*EXTERNAL AddAtomW:WINAPI*&gt;
PROCEDURE AddAtomW (lpString: LPCWSTR): ATOM;

CONST AddAtom = AddAtomA;

&lt;*EXTERNAL FindAtomA:WINAPI*&gt;
PROCEDURE FindAtomA (lpString: LPCSTR): ATOM;

&lt;*EXTERNAL FindAtomW:WINAPI*&gt;
PROCEDURE FindAtomW (lpString: LPCWSTR): ATOM;

CONST FindAtom = FindAtomA;

&lt;*EXTERNAL GetAtomNameA:WINAPI*&gt;
PROCEDURE GetAtomNameA (nAtom: ATOM; lpBuffer: LPSTR; nSize: int): UINT;

&lt;*EXTERNAL GetAtomNameW:WINAPI*&gt;
PROCEDURE GetAtomNameW (nAtom: ATOM; lpBuffer: LPWSTR; nSize: int): UINT;

CONST GetAtomName = GetAtomNameA;

&lt;*EXTERNAL GetProfileIntA:WINAPI*&gt;
PROCEDURE GetProfileIntA (lpAppName: LPCSTR;
                          lpKeyName: LPCSTR;
                          nDefault : DWORD   ): UINT;

&lt;*EXTERNAL GetProfileIntW:WINAPI*&gt;
PROCEDURE GetProfileIntW (lpAppName: LPCWSTR;
                          lpKeyName: LPCWSTR;
                          nDefault : DWORD    ): UINT;

CONST GetProfileInt = GetProfileIntA;

&lt;*EXTERNAL GetProfileStringA:WINAPI*&gt;
PROCEDURE GetProfileStringA (lpAppName       : LPCSTR;
                             lpKeyName       : LPCSTR;
                             lpDefault       : LPCSTR;
                             lpReturnedString: LPSTR;
                             nSize           : DWORD   ): DWORD;

&lt;*EXTERNAL GetProfileStringW:WINAPI*&gt;
PROCEDURE GetProfileStringW (lpAppName       : LPCWSTR;
                             lpKeyName       : LPCWSTR;
                             lpDefault       : LPCWSTR;
                             lpReturnedString: LPWSTR;
                             nSize           : DWORD    ): DWORD;

CONST GetProfileString = GetProfileStringA;

&lt;*EXTERNAL WriteProfileStringA:WINAPI*&gt;
PROCEDURE WriteProfileStringA (lpAppName: LPCSTR;
                               lpKeyName: LPCSTR;
                               lpString : LPCSTR  ): BOOL;

&lt;*EXTERNAL WriteProfileStringW:WINAPI*&gt;
PROCEDURE WriteProfileStringW (lpAppName: LPCWSTR;
                               lpKeyName: LPCWSTR;
                               lpString : LPCWSTR  ): BOOL;

CONST WriteProfileString = WriteProfileStringA;

&lt;*EXTERNAL GetProfileSectionA:WINAPI*&gt;
PROCEDURE GetProfileSectionA (lpAppName       : LPCSTR;
                              lpReturnedString: LPSTR;
                              nSize           : DWORD   ): DWORD;

&lt;*EXTERNAL GetProfileSectionW:WINAPI*&gt;
PROCEDURE GetProfileSectionW (lpAppName       : LPCWSTR;
                              lpReturnedString: LPWSTR;
                              nSize           : DWORD    ): DWORD;

CONST GetProfileSection = GetProfileSectionA;

&lt;*EXTERNAL WriteProfileSectionA:WINAPI*&gt;
PROCEDURE WriteProfileSectionA (lpAppName: LPCSTR; lpString: LPCSTR): BOOL;

&lt;*EXTERNAL WriteProfileSectionW:WINAPI*&gt;
PROCEDURE WriteProfileSectionW (lpAppName: LPCWSTR; lpString: LPCWSTR): BOOL;

CONST WriteProfileSection = WriteProfileSectionA;

&lt;*EXTERNAL GetPrivateProfileIntA:WINAPI*&gt;
PROCEDURE GetPrivateProfileIntA (lpAppName : LPCSTR;
                                 lpKeyName : LPCSTR;
                                 nDefault  : DWORD;
                                 lpFileName: LPCSTR  ): UINT;

&lt;*EXTERNAL GetPrivateProfileIntW:WINAPI*&gt;
PROCEDURE GetPrivateProfileIntW (lpAppName : LPCWSTR;
                                 lpKeyName : LPCWSTR;
                                 nDefault  : DWORD;
                                 lpFileName: LPCWSTR  ): UINT;

CONST GetPrivateProfileInt = GetPrivateProfileIntA;

&lt;*EXTERNAL GetPrivateProfileStringA:WINAPI*&gt;
PROCEDURE GetPrivateProfileStringA (lpAppName       : LPCSTR;
                                    lpKeyName       : LPCSTR;
                                    lpDefault       : LPCSTR;
                                    lpReturnedString: LPSTR;
                                    nSize           : DWORD;
                                    lpFileName      : LPCSTR  ): DWORD;

&lt;*EXTERNAL GetPrivateProfileStringW:WINAPI*&gt;
PROCEDURE GetPrivateProfileStringW (lpAppName       : LPCWSTR;
                                    lpKeyName       : LPCWSTR;
                                    lpDefault       : LPCWSTR;
                                    lpReturnedString: LPWSTR;
                                    nSize           : DWORD;
                                    lpFileName      : LPCWSTR  ): DWORD;

CONST GetPrivateProfileString = GetPrivateProfileStringA;

&lt;*EXTERNAL WritePrivateProfileStringA:WINAPI*&gt;
PROCEDURE WritePrivateProfileStringA (lpAppName : LPCSTR;
                                      lpKeyName : LPCSTR;
                                      lpString  : LPCSTR;
                                      lpFileName: LPCSTR  ): BOOL;

&lt;*EXTERNAL WritePrivateProfileStringW:WINAPI*&gt;
PROCEDURE WritePrivateProfileStringW (lpAppName : LPCWSTR;
                                      lpKeyName : LPCWSTR;
                                      lpString  : LPCWSTR;
                                      lpFileName: LPCWSTR  ): BOOL;

CONST WritePrivateProfileString = WritePrivateProfileStringA;

&lt;*EXTERNAL GetPrivateProfileSectionA:WINAPI*&gt;
PROCEDURE GetPrivateProfileSectionA (lpAppName       : LPCSTR;
                                     lpReturnedString: LPSTR;
                                     nSize           : DWORD;
                                     lpFileName      : LPCSTR  ): DWORD;

&lt;*EXTERNAL GetPrivateProfileSectionW:WINAPI*&gt;
PROCEDURE GetPrivateProfileSectionW (lpAppName       : LPCWSTR;
                                     lpReturnedString: LPWSTR;
                                     nSize           : DWORD;
                                     lpFileName      : LPCWSTR  ): DWORD;

CONST GetPrivateProfileSection = GetPrivateProfileSectionA;

&lt;*EXTERNAL WritePrivateProfileSectionA:WINAPI*&gt;
PROCEDURE WritePrivateProfileSectionA (lpAppName : LPCSTR;
                                       lpString  : LPCSTR;
                                       lpFileName: LPCSTR  ): BOOL;

&lt;*EXTERNAL WritePrivateProfileSectionW:WINAPI*&gt;
PROCEDURE WritePrivateProfileSectionW (lpAppName : LPCWSTR;
                                       lpString  : LPCWSTR;
                                       lpFileName: LPCWSTR  ): BOOL;

CONST WritePrivateProfileSection = WritePrivateProfileSectionA;

&lt;*EXTERNAL GetDriveTypeA:WINAPI*&gt;
PROCEDURE GetDriveTypeA (lpRootPathName: LPSTR): UINT;

&lt;*EXTERNAL GetDriveTypeW:WINAPI*&gt;
PROCEDURE GetDriveTypeW (lpRootPathName: LPWSTR): UINT;

CONST GetDriveType = GetDriveTypeA;

&lt;*EXTERNAL GetSystemDirectoryA:WINAPI*&gt;
PROCEDURE GetSystemDirectoryA (lpBuffer: LPSTR; uSize: UINT): UINT;

&lt;*EXTERNAL GetSystemDirectoryW:WINAPI*&gt;
PROCEDURE GetSystemDirectoryW (lpBuffer: LPWSTR; uSize: UINT): UINT;

CONST GetSystemDirectory = GetSystemDirectoryA;

&lt;*EXTERNAL GetTempPathA:WINAPI*&gt;
PROCEDURE GetTempPathA (nBufferLength: DWORD; lpBuffer: LPSTR): DWORD;

&lt;*EXTERNAL GetTempPathW:WINAPI*&gt;
PROCEDURE GetTempPathW (nBufferLength: DWORD; lpBuffer: LPWSTR): DWORD;

CONST GetTempPath = GetTempPathA;

&lt;*EXTERNAL GetTempFileNameA:WINAPI*&gt;
PROCEDURE GetTempFileNameA (lpPathName    : LPCSTR;
                            lpPrefixString: LPCSTR;
                            uUnique       : UINT;
                            lpTempFileName: LPSTR   ): UINT;

&lt;*EXTERNAL GetTempFileNameW:WINAPI*&gt;
PROCEDURE GetTempFileNameW (lpPathName    : LPCWSTR;
                            lpPrefixString: LPCWSTR;
                            uUnique       : UINT;
                            lpTempFileName: LPWSTR   ): UINT;

CONST GetTempFileName = GetTempFileNameA;

&lt;*EXTERNAL GetWindowsDirectoryA:WINAPI*&gt;
PROCEDURE GetWindowsDirectoryA (lpBuffer: LPSTR; uSize: UINT): UINT;

&lt;*EXTERNAL GetWindowsDirectoryW:WINAPI*&gt;
PROCEDURE GetWindowsDirectoryW (lpBuffer: LPWSTR; uSize: UINT): UINT;

CONST GetWindowsDirectory = GetWindowsDirectoryA;

&lt;*EXTERNAL SetCurrentDirectoryA:WINAPI*&gt;
PROCEDURE SetCurrentDirectoryA (lpPathName: LPSTR): BOOL;

&lt;*EXTERNAL SetCurrentDirectoryW:WINAPI*&gt;
PROCEDURE SetCurrentDirectoryW (lpPathName: LPWSTR): BOOL;

CONST SetCurrentDirectory = SetCurrentDirectoryA;

&lt;*EXTERNAL GetCurrentDirectoryA:WINAPI*&gt;
PROCEDURE GetCurrentDirectoryA (nBufferLength: DWORD; lpBuffer: LPSTR): DWORD;

&lt;*EXTERNAL GetCurrentDirectoryW:WINAPI*&gt;
PROCEDURE GetCurrentDirectoryW (nBufferLength: DWORD; lpBuffer: LPWSTR): DWORD;

CONST GetCurrentDirectory = GetCurrentDirectoryA;

&lt;*EXTERNAL GetDiskFreeSpaceA:WINAPI*&gt;
PROCEDURE GetDiskFreeSpaceA (lpRootPathName         : LPSTR;
                             lpSectorsPerCluster    : LPDWORD;
                             lpBytesPerSector       : LPDWORD;
                             lpNumberOfFreeClusters : LPDWORD;
                             lpTotalNumberOfClusters: LPDWORD  ): BOOL;

&lt;*EXTERNAL GetDiskFreeSpaceW:WINAPI*&gt;
PROCEDURE GetDiskFreeSpaceW (lpRootPathName         : LPWSTR;
                             lpSectorsPerCluster    : LPDWORD;
                             lpBytesPerSector       : LPDWORD;
                             lpNumberOfFreeClusters : LPDWORD;
                             lpTotalNumberOfClusters: LPDWORD  ): BOOL;

CONST GetDiskFreeSpace = GetDiskFreeSpaceA;

&lt;*EXTERNAL CreateDirectoryA:WINAPI*&gt;
PROCEDURE CreateDirectoryA (lpPathName          : LPSTR;
                            lpSecurityAttributes: LPSECURITY_ATTRIBUTES): BOOL;

&lt;*EXTERNAL CreateDirectoryW:WINAPI*&gt;
PROCEDURE CreateDirectoryW (lpPathName          : LPWSTR;
                            lpSecurityAttributes: LPSECURITY_ATTRIBUTES): BOOL;

CONST CreateDirectory = CreateDirectoryA;

&lt;*EXTERNAL RemoveDirectoryA:WINAPI*&gt;
PROCEDURE RemoveDirectoryA (lpPathName: LPSTR): BOOL;

&lt;*EXTERNAL RemoveDirectoryW:WINAPI*&gt;
PROCEDURE RemoveDirectoryW (lpPathName: LPWSTR): BOOL;

CONST RemoveDirectory = RemoveDirectoryA;

&lt;*EXTERNAL GetFullPathNameA:WINAPI*&gt;
PROCEDURE GetFullPathNameA (lpFileName   : LPCSTR;
                            nBufferLength: DWORD;
                            lpBuffer     : LPSTR;
                            lpFilePart   : UNTRACED REF LPSTR): DWORD;

&lt;*EXTERNAL GetFullPathNameW:WINAPI*&gt;
PROCEDURE GetFullPathNameW (lpFileName   : LPCWSTR;
                            nBufferLength: DWORD;
                            lpBuffer     : LPWSTR;
                            lpFilePart   : UNTRACED REF LPWSTR): DWORD;

CONST GetFullPathName = GetFullPathNameA;

&lt;*EXTERNAL CreateFileA:WINAPI*&gt;
PROCEDURE CreateFileA (lpFileName           : LPCSTR;
                       dwDesiredAccess      : DWORD;
                       dwShareMode          : DWORD;
                       lpSecurityAttributes : LPSECURITY_ATTRIBUTES;
                       dwCreationDisposition: DWORD;
                       dwFlagsAndAttributes : DWORD;
                       hTemplateFile        : HANDLE                 ): HANDLE;

&lt;*EXTERNAL CreateFileW:WINAPI*&gt;
PROCEDURE CreateFileW (lpFileName           : LPCWSTR;
                       dwDesiredAccess      : DWORD;
                       dwShareMode          : DWORD;
                       lpSecurityAttributes : LPSECURITY_ATTRIBUTES;
                       dwCreationDisposition: DWORD;
                       dwFlagsAndAttributes : DWORD;
                       hTemplateFile        : HANDLE                 ): HANDLE;

CONST CreateFile = CreateFileA;

&lt;*EXTERNAL SetFileAttributesA:WINAPI*&gt;
PROCEDURE SetFileAttributesA (lpFileName: LPSTR; dwFileAttributes: DWORD):BOOL;

&lt;*EXTERNAL SetFileAttributesW:WINAPI*&gt;
PROCEDURE SetFileAttributesW (lpFileName: LPWSTR; dwFileAttributes:DWORD):BOOL;

CONST SetFileAttributes = SetFileAttributesA;

&lt;*EXTERNAL GetFileAttributesA:WINAPI*&gt;
PROCEDURE GetFileAttributesA (lpFileName: LPSTR): DWORD;

&lt;*EXTERNAL GetFileAttributesW:WINAPI*&gt;
PROCEDURE GetFileAttributesW (lpFileName: LPWSTR): DWORD;

CONST GetFileAttributes = GetFileAttributesA;

&lt;*EXTERNAL DeleteFileA:WINAPI*&gt;
PROCEDURE DeleteFileA (lpFileName: LPSTR): BOOL;

&lt;*EXTERNAL DeleteFileW:WINAPI*&gt;
PROCEDURE DeleteFileW (lpFileName: LPWSTR): BOOL;

CONST DeleteFile = DeleteFileA;

&lt;*EXTERNAL FindFirstFileA:WINAPI*&gt;
PROCEDURE FindFirstFileA (lpFileName    : LPSTR;
                          lpFindFileData: LPWIN32_FIND_DATAA): HANDLE;

&lt;*EXTERNAL FindFirstFileW:WINAPI*&gt;
PROCEDURE FindFirstFileW (lpFileName    : LPWSTR;
                          lpFindFileData: LPWIN32_FIND_DATAW): HANDLE;

CONST FindFirstFile = FindFirstFileA;

&lt;*EXTERNAL FindNextFileA:WINAPI*&gt;
PROCEDURE FindNextFileA (hFindFile     : HANDLE;
                         lpFindFileData: LPWIN32_FIND_DATAA): BOOL;

&lt;*EXTERNAL FindNextFileW:WINAPI*&gt;
PROCEDURE FindNextFileW (hFindFile     : HANDLE;
                         lpFindFileData: LPWIN32_FIND_DATAW): BOOL;

CONST FindNextFile = FindNextFileA;

&lt;*EXTERNAL SearchPathA:WINAPI*&gt;
PROCEDURE SearchPathA (lpPath       : LPCSTR;
                       lpFileName   : LPCSTR;
                       lpExtension  : LPCSTR;
                       nBufferLength: DWORD;
                       lpBuffer     : LPSTR;
                       lpFilePart   : UNTRACED REF LPSTR): DWORD;

&lt;*EXTERNAL SearchPathW:WINAPI*&gt;
PROCEDURE SearchPathW (lpPath       : LPCWSTR;
                       lpFileName   : LPCWSTR;
                       lpExtension  : LPCWSTR;
                       nBufferLength: DWORD;
                       lpBuffer     : LPWSTR;
                       lpFilePart   : UNTRACED REF LPWSTR): DWORD;

CONST SearchPath = SearchPathA;

&lt;*EXTERNAL CopyFileA:WINAPI*&gt;
PROCEDURE CopyFileA (lpExistingFileName: LPSTR;
                     lpNewFileName     : LPSTR;
                     bFailIfExists     : BOOL   ): BOOL;

&lt;*EXTERNAL CopyFileW:WINAPI*&gt;
PROCEDURE CopyFileW (lpExistingFileName: LPWSTR;
                     lpNewFileName     : LPWSTR;
                     bFailIfExists     : BOOL    ): BOOL;

CONST CopyFile = CopyFileA;

&lt;*EXTERNAL MoveFileA:WINAPI*&gt;
PROCEDURE MoveFileA (lpExistingFileName: LPSTR; lpNewFileName: LPSTR): BOOL;
&lt;*EXTERNAL MoveFileW:WINAPI*&gt;

PROCEDURE MoveFileW (lpExistingFileName: LPWSTR; lpNewFileName: LPWSTR): BOOL;
CONST MoveFile = MoveFileA;

&lt;*EXTERNAL MoveFileExA:WINAPI*&gt;
PROCEDURE MoveFileExA (lpExistingFileName: LPSTR;
                       lpNewFileName     : LPSTR;
                       dwFlags           : DWORD  ): BOOL;

&lt;*EXTERNAL MoveFileExW:WINAPI*&gt;
PROCEDURE MoveFileExW (lpExistingFileName: LPWSTR;
                       lpNewFileName     : LPWSTR;
                       dwFlags           : DWORD   ): BOOL;

CONST MoveFileEx = MoveFileExA;

CONST
  MOVEFILE_REPLACE_EXISTING   = 16_00000001;
  MOVEFILE_COPY_ALLOWED       = 16_00000002;
  MOVEFILE_DELAY_UNTIL_REBOOT = 16_00000004;

&lt;*EXTERNAL CreateNamedPipeA:WINAPI*&gt;
PROCEDURE CreateNamedPipeA (lpName              : LPSTR;
                            dwOpenMode          : DWORD;
                            dwPipeMode          : DWORD;
                            nMaxInstances       : DWORD;
                            nOutBufferSize      : DWORD;
                            nInBufferSize       : DWORD;
                            nDefaultTimeOut     : DWORD;
                          lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE;

&lt;*EXTERNAL CreateNamedPipeW:WINAPI*&gt;
PROCEDURE CreateNamedPipeW (lpName              : LPWSTR;
                            dwOpenMode          : DWORD;
                            dwPipeMode          : DWORD;
                            nMaxInstances       : DWORD;
                            nOutBufferSize      : DWORD;
                            nInBufferSize       : DWORD;
                            nDefaultTimeOut     : DWORD;
                          lpSecurityAttributes: LPSECURITY_ATTRIBUTES): HANDLE;

CONST CreateNamedPipe = CreateNamedPipeA;

&lt;*EXTERNAL GetNamedPipeHandleStateA:WINAPI*&gt;
PROCEDURE GetNamedPipeHandleStateA (hNamedPipe          : HANDLE;
                                    lpState             : LPDWORD;
                                    lpCurInstances      : LPDWORD;
                                    lpMaxCollectionCount: LPDWORD;
                                    lpCollectDataTimeout: LPDWORD;
                                    lpUserName          : LPSTR;
                                    nMaxUserNameSize    : DWORD    ): BOOL;

&lt;*EXTERNAL GetNamedPipeHandleStateW:WINAPI*&gt;
PROCEDURE GetNamedPipeHandleStateW (hNamedPipe          : HANDLE;
                                    lpState             : LPDWORD;
                                    lpCurInstances      : LPDWORD;
                                    lpMaxCollectionCount: LPDWORD;
                                    lpCollectDataTimeout: LPDWORD;
                                    lpUserName          : LPWSTR;
                                    nMaxUserNameSize    : DWORD    ): BOOL;

CONST GetNamedPipeHandleState = GetNamedPipeHandleStateA;

&lt;*EXTERNAL CallNamedPipeA:WINAPI*&gt;
PROCEDURE CallNamedPipeA (lpNamedPipeName: LPSTR;
                          lpInBuffer     : LPVOID;
                          nInBufferSize  : DWORD;
                          lpOutBuffer    : LPVOID;
                          nOutBufferSize : DWORD;
                          lpBytesRead    : LPDWORD;
                          nTimeOut       : DWORD    ): BOOL;

&lt;*EXTERNAL CallNamedPipeW:WINAPI*&gt;
PROCEDURE CallNamedPipeW (lpNamedPipeName: LPWSTR;
                          lpInBuffer     : LPVOID;
                          nInBufferSize  : DWORD;
                          lpOutBuffer    : LPVOID;
                          nOutBufferSize : DWORD;
                          lpBytesRead    : LPDWORD;
                          nTimeOut       : DWORD    ): BOOL;

CONST CallNamedPipe = CallNamedPipeA;

&lt;*EXTERNAL WaitNamedPipeA:WINAPI*&gt;
PROCEDURE WaitNamedPipeA (lpNamedPipeName: LPSTR; nTimeOut: DWORD): BOOL;

&lt;*EXTERNAL WaitNamedPipeW:WINAPI*&gt;
PROCEDURE WaitNamedPipeW (lpNamedPipeName: LPWSTR; nTimeOut: DWORD): BOOL;

CONST WaitNamedPipe = WaitNamedPipeA;

&lt;*EXTERNAL GetVolumeInformationA:WINAPI*&gt;
PROCEDURE GetVolumeInformationA (lpRootPathName          : LPSTR;
                                 lpVolumeNameBuffer      : LPSTR;
                                 nVolumeNameSize         : DWORD;
                                 lpVolumeSerialNumber    : LPDWORD;
                                 lpMaximumComponentLength: LPDWORD;
                                 lpFileSystemFlags       : LPDWORD;
                                 lpFileSystemNameBuffer  : LPSTR;
                                 nFileSystemNameSize     : DWORD    ): BOOL;

&lt;*EXTERNAL GetVolumeInformationW:WINAPI*&gt;
PROCEDURE GetVolumeInformationW (lpRootPathName          : LPWSTR;
                                 lpVolumeNameBuffer      : LPWSTR;
                                 nVolumeNameSize         : DWORD;
                                 lpVolumeSerialNumber    : LPDWORD;
                                 lpMaximumComponentLength: LPDWORD;
                                 lpFileSystemFlags       : LPDWORD;
                                 lpFileSystemNameBuffer  : LPWSTR;
                                 nFileSystemNameSize     : DWORD    ): BOOL;

CONST GetVolumeInformation = GetVolumeInformationA;
</PRE> Event logging APIs 

<P><PRE>&lt;*EXTERNAL ClearEventLogA:WINAPI*&gt;
PROCEDURE ClearEventLogA (hEventLog: HANDLE; lpBackupFileName: LPSTR): BOOL;

&lt;*EXTERNAL ClearEventLogW:WINAPI*&gt;
PROCEDURE ClearEventLogW (hEventLog: HANDLE; lpBackupFileName: LPWSTR): BOOL;

CONST ClearEventLog = ClearEventLogA;

&lt;*EXTERNAL BackupEventLogA:WINAPI*&gt;
PROCEDURE BackupEventLogA (hEventLog: HANDLE; lpBackupFileName: LPSTR): BOOL;

&lt;*EXTERNAL BackupEventLogW:WINAPI*&gt;
PROCEDURE BackupEventLogW (hEventLog: HANDLE; lpBackupFileName: LPWSTR): BOOL;

CONST BackupEventLog = BackupEventLogA;

&lt;*EXTERNAL CloseEventLog:WINAPI*&gt;
PROCEDURE CloseEventLog (hEventLog: HANDLE): BOOL;

&lt;*EXTERNAL DeregisterEventSource:WINAPI*&gt;
PROCEDURE DeregisterEventSource (hEventLog: HANDLE): BOOL;

&lt;*EXTERNAL GetNumberOfEventLogRecords:WINAPI*&gt;
PROCEDURE GetNumberOfEventLogRecords (hEventLog      : HANDLE;
                                      NumberOfRecords: PDWORD  ): BOOL;

&lt;*EXTERNAL GetOldestEventLogRecord:WINAPI*&gt;
PROCEDURE GetOldestEventLogRecord (hEventLog   : HANDLE;
                                   OldestRecord: PDWORD  ): BOOL;

&lt;*EXTERNAL OpenEventLogA:WINAPI*&gt;
PROCEDURE OpenEventLogA (lpUNCServerName: LPSTR; lpSourceName: LPSTR): HANDLE;

&lt;*EXTERNAL OpenEventLogW:WINAPI*&gt;
PROCEDURE OpenEventLogW (lpUNCServerName: LPWSTR; lpSourceName: LPWSTR):HANDLE;

CONST OpenEventLog = OpenEventLogA;

&lt;*EXTERNAL RegisterEventSourceA:WINAPI*&gt;
PROCEDURE RegisterEventSourceA (lpUNCServerName: LPSTR;
                                lpSourceName   : LPSTR  ): HANDLE;

&lt;*EXTERNAL RegisterEventSourceW:WINAPI*&gt;
PROCEDURE RegisterEventSourceW (lpUNCServerName: LPWSTR;
                                lpSourceName   : LPWSTR  ): HANDLE;

CONST RegisterEventSource = RegisterEventSourceA;

&lt;*EXTERNAL OpenBackupEventLogA:WINAPI*&gt;
PROCEDURE OpenBackupEventLogA (lpUNCServerName: LPSTR;
                               lpFileName     : LPSTR):  HANDLE;

&lt;*EXTERNAL OpenBackupEventLogW:WINAPI*&gt;
PROCEDURE OpenBackupEventLogW (lpUNCServerName: LPWSTR;
                               lpFileName     : LPWSTR  ): HANDLE;

CONST OpenBackupEventLog = OpenBackupEventLogA;

&lt;*EXTERNAL ReadEventLogA:WINAPI*&gt;
PROCEDURE ReadEventLogA (hEventLog               : HANDLE;
                         dwReadFlags             : DWORD;
                         dwRecordOffset          : DWORD;
                         lpBuffer                : LPVOID;
                         nNumberOfBytesToRead    : DWORD;
                         pnBytesRead             : UNTRACED REF DWORD;
                         pnMinNumberOfBytesNeeded: UNTRACED REF DWORD  ): BOOL;

&lt;*EXTERNAL ReadEventLogW:WINAPI*&gt;
PROCEDURE ReadEventLogW (hEventLog               : HANDLE;
                         dwReadFlags             : DWORD;
                         dwRecordOffset          : DWORD;
                         lpBuffer                : LPVOID;
                         nNumberOfBytesToRead    : DWORD;
                         pnBytesRead             : UNTRACED REF DWORD;
                         pnMinNumberOfBytesNeeded: UNTRACED REF DWORD  ): BOOL;

CONST ReadEventLog = ReadEventLogA;

&lt;*EXTERNAL ReportEventA:WINAPI*&gt;
PROCEDURE ReportEventA (hEventLog  : HANDLE;
                        wType      : WORD;
                        wCategory  : WORD;
                        dwEventID  : DWORD;
                        lpUserSid  : PSID;
                        wNumStrings: WORD;
                        dwDataSize : DWORD;
                        lpStrings  : UNTRACED REF LPSTR;
                        lpRawData  : LPVOID              ): BOOL;

&lt;*EXTERNAL ReportEventW:WINAPI*&gt;
PROCEDURE ReportEventW (hEventLog  : HANDLE;
                        wType      : WORD;
                        wCategory  : WORD;
                        dwEventID  : DWORD;
                        lpUserSid  : PSID;
                        wNumStrings: WORD;
                        dwDataSize : DWORD;
                        lpStrings  : UNTRACED REF LPWSTR;
                        lpRawData  : LPVOID               ): BOOL;

CONST ReportEvent = ReportEventA;
</PRE> Security APIs 

<P>
<P><PRE>&lt;*EXTERNAL DuplicateToken:WINAPI*&gt;
PROCEDURE DuplicateToken (ExistingTokenHandle: HANDLE;
                        ImpersonationLevel: WinNT.SECURITY_IMPERSONATION_LEVEL;
                          DuplicateTokenHandle: PHANDLE): BOOL;

&lt;*EXTERNAL GetKernelObjectSecurity:WINAPI*&gt;
PROCEDURE GetKernelObjectSecurity (Handle        : HANDLE;
                             RequestedInformation: WinNT.SECURITY_INFORMATION;
                             pSecurityDescriptor : WinNT.PSECURITY_DESCRIPTOR;
                             nLength             : DWORD;
                             lpnLengthNeeded     : LPDWORD): BOOL;

&lt;*EXTERNAL ImpersonateNamedPipeClient:WINAPI*&gt;
PROCEDURE ImpersonateNamedPipeClient (hNamedPipe: HANDLE): BOOL;

&lt;*EXTERNAL ImpersonateSelf:WINAPI*&gt;
PROCEDURE ImpersonateSelf (
            ImpersonationLevel: WinNT.SECURITY_IMPERSONATION_LEVEL): BOOL;

&lt;*EXTERNAL RevertToSelf:WINAPI*&gt;
PROCEDURE RevertToSelf (): BOOL;

&lt;*EXTERNAL AccessCheck:WINAPI*&gt;
PROCEDURE AccessCheck (pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                       ClientToken        : HANDLE;
                       DesiredAccess      : DWORD;
                       GenericMapping     : WinNT.PGENERIC_MAPPING;
                       PrivilegeSet       : WinNT.PPRIVILEGE_SET;
                       PrivilegeSetLength : LPDWORD;
                       GrantedAccess      : LPDWORD;
                       AccessStatus       : LPBOOL                    ): BOOL;

&lt;*EXTERNAL OpenProcessToken:WINAPI*&gt;
PROCEDURE OpenProcessToken (ProcessHandle: HANDLE;
                            DesiredAccess: DWORD;
                            TokenHandle  : PHANDLE ): BOOL;

&lt;*EXTERNAL OpenThreadToken:WINAPI*&gt;
PROCEDURE OpenThreadToken (ThreadHandle : HANDLE;
                           DesiredAccess: DWORD;
                           OpenAsSelf   : BOOL;
                           TokenHandle  : PHANDLE ): BOOL;

&lt;*EXTERNAL GetTokenInformation:WINAPI*&gt;
PROCEDURE GetTokenInformation (TokenHandle: HANDLE;
                          TokenInformationClass: WinNT.TOKEN_INFORMATION_CLASS;
                               TokenInformation      : LPVOID;
                               TokenInformationLength: DWORD;
                               ReturnLength          : PDWORD  ): BOOL;

&lt;*EXTERNAL SetTokenInformation:WINAPI*&gt;
PROCEDURE SetTokenInformation (TokenHandle: HANDLE;
                          TokenInformationClass: WinNT.TOKEN_INFORMATION_CLASS;
                               TokenInformation      : LPVOID;
                               TokenInformationLength: DWORD   ): BOOL;

&lt;*EXTERNAL AdjustTokenPrivileges:WINAPI*&gt;
PROCEDURE AdjustTokenPrivileges (TokenHandle         : HANDLE;
                                 DisableAllPrivileges: BOOL;
                                 NewState     : WinNT.PTOKEN_PRIVILEGES;
                                 BufferLength : DWORD;
                                 PreviousState: WinNT.PTOKEN_PRIVILEGES;
                                 ReturnLength : PDWORD                 ): BOOL;

&lt;*EXTERNAL AdjustTokenGroups:WINAPI*&gt;
PROCEDURE AdjustTokenGroups (TokenHandle   : HANDLE;
                             ResetToDefault: BOOL;
                             NewState      : WinNT.PTOKEN_GROUPS;
                             BufferLength  : DWORD;
                             PreviousState : WinNT.PTOKEN_GROUPS;
                             ReturnLength  : PDWORD               ): BOOL;

&lt;*EXTERNAL PrivilegeCheck:WINAPI*&gt;
PROCEDURE PrivilegeCheck (ClientToken       : HANDLE;
                          RequiredPrivileges: WinNT.PPRIVILEGE_SET;
                          pfResult          : LPBOOL                ): BOOL;

&lt;*EXTERNAL AccessCheckAndAuditAlarmA:WINAPI*&gt;
PROCEDURE AccessCheckAndAuditAlarmA (SubsystemName    : LPSTR;
                                     HandleId         : LPVOID;
                                     ObjectTypeName   : LPSTR;
                                     ObjectName       : LPSTR;
                                SecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                                     DesiredAccess    : DWORD;
                                     GenericMapping   : WinNT.PGENERIC_MAPPING;
                                     ObjectCreation   : BOOL;
                                     GrantedAccess    : LPDWORD;
                                     AccessStatus     : LPBOOL;
                                     pfGenerateOnClose: LPBOOL   ): BOOL;

&lt;*EXTERNAL AccessCheckAndAuditAlarmW:WINAPI*&gt;
PROCEDURE AccessCheckAndAuditAlarmW (SubsystemName    : LPWSTR;
                                     HandleId         : LPVOID;
                                     ObjectTypeName   : LPWSTR;
                                     ObjectName       : LPWSTR;
                                SecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                                     DesiredAccess    : DWORD;
                                    GenericMapping    : WinNT.PGENERIC_MAPPING;
                                     ObjectCreation   : BOOL;
                                     GrantedAccess    : LPDWORD;
                                     AccessStatus     : LPBOOL;
                                     pfGenerateOnClose: LPBOOL   ): BOOL;

CONST AccessCheckAndAuditAlarm = AccessCheckAndAuditAlarmA;

&lt;*EXTERNAL ObjectOpenAuditAlarmA:WINAPI*&gt;
PROCEDURE ObjectOpenAuditAlarmA (SubsystemName  : LPSTR;
                                 HandleId       : LPVOID;
                                 ObjectTypeName : LPSTR;
                                 ObjectName     : LPSTR;
                             pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                                 ClientToken    : HANDLE;
                                 DesiredAccess  : DWORD;
                                 GrantedAccess  : DWORD;
                                 Privileges     : WinNT.PPRIVILEGE_SET;
                                 ObjectCreation : BOOL;
                                 AccessGranted  : BOOL;
                                 GenerateOnClose: LPBOOL               ): BOOL;

&lt;*EXTERNAL ObjectOpenAuditAlarmW:WINAPI*&gt;
PROCEDURE ObjectOpenAuditAlarmW (SubsystemName : LPWSTR;
                                 HandleId      : LPVOID;
                                 ObjectTypeName: LPWSTR;
                                 ObjectName    : LPWSTR;
                            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                                 ClientToken    : HANDLE;
                                 DesiredAccess  : DWORD;
                                 GrantedAccess  : DWORD;
                                 Privileges     : WinNT.PPRIVILEGE_SET;
                                 ObjectCreation : BOOL;
                                 AccessGranted  : BOOL;
                                 GenerateOnClose: LPBOOL              ): BOOL;

CONST ObjectOpenAuditAlarm = ObjectOpenAuditAlarmA;

&lt;*EXTERNAL ObjectPrivilegeAuditAlarmA:WINAPI*&gt;
PROCEDURE ObjectPrivilegeAuditAlarmA (SubsystemName: LPSTR;
                                      HandleId     : LPVOID;
                                      ClientToken  : HANDLE;
                                      DesiredAccess: DWORD;
                                      Privileges: WinNT.PPRIVILEGE_SET;
                                      AccessGranted: BOOL): BOOL;

&lt;*EXTERNAL ObjectPrivilegeAuditAlarmW:WINAPI*&gt;
PROCEDURE ObjectPrivilegeAuditAlarmW (SubsystemName: LPWSTR;
                                      HandleId     : LPVOID;
                                      ClientToken  : HANDLE;
                                      DesiredAccess: DWORD;
                                      Privileges: WinNT.PPRIVILEGE_SET;
                                      AccessGranted: BOOL): BOOL;

CONST ObjectPrivilegeAuditAlarm = ObjectPrivilegeAuditAlarmA;

&lt;*EXTERNAL ObjectCloseAuditAlarmA:WINAPI*&gt;
PROCEDURE ObjectCloseAuditAlarmA (SubsystemName  : LPSTR;
                                  HandleId       : LPVOID;
                                  GenerateOnClose: BOOL    ): BOOL;

&lt;*EXTERNAL ObjectCloseAuditAlarmW:WINAPI*&gt;
PROCEDURE ObjectCloseAuditAlarmW (SubsystemName  : LPWSTR;
                                  HandleId       : LPVOID;
                                  GenerateOnClose: BOOL    ): BOOL;

CONST ObjectCloseAuditAlarm = ObjectCloseAuditAlarmA;

&lt;*EXTERNAL PrivilegedServiceAuditAlarmA:WINAPI*&gt;
PROCEDURE PrivilegedServiceAuditAlarmA (SubsystemName: LPSTR;
                                        ServiceName  : LPSTR;
                                        ClientToken  : HANDLE;
                                        Privileges: WinNT.PPRIVILEGE_SET;
                                        AccessGranted: BOOL): BOOL;

&lt;*EXTERNAL PrivilegedServiceAuditAlarmW:WINAPI*&gt;
PROCEDURE PrivilegedServiceAuditAlarmW (SubsystemName: LPWSTR;
                                        ServiceName  : LPWSTR;
                                        ClientToken  : HANDLE;
                                        Privileges: WinNT.PPRIVILEGE_SET;
                                        AccessGranted: BOOL): BOOL;

CONST PrivilegedServiceAuditAlarm = PrivilegedServiceAuditAlarmA;

&lt;*EXTERNAL IsValidSid:WINAPI*&gt;
PROCEDURE IsValidSid (pSid: PSID): BOOL;

&lt;*EXTERNAL EqualSid:WINAPI*&gt;
PROCEDURE EqualSid (pSid1: PSID; pSid2: PSID): BOOL;

&lt;*EXTERNAL EqualPrefixSid:WINAPI*&gt;
PROCEDURE EqualPrefixSid (pSid1: PSID; pSid2: PSID): BOOL;

&lt;*EXTERNAL GetSidLengthRequired:WINAPI*&gt;
PROCEDURE GetSidLengthRequired (nSubAuthorityCount: UCHAR): DWORD;

&lt;*EXTERNAL AllocateAndInitializeSid:WINAPI*&gt;
PROCEDURE AllocateAndInitializeSid (
                         pIdentifierAuthority: WinNT.PSID_IDENTIFIER_AUTHORITY;
                         nSubAuthorityCount: BYTE;
                         nSubAuthority0    : DWORD;
                         nSubAuthority1    : DWORD;
                         nSubAuthority2    : DWORD;
                         nSubAuthority3    : DWORD;
                         nSubAuthority4    : DWORD;
                         nSubAuthority5    : DWORD;
                         nSubAuthority6    : DWORD;
                         nSubAuthority7    : DWORD;
                         pSid              : UNTRACED REF PSID): BOOL;

&lt;*EXTERNAL FreeSid:WINAPI*&gt;
PROCEDURE FreeSid (pSid: PSID): PVOID;

&lt;*EXTERNAL InitializeSid:WINAPI*&gt;
PROCEDURE InitializeSid (Sid                 : PSID;
                         pIdentifierAuthority: WinNT.PSID_IDENTIFIER_AUTHORITY;
                         nSubAuthorityCount  : BYTE): BOOL;

&lt;*EXTERNAL GetSidIdentifierAuthority:WINAPI*&gt;
PROCEDURE GetSidIdentifierAuthority (
              pSid: PSID): WinNT.PSID_IDENTIFIER_AUTHORITY;

&lt;*EXTERNAL GetSidSubAuthority:WINAPI*&gt;
PROCEDURE GetSidSubAuthority (pSid: PSID; nSubAuthority: DWORD): PDWORD;

&lt;*EXTERNAL GetSidSubAuthorityCount:WINAPI*&gt;
PROCEDURE GetSidSubAuthorityCount (pSid: PSID): PUCHAR;

&lt;*EXTERNAL GetLengthSid:WINAPI*&gt;
PROCEDURE GetLengthSid (pSid: PSID): DWORD;

&lt;*EXTERNAL CopySid:WINAPI*&gt;
PROCEDURE CopySid (nDestinationSidLength: DWORD;
                   pDestinationSid      : PSID;
                   pSourceSid           : PSID   ): BOOL;

&lt;*EXTERNAL AreAllAccessesGranted:WINAPI*&gt;
PROCEDURE AreAllAccessesGranted (GrantedAccess: DWORD;
                                 DesiredAccess: DWORD  ): BOOL;

&lt;*EXTERNAL AreAnyAccessesGranted:WINAPI*&gt;
PROCEDURE AreAnyAccessesGranted (GrantedAccess: DWORD;
                                 DesiredAccess: DWORD  ): BOOL;

&lt;*EXTERNAL MapGenericMask:WINAPI*&gt;
PROCEDURE MapGenericMask (AccessMask    : PDWORD;
                          GenericMapping: WinNT.PGENERIC_MAPPING);

&lt;*EXTERNAL IsValidAcl:WINAPI*&gt;
PROCEDURE IsValidAcl (pAcl: PACL): BOOL;

&lt;*EXTERNAL InitializeAcl:WINAPI*&gt;
PROCEDURE InitializeAcl (pAcl         : PACL;
                         nAclLength   : DWORD;
                         dwAclRevision: DWORD  ): BOOL;

&lt;*EXTERNAL GetAclInformation:WINAPI*&gt;
PROCEDURE GetAclInformation (pAcl                 : PACL;
                             pAclInformation      : LPVOID;
                             nAclInformationLength: DWORD;
                     dwAclInformationClass: WinNT.ACL_INFORMATION_CLASS): BOOL;

&lt;*EXTERNAL SetAclInformation:WINAPI*&gt;
PROCEDURE SetAclInformation (pAcl                 : PACL;
                             pAclInformation      : LPVOID;
                             nAclInformationLength: DWORD;
                     dwAclInformationClass: WinNT.ACL_INFORMATION_CLASS): BOOL;

&lt;*EXTERNAL AddAce:WINAPI*&gt;
PROCEDURE AddAce (pAcl              : PACL;
                  dwAceRevision     : DWORD;
                  dwStartingAceIndex: DWORD;
                  pAceList          : LPVOID;
                  nAceListLength    : DWORD   ): BOOL;

&lt;*EXTERNAL DeleteAce:WINAPI*&gt;
PROCEDURE DeleteAce (pAcl: PACL; dwAceIndex: DWORD): BOOL;

&lt;*EXTERNAL GetAce:WINAPI*&gt;
PROCEDURE GetAce (pAcl      : PACL;
                  dwAceIndex: DWORD;
                  pAce      : UNTRACED REF LPVOID): BOOL;

&lt;*EXTERNAL AddAccessAllowedAce:WINAPI*&gt;
PROCEDURE AddAccessAllowedAce (pAcl         : PACL;
                               dwAceRevision: DWORD;
                               AccessMask   : DWORD;
                               pSid         : PSID   ): BOOL;

&lt;*EXTERNAL AddAccessDeniedAce:WINAPI*&gt;
PROCEDURE AddAccessDeniedAce (pAcl         : PACL;
                              dwAceRevision: DWORD;
                              AccessMask   : DWORD;
                              pSid         : PSID   ): BOOL;

&lt;*EXTERNAL AddAuditAccessAce:WINAPI*&gt;
PROCEDURE AddAuditAccessAce (pAcl         : PACL;
                             dwAceRevision: DWORD;
                             dwAccessMask : DWORD;
                             pSid         : PSID;
                             bAuditSuccess: BOOL;
                             bAuditFailure: BOOL   ): BOOL;

&lt;*EXTERNAL FindFirstFreeAce:WINAPI*&gt;
PROCEDURE FindFirstFreeAce (pAcl: PACL; pAce: UNTRACED REF LPVOID): BOOL;

&lt;*EXTERNAL InitializeSecurityDescriptor:WINAPI*&gt;
PROCEDURE InitializeSecurityDescriptor (
            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
            dwRevision         : DWORD                      ): BOOL;

&lt;*EXTERNAL IsValidSecurityDescriptor:WINAPI*&gt;
PROCEDURE IsValidSecurityDescriptor (
            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR): BOOL;

&lt;*EXTERNAL GetSecurityDescriptorLength:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorLength (
            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR): DWORD;

&lt;*EXTERNAL GetSecurityDescriptorControl:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorControl (
            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
            pControl           : WinNT.PSECURITY_DESCRIPTOR_CONTROL;
            lpdwRevision       : LPDWORD                             ): BOOL;

&lt;*EXTERNAL SetSecurityDescriptorDacl:WINAPI*&gt;
PROCEDURE SetSecurityDescriptorDacl (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              bDaclPresent       : BOOL;
              pDacl              : PACL;
              bDaclDefaulted     : BOOL  ): BOOL;

&lt;*EXTERNAL GetSecurityDescriptorDacl:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorDacl (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              lpbDaclPresent     : LPBOOL;
              pDacl              : UNTRACED REF PACL;
              lpbDaclDefaulted   : LPBOOL): BOOL;

&lt;*EXTERNAL SetSecurityDescriptorSacl:WINAPI*&gt;
PROCEDURE SetSecurityDescriptorSacl (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              bSaclPresent       : BOOL;
              pSacl              : PACL;
              bSaclDefaulted     : BOOL  ): BOOL;

&lt;*EXTERNAL GetSecurityDescriptorSacl:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorSacl (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              lpbSaclPresent     : LPBOOL;
              pSacl              : UNTRACED REF PACL;
              lpbSaclDefaulted   : LPBOOL): BOOL;

&lt;*EXTERNAL SetSecurityDescriptorOwner:WINAPI*&gt;
PROCEDURE SetSecurityDescriptorOwner (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              pOwner             : PSID;
              bOwnerDefaulted    : BOOL  ): BOOL;

&lt;*EXTERNAL GetSecurityDescriptorOwner:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorOwner (
              pSecurityDescriptor : WinNT.PSECURITY_DESCRIPTOR;
              pOwner              : UNTRACED REF PSID;
              lpbOwnerDefaulted   : LPBOOL): BOOL;

&lt;*EXTERNAL SetSecurityDescriptorGroup:WINAPI*&gt;
PROCEDURE SetSecurityDescriptorGroup (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              pGroup             : PSID;
              bGroupDefaulted    : BOOL  ): BOOL;

&lt;*EXTERNAL GetSecurityDescriptorGroup:WINAPI*&gt;
PROCEDURE GetSecurityDescriptorGroup (
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              pGroup             : UNTRACED REF PSID;
              lpbGroupDefaulted  : LPBOOL): BOOL;

&lt;*EXTERNAL CreatePrivateObjectSecurity:WINAPI*&gt;
PROCEDURE CreatePrivateObjectSecurity (
              ParentDescriptor : WinNT.PSECURITY_DESCRIPTOR;
              CreatorDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              NewDescriptor    : UNTRACED REF WinNT.PSECURITY_DESCRIPTOR;
              IsDirectoryObject: BOOL;
              Token            : HANDLE;
              GenericMapping   : WinNT.PGENERIC_MAPPING): BOOL;

&lt;*EXTERNAL SetPrivateObjectSecurity:WINAPI*&gt;
PROCEDURE SetPrivateObjectSecurity (
            SecurityInformation      : WinNT.SECURITY_INFORMATION;
            ModificationDescriptor   : WinNT.PSECURITY_DESCRIPTOR;
            ObjectsSecurityDescriptor: UNTRACED REF WinNT.PSECURITY_DESCRIPTOR;
            GenericMapping           : WinNT.PGENERIC_MAPPING;
            Token                    : HANDLE): BOOL;

&lt;*EXTERNAL GetPrivateObjectSecurity:WINAPI*&gt;
PROCEDURE GetPrivateObjectSecurity (
              ObjectDescriptor   : WinNT.PSECURITY_DESCRIPTOR;
              SecurityInformation: WinNT.SECURITY_INFORMATION;
              ResultantDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              DescriptorLength   : DWORD;
              ReturnLength       : PDWORD ): BOOL;

&lt;*EXTERNAL DestroyPrivateObjectSecurity:WINAPI*&gt;
PROCEDURE DestroyPrivateObjectSecurity (
              ObjectDescriptor: UNTRACED REF WinNT.PSECURITY_DESCRIPTOR): BOOL;

&lt;*EXTERNAL MakeSelfRelativeSD:WINAPI*&gt;
PROCEDURE MakeSelfRelativeSD (
              pAbsoluteSecurityDescriptor    : WinNT.PSECURITY_DESCRIPTOR;
              pSelfRelativeSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
              lpdwBufferLength               : LPDWORD): BOOL;

&lt;*EXTERNAL MakeAbsoluteSD:WINAPI*&gt;
PROCEDURE MakeAbsoluteSD (
              pSelfRelativeSecurityDescriptor   : WinNT.PSECURITY_DESCRIPTOR;
              pAbsoluteSecurityDescriptor       : WinNT.PSECURITY_DESCRIPTOR;
              lpdwAbsoluteSecurityDescriptorSize: LPDWORD;
              pDacl                             : PACL;
              lpdwDaclSize                      : LPDWORD;
              pSacl                             : PACL;
              lpdwSaclSize                      : LPDWORD;
              pOwner                            : PSID;
              lpdwOwnerSize                     : LPDWORD;
              pPrimaryGroup                     : PSID;
              lpdwPrimaryGroupSize              : LPDWORD  ): BOOL;

&lt;*EXTERNAL SetFileSecurityA:WINAPI*&gt;
PROCEDURE SetFileSecurityA (
              lpFileName         : LPSTR;
              SecurityInformation: WinNT.SECURITY_INFORMATION;
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR): BOOL;

&lt;*EXTERNAL SetFileSecurityW:WINAPI*&gt;
PROCEDURE SetFileSecurityW (
              lpFileName         : LPWSTR;
              SecurityInformation: WinNT.SECURITY_INFORMATION;
              pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR): BOOL;

CONST SetFileSecurity = SetFileSecurityA;

&lt;*EXTERNAL GetFileSecurityA:WINAPI*&gt;
PROCEDURE GetFileSecurityA (lpFileName: LPSTR;
                            RequestedInformation: WinNT.SECURITY_INFORMATION;
                            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                            nLength        : DWORD;
                            lpnLengthNeeded: LPDWORD): BOOL;

&lt;*EXTERNAL GetFileSecurityW:WINAPI*&gt;
PROCEDURE GetFileSecurityW (lpFileName: LPWSTR;
                            RequestedInformation: WinNT.SECURITY_INFORMATION;
                            pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                            nLength        : DWORD;
                            lpnLengthNeeded: LPDWORD): BOOL;

CONST GetFileSecurity = GetFileSecurityA;

&lt;*EXTERNAL SetKernelObjectSecurity:WINAPI*&gt;
PROCEDURE SetKernelObjectSecurity (
              Handle             : HANDLE;
              SecurityInformation: WinNT.SECURITY_INFORMATION;
              SecurityDescriptor : WinNT.PSECURITY_DESCRIPTOR): BOOL;

&lt;*EXTERNAL FindFirstChangeNotificationA:WINAPI*&gt;
PROCEDURE FindFirstChangeNotificationA (lpPathName    : LPSTR;
                                        bWatchSubtree : BOOL;
                                        dwNotifyFilter: DWORD  ): HANDLE;

&lt;*EXTERNAL FindFirstChangeNotificationW:WINAPI*&gt;
PROCEDURE FindFirstChangeNotificationW (lpPathName    : LPWSTR;
                                        bWatchSubtree : BOOL;
                                        dwNotifyFilter: DWORD  ): HANDLE;

CONST FindFirstChangeNotification = FindFirstChangeNotificationA;

&lt;*EXTERNAL FindNextChangeNotification:WINAPI*&gt;
PROCEDURE FindNextChangeNotification (hChangeHandle: HANDLE): BOOL;

&lt;*EXTERNAL FindCloseChangeNotification:WINAPI*&gt;
PROCEDURE FindCloseChangeNotification (hChangeHandle: HANDLE): BOOL;

&lt;*EXTERNAL VirtualLock:WINAPI*&gt;
PROCEDURE VirtualLock (lpAddress: LPVOID; dwSize: DWORD): BOOL;

&lt;*EXTERNAL VirtualUnlock:WINAPI*&gt;
PROCEDURE VirtualUnlock (lpAddress: LPVOID; dwSize: DWORD): BOOL;

&lt;*EXTERNAL MapViewOfFileEx:WINAPI*&gt;
PROCEDURE MapViewOfFileEx (hFileMappingObject  : HANDLE;
                           dwDesiredAccess     : DWORD;
                           dwFileOffsetHigh    : DWORD;
                           dwFileOffsetLow     : DWORD;
                           dwNumberOfBytesToMap: DWORD;
                           lpBaseAddress       : LPVOID  ): LPVOID;

&lt;*EXTERNAL SetPriorityClass:WINAPI*&gt;
PROCEDURE SetPriorityClass (hProcess: HANDLE; dwPriorityClass: DWORD): BOOL;

&lt;*EXTERNAL GetPriorityClass:WINAPI*&gt;
PROCEDURE GetPriorityClass (hProcess: HANDLE): DWORD;

&lt;*EXTERNAL IsBadReadPtr:WINAPI*&gt;
PROCEDURE IsBadReadPtr (lp: void_star; ucb: UINT): BOOL;

&lt;*EXTERNAL IsBadWritePtr:WINAPI*&gt;
PROCEDURE IsBadWritePtr (lp: LPVOID; ucb: UINT): BOOL;

&lt;*EXTERNAL IsBadHugeReadPtr:WINAPI*&gt;
PROCEDURE IsBadHugeReadPtr (lp: void_star; ucb: UINT): BOOL;

&lt;*EXTERNAL IsBadHugeWritePtr:WINAPI*&gt;
PROCEDURE IsBadHugeWritePtr (lp: LPVOID; ucb: UINT): BOOL;

&lt;*EXTERNAL IsBadCodePtr:WINAPI*&gt;
PROCEDURE IsBadCodePtr (lpfn: FARPROC): BOOL;

&lt;*EXTERNAL IsBadStringPtrA:WINAPI*&gt;
PROCEDURE IsBadStringPtrA (lpsz: LPCSTR; ucchMax: UINT): BOOL;

&lt;*EXTERNAL IsBadStringPtrW:WINAPI*&gt;
PROCEDURE IsBadStringPtrW (lpsz: LPCWSTR; ucchMax: UINT): BOOL;

CONST IsBadStringPtr = IsBadStringPtrA;

&lt;*EXTERNAL LookupAccountSidA:WINAPI*&gt;
PROCEDURE LookupAccountSidA (lpSystemName          : LPSTR;
                             Sid                   : PSID;
                             Name                  : LPSTR;
                             cbName                : LPDWORD;
                             ReferencedDomainName  : LPSTR;
                             cbReferencedDomainName: LPDWORD;
                             peUse                 : WinNT.PSID_NAME_USE):BOOL;

&lt;*EXTERNAL LookupAccountSidW:WINAPI*&gt;
PROCEDURE LookupAccountSidW (lpSystemName          : LPWSTR;
                             Sid                   : PSID;
                             Name                  : LPWSTR;
                             cbName                : LPDWORD;
                             ReferencedDomainName  : LPWSTR;
                             cbReferencedDomainName: LPDWORD;
                             peUse                 : WinNT.PSID_NAME_USE):BOOL;

CONST LookupAccountSid = LookupAccountSidA;

&lt;*EXTERNAL LookupAccountNameA:WINAPI*&gt;
PROCEDURE LookupAccountNameA (lpSystemName          : LPSTR;
                              lpAccountName         : LPSTR;
                              Sid                   : PSID;
                              cbSid                 : LPDWORD;
                              ReferencedDomainName  : LPSTR;
                              cbReferencedDomainName: LPDWORD;
                              peUse                : WinNT.PSID_NAME_USE):BOOL;

&lt;*EXTERNAL LookupAccountNameW:WINAPI*&gt;
PROCEDURE LookupAccountNameW (lpSystemName          : LPWSTR;
                              lpAccountName         : LPWSTR;
                              Sid                   : PSID;
                              cbSid                 : LPDWORD;
                              ReferencedDomainName  : LPWSTR;
                              cbReferencedDomainName: LPDWORD;
                              peUse                : WinNT.PSID_NAME_USE):BOOL;

CONST LookupAccountName = LookupAccountNameA;

&lt;*EXTERNAL LookupPrivilegeValueA:WINAPI*&gt;
PROCEDURE LookupPrivilegeValueA (lpSystemName: LPSTR;
                                 lpName      : LPSTR;
                                 lpLuid      : PLUID  ): BOOL;

&lt;*EXTERNAL LookupPrivilegeValueW:WINAPI*&gt;
PROCEDURE LookupPrivilegeValueW (lpSystemName: LPWSTR;
                                 lpName      : LPWSTR;
                                 lpLuid      : PLUID   ): BOOL;

CONST LookupPrivilegeValue = LookupPrivilegeValueA;

&lt;*EXTERNAL LookupPrivilegeNameA:WINAPI*&gt;
PROCEDURE LookupPrivilegeNameA (lpSystemName: LPSTR;
                                lpLuid      : PLUID;
                                lpName      : LPSTR;
                                cbName      : LPDWORD): BOOL;

&lt;*EXTERNAL LookupPrivilegeNameW:WINAPI*&gt;
PROCEDURE LookupPrivilegeNameW (lpSystemName: LPWSTR;
                                lpLuid      : PLUID;
                                lpName      : LPWSTR;
                                cbName      : LPDWORD ): BOOL;

CONST LookupPrivilegeName = LookupPrivilegeNameA;

&lt;*EXTERNAL LookupPrivilegeDisplayNameA:WINAPI*&gt;
PROCEDURE LookupPrivilegeDisplayNameA (lpSystemName : LPSTR;
                                       lpName       : LPSTR;
                                       lpDisplayName: LPSTR;
                                       cbDisplayName: LPDWORD;
                                       lpLanguageId : LPDWORD  ): BOOL;

&lt;*EXTERNAL LookupPrivilegeDisplayNameW:WINAPI*&gt;
PROCEDURE LookupPrivilegeDisplayNameW (lpSystemName : LPWSTR;
                                       lpName       : LPWSTR;
                                       lpDisplayName: LPWSTR;
                                       cbDisplayName: LPDWORD;
                                       lpLanguageId : LPDWORD  ): BOOL;

CONST LookupPrivilegeDisplayName = LookupPrivilegeDisplayNameA;

&lt;*EXTERNAL AllocateLocallyUniqueId:WINAPI*&gt;
PROCEDURE AllocateLocallyUniqueId (Luid: PLUID): BOOL;

&lt;*EXTERNAL BuildCommDCBA:WINAPI*&gt;
PROCEDURE BuildCommDCBA (lpDef: LPSTR; lpDCB: LPDCB): BOOL;

&lt;*EXTERNAL BuildCommDCBW:WINAPI*&gt;
PROCEDURE BuildCommDCBW (lpDef: LPWSTR; lpDCB: LPDCB): BOOL;

CONST BuildCommDCB = BuildCommDCBA;

CONST MAX_COMPUTERNAME_LENGTH = 15;

&lt;*EXTERNAL GetComputerNameA:WINAPI*&gt;
PROCEDURE GetComputerNameA (lpBuffer: LPSTR; nSize: LPDWORD): BOOL;

&lt;*EXTERNAL GetComputerNameW:WINAPI*&gt;
PROCEDURE GetComputerNameW (lpBuffer: LPWSTR; nSize: LPDWORD): BOOL;

CONST GetComputerName = GetComputerNameA;

&lt;*EXTERNAL SetComputerNameA:WINAPI*&gt;
PROCEDURE SetComputerNameA (lpComputerName: LPSTR): BOOL;

&lt;*EXTERNAL SetComputerNameW:WINAPI*&gt;
PROCEDURE SetComputerNameW (lpComputerName: LPWSTR): BOOL;

CONST SetComputerName = SetComputerNameA;

&lt;*EXTERNAL GetUserNameA:WINAPI*&gt;
PROCEDURE GetUserNameA (lpBuffer: LPSTR; nSize: LPDWORD): BOOL;

&lt;*EXTERNAL GetUserNameW:WINAPI*&gt;
PROCEDURE GetUserNameW (lpBuffer: LPWSTR; nSize: LPDWORD): BOOL;

CONST GetUserName = GetUserNameA;
</PRE> Performance counter API's 

<P><PRE>&lt;*EXTERNAL QueryPerformanceCounter:WINAPI*&gt;
PROCEDURE QueryPerformanceCounter (
              lpPerformanceCount: UNTRACED REF LARGE_INTEGER): BOOL;

&lt;*EXTERNAL QueryPerformanceFrequency:WINAPI*&gt;
PROCEDURE QueryPerformanceFrequency (
              lpFrequency: UNTRACED REF LARGE_INTEGER): BOOL;
</PRE> Abnormal termination codes 
<PRE>CONST
  TC_NORMAL  = 0;
  TC_HARDERR = 1;
  TC_GP_TRAP = 2;
  TC_SIGNAL  = 3;

END WinBase.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
