<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinCon.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinCon.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>INTERFACE <interface>WinCon</interface>;
</PRE> Corresponds to build version 0002 of <CODE>wincon.h</CODE>.  See that file for
   details.
<P>
   This module contains the public data structures, data types, and
   procedures exported by the NT console subsystem. 

<P><PRE>IMPORT <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="WinBase.i3">WinBase</A>;

FROM <A HREF="WinDef.i3">WinDef</A> IMPORT SHORT, BOOL, WORD, DWORD, UINT, LPDWORD, LPWORD, LPVOID;
FROM <A HREF="WinNT.i3">WinNT</A> IMPORT WCHAR, HANDLE, LPSTR, LPWSTR, PVOID;

TYPE
  PCOORD = UNTRACED REF COORD;
  COORD = RECORD
    X: SHORT;
    Y: SHORT;
  END;

  PSMALL_RECT = UNTRACED REF SMALL_RECT;
  SMALL_RECT = RECORD
    Left  : SHORT;
    Top   : SHORT;
    Right : SHORT;
    Bottom: SHORT;
  END;

  PKEY_EVENT_RECORD = UNTRACED REF KEY_EVENT_RECORD;
  KEY_EVENT_RECORD = RECORD
    bKeyDown        : BOOL;
    wRepeatCount    : WORD;
    wVirtualKeyCode : WORD;
    wVirtualScanCode: WORD;
    uChar           : WCHAR; (* ??? *)
                     (* union { WCHAR UnicodeChar; CHAR AsciiChar; } uChar; *)
    dwControlKeyState: DWORD;
  END;
</PRE> ControlKeyState flags 

<P><PRE>CONST
  RIGHT_ALT_PRESSED  = 16_0001; (* the right alt key is pressed. *)
  LEFT_ALT_PRESSED   = 16_0002; (* the left alt key is pressed. *)
  RIGHT_CTRL_PRESSED = 16_0004; (* the right ctrl key is pressed. *)
  LEFT_CTRL_PRESSED  = 16_0008; (* the left ctrl key is pressed. *)
  SHIFT_PRESSED      = 16_0010; (* the shift key is pressed. *)
  NUMLOCK_ON         = 16_0020; (* the numlock light is on. *)
  SCROLLLOCK_ON      = 16_0040; (* the scrolllock light is on. *)
  CAPSLOCK_ON        = 16_0080; (* the capslock light is on. *)
  ENHANCED_KEY       = 16_0100; (* the key is enhanced. *)

TYPE
  PMOUSE_EVENT_RECORD = UNTRACED REF MOUSE_EVENT_RECORD;
  MOUSE_EVENT_RECORD = RECORD
    dwMousePosition  : COORD;
    dwButtonState    : DWORD;
    dwControlKeyState: DWORD;
    dwEventFlags     : DWORD;
  END;
</PRE> ButtonState flags 

<P><PRE>CONST
  FROM_LEFT_1ST_BUTTON_PRESSED = 16_0001;
  RIGHTMOST_BUTTON_PRESSED     = 16_0002;
  FROM_LEFT_2ND_BUTTON_PRESSED = 16_0004;
  FROM_LEFT_3RD_BUTTON_PRESSED = 16_0008;
  FROM_LEFT_4TH_BUTTON_PRESSED = 16_0010;
</PRE> EventFlags 

<P><PRE>CONST
  MOUSE_MOVED  = 16_0001;
  DOUBLE_CLICK = 16_0002;

TYPE
  WINDOW_BUFFER_SIZE_RECORD = RECORD dwSize: COORD;  END;
  PWINDOW_BUFFER_SIZE_RECORD = UNTRACED REF WINDOW_BUFFER_SIZE_RECORD;

  MENU_EVENT_RECORD = RECORD dwCommandId: UINT;  END;
  PMENU_EVENT_RECORD = UNTRACED REF MENU_EVENT_RECORD;

  FOCUS_EVENT_RECORD = RECORD bSetFocus: BOOL;  END;
  PFOCUS_EVENT_RECORD = UNTRACED REF FOCUS_EVENT_RECORD;

  PINPUT_RECORD = UNTRACED REF INPUT_RECORD;
  INPUT_RECORD = RECORD
    EventType: WORD;
    Event    : KEY_EVENT_RECORD;  (* !!! *)
                   (*
                   union {
                       KEY_EVENT_RECORD KeyEvent;
                       MOUSE_EVENT_RECORD MouseEvent;
                       WINDOW_BUFFER_SIZE_RECORD WindowBufferSizeEvent;
                       MENU_EVENT_RECORD MenuEvent;
                       FOCUS_EVENT_RECORD FocusEvent;
                   } Event;
                   *)
  END;
</PRE> EventType flags: 

<P><PRE>CONST
  KEY_EVENT   = 16_0001;        (* Event contains key event record *)
  MOUSE_EVENT = 16_0002;        (* Event contains mouse event record *)
  WINDOW_BUFFER_SIZE_EVENT = 16_0004; (* Event contains window change event
                                         record *)
  MENU_EVENT  = 16_0008;        (* Event contains menu event record *)
  FOCUS_EVENT = 16_0010;        (* event contains focus change *)

TYPE
  PCHAR_INFO = UNTRACED REF CHAR_INFO;
  CHAR_INFO = RECORD
    Char: WCHAR; (* ??? *)
                (* union { WCHAR UnicodeChar; CHAR AsciiChar; } Char; *)
    Attributes: WORD;
  END;
</PRE> Attributes flags: 

<P><PRE>CONST
  FOREGROUND_BLUE      = 16_0001; (* text color contains blue. *)
  FOREGROUND_GREEN     = 16_0002; (* text color contains green. *)
  FOREGROUND_RED       = 16_0004; (* text color contains red. *)
  FOREGROUND_INTENSITY = 16_0008; (* text color is intensified. *)
  BACKGROUND_BLUE      = 16_0010; (* background color contains blue. *)
  BACKGROUND_GREEN     = 16_0020; (* background color contains green. *)
  BACKGROUND_RED       = 16_0040; (* background color contains red. *)
  BACKGROUND_INTENSITY = 16_0080; (* background color is intensified. *)

TYPE
  PCONSOLE_SCREEN_BUFFER_INFO = UNTRACED REF CONSOLE_SCREEN_BUFFER_INFO;
  CONSOLE_SCREEN_BUFFER_INFO = RECORD
    dwSize             : COORD;
    dwCursorPosition   : COORD;
    wAttributes        : WORD;
    srWindow           : SMALL_RECT;
    dwMaximumWindowSize: COORD;
  END;

  PCONSOLE_CURSOR_INFO = UNTRACED REF CONSOLE_CURSOR_INFO;
  CONSOLE_CURSOR_INFO = RECORD
    dwSize  : DWORD;
    bVisible: BOOL;
  END;
</PRE> typedef for ctrl-c handler routines 

<P><PRE>TYPE PHANDLER_ROUTINE = &lt;*WINAPI*&gt; PROCEDURE (CtrlType: DWORD): BOOL;

CONST
  CTRL_C_EVENT     = 0;
  CTRL_BREAK_EVENT = 1;
  CTRL_CLOSE_EVENT = 2;
  (* 3 is reserved! *)
  (* 4 is reserved! *)
  CTRL_LOGOFF_EVENT   = 5;
  CTRL_SHUTDOWN_EVENT = 6;
</PRE> Input Mode flags: 

<P><PRE>CONST
  ENABLE_PROCESSED_INPUT = 16_0001;
  ENABLE_LINE_INPUT      = 16_0002;
  ENABLE_ECHO_INPUT      = 16_0004;
  ENABLE_WINDOW_INPUT    = 16_0008;
  ENABLE_MOUSE_INPUT     = 16_0010;
</PRE> Output Mode flags: 

<P><PRE>CONST
  ENABLE_PROCESSED_OUTPUT   = 16_0001;
  ENABLE_WRAP_AT_EOL_OUTPUT = 16_0002;
</PRE> direct API definitions. 

<P><PRE>&lt;*EXTERNAL PeekConsoleInputA:WINAPI*&gt;
PROCEDURE PeekConsoleInputA (hConsoleInput       : HANDLE;
                             lpBuffer            : PINPUT_RECORD;
                             nLength             : DWORD;
                             lpNumberOfEventsRead: LPDWORD        ): BOOL;

&lt;*EXTERNAL PeekConsoleInputW:WINAPI*&gt;
PROCEDURE PeekConsoleInputW (hConsoleInput       : HANDLE;
                             lpBuffer            : PINPUT_RECORD;
                             nLength             : DWORD;
                             lpNumberOfEventsRead: LPDWORD        ): BOOL;

CONST PeekConsoleInput = PeekConsoleInputA;

&lt;*EXTERNAL ReadConsoleInputA:WINAPI*&gt;
PROCEDURE ReadConsoleInputA (hConsoleInput       : HANDLE;
                             lpBuffer            : PINPUT_RECORD;
                             nLength             : DWORD;
                             lpNumberOfEventsRead: LPDWORD        ): BOOL;

&lt;*EXTERNAL ReadConsoleInputW:WINAPI*&gt;
PROCEDURE ReadConsoleInputW (hConsoleInput       : HANDLE;
                             lpBuffer            : PINPUT_RECORD;
                             nLength             : DWORD;
                             lpNumberOfEventsRead: LPDWORD       ): BOOL;

CONST ReadConsoleInput = ReadConsoleInputA;

&lt;*EXTERNAL WriteConsoleInputA:WINAPI*&gt;
PROCEDURE WriteConsoleInputA (hConsoleInput          : HANDLE;
                              lpBuffer               : PINPUT_RECORD;
                              nLength                : DWORD;
                              lpNumberOfEventsWritten: LPDWORD        ): BOOL;

&lt;*EXTERNAL WriteConsoleInputW:WINAPI*&gt;
PROCEDURE WriteConsoleInputW (hConsoleInput          : HANDLE;
                              lpBuffer               : PINPUT_RECORD;
                              nLength                : DWORD;
                              lpNumberOfEventsWritten: LPDWORD        ): BOOL;

CONST WriteConsoleInput = WriteConsoleInputA;

&lt;*EXTERNAL ReadConsoleOutputA:WINAPI*&gt;
PROCEDURE ReadConsoleOutputA (hConsoleOutput: HANDLE;
                              lpBuffer      : PCHAR_INFO;
                              dwBufferSize  : COORD;
                              dwBufferCoord : COORD;
                              lpReadRegion  : PSMALL_RECT ): BOOL;

&lt;*EXTERNAL ReadConsoleOutputW:WINAPI*&gt;
PROCEDURE ReadConsoleOutputW (hConsoleOutput: HANDLE;
                              lpBuffer      : PCHAR_INFO;
                              dwBufferSize  : COORD;
                              dwBufferCoord : COORD;
                              lpReadRegion  : PSMALL_RECT ): BOOL;

CONST ReadConsoleOutput = ReadConsoleOutputA;

&lt;*EXTERNAL WriteConsoleOutputA:WINAPI*&gt;
PROCEDURE WriteConsoleOutputA (hConsoleOutput: HANDLE;
                               lpBuffer      : PCHAR_INFO;
                               dwBufferSize  : COORD;
                               dwBufferCoord : COORD;
                               lpWriteRegion : PSMALL_RECT ): BOOL;

&lt;*EXTERNAL WriteConsoleOutputW:WINAPI*&gt;
PROCEDURE WriteConsoleOutputW (hConsoleOutput: HANDLE;
                               lpBuffer      : PCHAR_INFO;
                               dwBufferSize  : COORD;
                               dwBufferCoord : COORD;
                               lpWriteRegion : PSMALL_RECT ): BOOL;

CONST WriteConsoleOutput = WriteConsoleOutputA;

&lt;*EXTERNAL ReadConsoleOutputCharacterA:WINAPI*&gt;
PROCEDURE ReadConsoleOutputCharacterA (hConsoleOutput     : HANDLE;
                                       lpCharacter        : LPSTR;
                                       nLength            : DWORD;
                                       dwReadCoord        : COORD;
                                       lpNumberOfCharsRead: LPDWORD ): BOOL;

&lt;*EXTERNAL ReadConsoleOutputCharacterW:WINAPI*&gt;
PROCEDURE ReadConsoleOutputCharacterW (hConsoleOutput     : HANDLE;
                                       lpCharacter        : LPWSTR;
                                       nLength            : DWORD;
                                       dwReadCoord        : COORD;
                                       lpNumberOfCharsRead: LPDWORD ): BOOL;

CONST ReadConsoleOutputCharacter = ReadConsoleOutputCharacterA;

&lt;*EXTERNAL ReadConsoleOutputAttribute:WINAPI*&gt;
PROCEDURE ReadConsoleOutputAttribute (hConsoleOutput     : HANDLE;
                                      lpAttribute        : LPWORD;
                                      nLength            : DWORD;
                                      dwReadCoord        : COORD;
                                      lpNumberOfAttrsRead: LPDWORD ): BOOL;

&lt;*EXTERNAL WriteConsoleOutputCharacterA:WINAPI*&gt;
PROCEDURE WriteConsoleOutputCharacterA (hConsoleOutput        : HANDLE;
                                        lpCharacter           : LPSTR;
                                        nLength               : DWORD;
                                        dwWriteCoord          : COORD;
                                        lpNumberOfCharsWritten: LPDWORD): BOOL;

&lt;*EXTERNAL WriteConsoleOutputCharacterW:WINAPI*&gt;
PROCEDURE WriteConsoleOutputCharacterW (hConsoleOutput        : HANDLE;
                                        lpCharacter           : LPWSTR;
                                        nLength               : DWORD;
                                        dwWriteCoord          : COORD;
                                        lpNumberOfCharsWritten: LPDWORD): BOOL;

CONST WriteConsoleOutputCharacter = WriteConsoleOutputCharacterA;

&lt;*EXTERNAL WriteConsoleOutputAttribute:WINAPI*&gt;
PROCEDURE WriteConsoleOutputAttribute (hConsoleOutput        : HANDLE;
                                       lpAttribute           : LPWORD;
                                       nLength               : DWORD;
                                       dwWriteCoord          : COORD;
                                       lpNumberOfAttrsWritten: LPDWORD): BOOL;

&lt;*EXTERNAL FillConsoleOutputCharacterA:WINAPI*&gt;
PROCEDURE FillConsoleOutputCharacterA (hConsoleOutput        : HANDLE;
                                       cCharacter            : CHAR;
                                       nLength               : DWORD;
                                       dwWriteCoord          : COORD;
                                       lpNumberOfCharsWritten: LPDWORD ): BOOL;

&lt;*EXTERNAL FillConsoleOutputCharacterW:WINAPI*&gt;
PROCEDURE FillConsoleOutputCharacterW (hConsoleOutput        : HANDLE;
                                       cCharacter            : WCHAR;
                                       nLength               : DWORD;
                                       dwWriteCoord          : COORD;
                                       lpNumberOfCharsWritten: LPDWORD ): BOOL;

CONST FillConsoleOutputCharacter = FillConsoleOutputCharacterA;

&lt;*EXTERNAL FillConsoleOutputAttribute:WINAPI*&gt;
PROCEDURE FillConsoleOutputAttribute (hConsoleOutput        : HANDLE;
                                      wAttribute            : WORD;
                                      nLength               : DWORD;
                                      dwWriteCoord          : COORD;
                                      lpNumberOfAttrsWritten: LPDWORD ): BOOL;

&lt;*EXTERNAL GetConsoleMode:WINAPI*&gt;
PROCEDURE GetConsoleMode (hConsoleHandle: HANDLE; lpMode: LPDWORD): BOOL;

&lt;*EXTERNAL GetNumberOfConsoleInputEvents:WINAPI*&gt;
PROCEDURE GetNumberOfConsoleInputEvents (hConsoleInput   : HANDLE;
                                           lpNumberOfEvents: LPDWORD ): BOOL;

&lt;*EXTERNAL GetConsoleScreenBufferInfo:WINAPI*&gt;
PROCEDURE GetConsoleScreenBufferInfo (
              hConsoleOutput: HANDLE;
              lpConsoleScreenBufferInfo: PCONSOLE_SCREEN_BUFFER_INFO): BOOL;

&lt;*EXTERNAL GetLargestConsoleWindowSize:WINAPI*&gt;
PROCEDURE GetLargestConsoleWindowSize (hConsoleOutput: HANDLE): COORD;

&lt;*EXTERNAL GetConsoleCursorInfo:WINAPI*&gt;
PROCEDURE GetConsoleCursorInfo (
                hConsoleOutput     : HANDLE;
                lpConsoleCursorInfo: PCONSOLE_CURSOR_INFO): BOOL;

&lt;*EXTERNAL GetNumberOfConsoleMouseButtons:WINAPI*&gt;
PROCEDURE GetNumberOfConsoleMouseButtons (
              lpNumberOfMouseButtons: LPDWORD): BOOL;

&lt;*EXTERNAL SetConsoleMode:WINAPI*&gt;
PROCEDURE SetConsoleMode (hConsoleHandle: HANDLE; dwMode: DWORD): BOOL;

&lt;*EXTERNAL SetConsoleActiveScreenBuffer:WINAPI*&gt;
PROCEDURE SetConsoleActiveScreenBuffer (hConsoleOutput: HANDLE): BOOL;

&lt;*EXTERNAL FlushConsoleInputBuffer:WINAPI*&gt;
PROCEDURE FlushConsoleInputBuffer (hConsoleInput: HANDLE): BOOL;

&lt;*EXTERNAL SetConsoleScreenBufferSize:WINAPI*&gt;
PROCEDURE SetConsoleScreenBufferSize (hConsoleOutput: HANDLE;
                                      dwSize        : COORD   ): BOOL;

&lt;*EXTERNAL SetConsoleCursorPosition:WINAPI*&gt;
PROCEDURE SetConsoleCursorPosition (hConsoleOutput  : HANDLE;
                                    dwCursorPosition: COORD   ): BOOL;

&lt;*EXTERNAL SetConsoleCursorInfo:WINAPI*&gt;
PROCEDURE SetConsoleCursorInfo (
              hConsoleOutput     : HANDLE;
              lpConsoleCursorInfo: PCONSOLE_CURSOR_INFO): BOOL;

&lt;*EXTERNAL ScrollConsoleScreenBufferA:WINAPI*&gt;
PROCEDURE ScrollConsoleScreenBufferA (hConsoleOutput     : HANDLE;
                                      lpScrollRectangle  : PSMALL_RECT;
                                      lpClipRectangle    : PSMALL_RECT;
                                      dwDestinationOrigin: COORD;
                                      lpFill             : PCHAR_INFO ): BOOL;

&lt;*EXTERNAL ScrollConsoleScreenBufferW:WINAPI*&gt;
PROCEDURE ScrollConsoleScreenBufferW (hConsoleOutput     : HANDLE;
                                      lpScrollRectangle  : PSMALL_RECT;
                                      lpClipRectangle    : PSMALL_RECT;
                                      dwDestinationOrigin: COORD;
                                      lpFill             : PCHAR_INFO ): BOOL;

CONST ScrollConsoleScreenBuffer = ScrollConsoleScreenBufferA;

&lt;*EXTERNAL SetConsoleWindowInfo:WINAPI*&gt;
PROCEDURE SetConsoleWindowInfo (hConsoleOutput : HANDLE;
                                bAbsolute      : BOOL;
                                lpConsoleWindow: PSMALL_RECT): BOOL;

&lt;*EXTERNAL SetConsoleTextAttribute:WINAPI*&gt;
PROCEDURE SetConsoleTextAttribute (hConsoleOutput: HANDLE;
                                   wAttributes   : WORD    ): BOOL;

&lt;*EXTERNAL SetConsoleCtrlHandler:WINAPI*&gt;
PROCEDURE SetConsoleCtrlHandler (HandlerRoutine: PHANDLER_ROUTINE;
                                 Add           : BOOL           ): BOOL;

&lt;*EXTERNAL GenerateConsoleCtrlEvent:WINAPI*&gt;
PROCEDURE GenerateConsoleCtrlEvent (dwCtrlEvent     : DWORD;
                                    dwProcessGroupId: DWORD  ): BOOL;

&lt;*EXTERNAL AllocConsole:WINAPI*&gt;
PROCEDURE AllocConsole (): BOOL;

&lt;*EXTERNAL FreeConsole:WINAPI*&gt;
PROCEDURE FreeConsole (): BOOL;

&lt;*EXTERNAL GetConsoleTitleA:WINAPI*&gt;
PROCEDURE GetConsoleTitleA (lpConsoleTitle: LPSTR; nSize: DWORD): DWORD;

&lt;*EXTERNAL GetConsoleTitleW:WINAPI*&gt;
PROCEDURE GetConsoleTitleW (lpConsoleTitle: LPWSTR; nSize: DWORD): DWORD;

CONST GetConsoleTitle = GetConsoleTitleA;

&lt;*EXTERNAL SetConsoleTitleA:WINAPI*&gt;
PROCEDURE SetConsoleTitleA (lpConsoleTitle: LPSTR): BOOL;

&lt;*EXTERNAL SetConsoleTitleW:WINAPI*&gt;
PROCEDURE SetConsoleTitleW (lpConsoleTitle: LPWSTR): BOOL;

CONST SetConsoleTitle = SetConsoleTitleA;

&lt;*EXTERNAL ReadConsoleA:WINAPI*&gt;
PROCEDURE ReadConsoleA (hConsoleInput       : HANDLE;
                        lpBuffer            : LPVOID;
                        nNumberOfCharsToRead: DWORD;
                        lpNumberOfCharsRead : LPDWORD;
                        lpReserved          : LPVOID   ): BOOL;

&lt;*EXTERNAL ReadConsoleW:WINAPI*&gt;
PROCEDURE ReadConsoleW (hConsoleInput       : HANDLE;
                        lpBuffer            : LPVOID;
                        nNumberOfCharsToRead: DWORD;
                        lpNumberOfCharsRead : LPDWORD;
                        lpReserved          : LPVOID   ): BOOL;

CONST ReadConsole = ReadConsoleA;

&lt;*EXTERNAL WriteConsoleA:WINAPI*&gt;
PROCEDURE WriteConsoleA (hConsoleOutput        : HANDLE;
                         lpBuffer              : Ctypes.void_star;
                         nNumberOfCharsToWrite : DWORD;
                         lpNumberOfCharsWritten: LPDWORD;
                         lpReserved            : LPVOID           ): BOOL;

&lt;*EXTERNAL WriteConsoleW:WINAPI*&gt;
PROCEDURE WriteConsoleW (hConsoleOutput        : HANDLE;
                         lpBuffer              : Ctypes.void_star;
                         nNumberOfCharsToWrite : DWORD;
                         lpNumberOfCharsWritten: LPDWORD;
                         lpReserved            : LPVOID          ): BOOL;

CONST WriteConsole = WriteConsoleA;

CONST CONSOLE_TEXTMODE_BUFFER = 1;

&lt;*EXTERNAL CreateConsoleScreenBuffer:WINAPI*&gt;
PROCEDURE CreateConsoleScreenBuffer (
              dwDesiredAccess     : DWORD;
              dwShareMode         : DWORD;
              lpSecurityAttributes: WinBase.LPSECURITY_ATTRIBUTES;
              dwFlags             : DWORD;
              lpScreenBufferData  : PVOID  ): HANDLE;

&lt;*EXTERNAL GetConsoleCP:WINAPI*&gt;
PROCEDURE GetConsoleCP (): UINT;

&lt;*EXTERNAL SetConsoleCP:WINAPI*&gt;
PROCEDURE SetConsoleCP (wCodePageID: UINT): BOOL;

&lt;*EXTERNAL GetConsoleOutputCP:WINAPI*&gt;
PROCEDURE GetConsoleOutputCP (): UINT;

&lt;*EXTERNAL SetConsoleOutputCP:WINAPI*&gt;
PROCEDURE SetConsoleOutputCP (wCodePageID: UINT): BOOL;

END WinCon.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
