<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinDef.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinDef.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P>
 * Here are Modula-3 procedures providing the functionality of C macros.
 

<P><PRE>MODULE <module><implements><A HREF="WinDef.i3">WinDef</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>;

TYPE
  dummy = RECORD unused: Ctypes.int; END;

REVEAL
  <A NAME="HWND">HWND</A>         = UNTRACED BRANDED &quot;HWND&quot; REF dummy;
  <A NAME="HHOOK">HHOOK</A>        = UNTRACED BRANDED &quot;HHOOK&quot; REF dummy;
  (** HGDIOBJ      = UNTRACED BRANDED &quot;HGDIOBJ&quot; REF dummy; **)
  <A NAME="HACCEL">HACCEL</A>       = UNTRACED BRANDED &quot;HACCEL&quot; REF dummy;
  <A NAME="HBITMAP">HBITMAP</A>      = UNTRACED BRANDED &quot;HBITMAP&quot; REF dummy;
  <A NAME="HBRUSH">HBRUSH</A>       = UNTRACED BRANDED &quot;HBRUSH&quot; REF dummy;
  <A NAME="HDC">HDC</A>          = UNTRACED BRANDED &quot;HDC&quot; REF dummy;
  <A NAME="HDESK">HDESK</A>        = UNTRACED BRANDED &quot;HDESK&quot; REF dummy;
  <A NAME="HENHMETAFILE">HENHMETAFILE</A> = UNTRACED BRANDED &quot;HENHMETAFILE&quot; REF dummy;
  <A NAME="HMF">HMF</A>          = UNTRACED BRANDED &quot;HMF&quot; REF dummy;
  <A NAME="HEMF">HEMF</A>         = UNTRACED BRANDED &quot;HEMF&quot; REF dummy;
  <A NAME="HFONT">HFONT</A>        = UNTRACED BRANDED &quot;HFONT&quot; REF dummy;
  <A NAME="HICON">HICON</A>        = UNTRACED BRANDED &quot;HICON&quot; REF dummy;
  <A NAME="HMENU">HMENU</A>        = UNTRACED BRANDED &quot;HMENU&quot; REF dummy;
  <A NAME="HMETAFILE">HMETAFILE</A>    = UNTRACED BRANDED &quot;HMETAFILE&quot; REF dummy;
  <A NAME="HINSTANCE">HINSTANCE</A>    = UNTRACED BRANDED &quot;HINSTANCE&quot; REF dummy;
  <A NAME="HPALETTE">HPALETTE</A>     = UNTRACED BRANDED &quot;HPALETTE&quot; REF dummy;
  <A NAME="HPEN">HPEN</A>         = UNTRACED BRANDED &quot;HPEN&quot; REF dummy;
  <A NAME="HRGN">HRGN</A>         = UNTRACED BRANDED &quot;HRGN&quot; REF dummy;
  <A NAME="HRSRC">HRSRC</A>        = UNTRACED BRANDED &quot;HRSRC&quot; REF dummy;
  <A NAME="HSTR">HSTR</A>         = UNTRACED BRANDED &quot;HSTR&quot; REF dummy;
  <A NAME="HWINSTA">HWINSTA</A>      = UNTRACED BRANDED &quot;HWINSTA&quot; REF dummy;
  <A NAME="HKL">HKL</A>          = UNTRACED BRANDED &quot;HKL&quot; REF dummy;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="MAKEWORD"><procedure>MAKEWORD</procedure></A> (a, b: BYTE): WORD =
  BEGIN
    RETURN Word.Or(a, Word.Shift(b, 8));
  END MAKEWORD;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="MAKELONG"><procedure>MAKELONG</procedure></A> (a, b: WORD): LONG =
  BEGIN
    RETURN Word.Or(a, Word.Shift(b, 16));
  END MAKELONG;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="LOWORD"><procedure>LOWORD</procedure></A> (l: LONG): WORD =
  BEGIN
    RETURN Word.And(l, 16_ffff);
  END LOWORD;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="HIWORD"><procedure>HIWORD</procedure></A> (l: LONG): WORD =
  BEGIN
    RETURN Word.And(Word.Shift(l, -16), 16_ffff);
  END HIWORD;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="LOBYTE"><procedure>LOBYTE</procedure></A> (w: WORD): BYTE =
  BEGIN
    RETURN Word.And(w, 16_ff)
  END LOBYTE;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="HIBYTE"><procedure>HIBYTE</procedure></A> (w: WORD): BYTE =
  BEGIN
    RETURN Word.And(Word.Shift(w, -8), 16_ff);
  END HIBYTE;

BEGIN
END WinDef.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
