<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinError.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinError.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>INTERFACE <interface>WinError</interface>;
</PRE> Corresponds to build version 0001 of <CODE>winerror.h</CODE>.
 * See that file for details.
 *
 *   This file contains the error code definitions for the Win32 API
 *   functions.
 

<P><PRE>FROM <A HREF="WinDef.i3">WinDef</A> IMPORT LONG;
</PRE>  Values are 32 bit values layed out as follows:

<P>   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1                      
   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  
  +---+-+-+-----------------------+-------------------------------+ 
  |Sev|C|R|     Facility          |               Code            | 
  +---+-+-+-----------------------+-------------------------------+ 
                                                                    
  where                                                             
                                                                    
      Sev - is the severity code                                    
                                                                    
          00 - Success                                              
          01 - Informational                                        
          10 - Warning                                              
          11 - Error                                                
                                                                    
      C - is the Customer code flag                                 
                                                                    
      R - is a reserved bit                                         
                                                                    
      Facility - is the facility code                               
                                                                    
      Code - is the facility's status code                          

<P>
<P> Define the facility codes

<P>
<P>
<P>
<P> Define the severity codes

<P>
<P><PRE>CONST NO_ERROR: LONG = 0;    (* dderror*)
</PRE><BLOCKQUOTE><EM> No error</EM></BLOCKQUOTE><PRE>

CONST ERROR_SUCCESS: LONG = 0;
</PRE><BLOCKQUOTE><EM> The configuration registry database operation completed successfully.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_FUNCTION: LONG = 1;    (* dderror*)
</PRE><BLOCKQUOTE><EM> Incorrect function</EM></BLOCKQUOTE><PRE>

CONST ERROR_FILE_NOT_FOUND: LONG = 2;
</PRE><BLOCKQUOTE><EM> The system cannot find the file specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PATH_NOT_FOUND: LONG = 3;
</PRE><BLOCKQUOTE><EM> The system cannot find the path specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_OPEN_FILES: LONG = 4;
</PRE><BLOCKQUOTE><EM> The system cannot open the file.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ACCESS_DENIED: LONG = 5;
</PRE><BLOCKQUOTE><EM> Access Denied.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_HANDLE: LONG = 6;
</PRE><BLOCKQUOTE><EM> The handle is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ARENA_TRASHED: LONG = 7;
</PRE><BLOCKQUOTE><EM> The storage control blocks were destroyed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_ENOUGH_MEMORY: LONG = 8;    (* dderror*)
</PRE><BLOCKQUOTE><EM> Not enough storage is available to process this command.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_BLOCK: LONG = 9;
</PRE><BLOCKQUOTE><EM> The storage control block address is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_ENVIRONMENT = 10;
</PRE><BLOCKQUOTE><EM> The environment is incorrect.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_FORMAT = 11;
</PRE><BLOCKQUOTE><EM> An attempt was made to load a program with an incorrect format.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ACCESS = 12;
</PRE><BLOCKQUOTE><EM> The access code is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_DATA = 13;
</PRE><BLOCKQUOTE><EM> The data is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_OUTOFMEMORY = 14;
</PRE><BLOCKQUOTE><EM> Not enough storage is available to complete this operation.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_DRIVE = 15;
</PRE><BLOCKQUOTE><EM> The system cannot find the drive specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CURRENT_DIRECTORY = 16;
</PRE><BLOCKQUOTE><EM> The directory cannot be removed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_SAME_DEVICE = 17;
</PRE><BLOCKQUOTE><EM> The system cannot move the file to a different disk drive.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_MORE_FILES = 18;
</PRE><BLOCKQUOTE><EM> There are no more files.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WRITE_PROTECT = 19;
</PRE><BLOCKQUOTE><EM> The diskette is write protected.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_UNIT = 20;
</PRE><BLOCKQUOTE><EM> The system cannot find the device specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_READY = 21;
</PRE><BLOCKQUOTE><EM> The drive is not ready.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_COMMAND = 22;
</PRE><BLOCKQUOTE><EM> The device does not recognize the command.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CRC = 23;
</PRE><BLOCKQUOTE><EM> Data error (cyclic redundancy check)</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_LENGTH = 24;
</PRE><BLOCKQUOTE><EM> The program issued a command but the command length is incorrect.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEEK = 25;
</PRE><BLOCKQUOTE><EM> The drive cannot locate a specific area or track on the disk.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_DOS_DISK = 26;
</PRE><BLOCKQUOTE><EM> The specified disk or diskette cannot be accessed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SECTOR_NOT_FOUND = 27;
</PRE><BLOCKQUOTE><EM> The drive cannot find the sector requested.</EM></BLOCKQUOTE><PRE>

CONST ERROR_OUT_OF_PAPER = 28;
</PRE><BLOCKQUOTE><EM> The printer is out of paper.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WRITE_FAULT = 29;
</PRE><BLOCKQUOTE><EM> The system cannot write to the specified device.</EM></BLOCKQUOTE><PRE>

CONST ERROR_READ_FAULT = 30;
</PRE><BLOCKQUOTE><EM> The system cannot read from the specified device.</EM></BLOCKQUOTE><PRE>

CONST ERROR_GEN_FAILURE = 31;
</PRE><BLOCKQUOTE><EM> A device attached to the system is not functioning.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SHARING_VIOLATION = 32;
</PRE><BLOCKQUOTE><EM> The process cannot access the file because
    it is being used by another process.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LOCK_VIOLATION = 33;
</PRE><BLOCKQUOTE><EM> The process cannot access the file because
    another process has locked a portion of the file.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WRONG_DISK = 34;
</PRE><BLOCKQUOTE><EM> The wrong diskette is in the drive.</EM></BLOCKQUOTE><PRE>
</PRE> Insert %2 (Volume Serial Number: %3)
 into drive %1.

<P><PRE>CONST ERROR_SHARING_BUFFER_EXCEEDED = 36;
</PRE><BLOCKQUOTE><EM> Too many files opened for sharing.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HANDLE_EOF = 38;
</PRE><BLOCKQUOTE><EM> Reached End of File.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HANDLE_DISK_FULL = 39;
</PRE><BLOCKQUOTE><EM> The disk is full.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_SUPPORTED = 50;
</PRE><BLOCKQUOTE><EM> The network request is not supported.</EM></BLOCKQUOTE><PRE>

CONST ERROR_REM_NOT_LIST = 51;
</PRE><BLOCKQUOTE><EM> The remote computer is not available.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DUP_NAME = 52;
</PRE><BLOCKQUOTE><EM> A duplicate name exists on the network.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_NETPATH = 53;
</PRE><BLOCKQUOTE><EM> The network path was not found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NETWORK_BUSY = 54;
</PRE><BLOCKQUOTE><EM> The network is busy.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DEV_NOT_EXIST = 55;
</PRE><BLOCKQUOTE><EM> The specified network resource is no longer</EM></BLOCKQUOTE><PRE>
</PRE> available.

<P><PRE>CONST ERROR_TOO_MANY_CMDS = 56;
</PRE><BLOCKQUOTE><EM> The network BIOS command limit has been reached.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ADAP_HDW_ERR = 57;
</PRE><BLOCKQUOTE><EM> A network adapter hardware error occurred.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_NET_RESP = 58;
</PRE><BLOCKQUOTE><EM> The specified server cannot perform the requested</EM></BLOCKQUOTE><PRE>
</PRE> operation.

<P><PRE>CONST ERROR_UNEXP_NET_ERR = 59;
</PRE><BLOCKQUOTE><EM> An unexpected network error occurred.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_REM_ADAP = 60;
</PRE><BLOCKQUOTE><EM> The remote adapter is not compatible.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PRINTQ_FULL = 61;
</PRE><BLOCKQUOTE><EM> The printer queue is full.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SPOOL_SPACE = 62;
</PRE><BLOCKQUOTE><EM> Space to store the file waiting to be printed is</EM></BLOCKQUOTE><PRE>
</PRE> not available on the server.

<P><PRE>CONST ERROR_PRINT_CANCELLED = 63;
</PRE><BLOCKQUOTE><EM> Your file waiting to be printed was deleted.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NETNAME_DELETED = 64;
</PRE><BLOCKQUOTE><EM> The specified network name is no longer available.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NETWORK_ACCESS_DENIED = 65;
</PRE><BLOCKQUOTE><EM> Network access is denied.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_DEV_TYPE = 66;
</PRE><BLOCKQUOTE><EM> The network resource type is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_NET_NAME = 67;
</PRE><BLOCKQUOTE><EM> The network name cannot be found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_NAMES = 68;
</PRE><BLOCKQUOTE><EM> The name limit for the local computer network</EM></BLOCKQUOTE><PRE>
</PRE> adapter card was exceeded.

<P><PRE>CONST ERROR_TOO_MANY_SESS = 69;
</PRE><BLOCKQUOTE><EM> The network BIOS session limit was exceeded.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SHARING_PAUSED = 70;
</PRE><BLOCKQUOTE><EM> The remote server has been paused or is in the</EM></BLOCKQUOTE><PRE>
</PRE> process of being started.

<P><PRE>CONST ERROR_REQ_NOT_ACCEP = 71;
</PRE><BLOCKQUOTE><EM> The network request was not accepted.</EM></BLOCKQUOTE><PRE>

CONST ERROR_REDIR_PAUSED = 72;
</PRE><BLOCKQUOTE><EM> The specified printer or disk device has been paused.</EM></BLOCKQUOTE><PRE>

CONST ERROR_FILE_EXISTS = 80;
</PRE><BLOCKQUOTE><EM> The file exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANNOT_MAKE = 82;
</PRE><BLOCKQUOTE><EM> The directory or file cannot be created.</EM></BLOCKQUOTE><PRE>

CONST ERROR_FAIL_I24 = 83;
</PRE><BLOCKQUOTE><EM> Fail on INT 24</EM></BLOCKQUOTE><PRE>

CONST ERROR_OUT_OF_STRUCTURES = 84;
</PRE><BLOCKQUOTE><EM> Storage to process this request is not available.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ALREADY_ASSIGNED = 85;
</PRE><BLOCKQUOTE><EM> The local device name is already in use.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PASSWORD = 86;
</PRE><BLOCKQUOTE><EM> The specified network password is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PARAMETER = 87;
</PRE><BLOCKQUOTE><EM> The parameter is incorrect.</EM></BLOCKQUOTE><PRE>    (* dderror*)

CONST ERROR_NET_WRITE_FAULT = 88;
</PRE><BLOCKQUOTE><EM> A write fault occurred on the network.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_PROC_SLOTS = 89;
</PRE><BLOCKQUOTE><EM> The system cannot start another process at</EM></BLOCKQUOTE><PRE>
</PRE> this time.

<P><PRE>CONST ERROR_TOO_MANY_SEMAPHORES = 100;
</PRE><BLOCKQUOTE><EM> Cannot create another system semaphore.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EXCL_SEM_ALREADY_OWNED = 101;
</PRE><BLOCKQUOTE><EM> The exclusive semaphore is owned by another process.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEM_IS_SET = 102;
</PRE><BLOCKQUOTE><EM> The semaphore is set and cannot be closed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_SEM_REQUESTS = 103;
</PRE><BLOCKQUOTE><EM> The semaphore cannot be set again.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_AT_INTERRUPT_TIME = 104;
</PRE><BLOCKQUOTE><EM> Cannot request exclusive semaphores at interrupt time.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEM_OWNER_DIED = 105;
</PRE><BLOCKQUOTE><EM> The previous ownership of this semaphore has ended.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEM_USER_LIMIT = 106;
</PRE><BLOCKQUOTE><EM> Insert the diskette for drive %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_CHANGE = 107;
</PRE><BLOCKQUOTE><EM> Program stopped because alternate diskette was not inserted.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DRIVE_LOCKED = 108;
</PRE><BLOCKQUOTE><EM> The disk is in use or locked by</EM></BLOCKQUOTE><PRE>
</PRE> another process.

<P><PRE>CONST ERROR_BROKEN_PIPE = 109;
</PRE><BLOCKQUOTE><EM> The pipe has been ended.</EM></BLOCKQUOTE><PRE>

CONST ERROR_OPEN_FAILED = 110;
</PRE><BLOCKQUOTE><EM> The system cannot open the</EM></BLOCKQUOTE><PRE>
</PRE> device or file specified.

<P><PRE>CONST ERROR_BUFFER_OVERFLOW = 111;
</PRE><BLOCKQUOTE><EM> The file name is too long.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_FULL = 112;
</PRE><BLOCKQUOTE><EM> There is not enough space on the disk.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_MORE_SEARCH_HANDLES = 113;
</PRE><BLOCKQUOTE><EM> No more internal file identifiers available.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_TARGET_HANDLE = 114;
</PRE><BLOCKQUOTE><EM> The target internal file identifier is incorrect.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_CATEGORY = 117;
</PRE><BLOCKQUOTE><EM> The IOCTL call made by the application program is</EM></BLOCKQUOTE><PRE>
</PRE> not correct.

<P><PRE>CONST ERROR_INVALID_VERIFY_SWITCH = 118;
</PRE><BLOCKQUOTE><EM> The verify-on-write switch parameter value is not</EM></BLOCKQUOTE><PRE>
</PRE> correct.

<P><PRE>CONST ERROR_BAD_DRIVER_LEVEL = 119;
</PRE><BLOCKQUOTE><EM> The system does not support the command requested.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CALL_NOT_IMPLEMENTED = 120;
</PRE><BLOCKQUOTE><EM> The Application Program Interface (API) entered</EM></BLOCKQUOTE><PRE>
</PRE> will only work in Windows/NT mode.

<P><PRE>CONST ERROR_SEM_TIMEOUT = 121;
</PRE><BLOCKQUOTE><EM> The semaphore timeout period has expired.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INSUFFICIENT_BUFFER = 122;
</PRE><BLOCKQUOTE><EM> The data area passed to a system call is too</EM></BLOCKQUOTE><PRE>
</PRE> small.     dderror

<P><PRE>CONST ERROR_INVALID_NAME = 123;
</PRE><BLOCKQUOTE><EM> The file name, directory name, or volume label is not syntactically correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_LEVEL = 124;
</PRE><BLOCKQUOTE><EM> The system call level is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_VOLUME_LABEL = 125;
</PRE><BLOCKQUOTE><EM> The disk has no volume label.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MOD_NOT_FOUND = 126;
</PRE><BLOCKQUOTE><EM> The specified module could not be found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PROC_NOT_FOUND = 127;
</PRE><BLOCKQUOTE><EM> The specified procedure could not be found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WAIT_NO_CHILDREN = 128;
</PRE><BLOCKQUOTE><EM> There are no child processes to wait for.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CHILD_NOT_COMPLETE = 129;
</PRE><BLOCKQUOTE><EM> The %1 application cannot be run in Windows mode.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DIRECT_ACCESS_HANDLE = 130;
</PRE><BLOCKQUOTE><EM> BUGBUG - message text missing.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NEGATIVE_SEEK = 131;
</PRE><BLOCKQUOTE><EM> BUGBUG - message text missing.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEEK_ON_DEVICE = 132;
</PRE><BLOCKQUOTE><EM> BUGBUG - message text missing.</EM></BLOCKQUOTE><PRE>

CONST ERROR_IS_JOIN_TARGET = 133;
</PRE><BLOCKQUOTE><EM> A JOIN or SUBST command</EM></BLOCKQUOTE><PRE>
</PRE> cannot be used for a drive that
 contains previously joined drives.

<P><PRE>CONST ERROR_IS_JOINED = 134;
</PRE><BLOCKQUOTE><EM> An attempt was made to use a</EM></BLOCKQUOTE><PRE>
</PRE> JOIN or SUBST command on a drive that has
 already been joined.

<P><PRE>CONST ERROR_IS_SUBSTED = 135;
</PRE><BLOCKQUOTE><EM> An attempt was made to use a</EM></BLOCKQUOTE><PRE>
</PRE> JOIN or SUBST command on a drive that has
 already been substituted.

<P><PRE>CONST ERROR_NOT_JOINED = 136;
</PRE><BLOCKQUOTE><EM> The system tried to delete</EM></BLOCKQUOTE><PRE>
</PRE> the JOIN of a drive that is not joined.

<P><PRE>CONST ERROR_NOT_SUBSTED = 137;
</PRE><BLOCKQUOTE><EM> The system tried to delete the</EM></BLOCKQUOTE><PRE>
</PRE> substitution of a drive that is not substituted.

<P><PRE>CONST ERROR_JOIN_TO_JOIN = 138;
</PRE><BLOCKQUOTE><EM> The system tried to join a drive</EM></BLOCKQUOTE><PRE>
</PRE> to a directory on a joined drive.

<P><PRE>CONST ERROR_SUBST_TO_SUBST = 139;
</PRE><BLOCKQUOTE><EM> The system tried to substitute a</EM></BLOCKQUOTE><PRE>
</PRE> drive to a directory on a substituted drive.

<P><PRE>CONST ERROR_JOIN_TO_SUBST = 140;
</PRE><BLOCKQUOTE><EM> The system tried to join a drive to</EM></BLOCKQUOTE><PRE>
</PRE> a directory on a substituted drive.

<P><PRE>CONST ERROR_SUBST_TO_JOIN = 141;
</PRE><BLOCKQUOTE><EM> The system tried to SUBST a drive</EM></BLOCKQUOTE><PRE>
</PRE> to a directory on a joined drive.

<P><PRE>CONST ERROR_BUSY_DRIVE = 142;
</PRE><BLOCKQUOTE><EM> The system cannot perform a JOIN or SUBST at this time.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SAME_DRIVE = 143;
</PRE><BLOCKQUOTE><EM> The system cannot join or substitute a</EM></BLOCKQUOTE><PRE>
</PRE> drive to or for a directory on the same drive.

<P><PRE>CONST ERROR_DIR_NOT_ROOT = 144;
</PRE><BLOCKQUOTE><EM> The directory is not a subdirectory of the root directory.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DIR_NOT_EMPTY = 145;
</PRE><BLOCKQUOTE><EM> The directory is not empty.</EM></BLOCKQUOTE><PRE>

CONST ERROR_IS_SUBST_PATH = 146;
</PRE><BLOCKQUOTE><EM> The path specified is being used in</EM></BLOCKQUOTE><PRE>
</PRE> a substitute.

<P><PRE>CONST ERROR_IS_JOIN_PATH = 147;
</PRE><BLOCKQUOTE><EM> Not enough resources are available to</EM></BLOCKQUOTE><PRE>
</PRE> process this command.

<P><PRE>CONST ERROR_PATH_BUSY = 148;
</PRE><BLOCKQUOTE><EM> The path specified cannot be used at this time.</EM></BLOCKQUOTE><PRE>

CONST ERROR_IS_SUBST_TARGET = 149;
</PRE><BLOCKQUOTE><EM> An attempt was made to join</EM></BLOCKQUOTE><PRE>
</PRE> or substitute a drive for which a directory
 on the drive is the target of a previous
 substitute.

<P><PRE>CONST ERROR_SYSTEM_TRACE = 150;
</PRE><BLOCKQUOTE><EM> System trace information was not specified in your</EM></BLOCKQUOTE><PRE>
</PRE> CONFIG.SYS file, or tracing is disallowed.

<P><PRE>CONST ERROR_INVALID_EVENT_COUNT = 151;
</PRE><BLOCKQUOTE><EM> The number of specified semaphore events for</EM></BLOCKQUOTE><PRE>
</PRE> DosMuxSemWait is not correct.

<P><PRE>CONST ERROR_TOO_MANY_MUXWAITERS = 152;
</PRE><BLOCKQUOTE><EM> DosMuxSemWait did not execute; too many semaphores</EM></BLOCKQUOTE><PRE>
</PRE> are already set.

<P><PRE>CONST ERROR_INVALID_LIST_FORMAT = 153;
</PRE><BLOCKQUOTE><EM> The DosMuxSemWait list is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LABEL_TOO_LONG = 154;
</PRE><BLOCKQUOTE><EM> The volume label you entered exceeds the</EM></BLOCKQUOTE><PRE>
</PRE> 11 character limit.  The first 11 characters were written
 to disk.  Any characters that exceeded the 11 character limit
 were automatically deleted.

<P><PRE>CONST ERROR_TOO_MANY_TCBS = 155;
</PRE><BLOCKQUOTE><EM> Cannot create another thread.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SIGNAL_REFUSED = 156;
</PRE><BLOCKQUOTE><EM> The recipient process has refused the signal.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISCARDED = 157;
</PRE><BLOCKQUOTE><EM> The segment is already discarded and cannot be locked.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_LOCKED = 158;
</PRE><BLOCKQUOTE><EM> The segment is already unlocked.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_THREADID_ADDR = 159;
</PRE><BLOCKQUOTE><EM> The address for the thread ID is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_ARGUMENTS = 160;
</PRE><BLOCKQUOTE><EM> The argument string passed to DosExecPgm is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_PATHNAME = 161;
</PRE><BLOCKQUOTE><EM> Invalid path name specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SIGNAL_PENDING = 162;
</PRE><BLOCKQUOTE><EM> A signal is already pending.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MAX_THRDS_REACHED = 164;
</PRE><BLOCKQUOTE><EM> No more threads can be created in the system.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LOCK_FAILED = 167;
</PRE><BLOCKQUOTE><EM> Attempt to lock a region of a file failed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BUSY = 170;
</PRE><BLOCKQUOTE><EM> The requested resource is in use.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANCEL_VIOLATION = 173;
</PRE><BLOCKQUOTE><EM> A lock request was not outstanding for the supplied cancel region.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
</PRE><BLOCKQUOTE><EM> The file system does not supporting atomic changing of the lock type.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SEGMENT_NUMBER = 180;
</PRE><BLOCKQUOTE><EM> The system detected a segment number that was not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ORDINAL = 182;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ALREADY_EXISTS = 183;
</PRE><BLOCKQUOTE><EM> Attempt to create file that already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_FLAG_NUMBER = 186;
</PRE><BLOCKQUOTE><EM> The flag passed is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SEM_NOT_FOUND = 187;
</PRE><BLOCKQUOTE><EM> The specified system semaphore name was not found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_STARTING_CODESEG = 188;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_STACKSEG = 189;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MODULETYPE = 190;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_EXE_SIGNATURE = 191;
</PRE><BLOCKQUOTE><EM> %1 cannot be run in Windows/NT mode.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EXE_MARKED_INVALID = 192;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_EXE_FORMAT = 193;
</PRE><BLOCKQUOTE><EM> %1 is not a valid Windows application.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ITERATED_DATA_EXCEEDS_64k = 194;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MINALLOCSIZE = 195;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DYNLINK_FROM_INVALID_RING = 196;
</PRE><BLOCKQUOTE><EM> The operating system cannot run this</EM></BLOCKQUOTE><PRE>
</PRE> application program.

<P><PRE>CONST ERROR_IOPL_NOT_ENABLED = 197;
</PRE><BLOCKQUOTE><EM> The operating system is not presently</EM></BLOCKQUOTE><PRE>
</PRE> configured to run this application.

<P><PRE>CONST ERROR_INVALID_SEGDPL = 198;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_AUTODATASEG_EXCEEDS_64k = 199;
</PRE><BLOCKQUOTE><EM> The operating system cannot run this</EM></BLOCKQUOTE><PRE>
</PRE> application program.

<P><PRE>CONST ERROR_RING2SEG_MUST_BE_MOVABLE = 200;
</PRE><BLOCKQUOTE><EM> The code segment cannot be greater than or equal to 64KB.</EM></BLOCKQUOTE><PRE>

CONST ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INFLOOP_IN_RELOC_CHAIN = 202;
</PRE><BLOCKQUOTE><EM> The operating system cannot run %1.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ENVVAR_NOT_FOUND = 203;
</PRE><BLOCKQUOTE><EM> The system could not find the environment</EM></BLOCKQUOTE><PRE>
</PRE> option that was entered.

<P><PRE>CONST ERROR_NO_SIGNAL_SENT = 205;
</PRE><BLOCKQUOTE><EM> No process in the command subtree has a</EM></BLOCKQUOTE><PRE>
</PRE> signal handler.

<P><PRE>CONST ERROR_FILENAME_EXCED_RANGE = 206;
</PRE><BLOCKQUOTE><EM> The file name or extension is too long.</EM></BLOCKQUOTE><PRE>

CONST ERROR_RING2_STACK_IN_USE = 207;
</PRE><BLOCKQUOTE><EM> The ring 2 stack is in use.</EM></BLOCKQUOTE><PRE>

CONST ERROR_META_EXPANSION_TOO_LONG = 208;
</PRE><BLOCKQUOTE><EM> The global file name characters, * or ? are entered</EM></BLOCKQUOTE><PRE>
</PRE> incorrectly or too many global file name characters are specified.

<P><PRE>CONST ERROR_INVALID_SIGNAL_NUMBER = 209;
</PRE><BLOCKQUOTE><EM> The signal being posted is not correct.</EM></BLOCKQUOTE><PRE>

CONST ERROR_THREAD_1_INACTIVE = 210;
</PRE><BLOCKQUOTE><EM> The signal handler cannot be set.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LOCKED = 212;
</PRE><BLOCKQUOTE><EM> The segment is locked and cannot be reallocated.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_MODULES = 214;
</PRE><BLOCKQUOTE><EM> Too many dynamic link modules are attached to this</EM></BLOCKQUOTE><PRE>
</PRE> program or dynamic link module.

<P><PRE>CONST ERROR_NESTING_NOT_ALLOWED = 215;
</PRE><BLOCKQUOTE><EM> Can't nest calls to LoadModule.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_PIPE = 230;
</PRE><BLOCKQUOTE><EM> Invalid pipe state.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PIPE_BUSY = 231;
</PRE><BLOCKQUOTE><EM> All pipe instances busy.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_DATA = 232;
</PRE><BLOCKQUOTE><EM> Pipe close in progress.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PIPE_NOT_CONNECTED = 233;
</PRE><BLOCKQUOTE><EM> No process on other end of pipe.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MORE_DATA = 234;
</PRE><BLOCKQUOTE><EM> More data is available.</EM></BLOCKQUOTE><PRE>    (* dderror*)

CONST ERROR_VC_DISCONNECTED = 240;
</PRE><BLOCKQUOTE><EM> The session was cancelled.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_EA_NAME = 254;
</PRE><BLOCKQUOTE><EM> The specified EA name was invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EA_LIST_INCONSISTENT = 255;
</PRE><BLOCKQUOTE><EM> The EAs are inconsistent.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_MORE_ITEMS = 259;
</PRE><BLOCKQUOTE><EM> No more data is available.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANNOT_COPY = 266;
</PRE><BLOCKQUOTE><EM> The Copy API cannot be used.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DIRECTORY = 267;
</PRE><BLOCKQUOTE><EM> Invalid directory name.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EAS_DIDNT_FIT = 275;
</PRE><BLOCKQUOTE><EM> The EAs did not fit in the buffer.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EA_FILE_CORRUPT = 276;
</PRE><BLOCKQUOTE><EM> The EA file on the mounted file system is corrupt.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EA_TABLE_FULL = 277;
</PRE><BLOCKQUOTE><EM> The EA table in the EA file on the mounted file system is full.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_EA_HANDLE = 278;
</PRE><BLOCKQUOTE><EM> The EA handle specified is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EAS_NOT_SUPPORTED = 282;
</PRE><BLOCKQUOTE><EM> The mounted file system does not support extended attributes.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_OWNER = 288;
</PRE><BLOCKQUOTE><EM> Attempt to release mutex not owned by caller.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_POSTS = 298;
</PRE><BLOCKQUOTE><EM> Too many posts were made to a semaphore.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MR_MID_NOT_FOUND = 317;
</PRE><BLOCKQUOTE><EM> The system cannot find message for message number 0x%1</EM></BLOCKQUOTE><PRE>
</PRE> in message file for %2.

<P><PRE>CONST ERROR_INVALID_ADDRESS = 487;
</PRE><BLOCKQUOTE><EM> Attempt to access invalid address.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ARITHMETIC_OVERFLOW = 534;
</PRE><BLOCKQUOTE><EM> Arithmatic result exceeded 32-bits.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PIPE_CONNECTED = 535;
</PRE><BLOCKQUOTE><EM> There is a process on other end of the pipe.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PIPE_LISTENING = 536;
</PRE><BLOCKQUOTE><EM> Waiting for a process to open the other end of the pipe.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EA_ACCESS_DENIED = 994;
</PRE><BLOCKQUOTE><EM> Access to the EA was denied.</EM></BLOCKQUOTE><PRE>

CONST ERROR_OPERATION_ABORTED = 995;
</PRE><BLOCKQUOTE><EM> The IO operation has been aborted due to either thread exit</EM></BLOCKQUOTE><PRE>
</PRE> or application request.

<P><PRE>CONST ERROR_IO_INCOMPLETE = 996;
</PRE><BLOCKQUOTE><EM> Overlapped IO event not in signalled state.</EM></BLOCKQUOTE><PRE>

CONST ERROR_IO_PENDING = 997;
</PRE><BLOCKQUOTE><EM> Overlapped IO operation in progress.</EM></BLOCKQUOTE><PRE>    (* dderror*)

CONST ERROR_NOACCESS = 998;
</PRE><BLOCKQUOTE><EM> Invalid access to memory location.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SWAPERROR = 999;
</PRE><BLOCKQUOTE><EM> Error accessing paging file.</EM></BLOCKQUOTE><PRE>

CONST ERROR_STACK_OVERFLOW = 1001;
</PRE><BLOCKQUOTE><EM> Recursion too deep, stack overflowed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MESSAGE = 1002;
</PRE><BLOCKQUOTE><EM> Window can't handle sent message.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CAN_NOT_COMPLETE = 1003;
</PRE><BLOCKQUOTE><EM> Cannot complete function for some reason.  Like calling GetSelection()</EM></BLOCKQUOTE><PRE>
</PRE> when there is no selection.

<P><PRE>CONST ERROR_INVALID_FLAGS = 1004;
</PRE><BLOCKQUOTE><EM> Invalid flags.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNRECOGNIZED_VOLUME = 1005;
</PRE><BLOCKQUOTE><EM> The volume does not contain a recognized file system.</EM></BLOCKQUOTE><PRE>
</PRE> Please make sure that all required file system drivers are loaded and that the
 volume is not corrupt.

<P><PRE>CONST ERROR_FILE_INVALID = 1006;
</PRE><BLOCKQUOTE><EM> The volume for a file has been externally altered such that the</EM></BLOCKQUOTE><PRE>
</PRE> opened file is no longer valid.

<P><PRE>CONST ERROR_FULLSCREEN_MODE = 1007;
</PRE><BLOCKQUOTE><EM> The requested operation cannot be performed in fullscreen mode.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_TOKEN = 1008;
</PRE><BLOCKQUOTE><EM> An attempt was made to reference a token that does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BADDB = 1009;
</PRE><BLOCKQUOTE><EM> The configuration registry database is corrupt.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BADKEY = 1010;
</PRE><BLOCKQUOTE><EM> The configuration registry key is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANTOPEN = 1011;
</PRE><BLOCKQUOTE><EM> The configuration registry key could not be opened.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANTREAD = 1012;
</PRE><BLOCKQUOTE><EM> The configuration registry key could not be read.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANTWRITE = 1013;
</PRE><BLOCKQUOTE><EM> The configuration registry key could not be written.</EM></BLOCKQUOTE><PRE>

CONST ERROR_REGISTRY_RECOVERED = 1014;
</PRE><BLOCKQUOTE><EM> One of the files containing the system's Registry data had to be recovered</EM></BLOCKQUOTE><PRE>
</PRE> by use of a log or alternate copy.  The recovery was successful.

<P><PRE>CONST ERROR_REGISTRY_CORRUPT = 1015;
</PRE><BLOCKQUOTE><EM> The Registry is corrupt.</EM></BLOCKQUOTE><PRE>
</PRE> The structure of one of the files that contains Registry data is corrupt, or
 the system's in memory image of the file is corrupt, or the file could not
 be recovered because its alternate copy or log was absent or corrupt.

<P><PRE>CONST ERROR_REGISTRY_IO_FAILED = 1016;
</PRE><BLOCKQUOTE><EM> An I/O operation initiated by the Registry failed unrecoverably.</EM></BLOCKQUOTE><PRE>
</PRE> The Registry could not read in, or write out, or flush, one of the files
 that contain the system's image of the Registry.

<P><PRE>CONST ERROR_NOT_REGISTRY_FILE = 1017;
</PRE><BLOCKQUOTE><EM> The system has attempted to load or restore a file into the registry, and the</EM></BLOCKQUOTE><PRE>
</PRE> specified file is not in the format of a registry file.

<P><PRE>CONST ERROR_KEY_DELETED = 1018;
</PRE><BLOCKQUOTE><EM> Illegal operation attempted on a registry key which has been marked for deletion.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_LOG_SPACE = 1019;
</PRE><BLOCKQUOTE><EM> System could not allocate required space in a registry log.</EM></BLOCKQUOTE><PRE>

CONST ERROR_KEY_HAS_CHILDREN = 1020;
</PRE><BLOCKQUOTE><EM> An attempt was made to create a symbolic link in a registry key that already</EM></BLOCKQUOTE><PRE>
</PRE> has subkeys or values.

<P><PRE>CONST ERROR_CHILD_MUST_BE_VOLATILE = 1021;
</PRE><BLOCKQUOTE><EM> An attempt was made to create a Stable subkey under a Volatile parent key.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOTIFY_ENUM_DIR = 1022;
</PRE><BLOCKQUOTE><EM> This indicates that a notify change request is being completed and that the</EM></BLOCKQUOTE><PRE>
</PRE> information is not being returned in the caller's buffer.  The caller now
 needs to enumerate the files to find the changes.

<P><PRE>CONST ERROR_DEPENDENT_SERVICES_RUNNING = 1051;
</PRE><BLOCKQUOTE><EM> A stop control has been sent to a service which other running services</EM></BLOCKQUOTE><PRE>
</PRE> are dependent on.

<P><PRE>CONST ERROR_INVALID_SERVICE_CONTROL = 1052;
</PRE><BLOCKQUOTE><EM> The requested control is not valid for this service</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
</PRE><BLOCKQUOTE><EM> The service did not respond to the start or control request in a timely</EM></BLOCKQUOTE><PRE>
</PRE> fashion.

<P><PRE>CONST ERROR_SERVICE_NO_THREAD = 1054;
</PRE><BLOCKQUOTE><EM> A thread could not be created for the Win32 service.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_DATABASE_LOCKED = 1055;
</PRE><BLOCKQUOTE><EM> The service database is locked.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_ALREADY_RUNNING = 1056;
</PRE><BLOCKQUOTE><EM> An instance of the service is already running.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SERVICE_ACCOUNT = 1057;
</PRE><BLOCKQUOTE><EM> The account name is invalid or does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_DISABLED = 1058;
</PRE><BLOCKQUOTE><EM> The specified service is disabled and cannot be started.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CIRCULAR_DEPENDENCY = 1059;
</PRE><BLOCKQUOTE><EM> Circular service dependency was specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_DOES_NOT_EXIST = 1060;
</PRE><BLOCKQUOTE><EM> The specified service does not exist as an installed service.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;
</PRE><BLOCKQUOTE><EM> The service cannot accept control messages at this time.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_NOT_ACTIVE = 1062;
</PRE><BLOCKQUOTE><EM> The service has not been started.</EM></BLOCKQUOTE><PRE>

CONST ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063;
</PRE><BLOCKQUOTE><EM> The service process could not connect to the service controller.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EXCEPTION_IN_SERVICE = 1064;
</PRE><BLOCKQUOTE><EM> An exception occurred in the service when handling the control request.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DATABASE_DOES_NOT_EXIST = 1065;
</PRE><BLOCKQUOTE><EM> The database specified does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_SPECIFIC_ERROR = 1066;
</PRE><BLOCKQUOTE><EM> The service has returned a service specific error code.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PROCESS_ABORTED = 1067;
</PRE><BLOCKQUOTE><EM> The process terminated unexpectedly.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
</PRE><BLOCKQUOTE><EM> The dependency service or group failed to start.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_LOGON_FAILED = 1069;
</PRE><BLOCKQUOTE><EM> The service failed to be logged on.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_START_HANG = 1070;
</PRE><BLOCKQUOTE><EM> The service hung on starting.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SERVICE_LOCK = 1071;
</PRE><BLOCKQUOTE><EM> The specified service database lock is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
</PRE><BLOCKQUOTE><EM> The specified service has been marked for deletion.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_EXISTS = 1073;
</PRE><BLOCKQUOTE><EM> The specified service already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ALREADY_RUNNING_LKG = 1074;
</PRE><BLOCKQUOTE><EM> The system is currently booted using the last-known-good configuration.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVICE_DEPENDENCY_DELETED = 1075;
</PRE><BLOCKQUOTE><EM> The dependency service does not exist or has been marked for</EM></BLOCKQUOTE><PRE>
</PRE> deletion.

<P><PRE>CONST ERROR_BOOT_ALREADY_ACCEPTED = 1076;
</PRE><BLOCKQUOTE><EM> The current boot has already been accepted for use as the</EM></BLOCKQUOTE><PRE>
</PRE> last-known-good control set.

<P><PRE>CONST ERROR_END_OF_MEDIA = 1100;
</PRE><BLOCKQUOTE><EM> End of tape mark has been reached during an operation.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SHORT_FILEMARK_DETECTED = 1101;
</PRE><BLOCKQUOTE><EM> A tape access reached a short filemark.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LONG_FILEMARK_DETECTED = 1102;
</PRE><BLOCKQUOTE><EM> A tape access reached a long filemark.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SETMARK_DETECTED = 1103;
</PRE><BLOCKQUOTE><EM> A tape access reached a setmark.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_DATA_DETECTED = 1104;
</PRE><BLOCKQUOTE><EM> During a tape access, the end of the data written is reached.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PARTITION_FAILURE = 1105;
</PRE><BLOCKQUOTE><EM> Tape could not be partitioned.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_BLOCK_LENGTH = 1106;
</PRE><BLOCKQUOTE><EM> When accessing a new tape of a multivolume partition, the current</EM></BLOCKQUOTE><PRE>
</PRE> blocksize is incorrect.

<P><PRE>CONST ERROR_DEVICE_NOT_PARTITIONED = 1107;
</PRE><BLOCKQUOTE><EM> Tape partition information could not be found when loading a tape.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNABLE_TO_LOCK_MEDIA = 1108;
</PRE><BLOCKQUOTE><EM> Attempt to lock the eject media mechansism fails.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;
</PRE><BLOCKQUOTE><EM> Unload media fails.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TAPE_WRITE_PROTECTED = 1110;
</PRE><BLOCKQUOTE><EM> Attempt to write to or erase a write protected tape.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TAPE_OPERATION_NOT_SUPPORTED = 1111;
</PRE><BLOCKQUOTE><EM> Attempted operation not supported on drive.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_TAPE_IN_DRIVE = 1112;
</PRE><BLOCKQUOTE><EM> Tape query failed because of no tape in drive.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_UNICODE_TRANSLATION = 1113;
</PRE><BLOCKQUOTE><EM> No mapping for the Unicode character exists in the target multi-byte code page.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DLL_INIT_FAILED = 1114;
</PRE><BLOCKQUOTE><EM> A DLL initialization routine failed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SHUTDOWN_IN_PROGRESS = 1115;
</PRE><BLOCKQUOTE><EM> A system shutdown is in progress.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;
</PRE><BLOCKQUOTE><EM> An attempt to abort the shutdown of the system failed because no shutdown</EM></BLOCKQUOTE><PRE>
</PRE> was in progress.

<P><PRE>CONST ERROR_IO_DEVICE = 1117;
</PRE><BLOCKQUOTE><EM> The request could not be performed because of an I/O device error.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERIAL_NO_DEVICE = 1118;
</PRE><BLOCKQUOTE><EM> No serial device was successfully initialized.  The serial driver will unload.</EM></BLOCKQUOTE><PRE>

CONST ERROR_IRQ_BUSY = 1119;
</PRE><BLOCKQUOTE><EM> An attempt was made to open a device that was sharing an IRQ with other devices.</EM></BLOCKQUOTE><PRE>
</PRE> At least one other device that uses that IRQ was already opened.  Two concurrent
 opens of devices that share an IRQ and only work via interrupts is not supported
 for the particular bus type that the devices use.

<P><PRE>CONST ERROR_MORE_WRITES = 1120;
</PRE><BLOCKQUOTE><EM> This informational status message indicates that the serial io control</EM></BLOCKQUOTE><PRE>
</PRE> IOCTL_SERIAL_XOFF_COUNTER completed due to another write to the serial
 port.

<P><PRE>CONST ERROR_COUNTER_TIMEOUT = 1121;
</PRE><BLOCKQUOTE><EM> This informational status message indicates that the serial io control</EM></BLOCKQUOTE><PRE>
</PRE> IOCTL_SERIAL_XOFF_COUNTER completed due to timer expiring before the
 counter reached 0.

<P><PRE>CONST ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;
</PRE><BLOCKQUOTE><EM> While accessing the floppy an id address mark was not found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_FLOPPY_WRONG_CYLINDER = 1123;
</PRE><BLOCKQUOTE><EM> While accessing the floppy the track address from the sector id field was found</EM></BLOCKQUOTE><PRE>
</PRE> to be different than the track address maintained by the controller.

<P><PRE>CONST ERROR_FLOPPY_UNKNOWN_ERROR = 1124;
</PRE><BLOCKQUOTE><EM> The floppy controller reported an error that is not recognized by the floppy driver.</EM></BLOCKQUOTE><PRE>

CONST ERROR_FLOPPY_BAD_REGISTERS = 1125;
</PRE><BLOCKQUOTE><EM> While accessing the floppy, the controller returned inconsistant results via its registers.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_RECALIBRATE_FAILED = 1126;
</PRE><BLOCKQUOTE><EM> While accessing the hard disk, a recalibrate operation failed, even after retries.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_OPERATION_FAILED = 1127;
</PRE><BLOCKQUOTE><EM> While accessing the hard disk, a disk operation failed even after retries.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_RESET_FAILED = 1128;
</PRE><BLOCKQUOTE><EM> While accessing the hard disk, a disk controller reset was needed, but even that failed.</EM></BLOCKQUOTE><PRE>
</PRE> It would seem that some diagnostics should be run.

<P>///////////////////////
                       
 Winnet32 Status Codes 
                       
///////////////////////

<P><PRE>CONST ERROR_BAD_USERNAME = 2202;
</PRE><BLOCKQUOTE><EM> The specified user name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_NETWORK = 2138;
</PRE><BLOCKQUOTE><EM> The network is not present or not started.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_CONNECTED = 2250;
</PRE><BLOCKQUOTE><EM> This network connection does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_OPEN_FILES = 2401;
</PRE><BLOCKQUOTE><EM> There are open files or requests pending on this connection.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DEVICE_IN_USE = 2404;
</PRE><BLOCKQUOTE><EM> The device is in use by an active process and cannot be disconnected.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_DEVICE = 1200;
</PRE><BLOCKQUOTE><EM> The specified device name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CONNECTION_UNAVAIL = 1201;
</PRE><BLOCKQUOTE><EM> The device is not currently connected but it is a remembered connection.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DEVICE_ALREADY_REMEMBERED = 1202;
</PRE><BLOCKQUOTE><EM> An attempt was made to remember a device that had previously been remembered.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_NET_OR_BAD_PATH = 1203;
</PRE><BLOCKQUOTE><EM> No network provider accepted the given network path.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_PROVIDER = 1204;
</PRE><BLOCKQUOTE><EM> The specified network provider name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANNOT_OPEN_PROFILE = 1205;
</PRE><BLOCKQUOTE><EM> Unable to open the network connection profile.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_PROFILE = 1206;
</PRE><BLOCKQUOTE><EM> The network connection profile is corrupt.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_CONTAINER = 1207;
</PRE><BLOCKQUOTE><EM> Cannot enumerate a non-container.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EXTENDED_ERROR = 1208;
</PRE><BLOCKQUOTE><EM> An extended error has occurred.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_GROUPNAME = 1209;
</PRE><BLOCKQUOTE><EM> The format of the specified group name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_COMPUTERNAME = 1210;
</PRE><BLOCKQUOTE><EM> The format of the specified computer name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_EVENTNAME = 1211;
</PRE><BLOCKQUOTE><EM> The format of the specified event name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_DOMAINNAME = 1212;
</PRE><BLOCKQUOTE><EM> The format of the specified domain name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SERVICENAME = 1213;
</PRE><BLOCKQUOTE><EM> The format of the specified service name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_NETNAME = 1214;
</PRE><BLOCKQUOTE><EM> The format of the specified network name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SHARENAME = 1215;
</PRE><BLOCKQUOTE><EM> The format of the specified share name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PASSWORDNAME = 1216;
</PRE><BLOCKQUOTE><EM> The format of the specified password is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MESSAGENAME = 1217;
</PRE><BLOCKQUOTE><EM> The format of the specified message name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MESSAGEDEST = 1218;
</PRE><BLOCKQUOTE><EM> The format of the specified message destination is invalid.</EM></BLOCKQUOTE><PRE>
</PRE>///////////////////////
                       
 Security Status Codes 
                       
///////////////////////

<P><PRE>CONST ERROR_NOT_ALL_ASSIGNED = 1300;
</PRE><BLOCKQUOTE><EM> Indicates not all privileges referenced are assigned to the caller.</EM></BLOCKQUOTE><PRE>
</PRE> This allows, for example, all privileges to be disabled without having
 to know exactly which privileges are assigned.

<P><PRE>CONST ERROR_SOME_NOT_MAPPED = 1301;
</PRE><BLOCKQUOTE><EM> Some of the information to be translated has not been translated.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;
</PRE><BLOCKQUOTE><EM> No system quota limits are specifically set for this Account.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LOCAL_USER_SESSION_KEY = 1303;
</PRE><BLOCKQUOTE><EM> A user session key was requested for a local rpc connection. The session key</EM></BLOCKQUOTE><PRE>
</PRE> returned is a constant value and not unique to this connection. There is
 little to be gained by encrypting data on such a connection.

<P><PRE>CONST ERROR_NULL_LM_PASSWORD = 1304;
</PRE><BLOCKQUOTE><EM> The NT password is too complex to be converted to a Lan-Manager password.</EM></BLOCKQUOTE><PRE>
</PRE> The Lan-Manager password returned is a NULL string.

<P><PRE>CONST ERROR_UNKNOWN_REVISION = 1305;
</PRE><BLOCKQUOTE><EM> Indicates a revision number encountered or specified is not one</EM></BLOCKQUOTE><PRE>
</PRE> known by the service.  It may be a more recent revision than the
 service is aware of.

<P><PRE>CONST ERROR_REVISION_MISMATCH = 1306;
</PRE><BLOCKQUOTE><EM> Indicates two revision levels are incompatible.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_OWNER = 1307;
</PRE><BLOCKQUOTE><EM> Indicates a particular Security ID may not be assigned as the</EM></BLOCKQUOTE><PRE>
</PRE> owner of an object.

<P><PRE>CONST ERROR_INVALID_PRIMARY_GROUP = 1308;
</PRE><BLOCKQUOTE><EM> Indicates a particular Security ID may not be assigned as the</EM></BLOCKQUOTE><PRE>
</PRE> primary group of an object.

<P><PRE>CONST ERROR_NO_IMPERSONATION_TOKEN = 1309;
</PRE><BLOCKQUOTE><EM> An attempt has been made to operate on an impersonation token</EM></BLOCKQUOTE><PRE>
</PRE> by a thread that is not currently impersonating a client.

<P><PRE>CONST ERROR_CANT_DISABLE_MANDATORY = 1310;
</PRE><BLOCKQUOTE><EM> A mandatory group may not be disabled.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_LOGON_SERVERS = 1311;
</PRE><BLOCKQUOTE><EM> There are currently no logon servers available to service the logon</EM></BLOCKQUOTE><PRE>
</PRE> request.

<P><PRE>CONST ERROR_NO_SUCH_LOGON_SESSION = 1312;
</PRE><BLOCKQUOTE><EM> A specified logon session does not exist.  It may already have</EM></BLOCKQUOTE><PRE>
</PRE> been terminated.

<P><PRE>CONST ERROR_NO_SUCH_PRIVILEGE = 1313;
</PRE><BLOCKQUOTE><EM> A specified privilege does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PRIVILEGE_NOT_HELD = 1314;
</PRE><BLOCKQUOTE><EM> A required privilege is not held by the client.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ACCOUNT_NAME = 1315;
</PRE><BLOCKQUOTE><EM> The name provided is not a properly formed account name.</EM></BLOCKQUOTE><PRE>

CONST ERROR_USER_EXISTS = 1316;
</PRE><BLOCKQUOTE><EM> The specified user already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SUCH_USER = 1317;
</PRE><BLOCKQUOTE><EM> The specified user does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_GROUP_EXISTS = 1318;
</PRE><BLOCKQUOTE><EM> The specified group already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SUCH_GROUP = 1319;
</PRE><BLOCKQUOTE><EM> The specified group does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MEMBER_IN_GROUP = 1320;
</PRE><BLOCKQUOTE><EM> The specified user account is already in the specified group account.</EM></BLOCKQUOTE><PRE>
</PRE> Also used to indicate a group can not be deleted because it contains
 a member.

<P><PRE>CONST ERROR_MEMBER_NOT_IN_GROUP = 1321;
</PRE><BLOCKQUOTE><EM> The specified user account is not a member of the specified group account.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LAST_ADMIN = 1322;
</PRE><BLOCKQUOTE><EM> Indicates the requested operation would disable or delete the last</EM></BLOCKQUOTE><PRE>
</PRE> remaining administration account.  This is not allowed to prevent
 creating a situation in which the system will not be administratable.

<P><PRE>CONST ERROR_WRONG_PASSWORD = 1323;
</PRE><BLOCKQUOTE><EM> When trying to update a password, this return status indicates that</EM></BLOCKQUOTE><PRE>
</PRE> the value provided as the current password is not correct.

<P><PRE>CONST ERROR_ILL_FORMED_PASSWORD = 1324;
</PRE><BLOCKQUOTE><EM> When trying to update a password, this return status indicates that</EM></BLOCKQUOTE><PRE>
</PRE> the value provided for the new password contains values that are
 not allowed in passwords.

<P><PRE>CONST ERROR_PASSWORD_RESTRICTION = 1325;
</PRE><BLOCKQUOTE><EM> When trying to update a password, this status indicates that some</EM></BLOCKQUOTE><PRE>
</PRE> password update rule has been violated.  For example, the password
 may not meet length criteria.

<P><PRE>CONST ERROR_LOGON_FAILURE = 1326;
</PRE><BLOCKQUOTE><EM> The attempted logon is invalid.  This is either due to a bad username</EM></BLOCKQUOTE><PRE>
</PRE> or authentication information.

<P><PRE>CONST ERROR_ACCOUNT_RESTRICTION = 1327;
</PRE><BLOCKQUOTE><EM> Indicates a referenced user name and authentication information are</EM></BLOCKQUOTE><PRE>
</PRE> valid, but some user account restriction has prevented successful
 authentication (such as time-of-day restrictions).

<P><PRE>CONST ERROR_INVALID_LOGON_HOURS = 1328;
</PRE><BLOCKQUOTE><EM> The user account has time restrictions and may not be logged onto</EM></BLOCKQUOTE><PRE>
</PRE> at this time.

<P><PRE>CONST ERROR_INVALID_WORKSTATION = 1329;
</PRE><BLOCKQUOTE><EM> The user account is restricted such that it may not be used to</EM></BLOCKQUOTE><PRE>
</PRE> log on from the source workstation.

<P><PRE>CONST ERROR_PASSWORD_EXPIRED = 1330;
</PRE><BLOCKQUOTE><EM> The user account's password has expired.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ACCOUNT_DISABLED = 1331;
</PRE><BLOCKQUOTE><EM> The referenced account is currently disabled and may not be logged on to.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NONE_MAPPED = 1332;
</PRE><BLOCKQUOTE><EM> None of the information to be translated has been translated.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;
</PRE><BLOCKQUOTE><EM> The number of LUIDs requested may not be allocated with a single</EM></BLOCKQUOTE><PRE>
</PRE> allocation.

<P><PRE>CONST ERROR_LUIDS_EXHAUSTED = 1334;
</PRE><BLOCKQUOTE><EM> Indicates there are no more LUIDs to allocate.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SUB_AUTHORITY = 1335;
</PRE><BLOCKQUOTE><EM> Indicates the sub-authority value is invalid for the particular use.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ACL = 1336;
</PRE><BLOCKQUOTE><EM> Indicates the ACL structure is not valid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SID = 1337;
</PRE><BLOCKQUOTE><EM> Indicates the SID structure is not valid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SECURITY_DESCR = 1338;
</PRE><BLOCKQUOTE><EM> Indicates the SECURITY_DESCRIPTOR structure is not valid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_INHERITANCE_ACL = 1340;
</PRE><BLOCKQUOTE><EM> Indicates that an attempt to build either an inherited ACL or ACE</EM></BLOCKQUOTE><PRE>
</PRE> was not successful.
 This can be caused by a number of things.  One of the more probable
 causes is the replacement of a CreatorId with an SID that didn't fit
 into the ACE or ACL.

<P><PRE>CONST ERROR_SERVER_DISABLED = 1341;
</PRE><BLOCKQUOTE><EM> The GUID allocation server is [already] disabled at the moment.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SERVER_NOT_DISABLED = 1342;
</PRE><BLOCKQUOTE><EM> The GUID allocation server is [already] enabled at the moment.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ID_AUTHORITY = 1343;
</PRE><BLOCKQUOTE><EM> The value provided was an invalid value for an identifier authority.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;
</PRE><BLOCKQUOTE><EM> When a block of memory is allotted for future updates, such as the memory</EM></BLOCKQUOTE><PRE>
</PRE> allocated to hold discretionary access control and primary group information,
 successive updates may exceed the amount of memory originally allotted.
 Since quota may already have been charged to several processes which have
 handles to the object, it is not reasonable to alter the size of the
 allocated memory.  Instead, a request that requires more memory than has
 been allotted must fail and the ERROR_ALLOTTED_SPACE_EXCEEDED error returned.

<P><PRE>CONST ERROR_INVALID_GROUP_ATTRIBUTES = 1345;
</PRE><BLOCKQUOTE><EM> The specified attributes are invalid, or incompatible with the</EM></BLOCKQUOTE><PRE>
</PRE> attributes for the group as a whole.

<P><PRE>CONST ERROR_BAD_IMPERSONATION_LEVEL = 1346;
</PRE><BLOCKQUOTE><EM> A specified impersonation level is invalid.</EM></BLOCKQUOTE><PRE>
</PRE> Also used to indicate a required impersonation level was not provided.

<P><PRE>CONST ERROR_CANT_OPEN_ANONYMOUS = 1347;
</PRE><BLOCKQUOTE><EM> An attempt was made to open an Anonymous level token.</EM></BLOCKQUOTE><PRE>
</PRE> Anonymous tokens may not be opened.

<P><PRE>CONST ERROR_BAD_VALIDATION_CLASS = 1348;
</PRE><BLOCKQUOTE><EM> The validation information class requested was invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_TOKEN_TYPE = 1349;
</PRE><BLOCKQUOTE><EM> The type of a token object is inapropriate for its attempted use.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SECURITY_ON_OBJECT = 1350;
</PRE><BLOCKQUOTE><EM> Indicates an attempt was made to operate on the security of</EM></BLOCKQUOTE><PRE>
</PRE> an object that does not have security associated with it.

<P><PRE>CONST ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;
</PRE><BLOCKQUOTE><EM> Indicates a domain controller could not be contacted or that</EM></BLOCKQUOTE><PRE>
</PRE> objects within the domain are protected such that necessary
 information could not be retrieved.

<P><PRE>CONST ERROR_INVALID_SERVER_STATE = 1352;
</PRE><BLOCKQUOTE><EM> Indicates the Sam Server was in the wrong state to</EM></BLOCKQUOTE><PRE>
</PRE> perform the desired operation.

<P><PRE>CONST ERROR_INVALID_DOMAIN_STATE = 1353;
</PRE><BLOCKQUOTE><EM> Indicates the Domain was in the wrong state to</EM></BLOCKQUOTE><PRE>
</PRE> perform the desired operation.

<P><PRE>CONST ERROR_INVALID_DOMAIN_ROLE = 1354;
</PRE><BLOCKQUOTE><EM> Indicates the desired operation cannot be completed</EM></BLOCKQUOTE><PRE>
</PRE> with the domain in its present role.

<P><PRE>CONST ERROR_NO_SUCH_DOMAIN = 1355;
</PRE><BLOCKQUOTE><EM> The specified Domain did not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DOMAIN_EXISTS = 1356;
</PRE><BLOCKQUOTE><EM> The specified Domain already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;
</PRE><BLOCKQUOTE><EM> An attempt to exceed the limit on the number of domains per server</EM></BLOCKQUOTE><PRE>
</PRE> for this release.

<P><PRE>CONST ERROR_INTERNAL_DB_CORRUPTION = 1358;
</PRE><BLOCKQUOTE><EM> This error indicates that the requested operation cannot be</EM></BLOCKQUOTE><PRE>
</PRE> completed due to a catastrophic media failure or on-disk data
 structure corruption

<P><PRE>CONST ERROR_INTERNAL_ERROR = 1359;
</PRE><BLOCKQUOTE><EM> This error indicates that the SAM server has encounterred an</EM></BLOCKQUOTE><PRE>
</PRE> internal consistency error in its database.  This catastrophic
 failure will prevent further operation of SAM

<P><PRE>CONST ERROR_GENERIC_NOT_MAPPED = 1360;
</PRE><BLOCKQUOTE><EM> Indicates generic access types were contained in an access mask</EM></BLOCKQUOTE><PRE>
</PRE> which should already be mapped to non-generic access types.

<P><PRE>CONST ERROR_BAD_DESCRIPTOR_FORMAT = 1361;
</PRE><BLOCKQUOTE><EM> Indicates a security descriptor is not in the necessary format (absolute</EM></BLOCKQUOTE><PRE>
</PRE> or self-relative).

<P><PRE>CONST ERROR_NOT_LOGON_PROCESS = 1362;
</PRE><BLOCKQUOTE><EM> The requested action is restricted for use by logon processes</EM></BLOCKQUOTE><PRE>
</PRE> only.  The calling process has not registered as a logon process.

<P><PRE>CONST ERROR_LOGON_SESSION_EXISTS = 1363;
</PRE><BLOCKQUOTE><EM> A attempt has been made to start a new session manager or</EM></BLOCKQUOTE><PRE>
</PRE> LSA logon session with an ID that is alread in use.

<P><PRE>CONST ERROR_NO_SUCH_PACKAGE = 1364;
</PRE><BLOCKQUOTE><EM> A specified authentication package is unknown</EM></BLOCKQUOTE><PRE>

CONST ERROR_BAD_LOGON_SESSION_STATE = 1365;
</PRE><BLOCKQUOTE><EM> The logon session is not in a state the is consistent with the</EM></BLOCKQUOTE><PRE>
</PRE> requested operation.

<P><PRE>CONST ERROR_LOGON_SESSION_COLLISION = 1366;
</PRE><BLOCKQUOTE><EM> The logon session is not in a state the is consistent with the</EM></BLOCKQUOTE><PRE>
</PRE> requested operation.  BUG, BUG - fix this message

<P><PRE>CONST ERROR_INVALID_LOGON_TYPE = 1367;
</PRE><BLOCKQUOTE><EM> Indicates an invalid value has been provided for LogonType has been</EM></BLOCKQUOTE><PRE>
</PRE> requested.

<P><PRE>CONST ERROR_CANNOT_IMPERSONATE = 1368;
</PRE><BLOCKQUOTE><EM> Indicates that an attempt has been made to impersonate via a named</EM></BLOCKQUOTE><PRE>
</PRE> pipe that has not yet been read from.

<P><PRE>CONST ERROR_RXACT_INVALID_STATE = 1369;
</PRE><BLOCKQUOTE><EM> Indicates that the transaction state of a registry sub-tree is</EM></BLOCKQUOTE><PRE>
</PRE> incompatible with the requested operation.
 For example, a request has been made to start a new transaction with
 one already in progress, or a request to apply a transaction when one
 is not currently in progress.
 This status value is returned by the runtime library (RTL) registry
 transaction package (RXact).

<P><PRE>CONST ERROR_RXACT_COMMIT_FAILURE = 1370;
</PRE><BLOCKQUOTE><EM> Indicates an error has occured during a registry transaction commit.</EM></BLOCKQUOTE><PRE>
</PRE> The database has been left in an unknown, but probably inconsistent,
 state.  The state of the registry transaction is left as COMMITTING.
 This status value is returned by the runtime library (RTL) registry
 transaction package (RXact).

<P><PRE>CONST ERROR_SPECIAL_ACCOUNT = 1371;
</PRE><BLOCKQUOTE><EM> Indicates an operation has been attempted on a built-in (special)</EM></BLOCKQUOTE><PRE>
</PRE> SAM account which is incompatible with built-in accounts.  For
 example, built-in accounts can not be re-named or deleted.

<P><PRE>CONST ERROR_SPECIAL_GROUP = 1372;
</PRE><BLOCKQUOTE><EM> The operation requested may not be performed on the specified</EM></BLOCKQUOTE><PRE>
</PRE> group because it is a built-in special group.

<P><PRE>CONST ERROR_SPECIAL_USER = 1373;
</PRE><BLOCKQUOTE><EM> The operation requested may not be performed on the specified</EM></BLOCKQUOTE><PRE>
</PRE> user  because it is a built-in special user.

<P><PRE>CONST ERROR_MEMBERS_PRIMARY_GROUP = 1374;
</PRE><BLOCKQUOTE><EM> Indicates a member can not be removed from a group because the</EM></BLOCKQUOTE><PRE>
</PRE> group is currently the member's primary group.

<P><PRE>CONST ERROR_TOKEN_ALREADY_IN_USE = 1375;
</PRE><BLOCKQUOTE><EM> An attempt was made to establish a token for use as a primary token</EM></BLOCKQUOTE><PRE>
</PRE> but the token is already in use.  A token can only be the primary token
 of one process at a time.

<P><PRE>CONST ERROR_NO_SUCH_ALIAS = 1376;
</PRE><BLOCKQUOTE><EM> The specified alias does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MEMBER_NOT_IN_ALIAS = 1377;
</PRE><BLOCKQUOTE><EM> The specified account name is not a member of the alias.</EM></BLOCKQUOTE><PRE>

CONST ERROR_MEMBER_IN_ALIAS = 1378;
</PRE><BLOCKQUOTE><EM> The specified account name is already a member of the alias.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ALIAS_EXISTS = 1379;
</PRE><BLOCKQUOTE><EM> The specified alias already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LOGON_NOT_GRANTED = 1380;
</PRE><BLOCKQUOTE><EM> A requested type of logon (e.g., Interactive, Network, Service) is not</EM></BLOCKQUOTE><PRE>
</PRE> granted by the target system's local security policy.  Please ask the
 system administrator to grant the necessary form of logon.

<P><PRE>CONST ERROR_TOO_MANY_SECRETS = 1381;
</PRE><BLOCKQUOTE><EM> The maximum number of secrets that may be stored in a single system has been</EM></BLOCKQUOTE><PRE>
</PRE> exceeded.  The length and number of secrets is limited to satisfy United
 States State Department export restrictions.

<P><PRE>CONST ERROR_SECRET_TOO_LONG = 1382;
</PRE><BLOCKQUOTE><EM> The length of an secret exceeds the maximum length allowed.  The length and</EM></BLOCKQUOTE><PRE>
</PRE> number of secrets is limited to satisfy United States State Department
 export restrictions.

<P><PRE>CONST ERROR_INTERNAL_DB_ERROR = 1383;
</PRE><BLOCKQUOTE><EM> The Local Security Authority (LSA) database contains in internal inconsistency.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TOO_MANY_CONTEXT_IDS = 1384;
</PRE><BLOCKQUOTE><EM> During a logon attempt, the user's security context accumulated too many</EM></BLOCKQUOTE><PRE>
</PRE> security IDs.  This is a very unusual situation.  Remove the user from
 some groups or aliases to reduce the number of security ids to incorporate
 into the security context.

<P><PRE>CONST ERROR_LOGON_TYPE_NOT_GRANTED = 1385;
</PRE><BLOCKQUOTE><EM> A user has requested a type of logon (e.g., interactive or network) that</EM></BLOCKQUOTE><PRE>
</PRE> has not be granted.  An administrator has control over who may logon
 interactively and through the network.

<P><PRE>CONST ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;
</PRE><BLOCKQUOTE><EM> An attempt was made to change a user password in the security account manager</EM></BLOCKQUOTE><PRE>
</PRE> without providing the necessary NT cross-encrypted password.

<P><PRE>CONST ERROR_NO_SUCH_MEMBER = 1387;
</PRE><BLOCKQUOTE><EM> A new member could not be added to an alias because the member does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MEMBER = 1388;
</PRE><BLOCKQUOTE><EM> A new member could not be added to an alias because the member has the</EM></BLOCKQUOTE><PRE>
</PRE> wrong account type.

<P><PRE>CONST ERROR_TOO_MANY_SIDS = 1389;
</PRE><BLOCKQUOTE><EM> Too many Sids have been specified.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;
</PRE><BLOCKQUOTE><EM> An attempt was made to change a user password in the security account manager</EM></BLOCKQUOTE><PRE>
</PRE> without providing the necessary LM cross-encrypted password.

<P><PRE>CONST ERROR_NO_INHERITANCE = 1391;
</PRE><BLOCKQUOTE><EM> Indicates an ACL contains no inheritable components</EM></BLOCKQUOTE><PRE>

CONST ERROR_FILE_CORRUPT = 1392;
</PRE><BLOCKQUOTE><EM> The file or directory is corrupt and non-readable.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DISK_CORRUPT = 1393;
</PRE><BLOCKQUOTE><EM> The disk structure is corrupt and non-readable.</EM></BLOCKQUOTE><PRE>
</PRE> End of security error codes

<P>/////////////////////
                     
 WinUser Error Codes 
                     
/////////////////////

<P><PRE>CONST ERROR_INVALID_WINDOW_HANDLE = 1400;
</PRE><BLOCKQUOTE><EM> Invalid window handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MENU_HANDLE = 1401;
</PRE><BLOCKQUOTE><EM> Invalid menu handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_CURSOR_HANDLE = 1402;
</PRE><BLOCKQUOTE><EM> Invalid cursor handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ACCEL_HANDLE = 1403;
</PRE><BLOCKQUOTE><EM> Invalid accelerator-table handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_HOOK_HANDLE = 1404;
</PRE><BLOCKQUOTE><EM> Invalid hook handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_DWP_HANDLE = 1405;
</PRE><BLOCKQUOTE><EM> Invalid DeferWindowPos handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TLW_WITH_WSCHILD = 1406;
</PRE><BLOCKQUOTE><EM> CreateWindow() failed, creating top-level window with WS_CHILD style.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CANNOT_FIND_WND_CLASS = 1407;
</PRE><BLOCKQUOTE><EM> Cannot find window class.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WINDOW_OF_OTHER_THREAD = 1408;
</PRE><BLOCKQUOTE><EM> Invalid window, belongs to other thread.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HOTKEY_ALREADY_REGISTERED = 1409;
</PRE><BLOCKQUOTE><EM> Hotkey already registered.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CLASS_ALREADY_EXISTS = 1410;
</PRE><BLOCKQUOTE><EM> Class already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CLASS_DOES_NOT_EXIST = 1411;
</PRE><BLOCKQUOTE><EM> Class does not exist.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CLASS_HAS_WINDOWS = 1412;
</PRE><BLOCKQUOTE><EM> Class still has open windows.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_INDEX = 1413;
</PRE><BLOCKQUOTE><EM> Invalid index.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ICON_HANDLE = 1414;
</PRE><BLOCKQUOTE><EM> Invalid icon handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PRIVATE_DIALOG_INDEX = 1415;
</PRE><BLOCKQUOTE><EM> Using private DIALOG window words.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LISTBOX_ID_NOT_FOUND = 1416;
</PRE><BLOCKQUOTE><EM> Listbox ID not found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_WILDCARD_CHARACTERS = 1417;
</PRE><BLOCKQUOTE><EM> No wildcard characters found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CLIPBOARD_NOT_OPEN = 1418;
</PRE><BLOCKQUOTE><EM> Thread doesn't have clipboard open.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HOTKEY_NOT_REGISTERED = 1419;
</PRE><BLOCKQUOTE><EM> Hotkey not registered.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WINDOW_NOT_DIALOG = 1420;
</PRE><BLOCKQUOTE><EM> The window is not a valid dialog window.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CONTROL_ID_NOT_FOUND = 1421;
</PRE><BLOCKQUOTE><EM> Control ID not found.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_COMBOBOX_MESSAGE = 1422;
</PRE><BLOCKQUOTE><EM> Invalid Message, combobox doesn't have an edit control.</EM></BLOCKQUOTE><PRE>

CONST ERROR_WINDOW_NOT_COMBOBOX = 1423;
</PRE><BLOCKQUOTE><EM> The window is not a combobox.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_EDIT_HEIGHT = 1424;
</PRE><BLOCKQUOTE><EM> Height must be less than 256.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DC_NOT_FOUND = 1425;
</PRE><BLOCKQUOTE><EM> Invalid HDC passed to ReleaseDC.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_HOOK_FILTER = 1426;
</PRE><BLOCKQUOTE><EM> Invalid hook filter type.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_FILTER_PROC = 1427;
</PRE><BLOCKQUOTE><EM> Invalid filter proc.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HOOK_NEEDS_HMOD = 1428;
</PRE><BLOCKQUOTE><EM> Cannot set non-local hook without an module handle.</EM></BLOCKQUOTE><PRE>

CONST ERROR_GLOBAL_ONLY_HOOK = 1429;
</PRE><BLOCKQUOTE><EM> This hook can only be set globally.</EM></BLOCKQUOTE><PRE>

CONST ERROR_JOURNAL_HOOK_SET = 1430;
</PRE><BLOCKQUOTE><EM> The journal hook is already installed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HOOK_NOT_INSTALLED = 1431;
</PRE><BLOCKQUOTE><EM> Hook not installed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_LB_MESSAGE = 1432;
</PRE><BLOCKQUOTE><EM> Invalid message for single-selection listbox.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SETCOUNT_ON_BAD_LB = 1433;
</PRE><BLOCKQUOTE><EM> LB_SETCOUNT sent to non-lazy listbox.</EM></BLOCKQUOTE><PRE>

CONST ERROR_LB_WITHOUT_TABSTOPS = 1434;
</PRE><BLOCKQUOTE><EM> This listbox doesn't support tab stops.</EM></BLOCKQUOTE><PRE>

CONST ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;
</PRE><BLOCKQUOTE><EM> Cannot destroy object created by another thread.</EM></BLOCKQUOTE><PRE>

CONST ERROR_CHILD_WINDOW_MENU = 1436;
</PRE><BLOCKQUOTE><EM> Child windows can't have menus.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SYSTEM_MENU = 1437;
</PRE><BLOCKQUOTE><EM> Window doesn't have system menu.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_MSGBOX_STYLE = 1438;
</PRE><BLOCKQUOTE><EM> Invalid message box style.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SPI_VALUE = 1439;
</PRE><BLOCKQUOTE><EM> Invalid SPI_* parameter.</EM></BLOCKQUOTE><PRE>

CONST ERROR_SCREEN_ALREADY_LOCKED = 1440;
</PRE><BLOCKQUOTE><EM> Screen already locked.</EM></BLOCKQUOTE><PRE>

CONST ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;
</PRE><BLOCKQUOTE><EM> All DeferWindowPos() HWNDs must have same parent.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NOT_CHILD_WINDOW = 1442;
</PRE><BLOCKQUOTE><EM> Window is not a child window.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_GW_COMMAND = 1443;
</PRE><BLOCKQUOTE><EM> Invalid GW_* command.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_THREAD_ID = 1444;
</PRE><BLOCKQUOTE><EM> Invalid thread ID.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NON_MDICHILD_WINDOW = 1445;
</PRE><BLOCKQUOTE><EM> DefMDIChildProc() called with a non-MDIChild window.</EM></BLOCKQUOTE><PRE>

CONST ERROR_POPUP_ALREADY_ACTIVE = 1446;
</PRE><BLOCKQUOTE><EM> Popup menu already active.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_SCROLLBARS = 1447;
</PRE><BLOCKQUOTE><EM> Window does not have scrollbars.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SCROLLBAR_RANGE = 1448;
</PRE><BLOCKQUOTE><EM> Scrollbar range greater than 0x7FFF.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SHOWWIN_COMMAND = 1449;
</PRE><BLOCKQUOTE><EM> Invalid ShowWindow() command.</EM></BLOCKQUOTE><PRE>
</PRE> End of WinUser error codes

<P>///////////////////////
                       
 Eventlog Status Codes 
                       
///////////////////////

<P><PRE>CONST ERROR_EVENTLOG_FILE_CORRUPT = 1500;
</PRE><BLOCKQUOTE><EM> The Eventlog logfile %1 is corrupt.</EM></BLOCKQUOTE><PRE>

CONST ERROR_EVENTLOG_CANT_START = 1501;
</PRE><BLOCKQUOTE><EM> No Eventlog log file could be opened.  The Eventlog service did not start.</EM></BLOCKQUOTE><PRE>
</PRE> End of eventlog error codes

<P>//////////////////
                  
 RPC Status Codes 
                  
//////////////////

<P><PRE>CONST RPC_S_INVALID_STRING_BINDING = 1700;
</PRE><BLOCKQUOTE><EM> The string binding is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_WRONG_KIND_OF_BINDING = 1701;
</PRE><BLOCKQUOTE><EM> The binding handle is not the correct type.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_BINDING = 1702;
</PRE><BLOCKQUOTE><EM> The binding handle is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;
</PRE><BLOCKQUOTE><EM> The Rpc protocol sequence is not supported.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_RPC_PROTSEQ = 1704;
</PRE><BLOCKQUOTE><EM> The rpc protocol sequence is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_STRING_UUID = 1705;
</PRE><BLOCKQUOTE><EM> The string uuid is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_ENDPOINT_FORMAT = 1706;
</PRE><BLOCKQUOTE><EM> The endpoint format is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_NET_ADDR = 1707;
</PRE><BLOCKQUOTE><EM> The network address is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_ENDPOINT_FOUND = 1708;
</PRE><BLOCKQUOTE><EM> No endpoint was found.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_TIMEOUT = 1709;
</PRE><BLOCKQUOTE><EM> The timeout value is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_OBJECT_NOT_FOUND = 1710;
</PRE><BLOCKQUOTE><EM> The object uuid was not found.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ALREADY_REGISTERED = 1711;
</PRE><BLOCKQUOTE><EM> The object uuid has already been registered.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_TYPE_ALREADY_REGISTERED = 1712;
</PRE><BLOCKQUOTE><EM> The type uuid has already been registered.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ALREADY_LISTENING = 1713;
</PRE><BLOCKQUOTE><EM> The server is already listening.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_PROTSEQS_REGISTERED = 1714;
</PRE><BLOCKQUOTE><EM> No protocol sequences have been registered.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NOT_LISTENING = 1715;
</PRE><BLOCKQUOTE><EM> The server is not listening.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_MGR_TYPE = 1716;
</PRE><BLOCKQUOTE><EM> The manager type is unknown.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_IF = 1717;
</PRE><BLOCKQUOTE><EM> The interface is unknown.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_BINDINGS = 1718;
</PRE><BLOCKQUOTE><EM> There are no bindings.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_PROTSEQS = 1719;
</PRE><BLOCKQUOTE><EM> There are no protocol sequences.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_CANT_CREATE_ENDPOINT = 1720;
</PRE><BLOCKQUOTE><EM> The endpoint can not be created.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_OUT_OF_RESOURCES = 1721;
</PRE><BLOCKQUOTE><EM> Not enough resources are available to complete this operation.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_SERVER_UNAVAILABLE = 1722;
</PRE><BLOCKQUOTE><EM> The server is unavailable.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_SERVER_TOO_BUSY = 1723;
</PRE><BLOCKQUOTE><EM> The server is too busy to complete this operation.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_NETWORK_OPTIONS = 1724;
</PRE><BLOCKQUOTE><EM> The network options are invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_CALL_ACTIVE = 1725;
</PRE><BLOCKQUOTE><EM> There is not a remote procedure call active in this thread.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_CALL_FAILED = 1726;
</PRE><BLOCKQUOTE><EM> The remote procedure call failed.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_CALL_FAILED_DNE = 1727;
</PRE><BLOCKQUOTE><EM> The remote procedure call failed and did not execute.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_PROTOCOL_ERROR = 1728;
</PRE><BLOCKQUOTE><EM> An rpc protocol error occured.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_CANNOT_BIND = 1729;
</PRE><BLOCKQUOTE><EM> An attempt to bind with the server failed.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNSUPPORTED_TRANS_SYN = 1730;
</PRE><BLOCKQUOTE><EM> The transfer syntax is not supported by the server.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_SERVER_OUT_OF_MEMORY = 1731;
</PRE><BLOCKQUOTE><EM> The server has insufficient memory to complete this operation.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNSUPPORTED_TYPE = 1732;
</PRE><BLOCKQUOTE><EM> The type uuid is not supported.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_TAG = 1733;
</PRE><BLOCKQUOTE><EM> The tag is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_BOUND = 1734;
</PRE><BLOCKQUOTE><EM> The array bounds are invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_ENTRY_NAME = 1735;
</PRE><BLOCKQUOTE><EM> The binding does not contain an entry name.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_NAME_SYNTAX = 1736;
</PRE><BLOCKQUOTE><EM> The name syntax is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;
</PRE><BLOCKQUOTE><EM> The name syntax is not supported.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_SERVER_NOT_LISTENING = 1738;
</PRE><BLOCKQUOTE><EM> The server is not listening for remote procedure calls.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UUID_NO_ADDRESS = 1739;
</PRE><BLOCKQUOTE><EM> No network address is available to use to construct a uuid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_DUPLICATE_ENDPOINT = 1740;
</PRE><BLOCKQUOTE><EM> The endpoint is a duplicate.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_AUTHN_TYPE = 1741;
</PRE><BLOCKQUOTE><EM> The authentication type is unknown.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_MAX_CALLS_TOO_SMALL = 1742;
</PRE><BLOCKQUOTE><EM> The maximum number of calls is too small.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_STRING_TOO_LONG = 1743;
</PRE><BLOCKQUOTE><EM> The string is too long.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_PROTSEQ_NOT_FOUND = 1744;
</PRE><BLOCKQUOTE><EM> The rpc protocol sequence was not found.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_PROCNUM_OUT_OF_RANGE = 1745;
</PRE><BLOCKQUOTE><EM> The procedure number is out of range.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_BINDING_HAS_NO_AUTH = 1746;
</PRE><BLOCKQUOTE><EM> The binding does not contain any authentication information.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;
</PRE><BLOCKQUOTE><EM> The authentication service is unknown.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;
</PRE><BLOCKQUOTE><EM> The authentication level is unknown.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_AUTH_IDENTITY = 1749;
</PRE><BLOCKQUOTE><EM> The security context is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;
</PRE><BLOCKQUOTE><EM> The authorization service is unknown.</EM></BLOCKQUOTE><PRE>

CONST EPT_S_INVALID_ENTRY = 1751;
</PRE><BLOCKQUOTE><EM> The entry is invalid.</EM></BLOCKQUOTE><PRE>

CONST EPT_S_CANT_PERFORM_OP = 1752;
</PRE><BLOCKQUOTE><EM> The operation can not be performed.</EM></BLOCKQUOTE><PRE>

CONST EPT_S_NOT_REGISTERED = 1753;
</PRE><BLOCKQUOTE><EM> There are not more endpoints available from the endpoint mapper.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_INTERFACES_EXPORTED = 1754;
</PRE><BLOCKQUOTE><EM> No interfaces have been exported.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INCOMPLETE_NAME = 1755;
</PRE><BLOCKQUOTE><EM> The entry name is incomplete.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_VERS_OPTION = 1756;
</PRE><BLOCKQUOTE><EM> The version option is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_MORE_MEMBERS = 1757;
</PRE><BLOCKQUOTE><EM> There are no more members.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NOTHING_TO_UNEXPORT = 1758;
</PRE><BLOCKQUOTE><EM> There is nothing to unexport.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INTERFACE_NOT_FOUND = 1759;
</PRE><BLOCKQUOTE><EM> The interface was not found.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ENTRY_ALREADY_EXISTS = 1760;
</PRE><BLOCKQUOTE><EM> The entry already exists.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ENTRY_NOT_FOUND = 1761;
</PRE><BLOCKQUOTE><EM> The entry is not found.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;
</PRE><BLOCKQUOTE><EM> The name service is unavailable.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INVALID_NAF_IF = 1763;
</PRE><BLOCKQUOTE><EM> The network address family is invalid.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_CANNOT_SUPPORT = 1764;
</PRE><BLOCKQUOTE><EM> The requested operation is not supported.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_NO_CONTEXT_AVAILABLE = 1765;
</PRE><BLOCKQUOTE><EM> No security context is available to allow impersonation.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_INTERNAL_ERROR = 1766;
</PRE><BLOCKQUOTE><EM> An internal error occured in rpc.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ZERO_DIVIDE = 1767;
</PRE><BLOCKQUOTE><EM> The server attempted an integer divide by zero.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_ADDRESS_ERROR = 1768;
</PRE><BLOCKQUOTE><EM> An addressing error occured in the server.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_FP_DIV_ZERO = 1769;
</PRE><BLOCKQUOTE><EM> A floating point operation at the server caused a divide by zero.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_FP_UNDERFLOW = 1770;
</PRE><BLOCKQUOTE><EM> A floating point underflow occured at the server.</EM></BLOCKQUOTE><PRE>

CONST RPC_S_FP_OVERFLOW = 1771;
</PRE><BLOCKQUOTE><EM> A floating point overflow occured at the server.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_NO_MORE_ENTRIES = 1772;
</PRE><BLOCKQUOTE><EM> The list of servers available for auto_handle binding has been exhausted.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;
</PRE><BLOCKQUOTE><EM> The file designated by DCERPCCHARTRANS cannot be opened.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;
</PRE><BLOCKQUOTE><EM> The file containing the character translation table has fewer than</EM></BLOCKQUOTE><PRE>
</PRE> 512 bytes.

<P><PRE>CONST RPC_X_SS_IN_NULL_CONTEXT = 1775;
</PRE><BLOCKQUOTE><EM> A null context handle is passed as an [in] parameter.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_CONTEXT_MISMATCH = 1776;
</PRE><BLOCKQUOTE><EM> The context handle does not match any known context handles.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_CONTEXT_DAMAGED = 1777;
</PRE><BLOCKQUOTE><EM> The context handle changed during a call.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_HANDLES_MISMATCH = 1778;
</PRE><BLOCKQUOTE><EM> The binding handles passed to a remote procedure call do not match.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;
</PRE><BLOCKQUOTE><EM> The stub is unable to get the call handle.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_NULL_REF_POINTER = 1780;
</PRE><BLOCKQUOTE><EM> A null reference pointer was passed to the stub.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;
</PRE><BLOCKQUOTE><EM> The enumeration value is out of range.</EM></BLOCKQUOTE><PRE>

CONST RPC_X_BYTE_COUNT_TOO_SMALL = 1782;
</PRE><BLOCKQUOTE><EM> The byte count is too small</EM></BLOCKQUOTE><PRE>

CONST RPC_X_BAD_STUB_DATA = 1783;
</PRE><BLOCKQUOTE><EM> The stub received bad data.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_USER_BUFFER = 1784;
</PRE><BLOCKQUOTE><EM> The supplied user buffer is not valid for the requested operation.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNRECOGNIZED_MEDIA = 1785;
</PRE><BLOCKQUOTE><EM> The disk media is not recognized.  It may not be formatted.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_TRUST_LSA_SECRET = 1786;
</PRE><BLOCKQUOTE><EM> The workstation does not have a trust secret.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NO_TRUST_SAM_ACCOUNT = 1787;
</PRE><BLOCKQUOTE><EM> The domain controller does not have an account for this workstation.</EM></BLOCKQUOTE><PRE>

CONST ERROR_TRUSTED_DOMAIN_FAILURE = 1788;
</PRE><BLOCKQUOTE><EM> The trust relationship between the primary domain and the trusted</EM></BLOCKQUOTE><PRE>
</PRE> domain failed.

<P><PRE>CONST ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;
</PRE><BLOCKQUOTE><EM> The trust relationship between this workstation and the primary</EM></BLOCKQUOTE><PRE>
</PRE> domain failed.

<P><PRE>CONST ERROR_TRUST_FAILURE = 1790;
</PRE><BLOCKQUOTE><EM> The network logon failed. This may be due the validation authority can't</EM></BLOCKQUOTE><PRE>
</PRE> be reached

<P><PRE>CONST RPC_S_CALL_IN_PROGRESS = 1791;
</PRE><BLOCKQUOTE><EM> A remote procedure call is already in progress for this thread.</EM></BLOCKQUOTE><PRE>

CONST ERROR_NETLOGON_NOT_STARTED = 1792;
</PRE><BLOCKQUOTE><EM> An attempt was made to logon, but the netlogon service was not started.</EM></BLOCKQUOTE><PRE>

CONST ERROR_ACCOUNT_EXPIRED = 1793;
</PRE><BLOCKQUOTE><EM> The user's account has expired.</EM></BLOCKQUOTE><PRE>

CONST ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;
</PRE><BLOCKQUOTE><EM> The redirector is in use and  cannot be unloaded.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;
</PRE><BLOCKQUOTE><EM> The specified Printer Driver is already installed.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNKNOWN_PORT = 1796;
</PRE><BLOCKQUOTE><EM> The specified Port is unknown.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNKNOWN_PRINTER_DRIVER = 1797;
</PRE><BLOCKQUOTE><EM> The Printer Driver is unknown.</EM></BLOCKQUOTE><PRE>

CONST ERROR_UNKNOWN_PRINTPROCESSOR = 1798;
</PRE><BLOCKQUOTE><EM> The Print Processor is unknown.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_SEPARATOR_FILE = 1799;
</PRE><BLOCKQUOTE><EM> The specified separator file is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PRIORITY = 1800;
</PRE><BLOCKQUOTE><EM> The specified Priority is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PRINTER_NAME = 1801;
</PRE><BLOCKQUOTE><EM> The Printer Name is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_PRINTER_ALREADY_EXISTS: LONG = 1802;
</PRE><BLOCKQUOTE><EM> The Printer already exists.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_PRINTER_COMMAND = 1803;
</PRE><BLOCKQUOTE><EM> The Printer Command is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_DATATYPE = 1804;
</PRE><BLOCKQUOTE><EM> The specified datatype is invalid.</EM></BLOCKQUOTE><PRE>

CONST ERROR_INVALID_ENVIRONMENT = 1805;
</PRE><BLOCKQUOTE><EM> The Environment specified is invalid.</EM></BLOCKQUOTE><PRE>

END WinError.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
