<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinGDI.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinGDI.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>MODULE <module><implements><A HREF="WinGDI.i3">WinGDI</A></implements></module>;

FROM <A HREF="../../word/src/Word.i3">Word</A> IMPORT Shift, Or, Extract;

FROM <A HREF="WinDef.i3">WinDef</A> IMPORT BYTE, COLORREF, WORD;

PROCEDURE <A NAME="RGB"><procedure>RGB</procedure></A> (r, g, b: BYTE): COLORREF =
  BEGIN
    RETURN Or(r, Or(Shift(g, 8), Shift(b, 16)));
  END RGB;

PROCEDURE <A NAME="PALETTERGB"><procedure>PALETTERGB</procedure></A> (r, g, b: BYTE): COLORREF =
  BEGIN
    RETURN Or(16_02000000, RGB(r, g, b));
  END PALETTERGB;

PROCEDURE <A NAME="PALETTEINDEX"><procedure>PALETTEINDEX</procedure></A> (i: WORD): COLORREF =
  BEGIN
    RETURN Or(16_01000000, i);
  END PALETTEINDEX;

PROCEDURE <A NAME="GetRValue"><procedure>GetRValue</procedure></A> (rgb: COLORREF): BYTE =
  BEGIN
    RETURN Extract(rgb, 8, 0);
  END GetRValue;

PROCEDURE <A NAME="GetGValue"><procedure>GetGValue</procedure></A> (rgb: COLORREF): BYTE =
  BEGIN
    RETURN Extract(rgb, 8, 7);
  END GetGValue;

PROCEDURE <A NAME="GetBValue"><procedure>GetBValue</procedure></A> (rgb: COLORREF): BYTE =
  BEGIN
    RETURN Extract(rgb, 8, 15);
  END GetBValue;

BEGIN
END WinGDI.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
