<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinNT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinNT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>UNSAFE MODULE <module><implements><A HREF="WinNT.i3">WinNT</A></implements></module>;

FROM <A HREF="../../C/src/Common/M3toC.i3">M3toC</A> IMPORT TtoS;
FROM <A HREF="../../word/src/Word.i3">Word</A> IMPORT And, Or, Not, Shift;
FROM <A HREF="WinDef.i3">WinDef</A> IMPORT WORD;
</PRE> Basic Type of x 
 #define BTYPE(x) ((x) &amp; N_BTMASK) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="BTYPE"><procedure>BTYPE</procedure></A> (x: WORD): WORD =
  BEGIN
    RETURN And(x, N_BTMASK);
  END BTYPE;
</PRE> Is x a pointer? 
 #define ISPTR(x) (((x) &amp; N_TMASK) == (IMAGE_SYM_DTYPE_POINTER &lt;&lt; N_BTSHFT)) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="ISPTR"><procedure>ISPTR</procedure></A> (x: WORD): BOOLEAN =
  BEGIN
    RETURN And(x, N_TMASK) = Shift(IMAGE_SYM_DTYPE_POINTER, N_BTSHFT);
  END ISPTR;
</PRE> Is x a function? 
 #define ISFCN(x) (((x) &amp; N_TMASK) == (IMAGE_SYM_DTYPE_FUNCTION &lt;&lt; N_BTSHFT)) 
<PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="ISFCN"><procedure>ISFCN</procedure></A> (x: WORD): BOOLEAN =
  BEGIN
    RETURN And(x, N_TMASK) = Shift(IMAGE_SYM_DTYPE_FUNCTION, N_BTSHFT);
  END ISFCN;
</PRE> Is x an array? 
 #define ISARY(x) (((x) &amp; N_TMASK) == (IMAGE_SYM_DTYPE_ARRAY &lt;&lt; N_BTSHFT)) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="ISARY"><procedure>ISARY</procedure></A> (x: WORD): BOOLEAN =
  BEGIN
    RETURN And(x, N_TMASK) = Shift(IMAGE_SYM_DTYPE_ARRAY, N_BTSHFT);
  END ISARY;
</PRE> Is x a structure, union, or enumeration TAG? 
 #define ISTAG(x) ((x)==IMAGE_SYM_CLASS_STRUCT_TAG || (x)==IMAGE_SYM_CLASS_UNION_TAG || (x)==IMAGE_SYM_CLASS_ENUM_TAG) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="ISTAG"><procedure>ISTAG</procedure></A> (x: WORD): BOOLEAN =
  BEGIN
    RETURN x = IMAGE_SYM_CLASS_STRUCT_TAG OR x = IMAGE_SYM_CLASS_UNION_TAG
             OR x = IMAGE_SYM_CLASS_ENUM_TAG;
  END ISTAG;
</PRE> #define INCREF(x) ((((x)&amp;~N_BTMASK)&lt;&lt;N_TSHIFT)|(IMAGE_SYM_DTYPE_POINTER&lt;&lt;N_BTSHFT)|(x&amp;N_BTMASK)) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="INCREF"><procedure>INCREF</procedure></A> (x: WORD): WORD =
  BEGIN
    RETURN
      Or(Or(Shift(And(x, Not(N_BTMASK)), N_TSHIFT),
            Shift(IMAGE_SYM_DTYPE_POINTER, N_BTSHFT)), And(x, N_BTSHFT));
  END INCREF;
</PRE> #define DECREF(x) ((((x)&gt;&gt;N_TSHIFT)&amp;~N_BTMASK)|((x)&amp;N_BTMASK)) 

<P><PRE>&lt;* INLINE *&gt;
PROCEDURE <A NAME="DECREF"><procedure>DECREF</procedure></A> (x: WORD): WORD =
  BEGIN
    RETURN Or(And(Shift(x, -N_TSHIFT), Not(N_BTMASK)), And(x, N_BTMASK));
  END DECREF;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="IMAGE_SNAP_BY_ORDINAL"><procedure>IMAGE_SNAP_BY_ORDINAL</procedure></A> (Ordinal: WORD): BOOLEAN =
  BEGIN
    RETURN And(Ordinal, IMAGE_ORDINAL_FLAG) # 0;
  END IMAGE_SNAP_BY_ORDINAL;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="IMAGE_ORDINAL"><procedure>IMAGE_ORDINAL</procedure></A> (Ordinal: WORD): WORD =
  BEGIN
    RETURN And(Ordinal, 16_ffff);
  END IMAGE_ORDINAL;

BEGIN
  IMAGE_ARCHIVE_START            := TtoS(&quot;!&lt;arch&gt;\n&quot;);
  IMAGE_ARCHIVE_END              := TtoS(&quot;`\n&quot;);
  IMAGE_ARCHIVE_PAD              := TtoS(&quot;\n&quot;);
  IMAGE_ARCHIVE_LINKER_MEMBER    := TtoS(&quot;/               &quot;);
  IMAGE_ARCHIVE_LONGNAMES_MEMBER := TtoS(&quot;//              &quot;);
END WinNT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
