<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinNetwk.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinNetwk.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>INTERFACE <interface>WinNetwk</interface>;
</PRE> Corresponds to <CODE>winnetwk.h</CODE>.
   See that file for details.
<P>
   Standard WINNET Header File for NT-WIN32 

<P><PRE>IMPORT <A HREF="WinError.i3">WinError</A>;

FROM <A HREF="WinDef.i3">WinDef</A> IMPORT BOOL, DWORD, LPDWORD, LPVOID, LPHANDLE;
FROM <A HREF="WinNT.i3">WinNT</A> IMPORT HANDLE, LPSTR, LPWSTR;
</PRE> RESOURCE ENUMERATION 

<P><PRE>CONST
  RESOURCE_CONNECTED  = 16_00000001;
  RESOURCE_GLOBALNET  = 16_00000002;
  RESOURCE_REMEMBERED = 16_00000003;

  RESOURCETYPE_ANY   = 16_00000000;
  RESOURCETYPE_DISK  = 16_00000001;
  RESOURCETYPE_PRINT = 16_00000002;

  RESOURCEUSAGE_CONNECTABLE = 16_00000001;
  RESOURCEUSAGE_CONTAINER   = 16_00000002;
  RESOURCEUSAGE_RESERVED    = 16_80000000;

  RESOURCEDISPLAYTYPE_GENERIC = 16_00000000;
  RESOURCEDISPLAYTYPE_DOMAIN  = 16_00000001;
  RESOURCEDISPLAYTYPE_SERVER  = 16_00000002;
  RESOURCEDISPLAYTYPE_SHARE   = 16_00000003;

TYPE
  LPNETRESOURCEA = UNTRACED REF NETRESOURCEA;
  NETRESOURCEA = RECORD
    dwScope      : DWORD;
    dwType       : DWORD;
    dwDisplayType: DWORD;
    dwUsage      : DWORD;
    lpLocalName  : LPSTR;
    lpRemoteName : LPSTR;
    lpComment    : LPSTR;
    lpProvider   : LPSTR;
  END;

  LPNETRESOURCEW = UNTRACED REF NETRESOURCEW;
  NETRESOURCEW = RECORD
    dwScope      : DWORD;
    dwType       : DWORD;
    dwDisplayType: DWORD;
    dwUsage      : DWORD;
    lpLocalName  : LPWSTR;
    lpRemoteName : LPWSTR;
    lpComment    : LPWSTR;
    lpProvider   : LPWSTR;
  END;

  NETRESOURCE   = NETRESOURCEA;
  LPNETRESOURCE = LPNETRESOURCEA;
</PRE> CONNECTIONS 

<P><PRE>CONST CONNECT_UPDATE_PROFILE = 16_00000001;

TYPE

&lt;*EXTERNAL WNetAddConnectionA:APIENTRY*&gt;
PROCEDURE WNetAddConnectionA (lpRemoteName: LPSTR;
                              lpPassword  : LPSTR;
                              lpLocalName : LPSTR  ): DWORD;

&lt;*EXTERNAL WNetAddConnectionW:APIENTRY*&gt;
PROCEDURE WNetAddConnectionW (lpRemoteName: LPWSTR;
                              lpPassword  : LPWSTR;
                              lpLocalName : LPWSTR  ): DWORD;
CONST WNetAddConnection = WNetAddConnectionA;

&lt;*EXTERNAL WNetAddConnection2A:APIENTRY*&gt;
PROCEDURE WNetAddConnection2A (lpNetResource: LPNETRESOURCEA;
                               lpPassword   : LPSTR;
                               lpUserName   : LPSTR;
                               dwFlags      : DWORD           ): DWORD;

&lt;*EXTERNAL WNetAddConnection2W:APIENTRY*&gt;
PROCEDURE WNetAddConnection2W (lpNetResource: LPNETRESOURCEW;
                               lpPassword   : LPWSTR;
                               lpUserName   : LPWSTR;
                               dwFlags      : DWORD           ): DWORD;
CONST WNetAddConnection2 = WNetAddConnection2A;

&lt;*EXTERNAL WNetCancelConnectionA:APIENTRY*&gt;
PROCEDURE WNetCancelConnectionA (lpName: LPSTR; fForce: BOOL): DWORD;

&lt;*EXTERNAL WNetCancelConnectionW:APIENTRY*&gt;
PROCEDURE WNetCancelConnectionW (lpName: LPWSTR; fForce: BOOL): DWORD;
CONST WNetCancelConnection = WNetCancelConnectionA;

&lt;*EXTERNAL WNetCancelConnection2A:APIENTRY*&gt;
PROCEDURE WNetCancelConnection2A (lpName : LPSTR;
                                  dwFlags: DWORD;
                                  fForce : BOOL   ): DWORD;

&lt;*EXTERNAL WNetCancelConnection2W:APIENTRY*&gt;
PROCEDURE WNetCancelConnection2W (lpName : LPWSTR;
                                  dwFlags: DWORD;
                                  fForce : BOOL    ): DWORD;
CONST WNetCancelConnection2 = WNetCancelConnection2A;

&lt;*EXTERNAL WNetGetConnectionA:APIENTRY*&gt;
PROCEDURE WNetGetConnectionA (lpLocalName : LPSTR;
                              lpRemoteName: LPSTR;
                              lpnLength   : LPDWORD): DWORD;

&lt;*EXTERNAL WNetGetConnectionW:APIENTRY*&gt;
PROCEDURE WNetGetConnectionW (lpLocalName : LPWSTR;
                              lpRemoteName: LPWSTR;
                              lpnLength   : LPDWORD ): DWORD;
CONST WNetGetConnection = WNetGetConnectionA;

&lt;*EXTERNAL WNetOpenEnumA:APIENTRY*&gt;
PROCEDURE WNetOpenEnumA (dwScope      : DWORD;
                         dwType       : DWORD;
                         dwUsage      : DWORD;
                         lpNetResource: LPNETRESOURCEA;
                         lphEnum      : LPHANDLE        ): DWORD;

&lt;*EXTERNAL WNetOpenEnumW:APIENTRY*&gt;
PROCEDURE WNetOpenEnumW (dwScope      : DWORD;
                         dwType       : DWORD;
                         dwUsage      : DWORD;
                         lpNetResource: LPNETRESOURCEW;
                         lphEnum      : LPHANDLE        ): DWORD;
CONST WNetOpenEnum = WNetOpenEnumA;

&lt;*EXTERNAL WNetEnumResourceA:APIENTRY*&gt;
PROCEDURE WNetEnumResourceA (hEnum       : HANDLE;
                             lpcCount    : LPDWORD;
                             lpBuffer    : LPVOID;
                             lpBufferSize: LPDWORD  ): DWORD;

&lt;*EXTERNAL WNetEnumResourceW:APIENTRY*&gt;
PROCEDURE WNetEnumResourceW (hEnum       : HANDLE;
                             lpcCount    : LPDWORD;
                             lpBuffer    : LPVOID;
                             lpBufferSize: LPDWORD  ): DWORD;
CONST WNetEnumResource = WNetEnumResourceA;

&lt;*EXTERNAL WNetCloseEnum:APIENTRY*&gt;
PROCEDURE WNetCloseEnum (hEnum: HANDLE): DWORD;
</PRE> OTHER 

<P><PRE>&lt;*EXTERNAL WNetGetUserA:APIENTRY*&gt;
PROCEDURE WNetGetUserA (lpName    : LPSTR;
                        lpUserName: LPSTR;
                        lpnLength : LPDWORD): DWORD;

&lt;*EXTERNAL WNetGetUserW:APIENTRY*&gt;
PROCEDURE WNetGetUserW (lpName    : LPWSTR;
                        lpUserName: LPWSTR;
                        lpnLength : LPDWORD ): DWORD;
CONST WNetGetUser = WNetGetUserA;
</PRE> BROWSE DIALOG 

<P><PRE>&lt;*EXTERNAL HWND:APIENTRY*&gt;
PROCEDURE HWND (dwType: DWORD): DWORD;
</PRE> ERRORS 

<P><PRE>&lt;*EXTERNAL WNetGetLastErrorA:APIENTRY*&gt;
PROCEDURE WNetGetLastErrorA (lpError      : LPDWORD;
                             lpErrorBuf   : LPSTR;
                             nErrorBufSize: DWORD;
                             lpNameBuf    : LPSTR;
                             nNameBufSize : DWORD    ): DWORD;

&lt;*EXTERNAL WNetGetLastErrorW:APIENTRY*&gt;
PROCEDURE WNetGetLastErrorW (lpError      : LPDWORD;
                             lpErrorBuf   : LPWSTR;
                             nErrorBufSize: DWORD;
                             lpNameBuf    : LPWSTR;
                             nNameBufSize : DWORD    ): DWORD;
CONST WNetGetLastError = WNetGetLastErrorA;
</PRE> STATUS CODES 

<P> This section is provided for backward compatibility.  Use of the ERROR_*
   codes is preferred.  The WN_* error codes may not be available in future
   releases. 

<P> General 

<P><PRE>CONST
  WN_SUCCESS        = WinError.NO_ERROR;
  WN_NOT_SUPPORTED  = WinError.ERROR_NOT_SUPPORTED;
  WN_NET_ERROR      = WinError.ERROR_UNEXP_NET_ERR;
  WN_MORE_DATA      = WinError.ERROR_MORE_DATA;
  WN_BAD_POINTER    = WinError.ERROR_INVALID_ADDRESS;
  WN_BAD_VALUE      = WinError.ERROR_INVALID_PARAMETER;
  WN_BAD_PASSWORD   = WinError.ERROR_INVALID_PASSWORD;
  WN_ACCESS_DENIED  = WinError.ERROR_ACCESS_DENIED;
  WN_FUNCTION_BUSY  = WinError.ERROR_BUSY;
  WN_WINDOWS_ERROR  = WinError.ERROR_UNEXP_NET_ERR;
  WN_BAD_USER       = WinError.ERROR_BAD_USERNAME;
  WN_OUT_OF_MEMORY  = WinError.ERROR_NOT_ENOUGH_MEMORY;
  WN_NO_NETWORK     = WinError.ERROR_NO_NETWORK;
  WN_EXTENDED_ERROR = WinError.ERROR_EXTENDED_ERROR;
</PRE> Connection 

<P><PRE>CONST
  WN_NOT_CONNECTED       = WinError.ERROR_NOT_CONNECTED;
  WN_OPEN_FILES          = WinError.ERROR_OPEN_FILES;
  WN_DEVICE_IN_USE       = WinError.ERROR_DEVICE_IN_USE;
  WN_BAD_NETNAME         = WinError.ERROR_BAD_NET_NAME;
  WN_BAD_LOCALNAME       = WinError.ERROR_BAD_DEVICE;
  WN_ALREADY_CONNECTED   = WinError.ERROR_ALREADY_ASSIGNED;
  WN_DEVICE_ERROR        = WinError.ERROR_GEN_FAILURE;
  WN_CONNECTION_CLOSED   = WinError.ERROR_CONNECTION_UNAVAIL;
  WN_NO_NET_OR_BAD_PATH  = WinError.ERROR_NO_NET_OR_BAD_PATH;
  WN_BAD_PROVIDER        = WinError.ERROR_BAD_PROVIDER;
  WN_CANNOT_OPEN_PROFILE = WinError.ERROR_CANNOT_OPEN_PROFILE;
  WN_BAD_PROFILE         = WinError.ERROR_BAD_PROFILE;
</PRE> Enumeration 

<P><PRE>CONST
  WN_BAD_HANDLE      = WinError.ERROR_INVALID_HANDLE;
  WN_NO_MORE_ENTRIES = WinError.ERROR_NO_MORE_ITEMS;
  WN_NOT_CONTAINER   = WinError.ERROR_NOT_CONTAINER;

  WN_NO_ERROR = WinError.NO_ERROR;

END WinNetwk.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
