<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinReg.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinReg.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>INTERFACE <interface>WinReg</interface>;
</PRE> Corresponds to build version 0001 of <CODE>winreg.h</CODE>.
   See that file for details.
<P>
   This module contains the function prototypes and constant, type and
   structure definitions for the Windows 32-Bit Registry API. 

<P><PRE>IMPORT <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="WinBase.i3">WinBase</A>, <A HREF="WinNT.i3">WinNT</A>;

FROM <A HREF="WinNT.i3">WinNT</A> IMPORT LONG, LPSTR, LPWSTR, HANDLE;
FROM <A HREF="WinDef.i3">WinDef</A> IMPORT DWORD, LPDWORD, LPBYTE, BOOL;
</PRE> Requested Key access mask type. 

<P><PRE>TYPE REGSAM = WinNT.ACCESS_MASK;
</PRE> Type definitions. 

<P><PRE>TYPE
  HKEY  = UNTRACED BRANDED &quot;HKEY&quot; REF RECORD unused: Ctypes.int;  END;
  PHKEY = UNTRACED REF PHKEY;
</PRE> Reserved Key Handles. 

<P> !!! Eeeek!!!
CONST
  HKEY_CLASSES_ROOT    : HKEY = 16_80000000;
  HKEY_CURRENT_USER    : HKEY = 16_80000001;
  HKEY_LOCAL_MACHINE   : HKEY = 16_80000002;
  HKEY_USERS           : HKEY = 16_80000003;
  HKEY_PERFORMANCE_DATA: HKEY = 16_80000004;


<P> API Prototypes. 

<P><PRE>&lt;*EXTERNAL RegCloseKey:APIENTRY*&gt;
PROCEDURE RegCloseKey (hKey: HKEY): LONG;

&lt;*EXTERNAL RegConnectRegistryA:APIENTRY*&gt;
PROCEDURE RegConnectRegistryA (lpMachineName: LPSTR;
                               hKey         : HKEY;
                               phkResult    : PHKEY  ): LONG;

&lt;*EXTERNAL RegConnectRegistryW:APIENTRY*&gt;
PROCEDURE RegConnectRegistryW (lpMachineName: LPWSTR;
                               hKey         : HKEY;
                               phkResult    : PHKEY   ): LONG;

CONST RegConnectRegistry = RegConnectRegistryA;

&lt;*EXTERNAL RegCreateKeyA:APIENTRY*&gt;
PROCEDURE RegCreateKeyA (hKey: HKEY; lpSubKey: LPSTR; phkResult: PHKEY): LONG;

&lt;*EXTERNAL RegCreateKeyW:APIENTRY*&gt;
PROCEDURE RegCreateKeyW (hKey: HKEY; lpSubKey: LPWSTR; phkResult: PHKEY): LONG;

CONST RegCreateKey = RegCreateKeyA;

&lt;*EXTERNAL RegCreateKeyExA:APIENTRY*&gt;
PROCEDURE RegCreateKeyExA (hKey                : HKEY;
                           lpSubKey            : LPSTR;
                           Reserved            : DWORD;
                           lpClass             : LPSTR;
                           dwOptions           : DWORD;
                           samDesired          : REGSAM;
                           lpSecurityAttributes: WinBase.LPSECURITY_ATTRIBUTES;
                           phkResult           : PHKEY;
                           lpdwDisposition     : LPDWORD                ): LONG;

&lt;*EXTERNAL RegCreateKeyExW:APIENTRY*&gt;
PROCEDURE RegCreateKeyExW (hKey                : HKEY;
                           lpSubKey            : LPWSTR;
                           Reserved            : DWORD;
                           lpClass             : LPWSTR;
                           dwOptions           : DWORD;
                           samDesired          : REGSAM;
                           lpSecurityAttributes: WinBase.LPSECURITY_ATTRIBUTES;
                           phkResult           : PHKEY;
                           lpdwDisposition     : LPDWORD                ): LONG;

CONST RegCreateKeyEx = RegCreateKeyExA;

&lt;*EXTERNAL RegDeleteKeyA:APIENTRY*&gt;
PROCEDURE RegDeleteKeyA (hKey: HKEY; lpSubKey: LPSTR): LONG;

&lt;*EXTERNAL RegDeleteKeyW:APIENTRY*&gt;
PROCEDURE RegDeleteKeyW (hKey: HKEY; lpSubKey: LPWSTR): LONG;

CONST RegDeleteKey = RegDeleteKeyA;

&lt;*EXTERNAL RegDeleteValueA:APIENTRY*&gt;
PROCEDURE RegDeleteValueA (hKey: HKEY; lpValueName: LPSTR): LONG;

&lt;*EXTERNAL RegDeleteValueW:APIENTRY*&gt;
PROCEDURE RegDeleteValueW (hKey: HKEY; lpValueName: LPWSTR): LONG;

CONST RegDeleteValue = RegDeleteValueA;

&lt;*EXTERNAL RegEnumKeyA:APIENTRY*&gt;
PROCEDURE RegEnumKeyA (hKey   : HKEY;
                                                     dwIndex: DWORD;
                                                     lpName : LPSTR;
                                                     cbName : DWORD  ): LONG;

&lt;*EXTERNAL RegEnumKeyW:APIENTRY*&gt;
PROCEDURE RegEnumKeyW (hKey   : HKEY;
                                                     dwIndex: DWORD;
                                                     lpName : LPWSTR;
                                                     cbName : DWORD   ): LONG;

CONST RegEnumKey = RegEnumKeyA;

&lt;*EXTERNAL RegEnumKeyExA:APIENTRY*&gt;
PROCEDURE RegEnumKeyExA (hKey             : HKEY;
                         dwIndex          : DWORD;
                         lpName           : LPSTR;
                         lpcbName         : LPDWORD;
                         lpReserved       : LPDWORD;
                         lpClass          : LPSTR;
                         lpcbClass        : LPDWORD;
                         lpftLastWriteTime: WinBase.PFILETIME): LONG;

&lt;*EXTERNAL RegEnumKeyExW:APIENTRY*&gt;
PROCEDURE RegEnumKeyExW (hKey             : HKEY;
                         dwIndex          : DWORD;
                         lpName           : LPWSTR;
                         lpcbName         : LPDWORD;
                         lpReserved       : LPDWORD;
                         lpClass          : LPWSTR;
                         lpcbClass        : LPDWORD;
                         lpftLastWriteTime: WinBase.PFILETIME): LONG;

CONST RegEnumKeyEx = RegEnumKeyExA;

&lt;*EXTERNAL RegEnumValueA:APIENTRY*&gt;
PROCEDURE RegEnumValueA (hKey         : HKEY;
                         dwIndex      : DWORD;
                         lpValueName  : LPSTR;
                         lpcbValueName: LPDWORD;
                         lpReserved   : LPDWORD;
                         lpType       : LPDWORD;
                         lpData       : LPBYTE;
                         lpcbData     : LPDWORD  ): LONG;

&lt;*EXTERNAL RegEnumValueW:APIENTRY*&gt;
PROCEDURE RegEnumValueW (hKey         : HKEY;
                         dwIndex      : DWORD;
                         lpValueName  : LPWSTR;
                         lpcbValueName: LPDWORD;
                         lpReserved   : LPDWORD;
                         lpType       : LPDWORD;
                         lpData       : LPBYTE;
                         lpcbData     : LPDWORD  ): LONG;

CONST RegEnumValue = RegEnumValueA;

&lt;*EXTERNAL RegFlushKey:APIENTRY*&gt;
PROCEDURE RegFlushKey (hKey: HKEY): LONG;

&lt;*EXTERNAL RegGetKeySecurity:APIENTRY*&gt;
PROCEDURE RegGetKeySecurity (hKey               : HKEY;
                             SecurityInformation: WinNT.SECURITY_INFORMATION;
                             pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR;
                             lpcbSecurityDescriptor: LPDWORD): LONG;

&lt;*EXTERNAL RegLoadKeyA:APIENTRY*&gt;
PROCEDURE RegLoadKeyA (hKey: HKEY; lpSubKey: LPSTR; lpFile: LPSTR): LONG;

&lt;*EXTERNAL RegLoadKeyW:APIENTRY*&gt;
PROCEDURE RegLoadKeyW (hKey: HKEY; lpSubKey: LPWSTR; lpFile: LPWSTR): LONG;

CONST RegLoadKey = RegLoadKeyA;

&lt;*EXTERNAL RegNotifyChangeKeyValue:APIENTRY*&gt;
PROCEDURE RegNotifyChangeKeyValue (hKey          : HKEY;
                                   bWatchSubtree : BOOL;
                                   dwNotifyFilter: DWORD;
                                   hEvent        : HANDLE;
                                   fAsynchronus  : BOOL    ): LONG;

&lt;*EXTERNAL RegOpenKeyA:APIENTRY*&gt;
PROCEDURE RegOpenKeyA (hKey: HKEY; lpSubKey: LPSTR; phkResult: PHKEY): LONG;

&lt;*EXTERNAL RegOpenKeyW:APIENTRY*&gt;
PROCEDURE RegOpenKeyW (hKey: HKEY; lpSubKey: LPWSTR; phkResult: PHKEY): LONG;

CONST RegOpenKey = RegOpenKeyA;

&lt;*EXTERNAL RegOpenKeyExA:APIENTRY*&gt;
PROCEDURE RegOpenKeyExA (hKey      : HKEY;
                         lpSubKey  : LPSTR;
                         ulOptions : DWORD;
                         samDesired: REGSAM;
                         phkResult : PHKEY   ): LONG;

&lt;*EXTERNAL RegOpenKeyExW:APIENTRY*&gt;
PROCEDURE RegOpenKeyExW (hKey      : HKEY;
                         lpSubKey  : LPWSTR;
                         ulOptions : DWORD;
                         samDesired: REGSAM;
                         phkResult : PHKEY   ): LONG;

CONST RegOpenKeyEx = RegOpenKeyExA;

&lt;*EXTERNAL RegQueryInfoKeyA:APIENTRY*&gt;
PROCEDURE RegQueryInfoKeyA (hKey                  : HKEY;
                            lpClass               : LPSTR;
                            lpcbClass             : LPDWORD;
                            lpReserved            : LPDWORD;
                            lpcSubKeys            : LPDWORD;
                            lpcbMaxSubKeyLen      : LPDWORD;
                            lpcbMaxClassLen       : LPDWORD;
                            lpcValues             : LPDWORD;
                            lpcbMaxValueNameLen   : LPDWORD;
                            lpcbMaxValueLen       : LPDWORD;
                            lpcbSecurityDescriptor: LPDWORD;
                            lpftLastWriteTime     : WinBase.PFILETIME): LONG;

&lt;*EXTERNAL RegQueryInfoKeyW:APIENTRY*&gt;
PROCEDURE RegQueryInfoKeyW (hKey                  : HKEY;
                            lpClass               : LPWSTR;
                            lpcbClass             : LPDWORD;
                            lpReserved            : LPDWORD;
                            lpcSubKeys            : LPDWORD;
                            lpcbMaxSubKeyLen      : LPDWORD;
                            lpcbMaxClassLen       : LPDWORD;
                            lpcValues             : LPDWORD;
                            lpcbMaxValueNameLen   : LPDWORD;
                            lpcbMaxValueLen       : LPDWORD;
                            lpcbSecurityDescriptor: LPDWORD;
                            lpftLastWriteTime     : WinBase.PFILETIME): LONG;

CONST RegQueryInfoKey = RegQueryInfoKeyA;

&lt;*EXTERNAL RegQueryValueA:APIENTRY*&gt;
PROCEDURE RegQueryValueA (hKey     : HKEY;
                          lpSubKey : LPSTR;
                          lpValue  : LPSTR;
                          lpcbValue: LPDWORD): LONG;

&lt;*EXTERNAL RegQueryValueW:APIENTRY*&gt;
PROCEDURE RegQueryValueW (hKey     : HKEY;
                          lpSubKey : LPWSTR;
                          lpValue  : LPWSTR;
                          lpcbValue: LPDWORD ): LONG;

CONST RegQueryValue = RegQueryValueA;

&lt;*EXTERNAL RegQueryValueExA:APIENTRY*&gt;
PROCEDURE RegQueryValueExA (hKey       : HKEY;
                            lpValueName: LPSTR;
                            lpReserved : LPDWORD;
                            lpType     : LPDWORD;
                            lpData     : LPBYTE;
                            lpcbData   : LPDWORD  ): LONG;

&lt;*EXTERNAL RegQueryValueExW:APIENTRY*&gt;
PROCEDURE RegQueryValueExW (hKey       : HKEY;
                            lpValueName: LPWSTR;
                            lpReserved : LPDWORD;
                            lpType     : LPDWORD;
                            lpData     : LPBYTE;
                            lpcbData   : LPDWORD  ): LONG;

CONST RegQueryValueEx = RegQueryValueExA;

&lt;*EXTERNAL RegReplaceKeyA:APIENTRY*&gt;
PROCEDURE RegReplaceKeyA (hKey     : HKEY;
                          lpSubKey : LPSTR;
                          lpNewFile: LPSTR;
                          lpOldFile: LPSTR  ): LONG;

&lt;*EXTERNAL RegReplaceKeyW:APIENTRY*&gt;
PROCEDURE RegReplaceKeyW (hKey     : HKEY;
                          lpSubKey : LPWSTR;
                          lpNewFile: LPWSTR;
                          lpOldFile: LPWSTR  ): LONG;

CONST RegReplaceKey = RegReplaceKeyA;

&lt;*EXTERNAL RegRestoreKeyA:APIENTRY*&gt;
PROCEDURE RegRestoreKeyA (hKey: HKEY; lpFile: LPSTR; dwFlags: DWORD): LONG;

&lt;*EXTERNAL RegRestoreKeyW:APIENTRY*&gt;
PROCEDURE RegRestoreKeyW (hKey: HKEY; lpFile: LPWSTR; dwFlags: DWORD): LONG;

CONST RegRestoreKey = RegRestoreKeyA;

&lt;*EXTERNAL RegSaveKeyA:APIENTRY*&gt;
PROCEDURE RegSaveKeyA (hKey                : HKEY;
                       lpFile              : LPSTR;
                       lpSecurityAttributes: WinBase.LPSECURITY_ATTRIBUTES): LONG;

&lt;*EXTERNAL RegSaveKeyW:APIENTRY*&gt;
PROCEDURE RegSaveKeyW (hKey                : HKEY;
                       lpFile              : LPWSTR;
                       lpSecurityAttributes: WinBase.LPSECURITY_ATTRIBUTES): LONG;

CONST RegSaveKey = RegSaveKeyA;

&lt;*EXTERNAL RegSetKeySecurity:APIENTRY*&gt;
PROCEDURE RegSetKeySecurity (hKey               : HKEY;
                             SecurityInformation: WinNT.SECURITY_INFORMATION;
                             pSecurityDescriptor: WinNT.PSECURITY_DESCRIPTOR  ): LONG;

&lt;*EXTERNAL RegSetValueA:APIENTRY*&gt;
PROCEDURE RegSetValueA (hKey    : HKEY;
                        lpSubKey: LPSTR;
                        dwType  : DWORD;
                        lpData  : LPSTR;
                        cbData  : DWORD  ): LONG;

&lt;*EXTERNAL RegSetValueW:APIENTRY*&gt;
PROCEDURE RegSetValueW (hKey    : HKEY;
                        lpSubKey: LPWSTR;
                        dwType  : DWORD;
                        lpData  : LPWSTR;
                        cbData  : DWORD   ): LONG;

CONST RegSetValue = RegSetValueA;

&lt;*EXTERNAL RegSetValueExA:APIENTRY*&gt;
PROCEDURE RegSetValueExA (hKey       : HKEY;
                          lpValueName: LPSTR;
                          Reserved   : DWORD;
                          dwType     : DWORD;
                          lpData     : LPBYTE;
                          cbData     : DWORD   ): LONG;

&lt;*EXTERNAL RegSetValueExW:APIENTRY*&gt;
PROCEDURE RegSetValueExW (hKey       : HKEY;
                          lpValueName: LPWSTR;
                          Reserved   : DWORD;
                          dwType     : DWORD;
                          lpData     : LPBYTE;
                          cbData     : DWORD   ): LONG;

CONST RegSetValueEx = RegSetValueExA;

&lt;*EXTERNAL RegUnLoadKeyA:APIENTRY*&gt;
PROCEDURE RegUnLoadKeyA (hKey: HKEY; lpSubKey: LPSTR): LONG;

&lt;*EXTERNAL RegUnLoadKeyW:APIENTRY*&gt;
PROCEDURE RegUnLoadKeyW (hKey: HKEY; lpSubKey: LPWSTR): LONG;

CONST RegUnLoadKey = RegUnLoadKeyA;
</PRE> Remoteable System Shutdown APIs 

<P><PRE>&lt;*EXTERNAL InitiateSystemShutdownA:APIENTRY*&gt;
PROCEDURE InitiateSystemShutdownA (lpMachineName       : LPSTR;
                                   lpMessage           : LPSTR;
                                   dwTimeout           : DWORD;
                                   bForceAppsClosed    : BOOL;
                                   bRebootAfterShutdown: BOOL   ): BOOL;

&lt;*EXTERNAL InitiateSystemShutdownW:APIENTRY*&gt;
PROCEDURE InitiateSystemShutdownW (lpMachineName       : LPWSTR;
                                   lpMessage           : LPWSTR;
                                   dwTimeout           : DWORD;
                                   bForceAppsClosed    : BOOL;
                                   bRebootAfterShutdown: BOOL    ): BOOL;

CONST InitiateSystemShutdown = InitiateSystemShutdownA;

&lt;*EXTERNAL AbortSystemShutdownA:APIENTRY*&gt;
PROCEDURE AbortSystemShutdownA (lpMachineName: LPSTR): BOOL;

&lt;*EXTERNAL AbortSystemShutdownW:APIENTRY*&gt;
PROCEDURE AbortSystemShutdownW (lpMachineName: LPWSTR): BOOL;

CONST AbortSystemShutdown = AbortSystemShutdownA;

END WinReg.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
