<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinUser.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinUser.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>INTERFACE <interface><A HREF="WinUser.m3">WinUser</A></interface>;
</PRE> This file corresponds to build version 0003 of <CODE>winuser.h</CODE>
   See that file for details.
<P>
   Procedure declarations, constant definitions and macros for the User
   component. 

<P><PRE>IMPORT <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>;

FROM <A HREF="../../word/src/Word.i3">Word</A> IMPORT Or;
FROM <A HREF="WinDef.i3">WinDef</A> IMPORT SHORT, BOOL, WORD, DWORD, UINT, LPDWORD, LPWORD, LPVOID,
                   HWND, HDC, WPARAM, LPARAM, LRESULT, HINSTANCE, HMENU,
                   POINT, HKL, HDESK, HWINSTA, HICON, HCURSOR, HBRUSH,
                   RECT, BYTE, ATOM, PBYTE, LPBYTE, LPHANDLE, HACCEL,
                   HBITMAP, LPRECT, LPINT, HRGN, LPPOINT, INT, COLORREF,
                   HHOOK;
FROM <A HREF="WinNT.i3">WinNT</A> IMPORT WCHAR, HANDLE, LPSTR, LPWSTR, PVOID, LPTSTR, LPCSTR,
                  LPCWSTR, LONG, PSECURITY_INFORMATION,
                  PSECURITY_DESCRIPTOR, LPCTSTR;
FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int, char, long, void_star;

CONST WINVER = 16_0314;         (* version 3.2 *)

TYPE
  HDWP = HANDLE;
</PRE> MENUTEMPLATEA = VOID; (* No M3 equivalent 
  <PRE>MENUTEMPLATEW = VOID; *)

  LPMENUTEMPLATE = void_star;

  WNDPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: UINT;
                                    a3: WPARAM; a4: LPARAM): LRESULT;

  DLGPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: UINT;
                                    a3: WPARAM; a4: LPARAM): BOOL;

  TIMERPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: UINT; a3: UINT; a4: DWORD);

  GRAYSTRINGPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HDC; a2: LPARAM; a3: int): BOOL;

  PROPENUMPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: LPCSTR;
                                         a3: HANDLE): BOOL;

  PROPENUMPROCEX = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: LPTSTR;
                                           a3: HANDLE; a4: DWORD): BOOL;

  WNDENUMPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: LPARAM): BOOL;

  HOOKPROC = &lt;*CALLBACK*&gt; PROCEDURE (code: int; wParam: WPARAM;
                                     lParam: LPARAM): LRESULT;

  EDITWORDBREAKPROC = &lt;*CALLBACK*&gt; PROCEDURE (lpch: LPSTR; ichCurrent: int;
                                              cch: int; code: int): int;

  SENDASYNCPROC = &lt;*CALLBACK*&gt; PROCEDURE (a1: HWND; a2: UINT;
                                          a3: DWORD; a4: LRESULT);
</PRE>!!!  #define MAKEINTRESOURCE(i) (LPTSTR)((DWORD)((WORD)(i))) 

<P> Predefined Resource Types 
<PRE>VAR                             (* CONST *)
  RT_CURSOR      : LPTSTR;
  RT_BITMAP      : LPTSTR;
  RT_ICON        : LPTSTR;
  RT_MENU        : LPTSTR;
  RT_DIALOG      : LPTSTR;
  RT_STRING      : LPTSTR;
  RT_FONTDIR     : LPTSTR;
  RT_FONT        : LPTSTR;
  RT_ACCELERATOR : LPTSTR;
  RT_RCDATA      : LPTSTR;
  RT_MESSAGETABLE: LPTSTR;

CONST DIFFERENCE = 11;

VAR                             (* CONST *)
  (* NOTE: if any new resource types are introduced above this point, then
     the ** value of DIFFERENCE must be changed.  ** (RT_GROUP_CURSOR -
     RT_CURSOR) must always be equal to DIFFERENCE ** (RT_GROUP_ICON -
     RT_ICON) must always be equal to DIFFERENCE *)
  RT_GROUP_CURSOR: LPTSTR;
  (* The value RT_BITMAP+DIFFERENCE (13) is intentionally unused *)
  RT_GROUP_ICON: LPTSTR;
  (* The value 15 is unused/obsolete *)
  RT_VERSION   : LPTSTR;
  RT_DLGINCLUDE: LPTSTR;

TYPE
  wvsprintfA = &lt;*WINAPI*&gt; PROCEDURE (a1: LPSTR; a2: LPCSTR;
                                     arglist: Ctypes.void_star): Ctypes.int;
  wvsprintfW = &lt;*WINAPI*&gt; PROCEDURE (a1: LPWSTR; a2: LPCWSTR;
                                     arglist: Ctypes.void_star): Ctypes.int;
  wvsprintf = wvsprintfA;
</PRE> Steve G.  How do you want to handle varargs??? 

int WINAPI wsprintfA(LPSTR, LPCSTR, ...);
int WINAPI wsprintfW(LPWSTR, LPCWSTR, ...);
#ifdef UNICODE
#define wsprintf wsprintfW
#else
#define wsprintf wsprintfA
#endif // !UNICODE


<P> Scroll Bar Constants 
<PRE>CONST
  SB_HORZ = 0;
  SB_VERT = 1;
  SB_CTL  = 2;
  SB_BOTH = 3;
  SB_MAX  = 3;
</PRE> Scroll Bar Commands 
<PRE>CONST
  SB_LINEUP        = 0;
  SB_LINELEFT      = 0;
  SB_LINEDOWN      = 1;
  SB_LINERIGHT     = 1;
  SB_PAGEUP        = 2;
  SB_PAGELEFT      = 2;
  SB_PAGEDOWN      = 3;
  SB_PAGERIGHT     = 3;
  SB_THUMBPOSITION = 4;
  SB_THUMBTRACK    = 5;
  SB_TOP           = 6;
  SB_LEFT          = 6;
  SB_BOTTOM        = 7;
  SB_RIGHT         = 7;
  SB_ENDSCROLL     = 8;
  SB_CMD_MAX       = 8;
</PRE> ShowWindow() Commands 
<PRE>CONST
  SW_HIDE            = 0;
  SW_SHOWNORMAL      = 1;
  SW_NORMAL          = 1;
  SW_SHOWMINIMIZED   = 2;
  SW_SHOWMAXIMIZED   = 3;
  SW_MAXIMIZE        = 3;
  SW_SHOWNOACTIVATE  = 4;
  SW_SHOW            = 5;
  SW_MINIMIZE        = 6;
  SW_SHOWMINNOACTIVE = 7;
  SW_SHOWNA          = 8;
  SW_RESTORE         = 9;
  SW_SHOWDEFAULT     = 10;
  SW_MAX             = 10;
</PRE> Old ShowWindow() Commands 
<PRE>CONST
  HIDE_WINDOW         = 0;
  SHOW_OPENWINDOW     = 1;
  SHOW_ICONWINDOW     = 2;
  SHOW_FULLSCREEN     = 3;
  SHOW_OPENNOACTIVATE = 4;
</PRE> Identifiers for the WM_SHOWWINDOW message 
<PRE>CONST
  SW_PARENTCLOSING = 1;
  SW_OTHERZOOM     = 2;
  SW_PARENTOPENING = 3;
  SW_OTHERUNZOOM   = 4;
</PRE> WM_KEYUP/DOWN/CHAR HIWORD(lParam) flags 
<PRE>CONST
  KF_EXTENDED = 16_0100;
  KF_DLGMODE  = 16_0800;
  KF_MENUMODE = 16_1000;
  KF_ALTDOWN  = 16_2000;
  KF_REPEAT   = 16_4000;
  KF_UP       = 16_8000;
</PRE> Virtual Keys, Standard Set 
<PRE>CONST
  VK_LBUTTON = 16_01;
  VK_RBUTTON = 16_02;
  VK_CANCEL  = 16_03;
  VK_MBUTTON = 16_04;           (* NOT contiguous with L &amp; RBUTTON *)

  VK_BACK = 16_08;
  VK_TAB  = 16_09;

  VK_CLEAR  = 16_0C;
  VK_RETURN = 16_0D;

  VK_SHIFT   = 16_10;
  VK_CONTROL = 16_11;
  VK_MENU    = 16_12;
  VK_PAUSE   = 16_13;
  VK_CAPITAL = 16_14;

  VK_ESCAPE = 16_1B;

  VK_SPACE    = 16_20;
  VK_PRIOR    = 16_21;
  VK_NEXT     = 16_22;
  VK_END      = 16_23;
  VK_HOME     = 16_24;
  VK_LEFT     = 16_25;
  VK_UP       = 16_26;
  VK_RIGHT    = 16_27;
  VK_DOWN     = 16_28;
  VK_SELECT   = 16_29;
  VK_PRINT    = 16_2A;
  VK_EXECUTE  = 16_2B;
  VK_SNAPSHOT = 16_2C;
  (* #define VK_COPY 16_2C not used by keyboards. *)
  VK_INSERT = 16_2D;
  VK_DELETE = 16_2E;
  VK_HELP   = 16_2F;

  (* VK_0 thru VK_9 are the same as ASCII '0' thru '9' (16_30 - 16_39) *)
  (* VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (16_41 - 16_5A) *)

  VK_NUMPAD0   = 16_60;
  VK_NUMPAD1   = 16_61;
  VK_NUMPAD2   = 16_62;
  VK_NUMPAD3   = 16_63;
  VK_NUMPAD4   = 16_64;
  VK_NUMPAD5   = 16_65;
  VK_NUMPAD6   = 16_66;
  VK_NUMPAD7   = 16_67;
  VK_NUMPAD8   = 16_68;
  VK_NUMPAD9   = 16_69;
  VK_MULTIPLY  = 16_6A;
  VK_ADD       = 16_6B;
  VK_SEPARATOR = 16_6C;
  VK_SUBTRACT  = 16_6D;
  VK_DECIMAL   = 16_6E;
  VK_DIVIDE    = 16_6F;
  VK_F1        = 16_70;
  VK_F2        = 16_71;
  VK_F3        = 16_72;
  VK_F4        = 16_73;
  VK_F5        = 16_74;
  VK_F6        = 16_75;
  VK_F7        = 16_76;
  VK_F8        = 16_77;
  VK_F9        = 16_78;
  VK_F10       = 16_79;
  VK_F11       = 16_7A;
  VK_F12       = 16_7B;
  VK_F13       = 16_7C;
  VK_F14       = 16_7D;
  VK_F15       = 16_7E;
  VK_F16       = 16_7F;
  VK_F17       = 16_80;
  VK_F18       = 16_81;
  VK_F19       = 16_82;
  VK_F20       = 16_83;
  VK_F21       = 16_84;
  VK_F22       = 16_85;
  VK_F23       = 16_86;
  VK_F24       = 16_87;

  VK_NUMLOCK = 16_90;
  VK_SCROLL  = 16_91;

  (*
   * VK_L* &amp; VK_R* - left and right Alt, Ctrl and Shift virtual keys.
   * Used only as parameters to GetAsyncKeyState() and GetKeyState().
   * No other API or message will distinguish left and right keys in this way.
   *)
  VK_LSHIFT   = 16_A0;
  VK_RSHIFT   = 16_A1;
  VK_LCONTROL = 16_A2;
  VK_RCONTROL = 16_A3;
  VK_LMENU    = 16_A4;
  VK_RMENU    = 16_A5;

  VK_ATTN      = 16_F6;
  VK_CRSEL     = 16_F7;
  VK_EXSEL     = 16_F8;
  VK_EREOF     = 16_F9;
  VK_PLAY      = 16_FA;
  VK_ZOOM      = 16_FB;
  VK_NONAME    = 16_FC;
  VK_PA1       = 16_FD;
  VK_OEM_CLEAR = 16_FE;
</PRE> SetWindowsHook() codes 
<PRE>CONST
  WH_MIN             = (-1);
  WH_MSGFILTER       = (-1);
  WH_JOURNALRECORD   = 0;
  WH_JOURNALPLAYBACK = 1;
  WH_KEYBOARD        = 2;
  WH_GETMESSAGE      = 3;
  WH_CALLWNDPROC     = 4;
  WH_CBT             = 5;
  WH_SYSMSGFILTER    = 6;
  WH_MOUSE           = 7;
  WH_HARDWARE        = 8;
  WH_DEBUG           = 9;
  WH_SHELL           = 10;
  WH_MAX             = 10;
</PRE> Obsolete hook codes (NO LONGER SUPPORTED) 
<PRE>CONST
  HC_GETLPLPFN  = (-3);
  HC_LPLPFNNEXT = (-2);
  HC_LPFNNEXT   = (-1);
</PRE> Hook Codes 
<PRE>CONST
  HC_ACTION      = 0;
  HC_GETNEXT     = 1;
  HC_SKIP        = 2;
  HC_NOREMOVE    = 3;
  HC_NOREM       = HC_NOREMOVE;
  HC_SYSMODALON  = 4;
  HC_SYSMODALOFF = 5;
</PRE> CBT Hook Codes 
<PRE>CONST
  HCBT_MOVESIZE     = 0;
  HCBT_MINMAX       = 1;
  HCBT_QS           = 2;
  HCBT_CREATEWND    = 3;
  HCBT_DESTROYWND   = 4;
  HCBT_ACTIVATE     = 5;
  HCBT_CLICKSKIPPED = 6;
  HCBT_KEYSKIPPED   = 7;
  HCBT_SYSCOMMAND   = 8;
  HCBT_SETFOCUS     = 9;
</PRE><P>
 * HCBT_CREATEWND parameters pointed to by lParam
 
<PRE>TYPE
  LPCBT_CREATEWNDA = UNTRACED REF CBT_CREATEWNDA;
  CBT_CREATEWNDA = RECORD
    lpcs           : UNTRACED REF CREATESTRUCTA;
    hwndInsertAfter: HWND;
  END;

  (*
   * HCBT_CREATEWND parameters pointed to by lParam
   *)
  LPCBT_CREATEWNDW = UNTRACED REF CBT_CREATEWNDW;
  CBT_CREATEWNDW = RECORD
                     lpcs           : UNTRACED REF CREATESTRUCTW;
                     hwndInsertAfter: HWND;
  END;

  CBT_CREATEWND = CBT_CREATEWNDA;
  LPCBT_CREATEWND = LPCBT_CREATEWNDA;

  (*
   * HCBT_ACTIVATE structure pointed to by lParam
   *)
  LPCBTACTIVATESTRUCT = UNTRACED REF CBTACTIVATESTRUCT;
  CBTACTIVATESTRUCT = RECORD
                        fMouse    : BOOL;
                        hWndActive: HWND;
  END;
</PRE> WH_MSGFILTER Filter Proc Codes 
<PRE>CONST
  MSGF_DIALOGBOX  = 0;
  MSGF_MESSAGEBOX = 1;
  MSGF_MENU       = 2;
  MSGF_MOVE       = 3;
  MSGF_SIZE       = 4;
  MSGF_SCROLLBAR  = 5;
  MSGF_NEXTWINDOW = 6;
  MSGF_MAINLOOP   = 8;
  MSGF_MAX        = 8;
  MSGF_USER       = 4096;
</PRE> Shell support 
<PRE>CONST
  HSHELL_WINDOWCREATED       = 1;
  HSHELL_WINDOWDESTROYED     = 2;
  HSHELL_ACTIVATESHELLWINDOW = 3;
</PRE> Window Manager Hook Codes 
<PRE>CONST
  WC_INIT          = 1;
  WC_SWP           = 2;
  WC_DEFWINDOWPROC = 3;
  WC_MINMAX        = 4;
  WC_MOVE          = 5;
  WC_SIZE          = 6;
  WC_DRAWCAPTION   = 7;
</PRE> Message Structure used in Journaling 
<PRE>TYPE
  PEVENTMSGMSG = UNTRACED REF EVENTMSG;
  PEVENTMSG = UNTRACED REF EVENTMSG;
  EVENTMSG = RECORD
    message: UINT;
    paramL : UINT;
    paramH : UINT;
    time   : DWORD;
    hwnd   : HWND;
  END;

  (* Message structure used by WH_CALLWNDPROC *)
  PCWPSTRUCT = UNTRACED REF CWPSTRUCT;
  CWPSTRUCT = RECORD
    lParam : LPARAM;
    wParam : WPARAM;
    message: DWORD;
    hwnd   : HWND;
  END;

  (* Structure used by WH_DEBUG *)
  PDEBUGHOOKINFO = UNTRACED REF DEBUGHOOKINFO;
  DEBUGHOOKINFO = RECORD
    idThread: DWORD;
    reserved: LPARAM;
    lParam  : LPARAM;
    wParam  : WPARAM;
    code    : int;
  END;

  MOUSEHOOKSTRUCT = RECORD
    pt          : POINT;
    hwnd        : HWND;
    wHitTestCode: UINT;
    dwExtraInfo : DWORD;
  END;
</PRE><P>
 * Keyboard Layout API
 
<PRE>CONST
  HKL_PREV = 0;
  HKL_NEXT = 1;

  KLF_ACTIVATE       = 16_1;
  KLF_SUBSTITUTE_OK  = 16_2;
  KLF_UNLOADPREVIOUS = 16_4;
  KLF_REORDER        = 16_8;
</PRE><P>
 * Size of KeyboardLayoutName (number of characters), including nul terminator
 
<PRE>CONST KL_NAMELENGTH = 9;

TYPE
  LoadKeyboardLayoutA = &lt;*WINAPI*&gt; PROCEDURE (pwszKLID: LPCSTR; Flags: UINT): HKL;
  LoadKeyboardLayoutW = &lt;*WINAPI*&gt; PROCEDURE (pwszKLID: LPCWSTR; Flags: UINT): HKL;
  LoadKeyboardLayout = LoadKeyboardLayoutA;

TYPE
  ActivateKeyboardLayout = &lt;*WINAPI*&gt; PROCEDURE (hkl: HKL; Flags: UINT): BOOL;
  UnloadKeyboardLayout   = &lt;*WINAPI*&gt; PROCEDURE (hkl: HKL): BOOL;
  GetKeyboardLayoutNameA = &lt;*WINAPI*&gt; PROCEDURE (pwszKLID: LPSTR): BOOL;
  GetKeyboardLayoutNameW = &lt;*WINAPI*&gt; PROCEDURE (pwszKLID: LPWSTR): BOOL;

  GetKeyboardLayoutName = GetKeyboardLayoutNameA;
</PRE><P>
 * Desktop-specific access flags
 
<PRE>CONST
  DESKTOP_ENUMWINDOWS    : LONG = 16_0001;
  DESKTOP_CREATEWINDOW   : LONG = 16_0002;
  DESKTOP_CREATEMENU     : LONG = 16_0004;
  DESKTOP_HOOKCONTROL    : LONG = 16_0008;
  DESKTOP_JOURNALRECORD  : LONG = 16_0010;
  DESKTOP_JOURNALPLAYBACK: LONG = 16_0020;
  DESKTOP_ENUMERATE      : LONG = 16_0040;

TYPE GetThreadDesktop = &lt;*WINAPI*&gt; PROCEDURE (arg1: DWORD): HDESK;
</PRE><P>
 * Windowstation-specific access flags
 
<PRE>CONST
  WINSTA_ENUMDESKTOPS     : LONG = 16_0001;
  WINSTA_READATTRIBUTES   : LONG = 16_0002;
  WINSTA_ACCESSCLIPBOARD  : LONG = 16_0004;
  WINSTA_CREATEDESKTOP    : LONG = 16_0008;
  WINSTA_WRITEATTRIBUTES  : LONG = 16_0010;
  WINSTA_ACCESSGLOBALATOMS: LONG = 16_0020;
  WINSTA_EXITWINDOWS      : LONG = 16_0040;
  WINSTA_ENUMERATE        : LONG = 16_0100;
  WINSTA_READSCREEN       : LONG = 16_0200;

&lt;*EXTERNAL GetProcessWindowStation:WINAPI*&gt;
PROCEDURE GetProcessWindowStation (): HWINSTA;
</PRE><P>
 * window-specific access flags
 
<PRE>CONST WIN_ACCESSWINDOW: LONG = 16_0001;
</PRE><P>
 * menu-specific access flags
 
<PRE>CONST MENU_ACCESSMENU: LONG = 16_0001;

&lt;*EXTERNAL SetUserObjectSecurity:WINAPI*&gt;
PROCEDURE SetUserObjectSecurity (arg1: HANDLE;
                                 arg2: PSECURITY_INFORMATION;
                                 arg3: PSECURITY_DESCRIPTOR   ): BOOL;

&lt;*EXTERNAL GetUserObjectSecurity:WINAPI*&gt;
PROCEDURE GetUserObjectSecurity (arg1: HANDLE;
                                 arg2: PSECURITY_INFORMATION;
                                 arg3: PSECURITY_DESCRIPTOR;
                                 arg4: DWORD;
                                 arg5: LPDWORD                ): BOOL;

&lt;*EXTERNAL ImpersonateDDEClientWindow:WINAPI*&gt;
PROCEDURE ImpersonateDDEClientWindow (hwndClient: HWND; hwndServer: HWND):BOOL;

TYPE
  PWNDCLASSA = UNTRACED REF WNDCLASSA;
  NPWNDCLASSA = UNTRACED REF WNDCLASSA;
  LPWNDCLASSA = UNTRACED REF WNDCLASSA;
  WNDCLASSA = RECORD
    style        : UINT;
    lpfnWndProc  : WNDPROC;
    cbClsExtra   : int;
    cbWndExtra   : int;
    hInstance    : HINSTANCE;
    hIcon        : HICON;
    hCursor      : HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName : LPCSTR;
    lpszClassName: LPCSTR;
  END;

  PWNDCLASSW = UNTRACED REF WNDCLASSW;
  LPWNDCLASSW = UNTRACED REF WNDCLASSW;
  WNDCLASSW = RECORD
    style        : UINT;
    lpfnWndProc  : WNDPROC;
    cbClsExtra   : int;
    cbWndExtra   : int;
    hInstance    : HINSTANCE;
    hIcon        : HICON;
    hCursor      : HCURSOR;
    hbrBackground: HBRUSH;
    lpszMenuName : LPCWSTR;
    lpszClassName: LPCWSTR;
  END;

  WNDCLASS = WNDCLASSA;
  PWNDCLASS = PWNDCLASSA;
  NPWNDCLASS = NPWNDCLASSA;
  LPWNDCLASS = LPWNDCLASSA;

  (* Message structure *)
  PMSG = UNTRACED REF MSG;
  LPMSG = UNTRACED REF MSG;
  MSG = RECORD
    hwnd   : HWND;
    message: UINT;
    wParam : WPARAM;
    lParam : LPARAM;
    time   : DWORD;
    pt     : POINT;
  END;
</PRE>!!!  SteveG.  Macros will cost you extra.  #define POINTSTOPOINT(pt,pts)
   {(pt).x = (SHORT)LOWORD(pts); \ (pt).y = (SHORT)HIWORD(pts);} #define
   POINTTOPOINTS(pt) (MAKELONG((short)((pt).x), (short)((pt).y))) #define
   MAKEWPARAM(l, h) (WPARAM)MAKELONG(l, h) #define MAKELPARAM(l, h)
   (LPARAM)MAKELONG(l, h) #define MAKELRESULT(l, h) (LRESULT)MAKELONG(l,
   h) 

<P> Window field offsets for GetWindowLong() 
<PRE>CONST
  GWL_WNDPROC    = (-4);
  GWL_HINSTANCE  = (-6);
  GWL_HWNDPARENT = (-8);
  GWL_STYLE      = (-16);
  GWL_EXSTYLE    = (-20);
  GWL_USERDATA   = (-21);
  GWL_ID         = (-12);
</PRE> Class field offsets for GetClassLong() 
<PRE>CONST
  GCL_MENUNAME      = (-8);
  GCL_HBRBACKGROUND = (-10);
  GCL_HCURSOR       = (-12);
  GCL_HICON         = (-14);
  GCL_HMODULE       = (-16);
  GCL_CBWNDEXTRA    = (-18);
  GCL_CBCLSEXTRA    = (-20);
  GCL_WNDPROC       = (-24);
  GCL_STYLE         = (-26);
</PRE>!!!define GCW_ATOM (-32)

<P> Window Messages 
<PRE>CONST
  WM_NULL     = 16_0000;
  WM_CREATE   = 16_0001;
  WM_DESTROY  = 16_0002;
  WM_MOVE     = 16_0003;
  WM_SIZE     = 16_0005;
  WM_ACTIVATE = 16_0006;
</PRE><BLOCKQUOTE><EM><P>
 * WM_ACTIVATE state values
 </EM></BLOCKQUOTE><PRE>
CONST
  WA_INACTIVE    = 0;
  WA_ACTIVE      = 1;
  WA_CLICKACTIVE = 2;

CONST
  WM_SETFOCUS        = 16_0007;
  WM_KILLFOCUS       = 16_0008;
  WM_ENABLE          = 16_000A;
  WM_SETREDRAW       = 16_000B;
  WM_SETTEXT         = 16_000C;
  WM_GETTEXT         = 16_000D;
  WM_GETTEXTLENGTH   = 16_000E;
  WM_PAINT           = 16_000F;
  WM_CLOSE           = 16_0010;
  WM_QUERYENDSESSION = 16_0011;
  WM_QUIT            = 16_0012;
  WM_QUERYOPEN       = 16_0013;
  WM_ERASEBKGND      = 16_0014;
  WM_SYSCOLORCHANGE  = 16_0015;
  WM_ENDSESSION      = 16_0016;
  WM_SHOWWINDOW      = 16_0018;
  WM_WININICHANGE    = 16_001A;
  WM_DEVMODECHANGE   = 16_001B;
  WM_ACTIVATEAPP     = 16_001C;
  WM_FONTCHANGE      = 16_001D;
  WM_TIMECHANGE      = 16_001E;
  WM_CANCELMODE      = 16_001F;
  WM_SETCURSOR       = 16_0020;
  WM_MOUSEACTIVATE   = 16_0021;
  WM_CHILDACTIVATE   = 16_0022;
  WM_QUEUESYNC       = 16_0023;
</PRE><P>
 * Struct pointed to by WM_GETMINMAXINFO lParam
 
<PRE>TYPE
  MINMAXINFO = RECORD
    ptReserved    : POINT;
    ptMaxSize     : POINT;
    ptMaxPosition : POINT;
    ptMinTrackSize: POINT;
    ptMaxTrackSize: POINT;
  END;
  PMINMAXINFO = UNTRACED REF MINMAXINFO;
  LPMINMAXINFO = UNTRACED REF MINMAXINFO;
CONST WM_GETMINMAXINFO = 16_0024;

CONST
  WM_PAINTICON      = 16_0026;
  WM_ICONERASEBKGND = 16_0027;
  WM_NEXTDLGCTL     = 16_0028;
  WM_SPOOLERSTATUS  = 16_002A;
  WM_DRAWITEM       = 16_002B;
  WM_MEASUREITEM    = 16_002C;
  WM_DELETEITEM     = 16_002D;
  WM_VKEYTOITEM     = 16_002E;
  WM_CHARTOITEM     = 16_002F;
  WM_SETFONT        = 16_0030;
  WM_GETFONT        = 16_0031;
  WM_SETHOTKEY      = 16_0032;
  WM_GETHOTKEY      = 16_0033;
  WM_QUERYDRAGICON  = 16_0037;
  WM_COMPAREITEM    = 16_0039;
  WM_FULLSCREEN     = 16_003A;

CONST
  WM_COMPACTING           = 16_0041;
  WM_OTHERWINDOWCREATED   = 16_0042;
  WM_OTHERWINDOWDESTROYED = 16_0043;
  WM_COMMNOTIFY           = 16_0044;
  WM_HOTKEYEVENT          = 16_0045;
  WM_WINDOWPOSCHANGING    = 16_0046;
  WM_WINDOWPOSCHANGED     = 16_0047;
  WM_POWER                = 16_0048;
  WM_COPYDATA             = 16_004A;
TYPE
  COPYDATASTRUCT = RECORD
    dwData: DWORD;
    cbData: DWORD;
    lpData: PVOID;
  END;
  PCOPYDATASTRUCT = UNTRACED REF COPYDATASTRUCT;

CONST
  WM_NCCREATE        = 16_0081;
  WM_NCDESTROY       = 16_0082;
  WM_NCCALCSIZE      = 16_0083;
  WM_NCHITTEST       = 16_0084;
  WM_NCPAINT         = 16_0085;
  WM_NCACTIVATE      = 16_0086;
  WM_GETDLGCODE      = 16_0087;
  WM_NCMOUSEMOVE     = 16_00A0;
  WM_NCLBUTTONDOWN   = 16_00A1;
  WM_NCLBUTTONUP     = 16_00A2;
  WM_NCLBUTTONDBLCLK = 16_00A3;
  WM_NCRBUTTONDOWN   = 16_00A4;
  WM_NCRBUTTONUP     = 16_00A5;
  WM_NCRBUTTONDBLCLK = 16_00A6;
  WM_NCMBUTTONDOWN   = 16_00A7;
  WM_NCMBUTTONUP     = 16_00A8;
  WM_NCMBUTTONDBLCLK = 16_00A9;

  WM_KEYFIRST    = 16_0100;
  WM_KEYDOWN     = 16_0100;
  WM_KEYUP       = 16_0101;
  WM_CHAR        = 16_0102;
  WM_DEADCHAR    = 16_0103;
  WM_SYSKEYDOWN  = 16_0104;
  WM_SYSKEYUP    = 16_0105;
  WM_SYSCHAR     = 16_0106;
  WM_SYSDEADCHAR = 16_0107;
  WM_KEYLAST     = 16_0108;

  WM_INITDIALOG    = 16_0110;
  WM_COMMAND       = 16_0111;
  WM_SYSCOMMAND    = 16_0112;
  WM_TIMER         = 16_0113;
  WM_HSCROLL       = 16_0114;
  WM_VSCROLL       = 16_0115;
  WM_INITMENU      = 16_0116;
  WM_INITMENUPOPUP = 16_0117;
  WM_MENUSELECT    = 16_011F;
  WM_MENUCHAR      = 16_0120;
  WM_ENTERIDLE     = 16_0121;

  WM_CTLCOLORMSGBOX    = 16_0132;
  WM_CTLCOLOREDIT      = 16_0133;
  WM_CTLCOLORLISTBOX   = 16_0134;
  WM_CTLCOLORBTN       = 16_0135;
  WM_CTLCOLORDLG       = 16_0136;
  WM_CTLCOLORSCROLLBAR = 16_0137;
  WM_CTLCOLORSTATIC    = 16_0138;

  WM_MOUSEFIRST    = 16_0200;
  WM_MOUSEMOVE     = 16_0200;
  WM_LBUTTONDOWN   = 16_0201;
  WM_LBUTTONUP     = 16_0202;
  WM_LBUTTONDBLCLK = 16_0203;
  WM_RBUTTONDOWN   = 16_0204;
  WM_RBUTTONUP     = 16_0205;
  WM_RBUTTONDBLCLK = 16_0206;
  WM_MBUTTONDOWN   = 16_0207;
  WM_MBUTTONUP     = 16_0208;
  WM_MBUTTONDBLCLK = 16_0209;
  WM_MOUSELAST     = 16_0209;

  WM_PARENTNOTIFY   = 16_0210;
  WM_ENTERMENULOOP  = 16_0211;
  WM_EXITMENULOOP   = 16_0212;
  WM_MDICREATE      = 16_0220;
  WM_MDIDESTROY     = 16_0221;
  WM_MDIACTIVATE    = 16_0222;
  WM_MDIRESTORE     = 16_0223;
  WM_MDINEXT        = 16_0224;
  WM_MDIMAXIMIZE    = 16_0225;
  WM_MDITILE        = 16_0226;
  WM_MDICASCADE     = 16_0227;
  WM_MDIICONARRANGE = 16_0228;
  WM_MDIGETACTIVE   = 16_0229;
  WM_MDISETMENU     = 16_0230;
  WM_ENTERSIZEMOVE_UNDOCUMENTED = 16_0231;
  WM_EXITSIZEMOVE_UNDOCUMENTED = 16_0232;
  WM_DROPFILES      = 16_0233;
  WM_MDIREFRESHMENU = 16_0234;

  WM_CUT               = 16_0300;
  WM_COPY              = 16_0301;
  WM_PASTE             = 16_0302;
  WM_CLEAR             = 16_0303;
  WM_UNDO              = 16_0304;
  WM_RENDERFORMAT      = 16_0305;
  WM_RENDERALLFORMATS  = 16_0306;
  WM_DESTROYCLIPBOARD  = 16_0307;
  WM_DRAWCLIPBOARD     = 16_0308;
  WM_PAINTCLIPBOARD    = 16_0309;
  WM_VSCROLLCLIPBOARD  = 16_030A;
  WM_SIZECLIPBOARD     = 16_030B;
  WM_ASKCBFORMATNAME   = 16_030C;
  WM_CHANGECBCHAIN     = 16_030D;
  WM_HSCROLLCLIPBOARD  = 16_030E;
  WM_QUERYNEWPALETTE   = 16_030F;
  WM_PALETTEISCHANGING = 16_0310;
  WM_PALETTECHANGED    = 16_0311;
  WM_HOTKEY            = 16_0312;
</PRE> PenWindows specific messages 
<PRE>CONST
  WM_PENWINFIRST = 16_0380;
  WM_PENWINLAST  = 16_038F;

  WM_MM_RESERVED_FIRST = 16_03A0;
  WM_MM_RESERVED_LAST  = 16_03DF;
</PRE> NOTE: All Message Numbers below 16_0400 are RESERVED. 

<P> Private Window Messages Start Here: 
<PRE>CONST WM_USER = 16_0400;
</PRE> WM_SYNCTASK Commands 
<PRE>CONST
  ST_BEGINSWP = 0;
  ST_ENDSWP   = 1;
</PRE> WinWhere() Area Codes 
<PRE>CONST
  HTERROR       = (-2);
  HTTRANSPARENT = (-1);
  HTNOWHERE     = 0;
  HTCLIENT      = 1;
  HTCAPTION     = 2;
  HTSYSMENU     = 3;
  HTGROWBOX     = 4;
  HTSIZE        = HTGROWBOX;
  HTMENU        = 5;
  HTHSCROLL     = 6;
  HTVSCROLL     = 7;
  HTMINBUTTON   = 8;
  HTMAXBUTTON   = 9;
  HTLEFT        = 10;
  HTRIGHT       = 11;
  HTTOP         = 12;
  HTTOPLEFT     = 13;
  HTTOPRIGHT    = 14;
  HTBOTTOM      = 15;
  HTBOTTOMLEFT  = 16;
  HTBOTTOMRIGHT = 17;
  HTBORDER      = 18;
  HTREDUCE      = HTMINBUTTON;
  HTZOOM        = HTMAXBUTTON;
  HTSIZEFIRST   = HTLEFT;
  HTSIZELAST    = HTBOTTOMRIGHT;
</PRE> SendMessageTimeout values 
<PRE>CONST
  SMTO_NORMAL      = 16_0000;
  SMTO_BLOCK       = 16_0001;
  SMTO_ABORTIFHUNG = 16_0002;
</PRE> WM_MOUSEACTIVATE Return Codes 
<PRE>CONST
  MA_ACTIVATE         = 1;
  MA_ACTIVATEANDEAT   = 2;
  MA_NOACTIVATE       = 3;
  MA_NOACTIVATEANDEAT = 4;

&lt;*EXTERNAL RegisterWindowMessageA:WINAPI*&gt;
PROCEDURE RegisterWindowMessageA (lpString: LPCSTR): UINT;

&lt;*EXTERNAL RegisterWindowMessageW:WINAPI*&gt;
PROCEDURE RegisterWindowMessageW (lpString: LPCWSTR): UINT;
CONST RegisterWindowMessage = RegisterWindowMessageA;
</PRE> WM_SIZE message wParam values 
<PRE>CONST
  SIZE_RESTORED  = 0;
  SIZE_MINIMIZED = 1;
  SIZE_MAXIMIZED = 2;
  SIZE_MAXSHOW   = 3;
  SIZE_MAXHIDE   = 4;
</PRE> Obsolete constant names 
<PRE>CONST
  SIZENORMAL     = SIZE_RESTORED;
  SIZEICONIC     = SIZE_MINIMIZED;
  SIZEFULLSCREEN = SIZE_MAXIMIZED;
  SIZEZOOMSHOW   = SIZE_MAXSHOW;
  SIZEZOOMHIDE   = SIZE_MAXHIDE;
</PRE> WM_WINDOWPOSCHANGING/CHANGED struct pointed to by lParam 
<PRE>TYPE
  WINDOWPOS = RECORD
    hwnd           : HWND;
    hwndInsertAfter: HWND;
    x              : int;
    y              : int;
    cx             : int;
    cy             : int;
    flags          : UINT;
  END;
  PWINDOWPOS = UNTRACED REF WINDOWPOS;
  LPWINDOWPOS = UNTRACED REF WINDOWPOS;

  (* WM_NCCALCSIZE parameter structure *)
  NCCALCSIZE_PARAMS = RECORD
    rgrc : ARRAY [0 .. 3 - 1] OF RECT;
    lppos: PWINDOWPOS;
  END;
  LPNCCALCSIZE_PARAMS = UNTRACED REF NCCALCSIZE_PARAMS;
</PRE> WM_NCCALCSIZE <CODE>window valid rect</CODE> return values 
<PRE>CONST
  WVR_ALIGNTOP    = 16_0010;
  WVR_ALIGNLEFT   = 16_0020;
  WVR_ALIGNBOTTOM = 16_0040;
  WVR_ALIGNRIGHT  = 16_0080;
  WVR_HREDRAW     = 16_0100;
  WVR_VREDRAW     = 16_0200;
  WVR_REDRAW      = Or(WVR_HREDRAW, WVR_VREDRAW);
  WVR_VALIDRECTS  = 16_0400;
</PRE> Key State Masks for Mouse Messages 
<PRE>CONST
  MK_LBUTTON = 16_0001;
  MK_RBUTTON = 16_0002;
  MK_SHIFT   = 16_0004;
  MK_CONTROL = 16_0008;
  MK_MBUTTON = 16_0010;
</PRE> Window Styles 
<PRE>CONST
  WS_OVERLAPPED  : LONG = 16_00000000;
  WS_POPUP       : LONG = 16_80000000;
  WS_CHILD       : LONG = 16_40000000;
  WS_MINIMIZE    : LONG = 16_20000000;
  WS_VISIBLE     : LONG = 16_10000000;
  WS_DISABLED    : LONG = 16_08000000;
  WS_CLIPSIBLINGS: LONG = 16_04000000;
  WS_CLIPCHILDREN: LONG = 16_02000000;
  WS_MAXIMIZE    : LONG = 16_01000000;
  WS_CAPTION     : LONG = 16_00C00000; (* WS_BORDER | WS_DLGFRAME *)
  WS_BORDER      : LONG = 16_00800000;
  WS_DLGFRAME    : LONG = 16_00400000;
  WS_VSCROLL     : LONG = 16_00200000;
  WS_HSCROLL     : LONG = 16_00100000;
  WS_SYSMENU     : LONG = 16_00080000;
  WS_THICKFRAME  : LONG = 16_00040000;
  WS_GROUP       : LONG = 16_00020000;
  WS_TABSTOP     : LONG = 16_00010000;

  WS_MINIMIZEBOX: LONG = 16_00020000;
  WS_MAXIMIZEBOX: LONG = 16_00010000;

  WS_TILED       = WS_OVERLAPPED;
  WS_ICONIC      = WS_MINIMIZE;
  WS_SIZEBOX     = WS_THICKFRAME;
  WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;
</PRE> Common Window Styles 
<PRE>CONST
  WS_OVERLAPPEDWINDOW = Or(WS_OVERLAPPED,
                           Or(WS_CAPTION,
                              Or(WS_SYSMENU,
                                 Or(WS_THICKFRAME,
                                    Or(WS_MINIMIZEBOX, WS_MAXIMIZEBOX)))));
  WS_POPUPWINDOW = Or(WS_POPUP, Or(WS_BORDER, WS_SYSMENU));
  WS_CHILDWINDOW = WS_CHILD;
</PRE> Extended Window Styles 
<PRE>CONST
  WS_EX_DLGMODALFRAME : LONG = 16_00000001;
  WS_EX_NOPARENTNOTIFY: LONG = 16_00000004;
  WS_EX_TOPMOST       : LONG = 16_00000008;
  WS_EX_ACCEPTFILES   : LONG = 16_00000010;
  WS_EX_TRANSPARENT   : LONG = 16_00000020;
</PRE> Class styles 
<PRE>CONST
  CS_VREDRAW      = 16_0001;
  CS_HREDRAW      = 16_0002;
  CS_KEYCVTWINDOW = 16_0004;
  CS_DBLCLKS      = 16_0008;
  (* 16_0010 - reserved (see user\server\usersrv.h) *)
  CS_OWNDC           = 16_0020;
  CS_CLASSDC         = 16_0040;
  CS_PARENTDC        = 16_0080;
  CS_NOKEYCVT        = 16_0100;
  CS_NOCLOSE         = 16_0200;
  CS_SAVEBITS        = 16_0800;
  CS_BYTEALIGNCLIENT = 16_1000;
  CS_BYTEALIGNWINDOW = 16_2000;
  CS_GLOBALCLASS     = 16_4000; (* Global window class *)
</PRE> Predefined Clipboard Formats 
<PRE>CONST
  CF_TEXT         = 1;
  CF_BITMAP       = 2;
  CF_METAFILEPICT = 3;
  CF_SYLK         = 4;
  CF_DIF          = 5;
  CF_TIFF         = 6;
  CF_OEMTEXT      = 7;
  CF_DIB          = 8;
  CF_PALETTE      = 9;
  CF_PENDATA      = 10;
  CF_RIFF         = 11;
  CF_WAVE         = 12;
  CF_UNICODETEXT  = 13;
  CF_ENHMETAFILE  = 14;

  CF_OWNERDISPLAY    = 16_0080;
  CF_DSPTEXT         = 16_0081;
  CF_DSPBITMAP       = 16_0082;
  CF_DSPMETAFILEPICT = 16_0083;
  CF_DSPENHMETAFILE  = 16_008E;
</PRE> <CODE>Private</CODE> formats don't get GlobalFree()'d 
<PRE>CONST
  CF_PRIVATEFIRST = 16_0200;
  CF_PRIVATELAST  = 16_02FF;
</PRE> <CODE>GDIOBJ</CODE> formats do get DeleteObject()'d 
<PRE>CONST
  CF_GDIOBJFIRST = 16_0300;
  CF_GDIOBJLAST  = 16_03FF;
</PRE><P>
 * Defines for the fVirt field of the Accelerator table structure.
 
<PRE>CONST
  FNOINVERT = 16_02;
  FSHIFT    = 16_04;
  FCONTROL  = 16_08;
  FALT      = 16_10;

TYPE
  ACCEL = RECORD
    fVirt: BYTE;        (* Also called the flags field *)
    key  : WORD;
    cmd  : WORD;
  END;
  LPACCEL = UNTRACED REF ACCEL;

  PAINTSTRUCT = RECORD
    hdc        : HDC;
    fErase     : BOOL;
    rcPaint    : RECT;
    fRestore   : BOOL;
    fIncUpdate : BOOL;
    rgbReserved: ARRAY [0 .. 32 - 1] OF BYTE;
  END;
  PPAINTSTRUCT = UNTRACED REF PAINTSTRUCT;
  LPPAINTSTRUCT = UNTRACED REF PAINTSTRUCT;

  LPCREATESTRUCTA = UNTRACED REF CREATESTRUCTA;
  CREATESTRUCTA = RECORD
    lpCreateParams: LPVOID;
    hInstance     : HINSTANCE;
    hMenu         : HMENU;
    hwndParent    : HWND;
    cy            : int;
    cx            : int;
    y             : int;
    x             : int;
    style         : LONG;
    lpszName      : LPCSTR;
    lpszClass     : LPCSTR;
    dwExStyle     : DWORD;
  END;

  LPCREATESTRUCTW = CREATESTRUCTW;
  CREATESTRUCTW = RECORD
    hInstance     : HINSTANCE;
    lpCreateParams: LPVOID;
    hMenu         : HMENU;
    hwndParent    : HWND;
    cy            : int;
    cx            : int;
    y             : int;
    x             : int;
    style         : LONG;
    lpszName      : LPCWSTR;
    lpszClass     : LPCWSTR;
    dwExStyle     : DWORD;
  END;

TYPE
  CREATESTRUCT = CREATESTRUCTA;
  LPCREATESTRUCT = LPCREATESTRUCTA;

  PWINDOWPLACEMENT = UNTRACED REF WINDOWPLACEMENT;
  LPWINDOWPLACEMENT = UNTRACED REF WINDOWPLACEMENT;
  WINDOWPLACEMENT = RECORD
    length          : UINT;
    flags           : UINT;
    showCmd         : UINT;
    ptMinPosition   : POINT;
    ptMaxPosition   : POINT;
    rcNormalPosition: RECT;
  END;

CONST
  WPF_SETMINPOSITION     = 16_0001;
  WPF_RESTORETOMAXIMIZED = 16_0002;
</PRE> Owner draw control types 
<PRE>CONST
  ODT_MENU     = 1;
  ODT_LISTBOX  = 2;
  ODT_COMBOBOX = 3;
  ODT_BUTTON   = 4;
</PRE> Owner draw actions 
<PRE>CONST
  ODA_DRAWENTIRE = 16_0001;
  ODA_SELECT     = 16_0002;
  ODA_FOCUS      = 16_0004;
</PRE> Owner draw state 
<PRE>CONST
  ODS_SELECTED = 16_0001;
  ODS_GRAYED   = 16_0002;
  ODS_DISABLED = 16_0004;
  ODS_CHECKED  = 16_0008;
  ODS_FOCUS    = 16_0010;
</PRE> MEASUREITEMSTRUCT for ownerdraw 
<PRE>TYPE
  MEASUREITEMSTRUCT = RECORD
    CtlType   : UINT;
    CtlID     : UINT;
    itemID    : UINT;
    itemWidth : UINT;
    itemHeight: UINT;
    itemData  : DWORD;
  END;

  (* DRAWITEMSTRUCT for ownerdraw *)
  DRAWITEMSTRUCT = RECORD
    CtlType   : UINT;
    CtlID     : UINT;
    itemID    : UINT;
    itemAction: UINT;
    itemState : UINT;
    hwndItem  : HWND;
    hDC       : HDC;
    rcItem    : RECT;
    itemData  : DWORD;
  END;

  (* DELETEITEMSTRUCT for ownerdraw *)
  DELETEITEMSTRUCT = RECORD
    CtlType : UINT;
    CtlID   : UINT;
    itemID  : UINT;
    hwndItem: HWND;
    itemData: UINT;
  END;

  (* COMPAREITEMSTUCT for ownerdraw sorting *)
  COMPAREITEMSTRUCT = RECORD
    CtlType   : UINT;
    CtlID     : UINT;
    hwndItem  : HWND;
    itemID1   : UINT;
    itemData1 : DWORD;
    itemID2   : UINT;
    itemData2 : DWORD;
    dwLocaleId: DWORD;
  END;
</PRE> Message Function Templates 

<P><PRE>&lt;*EXTERNAL GetMessageA:WINAPI*&gt;
PROCEDURE GetMessageA (lpMsg        : LPMSG;
                       hWnd         : HWND;
                       wMsgFilterMin: UINT;
                      wMsgFilterMax: UINT   ): BOOL;
</PRE> Message Function Templates 

<P><PRE>&lt;*EXTERNAL GetMessageW:WINAPI*&gt;
PROCEDURE GetMessageW (lpMsg        : LPMSG;
                       hWnd         : HWND;
                       wMsgFilterMin: UINT;
                       wMsgFilterMax: UINT   ): BOOL;
CONST GetMessage = GetMessageA;

&lt;*EXTERNAL TranslateMessage:WINAPI*&gt;
PROCEDURE TranslateMessage (lpMsg: UNTRACED REF MSG): BOOL;

&lt;*EXTERNAL DispatchMessageA:WINAPI*&gt;
PROCEDURE DispatchMessageA (lpMsg: UNTRACED REF MSG): LONG;

&lt;*EXTERNAL DispatchMessageW:WINAPI*&gt;
PROCEDURE DispatchMessageW (lpMsg: UNTRACED REF MSG): LONG;
CONST DispatchMessage = DispatchMessageA;

&lt;*EXTERNAL PeekMessageA:WINAPI*&gt;
PROCEDURE PeekMessageA (lpMsg        : LPMSG;
                        hWnd         : HWND;
                        wMsgFilterMin: UINT;
                        wMsgFilterMax: UINT;
                        wRemoveMsg   : UINT   ): BOOL;

&lt;*EXTERNAL PeekMessageW:WINAPI*&gt;
PROCEDURE PeekMessageW (lpMsg        : LPMSG;
                        hWnd         : HWND;
                        wMsgFilterMin: UINT;
                        wMsgFilterMax: UINT;
                        wRemoveMsg   : UINT   ): BOOL;
CONST PeekMessage = PeekMessageA;
</PRE> PeekMessage() Options 
<PRE>CONST
  PM_NOREMOVE = 16_0000;
  PM_REMOVE   = 16_0001;
  PM_NOYIELD  = 16_0002;

&lt;*EXTERNAL RegisterHotKey:WINAPI*&gt;
PROCEDURE RegisterHotKey (hwnd       : HWND;
                          id         : int;
                          fsModifiers: UINT;
                          vk         : UINT  ): BOOL;

&lt;*EXTERNAL UnregisterHotKey:WINAPI*&gt;
PROCEDURE UnregisterHotKey (hwnd: HWND; id: int): BOOL;

CONST
  MOD_ALT     = 16_0001;
  MOD_CONTROL = 16_0002;
  MOD_SHIFT   = 16_0004;

  IDHOT_SNAPWINDOW  = (-1);     (* SHIFT-PRINTSCRN *)
  IDHOT_SNAPDESKTOP = (-2);     (* PRINTSCRN *)

CONST
  EWX_LOGOFF   = 0;
  EWX_SHUTDOWN = 1;
  EWX_REBOOT   = 2;
  EWX_FORCE    = 4;

PROCEDURE <A HREF="WinUser.m3#ExitWindows">ExitWindows</A>(dwReserved: UINT; Code: DWORD): BOOL;

&lt;*EXTERNAL ExitWindowsEx:WINAPI*&gt;
PROCEDURE ExitWindowsEx (uFlags: UINT; ForceTimeout: DWORD): BOOL;

&lt;*EXTERNAL SwapMouseButton:WINAPI*&gt;
PROCEDURE SwapMouseButton (arg1: BOOL): BOOL;

&lt;*EXTERNAL GetMessagePos:WINAPI*&gt;
PROCEDURE GetMessagePos (): DWORD;

&lt;*EXTERNAL GetMessageTime:WINAPI*&gt;
PROCEDURE GetMessageTime (): LONG;

&lt;*EXTERNAL GetMessageExtraInfo:WINAPI*&gt;
PROCEDURE GetMessageExtraInfo (): LONG;

&lt;*EXTERNAL SendMessageA:WINAPI*&gt;
PROCEDURE SendMessageA (hWnd  : HWND;
                        Msg   : UINT;
                        wParam: WPARAM;
                        lParam: LPARAM  ): LRESULT;

&lt;*EXTERNAL SendMessageW:WINAPI*&gt;
PROCEDURE SendMessageW (hWnd  : HWND;
                        Msg   : UINT;
                        wParam: WPARAM;
                        lParam: LPARAM  ): LRESULT;
CONST SendMessage = SendMessageA;

&lt;*EXTERNAL SendMessageTimeoutA:WINAPI*&gt;
PROCEDURE SendMessageTimeoutA (hWnd      : HWND;
                               Msg       : UINT;
                               wParam    : WPARAM;
                               lParam    : LPARAM;
                               fuFlags   : UINT;
                               uTimeout  : UINT;
                               lpdwResult: LPDWORD ): LRESULT;

&lt;*EXTERNAL SendMessageTimeoutW:WINAPI*&gt;
PROCEDURE SendMessageTimeoutW (hWnd      : HWND;
                               Msg       : UINT;
                               wParam    : WPARAM;
                               lParam    : LPARAM;
                               fuFlags   : UINT;
                               uTimeout  : UINT;
                               lpdwResult: LPDWORD ): LRESULT;
CONST SendMessageTimeout = SendMessageTimeoutA;

&lt;*EXTERNAL SendNotifyMessageA:WINAPI*&gt;
PROCEDURE SendNotifyMessageA (hwnd  : HWND;
                                Msg   : UINT;
                                wParam: WPARAM;
                                lParam: LPARAM  ): BOOL;

&lt;*EXTERNAL SendNotifyMessageW:WINAPI*&gt;
PROCEDURE SendNotifyMessageW (hwnd  : HWND;
                                Msg   : UINT;
                                wParam: WPARAM;
                                lParam: LPARAM  ): BOOL;
CONST SendNotifyMessage = SendNotifyMessageA;

&lt;*EXTERNAL SendMessageCallbackA:WINAPI*&gt;
PROCEDURE SendMessageCallbackA (hwnd            : HWND;
                                  Msg             : UINT;
                                  wParam          : WPARAM;
                                  lParam          : LPARAM;
                                  lpResultCallBack: SENDASYNCPROC;
                                  dwData          : DWORD          ): BOOL;

&lt;*EXTERNAL SendMessageCallbackW:WINAPI*&gt;
PROCEDURE SendMessageCallbackW (hwnd            : HWND;
                                  Msg             : UINT;
                                  wParam          : WPARAM;
                                  lParam          : LPARAM;
                                  lpResultCallBack: SENDASYNCPROC;
                                  dwData          : DWORD          ): BOOL;
CONST SendMessageCallback = SendMessageCallbackA;

&lt;*EXTERNAL PostMessageA:WINAPI*&gt;
PROCEDURE PostMessageA (hWnd  : HWND;
                        Msg   : UINT;
                        wParam: WPARAM;
                        lParam: LPARAM  ): BOOL;

&lt;*EXTERNAL PostMessageW:WINAPI*&gt;
PROCEDURE PostMessageW (hWnd  : HWND;
                        Msg   : UINT;
                        wParam: WPARAM;
                        lParam: LPARAM  ): BOOL;
CONST PostMessage = PostMessageA;

&lt;*EXTERNAL PostThreadMessageA:WINAPI*&gt;
PROCEDURE PostThreadMessageA (idThread: DWORD;
                              Msg     : UINT;
                              wParam  : WPARAM;
                              lParam  : LPARAM  ): BOOL;

&lt;*EXTERNAL PostThreadMessageW:WINAPI*&gt;
PROCEDURE PostThreadMessageW (idThread: DWORD;
                              Msg     : UINT;
                              wParam  : WPARAM;
                              lParam  : LPARAM  ): BOOL;
CONST PostThreadMessage = PostThreadMessageA;

PROCEDURE <A HREF="WinUser.m3#PostAppMessageA">PostAppMessageA</A> (idThread: DWORD;
                           wMsg    : UINT;
                           wParam  : WPARAM;
                           lParam  : LPARAM  ): BOOL;

PROCEDURE <A HREF="WinUser.m3#PostAppMessageW">PostAppMessageW</A> (idThread: DWORD;
                           wMsg    : UINT;
                           wParam  : WPARAM;
                           lParam  : LPARAM  ): BOOL;

CONST PostAppMessage = PostAppMessageA;
</PRE> Special HWND value for use with PostMessage() and SendMessage() 
<PRE>VAR (* CONST *)
  HWND_BROADCAST: HWND;

&lt;*EXTERNAL AttachThreadInput:WINAPI*&gt;
PROCEDURE AttachThreadInput (idAttach  : DWORD;
                             idAttachTo: DWORD;
                             fAttach   : BOOL   ): BOOL;

&lt;*EXTERNAL ReplyMessage:WINAPI*&gt;
PROCEDURE ReplyMessage (arg1: LRESULT): BOOL;

&lt;*EXTERNAL WaitMessage:WINAPI*&gt;
PROCEDURE WaitMessage (): BOOL;

&lt;*EXTERNAL WaitForInputIdle:WINAPI*&gt;
PROCEDURE WaitForInputIdle (hProcess: HANDLE; dwMilliseconds: DWORD): DWORD;

&lt;*EXTERNAL DefWindowProcA:WINAPI*&gt;
PROCEDURE DefWindowProcA (hWnd  : HWND;
                            Msg   : UINT;
                            wParam: WPARAM;
                            lParam: LPARAM  ): LRESULT;

&lt;*EXTERNAL DefWindowProcW:WINAPI*&gt;
PROCEDURE DefWindowProcW (hWnd  : HWND;
                            Msg   : UINT;
                            wParam: WPARAM;
                            lParam: LPARAM  ): LRESULT;
CONST DefWindowProc = DefWindowProcA;

&lt;*EXTERNAL PostQuitMessage:WINAPI*&gt;
PROCEDURE PostQuitMessage (nExitCode: int);

&lt;*EXTERNAL CallWindowProcA:WINAPI*&gt;
PROCEDURE CallWindowProcA (lpPrevWndFunc: WNDPROC;
                             hWnd         : HWND;
                             Msg          : UINT;
                             wParam       : WPARAM;
                             lParam       : LPARAM   ): LRESULT;

&lt;*EXTERNAL CallWindowProcW:WINAPI*&gt;
PROCEDURE CallWindowProcW (lpPrevWndFunc: WNDPROC;
                             hWnd         : HWND;
                             Msg          : UINT;
                             wParam       : WPARAM;
                             lParam       : LPARAM   ): LRESULT;
CONST CallWindowProc = CallWindowProcA;

&lt;*EXTERNAL InSendMessage:WINAPI*&gt;
PROCEDURE InSendMessage (): BOOL;

&lt;*EXTERNAL GetDoubleClickTime:WINAPI*&gt;
PROCEDURE GetDoubleClickTime (): UINT;

&lt;*EXTERNAL SetDoubleClickTime:WINAPI*&gt;
PROCEDURE SetDoubleClickTime (arg1: UINT): BOOL;

&lt;*EXTERNAL RegisterClassA:WINAPI*&gt;
PROCEDURE RegisterClassA (lpWndClass: UNTRACED REF WNDCLASSA): ATOM;

&lt;*EXTERNAL RegisterClassW:WINAPI*&gt;
PROCEDURE RegisterClassW (lpWndClass: UNTRACED REF WNDCLASSW): ATOM;
CONST RegisterClass = RegisterClassA;

&lt;*EXTERNAL UnregisterClassA:WINAPI*&gt;
PROCEDURE UnregisterClassA (lpClassName: LPCSTR; hInstance: HINSTANCE): BOOL;

&lt;*EXTERNAL UnregisterClassW:WINAPI*&gt;
PROCEDURE UnregisterClassW (lpClassName: LPCWSTR; hInstance: HINSTANCE): BOOL;
CONST UnregisterClass = UnregisterClassA;

&lt;*EXTERNAL GetClassInfoA:WINAPI*&gt;
PROCEDURE GetClassInfoA (hInstance  : HINSTANCE;
                           lpClassName: LPCSTR;
                           lpWndClass : LPWNDCLASSA): BOOL;

&lt;*EXTERNAL GetClassInfoW:WINAPI*&gt;
PROCEDURE GetClassInfoW (hInstance  : HINSTANCE;
                           lpClassName: LPCWSTR;
                           lpWndClass : LPWNDCLASSW): BOOL;
CONST GetClassInfo = GetClassInfoA;

CONST CW_USEDEFAULT = 16_80000000;
</PRE> Special value for CreateWindow, et al. 
<PRE>VAR                             (* CONST *)
  HWND_DESKTOP: HWND;

&lt;*EXTERNAL CreateWindowExA:WINAPI*&gt;
PROCEDURE CreateWindowExA (dwExStyle   : DWORD;
                             lpClassName : LPCSTR;
                             lpWindowName: LPCSTR;
                             dwStyle     : DWORD;
                             X           : int;
                             Y           : int;
                             nWidth      : int;
                             nHeight     : int;
                             hWndParent  : HWND;
                             hMenu       : HMENU;
                             hInstance   : HINSTANCE;
                             lpParam     : LPVOID     ): HWND;

&lt;*EXTERNAL CreateWindowExW:WINAPI*&gt;
PROCEDURE CreateWindowExW (dwExStyle   : DWORD;
                             lpClassName : LPCWSTR;
                             lpWindowName: LPCWSTR;
                             dwStyle     : DWORD;
                             X           : int;
                             Y           : int;
                             nWidth      : int;
                             nHeight     : int;
                             hWndParent  : HWND;
                             hMenu       : HMENU;
                             hInstance   : HINSTANCE;
                             lpParam     : LPVOID     ): HWND;
CONST CreateWindowEx = CreateWindowExA;

PROCEDURE <A HREF="WinUser.m3#CreateWindowA">CreateWindowA</A> (lpClassName : LPCSTR;
                         lpWindowName: LPCSTR;
                         dwStyle     : DWORD;
                         x           : int;
                         y           : int;
                         nWidth      : int;
                         nHeight     : int;
                         hwndParent  : HWND;
                         hMenu       : HMENU;
                         hInstance   : HINSTANCE;
                         lpParam     : LPVOID     ): HWND;

PROCEDURE <A HREF="WinUser.m3#CreateWindowW">CreateWindowW</A> (lpClassName : LPCWSTR;
                         lpWindowName: LPCWSTR;
                         dwStyle     : DWORD;
                         x           : int;
                         y           : int;
                         nWidth      : int;
                         nHeight     : int;
                         hwndParent  : HWND;
                         hMenu       : HMENU;
                         hInstance   : HINSTANCE;
                         lpParam     : LPVOID     ): HWND;

CONST CreateWindow = CreateWindowA;

&lt;*EXTERNAL IsWindow:WINAPI*&gt;
PROCEDURE IsWindow (hWnd: HWND): BOOL;

&lt;*EXTERNAL IsMenu:WINAPI*&gt;
PROCEDURE IsMenu (hMenu: HMENU): BOOL;

&lt;*EXTERNAL IsChild:WINAPI*&gt;
PROCEDURE IsChild (hWndParent: HWND; hWnd: HWND): BOOL;

&lt;*EXTERNAL DestroyWindow:WINAPI*&gt;
PROCEDURE DestroyWindow (hWnd: HWND): BOOL;

&lt;*EXTERNAL ShowWindow:WINAPI*&gt;
PROCEDURE ShowWindow (hWnd: HWND; nCmdShow: int): BOOL;

&lt;*EXTERNAL FlashWindow:WINAPI*&gt;
PROCEDURE FlashWindow (hWnd: HWND; bInvert: BOOL): BOOL;

&lt;*EXTERNAL ShowOwnedPopups:WINAPI*&gt;
PROCEDURE ShowOwnedPopups (hWnd: HWND; fShow: BOOL): BOOL;

&lt;*EXTERNAL OpenIcon:WINAPI*&gt;
PROCEDURE OpenIcon (hWnd: HWND): BOOL;

&lt;*EXTERNAL CloseWindow:WINAPI*&gt;
PROCEDURE CloseWindow (hWnd: HWND): BOOL;

&lt;*EXTERNAL MoveWindow:WINAPI*&gt;
PROCEDURE MoveWindow (hWnd    : HWND;
                      X       : int;
                      Y       : int;
                      nWidth  : int;
                      nHeight : int;
                      bRepaint: BOOL  ): BOOL;

&lt;*EXTERNAL SetWindowPos:WINAPI*&gt;
PROCEDURE SetWindowPos (hWnd           : HWND;
                        hWndInsertAfter: HWND;
                        X              : int;
                        Y              : int;
                        cx             : int;
                        cy             : int;
                        uFlags         : UINT  ): BOOL;

&lt;*EXTERNAL GetWindowPlacement:WINAPI*&gt;
PROCEDURE GetWindowPlacement (hwnd   : HWND;
                              lpwndpl: UNTRACED REF WINDOWPLACEMENT): BOOL;

&lt;*EXTERNAL SetWindowPlacement:WINAPI*&gt;
PROCEDURE SetWindowPlacement (hwnd   : HWND;
                              lpwndpl: UNTRACED REF WINDOWPLACEMENT): BOOL;

&lt;*EXTERNAL BeginDeferWindowPos:WINAPI*&gt;
PROCEDURE BeginDeferWindowPos (nNumWindows: int): HDWP;

&lt;*EXTERNAL DeferWindowPos:WINAPI*&gt;
PROCEDURE DeferWindowPos (hWinPosInfo    : HDWP;
                          hWnd           : HWND;
                          hWndInsertAfter: HWND;
                          x              : int;
                          y              : int;
                          cx             : int;
                          cy             : int;
                          uFlags         : UINT  ): HDWP;

&lt;*EXTERNAL EndDeferWindowPos:WINAPI*&gt;
PROCEDURE EndDeferWindowPos (hWinPosInfo: HDWP): BOOL;

&lt;*EXTERNAL IsWindowVisible:WINAPI*&gt;
PROCEDURE IsWindowVisible (hWnd: HWND): BOOL;

&lt;*EXTERNAL IsIconic:WINAPI*&gt;
PROCEDURE IsIconic (hWnd: HWND): BOOL;

&lt;*EXTERNAL AnyPopup:WINAPI*&gt;
PROCEDURE AnyPopup (): BOOL;

&lt;*EXTERNAL BringWindowToTop:WINAPI*&gt;
PROCEDURE BringWindowToTop (hWnd: HWND): BOOL;

&lt;*EXTERNAL IsZoomed:WINAPI*&gt;
PROCEDURE IsZoomed (hWnd: HWND): BOOL;
</PRE> SetWindowPos Flags 
<PRE>CONST
  SWP_NOSIZE       = 16_0001;
  SWP_NOMOVE       = 16_0002;
  SWP_NOZORDER     = 16_0004;
  SWP_NOREDRAW     = 16_0008;
  SWP_NOACTIVATE   = 16_0010;
  SWP_FRAMECHANGED = 16_0020;   (* The frame changed: send WM_NCCALCSIZE *)
  SWP_SHOWWINDOW   = 16_0040;
  SWP_HIDEWINDOW   = 16_0080;
  SWP_NOCOPYBITS   = 16_0100;
  SWP_NOOWNERZORDER = 16_0200;  (* Don't do owner Z ordering *)

  SWP_DRAWFRAME    = SWP_FRAMECHANGED;
  SWP_NOREPOSITION = SWP_NOOWNERZORDER;

VAR                             (* CONST *)
  HWND_TOP      : HWND;
  HWND_BOTTOM   : HWND;
  HWND_TOPMOST  : HWND;
  HWND_NOTOPMOST: HWND;
</PRE><P>
 * WARNING: * The following structures must NOT be DWORD padded because they are
 * followed by strings, etc that do not have to be DWORD aligned.
 
???  #pragma pack(2)
<P>
   typedef struct { DWORD style; DWORD dwExtendedStyle; WORD cdit; WORD x;
   WORD y; WORD cx; WORD cy; END; typedef DLGTEMPLATE *LPDLGTEMPLATEA;
   typedef DLGTEMPLATE *LPDLGTEMPLATEW; LPDLGTEMPLATE = LPDLGTEMPLATEA;
   typedef CONST DLGTEMPLATE *LPCDLGTEMPLATEA; typedef CONST DLGTEMPLATE
   *LPCDLGTEMPLATEW; LPCDLGTEMPLATE = LPCDLGTEMPLATEA;
<P>
   (* * Dialog item template (dit)  <PRE>typedef struct { DWORD style; DWORD
   dwExtendedStyle; WORD x; WORD y; WORD cx; WORD cy; WORD id; END; typedef
   DLGITEMTEMPLATE *PDLGITEMTEMPLATEA; typedef DLGITEMTEMPLATE
   *PDLGITEMTEMPLATEW; PDLGITEMTEMPLATE = PDLGITEMTEMPLATEA; typedef
   DLGITEMTEMPLATE *LPDLGITEMTEMPLATEA; typedef DLGITEMTEMPLATE
   *LPDLGITEMTEMPLATEW; LPDLGITEMTEMPLATE = LPDLGITEMTEMPLATEA;

   #pragma pack() // Resume normal packing #endif // !RC_INVOKED *)
</PRE><P>
 *??? Some surrogate types while we figure out how to do the above
 
<PRE>TYPE
  LPDLGTEMPLATEA = ADDRESS;
  LPDLGTEMPLATEW = ADDRESS;
  LPDLGTEMPLATE = LPDLGTEMPLATEA;
  LPCDLGTEMPLATEA = ADDRESS;
  LPCDLGTEMPLATEW = ADDRESS;
  LPCDLGTEMPLATE = LPCDLGTEMPLATEA;

&lt;*EXTERNAL CreateDialogParamA:WINAPI*&gt;
PROCEDURE CreateDialogParamA (hInstance     : HINSTANCE;
                                lpTemplateName: LPCSTR;
                                hWndParent    : HWND;
                                lpDialogFunc  : DLGPROC;
                                dwInitParam   : LPARAM     ): HWND;

&lt;*EXTERNAL CreateDialogParamW:WINAPI*&gt;
PROCEDURE CreateDialogParamW (hInstance     : HINSTANCE;
                                lpTemplateName: LPCWSTR;
                                hWndParent    : HWND;
                                lpDialogFunc  : DLGPROC;
                                dwInitParam   : LPARAM     ): HWND;
CONST CreateDialogParam = CreateDialogParamA;

&lt;*EXTERNAL CreateDialogIndirectParamA:WINAPI*&gt;
PROCEDURE CreateDialogIndirectParamA (hInstance   : HINSTANCE;
                                        lpTemplate  : LPCDLGTEMPLATEA;
                                        hwndParent  : HWND;
                                        lpDialogFunc: DLGPROC;
                                        dwInitParam : LPARAM           ): HWND;

&lt;*EXTERNAL CreateDialogIndirectParamW:WINAPI*&gt;
PROCEDURE CreateDialogIndirectParamW (hInstance   : HINSTANCE;
                                        lpTemplate  : LPCDLGTEMPLATEW;
                                        hwndParent  : HWND;
                                        lpDialogFunc: DLGPROC;
                                        dwInitParam : LPARAM           ): HWND;
CONST CreateDialogIndirectParam = CreateDialogIndirectParamA;

PROCEDURE <A HREF="WinUser.m3#CreateDialogA">CreateDialogA</A> (hInstance   : HINSTANCE;
                         lpName      : LPCSTR;
                         hwndParent  : HWND;
                         lpDialogFunc: DLGPROC    ): HWND;

PROCEDURE <A HREF="WinUser.m3#CreateDialogW">CreateDialogW</A> (hInstance   : HINSTANCE;
                         lpName      : LPCWSTR;
                         hwndParent  : HWND;
                         lpDialogFunc: DLGPROC    ): HWND;

CONST CreateDialog = CreateDialogA;

PROCEDURE <A HREF="WinUser.m3#CreateDialogIndirectA">CreateDialogIndirectA</A> (hInstance   : HINSTANCE;
                                 lpTemplate  : LPCDLGTEMPLATEA;
                                 hwndParent  : HWND;
                                 lpDialogFunc: DLGPROC          ): HWND;

PROCEDURE <A HREF="WinUser.m3#CreateDialogIndirectW">CreateDialogIndirectW</A> (hInstance   : HINSTANCE;
                                 lpTemplate  : LPCDLGTEMPLATEW;
                                 hwndParent  : HWND;
                                 lpDialogFunc: DLGPROC          ): HWND;

CONST CreateDialogIndirect = CreateDialogIndirectA;

&lt;*EXTERNAL DialogBoxParamA:WINAPI*&gt;
PROCEDURE DialogBoxParamA (hInstance     : HINSTANCE;
                             lpTemplateName: LPCSTR;
                             hWndParent    : HWND;
                             lpDialogFunc  : DLGPROC;
                             dwInitParam   : LPARAM     ): int;

&lt;*EXTERNAL DialogBoxParamW:WINAPI*&gt;
PROCEDURE DialogBoxParamW (hInstance     : HINSTANCE;
                             lpTemplateName: LPCWSTR;
                             hWndParent    : HWND;
                             lpDialogFunc  : DLGPROC;
                             dwInitParam   : LPARAM     ): int;
CONST DialogBoxParam = DialogBoxParamA;

&lt;*EXTERNAL DialogBoxIndirectParamA:WINAPI*&gt;
PROCEDURE DialogBoxIndirectParamA (hInstance      : HINSTANCE;
                                     hDialogTemplate: LPDLGTEMPLATEA;
                                     hWndParent     : HWND;
                                     lpDialogFunc   : DLGPROC;
                                     dwInitParam    : LPARAM          ): int;

&lt;*EXTERNAL DialogBoxIndirectParamW:WINAPI*&gt;
PROCEDURE DialogBoxIndirectParamW (hInstance      : HINSTANCE;
                                     hDialogTemplate: LPDLGTEMPLATEW;
                                     hWndParent     : HWND;
                                     lpDialogFunc   : DLGPROC;
                                     dwInitParam    : LPARAM          ): int;
CONST DialogBoxIndirectParam = DialogBoxIndirectParamA;

PROCEDURE <A HREF="WinUser.m3#DialogBoxA">DialogBoxA</A>(hInstance     : HINSTANCE;
                             lpTemplateName: LPCSTR;
                             hWndParent    : HWND;
                             lpDialogFunc  : DLGPROC): int;

PROCEDURE <A HREF="WinUser.m3#DialogBoxW">DialogBoxW</A>(hInstance     : HINSTANCE;
                             lpTemplateName: LPCWSTR;
                             hWndParent    : HWND;
                             lpDialogFunc  : DLGPROC): int;

CONST DialogBox = DialogBoxA;

PROCEDURE <A HREF="WinUser.m3#DialogBoxIndirectA">DialogBoxIndirectA</A> (hInstance      : HINSTANCE;
                              hDialogTemplate: LPDLGTEMPLATEA;
                              hWndParent     : HWND;
                              lpDialogFunc   : DLGPROC         ): int;

PROCEDURE <A HREF="WinUser.m3#DialogBoxIndirectW">DialogBoxIndirectW</A> (hInstance      : HINSTANCE;
                              hDialogTemplate: LPDLGTEMPLATEW;
                              hWndParent     : HWND;
                              lpDialogFunc   : DLGPROC         ): int;

CONST DialogBoxIndirect = DialogBoxIndirectA;

&lt;*EXTERNAL EndDialog:WINAPI*&gt;
PROCEDURE EndDialog (hDlg: HWND; nResult: int): BOOL;

&lt;*EXTERNAL GetDlgItem:WINAPI*&gt;
PROCEDURE GetDlgItem (hDlg: HWND; nIDDlgItem: int): HWND;

&lt;*EXTERNAL SetDlgItemInt:WINAPI*&gt;
PROCEDURE SetDlgItemInt (hDlg      : HWND;
                           nIDDlgItem: int;
                           uValue    : UINT;
                           bSigned   : BOOL  ): BOOL;

&lt;*EXTERNAL GetDlgItemInt:WINAPI*&gt;
PROCEDURE GetDlgItemInt (hDlg        : HWND;
                           nIDDlgItem  : int;
                           lpTranslated: UNTRACED REF BOOL;
                           bSigned     : BOOL               ): UINT;

&lt;*EXTERNAL SetDlgItemTextA:WINAPI*&gt;
PROCEDURE SetDlgItemTextA (hDlg: HWND; nIDDlgItem: int; lpString: LPCSTR): BOOL;

&lt;*EXTERNAL SetDlgItemTextW:WINAPI*&gt;
PROCEDURE SetDlgItemTextW (hDlg: HWND; nIDDlgItem: int; lpString: LPCWSTR): BOOL;
CONST SetDlgItemText = SetDlgItemTextA;

&lt;*EXTERNAL GetDlgItemTextA:WINAPI*&gt;
PROCEDURE GetDlgItemTextA (hDlg      : HWND;
                             nIDDlgItem: int;
                             lpString  : LPSTR;
                             nMaxCount : int    ): UINT;

&lt;*EXTERNAL GetDlgItemTextW:WINAPI*&gt;
PROCEDURE GetDlgItemTextW (hDlg      : HWND;
                             nIDDlgItem: int;
                             lpString  : LPWSTR;
                             nMaxCount : int     ): UINT;
CONST GetDlgItemText = GetDlgItemTextA;

&lt;*EXTERNAL CheckDlgButton:WINAPI*&gt;
PROCEDURE CheckDlgButton (hDlg: HWND; nIDButton: int; uCheck: UINT): BOOL;

&lt;*EXTERNAL CheckRadioButton:WINAPI*&gt;
PROCEDURE CheckRadioButton (hDlg          : HWND;
                              nIDFirstButton: int;
                              nIDLastButton : int;
                              nIDCheckButton: int   ): BOOL;

&lt;*EXTERNAL IsDlgButtonChecked:WINAPI*&gt;
PROCEDURE IsDlgButtonChecked (hDlg: HWND; nIDButton: int): UINT;

&lt;*EXTERNAL SendDlgItemMessageA:WINAPI*&gt;
PROCEDURE SendDlgItemMessageA (hDlg      : HWND;
                                 nIDDlgItem: int;
                                 Msg       : UINT;
                                 wParam    : WPARAM;
                                 lParam    : LPARAM  ): LONG;

&lt;*EXTERNAL SendDlgItemMessageW:WINAPI*&gt;
PROCEDURE SendDlgItemMessageW (hDlg      : HWND;
                                 nIDDlgItem: int;
                                 Msg       : UINT;
                                 wParam    : WPARAM;
                                 lParam    : LPARAM  ): LONG;
CONST SendDlgItemMessage = SendDlgItemMessageA;

&lt;*EXTERNAL GetNextDlgGroupItem:WINAPI*&gt;
PROCEDURE GetNextDlgGroupItem (hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND;

&lt;*EXTERNAL GetNextDlgTabItem:WINAPI*&gt;
PROCEDURE GetNextDlgTabItem (hDlg: HWND; hCtl: HWND; bPrevious: BOOL): HWND;

&lt;*EXTERNAL GetDlgCtrlID:WINAPI*&gt;
PROCEDURE GetDlgCtrlID (hWnd: HWND): int;

&lt;*EXTERNAL GetDialogBaseUnits:WINAPI*&gt;
PROCEDURE GetDialogBaseUnits (): long;

&lt;*EXTERNAL DefDlgProcA:WINAPI*&gt;
PROCEDURE DefDlgProcA (hDlg  : HWND;
                       Msg   : UINT;
                       wParam: WPARAM;
                       lParam: LPARAM  ): LRESULT;

&lt;*EXTERNAL DefDlgProcW:WINAPI*&gt;
PROCEDURE DefDlgProcW (hDlg  : HWND;
                       Msg   : UINT;
                       wParam: WPARAM;
                       lParam: LPARAM  ): LRESULT;
CONST DefDlgProc = DefDlgProcA;
</PRE><P>
 * Window extra byted needed for private dialog classes.
 
<PRE>CONST DLGWINDOWEXTRA = 30;

&lt;*EXTERNAL CallMsgFilter:WINAPI*&gt;
PROCEDURE CallMsgFilter (lpMsg: LPMSG; nCode: int): BOOL;
</PRE> Clipboard Manager Functions 

<P><PRE>&lt;*EXTERNAL OpenClipboard:WINAPI*&gt;
PROCEDURE OpenClipboard (hWnd: HWND): BOOL;

&lt;*EXTERNAL CloseClipboard:WINAPI*&gt;
PROCEDURE CloseClipboard (): BOOL;

&lt;*EXTERNAL GetClipboardOwner:WINAPI*&gt;
PROCEDURE GetClipboardOwner (): HWND;

&lt;*EXTERNAL SetClipboardViewer:WINAPI*&gt;
PROCEDURE SetClipboardViewer (arg1: HWND): HWND;

&lt;*EXTERNAL GetClipboardViewer:WINAPI*&gt;
PROCEDURE GetClipboardViewer (): HWND;

&lt;*EXTERNAL ChangeClipboardChain:WINAPI*&gt;
PROCEDURE ChangeClipboardChain (arg1: HWND; arg2: HWND): BOOL;

&lt;*EXTERNAL SetClipboardData:WINAPI*&gt;
PROCEDURE SetClipboardData (uFormat: UINT; hMem: HANDLE): HANDLE;

&lt;*EXTERNAL GetClipboardData:WINAPI*&gt;
PROCEDURE GetClipboardData (uFormat: UINT): HANDLE;

&lt;*EXTERNAL RegisterClipboardFormatA:WINAPI*&gt;
PROCEDURE RegisterClipboardFormatA (arg1: LPCSTR): UINT;

&lt;*EXTERNAL RegisterClipboardFormatW:WINAPI*&gt;
PROCEDURE RegisterClipboardFormatW (arg1: LPCWSTR): UINT;
CONST RegisterClipboardFormat = RegisterClipboardFormatA;

&lt;*EXTERNAL CountClipboardFormats:WINAPI*&gt;
PROCEDURE CountClipboardFormats (): int;

&lt;*EXTERNAL EnumClipboardFormats:WINAPI*&gt;
PROCEDURE EnumClipboardFormats (arg1: UINT): UINT;

&lt;*EXTERNAL GetClipboardFormatNameA:WINAPI*&gt;
PROCEDURE GetClipboardFormatNameA (arg1: UINT; arg2: LPSTR; arg3: int): int;

&lt;*EXTERNAL GetClipboardFormatNameW:WINAPI*&gt;
PROCEDURE GetClipboardFormatNameW (arg1: UINT; arg2: LPWSTR; arg3: int): int;
CONST GetClipboardFormatName = GetClipboardFormatNameA;

&lt;*EXTERNAL EmptyClipboard:WINAPI*&gt;
PROCEDURE EmptyClipboard (): BOOL;

&lt;*EXTERNAL IsClipboardFormatAvailable:WINAPI*&gt;
PROCEDURE IsClipboardFormatAvailable (arg1: UINT): BOOL;

&lt;*EXTERNAL GetPriorityClipboardFormat:WINAPI*&gt;
PROCEDURE GetPriorityClipboardFormat (arg1: UNTRACED REF UINT; arg2: int): int;

&lt;*EXTERNAL GetOpenClipboardWindow:WINAPI*&gt;
PROCEDURE GetOpenClipboardWindow (): HWND;
</PRE> Character Translation Routines 

<P><PRE>&lt;*EXTERNAL CharToOemA:WINAPI*&gt;
PROCEDURE CharToOemA (arg1: LPCSTR; arg2: LPSTR): BOOL;

&lt;*EXTERNAL CharToOemW:WINAPI*&gt;
PROCEDURE CharToOemW (arg1: LPCWSTR; arg2: LPSTR): BOOL;
CONST CharToOem = CharToOemA;

&lt;*EXTERNAL OemToCharA:WINAPI*&gt;
PROCEDURE OemToCharA (arg1: LPCSTR; arg2: LPSTR): BOOL;

&lt;*EXTERNAL OemToCharW:WINAPI*&gt;
PROCEDURE OemToCharW (arg1: LPCSTR; arg2: LPWSTR): BOOL;
CONST OemToChar = OemToCharA;

&lt;*EXTERNAL CharToOemBuffA:WINAPI*&gt;
PROCEDURE CharToOemBuffA (arg1: LPCSTR; arg2: LPSTR; arg3: DWORD): BOOL;

&lt;*EXTERNAL CharToOemBuffW:WINAPI*&gt;
PROCEDURE CharToOemBuffW (arg1: LPCWSTR; arg2: LPSTR; arg3: DWORD): BOOL;
CONST CharToOemBuff = CharToOemBuffA;

&lt;*EXTERNAL OemToCharBuffA:WINAPI*&gt;
PROCEDURE OemToCharBuffA (arg1: LPCSTR; arg2: LPSTR; arg3: DWORD): BOOL;

&lt;*EXTERNAL OemToCharBuffW:WINAPI*&gt;
PROCEDURE OemToCharBuffW (arg1: LPCSTR; arg2: LPWSTR; arg3: DWORD): BOOL;
CONST OemToCharBuff = OemToCharBuffA;

&lt;*EXTERNAL CharUpperA:WINAPI*&gt;
PROCEDURE CharUpperA (arg1: LPSTR): LPSTR;

&lt;*EXTERNAL CharUpperW:WINAPI*&gt;
PROCEDURE CharUpperW (arg1: LPWSTR): LPWSTR;
CONST CharUpper = CharUpperA;

&lt;*EXTERNAL CharUpperBuffA:WINAPI*&gt;
PROCEDURE CharUpperBuffA (arg1: LPSTR; arg2: DWORD): DWORD;

&lt;*EXTERNAL CharUpperBuffW:WINAPI*&gt;
PROCEDURE CharUpperBuffW (arg1: LPWSTR; arg2: DWORD): DWORD;
CONST CharUpperBuff = CharUpperBuffA;

&lt;*EXTERNAL CharLowerA:WINAPI*&gt;
PROCEDURE CharLowerA (arg1: LPSTR): LPSTR;

&lt;*EXTERNAL CharLowerW:WINAPI*&gt;
PROCEDURE CharLowerW (arg1: LPWSTR): LPWSTR;
CONST CharLower = CharLowerA;

&lt;*EXTERNAL CharLowerBuffA:WINAPI*&gt;
PROCEDURE CharLowerBuffA (a1: LPSTR; a2: DWORD): DWORD;

&lt;*EXTERNAL CharLowerBuffW:WINAPI*&gt;
PROCEDURE CharLowerBuffW (a1: LPWSTR; a2: DWORD): DWORD;
CONST CharLowerBuff = CharLowerBuffA;

&lt;*EXTERNAL CharNextA:WINAPI*&gt;
PROCEDURE CharNextA (a1: LPCSTR): LPSTR;

&lt;*EXTERNAL CharNextW:WINAPI*&gt;
PROCEDURE CharNextW (a1: LPCWSTR): LPWSTR;
CONST CharNext = CharNextA;

&lt;*EXTERNAL CharPrevA:WINAPI*&gt;
PROCEDURE CharPrevA (a1: LPCSTR; a2: LPCSTR): LPSTR;

&lt;*EXTERNAL CharPrevW:WINAPI*&gt;
PROCEDURE CharPrevW (a1: LPCWSTR; a2: LPCWSTR): LPWSTR;
CONST CharPrev = CharPrevA;
</PRE><PRE>
      ???
  </PRE>
(* Compatibility defines for character translation routines 
   <PRE>#define AnsiToOem CharToOemA
   #define OemToAnsi OemToCharA
   #define AnsiToOemBuff CharToOemBuffA
   #define OemToAnsiBuff OemToCharBuffA
   #define AnsiUpper CharUpperA
   #define AnsiUpperBuff CharUpperBuffA
   #define AnsiLower CharLowerA
   #define AnsiLowerBuff CharLowerBuffA
   #define AnsiNext CharNextA
   #define AnsiPrev CharPrevA
*)
</PRE> Language dependent Routines 

<P><PRE>&lt;*EXTERNAL IsCharAlphaA:WINAPI*&gt;
PROCEDURE IsCharAlphaA (a1: CHAR): BOOL;

&lt;*EXTERNAL IsCharAlphaW:WINAPI*&gt;
PROCEDURE IsCharAlphaW (a1: WCHAR): BOOL;
CONST IsCharAlpha = IsCharAlphaA;

&lt;*EXTERNAL IsCharAlphaNumericA:WINAPI*&gt;
PROCEDURE IsCharAlphaNumericA (a1: CHAR): BOOL;

&lt;*EXTERNAL IsCharAlphaNumericW:WINAPI*&gt;
PROCEDURE IsCharAlphaNumericW (a1: WCHAR): BOOL;
CONST IsCharAlphaNumeric = IsCharAlphaNumericA;

&lt;*EXTERNAL IsCharUpperA:WINAPI*&gt;
PROCEDURE IsCharUpperA (a1: CHAR): BOOL;

&lt;*EXTERNAL IsCharUpperW:WINAPI*&gt;
PROCEDURE IsCharUpperW (a1: WCHAR): BOOL;
CONST IsCharUpper = IsCharUpperA;

&lt;*EXTERNAL IsCharLowerA:WINAPI*&gt;
PROCEDURE IsCharLowerA (a1: CHAR): BOOL;

&lt;*EXTERNAL IsCharLowerW:WINAPI*&gt;
PROCEDURE IsCharLowerW (a1: WCHAR): BOOL;
CONST IsCharLower = IsCharLowerA;

&lt;*EXTERNAL SetFocus:WINAPI*&gt;
PROCEDURE SetFocus (hWnd: HWND): HWND;

&lt;*EXTERNAL GetActiveWindow:WINAPI*&gt;
PROCEDURE GetActiveWindow (): HWND;

&lt;*EXTERNAL GetFocus:WINAPI*&gt;
PROCEDURE GetFocus (): HWND;

&lt;*EXTERNAL GetKBCodePage:WINAPI*&gt;
PROCEDURE GetKBCodePage (): UINT;

&lt;*EXTERNAL GetKeyState:WINAPI*&gt;
PROCEDURE GetKeyState (nVirtKey: int): SHORT;

&lt;*EXTERNAL GetAsyncKeyState:WINAPI*&gt;
PROCEDURE GetAsyncKeyState (vKey: int): SHORT;

&lt;*EXTERNAL GetKeyboardState:WINAPI*&gt;
PROCEDURE GetKeyboardState (lpKeyState: PBYTE): BOOL;

&lt;*EXTERNAL SetKeyboardState:WINAPI*&gt;
PROCEDURE SetKeyboardState (lpKeyState: LPBYTE): BOOL;

&lt;*EXTERNAL GetKeyNameTextA:WINAPI*&gt;
PROCEDURE GetKeyNameTextA (lParam: LONG; lpString: LPSTR; nSize: int): int;

&lt;*EXTERNAL GetKeyNameTextW:WINAPI*&gt;
PROCEDURE GetKeyNameTextW (lParam: LONG; lpString: LPWSTR; nSize: int): int;
CONST GetKeyNameText = GetKeyNameTextA;

&lt;*EXTERNAL GetKeyboardType:WINAPI*&gt;
PROCEDURE GetKeyboardType (nTypeFlag: int): int;

&lt;*EXTERNAL ToAscii:WINAPI*&gt;
PROCEDURE ToAscii (uVirtKey  : UINT;
                   uScanCode : UINT;
                   lpKeyState: PBYTE;
                   lpChar    : LPWORD;
                   uFlags    : UINT    ): int;

&lt;*EXTERNAL ToUnicode:WINAPI*&gt;
PROCEDURE ToUnicode (wVirtKey  : UINT;
                     wScanCode : UINT;
                     lpKeyState: PBYTE;
                     lpChar    : LPDWORD;
                     wFlags    : UINT     ): int;

&lt;*EXTERNAL VkKeyScanA:WINAPI*&gt;
PROCEDURE VkKeyScanA (cChar: CHAR): SHORT;

&lt;*EXTERNAL VkKeyScanW:WINAPI*&gt;
PROCEDURE VkKeyScanW (cChar: WCHAR): SHORT;

CONST VkKeyScan = VkKeyScanA;

&lt;*EXTERNAL MapVirtualKey:WINAPI*&gt;
PROCEDURE MapVirtualKey (uCode: UINT; uMapType: UINT): UINT;

&lt;*EXTERNAL GetInputState:WINAPI*&gt;
PROCEDURE GetInputState (): BOOL;

&lt;*EXTERNAL GetQueueStatus:WINAPI*&gt;
PROCEDURE GetQueueStatus (flags: UINT): DWORD;

&lt;*EXTERNAL GetCapture:WINAPI*&gt;
PROCEDURE GetCapture (): HWND;

&lt;*EXTERNAL SetCapture:WINAPI*&gt;
PROCEDURE SetCapture (hWnd: HWND): HWND;

&lt;*EXTERNAL ReleaseCapture:WINAPI*&gt;
PROCEDURE ReleaseCapture (): BOOL;

&lt;*EXTERNAL MsgWaitForMultipleObjects:WINAPI*&gt;
PROCEDURE MsgWaitForMultipleObjects (nCount        : DWORD;
                                     pHandles      : LPHANDLE;
                                     fWaitAll      : BOOL;
                                     dwMilliseconds: DWORD;
                                     dwWakeMask    : DWORD     ): DWORD;
</PRE> Queue status flags for GetQueueStatus() and
   MsgWaitForMultipleObjects() 
<PRE>CONST
  QS_KEY         = 16_01;
  QS_MOUSEMOVE   = 16_02;
  QS_MOUSEBUTTON = 16_04;
  QS_MOUSE       = Or(QS_MOUSEMOVE, QS_MOUSEBUTTON);
  QS_POSTMESSAGE = 16_08;
  QS_TIMER       = 16_10;
  QS_PAINT       = 16_20;
  QS_SENDMESSAGE = 16_40;
  QS_HOTKEY      = 16_80;
  QS_INPUT       = Or(QS_MOUSE, QS_KEY);
  QS_ALLEVENTS = Or(QS_INPUT, Or(QS_POSTMESSAGE,
                                 Or(QS_TIMER, Or(QS_PAINT, QS_HOTKEY))));

&lt;*EXTERNAL GetSysInputMode:WINAPI*&gt;
PROCEDURE GetSysInputMode (): UINT;
</PRE> GetSysInputMode return values 
<PRE>CONST
  IMD_NONE             = 0;
  IMD_MENU             = 1;
  IMD_DIALOGBOX        = 2;
  IMD_NEXTWINDOW       = 3;
  IMD_SCROLLBAR        = 4;
  IMD_TITLEBUTTONTRACK = 5;
  IMD_MOVESIZETRACK    = 6;
  IMD_SYSERRDLG        = 7;
  IMD_DRAGOBJECT       = 8;
  IMD_DRAGDETECT       = 9;
</PRE> Windows Functions 
<PRE>&lt;*EXTERNAL SetTimer:WINAPI*&gt;
PROCEDURE SetTimer (hwnd       : HWND;
                    nIDEvent   : UINT;
                    uElapse    : UINT;
                    lpTimerFunc: TIMERPROC): UINT;

&lt;*EXTERNAL KillTimer:WINAPI*&gt;
PROCEDURE KillTimer (hWnd: HWND; uIDEvent: UINT): BOOL;

&lt;*EXTERNAL IsWindowUnicode:WINAPI*&gt;
PROCEDURE IsWindowUnicode (hWnd: HWND): BOOL;

&lt;*EXTERNAL EnableWindow:WINAPI*&gt;
PROCEDURE EnableWindow (hWnd: HWND; bEnable: BOOL): BOOL;

&lt;*EXTERNAL IsWindowEnabled:WINAPI*&gt;
PROCEDURE IsWindowEnabled (hWnd: HWND): BOOL;

&lt;*EXTERNAL LoadAcceleratorsA:WINAPI*&gt;
PROCEDURE LoadAcceleratorsA (hInstance: HINSTANCE; lpTableName: LPCSTR): HACCEL;

&lt;*EXTERNAL LoadAcceleratorsW:WINAPI*&gt;
PROCEDURE LoadAcceleratorsW (hInstance: HINSTANCE; lpTableName: LPCWSTR): HACCEL;

CONST LoadAccelerators = LoadAcceleratorsA;

&lt;*EXTERNAL CreateAcceleratorTable:WINAPI*&gt;
PROCEDURE CreateAcceleratorTable (int: LPACCEL): HACCEL;

&lt;*EXTERNAL DestroyAcceleratorTable:WINAPI*&gt;
PROCEDURE DestroyAcceleratorTable (a1: HACCEL): BOOL;

&lt;*EXTERNAL CopyAcceleratorTable:WINAPI*&gt;
PROCEDURE CopyAcceleratorTable (a1: HACCEL; a2: LPACCEL; a3: int): int;

&lt;*EXTERNAL TranslateAccelerator:WINAPI*&gt;
PROCEDURE TranslateAccelerator (hWnd     : HWND;
                                hAccTable: HACCEL;
                                lpMsg    : LPMSG   ): int;
</PRE> GetSystemMetrics() codes 
<PRE>CONST
  SM_CXSCREEN          = 0;
  SM_CYSCREEN          = 1;
  SM_CXVSCROLL         = 2;
  SM_CYHSCROLL         = 3;
  SM_CYCAPTION         = 4;
  SM_CXBORDER          = 5;
  SM_CYBORDER          = 6;
  SM_CXDLGFRAME        = 7;
  SM_CYDLGFRAME        = 8;
  SM_CYVTHUMB          = 9;
  SM_CXHTHUMB          = 10;
  SM_CXICON            = 11;
  SM_CYICON            = 12;
  SM_CXCURSOR          = 13;
  SM_CYCURSOR          = 14;
  SM_CYMENU            = 15;
  SM_CXFULLSCREEN      = 16;
  SM_CYFULLSCREEN      = 17;
  SM_CYKANJIWINDOW     = 18;
  SM_MOUSEPRESENT      = 19;
  SM_CYVSCROLL         = 20;
  SM_CXHSCROLL         = 21;
  SM_DEBUG             = 22;
  SM_SWAPBUTTON        = 23;
  SM_RESERVED1         = 24;
  SM_RESERVED2         = 25;
  SM_RESERVED3         = 26;
  SM_RESERVED4         = 27;
  SM_CXMIN             = 28;
  SM_CYMIN             = 29;
  SM_CXSIZE            = 30;
  SM_CYSIZE            = 31;
  SM_CXFRAME           = 32;
  SM_CYFRAME           = 33;
  SM_CXMINTRACK        = 34;
  SM_CYMINTRACK        = 35;
  SM_CXDOUBLECLK       = 36;
  SM_CYDOUBLECLK       = 37;
  SM_CXICONSPACING     = 38;
  SM_CYICONSPACING     = 39;
  SM_MENUDROPALIGNMENT = 40;
  SM_PENWINDOWS        = 41;
  SM_DBCSENABLED       = 42;
  SM_CMOUSEBUTTONS     = 43;
  SM_MAX               = 43;
  SM_CMETRICS          = 44;

&lt;*EXTERNAL GetSystemMetrics:WINAPI*&gt;
PROCEDURE GetSystemMetrics (nIndex: int): int;

&lt;*EXTERNAL LoadMenuA:WINAPI*&gt;
PROCEDURE LoadMenuA (hInstance: HINSTANCE; lpMenuName: LPCSTR): HMENU;

&lt;*EXTERNAL LoadMenuW:WINAPI*&gt;
PROCEDURE LoadMenuW (hInstance: HINSTANCE; lpMenuName: LPCWSTR): HMENU;
CONST LoadMenu = LoadMenuA;

&lt;*EXTERNAL LoadMenuIndirectA:WINAPI*&gt;
PROCEDURE LoadMenuIndirectA (lpMenuTemplate: LPMENUTEMPLATE): HMENU;

&lt;*EXTERNAL LoadMenuIndirectW:WINAPI*&gt;
PROCEDURE LoadMenuIndirectW (lpMenuTemplate: LPMENUTEMPLATE): HMENU;
CONST LoadMenuIndirect = LoadMenuIndirectA;

&lt;*EXTERNAL GetMenu:WINAPI*&gt;
PROCEDURE GetMenu (hWnd: HWND): HMENU;

&lt;*EXTERNAL SetMenu:WINAPI*&gt;
PROCEDURE SetMenu (hWnd: HWND; hMenu: HMENU): BOOL;

&lt;*EXTERNAL ChangeMenuA:WINAPI*&gt;
PROCEDURE ChangeMenuA (a1: HMENU;
                       a2: UINT;
                       a3: LPCTSTR;
                       a4: UINT;
                       a5: UINT     ): BOOL;

&lt;*EXTERNAL ChangeMenuW:WINAPI*&gt;
PROCEDURE ChangeMenuW (a1: HMENU;
                       a2: UINT;
                       a3: LPCTSTR;
                       a4: UINT;
                       a5: UINT     ): BOOL;
CONST ChangeMenu = ChangeMenuA;

&lt;*EXTERNAL HiliteMenuItem:WINAPI*&gt;
PROCEDURE HiliteMenuItem (hWnd         : HWND;
                          hMenu        : HMENU;
                          uIDHiliteItem: UINT;
                          uHilite      : UINT   ): BOOL;

&lt;*EXTERNAL GetMenuStringA:WINAPI*&gt;
PROCEDURE GetMenuStringA (hMenu    : HMENU;
                          uIDItem  : UINT;
                          lpString : LPSTR;
                          nMaxCount: int;
                          uFlag    : UINT   ): int;

&lt;*EXTERNAL GetMenuStringW:WINAPI*&gt;
PROCEDURE GetMenuStringW (hMenu    : HMENU;
                            uIDItem  : UINT;
                            lpString : LPWSTR;
                            nMaxCount: int;
                            uFlag    : UINT    ): int;
CONST GetMenuString = GetMenuStringA;

&lt;*EXTERNAL GetMenuState:WINAPI*&gt;
PROCEDURE GetMenuState (hMenu: HMENU; uId: UINT; uFlags: UINT): UINT;

&lt;*EXTERNAL DrawMenuBar:WINAPI*&gt;
PROCEDURE DrawMenuBar (hWnd: HWND): BOOL;

&lt;*EXTERNAL GetSystemMenu:WINAPI*&gt;
PROCEDURE GetSystemMenu (hWnd: HWND; bRevert: BOOL): HMENU;

&lt;*EXTERNAL CreateMenu:WINAPI*&gt;
PROCEDURE CreateMenu (): HMENU;

&lt;*EXTERNAL CreatePopupMenu:WINAPI*&gt;
PROCEDURE CreatePopupMenu (): HMENU;

&lt;*EXTERNAL DestroyMenu:WINAPI*&gt;
PROCEDURE DestroyMenu (hMenu: HMENU): BOOL;

&lt;*EXTERNAL CheckMenuItem:WINAPI*&gt;
PROCEDURE CheckMenuItem (hMenu: HMENU; uIDCheckItem: UINT; uCheck: UINT): BOOL;

&lt;*EXTERNAL EnableMenuItem:WINAPI*&gt;
PROCEDURE EnableMenuItem (hMenu        : HMENU;
                            uIDEnableItem: UINT;
                            uEnable      : UINT   ): BOOL;

&lt;*EXTERNAL GetSubMenu:WINAPI*&gt;
PROCEDURE GetSubMenu (hMenu: HMENU; nPos: int): HMENU;

&lt;*EXTERNAL GetMenuItemID:WINAPI*&gt;
PROCEDURE GetMenuItemID (hMenu: HMENU; nPos: int): UINT;

&lt;*EXTERNAL GetMenuItemCount:WINAPI*&gt;
PROCEDURE GetMenuItemCount (hMenu: HMENU): int;

&lt;*EXTERNAL InsertMenuA:WINAPI*&gt;
PROCEDURE InsertMenuA (hMenu     : HMENU;
                         uPosition : UINT;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCSTR ): BOOL;

&lt;*EXTERNAL InsertMenuW:WINAPI*&gt;
PROCEDURE InsertMenuW (hMenu     : HMENU;
                         uPosition : UINT;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCWSTR): BOOL;
CONST InsertMenu = InsertMenuA;

&lt;*EXTERNAL AppendMenuA:WINAPI*&gt;
PROCEDURE AppendMenuA (hMenu     : HMENU;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCSTR ): BOOL;

&lt;*EXTERNAL AppendMenuW:WINAPI*&gt;
PROCEDURE AppendMenuW (hMenu     : HMENU;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCWSTR): BOOL;
CONST AppendMenu = AppendMenuA;

&lt;*EXTERNAL ModifyMenuA:WINAPI*&gt;
PROCEDURE ModifyMenuA (hMnu      : HMENU;
                         uPosition : UINT;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCSTR ): BOOL;

&lt;*EXTERNAL ModifyMenuW:WINAPI*&gt;
PROCEDURE ModifyMenuW (hMnu      : HMENU;
                         uPosition : UINT;
                         uFlags    : UINT;
                         uIDNewItem: UINT;
                         lpNewItem : LPCWSTR): BOOL;
CONST ModifyMenu = ModifyMenuA;

&lt;*EXTERNAL RemoveMenu:WINAPI*&gt;
PROCEDURE RemoveMenu (hMenu: HMENU; uPosition: UINT; uFlags: UINT): BOOL;

&lt;*EXTERNAL DeleteMenu:WINAPI*&gt;
PROCEDURE DeleteMenu (hMenu: HMENU; uPosition: UINT; uFlags: UINT): BOOL;

&lt;*EXTERNAL SetMenuItemBitmaps:WINAPI*&gt;
PROCEDURE SetMenuItemBitmaps (hMenu           : HMENU;
                                uPosition       : UINT;
                                uFlags          : UINT;
                                hBitmapUnchecked: HBITMAP;
                                hBitmapChecked  : HBITMAP  ): BOOL;

&lt;*EXTERNAL GetMenuCheckMarkDimensions:WINAPI*&gt;
PROCEDURE GetMenuCheckMarkDimensions (): LONG;

&lt;*EXTERNAL TrackPopupMenu:WINAPI*&gt;
PROCEDURE TrackPopupMenu (hMenu    : HMENU;
                            uFlags   : UINT;
                            x        : int;
                            y        : int;
                            nReserved: int;
                            hWnd     : HWND;
                            prcRect  : LPRECT): BOOL;
</PRE> Flags for TrackPopupMenu 
<PRE>CONST
  TPM_LEFTBUTTON : LONG = 16_0000;
  TPM_RIGHTBUTTON: LONG = 16_0002;
  TPM_LEFTALIGN  : LONG = 16_0000;
  TPM_CENTERALIGN: LONG = 16_0004;
  TPM_RIGHTALIGN : LONG = 16_0008;

&lt;*EXTERNAL DrawIcon:WINAPI*&gt;
PROCEDURE DrawIcon (a1: HDC; a2: int; a3: int; a4: HICON): BOOL;
</PRE> DrawText() Format Flags 
<PRE>CONST
  DT_TOP             = 16_0000;
  DT_LEFT            = 16_0000;
  DT_CENTER          = 16_0001;
  DT_RIGHT           = 16_0002;
  DT_VCENTER         = 16_0004;
  DT_BOTTOM          = 16_0008;
  DT_WORDBREAK       = 16_0010;
  DT_SINGLELINE      = 16_0020;
  DT_EXPANDTABS      = 16_0040;
  DT_TABSTOP         = 16_0080;
  DT_NOCLIP          = 16_0100;
  DT_EXTERNALLEADING = 16_0200;
  DT_CALCRECT        = 16_0400;
  DT_NOPREFIX        = 16_0800;
  DT_INTERNAL        = 16_1000;

&lt;*EXTERNAL DrawTextA:WINAPI*&gt;
PROCEDURE DrawTextA (hDC     : HDC;
                     lpString: LPCSTR;
                     nCount  : int;
                     lpRect  : LPRECT;
                     uFormat : UINT    ): int;

&lt;*EXTERNAL DrawTextW:WINAPI*&gt;
PROCEDURE DrawTextW (hDC     : HDC;
                     lpString: LPCWSTR;
                     nCount  : int;
                     lpRect  : LPRECT;
                     uFormat : UINT     ): int;
CONST DrawText = DrawTextA;

&lt;*EXTERNAL GrayStringA:WINAPI*&gt;
PROCEDURE GrayStringA (hDC         : HDC;
                         hBrush      : HBRUSH;
                         lpOutputFunc: GRAYSTRINGPROC;
                         lpData      : LPARAM;
                         nCount      : int;
                         X           : int;
                         Y           : int;
                         nWidth      : int;
                         nHeight     : int             ): BOOL;

&lt;*EXTERNAL GrayStringW:WINAPI*&gt;
PROCEDURE GrayStringW (hDC         : HDC;
                         hBrush      : HBRUSH;
                         lpOutputFunc: GRAYSTRINGPROC;
                         lpData      : LPARAM;
                         nCount      : int;
                         X           : int;
                         Y           : int;
                         nWidth      : int;
                         nHeight     : int             ): BOOL;
CONST GrayString = GrayStringA;

&lt;*EXTERNAL TabbedTextOutA:WINAPI*&gt;
PROCEDURE TabbedTextOutA (hDC                : HDC;
                            X                  : int;
                            Y                  : int;
                            lpString           : LPCSTR;
                            nCount             : int;
                            nTabPositions      : int;
                            lpnTabStopPositions: LPINT;
                            nTabOrigin         : int     ): LONG;

&lt;*EXTERNAL TabbedTextOutW:WINAPI*&gt;
PROCEDURE TabbedTextOutW (hDC                : HDC;
                            X                  : int;
                            Y                  : int;
                            lpString           : LPCWSTR;
                            nCount             : int;
                            nTabPositions      : int;
                            lpnTabStopPositions: LPINT;
                            nTabOrigin         : int      ): LONG;
CONST TabbedTextOut = TabbedTextOutA;

&lt;*EXTERNAL GetTabbedTextExtentA:WINAPI*&gt;
PROCEDURE GetTabbedTextExtentA (hDC                : HDC;
                                  lpString           : LPCSTR;
                                  nCount             : int;
                                  nTabPositions      : int;
                                  lpnTabStopPositions: LPINT   ): DWORD;

&lt;*EXTERNAL GetTabbedTextExtentW:WINAPI*&gt;
PROCEDURE GetTabbedTextExtentW (hDC                : HDC;
                                  lpString           : LPCWSTR;
                                  nCount             : int;
                                  nTabPositions      : int;
                                  lpnTabStopPositions: LPINT    ): DWORD;
CONST GetTabbedTextExtent = GetTabbedTextExtentA;

&lt;*EXTERNAL UpdateWindow:WINAPI*&gt;
PROCEDURE UpdateWindow (hWnd: HWND): BOOL;

&lt;*EXTERNAL SetActiveWindow:WINAPI*&gt;
PROCEDURE SetActiveWindow (hWnd: HWND): HWND;

&lt;*EXTERNAL GetForegroundWindow:WINAPI*&gt;
PROCEDURE GetForegroundWindow (): HWND;

&lt;*EXTERNAL SetForegroundWindow:WINAPI*&gt;
PROCEDURE SetForegroundWindow (hWnd: HWND): BOOL;

&lt;*EXTERNAL WindowFromDC:WINAPI*&gt;
PROCEDURE WindowFromDC (hdc: HDC): HWND;

&lt;*EXTERNAL GetDC:WINAPI*&gt;
PROCEDURE GetDC (hWnd: HWND): HDC;

&lt;*EXTERNAL GetDCEx:WINAPI*&gt;
PROCEDURE GetDCEx (hwnd: HWND; hrgnClip: HRGN; flags: DWORD): HDC;
</PRE> GetDCEx() flags 
<PRE>CONST
  DCX_WINDOW      : LONG = 16_00000001;
  DCX_CACHE       : LONG = 16_00000002;
  DCX_NORESETATTRS: LONG = 16_00000004;
  DCX_CLIPCHILDREN: LONG = 16_00000008;
  DCX_CLIPSIBLINGS: LONG = 16_00000010;
  DCX_PARENTCLIP  : LONG = 16_00000020;

  DCX_EXCLUDERGN  : LONG = 16_00000040;
  DCX_INTERSECTRGN: LONG = 16_00000080;

  DCX_EXCLUDEUPDATE  : LONG = 16_00000100;
  DCX_INTERSECTUPDATE: LONG = 16_00000200;

  DCX_LOCKWINDOWUPDATE: LONG = 16_00000400;

  DCX_USESTYLE   : LONG = 16_00010000;
  DCX_NORECOMPUTE: LONG = 16_00100000;
  DCX_VALIDATE   : LONG = 16_00200000;

&lt;*EXTERNAL GetWindowDC:WINAPI*&gt;
PROCEDURE GetWindowDC (hWnd: HWND): HDC;

&lt;*EXTERNAL ReleaseDC:WINAPI*&gt;
PROCEDURE ReleaseDC (hWnd: HWND; hDC: HDC): int;

&lt;*EXTERNAL BeginPaint:WINAPI*&gt;
PROCEDURE BeginPaint (hWnd: HWND; lpPaint: LPPAINTSTRUCT): HDC;

&lt;*EXTERNAL EndPaint:WINAPI*&gt;
PROCEDURE EndPaint (hWnd: HWND; lpPaint: UNTRACED REF PAINTSTRUCT): BOOL;

&lt;*EXTERNAL GetUpdateRect:WINAPI*&gt;
PROCEDURE GetUpdateRect (hWnd: HWND; lpRect: LPRECT; bErase: BOOL): BOOL;

&lt;*EXTERNAL GetUpdateRgn:WINAPI*&gt;
PROCEDURE GetUpdateRgn (hWnd: HWND; hRgn: HRGN; bErase: BOOL): int;

&lt;*EXTERNAL ExcludeUpdateRgn:WINAPI*&gt;
PROCEDURE ExcludeUpdateRgn (hDC: HDC; hWnd: HWND): int;

&lt;*EXTERNAL InvalidateRect:WINAPI*&gt;
PROCEDURE InvalidateRect (hWnd  : HWND;
                            lpRect: LPRECT;
                            bErase: BOOL               ): BOOL;

&lt;*EXTERNAL ValidateRect:WINAPI*&gt;
PROCEDURE ValidateRect (hWnd: HWND; lpRect: LPRECT): BOOL;

&lt;*EXTERNAL InvalidateRgn:WINAPI*&gt;
PROCEDURE InvalidateRgn (hWnd: HWND; hRgn: HRGN; bErase: BOOL): BOOL;

&lt;*EXTERNAL ValidateRgn:WINAPI*&gt;
PROCEDURE ValidateRgn (hWnd: HWND; hRgn: HRGN): BOOL;

&lt;*EXTERNAL RedrawWindow:WINAPI*&gt;
PROCEDURE RedrawWindow (hwnd      : HWND;
                          lprcUpdate: LPRECT;
                          hrgnUpdate: HRGN;
                          flags     : UINT               ): BOOL;
</PRE> RedrawWindow() flags 
<PRE>CONST
  RDW_INVALIDATE    = 16_0001;
  RDW_INTERNALPAINT = 16_0002;
  RDW_ERASE         = 16_0004;

  RDW_VALIDATE        = 16_0008;
  RDW_NOINTERNALPAINT = 16_0010;
  RDW_NOERASE         = 16_0020;

  RDW_NOCHILDREN  = 16_0040;
  RDW_ALLCHILDREN = 16_0080;

  RDW_UPDATENOW = 16_0100;
  RDW_ERASENOW  = 16_0200;
</PRE> LockWindowUpdate API 
<PRE>&lt;*EXTERNAL LockWindowUpdate:WINAPI*&gt;
PROCEDURE LockWindowUpdate (hwndLock: HWND): BOOL;

&lt;*EXTERNAL ScrollWindow:WINAPI*&gt;
PROCEDURE ScrollWindow (hWnd      : HWND;
                          XAmount   : int;
                          YAmount   : int;
                          lpRect    : LPRECT;
                          lpClipRect: LPRECT  ): BOOL;

&lt;*EXTERNAL ScrollDC:WINAPI*&gt;
PROCEDURE ScrollDC (hDC       : HDC;
                      dx        : int;
                      dy        : int;
                      lprcScroll: LPRECT;
                      lprcClip  : LPRECT;
                      hrgnUpdate: HRGN;
                      lprcUpdate: LPRECT             ): BOOL;

&lt;*EXTERNAL ScrollWindowEx:WINAPI*&gt;
PROCEDURE ScrollWindowEx (hwnd      : HWND;
                            dx        : int;
                            dy        : int;
                            prcScroll : LPRECT;
                            prcClip   : LPRECT;
                            hrgnUpdate: HRGN;
                            prcUpdate : LPRECT;
                            flags     : UINT               ): int;

CONST
  SW_SCROLLCHILDREN = 16_0001;  (* Scroll children within *lprcScroll. *)
  SW_INVALIDATE     = 16_0002;  (* Invalidate after scrolling *)
  SW_ERASE = 16_0004;           (* If SW_INVALIDATE, don't send
                                   WM_ERASEBACKGROUND *)

&lt;*EXTERNAL SetScrollPos:WINAPI*&gt;
PROCEDURE SetScrollPos (hWnd: HWND; nBar: int; nPos: int; bRedraw: BOOL): int;

&lt;*EXTERNAL GetScrollPos:WINAPI*&gt;
PROCEDURE GetScrollPos (hWnd: HWND; nBar: int): int;

&lt;*EXTERNAL SetScrollRange:WINAPI*&gt;
PROCEDURE SetScrollRange (hWnd   : HWND;
                            nBar   : int;
                            nMinPos: int;
                            nMaxPos: int;
                            bRedraw: BOOL  ): BOOL;

&lt;*EXTERNAL GetScrollRange:WINAPI*&gt;
PROCEDURE GetScrollRange (hWnd    : HWND;
                            nBar    : int;
                            lpMinPos: LPINT;
                            lpMaxPos: LPINT  ): BOOL;

&lt;*EXTERNAL ShowScrollBar:WINAPI*&gt;
PROCEDURE ShowScrollBar (hWnd: HWND; wBar: int; bShow: BOOL): BOOL;

&lt;*EXTERNAL EnableScrollBar:WINAPI*&gt;
PROCEDURE EnableScrollBar (hwnd: HWND; wSBflags: UINT; wArrows: UINT): BOOL;
</PRE> EnableScrollBar() flags 
<PRE>CONST
  ESB_ENABLE_BOTH  = 16_0000;
  ESB_DISABLE_BOTH = 16_0003;

  ESB_DISABLE_LEFT  = 16_0001;
  ESB_DISABLE_RIGHT = 16_0002;

  ESB_DISABLE_UP   = 16_0001;
  ESB_DISABLE_DOWN = 16_0002;

  ESB_DISABLE_LTUP = ESB_DISABLE_LEFT;
  ESB_DISABLE_RTDN = ESB_DISABLE_RIGHT;

&lt;*EXTERNAL SetPropA:WINAPI*&gt;
PROCEDURE SetPropA (hWnd: HWND; lpString: LPCSTR; hData: HANDLE): BOOL;

&lt;*EXTERNAL SetPropW:WINAPI*&gt;
PROCEDURE SetPropW (hWnd: HWND; lpString: LPCWSTR; hData: HANDLE): BOOL;
CONST SetProp = SetPropA;

&lt;*EXTERNAL GetPropA:WINAPI*&gt;
PROCEDURE GetPropA (hWnd: HWND; lpString: LPCSTR): HANDLE;

&lt;*EXTERNAL GetPropW:WINAPI*&gt;
PROCEDURE GetPropW (hWnd: HWND; lpString: LPCWSTR): HANDLE;
CONST GetProp = GetPropA;

&lt;*EXTERNAL RemovePropA:WINAPI*&gt;
PROCEDURE RemovePropA (hWnd: HWND; lpString: LPCSTR): HANDLE;

&lt;*EXTERNAL RemovePropW:WINAPI*&gt;
PROCEDURE RemovePropW (hWnd: HWND; lpString: LPCWSTR): HANDLE;
CONST RemoveProp = RemovePropA;

&lt;*EXTERNAL EnumPropsExA:WINAPI*&gt;
PROCEDURE EnumPropsExA (hWnd      : HWND;
                          lpEnumFunc: PROPENUMPROC;
                          lParam    : LPARAM        ): int;

&lt;*EXTERNAL EnumPropsExW:WINAPI*&gt;
PROCEDURE EnumPropsExW (hWnd      : HWND;
                          lpEnumFunc: PROPENUMPROC;
                          lParam    : LPARAM        ): int;
CONST EnumPropsEx = EnumPropsExA;

&lt;*EXTERNAL EnumPropsA:WINAPI*&gt;
PROCEDURE EnumPropsA (hWnd: HWND; lpEnumFunc: PROPENUMPROC): int;

&lt;*EXTERNAL EnumPropsW:WINAPI*&gt;
PROCEDURE EnumPropsW (hWnd: HWND; lpEnumFunc: PROPENUMPROC): int;
CONST EnumProps = EnumPropsA;

&lt;*EXTERNAL SetWindowTextA:WINAPI*&gt;
PROCEDURE SetWindowTextA (hWnd: HWND; lpString: LPCSTR): BOOL;

&lt;*EXTERNAL SetWindowTextW:WINAPI*&gt;
PROCEDURE SetWindowTextW (hWnd: HWND; lpString: LPCWSTR): BOOL;
CONST SetWindowText = SetWindowTextA;

&lt;*EXTERNAL GetWindowTextA:WINAPI*&gt;
PROCEDURE GetWindowTextA (hWnd: HWND; lpString: LPSTR; nMaxCount: int): int;

&lt;*EXTERNAL GetWindowTextW:WINAPI*&gt;
PROCEDURE GetWindowTextW (hWnd: HWND; lpString: LPWSTR; nMaxCount: int): int;
CONST GetWindowText = GetWindowTextA;

&lt;*EXTERNAL GetWindowTextLengthA:WINAPI*&gt;
PROCEDURE GetWindowTextLengthA (hWnd: HWND): int;

&lt;*EXTERNAL GetWindowTextLengthW:WINAPI*&gt;
PROCEDURE GetWindowTextLengthW (hWnd: HWND): int;
CONST GetWindowTextLength = GetWindowTextLengthA;

&lt;*EXTERNAL GetClientRect:WINAPI*&gt;
PROCEDURE GetClientRect (hWnd: HWND; lpRect: LPRECT): BOOL;

&lt;*EXTERNAL GetWindowRect:WINAPI*&gt;
PROCEDURE GetWindowRect (hWnd: HWND; lpRect: LPRECT): BOOL;

&lt;*EXTERNAL AdjustWindowRect:WINAPI*&gt;
PROCEDURE AdjustWindowRect (lpRect: LPRECT; dwStyle: DWORD; bMenu: BOOL): BOOL;

&lt;*EXTERNAL AdjustWindowRectEx:WINAPI*&gt;
PROCEDURE AdjustWindowRectEx (lpRect   : LPRECT;
                                dwStyle  : DWORD;
                                bMenu    : BOOL;
                                dwExStyle: DWORD   ): BOOL;
</PRE> MessageBox() Flags 
<PRE>CONST
  MB_OK              : LONG = 16_0000;
  MB_OKCANCEL        : LONG = 16_0001;
  MB_ABORTRETRYIGNORE: LONG = 16_0002;
  MB_YESNOCANCEL     : LONG = 16_0003;
  MB_YESNO           : LONG = 16_0004;
  MB_RETRYCANCEL     : LONG = 16_0005;

  MB_ICONHAND       : LONG = 16_0010;
  MB_ICONQUESTION   : LONG = 16_0020;
  MB_ICONEXCLAMATION: LONG = 16_0030;
  MB_ICONASTERISK   : LONG = 16_0040;

  MB_ICONINFORMATION = MB_ICONASTERISK;
  MB_ICONSTOP        = MB_ICONHAND;

  MB_DEFBUTTON1: LONG = 16_0000;
  MB_DEFBUTTON2: LONG = 16_0100;
  MB_DEFBUTTON3: LONG = 16_0200;

  MB_APPLMODAL  : LONG = 16_0000;
  MB_SYSTEMMODAL: LONG = 16_1000;
  MB_TASKMODAL  : LONG = 16_2000;

  MB_NOFOCUS             : LONG = 16_8000;
  MB_SETFOREGROUND       : LONG = 16_10000;
  MB_DEFAULT_DESKTOP_ONLY: LONG = 16_20000;

  MB_TYPEMASK: LONG = 16_000F;
  MB_ICONMASK: LONG = 16_00F0;
  MB_DEFMASK : LONG = 16_0F00;
  MB_MODEMASK: LONG = 16_3000;
  MB_MISCMASK: LONG = 16_C000;

&lt;*EXTERNAL MessageBoxExA:WINAPI*&gt;
PROCEDURE MessageBoxExA (hWnd       : HWND;
                           lpText     : LPCSTR;
                           lpCaption  : LPCSTR;
                           uType      : UINT;
                           wLanguageId: WORD    ): int;

&lt;*EXTERNAL MessageBoxExW:WINAPI*&gt;
PROCEDURE MessageBoxExW (hWnd       : HWND;
                           lpText     : LPCWSTR;
                           lpCaption  : LPCWSTR;
                           uType      : UINT;
                           wLanguageId: WORD     ): int;
CONST MessageBoxEx = MessageBoxExA;

PROCEDURE <A HREF="WinUser.m3#MessageBoxA">MessageBoxA</A> (hWnd     : HWND;
                       lpText   : LPCSTR;
                       lpCaption: LPCSTR;
                       uType    : UINT    ): int;

PROCEDURE <A HREF="WinUser.m3#MessageBoxW">MessageBoxW</A> (hWnd     : HWND;
                       lpText   : LPCWSTR;
                       lpCaption: LPCWSTR;
                       uType    : UINT     ): int;

CONST MessageBox = MessageBoxA;

&lt;*EXTERNAL MessageBeep:WINAPI*&gt;
PROCEDURE MessageBeep (uType: UINT): BOOL;

&lt;*EXTERNAL ShowCursor:WINAPI*&gt;
PROCEDURE ShowCursor (bShow: BOOL): int;

&lt;*EXTERNAL SetCursorPos:WINAPI*&gt;
PROCEDURE SetCursorPos (X: int; Y: int): BOOL;

&lt;*EXTERNAL SetCursor:WINAPI*&gt;
PROCEDURE SetCursor (hCursor: HCURSOR): HCURSOR;

&lt;*EXTERNAL GetCursorPos:WINAPI*&gt;
PROCEDURE GetCursorPos (lpPoint: LPPOINT): BOOL;

&lt;*EXTERNAL ClipCursor:WINAPI*&gt;
PROCEDURE ClipCursor (lpRect: LPRECT): BOOL;

&lt;*EXTERNAL GetClipCursor:WINAPI*&gt;
PROCEDURE GetClipCursor (lpRect: LPRECT): BOOL;

&lt;*EXTERNAL GetCursor:WINAPI*&gt;
PROCEDURE GetCursor (): HCURSOR;

&lt;*EXTERNAL CreateCaret:WINAPI*&gt;
PROCEDURE CreateCaret (hWnd   : HWND;
                       hBitmap: HBITMAP;
                       nWidth : int;
                       nHeight: int      ): BOOL;

&lt;*EXTERNAL GetCaretBlinkTime:WINAPI*&gt;
PROCEDURE GetCaretBlinkTime (): UINT;

&lt;*EXTERNAL SetCaretBlinkTime:WINAPI*&gt;
PROCEDURE SetCaretBlinkTime (uMSeconds: UINT): BOOL;

&lt;*EXTERNAL DestroyCaret:WINAPI*&gt;
PROCEDURE DestroyCaret (): BOOL;

&lt;*EXTERNAL HideCaret:WINAPI*&gt;
PROCEDURE HideCaret (hWnd: HWND): BOOL;

&lt;*EXTERNAL ShowCaret:WINAPI*&gt;
PROCEDURE ShowCaret (hWnd: HWND): BOOL;

&lt;*EXTERNAL SetCaretPos:WINAPI*&gt;
PROCEDURE SetCaretPos (X: int; Y: int): BOOL;

&lt;*EXTERNAL GetCaretPos:WINAPI*&gt;
PROCEDURE GetCaretPos (lpPoint: LPPOINT): BOOL;

&lt;*EXTERNAL ClientToScreen:WINAPI*&gt;
PROCEDURE ClientToScreen (hWnd: HWND; lpPoint: LPPOINT): BOOL;

&lt;*EXTERNAL ScreenToClient:WINAPI*&gt;
PROCEDURE ScreenToClient (hWnd: HWND; lpPoint: LPPOINT): BOOL;

&lt;*EXTERNAL MapWindowPoints:WINAPI*&gt;
PROCEDURE MapWindowPoints (hWndFrom: HWND;
                             hWndTo  : HWND;
                             lpPoints: LPPOINT;
                             cPoints : UINT     ): int;

&lt;*EXTERNAL WindowFromPoint:WINAPI*&gt;
PROCEDURE WindowFromPoint (Point: POINT): HWND;

&lt;*EXTERNAL ChildWindowFromPoint:WINAPI*&gt;
PROCEDURE ChildWindowFromPoint (hWndParent: HWND; Point: POINT): HWND;
</PRE> Color Types 
<PRE>CONST
  CTLCOLOR_MSGBOX    = 0;
  CTLCOLOR_EDIT      = 1;
  CTLCOLOR_LISTBOX   = 2;
  CTLCOLOR_BTN       = 3;
  CTLCOLOR_DLG       = 4;
  CTLCOLOR_SCROLLBAR = 5;
  CTLCOLOR_STATIC    = 6;
  CTLCOLOR_MAX       = 8;       (* three bits max *)

  COLOR_SCROLLBAR           = 0;
  COLOR_BACKGROUND          = 1;
  COLOR_ACTIVECAPTION       = 2;
  COLOR_INACTIVECAPTION     = 3;
  COLOR_MENU                = 4;
  COLOR_WINDOW              = 5;
  COLOR_WINDOWFRAME         = 6;
  COLOR_MENUTEXT            = 7;
  COLOR_WINDOWTEXT          = 8;
  COLOR_CAPTIONTEXT         = 9;
  COLOR_ACTIVEBORDER        = 10;
  COLOR_INACTIVEBORDER      = 11;
  COLOR_APPWORKSPACE        = 12;
  COLOR_HIGHLIGHT           = 13;
  COLOR_HIGHLIGHTTEXT       = 14;
  COLOR_BTNFACE             = 15;
  COLOR_BTNSHADOW           = 16;
  COLOR_GRAYTEXT            = 17;
  COLOR_BTNTEXT             = 18;
  COLOR_INACTIVECAPTIONTEXT = 19;
  COLOR_BTNHIGHLIGHT        = 20;
  COLOR_ENDCOLORS           = COLOR_BTNHIGHLIGHT;
  COLOR_MAX                 = 20;

&lt;*EXTERNAL GetSysColor:WINAPI*&gt;
PROCEDURE GetSysColor (nIndex: int): DWORD;

&lt;*EXTERNAL SetSysColors:WINAPI*&gt;
PROCEDURE SetSysColors (a1: int;
                          a2: UNTRACED REF INT;
                          a3: UNTRACED REF COLORREF): BOOL;

&lt;*EXTERNAL DrawFocusRect:WINAPI*&gt;
PROCEDURE DrawFocusRect (a1: HDC; a2: LPRECT): BOOL;

&lt;*EXTERNAL FillRect:WINAPI*&gt;
PROCEDURE FillRect (hdc: HDC; lprc: LPRECT; hbr: HBRUSH): int;

&lt;*EXTERNAL FrameRect:WINAPI*&gt;
PROCEDURE FrameRect (hdc: HDC; lprc: LPRECT; hbr: HBRUSH): int;

&lt;*EXTERNAL InvertRect:WINAPI*&gt;
PROCEDURE InvertRect (hdc: HDC; lprc: LPRECT): BOOL;

&lt;*EXTERNAL SetRect:WINAPI*&gt;
PROCEDURE SetRect (a1: LPRECT; a2: int; a3: int; a4: int; a5: int): BOOL;

&lt;*EXTERNAL SetRectEmpty:WINAPI*&gt;
PROCEDURE SetRectEmpty (a1: LPRECT): BOOL;

&lt;*EXTERNAL CopyRect:WINAPI*&gt;
PROCEDURE CopyRect (a1: LPRECT; a2: LPRECT): int;

&lt;*EXTERNAL InflateRect:WINAPI*&gt;
PROCEDURE InflateRect (a1: LPRECT; a2: int; a3: int): BOOL;

&lt;*EXTERNAL IntersectRect:WINAPI*&gt;
PROCEDURE IntersectRect (a1: LPRECT;
                           a2: LPRECT;
                           a3: LPRECT  ): int;

&lt;*EXTERNAL UnionRect:WINAPI*&gt;
PROCEDURE UnionRect (a1: LPRECT;
                       a2: LPRECT;
                       a3: LPRECT  ): BOOL;

&lt;*EXTERNAL SubtractRect:WINAPI*&gt;
PROCEDURE SubtractRect (a1: LPRECT;
                          a2: LPRECT;
                          a3: LPRECT  ): BOOL;

&lt;*EXTERNAL OffsetRect:WINAPI*&gt;
PROCEDURE OffsetRect (a1: LPRECT; a2: int; a3: int): BOOL;

&lt;*EXTERNAL IsRectEmpty:WINAPI*&gt;
PROCEDURE IsRectEmpty (lprc: LPRECT): BOOL;

&lt;*EXTERNAL EqualRect:WINAPI*&gt;
PROCEDURE EqualRect (a1: LPRECT; a2: LPRECT): BOOL;

&lt;*EXTERNAL PtInRect:WINAPI*&gt;
PROCEDURE PtInRect (a1: LPRECT; a2: POINT): BOOL;

&lt;*EXTERNAL GetWindowWord:WINAPI*&gt;
PROCEDURE GetWindowWord (hWnd: HWND; nIndex: int): WORD;

&lt;*EXTERNAL SetWindowWord:WINAPI*&gt;
PROCEDURE SetWindowWord (hWnd: HWND; nIndex: int; wNewWord: WORD): WORD;

&lt;*EXTERNAL GetWindowLongA:WINAPI*&gt;
PROCEDURE GetWindowLongA (hWnd: HWND; nIndex: int): LONG;

&lt;*EXTERNAL GetWindowLongW:WINAPI*&gt;
PROCEDURE GetWindowLongW (hWnd: HWND; nIndex: int): LONG;
CONST GetWindowLong = GetWindowLongA;

&lt;*EXTERNAL SetWindowLongA:WINAPI*&gt;
PROCEDURE SetWindowLongA (hWnd: HWND; nIndex: int; dwNewLong: LONG): LONG;

&lt;*EXTERNAL SetWindowLongW:WINAPI*&gt;
PROCEDURE SetWindowLongW (hWnd: HWND; nIndex: int; dwNewLong: LONG): LONG;
CONST SetWindowLong = SetWindowLongA;

&lt;*EXTERNAL GetClassWord:WINAPI*&gt;
PROCEDURE GetClassWord (hWnd: HWND; nIndex: int): WORD;

&lt;*EXTERNAL SetClassWord:WINAPI*&gt;
PROCEDURE SetClassWord (hWnd: HWND; nIndex: int; wNewWord: WORD): WORD;

&lt;*EXTERNAL GetClassLongA:WINAPI*&gt;
PROCEDURE GetClassLongA (hWnd: HWND; nIndex: int): DWORD;

&lt;*EXTERNAL GetClassLongW:WINAPI*&gt;
PROCEDURE GetClassLongW (hWnd: HWND; nIndex: int): DWORD;
CONST GetClassLong = GetClassLongA;

&lt;*EXTERNAL SetClassLongA:WINAPI*&gt;
PROCEDURE SetClassLongA (hWnd: HWND; nIndex: int; dwNewLong: LONG): DWORD;

&lt;*EXTERNAL SetClassLongW:WINAPI*&gt;
PROCEDURE SetClassLongW (hWnd: HWND; nIndex: int; dwNewLong: LONG): DWORD;
CONST SetClassLong = SetClassLongA;

&lt;*EXTERNAL GetDesktopWindow:WINAPI*&gt;
PROCEDURE GetDesktopWindow (): HWND;

&lt;*EXTERNAL SetDeskWallpaper:WINAPI*&gt;
PROCEDURE SetDeskWallpaper (lpString: LPCSTR): BOOL;

&lt;*EXTERNAL GetParent:WINAPI*&gt;
PROCEDURE GetParent (hWnd: HWND): HWND;

&lt;*EXTERNAL SetParent:WINAPI*&gt;
PROCEDURE SetParent (hWndChild: HWND; hWndNewParent: HWND): HWND;

&lt;*EXTERNAL EnumChildWindows:WINAPI*&gt;
PROCEDURE EnumChildWindows (hWndParent: HWND;
                              lpEnumFunc: WNDENUMPROC;
                              lParam    : LPARAM       ): BOOL;

&lt;*EXTERNAL FindWindowA:WINAPI*&gt;
PROCEDURE FindWindowA (lpClassName: LPCSTR; lpWindowName: LPCSTR): HWND;

&lt;*EXTERNAL FindWindowW:WINAPI*&gt;
PROCEDURE FindWindowW (lpClassName: LPCWSTR; lpWindowName: LPCWSTR): HWND;
CONST FindWindow = FindWindowA;

&lt;*EXTERNAL EnumWindows:WINAPI*&gt;
PROCEDURE EnumWindows (lpEnumFunc: WNDENUMPROC; lParam: LPARAM): BOOL;

&lt;*EXTERNAL EnumThreadWindows:WINAPI*&gt;
PROCEDURE EnumThreadWindows (dwThreadId: DWORD;
                               lpfn      : WNDENUMPROC;
                               lParam    : LPARAM       ): BOOL;

PROCEDURE <A HREF="WinUser.m3#EnumTaskWindows">EnumTaskWindows</A> (dwThreadId: DWORD;
                           lpfn      : WNDENUMPROC;
                           lParam    : LPARAM       ): BOOL;

&lt;*EXTERNAL GetClassNameA:WINAPI*&gt;
PROCEDURE GetClassNameA (hWnd: HWND; lpClassName: LPSTR; nMaxCount: int): int;

&lt;*EXTERNAL GetClassNameW:WINAPI*&gt;
PROCEDURE GetClassNameW (hWnd: HWND; lpClassName: LPWSTR; nMaxCount: int): int;
CONST GetClassName = GetClassNameA;

&lt;*EXTERNAL GetTopWindow:WINAPI*&gt;
PROCEDURE GetTopWindow (hWnd: HWND): HWND;

PROCEDURE <A HREF="WinUser.m3#GetNextWindow">GetNextWindow</A>(hWnd: HWND; uCmd: UINT):HWND;

&lt;*EXTERNAL GetWindowThreadProcessId:WINAPI*&gt;
PROCEDURE GetWindowThreadProcessId (hWnd: HWND; lpdwProcessId: LPDWORD): DWORD;

&lt;*EXTERNAL GetLastActivePopup:WINAPI*&gt;
PROCEDURE GetLastActivePopup (hWnd: HWND): HWND;
</PRE> GetWindow() Constants 
<PRE>CONST
  GW_HWNDFIRST = 0;
  GW_HWNDLAST  = 1;
  GW_HWNDNEXT  = 2;
  GW_HWNDPREV  = 3;
  GW_OWNER     = 4;
  GW_CHILD     = 5;
  GW_MAX       = 5;

&lt;*EXTERNAL GetWindow:WINAPI*&gt;
PROCEDURE GetWindow (hWnd: HWND; uCmd: UINT): HWND;

&lt;*EXTERNAL SetWindowsHookA:WINAPI*&gt;
PROCEDURE SetWindowsHookA (nFilterType: int; pfnFilterProc: HOOKPROC): HHOOK;

&lt;*EXTERNAL SetWindowsHookW:WINAPI*&gt;
PROCEDURE SetWindowsHookW (nFilterType: int; fnFilterProc: HOOKPROC): HHOOK;
CONST SetWindowsHook = SetWindowsHookA;

&lt;*EXTERNAL UnhookWindowsHook:WINAPI*&gt;
PROCEDURE UnhookWindowsHook (nCode: int; pfnFilterProc: HOOKPROC): BOOL;

&lt;*EXTERNAL SetWindowsHookExA:WINAPI*&gt;
PROCEDURE SetWindowsHookExA (idHook    : int;
                               lpfn      : HOOKPROC;
                               hmod      : HINSTANCE;
                               dwThreadId: DWORD      ): HHOOK;

&lt;*EXTERNAL SetWindowsHookExW:WINAPI*&gt;
PROCEDURE SetWindowsHookExW (idHook    : int;
                               lpfn      : HOOKPROC;
                               hmod      : HINSTANCE;
                               dwThreadId: DWORD      ): HHOOK;
CONST SetWindowsHookEx = SetWindowsHookExA;

&lt;*EXTERNAL UnhookWindowsHookEx:WINAPI*&gt;
PROCEDURE UnhookWindowsHookEx (hhk: HHOOK): BOOL;

&lt;*EXTERNAL CallNextHookEx:WINAPI*&gt;
PROCEDURE CallNextHookEx (hhk   : HHOOK;
                            nCode : int;
                            wParam: WPARAM;
                            lParam: LPARAM  ): LRESULT;
</PRE><P>
 * Macros for source-level compatibility with old functions.
 

<P><PRE>PROCEDURE <A HREF="WinUser.m3#DefHookProc">DefHookProc</A> (nCode : int;
                       wParam: WPARAM;
                       lParam: LPARAM;
                       phhk  : UNTRACED REF HHOOK): LRESULT;
</PRE> Menu flags for Add/Check/EnableMenuItem() 
<PRE>CONST
  MF_INSERT: LONG = 16_00000000;
  MF_CHANGE: LONG = 16_00000080;
  MF_APPEND: LONG = 16_00000100;
  MF_DELETE: LONG = 16_00000200;
  MF_REMOVE: LONG = 16_00001000;

  MF_BYCOMMAND : LONG = 16_00000000;
  MF_BYPOSITION: LONG = 16_00000400;

  MF_SEPARATOR: LONG = 16_00000800;

  MF_ENABLED : LONG = 16_00000000;
  MF_GRAYED  : LONG = 16_00000001;
  MF_DISABLED: LONG = 16_00000002;

  MF_UNCHECKED      : LONG = 16_00000000;
  MF_CHECKED        : LONG = 16_00000008;
  MF_USECHECKBITMAPS: LONG = 16_00000200;

  MF_STRING   : LONG = 16_00000000;
  MF_BITMAP   : LONG = 16_00000004;
  MF_OWNERDRAW: LONG = 16_00000100;

  MF_POPUP       : LONG = 16_00000010;
  MF_MENUBARBREAK: LONG = 16_00000020;
  MF_MENUBREAK   : LONG = 16_00000040;

  MF_UNHILITE: LONG = 16_00000000;
  MF_HILITE  : LONG = 16_00000080;

  MF_SYSMENU    : LONG = 16_00002000;
  MF_HELP       : LONG = 16_00004000;
  MF_MOUSESELECT: LONG = 16_00008000;
</PRE> Menu item resource format 
<PRE>TYPE
  MENUITEMTEMPLATEHEADER = RECORD
                             versionNumber: WORD;
                             offset       : WORD;
  END;

  MENUITEMTEMPLATE = RECORD
                       mtOption: WORD;
                       mtID    : WORD;
                       mtString: ARRAY [0 .. 1 - 1] OF char;
  END;

CONST MF_END: LONG = 16_00000080;
</PRE> System Menu Command Values 
<PRE>CONST
  SC_SIZE       = 16_F000;
  SC_MOVE       = 16_F010;
  SC_MINIMIZE   = 16_F020;
  SC_MAXIMIZE   = 16_F030;
  SC_NEXTWINDOW = 16_F040;
  SC_PREVWINDOW = 16_F050;
  SC_CLOSE      = 16_F060;
  SC_VSCROLL    = 16_F070;
  SC_HSCROLL    = 16_F080;
  SC_MOUSEMENU  = 16_F090;
  SC_KEYMENU    = 16_F100;
  SC_ARRANGE    = 16_F110;
  SC_RESTORE    = 16_F120;
  SC_TASKLIST   = 16_F130;
  SC_SCREENSAVE = 16_F140;
  SC_HOTKEY     = 16_F150;
</PRE> Obsolete names 
<PRE>CONST
  SC_ICON = SC_MINIMIZE;
  SC_ZOOM = SC_MAXIMIZE;
</PRE> Resource Loading Routines 

<P><PRE>&lt;*EXTERNAL LoadBitmapA:WINAPI*&gt;
PROCEDURE LoadBitmapA (hInstance: HINSTANCE; lpBitmapName: LPCSTR): HBITMAP;

&lt;*EXTERNAL LoadBitmapW:WINAPI*&gt;
PROCEDURE LoadBitmapW (hInstance: HINSTANCE; lpBitmapName: LPCWSTR): HBITMAP;
CONST LoadBitmap = LoadBitmapA;

&lt;*EXTERNAL LoadCursorA:WINAPI*&gt;
PROCEDURE LoadCursorA (hInstance: HINSTANCE; lpCursorName: LPCSTR): HCURSOR;

&lt;*EXTERNAL LoadCursorW:WINAPI*&gt;
PROCEDURE LoadCursorW (hInstance: HINSTANCE; lpCursorName: LPCWSTR): HCURSOR;
CONST LoadCursor = LoadCursorA;

&lt;*EXTERNAL CreateCursor:WINAPI*&gt;
PROCEDURE CreateCursor (a1: HINSTANCE;
                        a2: int;
                        a3: int;
                        a4: int;
                        a5: int;
                        a6: void_star;
                        a7: void_star  ): HCURSOR;

&lt;*EXTERNAL DestroyCursor:WINAPI*&gt;
PROCEDURE DestroyCursor (a1: HCURSOR): BOOL;
</PRE> Standard Cursor IDs 
<PRE>VAR                             (* CONST *)
  IDC_ARROW      : LPTSTR;
  IDC_IBEAM      : LPTSTR;
  IDC_WAIT       : LPTSTR;
  IDC_CROSS      : LPTSTR;
  IDC_UPARROW    : LPTSTR;
  IDC_SIZE       : LPTSTR;
  IDC_ICON       : LPTSTR;
  IDC_SIZENWSE   : LPTSTR;
  IDC_SIZENESW   : LPTSTR;
  IDC_SIZEWE     : LPTSTR;
  IDC_SIZENS     : LPTSTR;
  IDC_SIZEALL    : LPTSTR;      (* not in win3.1 *)
  IDC_NO         : LPTSTR;      (* not in win3.1 *)
  IDC_APPSTARTING: LPTSTR;      (* not in win3.1 *)

TYPE
  ICONINFO = RECORD
               fIcon   : BOOL;
    xHotspot: DWORD;
    yHotspot: DWORD;
    hbmMask : HBITMAP;
    hbmColor: HBITMAP;
  END;
  PICONINFO = UNTRACED REF PICONINFO;

&lt;*EXTERNAL LoadIconA:WINAPI*&gt;
PROCEDURE LoadIconA (hInstance: HINSTANCE; lpIconName: LPCSTR): HICON;

&lt;*EXTERNAL LoadIconW:WINAPI*&gt;
PROCEDURE LoadIconW (hInstance: HINSTANCE; lpIconName: LPCWSTR): HICON;
CONST LoadIcon = LoadIconA;

&lt;*EXTERNAL CreateIcon:WINAPI*&gt;
PROCEDURE CreateIcon (a1: HINSTANCE;
                      a2: int;
                      a3: int;
                      a4: BYTE;
                      a5: BYTE;
                      a6: UNTRACED REF BYTE;
                      a7: UNTRACED REF BYTE  ): HICON;

&lt;*EXTERNAL DestroyIcon:WINAPI*&gt;
PROCEDURE DestroyIcon (a1: HICON): BOOL;

&lt;*EXTERNAL LookupIconIdFromDirectory:WINAPI*&gt;
PROCEDURE LookupIconIdFromDirectory (presbits: PBYTE; fIcon: BOOL): int;

&lt;*EXTERNAL CreateIconFromResource:WINAPI*&gt;
PROCEDURE CreateIconFromResource (presbits : PBYTE;
                                  dwResSize: DWORD;
                                  fIcon    : BOOL;
                                  dwVer    : DWORD  ): HICON;

&lt;*EXTERNAL CreateIconIndirect:WINAPI*&gt;
PROCEDURE CreateIconIndirect (piconinfo: PICONINFO): HICON;

&lt;*EXTERNAL CopyIcon:WINAPI*&gt;
PROCEDURE CopyIcon (a1: HICON): HICON;

&lt;*EXTERNAL GetIconInfo:WINAPI*&gt;
PROCEDURE GetIconInfo (hIcon: HICON; piconinfo: PICONINFO): BOOL;
</PRE> OEM Resource Ordinal Numbers 
<PRE>CONST
  OBM_CLOSE    = 32754;
  OBM_UPARROW  = 32753;
  OBM_DNARROW  = 32752;
  OBM_RGARROW  = 32751;
  OBM_LFARROW  = 32750;
  OBM_REDUCE   = 32749;
  OBM_ZOOM     = 32748;
  OBM_RESTORE  = 32747;
  OBM_REDUCED  = 32746;
  OBM_ZOOMD    = 32745;
  OBM_RESTORED = 32744;
  OBM_UPARROWD = 32743;
  OBM_DNARROWD = 32742;
  OBM_RGARROWD = 32741;
  OBM_LFARROWD = 32740;
  OBM_MNARROW  = 32739;
  OBM_COMBO    = 32738;
  OBM_UPARROWI = 32737;
  OBM_DNARROWI = 32736;
  OBM_RGARROWI = 32735;
  OBM_LFARROWI = 32734;

  OBM_OLD_CLOSE   = 32767;
  OBM_SIZE        = 32766;
  OBM_OLD_UPARROW = 32765;
  OBM_OLD_DNARROW = 32764;
  OBM_OLD_RGARROW = 32763;
  OBM_OLD_LFARROW = 32762;
  OBM_BTSIZE      = 32761;
  OBM_CHECK       = 32760;
  OBM_CHECKBOXES  = 32759;
  OBM_BTNCORNERS  = 32758;
  OBM_OLD_REDUCE  = 32757;
  OBM_OLD_ZOOM    = 32756;
  OBM_OLD_RESTORE = 32755;

  OCR_NORMAL   = 32512;
  OCR_IBEAM    = 32513;
  OCR_WAIT     = 32514;
  OCR_CROSS    = 32515;
  OCR_UP       = 32516;
  OCR_SIZE     = 32640;
  OCR_ICON     = 32641;
  OCR_SIZENWSE = 32642;
  OCR_SIZENESW = 32643;
  OCR_SIZEWE   = 32644;
  OCR_SIZENS   = 32645;
  OCR_SIZEALL  = 32646;
  OCR_ICOCUR   = 32647;
  OCR_NO       = 32648;         (* not in win3.1 *)

  OIC_SAMPLE = 32512;
  OIC_HAND   = 32513;
  OIC_QUES   = 32514;
  OIC_BANG   = 32515;
  OIC_NOTE   = 32516;

CONST
  ORD_LANGDRIVER = 1;           (* The ordinal number for the entry point
                                   of ** language drivers. *)
</PRE> Standard Icon IDs 
<PRE>VAR                             (* CONST *)
  IDI_APPLICATION: LPTSTR;
  IDI_HAND       : LPTSTR;
  IDI_QUESTION   : LPTSTR;
  IDI_EXCLAMATION: LPTSTR;
  IDI_ASTERISK   : LPTSTR;

&lt;*EXTERNAL LoadStringA:WINAPI*&gt;
PROCEDURE LoadStringA (hInstance : HINSTANCE;
                         uID       : UINT;
                         lpBuffer  : LPSTR;
                         nBufferMax: int        ): int;

&lt;*EXTERNAL LoadStringW:WINAPI*&gt;
PROCEDURE LoadStringW (hInstance : HINSTANCE;
                         uID       : UINT;
                         lpBuffer  : LPWSTR;
                         nBufferMax: int        ): int;
CONST LoadString = LoadStringA;
</PRE> Dialog Box Command IDs 
<PRE>CONST
  IDOK     = 1;
  IDCANCEL = 2;
  IDABORT  = 3;
  IDRETRY  = 4;
  IDIGNORE = 5;
  IDYES    = 6;
  IDNO     = 7;
</PRE> Control Manager Structures and Definitions 

<P> Edit Control Styles 
<PRE>CONST
  ES_LEFT       : LONG = 16_0000;
  ES_CENTER     : LONG = 16_0001;
  ES_RIGHT      : LONG = 16_0002;
  ES_MULTILINE  : LONG = 16_0004;
  ES_UPPERCASE  : LONG = 16_0008;
  ES_LOWERCASE  : LONG = 16_0010;
  ES_PASSWORD   : LONG = 16_0020;
  ES_AUTOVSCROLL: LONG = 16_0040;
  ES_AUTOHSCROLL: LONG = 16_0080;
  ES_NOHIDESEL  : LONG = 16_0100;
  ES_OEMCONVERT : LONG = 16_0400;
  ES_READONLY   : LONG = 16_0800;
  ES_WANTRETURN : LONG = 16_1000;
</PRE> Edit Control Notification Codes 
<PRE>CONST
  EN_SETFOCUS  = 16_0100;
  EN_KILLFOCUS = 16_0200;
  EN_CHANGE    = 16_0300;
  EN_UPDATE    = 16_0400;
  EN_ERRSPACE  = 16_0500;
  EN_MAXTEXT   = 16_0501;
  EN_HSCROLL   = 16_0601;
  EN_VSCROLL   = 16_0602;
</PRE> Edit Control Messages 
<PRE>CONST
  EM_GETSEL              = 16_00B0;
  EM_SETSEL              = 16_00B1;
  EM_GETRECT             = 16_00B2;
  EM_SETRECT             = 16_00B3;
  EM_SETRECTNP           = 16_00B4;
  EM_SCROLL              = 16_00B5;
  EM_LINESCROLL          = 16_00B6;
  EM_SCROLLCARET         = 16_00B7;
  EM_GETMODIFY           = 16_00B8;
  EM_SETMODIFY           = 16_00B9;
  EM_GETLINECOUNT        = 16_00BA;
  EM_LINEINDEX           = 16_00BB;
  EM_SETHANDLE           = 16_00BC;
  EM_GETHANDLE           = 16_00BD;
  EM_GETTHUMB            = 16_00BE;
  EM_LINELENGTH          = 16_00C1;
  EM_REPLACESEL          = 16_00C2;
  EM_SETFONT             = 16_00C3;
  EM_GETLINE             = 16_00C4;
  EM_LIMITTEXT           = 16_00C5;
  EM_CANUNDO             = 16_00C6;
  EM_UNDO                = 16_00C7;
  EM_FMTLINES            = 16_00C8;
  EM_LINEFROMCHAR        = 16_00C9;
  EM_SETWORDBREAK        = 16_00CA;
  EM_SETTABSTOPS         = 16_00CB;
  EM_SETPASSWORDCHAR     = 16_00CC;
  EM_EMPTYUNDOBUFFER     = 16_00CD;
  EM_GETFIRSTVISIBLELINE = 16_00CE;
  EM_SETREADONLY         = 16_00CF;
  EM_SETWORDBREAKPROC    = 16_00D0;
  EM_GETWORDBREAKPROC    = 16_00D1;
  EM_GETPASSWORDCHAR     = 16_00D2;
  EM_MSGMAX              = 16_00D3;
</PRE> EDITWORDBREAKPROC code values 
<PRE>CONST
  WB_LEFT        = 0;
  WB_RIGHT       = 1;
  WB_ISDELIMITER = 2;
</PRE> Button Control Styles 
<PRE>CONST
  BS_PUSHBUTTON     : LONG = 16_00;
  BS_DEFPUSHBUTTON  : LONG = 16_01;
  BS_CHECKBOX       : LONG = 16_02;
  BS_AUTOCHECKBOX   : LONG = 16_03;
  BS_RADIOBUTTON    : LONG = 16_04;
  BS_3STATE         : LONG = 16_05;
  BS_AUTO3STATE     : LONG = 16_06;
  BS_GROUPBOX       : LONG = 16_07;
  BS_USERBUTTON     : LONG = 16_08;
  BS_AUTORADIOBUTTON: LONG = 16_09;
  BS_PUSHBOX        : LONG = 16_0A;
  BS_OWNERDRAW      : LONG = 16_0B;
  BS_LEFTTEXT       : LONG = 16_20;
</PRE> User Button Notification Codes 
<PRE>CONST
  BN_CLICKED       = 0;
  BN_PAINT         = 1;
  BN_HILITE        = 2;
  BN_UNHILITE      = 3;
  BN_DISABLE       = 4;
  BN_DOUBLECLICKED = 5;
</PRE> Button Control Messages 
<PRE>CONST
  BM_GETCHECK = 16_00F0;
  BM_SETCHECK = 16_00F1;
  BM_GETSTATE = 16_00F2;
  BM_SETSTATE = 16_00F3;
  BM_SETSTYLE = 16_00F4;
</PRE> Static Control Constants 
<PRE>CONST
  SS_LEFT          : LONG = 16_00;
  SS_CENTER        : LONG = 16_01;
  SS_RIGHT         : LONG = 16_02;
  SS_ICON          : LONG = 16_03;
  SS_BLACKRECT     : LONG = 16_04;
  SS_GRAYRECT      : LONG = 16_05;
  SS_WHITERECT     : LONG = 16_06;
  SS_BLACKFRAME    : LONG = 16_07;
  SS_GRAYFRAME     : LONG = 16_08;
  SS_WHITEFRAME    : LONG = 16_09;
  SS_USERITEM      : LONG = 16_0A;
  SS_SIMPLE        : LONG = 16_0B;
  SS_LEFTNOWORDWRAP: LONG = 16_0C;
  SS_NOPREFIX      : LONG = 16_80; (* Don't do &quot;&amp;&quot; character translation *)
</PRE> Static Control Mesages 
<PRE>CONST
  STM_SETICON = 16_170;
  STM_GETICON = 16_171;
  STM_MSGMAX  = 16_172;
</PRE><P>
 * Dialog window class
 
<PRE>VAR                             (* CONST *)
  WC_DIALOG: LPTSTR;
</PRE><P>
 * Get/SetWindowWord/Long offsets for use with WC_DIALOG windows
 
<PRE>CONST
  DWL_MSGRESULT = 0;
  DWL_DLGPROC   = 4;
  DWL_USER      = 8;
</PRE> Dialog Manager Routines 

<P><PRE>&lt;*EXTERNAL IsDialogMessage:WINAPI*&gt;
PROCEDURE IsDialogMessage (hDlg: HWND; lpMsg: LPMSG): BOOL;

&lt;*EXTERNAL MapDialogRect:WINAPI*&gt;
PROCEDURE MapDialogRect (hDlg: HWND; lpRect: LPRECT): BOOL;

&lt;*EXTERNAL DlgDirListA:WINAPI*&gt;
PROCEDURE DlgDirListA (hDlg         : HWND;
                         lpPathSpec   : LPSTR;
                         nIDListBox   : int;
                         nIDStaticPath: int;
                         uFileType    : UINT   ): int;

&lt;*EXTERNAL DlgDirListW:WINAPI*&gt;
PROCEDURE DlgDirListW (hDlg         : HWND;
                         lpPathSpec   : LPWSTR;
                         nIDListBox   : int;
                         nIDStaticPath: int;
                         uFileType    : UINT    ): int;
CONST DlgDirList = DlgDirListA;
</PRE><P>
 * DlgDirList, DlgDirListComboBox flags values
 
<PRE>CONST
  DDL_READWRITE = 16_0000;
  DDL_READONLY  = 16_0001;
  DDL_HIDDEN    = 16_0002;
  DDL_SYSTEM    = 16_0004;
  DDL_DIRECTORY = 16_0010;
  DDL_ARCHIVE   = 16_0020;

  DDL_POSTMSGS  = 16_2000;
  DDL_DRIVES    = 16_4000;
  DDL_EXCLUSIVE = 16_8000;

&lt;*EXTERNAL DlgDirSelectExA:WINAPI*&gt;
PROCEDURE DlgDirSelectExA (hDlg      : HWND;
                             lpString  : LPSTR;
                             nCount    : int;
                             nIDListBox: int    ): BOOL;

&lt;*EXTERNAL DlgDirSelectExW:WINAPI*&gt;
PROCEDURE DlgDirSelectExW (hDlg      : HWND;
                             lpString  : LPWSTR;
                             nCount    : int;
                             nIDListBox: int     ): BOOL;
CONST DlgDirSelectEx = DlgDirSelectExA;

&lt;*EXTERNAL DlgDirListComboBoxA:WINAPI*&gt;
PROCEDURE DlgDirListComboBoxA (hDlg         : HWND;
                                 lpPathSpec   : LPSTR;
                                 nIDComboBox  : int;
                                 nIDStaticPath: int;
                                 uFiletype    : UINT   ): int;

&lt;*EXTERNAL DlgDirListComboBoxW:WINAPI*&gt;
PROCEDURE DlgDirListComboBoxW (hDlg         : HWND;
                                 lpPathSpec   : LPWSTR;
                                 nIDComboBox  : int;
                                 nIDStaticPath: int;
                                 uFiletype    : UINT    ): int;
CONST DlgDirListComboBox = DlgDirListComboBoxA;

&lt;*EXTERNAL DlgDirSelectComboBoxExA:WINAPI*&gt;
PROCEDURE DlgDirSelectComboBoxExA (hDlg       : HWND;
                                     lpString   : LPSTR;
                                     nCount     : int;
                                     nIDComboBox: int    ): BOOL;

&lt;*EXTERNAL DlgDirSelectComboBoxExW:WINAPI*&gt;
PROCEDURE DlgDirSelectComboBoxExW (hDlg       : HWND;
                                     lpString   : LPWSTR;
                                     nCount     : int;
                                     nIDComboBox: int     ): BOOL;
CONST DlgDirSelectComboBoxEx = DlgDirSelectComboBoxExA;
</PRE> Dialog Styles 
<PRE>CONST
  DS_ABSALIGN  : LONG = 16_01;
  DS_SYSMODAL  : LONG = 16_02;
  DS_LOCALEDIT : LONG = 16_20;  (* Edit items get Local storage. *)
  DS_SETFONT   : LONG = 16_40;  (* User specified font for Dlg controls *)
  DS_MODALFRAME: LONG = 16_80;  (* Can be combined with WS_CAPTION *)
  DS_NOIDLEMSG : LONG = 16_100; (* WM_ENTERIDLE message will not be sent *)
  DS_SETFOREGROUND: LONG = 16_200; (* not in win3.1 *)

  DM_GETDEFID = (WM_USER + 0);
  DM_SETDEFID = (WM_USER + 1);
  DC_HASDEFID = 16_534B;        (* not in win3.1 *)
</PRE> Dialog Codes 
<PRE>CONST
  DLGC_WANTARROWS      = 16_0001; (* Control wants arrow keys *)
  DLGC_WANTTAB         = 16_0002; (* Control wants tab keys *)
  DLGC_WANTALLKEYS     = 16_0004; (* Control wants all keys *)
  DLGC_WANTMESSAGE     = 16_0004; (* Pass message to control *)
  DLGC_HASSETSEL       = 16_0008; (* Understands EM_SETSEL message *)
  DLGC_DEFPUSHBUTTON   = 16_0010; (* Default pushbutton *)
  DLGC_UNDEFPUSHBUTTON = 16_0020; (* Non-default pushbutton *)
  DLGC_RADIOBUTTON     = 16_0040; (* Radio button *)
  DLGC_WANTCHARS       = 16_0080; (* Want WM_CHAR messages *)
  DLGC_STATIC          = 16_0100; (* Static item: don't include *)
  DLGC_BUTTON          = 16_2000; (* Button item: can be checked *)

  LB_CTLCODE: LONG = 0;
</PRE> Listbox Return Values 
<PRE>CONST
  LB_OKAY     = 0;
  LB_ERR      = (-1);
  LB_ERRSPACE = (-2);
</PRE><P>
**  The idStaticPath parameter to DlgDirList can have the following values
**  ORed if the list box should show other details of the files along with
**  the name of the files;

 all other details also will be returned 

<P> Listbox Notification Codes 
<PRE>CONST
  LBN_ERRSPACE  = (-2);
  LBN_SELCHANGE = 1;
  LBN_DBLCLK    = 2;
  LBN_SELCANCEL = 3;
  LBN_SETFOCUS  = 4;
  LBN_KILLFOCUS = 5;
</PRE> Listbox messages 
<PRE>CONST
  LB_ADDSTRING           = 16_0180;
  LB_INSERTSTRING        = 16_0181;
  LB_DELETESTRING        = 16_0182;
  LB_SELITEMRANGEEX      = 16_0183;
  LB_RESETCONTENT        = 16_0184;
  LB_SETSEL              = 16_0185;
  LB_SETCURSEL           = 16_0186;
  LB_GETSEL              = 16_0187;
  LB_GETCURSEL           = 16_0188;
  LB_GETTEXT             = 16_0189;
  LB_GETTEXTLEN          = 16_018A;
  LB_GETCOUNT            = 16_018B;
  LB_SELECTSTRING        = 16_018C;
  LB_DIR                 = 16_018D;
  LB_GETTOPINDEX         = 16_018E;
  LB_FINDSTRING          = 16_018F;
  LB_GETSELCOUNT         = 16_0190;
  LB_GETSELITEMS         = 16_0191;
  LB_SETTABSTOPS         = 16_0192;
  LB_GETHORIZONTALEXTENT = 16_0193;
  LB_SETHORIZONTALEXTENT = 16_0194;
  LB_SETCOLUMNWIDTH      = 16_0195;
  LB_ADDFILE             = 16_0196;
  LB_SETTOPINDEX         = 16_0197;
  LB_GETITEMRECT         = 16_0198;
  LB_GETITEMDATA         = 16_0199;
  LB_SETITEMDATA         = 16_019A;
  LB_SELITEMRANGE        = 16_019B;
  LB_SETANCHORINDEX      = 16_019C;
  LB_GETANCHORINDEX      = 16_019D;
  LB_SETCARETINDEX       = 16_019E;
  LB_GETCARETINDEX       = 16_019F;
  LB_SETITEMHEIGHT       = 16_01A0;
  LB_GETITEMHEIGHT       = 16_01A1;
  LB_FINDSTRINGEXACT     = 16_01A2;
  LBCB_CARETON           = 16_01A3;
  LBCB_CARETOFF          = 16_01A4;
  LB_SETLOCALE           = 16_01A5;
  LB_GETLOCALE           = 16_01A6;
  LB_SETCOUNT            = 16_01A7;
  LB_MSGMAX              = 16_01A8;
</PRE> Listbox Styles 
<PRE>CONST
  LBS_NOTIFY           : LONG = 16_0001;
  LBS_SORT             : LONG = 16_0002;
  LBS_NOREDRAW         : LONG = 16_0004;
  LBS_MULTIPLESEL      : LONG = 16_0008;
  LBS_OWNERDRAWFIXED   : LONG = 16_0010;
  LBS_OWNERDRAWVARIABLE: LONG = 16_0020;
  LBS_HASSTRINGS       : LONG = 16_0040;
  LBS_USETABSTOPS      : LONG = 16_0080;
  LBS_NOINTEGRALHEIGHT : LONG = 16_0100;
  LBS_MULTICOLUMN      : LONG = 16_0200;
  LBS_WANTKEYBOARDINPUT: LONG = 16_0400;
  LBS_EXTENDEDSEL      : LONG = 16_0800;
  LBS_DISABLENOSCROLL  : LONG = 16_1000;
  LBS_NODATA           : LONG = 16_2000;
  LBS_STANDARD = Or(LBS_NOTIFY, Or(LBS_SORT, Or(WS_VSCROLL, WS_BORDER)));
</PRE> Combo Box return Values 
<PRE>CONST
  CB_OKAY     = 0;
  CB_ERR      = (-1);
  CB_ERRSPACE = (-2);
</PRE> Combo Box Notification Codes 
<PRE>CONST
  CBN_ERRSPACE     = (-1);
  CBN_SELCHANGE    = 1;
  CBN_DBLCLK       = 2;
  CBN_SETFOCUS     = 3;
  CBN_KILLFOCUS    = 4;
  CBN_EDITCHANGE   = 5;
  CBN_EDITUPDATE   = 6;
  CBN_DROPDOWN     = 7;
  CBN_CLOSEUP      = 8;
  CBN_SELENDOK     = 9;
  CBN_SELENDCANCEL = 10;
</PRE> Combo Box styles 
<PRE>CONST
  CBS_SIMPLE           : LONG = 16_0001;
  CBS_DROPDOWN         : LONG = 16_0002;
  CBS_DROPDOWNLIST     : LONG = 16_0003;
  CBS_OWNERDRAWFIXED   : LONG = 16_0010;
  CBS_OWNERDRAWVARIABLE: LONG = 16_0020;
  CBS_AUTOHSCROLL      : LONG = 16_0040;
  CBS_OEMCONVERT       : LONG = 16_0080;
  CBS_SORT             : LONG = 16_0100;
  CBS_HASSTRINGS       : LONG = 16_0200;
  CBS_NOINTEGRALHEIGHT : LONG = 16_0400;
  CBS_DISABLENOSCROLL  : LONG = 16_0800;
</PRE> Combo Box messages 
<PRE>CONST
  CB_GETEDITSEL            = 16_0140;
  CB_LIMITTEXT             = 16_0141;
  CB_SETEDITSEL            = 16_0142;
  CB_ADDSTRING             = 16_0143;
  CB_DELETESTRING          = 16_0144;
  CB_DIR                   = 16_0145;
  CB_GETCOUNT              = 16_0146;
  CB_GETCURSEL             = 16_0147;
  CB_GETLBTEXT             = 16_0148;
  CB_GETLBTEXTLEN          = 16_0149;
  CB_INSERTSTRING          = 16_014A;
  CB_RESETCONTENT          = 16_014B;
  CB_FINDSTRING            = 16_014C;
  CB_SELECTSTRING          = 16_014D;
  CB_SETCURSEL             = 16_014E;
  CB_SHOWDROPDOWN          = 16_014F;
  CB_GETITEMDATA           = 16_0150;
  CB_SETITEMDATA           = 16_0151;
  CB_GETDROPPEDCONTROLRECT = 16_0152;
  CB_SETITEMHEIGHT         = 16_0153;
  CB_GETITEMHEIGHT         = 16_0154;
  CB_SETEXTENDEDUI         = 16_0155;
  CB_GETEXTENDEDUI         = 16_0156;
  CB_GETDROPPEDSTATE       = 16_0157;
  CB_FINDSTRINGEXACT       = 16_0158;
  CB_SETLOCALE             = 16_0159;
  CB_GETLOCALE             = 16_015a;
  CB_MSGMAX                = 16_015b;
</PRE> Scroll Bar Styles 
<PRE>CONST
  SBS_HORZ                   : LONG = 16_0000;
  SBS_VERT                   : LONG = 16_0001;
  SBS_TOPALIGN               : LONG = 16_0002;
  SBS_LEFTALIGN              : LONG = 16_0002;
  SBS_BOTTOMALIGN            : LONG = 16_0004;
  SBS_RIGHTALIGN             : LONG = 16_0004;
  SBS_SIZEBOXTOPLEFTALIGN    : LONG = 16_0002;
  SBS_SIZEBOXBOTTOMRIGHTALIGN: LONG = 16_0004;
  SBS_SIZEBOX                : LONG = 16_0008;
</PRE> Scroll bar messages 
<PRE>CONST
  SBM_SETPOS         = 16_00E0; (* not in win3.1 *)
  SBM_GETPOS         = 16_00E1; (* not in win3.1 *)
  SBM_SETRANGE       = 16_00E2; (* not in win3.1 *)
  SBM_SETRANGEREDRAW = 16_00E6; (* not in win3.1 *)
  SBM_GETRANGE       = 16_00E3; (* not in win3.1 *)
  SBM_ENABLE_ARROWS  = 16_00E4; (* not in win3.1 *)
</PRE> MDI client style bits 
<PRE>CONST MDIS_ALLCHILDSTYLES = 16_0001;
</PRE> wParam Flags for WM_MDITILE and WM_MDICASCADE messages. 
<PRE>CONST
  MDITILE_VERTICAL     = 16_0000; (* not in win3.1 *)
  MDITILE_HORIZONTAL   = 16_0001; (* not in win3.1 *)
  MDITILE_SKIPDISABLED = 16_0002; (* not in win3.1 *)

TYPE
  MDICREATESTRUCTA = RECORD
                       szClass: LPCSTR;
                       szTitle: LPCSTR;
                       hOwner : HANDLE;
                       x      : int;
                       y      : int;
                       cx     : int;
                       cy     : int;
    style  : DWORD;
    lParam : LPARAM;  (* app-defined stuff *)
  END;
  LPMDICREATESTRUCTA = UNTRACED REF MDICREATESTRUCTA;
  MDICREATESTRUCTW = RECORD
    szClass: LPCWSTR;
    szTitle: LPCWSTR;
    hOwner : HANDLE;
    x      : int;
    y      : int;
    cx     : int;
    cy     : int;
    style  : DWORD;
    lParam : LPARAM;   (* app-defined stuff *)
  END;
  LPMDICREATESTRUCTW = UNTRACED REF MDICREATESTRUCTW;
  MDICREATESTRUCT = MDICREATESTRUCTA;
  LPMDICREATESTRUCT = LPMDICREATESTRUCTA;

  CLIENTCREATESTRUCT = RECORD
    hWindowMenu : HANDLE;
    idFirstChild: UINT;
  END;
  LPCLIENTCREATESTRUCT = UNTRACED REF CLIENTCREATESTRUCT;

&lt;*EXTERNAL DefFrameProcA:WINAPI*&gt;
PROCEDURE DefFrameProcA (hWnd         : HWND;
    hWndMDIClient: HWND;
    uMsg         : UINT;
    wParam       : WPARAM;
                           lParam       : LPARAM  ): LRESULT;

&lt;*EXTERNAL DefFrameProcW:WINAPI*&gt;
PROCEDURE DefFrameProcW (hWnd         : HWND;
                           hWndMDIClient: HWND;
                           uMsg         : UINT;
                           wParam       : WPARAM;
                           lParam       : LPARAM  ): LRESULT;
CONST DefFrameProc = DefFrameProcA;

&lt;*EXTERNAL DefMDIChildProcA:WINAPI*&gt;
PROCEDURE DefMDIChildProcA (hWnd  : HWND;
                              uMsg  : UINT;
                              wParam: WPARAM;
                              lParam: LPARAM  ): LRESULT;

&lt;*EXTERNAL DefMDIChildProcW:WINAPI*&gt;
PROCEDURE DefMDIChildProcW (hWnd  : HWND;
                              uMsg  : UINT;
                              wParam: WPARAM;
                              lParam: LPARAM  ): LRESULT;
CONST DefMDIChildProc = DefMDIChildProcA;

&lt;*EXTERNAL TranslateMDISysAccel:WINAPI*&gt;
PROCEDURE TranslateMDISysAccel (hWndClient: HWND; lpMsg: LPMSG): BOOL;

&lt;*EXTERNAL ArrangeIconicWindows:WINAPI*&gt;
PROCEDURE ArrangeIconicWindows (hWnd: HWND): UINT;

&lt;*EXTERNAL CreateMDIWindowA:WINAPI*&gt;
PROCEDURE CreateMDIWindowA (lpClassName : LPSTR;
                              lpWindowName: LPSTR;
                              dwStyle     : DWORD;
                              X           : int;
                              Y           : int;
                              nWidth      : int;
                              nHeight     : int;
                              hWndParent  : HWND;
                              hInstance   : HINSTANCE;
                              lParam      : LONG       ): HWND;

&lt;*EXTERNAL CreateMDIWindowW:WINAPI*&gt;
PROCEDURE CreateMDIWindowW (lpClassName : LPWSTR;
                              lpWindowName: LPWSTR;
                              dwStyle     : DWORD;
                              X           : int;
                              Y           : int;
                              nWidth      : int;
                              nHeight     : int;
                              hWndParent  : HWND;
                              hInstance   : HINSTANCE;
                              lParam      : LONG       ): HWND;
CONST CreateMDIWindow = CreateMDIWindowA;
</PRE>***** Help support *******************************************************

<P><PRE>TYPE
  HELPPOLY = DWORD;
  MULTIKEYHELPA = RECORD
                    mkSize     : DWORD;
                    mkKeylist  : CHAR;
    szKeyphrase: ARRAY [0 .. 1 - 1] OF CHAR;
  END;
  PMULTIKEYHELPA = UNTRACED REF MULTIKEYHELPA;
  LPMULTIKEYHELPA = UNTRACED REF MULTIKEYHELPA;
  MULTIKEYHELPW = RECORD
    mkSize     : DWORD;
    mkKeylist  : WCHAR;
    szKeyphrase: ARRAY [0 .. 1 - 1] OF WCHAR;
  END;
  PMULTIKEYHELPW = UNTRACED REF MULTIKEYHELPW;
  LPMULTIKEYHELPW = UNTRACED REF MULTIKEYHELPW;
  MULTIKEYHELP = MULTIKEYHELPA;
  PMULTIKEYHELP = PMULTIKEYHELPA;
  LPMULTIKEYHELP = LPMULTIKEYHELPA;

  HELPWININFOA = RECORD
    wStructSize: int;
    x          : int;
    y          : int;
    dx         : int;
    dy         : int;
    wMax       : int;
    rgchMember : ARRAY [0 .. 2 - 1] OF CHAR;
  END;
  PHELPWININFOA = UNTRACED REF HELPWININFOA;
  LPHELPWININFOA = UNTRACED REF HELPWININFOA;
  HELPWININFOW = RECORD
    wStructSize: int;
    x          : int;
    y          : int;
    dx         : int;
    dy         : int;
    wMax       : int;
    rgchMember : ARRAY [0 .. 2 - 1] OF WCHAR;
  END;
  PHELPWININFOW = UNTRACED REF HELPWININFOW;
  LPHELPWININFOW = UNTRACED REF HELPWININFOW;
  HELPWININFO = HELPWININFOA;
  PHELPWININFO = PHELPWININFOA;
  LPHELPWININFO = LPHELPWININFOA;
</PRE><P>
 * Commands to pass WinHelp()
 
<PRE>CONST
  HELP_CONTEXT   : LONG = 16_0001; (* Display topic in ulTopic *)
  HELP_QUIT      : LONG = 16_0002; (* Terminate help *)
  HELP_INDEX     : LONG = 16_0003; (* Display index *)
  HELP_CONTENTS  : LONG = 16_0003;
  HELP_HELPONHELP: LONG = 16_0004; (* Display help on using help *)
  HELP_SETINDEX: LONG = 16_0005; (* Set current Index for multi index
                                    help *)
  HELP_SETCONTENTS : LONG = 16_0005;
  HELP_CONTEXTPOPUP: LONG = 16_0008;
  HELP_FORCEFILE   : LONG = 16_0009;
  HELP_KEY: LONG = 16_0101;     (* Display topic for keyword in
                                   offabData *)
  HELP_COMMAND   : LONG = 16_0102;
  HELP_PARTIALKEY: LONG = 16_0105;
  HELP_MULTIKEY  : LONG = 16_0201;
  HELP_SETWINPOS : LONG = 16_0203;

&lt;*EXTERNAL WinHelpA:WINAPI*&gt;
PROCEDURE WinHelpA (hwndMain: HWND;
                    lpszHelp: LPCSTR;
                    uCommand: UINT;
                    dwData  : DWORD   ): BOOL;

&lt;*EXTERNAL WinHelpW:WINAPI*&gt;
PROCEDURE WinHelpW (hwndMain: HWND;
                    lpszHelp: LPCWSTR;
                    uCommand: UINT;
                    dwData  : DWORD    ): BOOL;
CONST WinHelp = WinHelpA;
</PRE> function declarations for profiler routines contained in Windows
   libraries 

<P><PRE>&lt;*EXTERNAL ProfInsChk:WINAPI*&gt;
PROCEDURE ProfInsChk (): int;

&lt;*EXTERNAL ProfSetup:WINAPI*&gt;
PROCEDURE ProfSetup (a1: int; a2: int);

&lt;*EXTERNAL ProfSampRate:WINAPI*&gt;
PROCEDURE ProfSampRate (a1: int; a2: int);

&lt;*EXTERNAL ProfStart:WINAPI*&gt;
PROCEDURE ProfStart ();

&lt;*EXTERNAL ProfStop:WINAPI*&gt;
PROCEDURE ProfStop ();

&lt;*EXTERNAL ProfClear:WINAPI*&gt;
PROCEDURE ProfClear ();

&lt;*EXTERNAL ProfFlush:WINAPI*&gt;
PROCEDURE ProfFlush ();

&lt;*EXTERNAL ProfFinish:WINAPI*&gt;
PROCEDURE ProfFinish ();
</PRE> Parameter for SystemParametersInfo() 
<PRE>CONST
  SPI_GETBEEP               = 1;
  SPI_SETBEEP               = 2;
  SPI_GETMOUSE              = 3;
  SPI_SETMOUSE              = 4;
  SPI_GETBORDER             = 5;
  SPI_SETBORDER             = 6;
  SPI_TIMEOUTS              = 7;
  SPI_GETKEYBOARDSPEED      = 10;
  SPI_SETKEYBOARDSPEED      = 11;
  SPI_LANGDRIVER            = 12;
  SPI_ICONHORIZONTALSPACING = 13;
  SPI_GETSCREENSAVETIMEOUT  = 14;
  SPI_SETSCREENSAVETIMEOUT  = 15;
  SPI_GETSCREENSAVEACTIVE   = 16;
  SPI_SETSCREENSAVEACTIVE   = 17;
  SPI_GETGRIDGRANULARITY    = 18;
  SPI_SETGRIDGRANULARITY    = 19;
  SPI_SETDESKWALLPAPER      = 20;
  SPI_SETDESKPATTERN        = 21;
  SPI_GETKEYBOARDDELAY      = 22;
  SPI_SETKEYBOARDDELAY      = 23;
  SPI_ICONVERTICALSPACING   = 24;
  SPI_GETICONTITLEWRAP      = 25;
  SPI_SETICONTITLEWRAP      = 26;
  SPI_GETMENUDROPALIGNMENT  = 27;
  SPI_SETMENUDROPALIGNMENT  = 28;
  SPI_SETDOUBLECLKWIDTH     = 29;
  SPI_SETDOUBLECLKHEIGHT    = 30;
  SPI_GETICONTITLELOGFONT   = 31;
  SPI_SETDOUBLECLICKTIME    = 32;
  SPI_SETMOUSEBUTTONSWAP    = 33;
  SPI_SETICONTITLELOGFONT   = 34;
  SPI_GETFASTTASKSWITCH     = 35;
  SPI_SETFASTTASKSWITCH     = 36;
  SPI_MAX                   = 36;

&lt;*EXTERNAL SystemParametersInfoA:WINAPI*&gt;
PROCEDURE SystemParametersInfoA (a1, a2: UINT; a3: PVOID; a4: UINT): BOOL;

&lt;*EXTERNAL SystemParametersInfoW:WINAPI*&gt;
PROCEDURE SystemParametersInfoW (a1, a2: UINT; a3: PVOID; a4: UINT): BOOL;

CONST SystemParametersInfo = SystemParametersInfoA;
</PRE> Flags 
<PRE>CONST
  SPIF_UPDATEINIFILE    = 16_0001;
  SPIF_SENDWININICHANGE = 16_0002;

END WinUser.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
