<HTML>
<HEAD>
<TITLE>SRC Modula-3: win32/src/WinUser.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>win32/src/WinUser.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Stephen Harrison                                       
                                                           

<P><PRE>UNSAFE MODULE <module><implements><A HREF="WinUser.i3">WinUser</A></implements></module>;

FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT int;
FROM <A HREF="WinNT.i3">WinNT</A>  IMPORT LPCSTR, LPCWSTR;
FROM <A HREF="WinDef.i3">WinDef</A> IMPORT BOOL, DWORD, UINT, LPVOID, HWND, WPARAM, LPARAM,
                   LRESULT, HINSTANCE, HMENU, HHOOK;

PROCEDURE <A NAME="ExitWindows"><procedure>ExitWindows</procedure></A> (&lt;*UNUSED*&gt; dwReserved: UINT;
                       &lt;*UNUSED*&gt; Code: DWORD): BOOL =
  BEGIN
    RETURN ExitWindowsEx(EWX_LOGOFF, 16_FFFFFFFF);
  END ExitWindows;

PROCEDURE <A NAME="PostAppMessageA"><procedure>PostAppMessageA</procedure></A> (idThread: DWORD;
                           wMsg    : UINT;
                           wParam  : WPARAM;
                           lParam  : LPARAM  ): BOOL =
  BEGIN
    RETURN PostThreadMessageA(idThread, wMsg, wParam, lParam);
  END PostAppMessageA;

PROCEDURE <A NAME="PostAppMessageW"><procedure>PostAppMessageW</procedure></A> (idThread: DWORD;
                           wMsg    : UINT;
                           wParam  : WPARAM;
                           lParam  : LPARAM  ): BOOL =
  BEGIN
    RETURN PostThreadMessageW(idThread, wMsg, wParam, lParam);
  END PostAppMessageW;

PROCEDURE <A NAME="CreateWindowA"><procedure>CreateWindowA</procedure></A> (lpClassName : LPCSTR;
                         lpWindowName: LPCSTR;
                         dwStyle     : DWORD;
                         x           : int;
                         y           : int;
                         nWidth      : int;
                         nHeight     : int;
                         hwndParent  : HWND;
                         hMenu       : HMENU;
                         hInstance   : HINSTANCE;
                         lpParam     : LPVOID     ): HWND =
  BEGIN
    RETURN
      CreateWindowExA(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                      nHeight, hwndParent, hMenu, hInstance, lpParam);
  END CreateWindowA;

PROCEDURE <A NAME="CreateWindowW"><procedure>CreateWindowW</procedure></A> (lpClassName : LPCWSTR;
                         lpWindowName: LPCWSTR;
                         dwStyle     : DWORD;
                         x           : int;
                         y           : int;
                         nWidth      : int;
                         nHeight     : int;
                         hwndParent  : HWND;
                         hMenu       : HMENU;
                         hInstance   : HINSTANCE;
                         lpParam     : LPVOID     ): HWND =
  BEGIN
    RETURN
      CreateWindowExW(0, lpClassName, lpWindowName, dwStyle, x, y, nWidth,
                      nHeight, hwndParent, hMenu, hInstance, lpParam);
  END CreateWindowW;

PROCEDURE <A NAME="CreateDialogA"><procedure>CreateDialogA</procedure></A> (hInstance   : HINSTANCE;
                         lpName      : LPCSTR;
                         hwndParent  : HWND;
                         lpDialogFunc: DLGPROC    ): HWND =
  BEGIN
    RETURN
      CreateDialogParamA(hInstance, lpName, hwndParent, lpDialogFunc, 0);
  END CreateDialogA;

PROCEDURE <A NAME="CreateDialogW"><procedure>CreateDialogW</procedure></A> (hInstance   : HINSTANCE;
                         lpName      : LPCWSTR;
                         hwndParent  : HWND;
                         lpDialogFunc: DLGPROC    ): HWND =
  BEGIN
    RETURN
      CreateDialogParamW(hInstance, lpName, hwndParent, lpDialogFunc, 0);
  END CreateDialogW;

PROCEDURE <A NAME="CreateDialogIndirectA"><procedure>CreateDialogIndirectA</procedure></A> (hInstance   : HINSTANCE;
                                 lpTemplate  : LPCDLGTEMPLATEA;
                                 hwndParent  : HWND;
                                 lpDialogFunc: DLGPROC          ): HWND =
  BEGIN
    RETURN CreateDialogIndirectParamA(
             hInstance, lpTemplate, hwndParent, lpDialogFunc, 0);
  END CreateDialogIndirectA;

PROCEDURE <A NAME="CreateDialogIndirectW"><procedure>CreateDialogIndirectW</procedure></A> (hInstance   : HINSTANCE;
                                 lpTemplate  : LPCDLGTEMPLATEW;
                                 hwndParent  : HWND;
                                 lpDialogFunc: DLGPROC          ): HWND =
  BEGIN
    RETURN CreateDialogIndirectParamW(
             hInstance, lpTemplate, hwndParent, lpDialogFunc, 0);
  END CreateDialogIndirectW;

PROCEDURE <A NAME="DialogBoxA"><procedure>DialogBoxA</procedure></A> (hInstance     : HINSTANCE;
                      lpTemplateName: LPCSTR;
                      hWndParent    : HWND;
                      lpDialogFunc  : DLGPROC    ): int =
  BEGIN
    RETURN
      DialogBoxParamA(hInstance, lpTemplateName, hWndParent, lpDialogFunc, 0);
  END DialogBoxA;

PROCEDURE <A NAME="DialogBoxW"><procedure>DialogBoxW</procedure></A> (hInstance     : HINSTANCE;
                      lpTemplateName: LPCWSTR;
                      hWndParent    : HWND;
                      lpDialogFunc  : DLGPROC    ): int =
  BEGIN
    RETURN
      DialogBoxParamW(hInstance, lpTemplateName, hWndParent, lpDialogFunc, 0);
  END DialogBoxW;

PROCEDURE <A NAME="DialogBoxIndirectA"><procedure>DialogBoxIndirectA</procedure></A> (hInstance      : HINSTANCE;
                              hDialogTemplate: LPDLGTEMPLATEA;
                              hWndParent     : HWND;
                              lpDialogFunc   : DLGPROC         ): int =
  BEGIN
    RETURN DialogBoxIndirectParamA(
             hInstance, hDialogTemplate, hWndParent, lpDialogFunc, 0);
  END DialogBoxIndirectA;

PROCEDURE <A NAME="DialogBoxIndirectW"><procedure>DialogBoxIndirectW</procedure></A> (hInstance      : HINSTANCE;
                              hDialogTemplate: LPDLGTEMPLATEW;
                              hWndParent     : HWND;
                              lpDialogFunc   : DLGPROC         ): int =
  BEGIN
    RETURN DialogBoxIndirectParamW(
             hInstance, hDialogTemplate, hWndParent, lpDialogFunc, 0);
  END DialogBoxIndirectW;

PROCEDURE <A NAME="MessageBoxA"><procedure>MessageBoxA</procedure></A> (hWnd     : HWND;
                       lpText   : LPCSTR;
                       lpCaption: LPCSTR;
                       uType    : UINT    ): int =
  BEGIN
    RETURN MessageBoxExA(hWnd, lpText, lpCaption, uType, 0);
  END MessageBoxA;

PROCEDURE <A NAME="MessageBoxW"><procedure>MessageBoxW</procedure></A> (hWnd     : HWND;
                       lpText   : LPCWSTR;
                       lpCaption: LPCWSTR;
                       uType    : UINT    ): int =
  BEGIN
    RETURN MessageBoxExW(hWnd, lpText, lpCaption, uType, 0);
  END MessageBoxW;

PROCEDURE <A NAME="EnumTaskWindows"><procedure>EnumTaskWindows</procedure></A> (dwThreadId: DWORD;
                           lpfn      : WNDENUMPROC;
                           lParam    : LPARAM       ): BOOL =
  BEGIN
    RETURN EnumThreadWindows(dwThreadId, lpfn, lParam);
  END EnumTaskWindows;

PROCEDURE <A NAME="GetNextWindow"><procedure>GetNextWindow</procedure></A> (hWnd: HWND; uCmd: UINT): HWND =
  BEGIN
    RETURN GetWindow(hWnd, uCmd);
  END GetNextWindow;

PROCEDURE <A NAME="DefHookProc"><procedure>DefHookProc</procedure></A> (nCode : int;
                       wParam: WPARAM;
                       lParam: LPARAM;
                       phhk  : UNTRACED REF HHOOK): LRESULT =
  BEGIN
    RETURN CallNextHookEx(phhk^, nCode, wParam, lParam);
  END DefHookProc;

BEGIN
  RT_CURSOR := LOOPHOLE(1, ADDRESS);
  RT_BITMAP := LOOPHOLE(2, ADDRESS);
  RT_ICON := LOOPHOLE(3, ADDRESS);
  RT_MENU := LOOPHOLE(4, ADDRESS);
  RT_DIALOG := LOOPHOLE(5, ADDRESS);
  RT_STRING := LOOPHOLE(6, ADDRESS);
  RT_FONTDIR := LOOPHOLE(7, ADDRESS);
  RT_FONT := LOOPHOLE(8, ADDRESS);
  RT_ACCELERATOR := LOOPHOLE(9, ADDRESS);
  RT_RCDATA := LOOPHOLE(10, ADDRESS);
  RT_MESSAGETABLE := LOOPHOLE(11, ADDRESS);

  (* NOTE: if any new resource types are introduced above this point, then
     the ** value of DIFFERENCE must be changed.  ** (RT_GROUP_CURSOR -
     RT_CURSOR) must always be equal to DIFFERENCE ** (RT_GROUP_ICON -
     RT_ICON) must always be equal to DIFFERENCE *)
  RT_GROUP_CURSOR := LOOPHOLE(RT_CURSOR + DIFFERENCE, ADDRESS);
  (* The value RT_BITMAP+DIFFERENCE (13) is intentionally unused *)
  RT_GROUP_ICON := LOOPHOLE(RT_ICON + DIFFERENCE, ADDRESS);
  (* The value 15 is unused/obsolete *)
  RT_VERSION := LOOPHOLE(16, ADDRESS);
  RT_DLGINCLUDE := LOOPHOLE(17, ADDRESS);

  HWND_BROADCAST := LOOPHOLE(16_ffff, ADDRESS);

  HWND_DESKTOP := LOOPHOLE(0, ADDRESS);

  HWND_TOP := LOOPHOLE(0, ADDRESS);
  HWND_BOTTOM := LOOPHOLE(1, ADDRESS);
  HWND_TOPMOST := LOOPHOLE(-1, ADDRESS);
  HWND_NOTOPMOST := LOOPHOLE(-2, ADDRESS);

  IDC_ARROW := LOOPHOLE(32512, ADDRESS);
  IDC_IBEAM := LOOPHOLE(32513, ADDRESS);
  IDC_WAIT := LOOPHOLE(32514, ADDRESS);
  IDC_CROSS := LOOPHOLE(32515, ADDRESS);
  IDC_UPARROW := LOOPHOLE(32516, ADDRESS);
  IDC_SIZE := LOOPHOLE(32640, ADDRESS);
  IDC_ICON := LOOPHOLE(32641, ADDRESS);
  IDC_SIZENWSE := LOOPHOLE(32642, ADDRESS);
  IDC_SIZENESW := LOOPHOLE(32643, ADDRESS);
  IDC_SIZEWE := LOOPHOLE(32644, ADDRESS);
  IDC_SIZENS := LOOPHOLE(32645, ADDRESS);
  IDC_SIZEALL := LOOPHOLE(32646, ADDRESS); (* not in win3.1 *)
  IDC_NO := LOOPHOLE(32648, ADDRESS); (* not in win3.1 *)
  IDC_APPSTARTING := LOOPHOLE(32650, ADDRESS); (* not in win3.1 *)

  IDI_APPLICATION := LOOPHOLE(32512, ADDRESS);
  IDI_HAND := LOOPHOLE(32513, ADDRESS);
  IDI_QUESTION := LOOPHOLE(32514, ADDRESS);
  IDI_EXCLAMATION := LOOPHOLE(32515, ADDRESS);
  IDI_ASTERISK := LOOPHOLE(32516, ADDRESS);

  WC_DIALOG := LOOPHOLE(16_8002, ADDRESS);

END WinUser.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
