<HTML>
<HEAD>
<TITLE>SRC Modula-3: word/src/Word.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>word/src/Word.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Word.m3">Word</A></interface>;
</PRE> A Word.T w represents a sequence of Word.Size bits
	  w(0), ..., w(Word.Size-1).
   It also represents the unsigned number
	  sum of 2^(i) * w(i) for i in 0, ..., Word.Size-1. 

<P><PRE>TYPE
  T = INTEGER;
      (* encoding is implementation-dependent; e.g., 2's complement. *)

CONST
  Size : INTEGER = BITSIZE (T);                (* implementation-dependent *)

PROCEDURE <A HREF="Word.m3#Plus">Plus</A> (x, y: T): T;         (* (x + y) MOD 2^[Word.Size] *)
PROCEDURE <A HREF="Word.m3#Times">Times</A> (x, y: T): T;        (* (x * y) MOD 2^[Word.Size] *)
PROCEDURE <A HREF="Word.m3#Minus">Minus</A> (x, y: T): T;        (* (x - y) MOD 2^[Word.Size] *)
PROCEDURE <A HREF="Word.m3#Divide">Divide</A> (x, y: T): T;       (* x divided by y *)
PROCEDURE <A HREF="Word.m3#Mod">Mod</A> (x, y: T): T;          (* x MOD y *)
PROCEDURE <A HREF="Word.m3#LT">LT</A> (x, y: T): BOOLEAN;     (* x &lt; y *)
PROCEDURE <A HREF="Word.m3#LE">LE</A> (x, y: T): BOOLEAN;     (* x &lt;= y *)
PROCEDURE <A HREF="Word.m3#GT">GT</A> (x, y: T): BOOLEAN;     (* x &gt; y *)
PROCEDURE <A HREF="Word.m3#GE">GE</A> (x, y: T): BOOLEAN;     (* x &gt;= y *)
PROCEDURE <A HREF="Word.m3#And">And</A> (x, y: T): T;          (* Bitwise AND of x and y *)
PROCEDURE <A HREF="Word.m3#Or">Or</A> (x, y: T): T;           (* Bitwise OR of x and y *)
PROCEDURE <A HREF="Word.m3#Xor">Xor</A> (x, y: T): T;          (* Bitwise XOR of x and y *)
PROCEDURE <A HREF="Word.m3#Not">Not</A> (x: T): T;             (* Bitwise complement of x *)

PROCEDURE <A HREF="Word.m3#Shift">Shift</A> (x: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> For all i such that both i and i - n are in the range [0 .. Word.Size - 1],
   bit i of the result equals bit i - n of x. The other bits of the result are
   0. Thus, shifting by n &gt; 0 is like multiplying by 2^(n) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#LeftShift">LeftShift</A> (x: T; n: [0..Size-1]): T;
</PRE><BLOCKQUOTE><EM> = Shift (x, n) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#RightShift">RightShift</A> (x: T; n: [0..Size-1]): T;
</PRE><BLOCKQUOTE><EM> = Shift (x, -n) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#Rotate">Rotate</A> (x: T; n: INTEGER): T;
</PRE><BLOCKQUOTE><EM> Bit i of the result equals bit (i - n) MOD Word.Size of x. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#LeftRotate">LeftRotate</A> (x: T; n: [0..Size-1]): T;
</PRE><BLOCKQUOTE><EM> = Rotate (x, n) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#RightRotate">RightRotate</A> (x: T; n: [0..Size-1]): T;
</PRE><BLOCKQUOTE><EM> = Rotate (x, -n) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#Extract">Extract</A> (x: T; i, n: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> Take n bits from x, with bit i as the least significant bit, and return them
   as the least significant n bits of a word whose other bits are 0. A checked
   runtime error if n + i &gt; Word.Size. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Word.m3#Insert">Insert</A> (x, y: T; i, n: CARDINAL): T;
</PRE><BLOCKQUOTE><EM> Return x with n bits replaced, with bit i as the least significant bit, by
   the least significant n bits of y. The other bits of x are unchanged. A
   checked runtime error if n + i &gt; Word.Size. </EM></BLOCKQUOTE><PRE>

END Word.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
