<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/derived/RemoteView_T_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/derived/RemoteView_T_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>RemoteView_T_v1</module> EXPORTS <A HREF="../src/RemoteView.i3"><implements>RemoteView</A></implements>, <A HREF="RemoteView_T_v1.i3"><implements>RemoteView_T_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../src/RemoteView.i3">RemoteView</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {event, endrun, startrun};
      ReturnCodes = {OK, RemoteView_Error};

  PROCEDURE <A NAME="Surrogate_startrun"><procedure>Surrogate_startrun</procedure></A>(self: RemoteView.T) RAISES {NetObj.Error,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.startrun));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_startrun;

  PROCEDURE <A NAME="Surrogate_endrun"><procedure>Surrogate_endrun</procedure></A>(self: RemoteView.T) RAISES {NetObj.Error,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.endrun));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_endrun;

  PROCEDURE <A NAME="Surrogate_event"><procedure>Surrogate_event</procedure></A>(
      self: RemoteView.T;
      tfactor_arg: REAL;
      nm_arg: TEXT;
      args_arg: TEXT) RAISES {RemoteView.Error, NetObj.Error,
      Thread.Alerted} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.event));
          StubLib.OutReal(c, tfactor_arg);
          StubLib.OutRef(c, nm_arg);
          StubLib.OutRef(c, args_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.RemoteView_Error) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE RemoteView.Error(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_event;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, RemoteView.T);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.startrun) =&gt; Stub_startrun(t, c, rep);
      | ORD(Methods.endrun) =&gt; Stub_endrun(t, c, rep);
      | ORD(Methods.event) =&gt; Stub_event(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | RemoteView.Error(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.RemoteView_Error));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_startrun"><procedure>Stub_startrun</procedure></A>(
    self: RemoteView.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  BEGIN
    self.startrun();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_startrun;

PROCEDURE <A NAME="Stub_endrun"><procedure>Stub_endrun</procedure></A>(
    self: RemoteView.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  BEGIN
    self.endrun();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_endrun;

PROCEDURE <A NAME="Stub_event"><procedure>Stub_event</procedure></A>(
    self: RemoteView.T;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, RemoteView.Error}=
  VAR tfactor_arg: REAL;
      nm_arg: TEXT;
      args_arg: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    tfactor_arg := StubLib.InReal(c, rep);
    nm_arg := StubLib.InRef(c, rep, -1);
    args_arg := StubLib.InRef(c, rep, -1);
    self.event(tfactor_arg, nm_arg, args_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_event;

BEGIN
  StubLib.Register(TYPECODE(RemoteView.T), 1, TYPECODE(Surrogate_RemoteView_T), Invoke);
END RemoteView_T_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
