<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/AlbumVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/AlbumVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;
</PRE> <CODE>AlbumVBT</CODE> manages a photo album of snapshots of VBTs.  The
   snapshots are taken by <CODE>Image.FromVBT</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="AlbumVBT.m3">AlbumVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="AlbumVBT.m3#T">T</A> &lt;: TPublic;
  <A HREF="AlbumVBT.m3#TPrivate">TPrivate</A> &lt;: VBT.Split;
  TPublic = TPrivate OBJECT
            METHODS
              &lt;* LL &lt;= VBT.mu *&gt;
              init (layoutAxis   : Axis.T;
                    size         : CARDINAL;
                    width, height: REAL       := 30.0): T;

              &lt;* LL = VBT.mu *&gt;
              add   (w: VBT.T);
              clear ();
            END;
</PRE> The call <CODE>v.init(layoutAxis, size, width, height)</CODE> initializes
   <CODE>v</CODE> to be an <CODE>AlbumVBT.T</CODE>.  An <CODE>AlbumVBT.T</CODE> is a <CODE>VBT.Split</CODE>
   that manages the layout of a series of images produced by
   taking snapshots of VBTs using <CODE>Image.FromVBT</CODE>.  The images in <CODE>v</CODE>
   are all shaped <CODE>v.width</CODE> by <CODE>v.height</CODE> millimeters and laid
   out in a grid.
<P>
   If <CODE>v.layoutAxis</CODE> is horizontal, then there are <CODE>v.size</CODE>
   images laid out horizontally in each row, with rows laid out
   top to bottom.  If <CODE>v.layoutAxis</CODE> is vertical, then there are
   <CODE>v.size</CODE> images per column and the columns are laid out left
   to right.
<P>
   The method call
<PRE>
      v.add(w)
   </PRE>
adds a new snapshot to the album.  It occupies the next slot
   either vertically or horizontally (depending on
   <CODE>v.layoutAxis</CODE>).
<P>
   The method call
<PRE>
      v.clear()
   </PRE>
removes all snapshots from the album. 

<P><PRE>END AlbumVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
