<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/AlbumVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/AlbumVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="AlbumVBT.i3">AlbumVBT</A></implements></module>;
</PRE> Like a photograph album of VBT snapshots 

<P><PRE>IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../lego/src/Image.i3">Image</A>, <A HREF="../../ui/src/split/PackSplit.i3">PackSplit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../lego/src/PixmapVBT.i3">PixmapVBT</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>,
  <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = TPublic BRANDED OBJECT
        ax        : Axis.T;
        size      : Size;
        pref      : CARDINAL;
        cntEntries: CARDINAL;
      OVERRIDES
        rescreen := RescreenT;
        shape    := ShapeT;
        init     := Init;
        add      := Add;
        clear    := Clear;
      END;

REVEAL <A NAME="TPrivate">TPrivate</A> = PackSplit.T BRANDED OBJECT END;

TYPE
  Size = ARRAY Axis.T OF REAL;

  ImageVBT = PixmapVBT.T OBJECT
                size: Size;
              OVERRIDES
                shape   := ShapePixmap;
              END;

PROCEDURE <A NAME="ShapePixmap"><procedure>ShapePixmap</procedure></A> (v: ImageVBT; ax: Axis.T; &lt;* UNUSED *&gt; n: CARDINAL):
  VBT.SizeRange =
  VAR pref := ROUND(VBT.MMToPixels(v, v.size[ax], ax));
  BEGIN
    RETURN VBT.SizeRange{pref, pref, pref + 1}
  END ShapePixmap;

CONST
  Gap = 2.0;

PROCEDURE <A NAME="RescreenT"><procedure>RescreenT</procedure></A> (t: T; READONLY cd: VBT.RescreenRec) =
  VAR
    ax   := t.ax;
    gap  := ROUND(VBT.MMToPixels(t, Gap, ax));
    size := ROUND(VBT.MMToPixels(t, t.size[ax], ax));
  BEGIN
    t.pref := t.cntEntries * (gap + size) + gap;
    PackSplit.T.rescreen(t, cd);
  END RescreenT;

PROCEDURE <A NAME="ShapeT"><procedure>ShapeT</procedure></A> (t: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  BEGIN
    IF ax # t.ax THEN
      RETURN PackSplit.T.shape(t, ax, n);
    ELSE
      RETURN VBT.SizeRange{t.pref, t.pref, t.pref + 1};
    END;
  END ShapeT;

&lt;* FATAL Split.NotAChild *&gt;
PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t            : T;
                ax           : Axis.T;
                cntEntries   : CARDINAL;
                width, height: REAL       := 30.0): T =
  BEGIN
    t.ax := ax;
    t.cntEntries := cntEntries;
    t.size := Size{width, height};
    RETURN PackSplit.T.init(t, ax, Gap, Gap, Pixmap.Gray, PaintOp.BgFg);
  END Init;

&lt;* FATAL TrestleComm.Failure *&gt;
PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (t: T; v: VBT.T) =
  VAR
    pmVBT := NEW(ImageVBT, size := t.size).init(
               pm := Image.Unscaled(
                       Image.FromVBT(v, t.size[Axis.T.Hor],
                                     t.size[Axis.T.Ver])),
               op := PaintOp.Copy, bg := PaintOp.Bg);
  BEGIN
    Split.AddChild(t, pmVBT);
    VBT.NewShape(t);
    VBT.Mark(t);
  END Add;

PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A> (t: T) =
  VAR ch := Split.Succ(t, NIL);
  BEGIN
    WHILE ch # NIL DO
      Split.Delete(t, ch);
      VBT.Discard(ch);
      ch := Split.Succ(t, NIL);
    END;
    VBT.NewShape(t);
  END Clear;

BEGIN
END AlbumVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
