<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/Algorithm.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/Algorithm.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> An Algorithm.T is a subclass of a ZeusClass.T with two
   additional methods and four additional fields:
<P>
   The <CODE>run</CODE> method is invoked when the user clicks on <CODE>GO</CODE> in
   the control panel.  It typically contains the algorithm as one
   would find in a text book.  The default method raises a fatal
   error (i.e., there is no default).
<P>
   If the user requests that the algorithm be aborted (via the
   Zeus control panel), a Thread.Alert exception is raised to
   abort the algorithm.  Thus, if the algorithm spawns any
   threads, it should handle the Thread.Alerted exception by
   aborting its children threads and then exiting.  Most
   single-threaded algorithms can just ignore the Thread.Alerted
   exception.
<P>
   The <CODE>init</CODE> method should be called right after an Algorithm.T
   is created with NEW.  The default method is a no-op (returns
   itself), but sub-classes may use it for necessary set-up.
   Therefore, any user-supplied override to the init method must
   invoke the init method of the supertype.
<P>
   The <CODE>data</CODE> field is a VBT.T (usually a FormsVBT.T), which will
   be displayed to the user in the session control panel.  The
   algorithm may use it to get input data from the user.  (Don't
   forget to lock VBT.mu before calling FormsVBT procedures to
   return data from the form!) Subclasses of Algorithm.T should
   ensure that the data field is initialized, either in the init
   method or before.  It's OK for this field to be NIL; in that
   case, Zeus will not call the display anything to the user.
<P>
   The <CODE>codeViews</CODE> field is an association list (a list of
   two-element lists).  In each tuple, the key is the public name
   of the view (a TEXT), and the second element is the name of a
   resource containing its source (also a TEXT).  The <CODE>codePath</CODE>
   field specifies the path to use when looking for resources.
   If <CODE>codePath</CODE> is <CODE>NIL</CODE>, then <CODE>ZeusPanel.GetPath()</CODE> is used.
<P>
   One way to construct this list is to load it from a file using
   Sx.Read.  Here's what such a file specifying 3 elements would
   contain:
<P>
<PRE>
         ((&quot;Insertion.m3&quot; &quot;Ins.m3.txt&quot;)
          (&quot;Insertion.c&quot;  &quot;Ins.c.txt&quot;)
          (&quot;Insertion&quot;    &quot;Ins.pseudo.txt&quot;))
</PRE>
   Alternatively, it's easy to construct such a list on the fly:
<P>
<PRE>
         RefList.List3(
             RefList.List2(&quot;Insertion.m3&quot;, &quot;Ins.m3.txt&quot;),
             RefList.List2(&quot;Insertion.c&quot;,  &quot;Ins.c.txt&quot;),
             RefList.List2(&quot;Insertion&quot;,    &quot;Ins.pseudo.txt&quot;))
</PRE>
<P>
   The <CODE>varView</CODE> field contains the DataView.T to be used to the
   algorithm.
   <P>
   Typically, the variable view is generated by ZeusDataView. 
   The procedure <CODE>ZeusDataView.New</CODE> should be passed when the view
   is registered. The <CODE>Startrun</CODE> method will fill in the <CODE>varView</CODE>
   field, based on the values in the <CODE>varRsrc</CODE> and <CODE>varPath</CODE> fields.
   If <CODE>varPath</CODE> is <CODE>NIL</CODE>, then <CODE>ZeusPanel.GetPath()</CODE> is used.
<P>
   The default ZeusClass methods <CODE>install</CODE>, <CODE>delete</CODE>, <CODE>config</CODE>,
   and <CODE>reactivity</CODE> are all noops.
<P>
   The default <CODE>snapshot</CODE> and <CODE>restore</CODE> methods test whether the
   <CODE>data</CODE> field is subclass of FormsVBT.T, and if so uses the
   FormsVBT <CODE>snapshot</CODE> and <CODE>restore</CODE> methods to save and restore
   the state of the data form.  If an algorithm keeps its primary
   data in the data form, then it does not need to override the
   snapshot/restore methods.  Otherwise, it needs to override the
   restore method with a procedure that invokes the supertype's
   restore method (restoring the FormsVBT.T), and then loads its
   variables from the <CODE>data</CODE> FormsVBT.T.
<P>
   Subclasses of Algorithm.T that are created by zume will be
   extended with methods for each FEEDBACK event in the .evt
   file.  The feedback methods must be invoked by a view while
   holding VBT.mu.  User-supplied overrides for FEEDBACK methods
   MUST NOT invoke the corresponding supertype methods. 

<P><PRE>INTERFACE <interface><A HREF="Algorithm.m3">Algorithm</A></interface>;

IMPORT <A HREF="../../codeview/src/DataView.i3">DataView</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="ZeusClass.i3">ZeusClass</A>;

TYPE
  <A HREF="Algorithm.m3#T">T</A> &lt;: Public;
  Public = ZeusClass.T OBJECT
             data     : VBT.T      := NIL;
             codeViews: RefList.T  := NIL;
             codePath : Rsrc.Path  := NIL;
             varView  : DataView.T := NIL;
             varRsrc  : TEXT       := NIL;
             varPath  : Rsrc.Path  := NIL;
           METHODS
             (* LL = VBT.mu *)
             init (): T;
             (* LL &lt; VBT.mu *)
             run () RAISES {Thread.Alerted};
           END;

END Algorithm.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
