<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/Algorithm.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/Algorithm.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Algorithm.i3">Algorithm</A></implements></module>;

IMPORT <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="ZeusClass.i3">ZeusClass</A>, <A HREF="ZeusUtil.i3">ZeusUtil</A>;
&lt;* PRAGMA LL *&gt;

REVEAL
  <A NAME="T">T</A> = AlgorithmClass.T BRANDED OBJECT
      OVERRIDES
        run               := DefaultRun;
        init              := DefaultInit;
        snapshot          := DefaultSnapshot;
        restore           := DefaultRestore;
        updateEventCounts := DefaultUpdateCts;
      END;

EXCEPTION FatalError;
&lt;*FATAL FatalError*&gt;

PROCEDURE <A NAME="DefaultRun"><procedure>DefaultRun</procedure></A> (&lt;*UNUSED*&gt; v: T) =
&lt;* LL = {} *&gt;
  BEGIN
    RAISE FatalError
  END DefaultRun;

PROCEDURE <A NAME="DefaultInit"><procedure>DefaultInit</procedure></A> (v: T): T =
&lt;* LL = VBT.mu *&gt;
  BEGIN
    v.evtMu := NEW(MUTEX);
    v.reactivity(FALSE);
    RETURN v
  END DefaultInit;

PROCEDURE <A NAME="DefaultSnapshot"><procedure>DefaultSnapshot</procedure></A> (v: T; wr: Wr.T) RAISES {ZeusClass.Error} =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    TRY
      Wr.PutText(wr, &quot;(&quot;)
    EXCEPT
    ELSE
      RAISE ZeusClass.Error(&quot;Algorithm.DefaultSnapshot write error&quot;)
    END;
    IF v.data # NIL THEN
      TYPECASE v.data OF
      | FormsVBT.T (fv) =&gt;
          TRY
            fv.snapshot(wr);
          EXCEPT
            FormsVBT.Error (msg) =&gt;
              RAISE ZeusClass.Error(
                      &quot;Algorithm.DefaultSnapshot FV error: &quot; &amp; msg);
          ELSE
            RAISE ZeusClass.Error(&quot;Algorithm.DefaultSnapshot error&quot;);
          END;
      ELSE
      END;
    END;
    ZeusClass.T.snapshot(v, wr);
    TRY
      Wr.PutText(wr, &quot;)&quot;)
    EXCEPT
    ELSE
      RAISE ZeusClass.Error(&quot;Algorithm.DefaultSnapshot write error&quot;)
    END;
  END DefaultSnapshot;

PROCEDURE <A NAME="DefaultRestore"><procedure>DefaultRestore</procedure></A> (v: T; rd: Rd.T) RAISES {ZeusClass.Error} =
&lt;* LL = VBT.mu *&gt;
  BEGIN
    IF rd = NIL THEN RETURN END;
    IF NOT ZeusUtil.EatChar(rd, '(') THEN
      RAISE ZeusClass.Error(&quot;Algorithm.DefaultRestore read error&quot;)
    END;
    IF v.data # NIL THEN
      TRY
        TYPECASE v.data OF
        | FormsVBT.T (fv) =&gt;
            fv.restore(rd);
        ELSE
        END;
      EXCEPT
      ELSE
        RAISE ZeusClass.Error(&quot;Algorithm.DefaultRestore error&quot;);
      END;
    END;
    ZeusClass.T.restore(v, rd);
    IF NOT ZeusUtil.EatChar(rd, ')') THEN
      RAISE ZeusClass.Error(&quot;Algorithm.DefaultRestore read error&quot;)
    END;
  END DefaultRestore;

PROCEDURE <A NAME="DefaultUpdateCts"><procedure>DefaultUpdateCts</procedure></A> (&lt;*UNUSED*&gt; v: T; &lt;*UNUSED*&gt; reset: BOOLEAN) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
  END DefaultUpdateCts;

BEGIN END Algorithm.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
