<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/AlgorithmClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/AlgorithmClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface>AlgorithmClass</interface>;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>;

&lt;*PRAGMA LL*&gt;

TYPE
  T = Algorithm.Public BRANDED OBJECT
        name            : TEXT         := &quot;&quot;;
        stopAtEvent     : BOOLEAN      := FALSE;
        waitAtEvent     : CARDINAL     := 1;
        stopatCodeEvents: BOOLEAN      := TRUE;
        waitatCodeEvents: CARDINAL     := 1;
        eventData       : FormsVBT.T;
        evtHandled      : BOOLEAN;
        evtMu           : MUTEX;
      METHODS
        &lt;* LL = VBT.mu *&gt;
        updateEventCounts (reset: BOOLEAN);
      END;
</PRE> The <CODE>name</CODE> field is set by Zeus immediately after an <CODE>Algorithm.T</CODE> has
   been instantiated.  Thereafter, the field is read-only. 
 The <CODE>eventData</CODE> field is a FormsVBT.T that ZeusPanel inserts into the
   Session control panel, just like the public <CODE>data</CODE> field.  The
   <CODE>eventData</CODE> form is used to set the stop/wait information about
   individual events; the automatically-generated &lt;Foo&gt;AlgClass module
   creates the form in its init() method and maintains the event data. 
 The stopAtEvent and waitAtEvent fields control whether to stop after the
   current output event, and how long to wait if you do.  These variables
   are set by #(_ALGNAME_)IE and read by ZeusPanel.  (Could be returned by
   procedure calls, but aren't (for efficiency?).) 
 The <CODE>evtHandled</CODE> field is set to FALSE by the default feedback event
   methods.  User-provided event handlers will not see this field, and
   hence will not set it.  The event dispatcher uses this field to decide
   whether an event was handled by the algorithm. 
 The <CODE>evtMu</CODE> MUTEX is locked by the IE output event procs.  It prevents
   output events from occurring simultaneously, and hence protects the view
   event-handling threads. 
 The <CODE>updateEventCounts</CODE> method is called to refresh the displayed counts
   of output events.  If reset = TRUE, all the counts are reset to 0.
   Whether or not the counts are reset, they are written into the EventData
   form. 

<P><PRE>REVEAL Algorithm.T &lt;: T;
END AlgorithmClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
