<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/Classes.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/Classes.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Classes.i3">Classes</A></implements></module>;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="View.i3">View</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="ZeusPanel.i3">ZeusPanel</A>;

TYPE
  AlgInfo = REF RECORD
                  proc  : ZeusPanel.NewAlgProc;
                  name  : TEXT;
                END;

VAR mu := NEW(MUTEX);    (* protect classes against simultaneous access *)

VAR
  algs: RefList.T (* of AlgInfo *);

PROCEDURE <A NAME="RegisterAlg"><procedure>RegisterAlg</procedure></A> (proc: ZeusPanel.NewAlgProc; name: TEXT) =
  VAR algInfo := NEW(AlgInfo, name := name, proc := proc);
  BEGIN
    LOCK mu DO algs := RefList.Append(algs, RefList.List1(algInfo)) END;
  END RegisterAlg;

PROCEDURE <A NAME="FindAlg"><procedure>FindAlg</procedure></A> (name: TEXT): INTEGER RAISES {NotFound} =
  VAR
    which := 0;
    rest  := algs;
  BEGIN
    LOCK mu DO
      WHILE rest # NIL DO
        IF Text.Equal(name, NARROW(rest.head, AlgInfo).name) THEN
          RETURN which
        END;
        INC(which);
        rest := rest.tail
      END;
    END;
    RAISE NotFound;
  END FindAlg;

PROCEDURE <A NAME="NewAlg"><procedure>NewAlg</procedure></A> (which: INTEGER): Algorithm.T =
  VAR alg: Algorithm.T;
  BEGIN
    LOCK mu DO
      IF which &gt;= RefList.Length(algs) THEN RETURN NIL END;
      WITH algInfo = NARROW(RefList.Nth(algs, which), AlgInfo) DO
        alg := algInfo.proc();
        alg.name := algInfo.name;
        RETURN alg;
      END
    END;
  END NewAlg;

PROCEDURE <A NAME="AlgCount"><procedure>AlgCount</procedure></A> (): INTEGER =
  BEGIN
    LOCK mu DO RETURN RefList.Length(algs) END
  END AlgCount;

TYPE
  ViewInfo = REF RECORD
                   proc     : ZeusPanel.NewViewProc;
                   name     : TEXT;
                   alertable: BOOLEAN;
                   sample   : View.T;
                 END;

VAR
  views: RefList.T (* of ViewInfo *);

PROCEDURE <A NAME="RegisterView"><procedure>RegisterView</procedure></A> (proc     : ZeusPanel.NewViewProc;
                        name     : TEXT;
                        alertable: BOOLEAN;
                        sample   : View.T                 ) =
  VAR
    viewInfo := NEW(ViewInfo, name := name, alertable := alertable,
                    sample := sample, proc := proc);
  BEGIN
    LOCK mu DO views := RefList.Append(views, RefList.List1(viewInfo)) END
  END RegisterView;

PROCEDURE <A NAME="FindView"><procedure>FindView</procedure></A> (name: TEXT): INTEGER RAISES {NotFound} =
  VAR
    which := 0;
    rest  := views;
  BEGIN
    LOCK mu DO
      WHILE rest # NIL DO
        IF Text.Equal(name, NARROW(rest.head, ViewInfo).name) THEN
          RETURN which
        END;
        INC(which);
        rest := rest.tail
      END;
    END;
    RAISE NotFound;
  END FindView;

PROCEDURE <A NAME="NewView"><procedure>NewView</procedure></A> (which: INTEGER): View.T =
  VAR view: View.T;
  BEGIN
    LOCK mu DO
      IF which &gt;= RefList.Length(views) THEN RETURN NIL END;
      WITH viewInfo = NARROW(RefList.Nth(views, which), ViewInfo) DO
        view := viewInfo.proc();
        IF view # NIL THEN
          view.name := viewInfo.name;
          view.alertable := viewInfo.alertable
        END;
        RETURN view;
      END
    END;
  END NewView;

PROCEDURE <A NAME="SampleView"><procedure>SampleView</procedure></A> (which: INTEGER): View.T =
  BEGIN
    LOCK mu DO
      IF which &gt;= RefList.Length(views) THEN RETURN NIL END;
      WITH viewInfo = NARROW(RefList.Nth(views, which), ViewInfo) DO
        IF viewInfo.sample = NIL THEN
          viewInfo.sample := viewInfo.proc();
          viewInfo.sample.name := viewInfo.name;
          viewInfo.sample.alertable := viewInfo.alertable;
        END;
        RETURN viewInfo.sample;
      END
    END;
  END SampleView;

PROCEDURE <A NAME="ViewCount"><procedure>ViewCount</procedure></A> (): INTEGER =
  BEGIN
    LOCK mu DO RETURN RefList.Length(views) END
  END ViewCount;

BEGIN
END Classes.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
