<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/OSUtils.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/OSUtils.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> OSUtils.mod                                                 </EM></BLOCKQUOTE><PRE>
</PRE> Stolen from Postcard. 
 Much of the implementation was taken from Ted Wobber's FileSys.m3 

<P><PRE>UNSAFE MODULE <module><implements><A HREF="OSUtils.i3">OSUtils</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="#x1">Uerror</A>, <A HREF="#x2">Unix</A>, <A HREF="#x3">Ustat</A>;

FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char_star, int;
</PRE> 
 Internal subroutines; mostly intact from FileSys.m3 
 

<P><PRE>TYPE
  EC = CARDINAL;

PROCEDURE <A NAME="ErrorMessage"><procedure>ErrorMessage</procedure></A> (ec: EC): Text.T =
  VAR
    p: char_star;
  BEGIN
    IF ec &lt;= Uerror.Max THEN
      p := Uerror.GetFrom_sys_errlist(ec);
      RETURN M3toC.StoT(p);  (* assumes sys err list is static *)
    ELSE
      RETURN &quot;Error code &quot; &amp; Fmt.Int(ec);
    END;
  END ErrorMessage;

CONST
  rwMode = Ustat.S_IREAD + Ustat.S_IWRITE + Ustat.S_GREAD + Ustat.S_OREAD;
  rwxMode = rwMode + Ustat.S_IEXEC + Ustat.S_GEXEC + Ustat.S_OEXEC;
</PRE> 
 File system operations 
 

<P><PRE>PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(path: TEXT) RAISES { FileError } =
  VAR
    p: char_star := M3toC.TtoS(path);
    status: int;
  BEGIN
    status := Unix.unlink(p);
    IF status = -1 THEN
      RAISE FileError(ErrorMessage(Uerror.errno));
    END;
  END Delete;

PROCEDURE <A NAME="MakeDir"><procedure>MakeDir</procedure></A>(path: TEXT) RAISES { FileError } =
  VAR
    status: int;
    p := M3toC.TtoS(path);
  BEGIN
    status := Unix.mkdir(p, rwxMode);
    IF status = -1 THEN
      RAISE FileError(ErrorMessage(Uerror.errno));
    END;
  END MakeDir;

BEGIN
END OSUtils.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Uerror is in:
</A><UL>
<LI><A HREF="../../unix/src/aix-3-2/Uerror.i3#0TOP0">unix/src/aix-3-2/Uerror.i3</A>
<LI><A HREF="../../unix/src/aix-ps2-1-2/Uerror.i3#0TOP0">unix/src/aix-ps2-1-2/Uerror.i3</A>
<LI><A HREF="../../unix/src/freebsd-1/Uerror.i3#0TOP0">unix/src/freebsd-1/Uerror.i3</A>
<LI><A HREF="../../unix/src/freebsd-2/Uerror.i3#0TOP0">unix/src/freebsd-2/Uerror.i3</A>
<LI><A HREF="../../unix/src/hpux-7-0/Uerror.i3#0TOP0">unix/src/hpux-7-0/Uerror.i3</A>
<LI><A HREF="../../unix/src/ibm-4-3/Uerror.i3#0TOP0">unix/src/ibm-4-3/Uerror.i3</A>
<LI><A HREF="../../unix/src/irix-5.2/Uerror.i3#0TOP0">unix/src/irix-5.2/Uerror.i3</A>
<LI><A HREF="../../unix/src/linux/Uerror.i3#0TOP0">unix/src/linux/Uerror.i3</A>
<LI><A HREF="../../unix/src/osf-1.generic/Uerror.i3#0TOP0">unix/src/osf-1.generic/Uerror.i3</A>
<LI><A HREF="../../unix/src/solaris-2-x/Uerror.i3#0TOP0">unix/src/solaris-2-x/Uerror.i3</A>
<LI><A HREF="../../unix/src/sunos-4-x/Uerror.i3#0TOP0">unix/src/sunos-4-x/Uerror.i3</A>
<LI><A HREF="../../unix/src/sysv-4.0/Uerror.i3#0TOP0">unix/src/sysv-4.0/Uerror.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.generic/Uerror.i3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Unix is in:
</A><UL>
<LI><A HREF="../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Ustat is in:
</A><UL>
<LI><A HREF="../../unix/src/aix-3-2/Ustat.i3#0TOP0">unix/src/aix-3-2/Ustat.i3</A>
<LI><A HREF="../../unix/src/aix-ps2-1-2/Ustat.i3#0TOP0">unix/src/aix-ps2-1-2/Ustat.i3</A>
<LI><A HREF="../../unix/src/freebsd-1/Ustat.i3#0TOP0">unix/src/freebsd-1/Ustat.i3</A>
<LI><A HREF="../../unix/src/freebsd-2/Ustat.i3#0TOP0">unix/src/freebsd-2/Ustat.i3</A>
<LI><A HREF="../../unix/src/hpux-7-0/Ustat.i3#0TOP0">unix/src/hpux-7-0/Ustat.i3</A>
<LI><A HREF="../../unix/src/ibm-4-3/Ustat.i3#0TOP0">unix/src/ibm-4-3/Ustat.i3</A>
<LI><A HREF="../../unix/src/irix-5.2/Ustat.i3#0TOP0">unix/src/irix-5.2/Ustat.i3</A>
<LI><A HREF="../../unix/src/linux/Ustat.i3#0TOP0">unix/src/linux/Ustat.i3</A>
<LI><A HREF="../../unix/src/osf-1.generic/Ustat.i3#0TOP0">unix/src/osf-1.generic/Ustat.i3</A>
<LI><A HREF="../../unix/src/solaris-2-x/Ustat.i3#0TOP0">unix/src/solaris-2-x/Ustat.i3</A>
<LI><A HREF="../../unix/src/sunos-4-x/Ustat.i3#0TOP0">unix/src/sunos-4-x/Ustat.i3</A>
<LI><A HREF="../../unix/src/sysv-4.0/Ustat.i3#0TOP0">unix/src/sysv-4.0/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.AP3000/Ustat.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.ARM/Ustat.i3#0TOP0">unix/src/ultrix-3-1.ARM/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.DS3100/Ustat.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.NEXT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SEQUENT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN3/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN386/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.UMAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Ustat.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.VAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.VAX/Ustat.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
