<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/TracedAlg.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/TracedAlg.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="TracedAlg.i3">TracedAlg</A></implements></module>;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, List, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="Zeus.i3">Zeus</A>, <A HREF="ZeusClass.i3">ZeusClass</A>, <A HREF="ZeusPanel.i3">ZeusPanel</A>;

REVEAL
  <A NAME="T">T</A> = Algorithm.T BRANDED OBJECT
  OVERRIDES
    install := Install;
    delete := Delete;
    snapshot := Snapshot;
    restore := Restore;
    config := Config;
    startrun := Startrun;
    endrun := Endrun;
    run := Run;
    data := Data;
  END;

PROCEDURE <A NAME="Install"><procedure>Install</procedure></A> (&lt;* UNUSED *&gt; alg: T) =
  BEGIN Trace (&quot;install&quot;) END Install;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A> (&lt;* UNUSED *&gt; alg: T) =
  BEGIN Trace (&quot;delete&quot;) END Delete;

PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (&lt;* UNUSED *&gt; alg: T; &lt;* UNUSED *&gt; wr: Wr.T) =
  BEGIN Trace (&quot;snapshot&quot;) END Snapshot;

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (&lt;* UNUSED *&gt; alg: T; &lt;* UNUSED *&gt; l: List.T) =
  BEGIN Trace (&quot;restore&quot;) END Restore;

PROCEDURE <A NAME="Config"><procedure>Config</procedure></A> (
    &lt;* UNUSED *&gt; alg: T;
    &lt;* UNUSED *&gt; state: ZeusClass.StateChange;
    &lt;* UNUSED *&gt; o: ZeusClass.T) =
  BEGIN Trace (&quot;config&quot;) END Config;

PROCEDURE <A NAME="Startrun"><procedure>Startrun</procedure></A> (&lt;* UNUSED *&gt; alg: T) =
  BEGIN Trace (&quot;startrun&quot;) END Startrun;

PROCEDURE <A NAME="Endrun"><procedure>Endrun</procedure></A> (&lt;* UNUSED *&gt; alg: T) =
  BEGIN Trace (&quot;endrun&quot;) END Endrun;

PROCEDURE <A NAME="Run"><procedure>Run</procedure></A> (&lt;* UNUSED *&gt; alg: T) RAISES {Thread.Alerted} =
  BEGIN Trace (&quot;run&quot;) END Run;

PROCEDURE <A NAME="Data"><procedure>Data</procedure></A> (&lt;* UNUSED *&gt; alg: T): VBT.T =
  BEGIN Trace (&quot;data&quot;); RETURN NIL END Data;

PROCEDURE <A NAME="Trace"><procedure>Trace</procedure></A> (t: TEXT) =
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    LOCK Zeus.stdoutMu DO
      Wr.PutText (Stdio.stdout, &quot;alg: &quot; &amp; t &amp; &quot;\n&quot;);
      Wr.Flush (Stdio.stdout);
    END
  END Trace;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): Algorithm.T =
  BEGIN RETURN NEW(T) END New;

BEGIN
  ZeusPanel.RegisterAlg (New, &quot;Traced Alg&quot;)
END TracedAlg.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
