<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/View.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/View.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="View.m3">View</A></interface>;

IMPORT <A HREF="../../lego/src/ReactivityVBT.i3">ReactivityVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="ZeusClass.i3">ZeusClass</A>;
</PRE> A View.T is a subclass of a ZeusClass.T with four additional
   methods: 

<P> init(ch) inserts the <CODE>ch</CODE> argument as the child of the View.T (which is
   a ReactivityVBT.T), sets the reactivity to Passive, and returns the
   View.T. If <CODE>ch</CODE> is <CODE>NIL</CODE>, then a child is created that displays 
   the background. The init() method should be called just after the View.T is
   created.  Any user-supplied override to the init method must invoke the
   init method of the supertype. 

<P> isCompat(alg) is called by ZeusPanel to determine whether the view is
   compatible with a particular algorithm.  Compatibility means that the
   view is prepared to display the events that the algorithm generates.
   This method generally just calls ISTYPE; the user should not have to
   override it except under unusual circumstances. 

<P> startrun(v) is called by ZeusPanel just after the user issues the
   command to start running the algorithm, and before the algorithm is
   actually run.  Many subclasses will override the <CODE>startrun</CODE> method to
   erase anything in the window left over from the previous execution of
   the algorithm.  If a view's startrun procedure is called, ZeusPanel
   guarantees that its endrun procedure will eventually be called. 

<P> endrun(v) is called by ZeusPanel just after the algorithm finishes
   running, either because it was aborted by the user, it crashed, or it
   came to a normal completion.  Typically, it is used by views to <CODE>clean
   up</CODE> after themselves -- to kill any active threads, etc.  An endrun
   method will only be called if its startrun method had been called
   previously. 

<P> The default ZeusClass <CODE>config</CODE> method is a noop.  The other ZeusClass
   methods have the following defaults:
<P>
   <CODE>install</CODE> tells Trestle to insert self into the window system,
             but not to put self on the screen; restore will be called
             immediately after install, and will do that.
<P>
   <CODE>delete</CODE> tells Trestle to delete self from the window system
<P>
   <CODE>snapshot</CODE> records location of Trestle window
<P>
   <CODE>restore</CODE> installs and moves self to a previously recorded location
<P>
   <CODE>reactivity</CODE> calls ReactivityVBT.Set to make the view Passive or Active.
             The view is made Dormant whenever it is incompatible with
             the current algorithm, and in this case the reactivity method
             has no effect.
<P>
   Subclasses of View.T that are created by zume will be extended with
   methods for each OUTPUT event and UPDATE event in the .evt file.  The
   output methods are invoked with LL &lt; VBT.mu.  Update methods (which are
   called in response to a feedback event) are invoked with LL = VBT.mu.
   User-supplied overrides for OUTPUT and UPDATE methods MUST NOT invoke
   the corresponding supertype methods. 

<P><PRE>REVEAL
   ZeusClass.Private &lt;: ReactivityVBT.T;

TYPE
  <A HREF="View.m3#T">T</A> &lt;: Public;
  Public = ZeusClass.T OBJECT
           METHODS
             (* LL = VBT.mu *)
             init (ch: VBT.T): T;
             isCompat (alg: ZeusClass.T): BOOLEAN;
             (* LL &lt; VBT.mu *)
             startrun ();
             endrun   ();
           END;

END View.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
