<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/View.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/View.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>View</module> EXPORTS <A HREF="View.i3"><implements>View</A></implements>, <A HREF="ViewClass.i3"><implements>ViewClass</A></implements>;
&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>,
       <A HREF="../../lego/src/ReactivityVBT.i3">ReactivityVBT</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/split/StableVBT.i3">StableVBT</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="ZeusClass.i3">ZeusClass</A>,
       <A HREF="ZeusPanelFriends.i3">ZeusPanelFriends</A>, <A HREF="ZeusUtil.i3">ZeusUtil</A>;

REVEAL
  <A NAME="T">T</A> = ViewClass.TT BRANDED OBJECT
      OVERRIDES
        init       := DefaultInit;
        isCompat   := DefaultIsCompat;
        install    := DefaultInstall;
        delete     := DefaultDelete;
        snapshot   := DefaultSnapshot;
        restore    := DefaultRestore;
        startrun   := DefaultStartrun;
        endrun     := DefaultEndrun;
        reactivity := DefaultReactivity;
      END;

TYPE
  Waiter =
    Thread.Closure OBJECT v: T;  OVERRIDES apply := WaiterThread; END;

&lt;*FATAL TrestleComm.Failure, Wr.Failure, Thread.Alerted *&gt;

PROCEDURE <A NAME="DefaultInit"><procedure>DefaultInit</procedure></A> (v: T; ch: VBT.T): T =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    v.evtCond := NEW(Thread.Condition);
    IF ch = NIL THEN ch := TextureVBT.New(PaintOp.Bg) END;
    EVAL ReactivityVBT.T.init(v, ch);
    RETURN v;
  END DefaultInit;

PROCEDURE <A NAME="Activate"><procedure>Activate</procedure></A>(v: T; on: BOOLEAN) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IF on THEN
      v.reactivity(FALSE);
    ELSE
      ReactivityVBT.Set(v, ReactivityVBT.State.Dormant, cursor)
    END;
  END Activate;

PROCEDURE <A NAME="DefaultIsCompat"><procedure>DefaultIsCompat</procedure></A> (&lt;*UNUSED*&gt; v: T; alg: ZeusClass.T): BOOLEAN =
  BEGIN
    RETURN ISTYPE(alg, Algorithm.T)
  END DefaultIsCompat;

PROCEDURE <A NAME="DefaultInstall"><procedure>DefaultInstall</procedure></A> (v: T) =
&lt;* LL = VBT.mu *&gt;
  BEGIN
    v.reactivity(FALSE);
    Trestle.Attach (v);
    Trestle.Decorate (v, applName := &quot;Zeus View&quot;, windowTitle := v.name);
    EVAL Thread.Fork(NEW(Waiter, v := v));
  END DefaultInstall;

PROCEDURE <A NAME="WaiterThread"><procedure>WaiterThread</procedure></A> (waiter: Waiter): REFANY RAISES {} =
&lt;* LL = {} *&gt;
  BEGIN
    WITH v = waiter.v DO
      Trestle.AwaitDelete (v);
      LOCK VBT.mu DO
        ZeusPanelFriends.DetachView (v);
        VBT.Discard (v);
      END
    END;
    RETURN NIL
  END WaiterThread;

PROCEDURE <A NAME="DefaultDelete"><procedure>DefaultDelete</procedure></A> (v: T) =
&lt;* LL = VBT.mu *&gt;
  BEGIN
    Trestle.Delete (v);
  END DefaultDelete;

PROCEDURE <A NAME="DefaultSnapshot"><procedure>DefaultSnapshot</procedure></A> (v: T; wr: Wr.T) =
&lt;* LL = VBT.mu *&gt;
  VAR
    dom := VBT.Domain(v);
    nw  := Trestle.ScreenOf(v, Rect.NorthWest(dom));
    se  := Trestle.ScreenOf(v, Rect.SouthEast(dom));
  BEGIN
    IF nw.id # Trestle.NoScreen THEN
      Wr.PutText(wr, &quot;(ScreenPos &quot; &amp; Fmt.Int(nw.id) &amp; &quot; &quot; &amp; Fmt.Int(nw.q.h)
                       &amp; &quot; &quot; &amp; Fmt.Int(nw.q.v) &amp; &quot; &quot; &amp; Fmt.Int(se.q.h)
                       &amp; &quot; &quot; &amp; Fmt.Int(se.q.v) &amp; &quot;)\n&quot;);
    ELSE
      Wr.PutText(wr, &quot;()\n&quot;);
    END;
  END DefaultSnapshot;

PROCEDURE <A NAME="DefaultRestore"><procedure>DefaultRestore</procedure></A> (v: T; rd: Rd.T)
  RAISES {ZeusClass.Error} =
  &lt;* LL = VBT.mu *&gt;
  VAR
    id    : Trestle.ScreenID;
    nw, se: Point.T;
    list  := ZeusUtil.RdToList(rd);
  PROCEDURE NarrowToInt (a: REFANY): INTEGER
    RAISES {ZeusClass.Error} =
    BEGIN
      TYPECASE a OF
      | REF INTEGER (ri) =&gt; RETURN ri^;
      ELSE
        RAISE ZeusClass.Error(
                &quot;NARROW failed in View.DefaultRestore&quot;);
      END;
    END NarrowToInt;
  BEGIN
    IF list = NIL THEN
      Trestle.MoveNear(v, NIL);
    ELSE
      IF RefList.Length(list) # 6 THEN
        RAISE
          ZeusClass.Error(&quot;View.DefaultRestore: bad ScreenPos&quot;);
      END;
      TRY
        ZeusUtil.KeywordCheck(list, &quot;ScreenPos&quot;)
      EXCEPT
        ZeusUtil.BadSnapshot (msg) =&gt;
          RAISE ZeusClass.Error(
                  &quot;View.DefaultRestore: bad ScreenPos: &quot; &amp; msg);
      END;
      EVAL RefListUtils.Pop(list);      (* first elem is ScreenPos *)
      id := NarrowToInt(RefListUtils.Pop(list));
      nw.h :=
        NarrowToInt(RefListUtils.Pop(list)) - ZeusPanelFriends.XDRIFT;
      nw.v :=
        NarrowToInt(RefListUtils.Pop(list)) - ZeusPanelFriends.YDRIFT;
      se.h :=
        NarrowToInt(RefListUtils.Pop(list)) - ZeusPanelFriends.XDRIFT;
      se.v :=
        NarrowToInt(RefListUtils.Pop(list)) - ZeusPanelFriends.YDRIFT;
      StableVBT.SetShape(v, ABS(se.h - nw.h), ABS(se.v - nw.v));
      IF ZeusUtil.ScreenPosOK(id, nw) THEN
        Trestle.Overlap(v, id, nw);
      ELSE
        Trestle.MoveNear(v, NIL);
      END;
    END;
  END DefaultRestore;

PROCEDURE <A NAME="DefaultStartrun"><procedure>DefaultStartrun</procedure></A> (&lt;*UNUSED*&gt;v: T) =
&lt;* LL = {} *&gt;
  BEGIN
    (* should the default method repaint the VBT with the bg color? *)
  END DefaultStartrun;

PROCEDURE <A NAME="DefaultEndrun"><procedure>DefaultEndrun</procedure></A> (&lt;*UNUSED*&gt; v: T) =
&lt;* LL = {} *&gt;
  BEGIN
  END DefaultEndrun;

PROCEDURE <A NAME="DefaultReactivity"><procedure>DefaultReactivity</procedure></A> (v: T; on: BOOLEAN) =
  &lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    (* The following test should not be necessary; call the reactivity
       method only when the view isCompat with the algorithm. *)
    (* IF ReactivityVBT.Get(v) # ReactivityVBT.State.Dormant THEN *)
    IF on THEN
      ReactivityVBT.Set(v, ReactivityVBT.State.Active, Cursor.DontCare);
    ELSE
      ReactivityVBT.Set(v, ReactivityVBT.State.Passive, cursor);
    END;
  END DefaultReactivity;

VAR cursor: Cursor.T;

BEGIN
 cursor := Cursor.FromName(ARRAY OF TEXT{&quot;XC_iron_cross&quot;});
END View.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
