<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/Zeus.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/Zeus.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>Zeus</module> EXPORTS <A HREF="Zeus.i3"><implements>Zeus</A></implements>, <A HREF="ZeusPrivate.i3"><implements>ZeusPrivate</A></implements>;
&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../mg/src/Animate.i3">Animate</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="ZeusClass.i3">ZeusClass</A>, <A HREF="ZeusCodeView.i3">ZeusCodeView</A>;
</PRE><BLOCKQUOTE><EM> IMPORT FormsVBT, List, MethodList, Rsrc, Text, Thread, Trestle, VBT;</EM></BLOCKQUOTE><PRE>

REVEAL
  <A NAME="Session">Session</A> = PrivateSession BRANDED OBJECT
              rw       : INTEGER            := 0;
              m        : MUTEX;
              c        : Thread.Condition;
              initiator: ZeusClass.T        := NIL;
              (* who initiated current Edit, Notify, or Broadcast *)
              locked: BOOLEAN := FALSE; (* &quot;is editing lock held?&quot; *)
              lockedBy : ZeusClass.T;  (* valid only when locked = TRUE *)
              lockedMsg: TEXT;         (* valid only when locked = TRUE *)
              evtMu    : MUTEX;        (* for event dispatching LL &gt; VBT.mu *)
              evtCond  : Thread.Condition;
              evtViewCt: CARDINAL           := 0;
            OVERRIDES
              init := InitDefault;
              pre  := PreDefault;
              post := PostDefault;
            END;

TYPE
  Prop = REF RECORD zeus: Session END;

PROCEDURE <A NAME="InitDefault"><procedure>InitDefault</procedure></A>(zeus: Session): Session =
  BEGIN (* LL = arbitrary *)
    zeus.rw := 0;
    zeus.m := NEW(MUTEX);
    zeus.c := NEW(Thread.Condition);
    zeus.evtMu := NEW(MUTEX);
    zeus.evtCond := NEW(Thread.Condition);
    RETURN zeus
  END InitDefault;

PROCEDURE <A NAME="PreDefault"><procedure>PreDefault</procedure></A> (&lt;*UNUSED*&gt; zeus     : Session;
                      &lt;*UNUSED*&gt; initiator: ZeusClass.T;
                      &lt;*UNUSED*&gt; style    : EventStyle;
                      &lt;*UNUSED*&gt; priority : INTEGER;
                      &lt;*UNUSED*&gt; t        : TEXT         ) =
  BEGIN (* LL = arbitrary *)
  END PreDefault;

PROCEDURE <A NAME="PostDefault"><procedure>PostDefault</procedure></A> (&lt;*UNUSED*&gt; zeus     : Session;
                       &lt;*UNUSED*&gt; initiator: ZeusClass.T;
                       &lt;*UNUSED*&gt; style    : EventStyle;
                       &lt;*UNUSED*&gt; priority : INTEGER;
                       &lt;*UNUSED*&gt; t        : TEXT         ) =
  BEGIN (* LL = arbitrary *)
  END PostDefault;

PROCEDURE <A NAME="AttachAlg"><procedure>AttachAlg</procedure></A> (zeus: Session; alg: Algorithm.T) =
  BEGIN                         (* LL = VBT.mu *)
    AcquireExclusive(zeus);
    zeus.alg := alg;
    Mark(zeus, alg);
    ReleaseExclusive(zeus);
  END AttachAlg;

PROCEDURE <A NAME="AttachView"><procedure>AttachView</procedure></A> (zeus: Session; view: View.T) =
  BEGIN                         (* LL = VBT.mu *)
    AcquireExclusive(zeus);
    IF NOT RefList.Member(zeus.views, view) THEN
      RefListUtils.Push(zeus.views, view);
      Mark(zeus, view);
      LOCK zeus.evtMu DO
        view.evtArg := NEW(ViewEvtRec, zeus := zeus);
        view.evtHandler := Thread.Fork(NEW(ViewClosure, view := view));
        WakeView(zeus, view);
        Thread.Wait(zeus.evtMu, zeus.evtCond);
      END;
      Configure(zeus, ZeusClass.StateChange.ViewAttached, view);
    END;
    ReleaseExclusive(zeus);
  END AttachView;

PROCEDURE <A NAME="DetachView"><procedure>DetachView</procedure></A> (view: View.T) =
  VAR zeus := Resolve(view);
  BEGIN                         (* LL = VBT.mu *)
    IF zeus = NIL THEN RETURN  END;
    AcquireExclusive (zeus);
    IF RefList.Member (zeus.views, view) THEN
      IF view.evtHandler # NIL THEN
        view.evtHQuit := TRUE;
        Thread.Alert(view.evtHandler)
      END;
      RefListUtils.Delete (zeus.views, view);
      VBT.RemProp (view, TYPECODE (Prop));
      Configure (zeus, ZeusClass.StateChange.ViewDetached, view);
    END;
    ReleaseExclusive (zeus);
  END DetachView;
</PRE>    (* Not converted to M3 
<PRE>PROCEDURE Destroy(zeus: Session) RAISES {};
  VAR
    cl:   Private;
    rest: RefList.T;
    view: ZeusClass.T;
  BEGIN
    cl := zeus^.private;
    AcquireExclusive(cl);
    rest := zeus^.views;
    WHILE rest # NIL DO
      view := NARROW(rest^.first, ZeusClass.T);
      MethodList.Clear(view, TYPECODE(Session));
      rest := rest^.tail;
    END;
    MethodList.Clear(alg, TYPECODE(Session));
    zeus^.views := NIL;
    zeus^.alg   := NIL;
    ReleaseExclusive(cl);
  END Destroy;
*)

PROCEDURE <A NAME="Initiator"><procedure>Initiator</procedure></A> (zeus: Session): ZeusClass.T=
  BEGIN                         (* LL = VBT.mu *)
    RETURN zeus.initiator;
  END Initiator;

PROCEDURE <A NAME="Mark"><procedure>Mark</procedure></A> (zeus: Session; v: ZeusClass.T) =
  BEGIN                         (* LL = VBT.mu *)
    WITH prop = NEW(Prop) DO
      prop.zeus := zeus;
      VBT.PutProp(v, prop);
    END
  END Mark;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (v: ZeusClass.T): Session =
  BEGIN                         (* LL = VBT.mu *)
    WITH prop = NARROW(VBT.GetProp(v, TYPECODE(Prop)), Prop) DO
      IF prop = NIL THEN RETURN NIL ELSE RETURN prop.zeus END
    END
  END Resolve;

PROCEDURE <A NAME="AlertViews"><procedure>AlertViews</procedure></A> (zeus: Session) =
  &lt;* LL = arbitrary *&gt;
  (* Send an alert to any view of this zeus session that has registered
     itself as alertable. *)
  VAR rest: RefList.T;
  BEGIN
    AcquireShared(zeus);
    rest := zeus.views;
    WHILE rest # NIL DO
      WITH v = NARROW(RefListUtils.Pop(rest), View.T) DO
        IF v.alertable THEN Thread.Alert(v.evtHandler) END;
      END;
    END;
    ReleaseShared(zeus);
  END AlertViews;
</PRE> **** Synchronizing Editing Actions **** 

<P><PRE>PROCEDURE <A NAME="Lock"><procedure>Lock</procedure></A> (zeus: Session; view: View.T; msg: TEXT): BOOLEAN =
  BEGIN                         (* LL = VBT.mu *)
    IF zeus.locked THEN
      RETURN FALSE;
    ELSE
      zeus.locked := TRUE;
      zeus.lockedBy := view;
      zeus.lockedMsg := msg;
      Configure(zeus, ZeusClass.StateChange.LockedBy, view);
      RETURN TRUE;
    END;
  END Lock;

PROCEDURE <A NAME="Unlock"><procedure>Unlock</procedure></A> (zeus: Session; view: View.T): BOOLEAN =
  BEGIN                         (* LL = VBT.mu *)
    IF (NOT zeus.locked) OR (zeus.lockedBy # view) THEN
      RETURN FALSE;
    ELSE
      zeus.locked := FALSE;
      Configure(zeus, ZeusClass.StateChange.UnlockedBy, view);
      RETURN TRUE;
    END;
  END Unlock;

PROCEDURE <A NAME="LockInfo"><procedure>LockInfo</procedure></A>(zeus: Session; VAR view: View.T; VAR msg: TEXT): BOOLEAN =
  BEGIN                         (* LL = VBT.mu *)
      IF  NOT zeus.locked THEN
        RETURN FALSE;
      ELSE
        view := zeus.lockedBy;
        msg := zeus.lockedMsg;
        RETURN TRUE;
      END;
  END LockInfo;

PROCEDURE <A NAME="IsLocked"><procedure>IsLocked</procedure></A> (zeus: Session): BOOLEAN =
  BEGIN                         (* LL = VBT.mu *)
    RETURN zeus.locked
  END IsLocked;

PROCEDURE <A NAME="CheckLock"><procedure>CheckLock</procedure></A> (zeus: Session; &lt;*UNUSED*&gt; initiator: ZeusClass.T)
  RAISES {Locked} =
  BEGIN                         (* LL = VBT.mu *)
    IF zeus.locked AND (zeus.lockedBy # zeus.initiator) THEN
      RAISE Locked(&quot;View is read-only -- &quot; &amp; zeus.lockedMsg);
    END;
  END CheckLock;
</PRE> **** Dispatching Events **** 

<P><PRE>PROCEDURE <A NAME="Dispatch"><procedure>Dispatch</procedure></A> (initiator   : ZeusClass.T;
                    style       : EventStyle;
                    priority    : INTEGER;
                    eventName   : TEXT;
                    dispatchProc: DispatchProc;
                    evtArgs     : REFANY        )
  RAISES {Error, Locked, Thread.Alerted} =
  (* If style = EventStyle.Broadcast, EventStyle.Output, or
     EventStyle.Code, then LL = {}.  Otherwise LL = VBT.mu *)
  VAR zeus := Resolve(initiator);
  BEGIN
    IF style # EventStyle.Broadcast THEN
      zeus.pre(initiator, style, priority, eventName)
    END;
    Animate.ResetATime();
    TRY
      CASE style OF
      | EventStyle.Output, EventStyle.Update =&gt;
          AlgToViews(zeus, initiator, dispatchProc, evtArgs);

      | EventStyle.Edit, EventStyle.Notify =&gt;
          IF style = EventStyle.Edit THEN CheckLock(zeus, initiator) END;
          ViewToAlg(zeus, initiator, dispatchProc, evtArgs);

      | EventStyle.Broadcast =&gt;
          ViewToAlg(zeus, initiator, dispatchProc, evtArgs);
          AlgToViews(zeus, initiator, dispatchProc, evtArgs);

      | EventStyle.Code =&gt;
          AlgToCodeViews(zeus, initiator, dispatchProc, evtArgs);

      END;
    FINALLY
      IF (style # EventStyle.Broadcast) THEN
        zeus.post(initiator, style, priority, eventName)
      END;
    END;
  END Dispatch;

TYPE
  ViewClosure = Thread.Closure OBJECT
                  view: View.T;
                OVERRIDES
                  apply := ViewThread;
                END;

  ViewEvtRec = REF RECORD
                     zeus  : Session;
                     proc  : DispatchProc;
                     args  : REFANY;
                     errVal: REFANY;
                   END;

PROCEDURE <A NAME="AlgToViews"><procedure>AlgToViews</procedure></A> (zeus        : Session;
                      initiator   : ZeusClass.T;
                      dispatchProc: DispatchProc;
                      evtArgs     : REFANY        ) RAISES {Error} =
  &lt;* LL &lt;= VBT.mu *&gt;
  VAR
    rest, rest2: RefList.T;
    myview     : View.T;
    errorVal   : REFANY;
    ct                  := 0;
  BEGIN
    AcquireShared(zeus);         (* is this needed?  something stronger? *)
    rest := zeus.views;
    rest2 := rest;
    ReleaseShared(zeus);
    LOCK zeus.evtMu DO
      zeus.evtWasHandled := FALSE;
      zeus.evtViewCt := 0;
      WHILE rest # NIL DO
        myview := NARROW(RefListUtils.Pop(rest), View.T);
        IF myview.isCompat(initiator) THEN
          INC(ct);
          myview.evtHandled := TRUE;
          WITH rec = NARROW(myview.evtArg, ViewEvtRec) DO
            rec.proc := dispatchProc;
            rec.args := evtArgs;
          END;
          WakeView(zeus, myview);
        END;
      END;
      rest := rest2;
      IF ct # 0 THEN Thread.Wait(zeus.evtMu, zeus.evtCond); END;
      WHILE rest # NIL DO
        myview := NARROW(RefListUtils.Pop(rest), View.T);
        IF myview.isCompat(initiator) THEN
          IF myview.evtHandled THEN zeus.evtWasHandled := TRUE END;
          WITH rec = NARROW(myview.evtArg, ViewEvtRec) DO
            IF (rec.errVal # NIL) AND (errorVal = NIL) THEN
              errorVal := rec.errVal;
            END;
          END;
        END;
      END;
    END;
    IF errorVal # NIL THEN RAISE Error(errorVal); END;
  END AlgToViews;

PROCEDURE <A NAME="ViewThread"><procedure>ViewThread</procedure></A> (self: ViewClosure): REFANY =
  BEGIN
    WITH v   = self.view,
         rec = NARROW(v.evtArg, ViewEvtRec) DO
      TRY
        WHILE TRUE DO
          WakeZeusAndSleep(rec.zeus, v);
          TRY
            rec.errVal := NIL;
            rec.proc(v, rec.args);
          EXCEPT
          | Thread.Alerted =&gt; IF v.evtHQuit THEN RETURN NIL END;
          END;
        END;
      EXCEPT
      | Thread.Alerted =&gt;
        &lt;* ASSERT v.evtHQuit *&gt;
        (* WakeZeusAndSleep raises Alerted only when v.evtHQuit *)
      END;
    END;
    RETURN NIL;
  END ViewThread;

PROCEDURE <A NAME="WakeView"><procedure>WakeView</procedure></A> (zeus: Session; view: View.T) =
  (* LL = {zeus.evtMu} *)
  BEGIN
    INC(zeus.evtViewCt);
    Thread.Signal(view.evtCond);
  END WakeView;

PROCEDURE <A NAME="WakeZeusAndSleep"><procedure>WakeZeusAndSleep</procedure></A> (zeus: Session; view: View.T)
  RAISES {Thread.Alerted} =
  (* LL = {} *)
  BEGIN
    LOCK zeus.evtMu DO
      DEC(zeus.evtViewCt);
      IF zeus.evtViewCt = 0 THEN Thread.Signal(zeus.evtCond) END;
      LOOP
        TRY
          Thread.AlertWait(zeus.evtMu, view.evtCond);
          RETURN;
        EXCEPT
          Thread.Alerted =&gt; IF view.evtHQuit THEN RAISE Thread.Alerted END;
        END;
      END;
    END;
  END WakeZeusAndSleep;

PROCEDURE <A NAME="ViewToAlg"><procedure>ViewToAlg</procedure></A> (zeus        : Session;
                     initiator   : ZeusClass.T;
                     dispatchProc: DispatchProc;
                     evtArgs     : REFANY        ) RAISES {Error} =
  (* LL &lt;= VBT.mu *) (* ? *)
  VAR errorVal: REFANY;
  BEGIN
    AcquireShared(zeus);
    zeus.initiator := initiator;
    TRY
      TRY
        zeus.alg.evtHandled := TRUE;    (* default fe methods set it FALSE *)
        dispatchProc(zeus.alg, evtArgs);
        zeus.evtWasHandled := zeus.alg.evtHandled;
      EXCEPT
      | Thread.Alerted =&gt;  (* shouldn't happen *)
      END;
    FINALLY
      zeus.initiator := NIL;
      ReleaseShared(zeus);
    END;
    IF errorVal # NIL THEN RAISE Error(errorVal); END;
  END ViewToAlg;

PROCEDURE <A NAME="AlgToCodeViews"><procedure>AlgToCodeViews</procedure></A> (           zeus        : Session;
                                     initiator   : ZeusClass.T;
                          &lt;*UNUSED*&gt; dispatchProc: DispatchProc;
                                     evtArgs     : REFANY        ) =
  VAR
    rest: RefList.T;
    arg          := NARROW(evtArgs, ZeusCodeView.Arg);
  BEGIN                          (* LL = {} *)
    AcquireShared(zeus);
    rest := zeus.views;
    ReleaseShared(zeus);
    zeus.evtWasHandled := FALSE;
    WHILE rest # NIL DO
      TYPECASE RefListUtils.Pop(rest) OF
      | ZeusCodeView.T (myview) =&gt;
          IF myview.isCompat(initiator) THEN
            zeus.evtWasHandled := TRUE;
            LOCK VBT.mu DO
              myview.cv.event(arg.highlight, 0, arg.procedureName);
            END;
          END;
      ELSE
      END;
    END;
  END AlgToCodeViews;
</PRE> **** Utilities **** 

<P><PRE>PROCEDURE <A NAME="Configure"><procedure>Configure</procedure></A> (zeus       : Session;
                     whatChanged: ZeusClass.StateChange;
                     instigator : ZeusClass.T            ) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    rest: RefList.T;
    view: View.T;
  BEGIN
    zeus.alg.config(whatChanged, instigator);
    rest := zeus.views;
    WHILE rest # NIL DO
      view := NARROW(rest.head, View.T);
      view.config(whatChanged, instigator);
      rest := rest.tail;
    END;
  END Configure;
</PRE> **** Reader/Writer **** 

<P><PRE>PROCEDURE <A NAME="Acquire"><procedure>Acquire</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    AcquireShared (zeus);
  END Acquire;

PROCEDURE <A NAME="Release"><procedure>Release</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    ReleaseShared (zeus);
  END Release;
</PRE> The following implements a simple reader/writer scheme. 
   See SPwM3, p103. Alternatively, track down Andrew Birrell. 

<P><PRE>PROCEDURE <A NAME="AcquireExclusive"><procedure>AcquireExclusive</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    LOCK zeus.m DO
      WHILE zeus.rw # 0 DO Thread.Wait (zeus.m, zeus.c) END;
      zeus.rw := -1;
    END
  END AcquireExclusive;

PROCEDURE <A NAME="AcquireShared"><procedure>AcquireShared</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    LOCK zeus.m DO
      WHILE zeus.rw &lt; 0 DO Thread.Wait (zeus.m, zeus.c) END;
      INC (zeus.rw)
    END
  END AcquireShared;

PROCEDURE <A NAME="ReleaseExclusive"><procedure>ReleaseExclusive</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    LOCK zeus.m DO
      zeus.rw := 0;
      Thread.Broadcast (zeus.c)
    END
  END ReleaseExclusive;

PROCEDURE <A NAME="ReleaseShared"><procedure>ReleaseShared</procedure></A> (zeus: Session) =
&lt;* LL &lt;= VBT.mu *&gt;
  BEGIN
    LOCK zeus.m DO
      DEC(zeus.rw);
      IF zeus.rw = 0 THEN Thread.Signal (zeus.c) END
    END
  END ReleaseShared;
</PRE> ****  Mainline  **** 

<P><PRE>BEGIN
  Thread.IncDefaultStackSize(10000);
  stdoutMu := NEW(MUTEX);
  stderrMu := NEW(MUTEX);
END Zeus.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
