<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The definition of the base class for Zeus algorithms and views. 

<P><PRE>INTERFACE <interface><A HREF="ZeusClass.m3">ZeusClass</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

EXCEPTION Error(TEXT);

TYPE
  <A HREF="ZeusClass.m3#T">T</A> &lt;: Public;
  <A HREF="ZeusClass.m3#Private">Private</A> &lt;: VBT.T;
  Public = Private OBJECT
           METHODS
             (* LL = VBT.mu *)
             install    ();
             delete     ();
             snapshot   (wr: Wr.T) RAISES {Error};
             restore    (rd: Rd.T) RAISES {Error};
             config     (state: StateChange; object: T);
             reactivity (on: BOOLEAN);
           END;

TYPE StateChange = {ViewAttached, ViewDetached, LockedBy, UnlockedBy};
</PRE> install(v) is called to attach to the WM all windows that v needs.
   This procedure should be called only once for each v.  Typically, this
   procedure will fork a thread to wait for the installed window(s) to be
   deleted.  At that time, it should perform any necessary cleanup (calling
   Zeus.DetachView before VBT.Discarding itself, if v is a <CODE>view,</CODE> e.g.).
<P>
   Special note:  install should NOT put windows on the screen.  The
   restore method will be called immediately after install, and will
   take care of putting up the windows. 

<P> delete(v) is called to delete from the WM all windows v has installed.
   This procedure will never be called more than once; if it is called, it
   is guaranteed that the install method was previously invoked.
<P>
   Note that there are two ways for v to be deleted: by the user issuing a
   delete command to the WM, or by invoking v's delete method (in response
   to some command in the control panel).  Thus any necessary cleanup
   should be performed by the thread that install() forks, rather than by
   the delete() method. 

<P> snapshot(v, wr) is called to snapshot the state of v as exactly one
   s-expression written into the supplied writer.  The state
   should include a description and location of any windows that v
   installs, any data it has gotten from the user, and so on. 

<P> restore(v, rd) is passed a reader positioned just before the
   s-expression that was written by v's snapshot method.  The restore
   method should restore the static state of v from this description.  This
   method and v's snapshot method should be inverses.
<P>
   A view's restore method should restore the positions of windows.
   The same is true for the restore method of an algorithm that installs
   windows.
<P>
   If the restore method is passed rd = NIL as an argument, it should
   restore the alg or view to its initial state, which in the case of a
   view means putting the windows on the screen in some default position. 

<P> config(v, whatChanged, instigator) is called by Zeus whenever Zeus's
   <CODE>configuration</CODE> changes.  A configuration change happens when a view is
   attached or detached, or a view has acquired or released the edit
   lock. 

<P> reactivity(v, on) is called by ZeusPanel to enable (on=TRUE) or disable
   (on=FALSE) feedback events.  It will be called when the algorithm
   pauses. 

<P>
<P> If a subtype overrides one or more of the default methods, the
   overriding method should call the method of the supertype. 
<PRE>END ZeusClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
