<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusClass.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusClass.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ZeusClass.i3">ZeusClass</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="ZeusUtil.i3">ZeusUtil</A>;
IMPORT <A HREF="../../lego/src/ReactivityVBT.i3">ReactivityVBT</A>;

REVEAL
   <A NAME="Private">Private</A> = ReactivityVBT.T BRANDED OBJECT END;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        install    := DefaultInstall;
        delete     := DefaultDelete;
        snapshot   := DefaultSnapshot;
        restore    := DefaultRestore;
        config     := DefaultConfig;
        reactivity := DefaultReactivity;
      END;

PROCEDURE <A NAME="DefaultInstall"><procedure>DefaultInstall</procedure></A> (&lt;*UNUSED*&gt; v: T) =
  BEGIN
  END DefaultInstall;

PROCEDURE <A NAME="DefaultDelete"><procedure>DefaultDelete</procedure></A> (&lt;*UNUSED*&gt; v: T) =
  BEGIN
  END DefaultDelete;

PROCEDURE <A NAME="DefaultSnapshot"><procedure>DefaultSnapshot</procedure></A> (&lt;*UNUSED*&gt; v: T; wr: Wr.T) RAISES {Error} =
  BEGIN
    TRY
      Wr.PutText(wr, &quot;()&quot;)
    EXCEPT
    ELSE
      RAISE Error(&quot;ZeusClass.DefaultSnapshot write error&quot;)
    END;
  END DefaultSnapshot;

PROCEDURE <A NAME="DefaultRestore"><procedure>DefaultRestore</procedure></A> (&lt;*UNUSED*&gt; v: T; rd: Rd.T)
  RAISES {Error} =
  BEGIN
    IF rd = NIL THEN RETURN END;
    IF NOT (ZeusUtil.EatChar(rd, '(') AND ZeusUtil.EatChar(rd, ')')) THEN
      RAISE Error(&quot;ZeusClass.DefaultRestore error&quot;)
    END;
  END DefaultRestore;

PROCEDURE <A NAME="DefaultConfig"><procedure>DefaultConfig</procedure></A> (&lt;*UNUSED*&gt; v: T;
                         &lt;*UNUSED*&gt; state: StateChange;
                         &lt;*UNUSED*&gt; object: T) =
  BEGIN
  END DefaultConfig;

PROCEDURE <A NAME="DefaultReactivity"><procedure>DefaultReactivity</procedure></A> (&lt;*UNUSED*&gt; v: T; &lt;*UNUSED*&gt; on: BOOLEAN) =
  BEGIN
  END DefaultReactivity;

BEGIN
END ZeusClass.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
