<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusCodeView.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusCodeView.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ZeusCodeView.T</CODE> is a subclass of a <CODE>View.T</CODE> with one
   additional field <CODE>cv</CODE>, which is a <CODE>CodeView.T</CODE>.  It
   encapsulates <CODE>CodeView.T</CODE> into the Zeus framework.  See
   <CODE>CodeView.i3</CODE> for details on using code views. 

<P><PRE>INTERFACE <interface><A HREF="ZeusCodeView.m3">ZeusCodeView</A></interface>;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="../../codeview/src/CodeView.i3">CodeView</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE
  <A HREF="ZeusCodeView.m3#T">T</A> &lt;: Public;
  Public = View.T OBJECT cv: CodeView.T END;

PROCEDURE <A HREF="ZeusCodeView.m3#New">New</A> (name   : TEXT;
               source : Rd.T;
               alg    : Algorithm.T;
               errorWr: Wr.T          := NIL;
               READONLY fontName := CodeView.DefaultFont;
               paneOffset: CARDINAL := 20;
               background: VBT.T    := NIL ): T;
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Creates and returns an initialized <CODE>T</CODE> with the given name,
   using <CODE>CodeView.New</CODE> with the last two arguments to create the
   <CODE>cv</CODE> field.  The <CODE>alg</CODE> argument is the algorithm for which
   this is a code view. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusCodeView.m3#Enter">Enter</A> (alg: Algorithm.T; procedureName: TEXT; pauseTime := -1)
  RAISES {Thread.Alerted};
&lt;* LL = {} *&gt;
</PRE><BLOCKQUOTE><EM> Indicates that procedure <CODE>procedureName</CODE> has been entered.  Causes a
   window to pop up containing the source for the procedure with the header
   highlighted. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusCodeView.m3#Exit">Exit</A> (alg: Algorithm.T; pauseTime := -1)
  RAISES {Thread.Alerted};
&lt;* LL = {} *&gt;
</PRE><BLOCKQUOTE><EM> Indicates that the current procedure is about to exit.  Its source
   window will be deleted.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusCodeView.m3#At">At</A> (alg: Algorithm.T; highlight := 0; pauseTime := -1)
  RAISES {Thread.Alerted};
&lt;* LL = {} *&gt;
</PRE><BLOCKQUOTE><EM> Highlights the region numbered <CODE>highlight</CODE>, indicating the current
   position within the procedure.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusCodeView.m3#Event">Event</A> (alg          : Algorithm.T;
                 highlight                    := 0;
                 pauseTime                    := -1;
                 procedureName: TEXT          := NIL )
  RAISES {Thread.Alerted};
&lt;* LL = {} *&gt;
</PRE><BLOCKQUOTE><EM> If <CODE>name # NIL</CODE>, invokes <CODE>Enter</CODE>.  If <CODE>highlight &lt; 0</CODE>, invokes <CODE>Exit</CODE>,
   otherwise invokes <CODE>At</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> For Zeus internal use: 

<P><PRE>TYPE
  Arg = REF RECORD (* argument of a code view event *)
              highlight           := 0;
              pauseTime           := -1;
              procedureName: TEXT := NIL
            END;

END ZeusCodeView.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
