<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusCodeView.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusCodeView.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ZeusCodeView.i3">ZeusCodeView</A></implements></module>;
&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../codeview/src/CodeView.i3">CodeView</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="Zeus.i3">Zeus</A>, <A HREF="ZeusClass.i3">ZeusClass</A>;

REVEAL View.T &lt;: ViewClass.TT;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        tc: CARDINAL;
      OVERRIDES
        isCompat := IsCompat;
        startrun := Startrun;
      END;

PROCEDURE <A NAME="IsCompat"><procedure>IsCompat</procedure></A> (v: T; alg: ZeusClass.T): BOOLEAN =
  &lt;* LL = arbitrary *&gt;
  BEGIN
    RETURN v.tc = TYPECODE(alg)
  END IsCompat;

PROCEDURE <A NAME="Startrun"><procedure>Startrun</procedure></A> (v: T) =
  &lt;* LL = {} *&gt;
  BEGIN
    LOCK VBT.mu DO v.cv.exitAll () END;
    View.T.startrun (v);
  END Startrun;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (name   : TEXT;
               source : Rd.T;
               alg    : Algorithm.T;
               errorWr: Wr.T := NIL;
               READONLY fontName := CodeView.DefaultFont;
               paneOffset: CARDINAL := 20;
               background: VBT.T    := NIL ): T =
  &lt;* LL = VBT.mu *&gt;
  (* Creates and returns an initialized T with the given name,
     using CodeView.New with the trailing arguments to create the
     cv field.  The alg argument is the algorithm for which this
     is a code view. *)
  VAR
    v := NEW(T, name := name,
             cv := CodeView.New(source, errorWr, fontName,
                                paneOffset, background),
             tc := TYPECODE(alg));
  BEGIN
    RETURN v.init(v.cv);
  END New;

PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A> (alg: Algorithm.T; procedureName: TEXT; pauseTime := -1)
  RAISES {Thread.Alerted} =
  &lt;* LL = {} *&gt;
  BEGIN
    Event (alg, 0, pauseTime, procedureName);
  END Enter;

PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (alg: Algorithm.T; pauseTime := -1)
  RAISES {Thread.Alerted} =
  &lt;* LL = {} *&gt;
  BEGIN
    Event (alg, -1, pauseTime, NIL);
  END Exit;

PROCEDURE <A NAME="At"><procedure>At</procedure></A> (alg: Algorithm.T; highlight := 0; pauseTime := -1)
  RAISES {Thread.Alerted} =
  &lt;* LL = {} *&gt;
  BEGIN
    Event (alg, highlight, pauseTime, NIL);
  END At;

PROCEDURE <A NAME="Event"><procedure>Event</procedure></A> (initiator    : Algorithm.T;
                 highlight                    := 0;
                 pauseTime                    := -1;
                 procedureName: TEXT          := NIL )
  RAISES {Thread.Alerted} =
  &lt;* LL = {} *&gt;
  &lt;* FATAL Zeus.Error, Zeus.Locked *&gt;
  (* Call this to create a code view event for alg &quot;initiator&quot;. *)
  VAR
    r := NEW (Arg, highlight := highlight, pauseTime := pauseTime,
              procedureName := procedureName);
  BEGIN
    initiator.stopAtEvent := initiator.stopatCodeEvents;
    initiator.waitAtEvent := initiator.waitatCodeEvents;
    (* Arguably, waitAtEvent should always be 0, and panel.delayTime should
       control the pause. *)
    IF initiator.waitAtEvent = 0 THEN r.pauseTime := 0 END;
    Zeus.Dispatch (initiator, Zeus.EventStyle.Code, 1, &quot;CodeView&quot;, NIL, r);
  END Event;

BEGIN
END ZeusCodeView.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
