<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusDataView.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusDataView.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ZeusDataView.i3">ZeusDataView</A></implements></module>;
&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../codeview/src/DataView.i3">DataView</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="Zeus.i3">Zeus</A>, <A HREF="ZeusClass.i3">ZeusClass</A>;

&lt;* FATAL Rd.Failure, Thread.Alerted, FormsVBT.Error *&gt;

REVEAL
  <A NAME="T">T</A> = View.T BRANDED OBJECT
        tc: CARDINAL;
        slate: TextVBT.T;
      OVERRIDES
        isCompat := IsCompat;
        startrun := Startrun;
        shape := Shape;
      END;

PROCEDURE <A NAME="IsCompat"><procedure>IsCompat</procedure></A> (&lt;* UNUSED *&gt; v: T; alg: ZeusClass.T):
  BOOLEAN =
  &lt;* LL = arbitrary *&gt;
  BEGIN
    RETURN NARROW(alg, Algorithm.T).varRsrc # NIL
  END IsCompat;

PROCEDURE <A NAME="Startrun"><procedure>Startrun</procedure></A> (view: T) =
  &lt;* LL.sup &lt; VBT.mu *&gt;
  &lt;* FATAL Rsrc.NotFound *&gt;
  VAR
    alg        := Zeus.Resolve(view).alg;
    ch : VBT.T;
  BEGIN
    LOCK VBT.mu DO
      (* This code is serialized among all data views.  Just
         before Zeus calls Startrun, it NILs alg.varView.  Thus,
         only the first data view whose Startrun executes will
         actually install the varRsrc form. *)
      IF alg.varRsrc = NIL THEN
        (*
        TextVBT.Put(view.slate,
          &quot;No variable-view form specified in this algorithm.&quot;);
        ch := view.slate;
        *)
        &lt;* ASSERT FALSE *&gt;
      ELSIF alg.varView # NIL THEN
        TextVBT.Put(
          view.slate,
          &quot;Another variable-view installed.&quot;);
        ch := view.slate;
      ELSE
        alg.varView :=
          NEW(DataView.T).initFromRsrc(alg.varRsrc, alg.varPath);
        ch := alg.varView;
      END;
      IF ch # Filter.Child(view) THEN
        EVAL Filter.Replace(view, ch)
      END
    END;
    View.T.startrun(view);
  END Startrun;

CONST
  DefaultShape =
     VBT.SizeRange{lo   := VBT.DefaultShape.lo,
                   pref := 300,
                   hi   := VBT.DefaultShape.hi};

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (&lt;* UNUSED *&gt; v   : VBT.T;
                 &lt;* UNUSED *&gt; axis: Axis.T;
                 &lt;* UNUSED *&gt; n   : CARDINAL): VBT.SizeRange =
  BEGIN
    RETURN DefaultShape
  END Shape;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): View.T =
  &lt;* LL.sup &lt;= VBT.mu *&gt;
  VAR ch := TextVBT.New (&quot;&quot;);
  BEGIN
    RETURN NEW (T, slate := ch).init (ch);
  END New;

BEGIN
END ZeusDataView.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
