<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusPanel.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusPanel.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;
</PRE> This interface provides a simple programmer interface for
   building algorithm animations, and provides a user interface
   for controlling the the selection of algorithms and views, and
   the execution of algorithms.
<P>
   For historical reasons, this interface is called <CODE>ZeusPanel</CODE>;
   the <CODE>Zeus</CODE> interface is at a lower-level than this interface;
   it is useful for creating multi-view editor applications, as
   well as an algorithm animation system. 

<P><PRE>INTERFACE <interface><A HREF="ZeusPanel.m3">ZeusPanel</A></interface>;

IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="View.i3">View</A>;

PROCEDURE <A HREF="ZeusPanel.m3#Interact">Interact</A> (
    title: TEXT := &quot;ZEUS Control Panel&quot;;
    path : Rsrc.Path := NIL);
&lt;* LL = 0 *&gt;
</PRE><BLOCKQUOTE><EM> Called once; doesn't return until the user deletes the control
   panel.  After installing a Zeus control panel in Trestle,
   tries to restore the state to the last time Zeus was exited
   (stored in StateDir) and then awaits user commands.  When the
   user deletes the control panel, either by a WM gesture or
   using the Quit button from the Zeus menu, Zeus tries to
   snapshot the state into StateDir before returning. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#GetPath">GetPath</A> (): Rsrc.Path;
&lt;* LL is arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return the <CODE>path</CODE> that was specified when <CODE>Interact</CODE> was
   called.  There is no way to change the path dynamically.  The
   path is mostly part of <CODE>ZeusPanel</CODE> as a convenience for
   application-writers to share a single path among multiple
   modules.  Also, it's used within <CODE>ZeusPanel</CODE> to open forms when
   <CODE>NewForm</CODE> is called. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#SetTitle">SetTitle</A> (title: TEXT);
&lt;* LL = 0 *&gt;
</PRE><BLOCKQUOTE><EM> Use <CODE>title</CODE> in the control panel's chassis.  Typically not
   called, since a title can be set with a parameter to
   <CODE>Interact</CODE>.  However, the title can be changed dynamically
   (for example, to reflect the name of the current algorithm or
   input). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#GetAnimationTime">GetAnimationTime</A> (): REAL;
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Returns the setting of the animation slider.  This is the
   amount of time that a ``one-second animation'' should take.
   By convention, each event takes one second. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#ReportError">ReportError</A> (text: TEXT);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Display the specified text as an error message in the control panel. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#ReportErrorC">ReportErrorC</A> (report: BOOLEAN; text: TEXT);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> IF report THEN ReportError(t) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#NewForm">NewForm</A> (name: TEXT; path: Rsrc.Path := NIL):
  FormsVBT.T;
&lt;* LL arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Returns a form stored in the resource <CODE>name</CODE> using the
   resource <CODE>path</CODE>.  However, if <CODE>path</CODE> is <CODE>NIL</CODE>, then it uses
   the value returned by <CODE>GetPath</CODE>.  It's a runtime error if
   there are any problems reading the form.  Most causal clients
   will read .fv files using this procedure. </EM></BLOCKQUOTE><PRE>

TYPE
  NewAlgProc = PROCEDURE (): Algorithm.T;

PROCEDURE <A HREF="ZeusPanel.m3#RegisterAlg">RegisterAlg</A> (proc: NewAlgProc; name, sessName: TEXT);
&lt;* LL=0 *&gt;
</PRE><BLOCKQUOTE><EM> Register an algorithm.  <CODE>name</CODE> is the name of the algorithm.  <CODE>sessName</CODE>
   is the name of the session to which the algorithm belongs, that is, the
   basename of the .evt file.  <CODE>proc</CODE> is a NewAlgProc, a procedure that
   returns an initialized instance of the algorithm.  This means that
   <CODE>proc</CODE> must call the init() method of the algorithm.  It is a checked
   runtime error if an algorithm with the same name has already been
   registered in the same session. </EM></BLOCKQUOTE><PRE>

TYPE
  NewViewProc = PROCEDURE (): View.T;

PROCEDURE <A HREF="ZeusPanel.m3#RegisterView">RegisterView</A> (proc          : NewViewProc;
                        name, sessName: TEXT;
                        alertable     : BOOLEAN       := FALSE;
                        sample        : View.T        := NIL    );
&lt;* LL=0 *&gt;
</PRE><BLOCKQUOTE><EM> Register a view.  <CODE>name</CODE> is the name of the view, and
   <CODE>sessName</CODE> is the name of the session to which the algorithm
   belongs, that is, the basename of the <CODE>.evt</CODE> file.  It is a
   checked runtime error if a view with the same name has already
   been registered in the same session. <CODE>proc</CODE> is a procedure
   that returns an initialized instance of the view.  This means
   that <CODE>proc</CODE> must call the <CODE>init</CODE> method of the view.  The
   <CODE>proc</CODE> can also return <CODE>NIL</CODE> to indicate that a new view could
   not be created for some reason (e.g., if the view uses a
   remote object that cannot be accessed).  In such cases, <CODE>proc</CODE>
   should display an error message to the user using
   <CODE>ZeusPanel.ReportError</CODE>.  If <CODE>alertable = TRUE</CODE>, then this
   view is willing to receive an alert as a signal to terminate
   the current event.  If <CODE>sample</CODE> is non-NIL, it is an
   unitialized instance of the view, passed in so the Zeus
   implementation can call its <CODE>isCompat</CODE> method.  Use this
   parameter if you don't want Zeus to create an uninstalled
   instance of the view, e.g., if <CODE>proc</CODE> has side effects like
   creating windows. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#SetSessTitle">SetSessTitle</A> (sessName, sessTitle: TEXT);
&lt;* LL=0 *&gt;
</PRE><BLOCKQUOTE><EM> The default title under which a session is listed in the <CODE>Sessions</CODE> menu
   is its name, that is, the basename of the .evt file.  Use this procedure
   to change the title of session <CODE>sessName</CODE> to <CODE>sessTitle.</CODE> This procedure
   creates a session named <CODE>sessName,</CODE> if none existed previously. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#Pause">Pause</A> (alg: Algorithm.T; msg: TEXT := NIL)
  RAISES {Thread.Alerted};
&lt;* LL=0, S=Running *&gt;
</PRE><BLOCKQUOTE><EM> This procedure may only be called from <CODE>alg</CODE>s run method.  It
   returns after the user issues a <CODE>Resume</CODE> or <CODE>Step</CODE> command, or
   it may raise Thread.Alerted (for instance, if the algorithm is
   aborted).  The <CODE>msg</CODE>, if non-<CODE>NIL</CODE>, is displayed in the
   control panel's status area. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#Abort">Abort</A>();
&lt;* LL=VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> This procedure acts as if the user had pressed the <CODE>Abort</CODE> button.
   Be careful: calling this procedure does not cause the algorithms to
   stop running immediately. The algorithms will stop the next time
   that Zeus gets control, which is typically the next time an event
   happens. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#StartFeedback">StartFeedback</A> (alg: Algorithm.T) RAISES {Thread.Alerted};
&lt;* LL=0, S=Running *&gt;
</PRE><BLOCKQUOTE><EM> This procedure may only be called from <CODE>alg</CODE>s run method.  It returns
   after <CODE>alg</CODE> has called EndFeedback or it may raise Thread.Alerted (for
   instance, if the algorithm is aborted).
<P>
   The effect of this procedure is to suspend the algorithm and allow
   feedback events (as if the user had clicked Pause).  When this procedure
   returns, the session continues under interpreter control (returns to the
   Running state).  This procedure is a noop if there already is a
   'pending' StartFeedback for this alg.
<P>
   StartFeedback calls the reactivity methods of the algorithm and views to
   enable and disable feedback events. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#EndFeedback">EndFeedback</A>(alg: Algorithm.T) RAISES {Thread.Alerted};
&lt;* LL=VBT.mu, S=Paused *&gt;
</PRE><BLOCKQUOTE><EM> This procedure signals a previous call to StartFeedback to return. 
   This procedure is typically called from an algorithm's Feedback 
   method. </EM></BLOCKQUOTE><PRE>

END ZeusPanel.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
