<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusPanel.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusPanel.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA LL *&gt;

MODULE <module>ZeusPanel</module> EXPORTS <A HREF="ZeusPanel.i3"><implements>ZeusPanel</A></implements>, <A HREF="ZeusPanelFriends.i3"><implements>ZeusPanelFriends</A></implements>, <A HREF="ZeusPanelPrivate.i3"><implements>ZeusPanelPrivate</A></implements>;

IMPORT <A HREF="AlbumVBT.i3">AlbumVBT</A>, <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../mg/src/Animate.i3">Animate</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="Classes.i3">Classes</A>,
       <A HREF="../../codeview/src/DataView.i3">DataView</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../lego/src/FlexVBT.i3">FlexVBT</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>,
       <A HREF="../../libm3/derived/RefListSort.i3">RefListSort</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../lego/src/ListVBT.i3">ListVBT</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../lego/src/MultiFilter.i3">MultiFilter</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>,
       <A HREF="../../lego/src/ScrollerVBT.i3">ScrollerVBT</A>, <A HREF="../../params/src/Params.i3">Params</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../lego/src/ScaleFilter.i3">ScaleFilter</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>,
       <A HREF="../../etext/src/TextEditVBT.i3">TextEditVBT</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../etext/src/TextPort.i3">TextPort</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>,
       <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="../../lego/src/ViewportVBT.i3">ViewportVBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="Zeus.i3">Zeus</A>, <A HREF="../derived/ZeusBundle.i3">ZeusBundle</A>,
       <A HREF="ZeusClass.i3">ZeusClass</A>, <A HREF="ZeusCodeView.i3">ZeusCodeView</A>, <A HREF="ZeusPanelFriends.i3">ZeusPanelFriends</A>, <A HREF="ZeusPrivate.i3">ZeusPrivate</A>, <A HREF="ZeusSnapshot.i3">ZeusSnapshot</A>;

VAR
  me: VBT.T; (* This is the VBT installed into Trestle *)

VAR ControlPanel: T;

&lt;*FATAL FormsVBT.Error, FormsVBT.Unimplemented,
        TrestleComm.Failure,
        Zeus.Error, Zeus.Locked,
        Thread.Alerted,
        OSError.E, Wr.Failure, Rd.Failure *&gt;
</PRE> **************** Control Panel Form **************** 

<P><PRE>PROCEDURE <A NAME="NewPanel"><procedure>NewPanel</procedure></A> (): T =
  &lt;* LL = VBT.mu *&gt;
  VAR panel: T;

  PROCEDURE Attach (name: TEXT; proc: FormsVBT.Proc) =
    BEGIN
      FormsVBT.AttachProc(panel.fv, name, proc, panel);
    END Attach;

  BEGIN
    panel := NEW(T,
                 (* InitInterpreter *)
                 mu := NEW(MUTEX), runCond := NEW(Thread.Condition),
                 algCond := NEW(Thread.Condition));
    panel.fvpath := Rsrc.BuildPath(&quot;$ZEUSPATH&quot;, ZeusBundle.Get());
    panel.fv := NewForm(&quot;zeusPanel.fv&quot;, panel.fvpath);
    me := panel.fv;

    Attach(&quot;quit&quot;, QuitP);
    Attach(&quot;goBtn&quot;, GoP);
    Attach(&quot;stepBtn&quot;, StepP);
    Attach(&quot;abortBtn&quot;, AbortP);
    FormsVBT.MakeDormant(panel.fv, &quot;goBtn&quot;);
    FormsVBT.MakeDormant(panel.fv, &quot;stepBtn&quot;);
    FormsVBT.MakeDormant(panel.fv, &quot;abortBtn&quot;);

    Attach(&quot;delay&quot;, SpeedP);
    Attach(&quot;minDelayFrac&quot;, MinDelayP);
    Attach(&quot;codeDelayFrac&quot;, CodeDelayP);
    Attach(&quot;maxSpeedFactor&quot;, SpeedFactorP);

    Attach(&quot;errClear&quot;, ErrClearP);
    Attach(&quot;errClearAndShut&quot;, ErrClearP);

    Attach(&quot;priority&quot;, PriorityP);

    Attach(&quot;snapshot&quot;, SnapshotP);
    Attach(&quot;restore&quot;, RestoreP);
    Attach(&quot;restoreShortcut&quot;, RestoreP);
    Attach(&quot;photoBtn&quot;, PhotoP);
    Attach(&quot;clearAlbum&quot;, ClearAlbumP);
    Attach(&quot;delViews&quot;, DelAllViewsP);

    Attach(&quot;recordBtn&quot;, RecordBtnP);
    Attach(&quot;record&quot;, RecordP);
    Attach(&quot;grabData&quot;, GrabDataP);
    Attach(&quot;futurePause&quot;, FuturePauseP);
    Attach(&quot;playbackBtn&quot;, PlaybackBtnP);
    Attach(&quot;playback&quot;, PlaybackP);

    LoadFromPanel(panel);

    VAR
      i           := 0;
      cnt         := Params.Count;
      param: TEXT;
    BEGIN
      WHILE i &lt; cnt DO
        param := Params.Get(i);
        TRY
          IF Text.Equal(param, &quot;-scale&quot;) THEN
            INC(i);
            IF i &gt;= cnt THEN EXIT END;
            panel.scale := Lex.Real(TextRd.New (Params.Get(i)));
            ScaleFilter.Scale(
              FormsVBT.GetVBT(panel.fv, &quot;scale&quot;), panel.scale, panel.scale);
          ELSIF Text.Equal(param, &quot;-xdrift&quot;) THEN
            INC(i);
            IF i &gt;= cnt THEN EXIT END;
            XDRIFT := Lex.Int(TextRd.New (Params.Get(i)));
          ELSIF Text.Equal(param, &quot;-ydrift&quot;) THEN
            INC(i);
            IF i &gt;= cnt THEN EXIT END;
            YDRIFT := Lex.Int(TextRd.New (Params.Get(i)));
          ELSE
            INC(i);
          END;
        EXCEPT
          Lex.Error, FloatMode.Trap =&gt;
        END;
      END;
    END;
    RETURN panel;
  END NewPanel;

PROCEDURE <A NAME="NewForm"><procedure>NewForm</procedure></A> (name: TEXT; path: Rsrc.Path := NIL):
  FormsVBT.T =
  &lt;* FATAL FormsVBT.Error, Rd.Failure, Rsrc.NotFound, Thread.Alerted *&gt;
  BEGIN
    IF path = NIL THEN path := GetPath() END;
    RETURN NEW(FormsVBT.T).initFromRsrc(name, path)
  END NewForm;

PROCEDURE <A NAME="LoadFromPanel"><procedure>LoadFromPanel</procedure></A> (panel: T) =
  &lt;*LL = VBT.mu*&gt;
  BEGIN
    FormsVBT.MakeEvent(panel.fv, &quot;delay&quot;, 0);
    FormsVBT.MakeEvent(panel.fv, &quot;minDelayFrac&quot;, 0);
    FormsVBT.MakeEvent(panel.fv, &quot;codeDelayFrac&quot;, 0);
    FormsVBT.MakeEvent(panel.fv, &quot;maxSpeedFactor&quot;, 0);
    FormsVBT.MakeEvent(panel.fv, &quot;priority&quot;, 0);
  END LoadFromPanel;

&lt;*UNUSED*&gt; PROCEDURE <A NAME="NYI"><procedure>NYI</procedure></A> (msg: TEXT) =
  BEGIN                         (* LL = VBT.mu *)
    ReportError(msg &amp; &quot; not yet implemented.&quot;);
  END NYI;

PROCEDURE <A NAME="QuitP"><procedure>QuitP</procedure></A> (&lt;*UNUSED*&gt;  fv : FormsVBT.T;
                 &lt;*UNUSED*&gt;  e  : TEXT;
                             arg: REFANY;
                 &lt;*UNUSED *&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    Trestle.Delete(NARROW(arg, T).fv);
  END QuitP;

PROCEDURE <A NAME="GoP"><procedure>GoP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
               &lt;*UNUSED*&gt; e  : TEXT;
                          arg: REFANY;
                          t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    (* ignored in playback, so don't generate it. *)
    (*    Script(ActionType.Go);*)
    ScriptMaybeStartFrame(arg);
    Go(NARROW(arg, T), t);
  END GoP;

PROCEDURE <A NAME="StepP"><procedure>StepP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                 &lt;*UNUSED*&gt; e  : TEXT;
                            arg: REFANY;
                            t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    (* ignored in playback, so don't generate it. *)
    (*    Script(ActionType.Step);*)
    ScriptMaybeStartFrame(arg);
    Step(NARROW(arg, T), t);
  END StepP;

PROCEDURE <A NAME="AbortP"><procedure>AbortP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                             t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    Script(ActionType.Abort);
    AbortInternal(NARROW(arg, T), t);
  END AbortP;

PROCEDURE <A NAME="SpeedP"><procedure>SpeedP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    UpdateSpeed(NARROW(arg, T));
  END SpeedP;

PROCEDURE <A NAME="MinDelayP"><procedure>MinDelayP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    UpdateMinDelay(NARROW(arg, T));
  END MinDelayP;

PROCEDURE <A NAME="CodeDelayP"><procedure>CodeDelayP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    UpdateCodeDelay(NARROW(arg, T));
  END CodeDelayP;

PROCEDURE <A NAME="SpeedFactorP"><procedure>SpeedFactorP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    UpdateSpeedFactor(NARROW(arg, T));
  END SpeedFactorP;

PROCEDURE <A NAME="PriorityP"><procedure>PriorityP</procedure></A> (           fv : FormsVBT.T;
                                e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    Script(ActionType.Priority, Sx.FromInt(FormsVBT.GetInteger(fv, e)));
    SetPanelPriority(NARROW(arg, T), FormsVBT.GetInteger(fv, e));
  END PriorityP;

PROCEDURE <A NAME="ErrClearP"><procedure>ErrClearP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                     &lt;*UNUSED*&gt; e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    (* Don't script.  Should we? *)
    ClearError(arg);
  END ErrClearP;

PROCEDURE <A NAME="SnapshotP"><procedure>SnapshotP</procedure></A> (           fv : FormsVBT.T;
                     &lt;*UNUSED*&gt; e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    Script(ActionType.Snapshot, FormsVBT.GetText(fv, &quot;snapshot&quot;));
    ZeusSnapshot.Snapshot(NARROW(arg, T), FormsVBT.GetText(fv, &quot;snapshot&quot;));
  END SnapshotP;

PROCEDURE <A NAME="RestoreP"><procedure>RestoreP</procedure></A> (           fv : FormsVBT.T;
                               e  : TEXT;
                               arg: REFANY;
                    &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN (* LL = VBT.mu *)
    ZeusSnapshot.Restore(NARROW(arg, T), FormsVBT.GetText(fv, e));
</PRE><BLOCKQUOTE><EM> DON'T PUT Restore IN SCRIPT.  Leave it to the frame restore.
    (* put Script call afterward, so session deletions (part of Restore's
       operation) happen before the Restore in scriptOut. </EM></BLOCKQUOTE><PRE>
    (* put snapshots in-line in scripts, rather than using filenames *)
    TRY
      WITH list = Sx.Read(FileRd.Read(FormsVBT.GetText(fv, e))) DO
        Script(ActionType.Restore, list);
        (* The following would hide information better: *)
        (* Script(ActionType.Restore, SnapshotToList()); *)
      END;
    EXCEPT
    ELSE
    END;
*)
</PRE><BLOCKQUOTE><EM>    Script(ActionType.Restore, FormsVBT.GetText(fv, e)); </EM></BLOCKQUOTE><PRE>
  END RestoreP;

PROCEDURE <A NAME="RecordBtnP"><procedure>RecordBtnP</procedure></A> (           fv : FormsVBT.T;
                      &lt;*UNUSED*&gt; e  : TEXT;
                      &lt;*UNUSED*&gt; arg: REFANY;
                      &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF scripting = ScriptingState.Off THEN
      FormsVBT.PopUp(fv, &quot;RecordDialog&quot;);
    ELSIF scripting = ScriptingState.Recording THEN
      StopScript();
    END (* IF *);
  END RecordBtnP;

PROCEDURE <A NAME="RecordP"><procedure>RecordP</procedure></A> (           fv : FormsVBT.T;
                   &lt;*UNUSED*&gt; e  : TEXT;
                   &lt;*UNUSED*&gt; arg: REFANY;
                   &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF scripting = ScriptingState.Off THEN
      StartScript(FormsVBT.GetText(fv, &quot;record&quot;));
    END (* IF *);
  END RecordP;

PROCEDURE <A NAME="PlaybackBtnP"><procedure>PlaybackBtnP</procedure></A> (           fv : FormsVBT.T;
                        &lt;*UNUSED*&gt; e  : TEXT;
                        &lt;*UNUSED*&gt; arg: REFANY;
                        &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF scripting = ScriptingState.Off THEN
      FormsVBT.PopUp(fv, &quot;PlaybackDialog&quot;);
    ELSIF scripting = ScriptingState.Playback THEN
      StopPlayback();
    END (* IF *);
  END PlaybackBtnP;

PROCEDURE <A NAME="PlaybackP"><procedure>PlaybackP</procedure></A> (           fv : FormsVBT.T;
                     &lt;*UNUSED*&gt; e  : TEXT;
                     &lt;*UNUSED*&gt; arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF scripting = ScriptingState.Off THEN
      StartPlayback(FormsVBT.GetText(fv, &quot;playback&quot;));
    END (* IF *);
  END PlaybackP;

PROCEDURE <A NAME="FuturePauseP"><procedure>FuturePauseP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                        &lt;*UNUSED*&gt; e  : TEXT;
                                   arg: REFANY;
                        &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF NOT stateIdle[NARROW(arg, T).runState] THEN
      Script(ActionType.FuturePause);
    END;
  END FuturePauseP;

PROCEDURE <A NAME="GrabDataP"><procedure>GrabDataP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                     &lt;*UNUSED*&gt; e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                          (* LL = VBT.mu *)
    IF NOT stateIdle[NARROW(arg, T).runState] THEN
      Script(ActionType.GrabData, ZeusSnapshot.GrabDataList(arg));
    END;
  END GrabDataP;

PROCEDURE <A NAME="SessionsP"><procedure>SessionsP</procedure></A> (           fv : FormsVBT.T;
                                e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  (* This is called only when stateIdle[panel.runState], thanks
     to the dormancy of the session menu at other times.  See
     SetRunState. *)
  BEGIN                          (* LL = VBT.mu *)
    &lt;*ASSERT Text.Equal(&quot;SESS&quot;, Text.Sub(e, 0, 4)) *&gt;
    Script(
      ActionType.Sessions,
      RefList.List2(
        Text.Sub(e, 4, LAST(INTEGER)),
        Sx.FromBool(FormsVBT.GetBoolean(fv, &quot;inTrestle&quot;))));
    NewSessionDefault(
      Text.Sub(e, 4, LAST(INTEGER)), NARROW(arg, T));
  END SessionsP;

PROCEDURE <A NAME="PhotoP"><procedure>PhotoP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                  &lt;*UNUSED*&gt; e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                         (* LL = VBT.mu *)
    Script(ActionType.Photo);
    Photo(NARROW(arg, T));
  END PhotoP;

PROCEDURE <A NAME="ClearAlbumP"><procedure>ClearAlbumP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                       &lt;*UNUSED*&gt; e  : TEXT;
                                  arg: REFANY;
                       &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                         (* LL = VBT.mu *)
    Script(ActionType.ClearAlbum);
    ClearAlbum(NARROW(arg, T));
  END ClearAlbumP;

PROCEDURE <A NAME="DelAllViewsP"><procedure>DelAllViewsP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                       &lt;*UNUSED*&gt; e  : TEXT;
                                  arg: REFANY;
                       &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  BEGIN                         (* LL = VBT.mu *)
    (* Don't script; will be caught by frame restore. *)
    DeleteAllViews(arg);
  END DelAllViewsP;
</PRE> **************** Session Form **************** 

<P><PRE>PROCEDURE <A NAME="AlgsP"><procedure>AlgsP</procedure></A> (           fv : FormsVBT.T;
                            e  : TEXT;
                            arg: REFANY;
                 &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  (* This is called only when stateIdle[panel.runState], thanks to
     the dormancy of the algs menu at other times.  See SetRunState. *)
  VAR
    sess               := NARROW(arg, Session);
    tb  : ListVBT.T    := FormsVBT.GetVBT(fv, e);
    sel : ListVBT.Cell;
    st  : TEXT;
  BEGIN (* LL = VBT.mu *)
    IF tb.getFirstSelected(sel) THEN
      st := tb.getValue(sel);
      WITH name = sess.name &amp; &quot;.&quot; &amp; st DO
        Script(ActionType.Algs, RefList.List2(SessListPos(sess), name));
        PickedAlg(sess, name);
        TRY
          IF sess.alg # NIL THEN sess.alg.restore(NIL); END;
        EXCEPT
          ZeusClass.Error =&gt;
        END;
      END;
    END;
  END AlgsP;

PROCEDURE <A NAME="ViewsP"><procedure>ViewsP</procedure></A> (           fv : FormsVBT.T;
                             e  : TEXT;
                             arg: REFANY;
                  &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  VAR
    sess               := NARROW(arg, Session);
    tb  : ListVBT.T    := FormsVBT.GetVBT(fv, e);
    sel : ListVBT.Cell;
  BEGIN                          (* LL = VBT.mu *)
    IF tb.getFirstSelected(sel) THEN
      WITH name = sess.name &amp; &quot;.&quot;
                    &amp; NARROW(tb.getValue(sel), TEXT) DO
        Script(ActionType.Views,
               RefList.List2(SessListPos(sess), name));
        WITH view = PickedView(sess, name) DO
          TRY
            IF view # NIL THEN view.restore(NIL); END;
          EXCEPT
            ZeusClass.Error =&gt;
          END;
        END;
      END;
      tb.selectNone();
    END;
  END ViewsP;

PROCEDURE <A NAME="AbortAlgP"><procedure>AbortAlgP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                     &lt;*UNUSED*&gt; e  : TEXT;
                                arg: REFANY;
                     &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  (* This should abort just the algorithm for this session *)
  BEGIN (* LL = VBT.mu *)
    Script(ActionType.AbortAlg, SessListPos(arg));
    AbortAlg(NARROW(arg, Session));
  END AbortAlgP;

PROCEDURE <A NAME="DestroyP"><procedure>DestroyP</procedure></A> (&lt;*UNUSED*&gt; fv : FormsVBT.T;
                    &lt;*UNUSED*&gt; e  : TEXT;
                               arg: REFANY;
                    &lt;*UNUSED*&gt; t  : VBT.TimeStamp) =
  VAR sess := NARROW(arg, Session);
  BEGIN (* LL = VBT.mu *)
    (* put Script() call in DestroySession() to catch WM deletes, too. *)
    IF sess.inTrestle THEN
      Trestle.Delete(sess.fv);
    ELSE
      DestroySession(sess);
    END;
  END DestroyP;
</PRE> **************** Main Interaction **************** 

<P><PRE>PROCEDURE <A NAME="Interact"><procedure>Interact</procedure></A> (title: TEXT      := &quot;ZEUS Control Panel&quot;;
                    path : Rsrc.Path := NIL                   ) =
  VAR panel := Resolve(NIL);
  BEGIN
    panel.title := title;
    panel.path := path;
    Start(panel);
    Trestle.Install(panel.fv, &quot;Zeus&quot;, NIL, panel.title);
    (* LOCK VBT.mu DO Trestle.MoveNear(panel.fv, NIL); END;*)
    Trestle.AwaitDelete(panel.fv);
    Finish(panel);
  END Interact;

TYPE
  PanelClosure = Thread.SizedClosure OBJECT
                   panel: T;
                 OVERRIDES
                   apply := PanelThread
                 END;

  AlgClosure = Thread.SizedClosure OBJECT
                 panel: T;
                 sess : Session;
               OVERRIDES
                 apply := AlgThread
               END;

PROCEDURE <A NAME="Start"><procedure>Start</procedure></A> (panel: T) =
  VAR pclosure: PanelClosure;
  BEGIN                         (* LL = {} *)
    LOCK VBT.mu DO
      ZeusSnapshot.InitialRestore(panel);
      IF (panel.sessions = NIL) AND (groupInfo # NIL) THEN
        NewSessionDefault(
          NARROW(groupInfo.head, AlgGroupInfo).groupName, panel);
      END;
    END;
    pclosure := NEW(PanelClosure, panel := panel, stackSize := 10000);
    panel.panelThread := Thread.Fork(pclosure);
  END Start;

PROCEDURE <A NAME="Finish"><procedure>Finish</procedure></A> (panel: T) =
  BEGIN                          (* LL = {} *)
    (* DebugFinish();*)
    StopScript();
    LOCK panel.mu DO
      panel.quit := TRUE;
      Thread.Broadcast(panel.runCond);
      AbortWithLock(panel, 0);
    END;
    EVAL Thread.Join(panel.panelThread);
    LOCK VBT.mu DO
      ZeusSnapshot.FinalSnapshot(panel);
      DestroyAllSessions(panel);
    END;
    LOCK VBT.mu DO VBT.Discard(panel.fv); END;
  END Finish;
</PRE> **************** Miscellaneous Entries **************** 

<P><PRE>PROCEDURE <A NAME="GetAnimationTime"><procedure>GetAnimationTime</procedure></A> (): REAL =
&lt;* LL = VBT.mu *&gt;
  VAR panel := Resolve(NIL);
  BEGIN
    RETURN panel.delayTime
  END GetAnimationTime;

PROCEDURE <A NAME="SetTitle"><procedure>SetTitle</procedure></A> (title: TEXT) =
  VAR panel := Resolve(NIL);
  BEGIN
    panel.title := title;
    LOCK VBT.mu DO RenameTrestleChassis(panel.fv, title); END;
  END SetTitle;

PROCEDURE <A NAME="GetPath"><procedure>GetPath</procedure></A> (): Rsrc.Path =
  VAR panel := Resolve(NIL);
  BEGIN
    RETURN panel.path
  END GetPath;

PROCEDURE <A NAME="ReportErrorC"><procedure>ReportErrorC</procedure></A> (report: BOOLEAN; t: TEXT) =
  BEGIN (* LL = VBT.mu *)
    IF report THEN ReportError(t); END;
  END ReportErrorC;

PROCEDURE <A NAME="ReportError"><procedure>ReportError</procedure></A> (text: TEXT) =
  VAR
    panel  : T;
    tlength: INTEGER;
  BEGIN                         (* LL = VBT.mu *)
    panel := Resolve(NIL);
    IF text = NIL THEN RETURN END;
    tlength := Text.Length(text);
    IF tlength = 0 THEN RETURN END;
    IF (Text.GetChar(text, tlength - 1) # '\n') THEN
      text := text &amp; &quot;\n&quot;;
    END;
    TextEditVBTAppend(FormsVBT.GetVBT(panel.fv, &quot;error&quot;), text);
    FormsVBT.PopUp(panel.fv, &quot;ErrorDialog&quot;);
  END ReportError;

PROCEDURE <A NAME="Abort"><procedure>Abort</procedure></A> () =
  VAR panel := Resolve(NIL);
  BEGIN (* LL = VBT.mu *)
    Script(ActionType.Abort);
    AbortInternal(panel, 0);
  END Abort;

PROCEDURE <A NAME="ClearError"><procedure>ClearError</procedure></A>(panel: T) =
  BEGIN
    TextEditVBTClear(FormsVBT.GetVBT(panel.fv, &quot;error&quot;))
  END ClearError;

PROCEDURE <A NAME="PrepForSnapshot"><procedure>PrepForSnapshot</procedure></A> (panel: T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    ClearError(panel);
  END PrepForSnapshot;

PROCEDURE <A NAME="OverrideRestore"><procedure>OverrideRestore</procedure></A>(panel: T) =
  &lt;* LL = VBT.mu *&gt;
  (* Call this from ZeusSnapshot.m3 after a restore to reset things
     that the restore operation shouldn't have changed, but may have. *)
  BEGIN
    ClearError(panel);
    SetRunState(panel, RunState.Virgin);
    ChangeScriptingState(scripting);
    ResetSessionMenu(panel);
  END OverrideRestore;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="AlgReady"><procedure>AlgReady</procedure></A> (alg: Algorithm.T; ready: BOOLEAN) =
  (* Enable or disable the GO and STEP buttons.  The buttons are enabled
     whenever the user changes the algorithm.  This procedure is useful
     when it is known that the user has specified invalid data such that it
     is meaningless to run the algorithm with such data. *)
  (* This doesn't work. *)
  VAR fv: FormsVBT.T;
  BEGIN
    fv := Resolve(alg).fv;
    IF ready THEN
      FormsVBT.MakeActive(fv, &quot;goBtn&quot;);
      FormsVBT.MakeActive(fv, &quot;stepBtn&quot;);
    ELSE
      FormsVBT.MakeDormant(fv, &quot;goBtn&quot;);
      FormsVBT.MakeDormant(fv, &quot;stepBtn&quot;);
    END;
  END AlgReady;
</PRE> **************** Registration **************** 

<P><PRE>TYPE
  AlgGroupInfo = REF RECORD
                       groupName: TEXT;
                       title    : TEXT;
                       vbt      : VBT.T;    (* menu entry *)
                       algs     : TextList.T := NIL;
                       views    : TextList.T := NIL;
                     END;

VAR
  groupInfo: RefList.T := NIL; (* of AlgGroupInfo *)

PROCEDURE <A NAME="GICompare"><procedure>GICompare</procedure></A> (a1, a2: REFANY): [-1 .. 1] =
  VAR
    i1 := NARROW(a1, AlgGroupInfo);
    i2 := NARROW(a2, AlgGroupInfo);
  BEGIN
    IF i1 = NIL THEN
      RETURN -1
    ELSIF i2 = NIL THEN
      RETURN 1
    ELSE
      RETURN Text.Compare(i1.title, i2.title);
    END;
  END GICompare;

PROCEDURE <A NAME="GetGroupInfo"><procedure>GetGroupInfo</procedure></A> (sessName: TEXT; inMenu: BOOLEAN := TRUE):
  AlgGroupInfo =
  &lt;* LL = VBT.mu *&gt;
  (* Look up the named algorithm group and return its AlgGroupInfo record.
     Create an AlgGroupInfo record if none exists.  In this case, and if
     inMenu is TRUE, then insert an entry into the menu in the Sessions
     menu in the control panel. *)
  VAR
    panel := Resolve(NIL);
    info  := GetExistingGI(sessName);
  BEGIN
    IF info # NIL THEN RETURN info END;
    info := NEW(AlgGroupInfo, groupName := sessName, title := sessName);
    IF inMenu THEN
      RefListUtils.Push(groupInfo, info);
      UpdateSessionMenu(panel);
    END;
    RETURN info;
  END GetGroupInfo;

PROCEDURE <A NAME="UpdateSessionMenu"><procedure>UpdateSessionMenu</procedure></A> (panel: T) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    l   : RefList.T;
    info: AlgGroupInfo;
  BEGIN
    groupInfo := RefListSort.SortD(groupInfo, GICompare);
    l := groupInfo;
    FormsVBT.Delete(panel.fv, &quot;sessionMenu&quot;, 0, LAST(CARDINAL));
    WHILE l # NIL DO
      info := RefListUtils.Pop(l);
      (*
      IF info.vbt # NIL THEN
        FormsVBT.InsertVBT(panel.fv, &quot;sessionMenu&quot;, info.vbt);
      ELSE
      *)
        info.vbt := FormsVBT.Insert(
                      panel.fv, &quot;sessionMenu&quot;,
                      &quot;(Shape (Width 100) (MButton %SESS&quot; &amp; info.groupName
                        &amp; &quot; (Text %TITLE&quot; &amp; info.groupName &amp; &quot; \&quot;&quot;
                        &amp; info.title &amp; &quot;\&quot;)))&quot;);
        FormsVBT.AttachProc(
          panel.fv, &quot;SESS&quot; &amp; info.groupName, SessionsP, panel);
      (*
      END;
      *)
    END;
  END UpdateSessionMenu;

PROCEDURE <A NAME="GetExistingGI"><procedure>GetExistingGI</procedure></A> (sessName: TEXT): AlgGroupInfo =
  (* Look up the named algorithm group and return its AlgGroupInfo record.
     RETURN NIL if none exists. *)
  VAR l := groupInfo;
  BEGIN (* LL = VBT.mu *)
    WHILE l # NIL DO
      IF Text.Equal(sessName, NARROW(l.head, AlgGroupInfo).groupName) THEN
        RETURN l.head
      END;
      l := l.tail;
    END;
    RETURN NIL;
  END GetExistingGI;

PROCEDURE <A NAME="GroupInfoExists"><procedure>GroupInfoExists</procedure></A> (sessName: TEXT): BOOLEAN =
  BEGIN (* LL = VBT.mu *)
    RETURN GetExistingGI(sessName) # NIL
  END GroupInfoExists;

PROCEDURE <A NAME="SetSessTitle"><procedure>SetSessTitle</procedure></A> (sessName, sessTitle: TEXT) =
  (* Change the title of session &quot;sessName&quot; to &quot;sessTitle.&quot; Create a
     session named &quot;sessName,&quot; if none existed previously. *)
  VAR
    info : AlgGroupInfo;
    panel               := Resolve(NIL);
  BEGIN (* LL = {} *)
    LOCK VBT.mu DO
      info := GetGroupInfo(sessName);
      info.title := sessTitle;
      FormsVBT.PutText(panel.fv, &quot;TITLE&quot; &amp; sessName, sessTitle);
      UpdateSessionMenu(panel);
    END;
  END SetSessTitle;

PROCEDURE <A NAME="ResetSessionMenu"><procedure>ResetSessionMenu</procedure></A> (panel: T) =
  &lt;* LL = VBT.mu *&gt;
  (* Reset the titles of the sessions in the session menu to be equal to
     their real titles. *)
  VAR l := groupInfo;
  BEGIN
    WHILE l # NIL DO
      WITH info = NARROW(l.head, AlgGroupInfo) DO
        FormsVBT.PutText(panel.fv, &quot;TITLE&quot; &amp; info.groupName, info.title);
      END;
      l := l.tail;
    END;
    UpdateSessionMenu(panel);
  END ResetSessionMenu;

EXCEPTION DuplicateName;
&lt;* FATAL DuplicateName *&gt;

PROCEDURE <A NAME="RegisterAlg"><procedure>RegisterAlg</procedure></A> (proc: NewAlgProc; name, sessName: TEXT) =
  (* LL = {} *)
  VAR info: AlgGroupInfo;
  BEGIN
    LOCK VBT.mu DO
      info := GetGroupInfo(sessName);
      IF NOT TextList.Member(info.algs, name) THEN
        Classes.RegisterAlg(proc, sessName &amp; &quot;.&quot; &amp; name);
        info.algs := TextList.Cons(name, info.algs);
      ELSE
        RAISE DuplicateName;
      END;
    END;
  END RegisterAlg;

PROCEDURE <A NAME="RegisterView"><procedure>RegisterView</procedure></A> (proc          : NewViewProc;
                        name, sessName: TEXT;
                        alertable     : BOOLEAN       := FALSE;
                        sample        : View.T        := NIL    ) =
  (* LL = {} *)
  VAR info: AlgGroupInfo;
  BEGIN
    LOCK VBT.mu DO
      info := GetGroupInfo(sessName);
      IF NOT TextList.Member(info.views, name) THEN
        Classes.RegisterView(proc, sessName &amp; &quot;.&quot; &amp; name, alertable, sample);
        info.views := TextList.Cons(name, info.views);
      ELSE
        RAISE DuplicateName;
      END;
    END;
  END RegisterView;
</PRE> **************** Creating and Destroying Sessions **************** 

<P><PRE>TYPE
  SessionWatcherClosure = Thread.Closure OBJECT
                            sess: Session;
                          OVERRIDES
                            apply := SessionWatcher
                          END;

PROCEDURE <A NAME="NewSessionDefault"><procedure>NewSessionDefault</procedure></A> (name: TEXT; panel: T) =
  (* Get the inTrestle parm from the FV before calling NewSession. *)
  BEGIN                         (* LL = VBT.mu *)
    IF NOT ZeusSnapshot.SessionFromStateDir(panel, name, FALSE) THEN
      NewSession(name, panel, FormsVBT.GetBoolean(panel.fv, &quot;inTrestle&quot;))
    END;
    LOCK panel.mu DO UpdateSessionButtons(panel); END;
  END NewSessionDefault;

PROCEDURE <A NAME="NewSession"><procedure>NewSession</procedure></A> (name     : TEXT;
                      panel    : T;
                      inTrestle: BOOLEAN;
                      pickAlg  : BOOLEAN   := TRUE) =
  &lt;* LL = VBT.mu *&gt;
  (* if pickAlg, call PickedAlg on the first alg assoc with the new
     session. *)
  VAR
    sess := NEW(Session, name := name,
                fv := NewForm(&quot;zeusSession.fv&quot;, panel.fvpath),
                inTrestle := inTrestle,
                (*mu := NEW(MUTEX), *)
                runCond := NEW(Thread.Condition),
                feedCond := NEW(Thread.Condition), alg := NEW(Algorithm.T));
    info                 := GetGroupInfo(name, FALSE);
    l       : TextList.T;
    browser : ListVBT.T;
    aclosure: AlgClosure;

  PROCEDURE Attach (id: TEXT; proc: FormsVBT.Proc) =
    BEGIN
      FormsVBT.AttachProc(sess.fv, id, proc, sess);
    END Attach;

  BEGIN
    EVAL sess.init();
    Zeus.AttachAlg(sess, sess.alg);
    sess.alg.install();
    Attach(&quot;algs&quot;, AlgsP);
    Attach(&quot;views&quot;, ViewsP);
    Attach(&quot;abort&quot;, AbortAlgP);
    FormsVBT.MakeDormant(sess.fv, &quot;abort&quot;);
    Attach(&quot;destroy&quot;, DestroyP);
    Attach(&quot;eventDataBool&quot;, ToggleTSplitP);
    Attach(&quot;algBool&quot;, ToggleTSplitP);
    Attach(&quot;dataFormBool&quot;, ToggleTSplitP);

    browser := FormsVBT.GetVBT(sess.fv, &quot;algs&quot;);
    l := info.algs;
    WHILE l # NIL DO InsertToBrowser(browser, l.head);  l := l.tail END;
    browser := FormsVBT.GetVBT(sess.fv, &quot;views&quot;);
    l := info.views;
    WHILE l # NIL DO InsertToBrowser(browser, l.head); l := l.tail END;

    aclosure :=
      NEW(AlgClosure, panel := panel, sess := sess, stackSize := 10000);
    sess.algThread := Thread.Fork(aclosure);
    LOCK panel.mu DO
      IF panel.sessions = NIL THEN
        FormsVBT.MakeActive(panel.fv, &quot;goBtn&quot;);
        FormsVBT.MakeActive(panel.fv, &quot;stepBtn&quot;);
      END;
      RefListUtils.Push(panel.sessions, sess);
      Animate.SetDuration(panel.delayTime);
    END;

    IF sess.inTrestle THEN
      ScaleFilter.Scale(
        FormsVBT.GetVBT(sess.fv, &quot;scale&quot;), panel.scale, panel.scale);
      Trestle.Attach(sess.fv);
      Trestle.Decorate(sess.fv, applName := &quot;Zeus&quot;,
                       windowTitle := &quot;Zeus &quot; &amp; info.title &amp; &quot; Session&quot;);
      MoveNear(sess.fv, panel.fv);
      (* Trestle.Install(sess.fv, &quot;Zeus&quot;, NIL, &quot;Zeus &quot; &amp; name &amp; &quot;
         Session&quot;);*)
      EVAL Thread.Fork(NEW(SessionWatcherClosure, sess := sess));
    ELSE
      DestroyFVOwner(panel, FormsVBT.GetGeneric(panel.fv, &quot;sessionFV&quot;));
      FormsVBT.PutText(panel.fv, &quot;sessName&quot;, info.title);
      FormsVBT.PutGeneric(panel.fv, &quot;sessionFV&quot;, sess.fv);
    END;
    IF pickAlg AND (info.algs # NIL) THEN
      PickedAlg(sess, sess.name &amp; &quot;.&quot; &amp; NARROW(info.algs.head, TEXT));
    END;
    TRY
      IF sess.alg # NIL THEN sess.alg.restore(NIL); END;
    EXCEPT
      ZeusClass.Error =&gt;
    END;
  END NewSession;

PROCEDURE <A NAME="SessionWatcher"><procedure>SessionWatcher</procedure></A> (cl: SessionWatcherClosure): REFANY =
  BEGIN                         (* LL = {} *)
    WITH sess = cl.sess DO
      Trestle.AwaitDelete(sess.fv);
      LOCK VBT.mu DO DestroySession(sess); END;
    END;
    RETURN NIL;
  END SessionWatcher;

PROCEDURE <A NAME="DestroyFVOwner"><procedure>DestroyFVOwner</procedure></A> (panel: T; fv: VBT.T) =
  VAR
    l     : RefList.T;
    tokill: Session := NIL;
  BEGIN                         (* LL = VBT.mu *)
    LOCK panel.mu DO
      l := panel.sessions;
      WHILE l # NIL DO
        WITH sess = NARROW(RefListUtils.Pop(l), Session) DO
          IF sess.fv = fv THEN tokill := sess END;
        END;
      END;
    END;
    IF tokill # NIL THEN DestroySession(tokill); END;
  END DestroyFVOwner;

PROCEDURE <A NAME="DestroySession"><procedure>DestroySession</procedure></A> (sess: Session) =
  VAR panel := Resolve(NIL);
      wasActive: BOOLEAN;
  BEGIN                         (* LL = VBT.mu *)
    IF NOT stateIdle[panel.runState] THEN
      (* frame restores will catch other destroys *)
      Script(ActionType.Destroy, SessListPos(sess));
    END;
    IF scripting # ScriptingState.Playback THEN (* no need o/w *)
      ZeusSnapshot.SessionToStateDir(sess);
    END;
    LOCK panel.mu DO
      sess.quit := TRUE;
      wasActive := sess.active;
      ChangeSessActive(sess, panel, FALSE);
      RefListUtils.Delete(panel.sessions, sess);
      UpdateSessionButtons(panel);
      IF (panel.sessions = NIL) AND (NOT panel.quit) THEN
        FormsVBT.MakeDormant(panel.fv, &quot;goBtn&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;stepBtn&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;abortBtn&quot;);
      END
    END;
    IF wasActive THEN SetRunState(panel, RunState.Aborted) END;
    DeleteViews(sess);
    IF sess.alg # NIL THEN DeleteAlg(sess) END;
    Thread.Alert(sess.algThread);
    Thread.Broadcast(sess.runCond);
    (* I think this caused a deadlock, and it doesn't seem necessary: *)
    (*    EVAL Thread.Join(sess.algThread);*)
    IF (NOT sess.inTrestle)
         AND (sess.fv = FormsVBT.GetGeneric(panel.fv, &quot;sessionFV&quot;)) THEN
      FormsVBT.PutGeneric(panel.fv, &quot;sessionFV&quot;, NIL);
      FormsVBT.PutText(panel.fv, &quot;sessName&quot;, &quot;Null&quot;);
    END;
  END DestroySession;

PROCEDURE <A NAME="DestroyAllSessions"><procedure>DestroyAllSessions</procedure></A> (panel: T) =
  VAR
    l, rest: RefList.T;            (* of Session *)
    sess   : Session;
  BEGIN                         (* LL = VBT.mu *)
    LOCK panel.mu DO
      l := panel.sessions;
</PRE><BLOCKQUOTE><EM>      panel.sessions := NIL;    (* is this a good idea? </EM></BLOCKQUOTE><PRE>
                                  NO! Destroys the numActive invariant! *)
      WHILE l # NIL DO
        sess := RefListUtils.Pop(l);
        IF sess.inTrestle THEN
          sess.quit := TRUE;    (* so sess won't be made active *)
          Trestle.Delete(sess.fv);
        ELSE
          RefListUtils.Push(rest, sess); (* probably happens &lt;= once *)
        END;
      END;
    END;
    WHILE rest # NIL DO DestroySession(RefListUtils.Pop(rest)) END;
  END DestroyAllSessions;

PROCEDURE <A NAME="UpdateSessionButtons"><procedure>UpdateSessionButtons</procedure></A> (panel: T) =
  &lt;* LL = {VBT.mu, panel.mu} *&gt;
  (* Selectively show the &quot;Abort Alg&quot; and &quot;Destroy Session&quot; buttons. *)
  VAR
    l   : RefList.T;
    sel : CARDINAL;
    sess: Session;
  BEGIN
    l := panel.sessions;
    IF RefList.Length(l) &gt; 1 THEN sel := 1 ELSE sel := 0 END;
    WHILE l # NIL DO
      sess := RefListUtils.Pop(l);
      FormsVBT.PutInteger(sess.fv, &quot;showButtons&quot;, sel);
    END;
  END UpdateSessionButtons;

PROCEDURE <A NAME="ToggleTSplitP"><procedure>ToggleTSplitP</procedure></A> (             fv : FormsVBT.T;
                                      e  : TEXT;
                                      arg: REFANY;
                         &lt;* UNUSED *&gt; t  : VBT.TimeStamp) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    Script(ActionType.ToggleTSplit, RefList.List2(SessListPos(arg), e));
    WITH tsplitName = Text.Sub(e, 0, Text.Length(e)
                                       - Text.Length(&quot;Bool&quot;))
                        &amp; &quot;T&quot; DO
      FormsVBT.PutInteger(
        fv, tsplitName, 1 - FormsVBT.GetInteger(fv, tsplitName))
    END
  END ToggleTSplitP;

PROCEDURE <A NAME="SessListPos"><procedure>SessListPos</procedure></A>(sess: Session): REF INTEGER =
  (* Return position of sess in panel.sessions as a REF INTEGER.
     If sess NOTIN panel.sessions,
     then return RefList.Length(panel.sessions), which is arguably wrong. *)
  VAR panel := Resolve(NIL);
      l: RefList.T;
      pos:= 0;
  BEGIN
    LOCK panel.mu DO
      l := panel.sessions;
      WHILE (l # NIL) AND (RefListUtils.Pop(l) # sess) DO INC(pos) END;
    END (* LOCK *);
    RETURN Sx.FromInt(pos);
  END SessListPos;
</PRE> **************** Selecting Algorithms and Views **************** 

<P><PRE>PROCEDURE <A NAME="PickedAlg"><procedure>PickedAlg</procedure></A> (sess: Session; which: TEXT) =
  (* LL = VBT.mu *)
  VAR
    alg   : Algorithm.T;
    suffix: TEXT;
  BEGIN
    TRY
      ZeusPanelFriends.whichAlg := which;
      alg := Classes.NewAlg(Classes.FindAlg(which));
    EXCEPT
      Classes.NotFound =&gt; RETURN
    END;
    Zeus.Acquire(sess);
    sess.viewsToAdd := RefList.Append(sess.viewsToAdd, sess.views);
    Zeus.Release(sess);
    IF sess.alg # NIL THEN DeleteAlg(sess) END;
    Zeus.AttachAlg(sess, alg);
    alg.install();
    sess.algIsSet := TRUE;
    IF CheckPrefix(which, sess.name &amp; &quot;.&quot;, suffix) THEN
      FormsVBT.PutText(sess.fv, &quot;algName&quot;, suffix);
      SelectInBrowser(FormsVBT.GetVBT(sess.fv, &quot;algs&quot;), suffix);
    END;
    FormsVBT.PutGeneric(sess.fv, &quot;dataForm&quot;, alg.data);
    FormsVBT.PutGeneric(sess.fv, &quot;eventDataForm&quot;, alg.eventData);
    InitViewBrowser(sess, alg);
    InitCodeViewBrowser(sess, alg);
    SetAllViewTitles(sess);    (* also makes incompat views dormant *)
  END PickedAlg;

PROCEDURE <A NAME="PickedView"><procedure>PickedView</procedure></A> (sess: Session; which: TEXT): View.T =
  (* LL = VBT.mu *)
  VAR view: View.T;
  BEGIN
    TRY
      ZeusPanelFriends.whichView := which;
      view := Classes.NewView(Classes.FindView(which));
    EXCEPT
      Classes.NotFound =&gt;
        view := NewCodeView(sess, which);
    END;
    IF view = NIL THEN RETURN NIL END;
    view.install();
    SetViewTitle(sess, view);
    (*
        IF sess.inTrestle THEN
          MoveNear(view, sess.fv);
        ELSE
          MoveNear(view, Resolve(NIL).fv);
        END;
    *)
    RefListUtils.Push(sess.viewsToAdd, view);
    ZeusPrivate.Mark(sess, view);
    RETURN view
  END PickedView;

PROCEDURE <A NAME="DeleteAlg"><procedure>DeleteAlg</procedure></A> (sess: Session) =
  (* LL = VBT.mu *)
  BEGIN
    (*    DeleteCodeViews(sess);
          EmptyCodeViewBrowser(sess, sess.alg); *)
    sess.alg.delete();
  END DeleteAlg;

PROCEDURE <A NAME="AttachViews"><procedure>AttachViews</procedure></A> (sess: Session) =
  (* LL = VBT.mu *)
  VAR
    rest: RefList.T;
    view: View.T;
  BEGIN
    rest := sess.viewsToAdd;
    WHILE rest # NIL DO
      view := NARROW(rest.head, View.T);
      Zeus.AttachView(sess, view);
      rest := rest.tail;
    END;
    sess.viewsToAdd := NIL;
  END AttachViews;

PROCEDURE <A NAME="DetachView"><procedure>DetachView</procedure></A> (view: View.T) =
  (* LL = VBT.mu *)
  VAR sess := NARROW(Zeus.Resolve(view), Session);
  BEGIN
    RefListUtils.Delete(sess.viewsToAdd, view);
    Zeus.DetachView(view);
  END DetachView;

PROCEDURE <A NAME="DeleteViews"><procedure>DeleteViews</procedure></A> (sess: Session) =
  VAR
    rest: RefList.T;
    view: View.T;
  BEGIN                         (* LL = VBT.mu *)
    Zeus.Acquire(sess);
    rest := RefList.Append(sess.viewsToAdd, sess.views);
    Zeus.Release(sess);
    WHILE rest # NIL DO
      view := NARROW(rest.head, View.T);
      view.delete();
      rest := rest.tail;
    END;
    sess.viewsToAdd := NIL;
  END DeleteViews;

PROCEDURE <A NAME="DeleteAllViews"><procedure>DeleteAllViews</procedure></A> (panel: T) =
  &lt;* LL = VBT.mu *&gt;
  VAR rest: RefList.T;
  BEGIN
    LOCK panel.mu DO
      rest := panel.sessions;
      WHILE rest # NIL DO DeleteViews(RefListUtils.Pop(rest)); END;
    END;
  END DeleteAllViews;

PROCEDURE <A NAME="SetAllViewTitles"><procedure>SetAllViewTitles</procedure></A> (sess: Session) =
  (* LL = VBT.mu *)
  (* This sets view titles, and also makes views that are incompatible with
     the current algorithm be Dormant. *)
  VAR rest: RefList.T;
  BEGIN
    rest := sess.viewsToAdd;
    WHILE rest # NIL DO
      WITH v = NARROW(RefListUtils.Pop(rest), View.T) DO
        IF v.isCompat(sess.alg) THEN
          SetViewTitle(sess, v);
          ViewClass.Activate(v, TRUE);
        ELSE
          ViewClass.Activate(v, FALSE);
        END;
      END;
    END;
    Zeus.Acquire(sess);
    rest := sess.views;
    Zeus.Release(sess);
    WHILE rest # NIL DO
      WITH v = NARROW(RefListUtils.Pop(rest), View.T) DO
        IF v.isCompat(sess.alg) THEN
          SetViewTitle(sess, v);
          ViewClass.Activate(v, TRUE);
        ELSE
          ViewClass.Activate(v, FALSE);
        END;
      END;
    END;
  END SetAllViewTitles;

PROCEDURE <A NAME="SetViewTitle"><procedure>SetViewTitle</procedure></A> (sess: Session; view: View.T) =
  (* LL = VBT.mu *)
  VAR asuffix, vsuffix: TEXT;
  BEGIN
    IF CheckPrefix(view.name, sess.name &amp; &quot;.&quot;, vsuffix)
         AND CheckPrefix(sess.alg.name, sess.name &amp; &quot;.&quot;, asuffix) THEN
      RenameTrestleChassis(view, asuffix &amp; &quot;: &quot; &amp; vsuffix);
    END;
  END SetViewTitle;

PROCEDURE <A NAME="InitViewBrowser"><procedure>InitViewBrowser</procedure></A> (sess: Session; alg: Algorithm.T) =
  VAR
    tp  : ListVBT.T  := FormsVBT.GetVBT(sess.fv, &quot;views&quot;);
    info             := GetGroupInfo(sess.name, FALSE);
    l   : TextList.T;
    view: View.T;
  BEGIN                          (* LL = VBT.mu *)
    tp.removeCells(0, LAST(INTEGER));
    l := info.views;
    WHILE l # NIL DO
      WITH t    = l.head,
           name = sess.name &amp; &quot;.&quot; &amp; t DO
        TRY
          l := l.tail;
          view := Classes.SampleView(Classes.FindView(name));
          IF view.isCompat(alg) THEN InsertToBrowser(tp, t); END;
        EXCEPT
          Classes.NotFound =&gt;
        END;
      END;
    END;
  END InitViewBrowser;
</PRE> **************** Code Views **************** 

<P><PRE>&lt;*UNUSED*&gt;
PROCEDURE <A NAME="DeleteCodeViews"><procedure>DeleteCodeViews</procedure></A> (sess: Session) =
  VAR l: RefList.T;
  BEGIN                         (* LL = VBT.mu *)
    l := sess.viewsToAdd;
    WHILE l # NIL DO
      TYPECASE RefListUtils.Pop(l) OF
      | ZeusCodeView.T (v) =&gt;
          v.delete();
          RefListUtils.Delete(sess.viewsToAdd, v);
      ELSE
      END;
    END;
    Zeus.Acquire(sess);
    l := sess.views;
    Zeus.Release(sess);
    WHILE l # NIL DO
      TYPECASE RefListUtils.Pop(l) OF
      | ZeusCodeView.T (v) =&gt;
          v.delete();           (* Zeus.DetachView does the rest *)
      ELSE
      END;
    END;
  END DeleteCodeViews;

PROCEDURE <A NAME="IsCodeView"><procedure>IsCodeView</procedure></A> (which: TEXT; sess: Session; VAR file: TEXT):
  BOOLEAN =
  (* LL = arbitrary *)
  VAR
    t   : TEXT;
    list: RefList.T;
  BEGIN
    IF NOT CheckPrefix(which, sess.name &amp; &quot;.&quot;, t) THEN RETURN FALSE END;
    list := RefListUtils.Assoc(sess.alg.codeViews, t);
    IF RefList.Length(list) # 2 THEN
      RETURN FALSE;
    ELSE
      TYPECASE list.tail.head OF
      | TEXT (txt) =&gt; file := txt; RETURN TRUE;
      ELSE
        RETURN FALSE;
      END;
    END;
  END IsCodeView;

PROCEDURE <A NAME="NewCodeView"><procedure>NewCodeView</procedure></A> (sess: Session; which: TEXT): ZeusCodeView.T =
  (* LL = VBT.mu *)
  VAR
    twr                   := TextWr.New();
    view : ZeusCodeView.T;
    t, fn: TEXT;
    path: Rsrc.Path;
  BEGIN
    IF NOT IsCodeView(which, sess, fn) THEN
      ReportError(which &amp; &quot; is not a code view&quot;);
      RETURN NIL
    END;
    path := sess.alg.codePath;
    IF path = NIL THEN path := GetPath() END;
    TRY
      view := ZeusCodeView.New(which, Rsrc.Open(fn, path), sess.alg, twr);
    EXCEPT
    Rsrc.NotFound =&gt;
        ReportError(&quot;Cannot find file &quot; &amp; fn);
        RETURN NIL;
    END;
    t := TextWr.ToText(twr);
    IF NOT Text.Equal(t, &quot;&quot;) THEN
      ReportError(t);
      RETURN NIL
    ELSE
      RETURN view
    END;
  END NewCodeView;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="EmptyCodeViewBrowser"><procedure>EmptyCodeViewBrowser</procedure></A> (sess: Session; alg: Algorithm.T) =
  VAR
    l       := alg.codeViews;
    browser := FormsVBT.GetVBT(sess.fv, &quot;views&quot;);
  BEGIN                         (* LL = VBT.mu *)
    WHILE l # NIL DO
      DeleteFromBrowser(
        browser, NARROW(NARROW(RefListUtils.Pop(l), RefList.T).head, TEXT));
    END;
  END EmptyCodeViewBrowser;

PROCEDURE <A NAME="InitCodeViewBrowser"><procedure>InitCodeViewBrowser</procedure></A> (sess: Session; alg: Algorithm.T) =
  VAR
    l       := alg.codeViews;
    browser := FormsVBT.GetVBT(sess.fv, &quot;views&quot;);
  BEGIN                         (* LL = VBT.mu *)
    WHILE l # NIL DO
      InsertToBrowser(
        browser, NARROW(NARROW(RefListUtils.Pop(l), RefList.T).head, TEXT));
    END;
  END InitCodeViewBrowser;
</PRE> **************** Broadcasting to Zeus Routines **************** 

<P><PRE>PROCEDURE <A NAME="Startrun"><procedure>Startrun</procedure></A>(sess: Session) =
  BEGIN                         (* LL = {} *)
    Zeus.Dispatch(sess.alg, Zeus.EventStyle.Broadcast, Zeus.MaxPriority,
                  &quot;ZeusClass.Startrun&quot;, DispatchStartrun, NIL);
  END Startrun;

PROCEDURE <A NAME="DispatchStartrun"><procedure>DispatchStartrun</procedure></A> (v: ZeusClass.T; &lt;*UNUSED*&gt; args: REFANY) =
  &lt;* LL = {} *&gt;
  (* Must test type of v, since Broadcast events go to both. *)
  BEGIN
    TYPECASE v OF
    | View.T (v) =&gt; v.startrun();
    ELSE
    END;
  END DispatchStartrun;

PROCEDURE <A NAME="Endrun"><procedure>Endrun</procedure></A>(sess: Session) =
  BEGIN                         (* LL = {} *)
    Zeus.Dispatch(sess.alg, Zeus.EventStyle.Broadcast, Zeus.MaxPriority,
                  &quot;ZeusClass.Endrun&quot;, DispatchEndrun, NIL);
  END Endrun;

PROCEDURE <A NAME="DispatchEndrun"><procedure>DispatchEndrun</procedure></A> (v: ZeusClass.T; &lt;*UNUSED*&gt; args: REFANY) =
  &lt;* LL = {} *&gt;
  (* Must test type of v, since Broadcast events go to both. *)
  BEGIN
    TYPECASE v OF
    | View.T (v) =&gt; v.endrun();
    ELSE
    END;
  END DispatchEndrun;
</PRE> **************** Interpreter **************** 

<P><PRE>PROCEDURE <A NAME="PanelThread"><procedure>PanelThread</procedure></A> (pc: PanelClosure): REFANY =
  (* LL = {} *)
  VAR
    l    : RefList.T;              (* of Session *)
    sess : Session;
    panel          := pc.panel;

  PROCEDURE OKToPause (): BOOLEAN =
    BEGIN
      RETURN (panel.runState = RunState.Paused)
               OR (panel.runState = RunState.Stepping);
</PRE><BLOCKQUOTE><EM>      RETURN (panel.runState = RunState.Paused)
             OR ((scripting # ScriptingState.Playback)
                 AND (panel.runState = RunState.Stepping));</EM></BLOCKQUOTE><PRE>
    END OKToPause;

  BEGIN                         (* LL = {} *)
</PRE><BLOCKQUOTE><EM> DebugWrite(<CODE>P-id = </CODE> &amp; Fmt.Ref(Thread.Self()) &amp; <CODE>\n</CODE>);</EM></BLOCKQUOTE><PRE>
    panel.panelThread := Thread.Self();
    WHILE TRUE DO
      &lt;* ASSERT (panel.numActive = 0) *&gt;
      LOCK panel.mu DO
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pi </CODE>); END;</EM></BLOCKQUOTE><PRE>
        panel.clock := 0;
        panel.subclock := 0;
        IF panel.quit THEN RETURN NIL; END;
        IF scripting = ScriptingState.Playback THEN
          PanelThreadPlayback(panel, TRUE);
        END;
        WHILE (panel.runState # RunState.Running)
          AND (panel.runState # RunState.Stepping)
          AND (NOT panel.quit) DO
          (* wait for a user-invoked Step or Go command... *)
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pj </CODE>); END;</EM></BLOCKQUOTE><PRE>
          Thread.Wait(panel.mu, panel.runCond);
        END;
        IF panel.quit THEN RETURN NIL; END;
        panel.clock := 1;    (* clock is 0 only when idle *)
      END;
      LOCK VBT.mu DO
        LOCK panel.mu DO
          l := panel.sessions;
          WHILE l # NIL DO
            sess := RefListUtils.Pop(l);
            IF NOT sess.quit THEN
              ChangeSessActive(sess, panel, TRUE);
              sess.waitUntil := 0;
              FormsVBT.MakeActive(sess.fv, &quot;abort&quot;);
            END;
          END;
        END;
      END;
      LOCK panel.mu DO
        WHILE panel.numActive &gt; 0 DO
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pa </CODE>); END;</EM></BLOCKQUOTE><PRE>
          panel.numRunning := 0;
          l := panel.sessions;
          WHILE l # NIL DO
            sess := l.head;
            IF sess.active AND (sess.waitUntil &lt;= panel.clock) THEN
	      sess.running := TRUE;
	      INC(panel.numRunning);
	      Thread.Broadcast(sess.runCond);
            ELSE
              sess.running := FALSE;
	    END;
            l := l.tail;
          END;
          IF panel.numRunning = 0 THEN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pb </CODE>); END;</EM></BLOCKQUOTE><PRE>
            INC(panel.clock);
            panel.subclock := 0;
          ELSE
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pc </CODE>); END;</EM></BLOCKQUOTE><PRE>
            Thread.Wait(panel.mu, panel.algCond);
            (* now panel.numRunning = 0 *)
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Pd </CODE>); END;</EM></BLOCKQUOTE><PRE>
            IF scripting = ScriptingState.Playback THEN
              PanelThreadPlayback(panel, FALSE);
            END;
            IF OKToPause() THEN
              WaitForUser(panel);
            END;
            INC(panel.subclock);
          END;
        END;
      END;
    END;
    RETURN NIL;
  END PanelThread;

PROCEDURE <A NAME="PanelThreadPlayback"><procedure>PanelThreadPlayback</procedure></A>(panel: T; frameStart: BOOLEAN) =
  &lt;* LL = {panel.mu} *&gt;
  (* but NOT VBT.mu *)
  (* No algorithm threads are running.  Release panel.mu, lock VBT.mu.
     If frameStart, flush playback records that aren't frame-starters.
     Call DoNextPlayback, release VBT.mu, reacquire panel.mu, and return. *)
  BEGIN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>ptp </CODE>); END;</EM></BLOCKQUOTE><PRE>
    Thread.Release(panel.mu);
    TRY
      LOCK VBT.mu DO
        IF frameStart THEN FlushFramePlayback() END;
        DoNextPlayback(panel);
      END;
    FINALLY
      Thread.Acquire(panel.mu);
    END;
  END PanelThreadPlayback;

PROCEDURE <A NAME="WaitForUser"><procedure>WaitForUser</procedure></A> (panel: T) =
  &lt;* LL = {panel.mu} *&gt;
  (* but NOT VBT.mu *)
  (* panel.numRunning = 0, so no algorithm threads are running.  Lock
     ordering requires us to release panel.mu before we can lock VBT.mu.
     We need to lock VBT.mu to enable/disable feedback.  Sleeping unlocks
     panel.mu anyway, so it's probably no big deal to unlock it a little
     earlier. *)
  VAR
    l: RefList.T;
    sess: Session;
  BEGIN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>wfu </CODE>); END;</EM></BLOCKQUOTE><PRE>
    Thread.Release(panel.mu);
    LOCK VBT.mu DO
      LOCK panel.mu DO
        l := panel.sessions;
        WHILE l # NIL DO
          sess := RefListUtils.Pop(l);
          IF sess.active THEN EnableFeedback (sess) END;
        END;
      END
    END;
    TRY
      LOCK panel.mu DO Thread.Wait(panel.mu, panel.runCond) END;
    FINALLY
      LOCK VBT.mu DO
        LOCK panel.mu DO
          l := panel.sessions;
          WHILE l # NIL DO
            sess := RefListUtils.Pop(l);
            DisableFeedback (sess);   (* not just for active sessions *)
          END;
        END
      END;
      Thread.Acquire(panel.mu);
    END;
  END WaitForUser;

VAR
  NullDataView := NEW(DataView.T);

PROCEDURE <A NAME="AlgThread"><procedure>AlgThread</procedure></A> (ac: AlgClosure): REFANY =
  VAR finalState: RunState;
  BEGIN                         (* LL = {} *)
    WITH panel = ac.panel,
         sess  = ac.sess,
         alg = sess.alg
     DO
</PRE><BLOCKQUOTE><EM> DebugWrite(<CODE>A-id = </CODE> &amp; Fmt.Ref(Thread.Self()) &amp; <CODE>\n</CODE>);</EM></BLOCKQUOTE><PRE>
      sess.algThread := Thread.Self();
      WHILE TRUE DO
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Ak </CODE>); END;</EM></BLOCKQUOTE><PRE>
        LOCK panel.mu DO
          IF sess.quit THEN RETURN NIL; END;
          (* wait for a user-invoked Step or Go command... *)
          Thread.Wait(panel.mu, sess.runCond);
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Al </CODE>); END;</EM></BLOCKQUOTE><PRE>
          IF sess.quit THEN RETURN NIL; END;
        END;
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Am </CODE>); END;</EM></BLOCKQUOTE><PRE>
        &lt;* ASSERT (sess.active) *&gt;
        LOCK VBT.mu DO AttachViews(sess); END;
        IF alg.varPath = NIL THEN alg.varPath := GetPath() END;
        alg.varView := NIL;
        Startrun(sess);
        IF alg.varView = NIL THEN alg.varView := NullDataView END;
        finalState := RunState.Done;
        TRY
          IF sess.algIsSet THEN
            LOCK VBT.mu DO sess.alg.updateEventCounts(TRUE) END;
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>An </CODE>); END;</EM></BLOCKQUOTE><PRE>
            sess.alg.run();
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Ao </CODE>); END;</EM></BLOCKQUOTE><PRE>
            LOCK VBT.mu DO sess.alg.updateEventCounts(FALSE) END;
          END
        EXCEPT
          Thread.Alerted =&gt; finalState := RunState.Aborted;
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Ap </CODE>); END;</EM></BLOCKQUOTE><PRE>
        | FormsVBT.Error (errorText) =&gt;
            ReportError(&quot;FormsVBT error in algorithm: &quot; &amp; errorText);
        ELSE
          ReportError(&quot;Unhandled exception raised in algorithm.&quot;);
        END;
  (* Endrun is broadcast (doesn't go through PostEventCallback),
     so we can now unregister from the panel's group of alg threads: *)
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>Aq </CODE>); END;</EM></BLOCKQUOTE><PRE>
        IF NOT sess.quit THEN (* test unnecessary? *)
          LOCK VBT.mu DO FormsVBT.MakeDormant(sess.fv, &quot;abort&quot;); END
        END;
        LOCK panel.mu DO
          ChangeSessActive(sess, panel, FALSE);
        END;
        LOCK VBT.mu DO SetRunState(panel, finalState); END;
        Endrun(sess);
        LOCK panel.mu DO StopRunning(sess, panel) END;
      END;
      RETURN NIL;
    END;
  END AlgThread;

PROCEDURE <A NAME="StopRunning"><procedure>StopRunning</procedure></A> (sess: Session; panel: T) =
  &lt;* LL.sup = panel.mu *&gt;
  BEGIN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>sr </CODE>); END;</EM></BLOCKQUOTE><PRE>
    IF sess.running THEN
      sess.running := FALSE;
      DEC(panel.numRunning);
      IF panel.numRunning = 0 THEN Thread.Signal(panel.algCond); END;
    END;
  END StopRunning;

PROCEDURE <A NAME="ChangeSessActive"><procedure>ChangeSessActive</procedure></A>(sess: Session; panel: T; act: BOOLEAN) =
  &lt;*LL = panel.mu*&gt;
  BEGIN
    IF RefList.Member(panel.sessions, sess) THEN
      IF act THEN
        IF NOT sess.active THEN INC(panel.numActive) END;
      ELSE
        IF sess.active THEN DEC(panel.numActive) END;
      END;
      sess.active := act;
      panel.mustSynch := (panel.numActive &gt; 1) OR
                             (scripting # ScriptingState.Off);
    END;
  END ChangeSessActive;

PROCEDURE <A NAME="Go"><procedure>Go</procedure></A> (panel: T; eventTime: VBT.TimeStamp) =
  BEGIN                         (* LL = VBT.mu *)
    GrabFocus(panel, eventTime);
    CASE GetRunState(panel) OF

    | RunState.Virgin, RunState.Done, RunState.Aborted =&gt;
        SetRunState(panel, RunState.Running);
        Thread.Broadcast(panel.runCond);

    | RunState.Stepping, RunState.Paused =&gt;
        SetRunState(panel, RunState.Running);
        Thread.Broadcast(panel.runCond);

    | RunState.Running =&gt; SetRunState(panel, RunState.Paused);

    END;
  END Go;

PROCEDURE <A NAME="Step"><procedure>Step</procedure></A> (panel: T; eventTime: VBT.TimeStamp) =
  BEGIN                         (* LL = VBT.mu *)
    GrabFocus(panel, eventTime);
    SetRunState(panel, RunState.Stepping);
    Thread.Broadcast(panel.runCond);
  END Step;

PROCEDURE <A NAME="AbortInternal"><procedure>AbortInternal</procedure></A> (panel: T; eventTime: VBT.TimeStamp) =
  (* LL &lt; panel.mu *)
  BEGIN
    LOCK panel.mu DO AbortWithLock(panel, eventTime) END;
  END AbortInternal;

PROCEDURE <A NAME="AbortWithLock"><procedure>AbortWithLock</procedure></A> (panel: T; eventTime: VBT.TimeStamp) =
  (* LL = panel.mu *)
  VAR
    l   : RefList.T;
    sess: Session;
  BEGIN
    (* DebugStart();*)
    (* DebugWrite(&quot;abort:&quot; &amp; Fmt.Ref(Thread.Self()) &amp; &quot;\n&quot;);*)
    IF NOT stateIdle[panel.runState] THEN
      Thread.Broadcast(panel.runCond);
      l := panel.sessions;
      WHILE l # NIL DO sess := RefListUtils.Pop(l); AbortAlg(sess); END;
    END;
    ReleaseFocus(panel, eventTime);
  END AbortWithLock;

PROCEDURE <A NAME="AbortAlg"><procedure>AbortAlg</procedure></A> (sess: Session) =
  BEGIN                         (* LL = arbitrary *)
    DisableFeedback(sess);
    IF sess.active THEN
      Thread.Alert(sess.algThread);
      ZeusPrivate.AlertViews(sess);    (* abort any alertable views *)
    END;
  END AbortAlg;

PROCEDURE <A NAME="PreEventCallback"><procedure>PreEventCallback</procedure></A> (&lt;*UNUSED*&gt; sess     : Session;
                            &lt;*UNUSED*&gt; initiator: ZeusClass.T;
                            &lt;*UNUSED*&gt; style    : Zeus.EventStyle;
                            &lt;*UNUSED*&gt; priority : INTEGER;
                            &lt;*UNUSED*&gt; eventName: TEXT             )
  RAISES {Thread.Alerted} =
  BEGIN                         (* LL = arbitrary *)
    IF Thread.TestAlert() THEN RAISE Thread.Alerted END;
  END PreEventCallback;

PROCEDURE <A NAME="PostEventCallback"><procedure>PostEventCallback</procedure></A> (           sess     : Session;
                                        initiator: ZeusClass.T;
                                        style    : Zeus.EventStyle;
                                        priority : INTEGER;
                             &lt;*UNUSED*&gt; eventName: TEXT             )
  (* LL &lt;= VBT.mu *)
  RAISES {Thread.Alerted} =
  VAR
    feedFg, pauseFg: BOOLEAN;
    alg            : Algorithm.T;
    panel                        := Resolve(NIL);
    now, delayFrac : REAL;

  PROCEDURE OKToPause (): BOOLEAN =
    (* LL = panel.mu *)
    BEGIN
      RETURN
        (panel.runState = RunState.Paused)
          OR ((panel.mustSynch OR (panel.runState = RunState.Stepping))
                AND (priority &lt;= panel.priority) AND alg.stopAtEvent
                AND sess.evtWasHandled);
    END OKToPause;
  PROCEDURE FeedbackOK (): BOOLEAN =
    (* LL = panel.mu *)
    BEGIN
      RETURN (panel.runState = RunState.Paused)
               OR ((panel.runState = RunState.Stepping)
                     AND (priority &lt;= panel.priority) AND alg.stopAtEvent
                     AND sess.evtWasHandled);
    END FeedbackOK;
  BEGIN
    IF (style = Zeus.EventStyle.Output) OR (style = Zeus.EventStyle.Code) THEN
      (* LL &lt; VBT.mu *)
      alg := NARROW(initiator, Algorithm.T);
      LOCK panel.mu DO feedFg := FeedbackOK(); pauseFg := OKToPause(); END;
      IF (NOT feedFg) AND sess.evtWasHandled THEN
        IF style = Zeus.EventStyle.Output THEN
          delayFrac := panel.minDelayFrac;
        ELSIF style = Zeus.EventStyle.Code THEN
          delayFrac := panel.codeDelayFrac;
        ELSE
          delayFrac := 0.0;
        END;
        now := Animate.ATime();
        IF now &lt; delayFrac THEN
          TRY
            Thread.AlertPause(MAX(0.0D0, FLOAT(panel.delayTime
                                           * (delayFrac - now), LONGREAL)));
          EXCEPT
            Thread.Alerted =&gt; Thread.Alert(Thread.Self());
          END;
        END;
      END;
      (* LOCK panel.mu DO feedFg := FeedbackOK(); END;*)
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>pec </CODE>); END;</EM></BLOCKQUOTE><PRE>
      LOCK panel.mu DO
        IF pauseFg (* OKToPause() *) THEN
          &lt;* ASSERT NOT RefList.Member(panel.sessions, sess) OR sess.running *&gt;
          StopRunning(sess, panel);
          sess.waitUntil := panel.clock + alg.waitAtEvent;
          Thread.AlertWait(panel.mu, sess.runCond);
        END;
      END;
    END;
    IF Thread.TestAlert() THEN RAISE Thread.Alerted END;
  END PostEventCallback;

PROCEDURE <A NAME="GetRunState"><procedure>GetRunState</procedure></A> (panel: T): RunState =
  BEGIN                         (* LL = arbitrary *)
    LOCK panel.mu DO RETURN panel.runState; END;
  END GetRunState;

PROCEDURE <A NAME="SetRunState"><procedure>SetRunState</procedure></A> (panel: T;
                       state: RunState;
                       msg  : TEXT       := NIL) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    LOCK panel.mu DO SetRunStateWithLock(panel, state, msg) END;
  END SetRunState;

PROCEDURE <A NAME="SetRunStateWithLock"><procedure>SetRunStateWithLock</procedure></A> (panel: T;
                               state: RunState;
                               msg  : TEXT       := NIL) =
  &lt;* LL = {VBT.mu, panel.mu} *&gt;
  PROCEDURE Set (btn: TEXT; status: TEXT) =
    VAR l: RefList.T;
        abortable := NOT stateIdle[state];
    BEGIN
      l := panel.sessions;
      WHILE l # NIL DO
        WITH sess = NARROW(RefListUtils.Pop(l), Session) DO
          IF abortable THEN
            FormsVBT.MakeDormant(sess.fv, &quot;algs&quot;)
          ELSE
            FormsVBT.MakeActive(sess.fv, &quot;algs&quot;)
          END
        END
      END;
      IF abortable THEN
        FormsVBT.MakeDormant(panel.fv, &quot;restoreBtn&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;restoreShortcut&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;restoreContents&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;sessionMenu&quot;);
        FormsVBT.MakeActive(panel.fv, &quot;abortBtn&quot;);
      ELSE
        FormsVBT.MakeActive(panel.fv, &quot;restoreBtn&quot;);
        FormsVBT.MakeActive(panel.fv, &quot;restoreShortcut&quot;);
        FormsVBT.MakeActive(panel.fv, &quot;restoreContents&quot;);
        FormsVBT.MakeActive(panel.fv, &quot;sessionMenu&quot;);
        FormsVBT.MakeDormant(panel.fv, &quot;abortBtn&quot;);
      END;
      ActivateScriptButtons(panel);
      FormsVBT.PutText(panel.fv, &quot;goText&quot;, btn);
      IF msg # NIL THEN status := status &amp; &quot; - &quot; &amp; msg END;
      FormsVBT.PutText(panel.fv, &quot;status&quot;, status);
    END Set;

  BEGIN
    IF (panel.numActive &gt; 0) AND ((state = RunState.Aborted)
                                   OR (state = RunState.Done)) THEN
      RETURN;
    END;
    panel.runState := state;
    CASE state OF
    | RunState.Virgin =&gt; Set(&quot;GO&quot;, &quot;Ready&quot;);
    | RunState.Running =&gt; Set(&quot;PAUSE&quot;, &quot;Running&quot;);
    | RunState.Stepping =&gt; Set(&quot;RESUME&quot;, &quot;Paused&quot;);
    | RunState.Paused =&gt; Set(&quot;RESUME&quot;, &quot;Paused&quot;);
    | RunState.Done =&gt; Set(&quot;GO&quot;, &quot;Completed&quot;);
    | RunState.Aborted =&gt; Set(&quot;GO&quot;, &quot;Aborted&quot;);
    END;
  END SetRunStateWithLock;
</PRE> **************** Reactivity / Feedback **************** 

<P><PRE>PROCEDURE <A NAME="EnableFeedback"><procedure>EnableFeedback</procedure></A> (sess: Session) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    ControlSessionFeedback(sess, TRUE);
  END EnableFeedback;

PROCEDURE <A NAME="DisableFeedback"><procedure>DisableFeedback</procedure></A> (sess: Session) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    ControlSessionFeedback(sess, FALSE);
  END DisableFeedback;

PROCEDURE <A NAME="ControlSessionFeedback"><procedure>ControlSessionFeedback</procedure></A> (sess: Zeus.Session; on: BOOLEAN) =
  &lt;* LL = VBT.mu *&gt;
  VAR l := sess.views;
  BEGIN
    WITH alg = sess.alg DO
      alg.reactivity(on);
      WHILE l # NIL DO
        WITH view = NARROW(RefListUtils.Pop(l), View.T) DO
          IF view.isCompat(alg) THEN view.reactivity(on); END;
        END;
      END;
    END;
  END ControlSessionFeedback;

PROCEDURE <A NAME="StartFeedback"><procedure>StartFeedback</procedure></A> (alg: Algorithm.T) RAISES {Thread.Alerted} =
&lt;* LL = {}, S = Running *&gt;
</PRE><BLOCKQUOTE><EM> Suspend the algorithm and allow feedback events (as if the user had
   clicked Pause).  Return after <CODE>alg</CODE> has called EndFeedback.  This
   procedure is a noop if there already is a 'pending' StartFeedback for
   this alg. </EM></BLOCKQUOTE><PRE>
  VAR sess := NARROW(Zeus.Resolve(alg), Session);
  BEGIN
    LOCK VBT.mu DO
      IF NOT sess.feedbackOn THEN
        sess.feedbackOn := TRUE;
        EnableFeedback(sess);
        TRY Thread.AlertWait(VBT.mu, sess.feedCond);
        FINALLY
          DisableFeedback(sess);
          sess.feedbackOn := FALSE;
        END;
      END;
    END;
  END StartFeedback;

PROCEDURE <A NAME="EndFeedback"><procedure>EndFeedback</procedure></A> (alg: Algorithm.T) =
  &lt;* LL = VBT.mu, S = Paused *&gt;
  (* This procedure signals a previous call to StartFeedback to return.  It
     is typically called from an algorithm's Feedback method. *)
  VAR sess := NARROW(Zeus.Resolve(alg), Session);
  BEGIN
    IF NOT sess.feedbackOn THEN
      ReportError(&quot;EndFeedback called with feedback off&quot;)
    ELSE
      Thread.Broadcast(sess.feedCond);
    END;
  END EndFeedback;

PROCEDURE <A NAME="Pause"><procedure>Pause</procedure></A> (alg: Algorithm.T; msg: TEXT := NIL)
  RAISES {Thread.Alerted} =
  &lt;* LL = 0, S = Running *&gt;
  VAR
    sess  := NARROW(Zeus.Resolve(alg), Session);
    panel := Resolve(NIL);
  BEGIN
    LOCK VBT.mu DO SetRunState(panel, RunState.Paused, msg) END;
    LOCK panel.mu DO
      StopRunning(sess, panel);
      sess.waitUntil := panel.clock;
      Thread.AlertWait(panel.mu, sess.runCond)
    END
  END Pause;
</PRE> **************** Event Priority **************** 

<P> PROCEDURE GetPriority (): INTEGER; 
 Report what priority the user has set in the control panel. 
<PRE>&lt;*UNUSED*&gt; PROCEDURE <A NAME="GetPriority"><procedure>GetPriority</procedure></A> (): INTEGER =
  (* LL = VBT.mu *)
  BEGIN
    RETURN GetPanelPriority(Resolve(NIL));
  END GetPriority;
</PRE> PROCEDURE SetPriority (priority: INTEGER); 
 Change the priority.  Client algorithms can use this to cause events to
   be generated that are not included in the <CODE>Step</CODE> command.  To do so, the
   algorithm first retrieves the current priority, then lowers it (probably
   to 0), does some stuff, then restores the priority to its initial
   value. 
<PRE>&lt;*UNUSED*&gt; PROCEDURE <A NAME="SetPriority"><procedure>SetPriority</procedure></A> (priority: INTEGER) =
  (* LL = VBT.mu *)
  BEGIN
    SetPanelPriority(Resolve(NIL), priority);
  END SetPriority;

PROCEDURE <A NAME="SetPanelPriority"><procedure>SetPanelPriority</procedure></A> (panel: T; priority: INTEGER) =
  BEGIN                         (* LL = VBT.mu *)
    LOCK panel.mu DO
      panel.priority := priority;
      FormsVBT.PutInteger(panel.fv, &quot;priority&quot;, priority);
    END;
  END SetPanelPriority;

PROCEDURE <A NAME="GetPanelPriority"><procedure>GetPanelPriority</procedure></A> (panel: T): INTEGER =
  BEGIN                         (* LL = arbitrary *)
    LOCK panel.mu DO RETURN panel.priority END;
  END GetPanelPriority;
</PRE> **************** Speedometer **************** 

<P> M3 FormsVBT doesn't have a REAL-valued slider, so this is
   done another way. 

<P><PRE>PROCEDURE <A NAME="UpdateSpeed"><procedure>UpdateSpeed</procedure></A> (panel: T) =
  (* LL = VBT.mu *)
  BEGIN
    panel.delayTime := FromFancySlider(panel);
    Script(ActionType.Speed, Sx.FromReal(panel.delayTime));
    Animate.SetDuration(panel.delayTime);
    FormsVBT.PutText(
      panel.fv, &quot;delayText&quot;, Fmt.Real(panel.delayTime, Fmt.Style.Fix, 4));
  END UpdateSpeed;

PROCEDURE <A NAME="UpdateMinDelay"><procedure>UpdateMinDelay</procedure></A> (panel: T) =
  (* LL = VBT.mu *)
  BEGIN
    panel.minDelayFrac := FromSimpleSlider(panel, &quot;minDelayFrac&quot;);
    Script(ActionType.MinDelay, Sx.FromReal(panel.minDelayFrac));
    FormsVBT.PutText(panel.fv, &quot;minDelayText&quot;,
                     Fmt.Real(panel.minDelayFrac, Fmt.Style.Fix,  2));
  END UpdateMinDelay;

PROCEDURE <A NAME="UpdateCodeDelay"><procedure>UpdateCodeDelay</procedure></A> (panel: T) =
  (* LL = VBT.mu *)
  BEGIN
    panel.codeDelayFrac := FromSimpleSlider(panel, &quot;codeDelayFrac&quot;);
    Script(ActionType.CodeDelay, Sx.FromReal(panel.codeDelayFrac));
    FormsVBT.PutText(panel.fv, &quot;codeDelayText&quot;,
                     Fmt.Real(panel.codeDelayFrac, Fmt.Style.Fix, 2));
  END UpdateCodeDelay;

PROCEDURE <A NAME="USFError"><procedure>USFError</procedure></A> (panel: T; t: TEXT) =
  (* LL = VBT.mu *)
  BEGIN
    FormsVBT.PutText(panel.fv, &quot;maxSpeedFactor&quot;,
                     Fmt.Real(panel.speedFactor, Fmt.Style.Fix, 2));
    ReportError(&quot;Bad max speed factor value: &quot; &amp; t)
  END USFError;

PROCEDURE <A NAME="UpdateSpeedFactor"><procedure>UpdateSpeedFactor</procedure></A> (panel: T) =
  (* LL = VBT.mu *)
  VAR
    t       := FormsVBT.GetText(panel.fv, &quot;maxSpeedFactor&quot;);
    r: REAL;
  BEGIN
    TRY
      r := Lex.Real(TextRd.New (t));
      IF r &lt;= 1.0 THEN
        USFError(panel, t);
      ELSE
        panel.speedFactor := r;
        Script(ActionType.SpeedFactor, t);
        panel.logSpeedFactor :=
          Math.log(FLOAT(panel.speedFactor, LONGREAL));
        UpdateSpeed(panel)
      END;
    EXCEPT
      Lex.Error, FloatMode.Trap =&gt; USFError(panel, t);
    END;
  END UpdateSpeedFactor;

PROCEDURE <A NAME="SetupSliderConversion"><procedure>SetupSliderConversion</procedure></A> (    fv               : FormsVBT.T;
                                name: TEXT;
                                 VAR min, range, value: LONGREAL    ) =
  (* LL = VBT.mu *)
  (* range is set to the range of the slider, min is set to its min, and
     value is set to its value. *)
  VAR v := NARROW(FormsVBT.GetVBT(fv, name), ScrollerVBT.T);
  BEGIN
    min := FLOAT(ScrollerVBT.GetMin(v), LONGREAL);
    range := FLOAT(ScrollerVBT.GetMax(v), LONGREAL) - min;
    value := FLOAT(ScrollerVBT.Get(v), LONGREAL);
  END SetupSliderConversion;

PROCEDURE <A NAME="FromSimpleSlider"><procedure>FromSimpleSlider</procedure></A>(panel: T; name: TEXT): REAL =
  VAR min, range, value: LONGREAL;
  BEGIN
    SetupSliderConversion(panel.fv, name, min, range, value);
    RETURN FLOAT((value - min) / range);
  END FromSimpleSlider;

PROCEDURE <A NAME="ToSimpleSlider"><procedure>ToSimpleSlider</procedure></A>(panel: T; name: TEXT; r: REAL) =
  VAR min, range, value: LONGREAL;
  BEGIN
    SetupSliderConversion(panel.fv, name, min, range, value);
    WITH frac = FLOAT(MAX(0.0, MIN(1.0, r)), LONGREAL) DO
      FormsVBT.PutInteger(panel.fv, name, ROUND(frac * range + min));
    END;
  END ToSimpleSlider;

CONST
  SpeedoBreak: LONGREAL = 0.1d0;
  SpeedoRange: LONGREAL = (1.0d0 - SpeedoBreak);
  SpeedoMid: LONGREAL = (SpeedoBreak + 0.5d0 * SpeedoRange);

PROCEDURE <A NAME="FromFancySlider"><procedure>FromFancySlider</procedure></A> (panel: T): REAL =
  (* LL = VBT.mu *)
  (* Returns a delay value *)
  VAR min, range, value: LONGREAL;
  BEGIN
    SetupSliderConversion(panel.fv, &quot;delay&quot;, min, range, value);
    value := (value - min) / range;
    IF value &lt;= SpeedoBreak THEN
      RETURN FLOAT(value) / (panel.speedFactor * FLOAT(SpeedoBreak));
    ELSE
      RETURN FLOAT(Math.exp(panel.logSpeedFactor * 2.0d0
                              * (value - SpeedoMid) / SpeedoRange))
    END;
  END FromFancySlider;

PROCEDURE <A NAME="ToFancySlider"><procedure>ToFancySlider</procedure></A> (panel: T; delay: REAL) =
  (* LL = VBT.mu *)
  VAR min, range, value: LONGREAL;
  BEGIN
    SetupSliderConversion(panel.fv, &quot;delay&quot;, min, range, value);
    IF delay &lt;= (1.0 / panel.speedFactor) THEN
      FormsVBT.PutInteger(
        panel.fv, &quot;delay&quot;,
        ROUND(SpeedoBreak * FLOAT(delay * panel.speedFactor, LONGREAL)
                * range + min));
    ELSE
      FormsVBT.PutInteger(
        panel.fv, &quot;delay&quot;,
        ROUND(
          (SpeedoRange * Math.log(FLOAT(delay, LONGREAL))
             / (panel.logSpeedFactor * 2.0d0) + SpeedoMid) * range + min));
    END;
  END ToFancySlider;
</PRE> **************** Keyboard Focus **************** 

<P><PRE>PROCEDURE <A NAME="GrabFocus"><procedure>GrabFocus</procedure></A> (&lt;*UNUSED*&gt; panel: T; &lt;*UNUSED*&gt; time: VBT.TimeStamp) =
  BEGIN
  END GrabFocus;

PROCEDURE <A NAME="ReleaseFocus"><procedure>ReleaseFocus</procedure></A> (&lt;*UNUSED*&gt; panel: T; &lt;*UNUSED*&gt; time: VBT.TimeStamp) =
  BEGIN
  END ReleaseFocus;
</PRE> **************** Photo Album **************** 

<P><PRE>PROCEDURE <A NAME="CntViews"><procedure>CntViews</procedure></A> (panel: T): CARDINAL =
  VAR
    rest, views: RefList.T;
    cnt        : CARDINAL := 0;
  BEGIN
    LOCK panel.mu DO
      rest := panel.sessions;
      WHILE rest # NIL DO
        views := NARROW(rest.head, Session).views;
        WHILE views # NIL DO INC(cnt); views := views.tail; END;
        rest := rest.tail;
      END;
    END;
    RETURN cnt
  END CntViews;

PROCEDURE <A NAME="TakePhotos"><procedure>TakePhotos</procedure></A> (panel: T) =
  VAR rest, views: RefList.T;
  BEGIN
    LOCK panel.mu DO
      rest := panel.sessions;
      WHILE rest # NIL DO
        views := NARROW(rest.head, Session).views;
        WHILE views # NIL DO
          WITH view  = NARROW(views.head, View.T),
               flex  = NARROW(MultiFilter.Child(panel.album), FlexVBT.T),
               album = NARROW(MultiFilter.Child(flex), AlbumVBT.T)        DO
            album.add(view);
          END;
          views := views.tail;
        END;
        rest := rest.tail;
      END;
    END;
  END TakePhotos;

EXCEPTION Oops;

PROCEDURE <A NAME="GetReal"><procedure>GetReal</procedure></A> (fv: FormsVBT.T; name: TEXT): REAL RAISES {Oops} =
  VAR
    t       := FormsVBT.GetText(fv, name);
    r: REAL;
  BEGIN
    TRY
      r := Lex.Real(TextRd.New (t));
      IF r &lt;= 5.0 THEN
        ReportError(&quot;Bad value (too small) for &quot; &amp; name &amp; &quot;: &quot; &amp; t);
        RAISE Oops;
      ELSE
        RETURN r
      END;
    EXCEPT
      Lex.Error, FloatMode.Trap =&gt;
        ReportError(&quot;Bad real value for &quot; &amp; name &amp; &quot;: &quot; &amp; t);
        RAISE Oops;
    END;
  END GetReal;

CONST
  AlbumAxis = Axis.T.Ver;
</PRE><BLOCKQUOTE><EM>OBSOLETE  FixedShape = FlexShape.Shape{FlexShape.Fixed, FlexShape.Fixed};</EM></BLOCKQUOTE><PRE>
  FixedShape = FlexVBT.Fixed;

PROCEDURE <A NAME="NewAlbum"><procedure>NewAlbum</procedure></A> (fv: FormsVBT.T; cnt: CARDINAL): AlbumVBT.T RAISES {Oops} =
  BEGIN
    RETURN NEW(AlbumVBT.T).init(AlbumAxis, cnt, GetReal(fv, &quot;photoWidth&quot;),
                                GetReal(fv, &quot;photoHeight&quot;))
  END NewAlbum;

TYPE
  MyViewport = ViewportVBT.T OBJECT
    panel: T;
  OVERRIDES
    misc := MiscVP;
  END;

PROCEDURE <A NAME="MiscVP"><procedure>MiscVP</procedure></A>(t: MyViewport; READONLY cd: VBT.MiscRec) =
  BEGIN
    IF cd.type = VBT.Deleted THEN
      t.panel.album := NIL
    END;
    ViewportVBT.T.misc(t, cd);
  END MiscVP;

PROCEDURE <A NAME="SetAlbum"><procedure>SetAlbum</procedure></A> (panel: T; cnt: CARDINAL) RAISES {Oops} =
  BEGIN
    IF panel.album = NIL THEN
      panel.album :=
        NEW(MyViewport, panel := panel).init(
          NEW(FlexVBT.T).init(
            NewAlbum(panel.fv, cnt), FixedShape),
          Axis.Other[AlbumAxis],
          shapeStyle := ViewportVBT.ShapeStyle.Unrelated,
          scrollStyle := ViewportVBT.ScrollStyle.HorAndVer);
      (* panel.album := NEW(Filter.T).init(NewAlbum(panel.fv,
         cnt)); *)
      Trestle.Attach(panel.album);
      Trestle.Decorate(
        panel.album, applName := &quot;Zeus Photo Album&quot;);
      Trestle.MoveNear(panel.album, NIL);
    ELSE
      WITH flex = MultiFilter.Child(panel.album),
           oldAlbum = MultiFilter.Replace(
                        flex, NewAlbum(panel.fv, cnt)) DO
        VBT.Discard(oldAlbum)
      END
    END;
    panel.cntViews := cnt;
  END SetAlbum;

PROCEDURE <A NAME="Photo"><procedure>Photo</procedure></A> (panel: T) =
  VAR cnt := CntViews(panel);
  BEGIN                         (* LL = VBT.mu *)
    TRY
      IF panel.album = NIL OR panel.cntViews # cnt THEN
        SetAlbum(panel, cnt);
      END;
    EXCEPT
      Oops =&gt;                   (* don't do anything *)
    END;
    TakePhotos(panel);
  END Photo;

PROCEDURE <A NAME="ClearAlbum"><procedure>ClearAlbum</procedure></A> (panel: T) =
  BEGIN                         (* LL = VBT.mu *)
    IF panel.album # NIL THEN
      WITH flex  = NARROW(MultiFilter.Child(panel.album), FlexVBT.T),
           album = NARROW(MultiFilter.Child(flex), AlbumVBT.T) DO
        album.clear()
      END
    END
  END ClearAlbum;
</PRE> PROCEDURE PhotographViews(alg: Algorithm.T) RAISES {Thread.Alerted}; 
<PRE>&lt;* LL=VBT.mu, s=Any *&gt;
</PRE><BLOCKQUOTE><EM> This procedure takes a <CODE>photograph</CODE> (captures a miniture pixmap)
   of all active views and enters them into an <CODE>photo album</CODE>.  It
   creates the album if none exists.  All views will get redisplayed
   (and maybe reshaped) when the photograph is taken. </EM></BLOCKQUOTE><PRE>
&lt;* UNUSED *&gt;
PROCEDURE <A NAME="PhotographViews"><procedure>PhotographViews</procedure></A> (&lt;* UNUSED *&gt; alg: Algorithm.T) =
  VAR panel := Resolve(NIL);
  BEGIN                         (* LL = VBT.mu *)
    Photo(panel)
  END PhotographViews;
</PRE>PROCEDURE ClearPhotoAlbum(alg: Algorithm.T) RAISES {Thread.Alerted}; 
<PRE>&lt;* LL=VBT.mu, s=Any *&gt;
</PRE><BLOCKQUOTE><EM> This procedure removes any <CODE>photographs</CODE> from the <CODE>photo album</CODE>
   (see PhotographViews, above). </EM></BLOCKQUOTE><PRE>
&lt;* UNUSED *&gt;
PROCEDURE <A NAME="ClearPhotoAlbum"><procedure>ClearPhotoAlbum</procedure></A> (&lt;* UNUSED *&gt; alg: Algorithm.T) =
  VAR panel := Resolve(NIL);
  BEGIN                         (* LL = VBT.mu *)
    ClearAlbum(panel)
  END ClearPhotoAlbum;
</PRE> **************** Scripting **************** 

<P><PRE>TYPE
  ActionType = {Go, Step, Abort, Speed, MinDelay, CodeDelay, SpeedFactor,
                Priority, Snapshot, Restore, Sessions, Photo, ClearAlbum,
                Algs, Views, AbortAlg, Destroy, ToggleTSplit,
                FutureGo, FuturePause, GrabData};
  ScriptRec = REF RECORD
                    action: ActionType;
                    clock  : INTEGER;
                    subclock  : INTEGER;
                    args  : REFANY;
                  END;
  ScriptingState = {Off, Recording, Playback};

VAR scriptOut: RefList.T; (* of ScriptRec, in reverse order *)
    scriptOutFile: TEXT; (* name of file where script will be written *)
    scriptIn: RefList.T; (* of ScriptRec, in forward order *)
    scripting: ScriptingState := ScriptingState.Off;

VAR actName:= ARRAY ActionType OF TEXT
                  {&quot;Go&quot;, &quot;Step&quot;, &quot;Abort&quot;, &quot;Speed&quot;, &quot;MinDelay&quot;, &quot;CodeDelay&quot;,
                   &quot;SpeedFactor&quot;, &quot;Priority&quot;, &quot;Snapshot&quot;, &quot;Restore&quot;,
                   &quot;Sessions&quot;, &quot;Photo&quot;, &quot;ClearAlbum&quot;, &quot;Algs&quot;, &quot;Views&quot;,
                   &quot;AbortAlg&quot;, &quot;Destroy&quot;, &quot;ToggleTSplit&quot;,
                   &quot;FutureGo&quot;, &quot;FuturePause&quot;, &quot;GrabData&quot;};

PROCEDURE <A NAME="StartScript"><procedure>StartScript</procedure></A>(file: TEXT) =
  &lt;* LL=VBT.mu *&gt;
  BEGIN
    IF scripting = ScriptingState.Off THEN
      scriptOutFile := file;
      scriptOut := NIL;
      ChangeScriptingState(ScriptingState.Recording);
      (* move the following to just after Go/Step has been pressed. *)
</PRE><BLOCKQUOTE><EM>      Script(ActionType.Restore, SnapshotToList());</EM></BLOCKQUOTE><PRE>
    END (* IF *);
  END StartScript;

PROCEDURE <A NAME="StopScript"><procedure>StopScript</procedure></A>() =
  &lt;* LL=VBT.mu *&gt;
  BEGIN
    IF scripting = ScriptingState.Recording THEN
      WriteScript(scriptOutFile);
      ChangeScriptingState(ScriptingState.Off);
    END (* IF *);
  END StopScript;

PROCEDURE <A NAME="WriteScript"><procedure>WriteScript</procedure></A>(file: TEXT) =
  &lt;* LL=VBT.mu *&gt;
  (* write scriptOut to the named file in reverse order *)
  VAR
    wr:= FileWr.Open(file);
    rec: ScriptRec;
    list := RefList.ReverseD(scriptOut);
  BEGIN
    scriptOut := NIL;
    WHILE list # NIL DO
      rec := RefListUtils.Pop(list);
      TRY
        Wr.PutText(wr, &quot;(&quot; &amp; actName[rec.action] &amp; &quot; &quot; &amp;
          &quot;(&quot; &amp; Fmt.Int(rec.clock) &amp; &quot; &quot; &amp; Fmt.Int(rec.subclock) &amp; &quot;) &quot;);
        Sx.Print(wr, rec.args);
        Wr.PutText(wr, &quot;)\n&quot; );
      EXCEPT
        Sx.PrintError =&gt;
      END;
    END (* WHILE *);
    Wr.Close(wr);
  END WriteScript;

PROCEDURE <A NAME="Script"><procedure>Script</procedure></A> (act: ActionType; argsIn: REFANY := NIL) =
</PRE><BLOCKQUOTE><EM> To find the calling sequences for Script(), search for <CODE>ActionType.</CODE>;
   collecting them here doesn't work, since they tend to get obsolete. </EM></BLOCKQUOTE><PRE>
  &lt;* LL=VBT.mu *&gt;
  VAR panel := Resolve(NIL);
  BEGIN
    IF scripting = ScriptingState.Recording THEN
      RefListUtils.Push(scriptOut, NEW(ScriptRec, action := act,
                               clock := panel.clock,
                               subclock := panel.subclock,
                               args := argsIn));
    END (* IF *);
  END Script;

PROCEDURE <A NAME="ScriptMaybeStartFrame"><procedure>ScriptMaybeStartFrame</procedure></A>(panel: T) =
  BEGIN
    LOCK panel.mu DO
      IF stateIdle[panel.runState] AND
        (scripting = ScriptingState.Recording) THEN
        Script(ActionType.Restore, SnapshotToList());
        Script(ActionType.FutureGo);
      END;
    END;
  END ScriptMaybeStartFrame;

PROCEDURE <A NAME="StartPlayback"><procedure>StartPlayback</procedure></A>(file: TEXT) =
  &lt;* LL=VBT.mu *&gt;
  BEGIN
    IF scripting = ScriptingState.Off THEN
      ReadScript(file);
      ChangeScriptingState(ScriptingState.Playback);
      DoNextPlayback(Resolve(NIL));
    END (* IF *);
  END StartPlayback;

PROCEDURE <A NAME="StopPlayback"><procedure>StopPlayback</procedure></A>() =
  &lt;* LL=VBT.mu *&gt;
  BEGIN
    IF scripting = ScriptingState.Playback THEN
      scriptIn := NIL;
      ChangeScriptingState(ScriptingState.Off);
    END (* IF *);
  END StopPlayback;

PROCEDURE <A NAME="DoNextPlayback"><procedure>DoNextPlayback</procedure></A>(panel: T) =
  &lt;*LL = VBT.mu*&gt;
  VAR rec: ScriptRec;
      b: BOOLEAN;
  BEGIN
    IF scripting = ScriptingState.Playback THEN
      LOOP
        IF scriptIn = NIL THEN StopPlayback(); EXIT; END;
        rec := scriptIn.head;
        LOCK panel.mu DO
          b := (stateIdle[panel.runState] AND
                 (rec.clock + rec.subclock + panel.clock + panel.subclock = 0))
               OR ((rec.clock + rec.subclock # 0)
                   AND ((panel.clock &gt; rec.clock)
                        OR ((panel.clock = rec.clock)
                            AND (panel.subclock &gt;= rec.subclock))));
        END;
        IF b THEN
          EVAL RefListUtils.Pop(scriptIn);
          IF NOT Playback(panel, rec) THEN EXIT END;
        ELSE
          EXIT;
        END;
      END (* LOOP *);
    END;
  END DoNextPlayback;

PROCEDURE <A NAME="FlushFramePlayback"><procedure>FlushFramePlayback</procedure></A>() =
  &lt;* LL=VBT.mu *&gt;
  (* Delete all ScriptRecs up to the next one for time (0,0) *)
  PROCEDURE NotAtFrameStart(rec: ScriptRec): BOOLEAN =
    BEGIN
      RETURN (rec.clock + rec.subclock # 0)
    END NotAtFrameStart;
  BEGIN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>ffp </CODE>); END;</EM></BLOCKQUOTE><PRE>
    IF scripting = ScriptingState.Playback THEN
      WHILE (scriptIn # NIL) AND NotAtFrameStart(scriptIn.head) DO
        EVAL RefListUtils.Pop(scriptIn);
      END;
    END;
    IF scriptIn = NIL THEN StopPlayback(); END;
  END FlushFramePlayback;

PROCEDURE <A NAME="Playback"><procedure>Playback</procedure></A>(panel: T; rec: ScriptRec):  BOOLEAN =
  (* Return TRUE if playback may continue, FALSE if algorithm should
     execute at least one step now. *)
  &lt;* LL=VBT.mu *&gt;
  PROCEDURE SessFromPos(pos: REF INTEGER): Session =
    BEGIN
      LOCK panel.mu DO
        IF RefList.Length(panel.sessions) &gt; pos^ THEN
          RETURN NARROW(RefList.Nth(panel.sessions, pos^), Session);
        ELSE
          ReportError(&quot;Playback error: not enough sessions&quot;);
          RETURN NIL;
        END;
      END;
    END SessFromPos;
  BEGIN
</PRE><BLOCKQUOTE><EM> IF debugP THEN DebugWrite(<CODE>play:</CODE> &amp; Fmt.Int(ORD(rec.action)) &amp; <CODE> </CODE>); END;</EM></BLOCKQUOTE><PRE>
    CASE rec.action OF
    | ActionType.Go =&gt;
        (*        Go(panel, 0);*)    (* see FutureGo *)
    | ActionType.Step =&gt;
        (*        Step(panel, 0);*)    (* see FutureGo *)
    | ActionType.Abort =&gt;
        AbortInternal(panel, 0);
    | ActionType.Speed =&gt;
        ToFancySlider(panel, NARROW(rec.args, REF REAL)^);
        UpdateSpeed(panel);    (* works because scripting # Recording *)
    | ActionType.MinDelay =&gt;
        ToSimpleSlider(panel, &quot;minDelayFrac&quot;, NARROW(rec.args, REF REAL)^);
        UpdateMinDelay(panel);
    | ActionType.CodeDelay =&gt;
        ToSimpleSlider(panel, &quot;codeDelayFrac&quot;, NARROW(rec.args, REF REAL)^);
        UpdateCodeDelay(panel);
    | ActionType.SpeedFactor =&gt;
        FormsVBT.PutText(panel.fv, &quot;maxSpeedFactor&quot;, rec.args);
        UpdateSpeedFactor(panel);
    | ActionType.Priority =&gt;
        SetPanelPriority(panel, NARROW(rec.args, REF INTEGER)^);
    | ActionType.Snapshot =&gt;
        (* don't do snapshot during playback *)
        (*        ZeusSnapshot.Snapshot(panel, rec.args);*)
    | ActionType.Restore =&gt;
        TYPECASE rec.args OF
        | TEXT (file) =&gt;
            ZeusSnapshot.Restore(panel, file);
        | RefList.T (list) =&gt;
            ZeusSnapshot.RestoreFromList(panel, list);
        ELSE (* do nothing if restore format is wrong *)
        END;
    | ActionType.Sessions =&gt;
        (* do nothing; will be caught at next frame start *)
        (* NOTE: REF BOOLEAN is also wrong type, it is Sx.True or Sx.False (an Atom.T) *)
        (*        FormsVBT.PutBoolean(panel.fv, &quot;inTrestle&quot;,
                            NARROW(rec.args.tail.head, REF BOOLEAN)^);
           NewSessionDefault(rec.args.head, panel);
        *)
    | ActionType.Photo =&gt;
        Photo(panel);
    | ActionType.ClearAlbum =&gt;
        ClearAlbum(panel);
    | ActionType.Algs =&gt;
        (* do nothing; will be caught at next frame start *)
        (*        WITH sess = SessFromPos(rec.args.head) DO
          IF sess # NIL THEN
            PickedAlg(sess, rec.args.tail.head);
            TRY
              IF sess.alg # NIL THEN sess.alg.restore(NIL); END;
            EXCEPT
              ZeusClass.Error =&gt;
            END;
          END;
        END;
        *)
    | ActionType.Views =&gt;
        (* do nothing; will be caught at next frame start *)
        (*        WITH sess = SessFromPos(rec.args.head) DO
          IF sess # NIL THEN
            WITH view = PickedView(sess, rec.args.tail.head) DO
              TRY
                IF view # NIL THEN view.restore(NIL); END;
              EXCEPT
                ZeusClass.Error =&gt;
              END;
            END;
          END;
        END;
        *)
    | ActionType.AbortAlg =&gt;
        WITH sess = SessFromPos(rec.args) DO
          IF sess # NIL THEN AbortAlg(sess); END;
        END;
    | ActionType.Destroy =&gt;
        WITH sess = SessFromPos(rec.args) DO
          (* This works because Script checks the &quot;scripting&quot; variable. *)
          IF sess # NIL THEN DestroyP(NIL, NIL, sess, 0); END;
        END;
    | ActionType.ToggleTSplit =&gt;
        IF NOT stateIdle[panel.runState] THEN
          (* number of sessions not preserved during idle states. *)
          WITH sess = SessFromPos(NARROW(rec.args, RefList.T).head) DO
            (* This works because Script checks the &quot;scripting&quot; variable. *)
            IF sess # NIL THEN
              ToggleTSplitP(sess.fv, NARROW(rec.args, RefList.T).tail.head, sess, 0);
            END;
          END;
        END;
    | ActionType.FutureGo =&gt;
        SetRunState(panel, RunState.Running, &quot;Playback Mode&quot;);
        Thread.Broadcast(panel.runCond);
        RETURN FALSE;
    | ActionType.FuturePause =&gt;
        SetRunState(panel, RunState.Paused, &quot;Under playback control&quot;);
    | ActionType.GrabData =&gt;
        ZeusSnapshot.RestoreData(panel, rec.args);
        ChangeScriptingState(scripting);
    END (* CASE *);
    RETURN TRUE;
  END Playback;

EXCEPTION BadScript;

PROCEDURE <A NAME="ReadScript"><procedure>ReadScript</procedure></A>(file: TEXT) =
  &lt;* LL=VBT.mu *&gt;
  (* read in scriptIn from the named file *)
  PROCEDURE ParseAct(a: REFANY): ActionType
      RAISES {BadScript} =
    BEGIN
      TYPECASE a OF
      | Atom.T (sxs) =&gt;
          WITH name = Atom.ToText(sxs) DO
            FOR i := FIRST(ActionType) TO LAST(ActionType) DO
              IF Text.Equal(name, actName[i]) THEN RETURN i END;
            END;
            RAISE BadScript;
          END;
      ELSE RAISE BadScript;
      END;
    END ParseAct;
  VAR
    rd:= FileRd.Open(file);
    ref: REFANY := NIL;
  BEGIN
    scriptIn := NIL;
    TRY
      WHILE NOT Rd.EOF(rd) DO
        TYPECASE Sx.Read(rd) OF
        | RefList.T (l) =&gt;
            IF RefList.Length(l) &gt;= 3 THEN ref := l.tail.tail.head END;
            WITH l2 = l.tail.head DO
              IF ISTYPE(l2, RefList.T)
                    AND (RefList.Length(l2) = 2)
                    AND ISTYPE(RefList.Nth(l2, 0), REF INTEGER)
                    AND ISTYPE(RefList.Nth(l2, 1), REF INTEGER) THEN
                RefListUtils.Push(
                    scriptIn,
                    NEW(ScriptRec,
                        action := ParseAct(l.head),
                        clock := NARROW(RefList.Nth(l2, 0), REF INTEGER)^,
                        subclock := NARROW(RefList.Nth(l2, 1), REF INTEGER)^,
                        args := ref));
              ELSE
                RAISE BadScript;
              END;
            END;
        ELSE
            RAISE BadScript;
        END;
      END (* WHILE *);
    EXCEPT
    | BadScript, Sx.ReadError =&gt; ReportError(&quot;Bad script format&quot;);
    ELSE
    END;
    scriptIn := RefList.ReverseD(scriptIn);
    Rd.Close(rd);
  END ReadScript;

PROCEDURE <A NAME="ChangeScriptingState"><procedure>ChangeScriptingState</procedure></A> (newState: ScriptingState) =
</PRE><BLOCKQUOTE><EM> Implement the ScriptingState finite state machine. </EM></BLOCKQUOTE><PRE>
  VAR panel := Resolve(NIL);
      fv := panel.fv;
  BEGIN (* LL = VBT.mu *)
    scripting := newState;
    IF scripting = ScriptingState.Off THEN
      FormsVBT.PutText(fv, &quot;recordBtnText&quot;, &quot;Record ...&quot;);
      FormsVBT.PutText(fv, &quot;playbackBtnText&quot;, &quot;Playback ...&quot;);
      ActivateScriptButtons(panel);
    ELSIF scripting = ScriptingState.Recording THEN
      FormsVBT.PutText(fv, &quot;recordBtnText&quot;, &quot;Stop Recording&quot;);
      FormsVBT.PutText(fv, &quot;playbackBtnText&quot;, &quot;Playback ...&quot;);
      FormsVBT.MakeActive(fv, &quot;recordBtn&quot;);
      FormsVBT.MakeDormant(fv, &quot;playbackBtn&quot;);
    ELSIF scripting = ScriptingState.Playback THEN
      FormsVBT.PutText(fv, &quot;recordBtnText&quot;, &quot;Record ...&quot;);
      FormsVBT.PutText(fv, &quot;playbackBtnText&quot;, &quot;Stop Playback&quot;);
      FormsVBT.MakeDormant(fv, &quot;recordBtn&quot;);
      FormsVBT.MakeActive(fv, &quot;playbackBtn&quot;);
    END;
    IF scripting = ScriptingState.Recording THEN
      FormsVBT.MakeActive(fv, &quot;futurePause&quot;);
      FormsVBT.MakeActive(fv, &quot;grabData&quot;);
    ELSE
      FormsVBT.MakeDormant(fv, &quot;futurePause&quot;);
      FormsVBT.MakeDormant(fv, &quot;grabData&quot;);
    END;
    FormsVBT.PopDown(fv, &quot;RecordDialog&quot;);
    FormsVBT.PopDown(fv, &quot;PlaybackDialog&quot;);
  END ChangeScriptingState;

PROCEDURE <A NAME="ActivateScriptButtons"><procedure>ActivateScriptButtons</procedure></A>(panel: T) =
  &lt;* LL = VBT.mu *&gt;
  BEGIN
    IF scripting = ScriptingState.Off THEN
      WITH fv = panel.fv DO
        IF stateIdle[panel.runState] THEN
          FormsVBT.MakeActive(fv, &quot;playbackBtn&quot;);
          FormsVBT.MakeActive(fv, &quot;recordBtn&quot;);
        ELSE
          FormsVBT.MakeDormant(fv, &quot;playbackBtn&quot;);
          FormsVBT.MakeDormant(fv, &quot;recordBtn&quot;);
        END;
      END;
    ELSIF scripting = ScriptingState.Recording THEN
      WITH fv = panel.fv DO
        IF stateIdle[panel.runState] THEN
          FormsVBT.MakeDormant(fv, &quot;futurePause&quot;);
          FormsVBT.MakeDormant(fv, &quot;grabData&quot;);
        ELSE
          FormsVBT.MakeActive(fv, &quot;futurePause&quot;);
          FormsVBT.MakeActive(fv, &quot;grabData&quot;);
        END;
      END;
    END;
  END ActivateScriptButtons;
</PRE> **************** Utilities **************** 

<P><PRE>PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (v: ZeusClass.T): T =
  (* LL = arbitrary *)
  (* This should never be called with any argument but NIL.  Probably
     should go away soon. *)
  BEGIN
    IF v = NIL THEN
      RETURN ControlPanel;
    ELSE
      &lt;* ASSERT FALSE *&gt;
</PRE><BLOCKQUOTE><EM>      RETURN NARROW(VBT.GetProp(v, TYPECODE(T)), T);</EM></BLOCKQUOTE><PRE>
    END;
  END Resolve;

&lt;*UNUSED*&gt; PROCEDURE <A NAME="Bound"><procedure>Bound</procedure></A> (val: INTEGER; min, max: INTEGER): INTEGER =
  BEGIN
    RETURN MAX(min, MIN(val, max))
  END Bound;

PROCEDURE <A NAME="TextEditVBTAppend"><procedure>TextEditVBTAppend</procedure></A> (v: TextEditVBT.T; text: TEXT) =
  (* LL = VBT.mu *)
  BEGIN
    TextPort.PutText(v.tp, text);
  END TextEditVBTAppend;

PROCEDURE <A NAME="TextEditVBTClear"><procedure>TextEditVBTClear</procedure></A> (v: TextEditVBT.T) =
  BEGIN
    TextPort.SetText(v.tp, &quot;&quot;)
  END TextEditVBTClear;

PROCEDURE <A NAME="InsertToBrowser"><procedure>InsertToBrowser</procedure></A> (tp: ListVBT.T; name: TEXT) =
  (* LL = VBT.mu *)
  VAR len := tp.count();
  BEGIN
    FOR i := 0 TO len - 1 DO
      IF Text.Compare(name, tp.getValue(i)) = -1 THEN
        tp.insertCells(i, 1);
        tp.setValue(i, name);
        RETURN;
      END;
    END;
    tp.insertCells(len, 1);
    tp.setValue(len, name);
  END InsertToBrowser;

PROCEDURE <A NAME="DeleteFromBrowser"><procedure>DeleteFromBrowser</procedure></A> (tp: ListVBT.T; name: TEXT) =
  (* LL = VBT.mu *)
  BEGIN
    FOR i := 0 TO tp.count() - 1 DO
      IF Text.Equal(name, tp.getValue(i)) THEN
        tp.removeCells(i, 1);
        RETURN;
      END;
    END;
  END DeleteFromBrowser;

PROCEDURE <A NAME="SelectInBrowser"><procedure>SelectInBrowser</procedure></A> (tp: ListVBT.T; name: TEXT) =
  (* LL = VBT.mu *)
  BEGIN
    FOR i := 0 TO tp.count() DO
      IF Text.Equal(name, tp.getValue(i)) THEN
        tp.selectOnly(i);
        RETURN;
      END;
    END;
  END SelectInBrowser;

PROCEDURE <A NAME="RenameTrestleChassis"><procedure>RenameTrestleChassis</procedure></A> (v: VBT.T; title: TEXT) =
  (* LL = VBT.mu *)
  BEGIN
    Trestle.Decorate(v, NIL, title);
  END RenameTrestleChassis;

PROCEDURE <A NAME="MoveNear"><procedure>MoveNear</procedure></A> (u, v: VBT.T) =
  (* LL = VBT.mu *)
  (* Replace Trestle.MoveNear(u, v).  No, revert to Trestle-style. *)
  BEGIN
    Trestle.MoveNear(u, v);
</PRE><BLOCKQUOTE><EM><P>
    WITH dom = VBT.Domain(v),
         ne  = Trestle.ScreenOf(v, Rect.NorthEast(dom)) DO
      IF (ne.trsl # NIL) AND (ne.id # Trestle.NoScreen) THEN
        Trestle.Overlap(
          u, ne.id, Point.Add(ne.q, Point.FromCoords(-10, 30)));
      ELSE
        Trestle.MoveNear(u, v);
      END;
    END;
</EM></BLOCKQUOTE><PRE>
  END MoveNear;

PROCEDURE <A NAME="CheckPrefix"><procedure>CheckPrefix</procedure></A> (t, pref: TEXT; VAR (*OUT*) res: TEXT): BOOLEAN =
  (* LL = arbitrary *)
  (* If pref is a prefix of t, set res := the suffix of t and return TRUE;
     else return FALSE, with res unspecified. *)
  VAR len := Text.Length(pref);
  BEGIN
    IF Text.Equal(pref, Text.Sub(t, 0, len)) THEN
      res := Text.Sub(t, len, LAST(CARDINAL));
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END CheckPrefix;

PROCEDURE <A NAME="SnapshotToList"><procedure>SnapshotToList</procedure></A> (): REFANY =
  VAR sx: REFANY;
  BEGIN
    WITH twr = TextWr.New() DO
      ZeusSnapshot.SnapshotToWr(Resolve(NIL), twr);
      TRY
        sx := Sx.Read(TextRd.New(TextWr.ToText(twr)))
      EXCEPT
        Rd.EndOfFile, Sx.ReadError =&gt;
      END;
      RETURN sx;
    END;
  END SnapshotToList;
</PRE> **************** Debugging **************** 

<P><PRE>VAR debugWr := TextWr.New();
    debugMu := NEW(MUTEX);
    debugP := FALSE;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="DebugWrite"><procedure>DebugWrite</procedure></A>(t: TEXT) =
  BEGIN
    LOCK debugMu DO Wr.PutText(debugWr, t); END;
  END DebugWrite;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="DebugStart"><procedure>DebugStart</procedure></A>() =
  BEGIN
    LOCK debugMu DO debugP := TRUE; END;
  END DebugStart;

&lt;*UNUSED*&gt;
PROCEDURE <A NAME="DebugFinish"><procedure>DebugFinish</procedure></A>() =
  BEGIN
    LOCK debugMu DO
      debugP := FALSE;
      Wr.PutText(Stdio.stderr, TextWr.ToText(debugWr));
    END;
  END DebugFinish;
</PRE> **************** Mainline **************** 

<P><PRE>BEGIN
  LOCK VBT.mu DO ControlPanel := NewPanel(); END;
END ZeusPanel.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
