<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusPanelPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusPanelPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;

INTERFACE <interface><A HREF="ZeusPanel.m3">ZeusPanelPrivate</A></interface>;

IMPORT <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="Zeus.i3">Zeus</A>,  <A HREF="ZeusClass.i3">ZeusClass</A>;

TYPE
  RunState = {Virgin, Running, Stepping, Paused, Done, Aborted};
</PRE> CONST 
<PRE>VAR stateIdle := ARRAY RunState OF BOOLEAN
            {TRUE, FALSE, FALSE, FALSE, TRUE, TRUE};

CONST Log10: LONGREAL = 2.3025850930d0;

TYPE
  T = ROOT OBJECT
        title   : TEXT;
        path    : Rsrc.Path;
        fv      : FormsVBT.T;
        scale   : REAL := 1.0;  (* scale factor for control panels *)
        fvpath  : Rsrc.Path;    (* my internal path *)
        sessions: RefList.T;       (* of Session *)

        (* Used by &quot;speedometer&quot;: *)
        speedFactor   : REAL     := 10.0;   (* load value from form *)
        logSpeedFactor: LONGREAL := Log10;
        delayTime     : REAL     := 0.0;    (* load value from form *)
        minDelayFrac  : REAL     := 0.0;    (* ditto *)
        codeDelayFrac : REAL     := 0.0;    (* ditto *)

        (* Used by &quot;interpreter&quot;: *)
        panelThread: Thread.T;
        priority   : INTEGER    := 1;    (* load value from form *)
        mu         : MUTEX;     &lt;* LL(mu) &gt; VBT.mu *&gt;
            (* LL ==&gt; a thread with mu locked must not acquire VBT.mu *)
        runCond   : Thread.Condition;
        algCond   : Thread.Condition;
        runState  : RunState;
        numActive : CARDINAL           := 0;
            (* numActive = number of sess IN sessions s.t. sess.active *)
        numRunning: CARDINAL           := 0;
            (* numRunning = number of sessions s.t. sess.running.
               A bug is possible here, if a session gets deleted, but keeps
               running, while panelThread is awakened and assumes that no
               sessions are running. *)
        mustSynch : BOOLEAN            := FALSE;
        clock     : CARDINAL           := 0;
        subclock  : CARDINAL           := 0;
        quit      : BOOLEAN            := FALSE;

        (* Used by &quot;photo&quot; and &quot;album&quot; *)
        album: VBT.T;
        cntViews: CARDINAL;
      END;

  Session = Zeus.Session OBJECT
              name      : TEXT;
              viewsToAdd: RefList.T (* of View.T *) := NIL; &lt;* LL = VBT.mu *&gt;
              inTrestle : BOOLEAN;
              fv        : FormsVBT.T;
              algThread : Thread.T;
              runCond   : Thread.Condition;
              feedCond  : Thread.Condition;
              feedbackOn: BOOLEAN                := FALSE;
              algIsSet: BOOLEAN := FALSE; (* alg not defaulted *)
              active: BOOLEAN := FALSE; (* alg started, not yet stopped *)
              running  : BOOLEAN    := FALSE; (* alg not paused *)
              waitUntil: CARDINAL;  (* used for event weights *)
              quit     : BOOLEAN    := FALSE;
            OVERRIDES
              pre  := PreEventCallback;
              post := PostEventCallback;
            END;

PROCEDURE <A HREF="ZeusPanel.m3#NewSession">NewSession</A> (name     : TEXT;
                      panel    : T;
                      inTrestle: BOOLEAN;
                      pickAlg  : BOOLEAN   := TRUE);
  &lt;* LL = VBT.mu *&gt;
  (* Create a new session, as a new top-level window if inTrestle, in the
     Zeus panel otherwise. If pickAlg, call PickedAlg on the first alg assoc
     with the new session. *)

PROCEDURE <A HREF="ZeusPanel.m3#PickedAlg">PickedAlg</A> (sess: Session; which: TEXT);
  &lt;* LL = VBT.mu *&gt;
  (* Select a new algorithm. *)

PROCEDURE <A HREF="ZeusPanel.m3#PickedView">PickedView</A> (sess: Session; which: TEXT): View.T;
  &lt;* LL = VBT.mu *&gt;
  (* Create a new view. *)

PROCEDURE <A HREF="ZeusPanel.m3#IsCodeView">IsCodeView</A> (which: TEXT; sess: Session; VAR file: TEXT):
  BOOLEAN;
  &lt;* LL = arbitrary *&gt;
  (* Is which a code view? *)

PROCEDURE <A HREF="ZeusPanel.m3#DestroyAllSessions">DestroyAllSessions</A> (panel: T);
</PRE><BLOCKQUOTE><EM> LL = VBT.mu </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#DestroySession">DestroySession</A> (sess: Session);
</PRE><BLOCKQUOTE><EM> LL = VBT.mu </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#LoadFromPanel">LoadFromPanel</A> (panel: T);
</PRE><BLOCKQUOTE><EM> loads parameter values from the control panel FormsVBT </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#PrepForSnapshot">PrepForSnapshot</A>(panel: T);
  (* Call this from ZeusSnapshot.m3 before a snapshot. *)

PROCEDURE <A HREF="ZeusPanel.m3#OverrideRestore">OverrideRestore</A>(panel: T);
  (* Call this from ZeusSnapshot.m3 after a restore to reset things
     that the restore operation shouldn't have changed, but may have. *)

PROCEDURE <A HREF="ZeusPanel.m3#GroupInfoExists">GroupInfoExists</A> (sessName: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> TRUE iff a session has been registered under sessName, i.e., a GroupInfo
   record exists under the given name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZeusPanel.m3#PreEventCallback">PreEventCallback</A> (sess     : Session;
                            initiator: ZeusClass.T;
                            style    : Zeus.EventStyle;
                            priority : INTEGER;
                            eventName: TEXT             )
  RAISES {Thread.Alerted};

PROCEDURE <A HREF="ZeusPanel.m3#PostEventCallback">PostEventCallback</A> (sess     : Session;
                             initiator: ZeusClass.T;
                             style    : Zeus.EventStyle;
                             priority : INTEGER;
                             eventName: TEXT             )
  (* LL &lt;= VBT.mu *)
  RAISES {Thread.Alerted};

END ZeusPanelPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
