<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusSnapshot.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusSnapshot.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
&lt;* PRAGMA LL *&gt;
</PRE> This internal interface provides the ZeusPanel snapshot and restore
   facilities. 

<P><PRE>INTERFACE <interface><A HREF="ZeusSnapshot.m3">ZeusSnapshot</A></interface>;

IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="ZeusPanelPrivate.i3">ZeusPanelPrivate</A>;

CONST
  HomeDir = &quot;HOME&quot;;
  StateDir = &quot;.zeusState&quot;;
  FinalState = &quot;Final_State&quot;;   (* filename for state at &quot;Quit&quot; *)

PROCEDURE <A HREF="ZeusSnapshot.m3#SessionToStateDir">SessionToStateDir</A> (sess  : ZeusPanelPrivate.Session;
                             report: BOOLEAN                    := TRUE)
  RAISES {};
  &lt;* LL = VBT.mu *&gt;

PROCEDURE <A HREF="ZeusSnapshot.m3#SessionFromStateDir">SessionFromStateDir</A> (panel : ZeusPanelPrivate.T;
                               name  : TEXT;
                               report: BOOLEAN := TRUE): BOOLEAN RAISES {};
  &lt;* LL = VBT.mu *&gt;

PROCEDURE <A HREF="ZeusSnapshot.m3#Snapshot">Snapshot</A> (panel : ZeusPanelPrivate.T;
                    file  : TEXT;
                    report: BOOLEAN              := TRUE) RAISES {};
  &lt;* LL = VBT.mu *&gt;

PROCEDURE <A HREF="ZeusSnapshot.m3#SnapshotToWr">SnapshotToWr</A> (panel : ZeusPanelPrivate.T;
                        wr  : Wr.T;
                        report: BOOLEAN          := TRUE) RAISES {};
  &lt;* LL = VBT.mu *&gt;

PROCEDURE <A HREF="ZeusSnapshot.m3#FinalSnapshot">FinalSnapshot</A> (panel : ZeusPanelPrivate.T) RAISES {};
  &lt;* LL = VBT.mu *&gt;
  (* Snapshot to default place at Zeus exit. *)

PROCEDURE <A HREF="ZeusSnapshot.m3#Restore">Restore</A> (panel : ZeusPanelPrivate.T;
                   file  : TEXT;
                   report: BOOLEAN              := TRUE) RAISES {};
  &lt;* LL = VBT.mu *&gt;

PROCEDURE <A HREF="ZeusSnapshot.m3#RestoreFromRd">RestoreFromRd</A> (panel : ZeusPanelPrivate.T;
                         rd    : Rd.T;
                         report: BOOLEAN              := TRUE;
                         file  : TEXT                 := NIL   ) RAISES {};
  &lt;* LL = VBT.mu *&gt;
  (* Restore(p, file) == RestoreFromRd(p, FileStream.OpenRead(file)) *)
  (* The file argument is just to be used in error messages. *)

PROCEDURE <A HREF="ZeusSnapshot.m3#RestoreFromList">RestoreFromList</A> (panel : ZeusPanelPrivate.T;
                           list  : RefList.T;
                           report: BOOLEAN      := TRUE) RAISES {};
  &lt;* LL = VBT.mu *&gt;
  (* RestoreFromRd(p, rd) == RestoreFromList(p, Sx.Read(rd)) *)

PROCEDURE <A HREF="ZeusSnapshot.m3#InitialRestore">InitialRestore</A> (panel : ZeusPanelPrivate.T) RAISES {};
  &lt;* LL = VBT.mu *&gt;
  (* Restore from default place at Zeus startup. *)
</PRE> Procedures to save and restore panel and algorithm data, ignoring
   views completely, under the assumption that the sessions at the time
   of snapshot can be mapped to those in panel.sessions at the time of
   restoration, in the same order. 

<P><PRE>PROCEDURE <A HREF="ZeusSnapshot.m3#GrabDataList">GrabDataList</A>(panel: ZeusPanelPrivate.T): REFANY;
  (* Returns a list. *)

PROCEDURE <A HREF="ZeusSnapshot.m3#RestoreData">RestoreData</A>(panel: ZeusPanelPrivate.T; list: RefList.T);
  (* Restores from a list. *)

END ZeusSnapshot.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
