<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusSnapshot.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusSnapshot.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="ZeusSnapshot.i3">ZeusSnapshot</A></implements></module>;
</PRE> A snapshot is an S-expression, written out by hand but normally read in
   using the Sx package.  Restore methods take an Rd.T as an argument.  A
   snapshot method writes its own data, then calls the snapshot method of
   its supertype.  A restore method reads its own data from the reader,
   then calls its supertype's restore method on the remaining list.
   Snapshot and restore methods must be exact inverses. 

<P> Some restore methods may find it convenient to read the input from the
   Rd.T into a List.T using Sx.Read.  This technique is used extensively
   below. 

<P>
<P><PRE>IMPORT <A HREF="Algorithm.i3">Algorithm</A>, <A HREF="AlgorithmClass.i3">AlgorithmClass</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="Classes.i3">Classes</A>, <A HREF="../../params/src/Env.i3">Env</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../os/src/Common/File.i3">File</A>,
       <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../os/src/Common/FS.i3">FS</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>,
       <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../formsvbt/src/RefListUtils.i3">RefListUtils</A>, <A HREF="../../os/src/Common/RegularFile.i3">RegularFile</A>,
       <A HREF="../../ui/src/split/StableVBT.i3">StableVBT</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>,
       <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View.i3">View</A>, <A HREF="ViewClass.i3">ViewClass</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="Zeus.i3">Zeus</A>, <A HREF="ZeusClass.i3">ZeusClass</A>,
       <A HREF="ZeusPanel.i3">ZeusPanel</A>, <A HREF="ZeusPanelFriends.i3">ZeusPanelFriends</A>, <A HREF="ZeusPanelPrivate.i3">ZeusPanelPrivate</A>,
       <A HREF="ZeusPrivate.i3">ZeusPrivate</A>, <A HREF="ZeusUtil.i3">ZeusUtil</A>;

&lt;*FATAL FormsVBT.Error, FormsVBT.Unimplemented,
        TrestleComm.Failure, Thread.Alerted, Wr.Failure *&gt;
</PRE> Convenience procedures for ZeusPanel init and exit. 

<P><PRE>PROCEDURE <A NAME="FinalSnapshot"><procedure>FinalSnapshot</procedure></A> (panel : ZeusPanelPrivate.T) RAISES {} =
  &lt;* LL = VBT.mu *&gt;
  (* Snapshot to default file at Zeus exit. *)
  BEGIN
    Snapshot(panel, StateDirFile(FinalState), FALSE);
  END FinalSnapshot;

PROCEDURE <A NAME="InitialRestore"><procedure>InitialRestore</procedure></A> (panel : ZeusPanelPrivate.T) RAISES {} =
  &lt;* LL = VBT.mu *&gt;
  (* Restore from default file at Zeus startup. *)
  BEGIN
    Restore(panel, StateDirFile(FinalState), FALSE);
  END InitialRestore;
</PRE> ************ Session Snapshot / Restore ************ 

<P> Snapshot and restore sessions to the StateDir directory 

<P><PRE>PROCEDURE <A NAME="SessionToStateDir"><procedure>SessionToStateDir</procedure></A> (sess  : ZeusPanelPrivate.Session;
                             report: BOOLEAN                    := TRUE)
  RAISES {} =
  VAR
    twr         := TextWr.New();
    fname       := StateDirFile(sess.name);
    wr   : Wr.T;
  BEGIN                          (* LL = VBT.mu *)
    TRY
      SessionToWr(sess, twr);
      wr := FileWr.Open(fname);
      Sx.Print(wr, Sx.Read(TextRd.New(TextWr.ToText(twr))));
      Wr.PutText(wr, &quot;\n&quot;);
      Wr.Close(wr);
    EXCEPT
    | Rd.EndOfFile, Sx.ReadError, Sx.PrintError =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Trouble with Sx in snapshot&quot;);
    | Wr.Failure, OSError.E =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Cannot open file: &quot; &amp; fname);
    | FormsVBT.Error (msg) =&gt; ZeusPanel.ReportErrorC(report, msg);
    | ZeusClass.Error (msg) =&gt; ZeusPanel.ReportErrorC(report, msg);
    | Thread.Alerted =&gt;
        ZeusPanel.ReportErrorC(
          report, &quot;Snapshort alerted; incompletely recorded&quot;);
    END;
  END SessionToStateDir;

PROCEDURE <A NAME="SessionFromStateDir"><procedure>SessionFromStateDir</procedure></A> (panel : ZeusPanelPrivate.T;
                               name  : TEXT;
                               report: BOOLEAN              := TRUE):
  BOOLEAN RAISES {} =
  (* Return TRUE if successful *)
  VAR
    fname         := StateDirFile(name);
    rd   : Rd.T;
    list : RefList.T;
    msg  : TEXT;
  BEGIN                          (* LL = VBT.mu *)
    TRY
      rd := FileRd.Open(fname);
      list := Sx.Read(rd);
    EXCEPT
    | OSError.E =&gt;
        (* no such file or directory *)
        RETURN FALSE;
    | Rd.EndOfFile =&gt;
        ZeusPanel.ReportErrorC(
          report, &quot;Unexpected end of file in &quot; &amp; fname);
        RETURN FALSE;
    | Sx.ReadError (msg) =&gt;
        ZeusPanel.ReportErrorC(
          report, &quot;Syntax error in &quot; &amp; fname &amp; &quot;: &quot; &amp; msg);
        RETURN FALSE;
    | Thread.Alerted =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Alerted while reading &quot; &amp; fname);
        RETURN FALSE;
    END;
    TRY
      RestoreSession(panel, list, FALSE);
      RETURN TRUE;
    EXCEPT
    | BadSnapshot (err) =&gt; msg := err;
    | FormsVBT.Error (err) =&gt; msg := err;
    | ZeusClass.Error (err) =&gt; msg := err;
    | Thread.Alerted =&gt; msg := &quot;interrupted&quot;;
    END;
    ZeusPanel.ReportErrorC(
      report, &quot;Problems restoring file: &quot; &amp; fname &amp; &quot; - &quot; &amp; msg);
    RETURN FALSE;
  END SessionFromStateDir;
</PRE> **************** Snapshot / Restore **************** 

<P><PRE>PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (panel: ZeusPanelPrivate.T;
                    file: TEXT;
                    report: BOOLEAN := TRUE)
  RAISES {} =
  (* LL = VBT.mu *)
  VAR
    wr : Wr.T;
  BEGIN
    TRY
      wr := FileWr.Open(file);
      SnapshotToWr(panel, wr, report);
      Wr.Close(wr);
      FormsVBT.PopDown(panel.fv, &quot;SnapshotDialog&quot;);
    EXCEPT
    | Wr.Failure, OSError.E (*(ec)*) =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Cannot open file: &quot; &amp; file
          (* &amp; &quot; (&quot; &amp; OS.errMessage[ec] &amp; &quot;)&quot;*));
    END;
  END Snapshot;

PROCEDURE <A NAME="SnapshotToWr"><procedure>SnapshotToWr</procedure></A> (panel: ZeusPanelPrivate.T;
                        wr: Wr.T;
                        report: BOOLEAN := TRUE)
  RAISES {} =
  (* LL = VBT.mu *)
  VAR
    twr       := TextWr.New();
  BEGIN
    TRY
      ZeusPanelPrivate.PrepForSnapshot(panel);
      SnapshotWr(panel, twr);
      Sx.Print(wr, Sx.Read(TextRd.New(TextWr.ToText(twr))));
      Wr.PutText(wr, &quot;\n&quot;);
    EXCEPT
    | Rd.EndOfFile, Sx.ReadError, Sx.PrintError =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Trouble with Sx in snapshot&quot;);
    | FormsVBT.Error (msg) =&gt; ZeusPanel.ReportErrorC(report, msg);
    | ZeusClass.Error (msg) =&gt; ZeusPanel.ReportErrorC(report, msg);
    | Thread.Alerted =&gt;
        ZeusPanel.ReportErrorC(
            report, &quot;Snapshort alerted; incompletely recorded&quot;);
    END;
  END SnapshotToWr;

PROCEDURE <A NAME="SnapshotWr"><procedure>SnapshotWr</procedure></A> (panel: ZeusPanelPrivate.T; wr: Wr.T)
  RAISES {FormsVBT.Error, Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR
    l := RefList.Reverse(panel.sessions); (* reverse so order is same after
                                          restoration *)
  BEGIN
    Wr.PutText(wr, &quot;(&quot;);
    panel.fv.snapshot(wr);
    WHILE l # NIL DO SessionToWr(RefListUtils.Pop(l), wr); END;
    Wr.PutText(wr, &quot;)\n&quot;);
  END SnapshotWr;

PROCEDURE <A NAME="SessionToWr"><procedure>SessionToWr</procedure></A> (sess: ZeusPanelPrivate.Session; wr: Wr.T)
  RAISES {FormsVBT.Error, Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR
    dom := VBT.Domain(sess.fv);
    nw  := Trestle.ScreenOf(sess.fv, Rect.NorthWest(dom));
    se  := Trestle.ScreenOf(sess.fv, Rect.SouthEast(dom));
    vlist, addlist: RefList.T;
  BEGIN
    Wr.PutText(wr, &quot;(&quot;);
    Wr.PutText(
      wr, &quot;(InTrestle &quot; &amp; Fmt.Bool(sess.inTrestle) &amp; &quot;)\n&quot;);
    Wr.PutText(wr, &quot;(Session \&quot;&quot; &amp; sess.name &amp; &quot;\&quot;)\n&quot;);
    Wr.PutText(
      wr, &quot;(ScreenPos &quot; &amp; Fmt.Int(nw.id) &amp; &quot; &quot; &amp; Fmt.Int(nw.q.h)
            &amp; &quot; &quot; &amp; Fmt.Int(nw.q.v) &amp; &quot; &quot; &amp; Fmt.Int(se.q.h) &amp; &quot; &quot;
            &amp; Fmt.Int(se.q.v) &amp; &quot;)\n&quot;);
    Wr.PutText(wr, &quot;(FV &quot;);
    sess.fv.snapshot(wr);
    Wr.PutText(wr, &quot;)\n&quot;);
    AlgToWr(wr, sess.alg);
    Wr.PutText(wr, &quot;(&quot;);
    Zeus.Acquire(sess);
    vlist := sess.views;
    addlist := sess.viewsToAdd;
    WHILE addlist # NIL DO
      WITH v = RefListUtils.Pop(addlist) DO
        IF NOT RefList.Member(vlist, v) THEN RefListUtils.Push(vlist, v); END;
      END;
    END;
    ViewsToWr(wr, sess, vlist);
    Zeus.Release(sess);
    Wr.PutText(wr, &quot;)&quot;);
    Wr.PutText(wr, &quot;)\n&quot;);
  END SessionToWr;

PROCEDURE <A NAME="AlgToWr"><procedure>AlgToWr</procedure></A> (wr: Wr.T; alg: Algorithm.T)
  RAISES {Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  BEGIN
    Wr.PutText(wr, &quot;(&quot;);
    IF (alg # NIL) AND NOT Text.Equal(alg.name, &quot;&quot;) THEN
      Wr.PutText(wr, &quot;(Alg \&quot;&quot; &amp; alg.name &amp; &quot;\&quot;)\n&quot;);
      alg.snapshot(wr);
    ELSE
      Wr.PutText(wr, &quot;(Alg \&quot;NIL\&quot;)\n&quot;);
    END;
    Wr.PutText(wr, &quot;)\n&quot;);
  END AlgToWr;

PROCEDURE <A NAME="ViewsToWr"><procedure>ViewsToWr</procedure></A> (           wr   : Wr.T;
                     &lt;*UNUSED*&gt; sess : ZeusPanelPrivate.Session;
                                views: RefList.T (* of View.T *))
  RAISES {ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR
    rest: RefList.T;
    view: View.T;
    scr : Trestle.ScreenOfRec;
  BEGIN
    rest := views;
    WHILE rest # NIL DO
      view := NARROW(rest.head, View.T);
      scr := Trestle.ScreenOf(view, Point.Origin);
      (* this test wouldn't be needed if deleting views got rid of them: *)
      IF scr.id # Trestle.NoScreen THEN
        Wr.PutText(wr, &quot;(&quot;);
        Wr.PutText(wr, &quot;(View \&quot;&quot; &amp; view.name &amp; &quot;\&quot;)\n&quot;);
        view.snapshot(wr);
        Wr.PutText(wr, &quot;)\n&quot;);
      END;
      rest := rest.tail;
    END;
  END ViewsToWr;

EXCEPTION
  BadSnapshot( TEXT );

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (panel : ZeusPanelPrivate.T;
                   file  : TEXT;
                   report: BOOLEAN              := TRUE) RAISES {} =
  (* LL = VBT.mu *)
  VAR rd: Rd.T;
  BEGIN
    TRY
      rd := FileRd.Open(file);
    EXCEPT
    | OSError.E =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Cannot open file: &quot; &amp; file);
        RETURN;
    END;
    RestoreFromRd(panel, rd, report, file);
    FormsVBT.PopDown(panel.fv, &quot;RestoreDialog&quot;);
  END Restore;

PROCEDURE <A NAME="RestoreFromRd"><procedure>RestoreFromRd</procedure></A> (panel : ZeusPanelPrivate.T;
                         rd    : Rd.T;
                         report: BOOLEAN              := TRUE;
                         file  : TEXT                 := NIL   )
  RAISES {} =
  &lt;* LL = VBT.mu *&gt;
  (* Restore(p, file) == RestoreFromRd(p, FileRd.Open(file)) *)
  VAR
    list: RefList.T;
    ra  : REFANY;
  BEGIN
    TRY
      ra := Sx.Read(rd);
      IF ISTYPE(ra, RefList.T) THEN
        list := ra
      ELSE
        RAISE Sx.ReadError(&quot;File does not contain a RefList.T&quot;)
      END;
    EXCEPT
    | Rd.EndOfFile =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Unexpected end of file in &quot; &amp; file);
        RETURN;
    | Sx.ReadError (msg) =&gt;
        ZeusPanel.ReportErrorC(
          report, &quot;Syntax error in &quot; &amp; file &amp; &quot;: &quot; &amp; msg);
        RETURN;
    | Thread.Alerted =&gt;
        ZeusPanel.ReportErrorC(report, &quot;Alerted while reading &quot; &amp; file);
        RETURN;
    END;
    RestoreFromList(panel, list, report);
  END RestoreFromRd;

PROCEDURE <A NAME="RestoreFromList"><procedure>RestoreFromList</procedure></A> (panel: ZeusPanelPrivate.T;
                           list: RefList.T;
                           report: BOOLEAN := TRUE)
    RAISES {} =
  VAR msg: TEXT;
  BEGIN
    ZeusPanelPrivate.DestroyAllSessions(panel);
    TRY
      PrivateRestoreFromList(panel, list);
      ZeusPanelPrivate.OverrideRestore(panel);
      RETURN;
    EXCEPT
    | BadSnapshot (err) =&gt; msg := err;
    | FormsVBT.Error (err) =&gt; msg := err;
    | ZeusClass.Error (err) =&gt; msg := err;
    | Thread.Alerted =&gt; msg := &quot;interrupted&quot;;
    END;
    ZeusPanel.ReportErrorC(
        report, &quot;Problems restoring from snapshot: &quot; &amp; msg);
    ZeusPanelPrivate.DestroyAllSessions(panel);
  END RestoreFromList;

PROCEDURE <A NAME="PrivateRestoreFromList"><procedure>PrivateRestoreFromList</procedure></A> (panel: ZeusPanelPrivate.T; list: RefList.T)
  RAISES {BadSnapshot, FormsVBT.Error, Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR
    l      : RefList.T;
    wr: TextWr.T;
  BEGIN
    IF list = NIL THEN RAISE BadSnapshot(&quot;Snapshot list is empty&quot;) END;
    l := RefListUtils.Pop(list); (* Snapshot brackets w/ parens *)
    TRY
      wr := TextWr.New();
      Sx.Print(wr, l);
      panel.fv.restore(TextRd.New(TextWr.ToText(wr)));
    EXCEPT
      Sx.PrintError, FormsVBT.Mismatch =&gt;
    END;
    ZeusPanelPrivate.LoadFromPanel(panel);

    WHILE (list # NIL) DO
      IF (NOT ISTYPE(list.head, RefList.T)) OR (list.head = NIL) THEN
        RAISE BadSnapshot(&quot;Not a valid snapshot&quot;);
      END;
      l := RefListUtils.Pop(list);
      TYPECASE l.head OF
      | RefList.T =&gt; RestoreSession(panel, l, TRUE);
      ELSE
        RAISE BadSnapshot(&quot;Not a valid snapshot&quot;);
      END;
    END;
  END PrivateRestoreFromList;

PROCEDURE <A NAME="RestoreSession"><procedure>RestoreSession</procedure></A> (panel     : ZeusPanelPrivate.T;
                          list      : RefList.T;
                          restoreIT : BOOLEAN)
  RAISES {BadSnapshot, FormsVBT.Error, Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  (* If restoreIT, put the session where it wants to be; o/w, put it in
     Trestle or not as dictated by the panel. *)
  VAR
    sess   : ZeusPanelPrivate.Session;
    bool   : BOOLEAN;
    l      : RefList.T;
    keyword: TEXT;
  BEGIN
    bool := FormsVBT.GetBoolean(panel.fv, &quot;inTrestle&quot;);
    TRY
      WHILE (list # NIL) DO
        IF NOT ISTYPE(list.head, RefList.T) THEN
          RAISE BadSnapshot(&quot;Invalid session snapshot&quot;);
        END;
        l := RefListUtils.Pop(list);
        IF l # NIL THEN
          TYPECASE l.head OF
          | Atom.T (sxs) =&gt;
              keyword := Atom.ToText(sxs);
              IF Text.Equal(keyword, &quot;InTrestle&quot;) THEN
                IF restoreIT THEN bool := GetSessInTrestle(l) END;
              ELSIF Text.Equal(keyword, &quot;Session&quot;) THEN
                sess := GetSession(panel, l, bool);
              ELSIF Text.Equal(keyword, &quot;ScreenPos&quot;) THEN
                IF (sess # NIL) AND sess.inTrestle THEN
                  GetSessPosition(panel, sess, l);
                END;
              ELSIF Text.Equal(keyword, &quot;FV&quot;) THEN
                IF sess # NIL THEN GetSessFV(sess, l) END;
              ELSE
                RAISE BadSnapshot(&quot;Unknown keyword&quot;);
              END;
          | RefList.T (lfirst) =&gt;
              IF sess # NIL THEN
                TYPECASE lfirst.head OF
                | Atom.T =&gt; GetAlg(sess, l);
                | RefList.T =&gt; GetViews(sess, l);
                ELSE
                  RAISE BadSnapshot(&quot;Invalid session snapshot&quot;);
                END;
              END;
          ELSE
            RAISE BadSnapshot(&quot;Invalid session snapshot&quot;);
          END;
        END;
      END;
    EXCEPT
    | BadSnapshot (msg) =&gt;
        IF sess # NIL THEN ZeusPanelPrivate.DestroySession(sess); END;
        RAISE BadSnapshot(msg);
    END;
  END RestoreSession;

PROCEDURE <A NAME="GetSession"><procedure>GetSession</procedure></A> (panel: ZeusPanelPrivate.T; arg: REFANY; inTrestle: BOOLEAN): ZeusPanelPrivate.Session
  RAISES {BadSnapshot} =
  (* LL = VBT.mu *)
  VAR sess: ZeusPanelPrivate.Session;
  BEGIN
    KeywordCheck(arg, &quot;Session&quot;);
    IF ISTYPE(arg, RefList.T) AND (RefList.Length(arg) = 2)
         AND ISTYPE(RefList.Nth(arg, 1), TEXT)
         AND ZeusPanelPrivate.GroupInfoExists(RefList.Nth(arg, 1)) THEN
      ZeusPanelPrivate.NewSession(RefList.Nth(arg, 1), panel, inTrestle, FALSE);
      sess := panel.sessions.head;
    ELSE
      RAISE BadSnapshot(&quot;Garbled session name&quot;);
    END;
    RETURN sess;
  END GetSession;

PROCEDURE <A NAME="GetSessInTrestle"><procedure>GetSessInTrestle</procedure></A> (arg: REFANY): BOOLEAN RAISES {BadSnapshot} =
  (* LL = VBT.mu *)
  BEGIN
    KeywordCheck(arg, &quot;InTrestle&quot;);
    IF ISTYPE(arg, RefList.T) AND (RefList.Length(arg) = 2)
         AND ISTYPE(RefList.Nth(arg, 1), Atom.T) THEN
      IF RefList.Nth(arg, 1) = Sx.True THEN
        RETURN TRUE
      ELSIF RefList.Nth(arg, 1) = Sx.False THEN
        RETURN FALSE
      ELSE
        RAISE BadSnapshot(&quot;Garbled inTrestle parameter&quot;);
      END;
    ELSE
      RAISE BadSnapshot(&quot;Garbled inTrestle parameter&quot;);
    END;
  END GetSessInTrestle;

PROCEDURE <A NAME="GetSessPosition"><procedure>GetSessPosition</procedure></A> (panel: ZeusPanelPrivate.T; sess: ZeusPanelPrivate.Session; arg: REFANY)
  RAISES {BadSnapshot} =
  (* LL = VBT.mu *)
  VAR l: RefList.T;
  PROCEDURE NarrowToInt (r: REFANY): INTEGER RAISES {BadSnapshot} =
    BEGIN
      TYPECASE r OF
      | REF INTEGER (rint) =&gt; RETURN rint^;
      ELSE
        RAISE BadSnapshot(&quot;Integer arg expected in position&quot;);
      END;
    END NarrowToInt;
  BEGIN
    IF ISTYPE(arg, RefList.T) AND (RefList.Length(arg) = 6) THEN
      l := arg;
      KeywordCheck(l, &quot;ScreenPos&quot;);
      SetSessPosition(
        panel, sess, NarrowToInt(RefList.Nth(l, 1)),
        NarrowToInt(RefList.Nth(l, 2)), NarrowToInt(RefList.Nth(l, 3)),
        NarrowToInt(RefList.Nth(l, 4)), NarrowToInt(RefList.Nth(l, 5)));
    ELSE
      RAISE BadSnapshot(&quot;Error in session position&quot;);
    END;
  END GetSessPosition;

PROCEDURE <A NAME="SetSessPosition"><procedure>SetSessPosition</procedure></A> (&lt;*UNUSED*&gt; panel: ZeusPanelPrivate.T;
                                      sess : ZeusPanelPrivate.Session;
                                      id   : INTEGER;
                           nwh, nwv, seh, sev: INTEGER) =
  (* LL = VBT.mu *)
  VAR
    nw := Point.FromCoords(nwh, nwv);
    se := Point.FromCoords(seh, sev);
    v  := sess.fv;
  BEGIN
    DEC(nw.h, ZeusPanelFriends.XDRIFT);
    DEC(nw.v, ZeusPanelFriends.YDRIFT);
    DEC(se.h, ZeusPanelFriends.XDRIFT);
    DEC(se.v, ZeusPanelFriends.YDRIFT);
    IF ZeusUtil.ScreenPosOK(id, nw) THEN
      StableVBT.SetShape(v, ABS(se.h - nw.h), ABS(se.v - nw.v));
      Trestle.Overlap(v, id, nw);
    ELSE
      (* leave alone; already installed *)
    END
  END SetSessPosition;

PROCEDURE <A NAME="GetSessFV"><procedure>GetSessFV</procedure></A> (sess: ZeusPanelPrivate.Session; arg: REFANY)
  RAISES {BadSnapshot} =
  (* LL = VBT.mu *)
  VAR wr: TextWr.T;
  BEGIN
    KeywordCheck(arg, &quot;FV&quot;);
    IF ISTYPE(arg, RefList.T) AND (RefList.Length(arg) = 2)
         AND ISTYPE(RefList.Nth(arg, 1), RefList.T) THEN
      TRY
        wr := TextWr.New();
        Sx.Print(wr, RefList.Nth(arg, 1));
        sess.fv.restore(TextRd.New(TextWr.ToText(wr)));
      EXCEPT
      | FormsVBT.Mismatch =&gt;
      | Sx.PrintError, FormsVBT.Error =&gt;
          RAISE BadSnapshot(&quot;Bad session FV snapshot&quot;);
      END;
    ELSE
      RAISE BadSnapshot(&quot;Bad session FV snapshot&quot;);
    END;
  END GetSessFV;

PROCEDURE <A NAME="GetAlg"><procedure>GetAlg</procedure></A> (sess: ZeusPanelPrivate.Session; arg: REFANY; new := TRUE)
  RAISES {BadSnapshot, Thread.Alerted, ZeusClass.Error} =
  (* LL = VBT.mu *)
  (* IF new THEN create a new alg object, ELSE re-use the old one. *)
  VAR list, l: RefList.T; wr: TextWr.T;
  BEGIN
    IF (arg # NIL) AND ISTYPE(arg, RefList.T) THEN
      list := arg;
    ELSE
      RAISE BadSnapshot(&quot;Bad alg snapshot&quot;);
    END;
    l := RefListUtils.Pop(list);
    IF (NOT ISTYPE(l, RefList.T)) OR (RefList.Length(l) # 2) THEN
      RAISE BadSnapshot(&quot;Bad alg snapshot&quot;);
    END;
    KeywordCheck(l, &quot;Alg&quot;);
    TYPECASE l.tail.head OF
    | TEXT (text) =&gt;
        TRY
          EVAL Classes.FindAlg(text);
        EXCEPT
          Classes.NotFound =&gt;
            IF Text.Equal(text, &quot;NIL&quot;) THEN
              RETURN
            ELSE
              RAISE BadSnapshot(&quot;Invalid alg name&quot;);
            END;
        END;
        IF new THEN ZeusPanelPrivate.PickedAlg(sess, text); END;
        TRY
          wr := TextWr.New();
          Sx.Print(wr, list.head);
          sess.alg.restore(TextRd.New(TextWr.ToText(wr)));
        EXCEPT
          Sx.PrintError =&gt; RAISE BadSnapshot(&quot;GetAlg error&quot;)
        END;
    ELSE
      RAISE BadSnapshot(&quot;Alg named not a string&quot;);
    END;
  END GetAlg;

PROCEDURE <A NAME="GetViews"><procedure>GetViews</procedure></A> (sess: ZeusPanelPrivate.Session; arg: REFANY)
  RAISES {BadSnapshot, ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR list: RefList.T;
  BEGIN
    IF NOT ISTYPE(arg, RefList.T) THEN RAISE BadSnapshot(&quot;Bad views&quot;) END;
    list := arg;
    WHILE list # NIL DO GetView(sess, RefListUtils.Pop(list)); END;
  END GetViews;

PROCEDURE <A NAME="GetView"><procedure>GetView</procedure></A> (sess: ZeusPanelPrivate.Session; arg: REFANY)
  RAISES {BadSnapshot, ZeusClass.Error} =
  (* LL = VBT.mu *)
  VAR
    list, l: RefList.T;
    view   : View.T;
    discard: TEXT;
    wr: TextWr.T;
  BEGIN
    IF (arg = NIL) OR (NOT ISTYPE(arg, RefList.T)) THEN
      RAISE BadSnapshot(&quot;Bad view snapshot&quot;)
    END;
    list := arg;
    l := RefListUtils.Pop(list);
    IF (NOT ISTYPE(l, RefList.T)) OR (RefList.Length(l) # 2) THEN
      RAISE BadSnapshot(&quot;Bad view snapshot&quot;);
    END;
    KeywordCheck(l, &quot;View&quot;);
    TYPECASE l.tail.head OF
    | TEXT (text) =&gt;
        TRY
          EVAL Classes.FindView(text);
        EXCEPT
          Classes.NotFound =&gt;
            IF NOT ZeusPanelPrivate.IsCodeView(text, sess, discard) THEN
              RETURN;
              (* Be more forgiving; ignore invalid view names, to allow
                 code views that don't belong to the current algorithm. *)
              (* RAISE BadSnapshot(&quot;Invalid view name&quot;);*)
            END;
        END;
        view := ZeusPanelPrivate.PickedView(sess, text);
        TRY
          wr := TextWr.New();
          Sx.Print(wr, list.head);
          view.restore(TextRd.New(TextWr.ToText(wr)));
        EXCEPT
          Sx.PrintError =&gt; RAISE BadSnapshot(&quot;GetView error&quot;)
        END;
    ELSE
      RAISE BadSnapshot(&quot;View named not a string&quot;);
    END;
  END GetView;
</PRE> **************** Data-only Snapshot / Restore **************** 

<P> Procedures to save and restore panel and algorithm data, ignoring
   views completely, under the assumption that the sessions at the time
   of snapshot can be mapped to those in panel.sessions at the time of
   restoration, in the same order. 

<P><PRE>PROCEDURE <A NAME="GrabDataList"><procedure>GrabDataList</procedure></A>(panel: ZeusPanelPrivate.T): REFANY =
  &lt;* LL = VBT.mu *&gt;
  VAR l := panel.sessions;
  BEGIN
    TRY
      WITH twr = TextWr.New() DO
        Wr.PutText(twr, &quot;(&quot;);
        panel.fv.snapshot(twr);
        WHILE l # NIL DO
          WITH sess = NARROW(RefListUtils.Pop(l), ZeusPanelPrivate.Session) DO
            Wr.PutText(twr, &quot;(&quot;);
            Wr.PutText(twr, &quot;(Session \&quot;&quot; &amp; sess.name &amp; &quot;\&quot;)\n&quot;);
            Wr.PutText(twr, &quot;(FV &quot;);
            sess.fv.snapshot(twr);
            Wr.PutText(twr, &quot;)\n&quot;);
            AlgToWr(twr, sess.alg);
            Wr.PutText(twr, &quot;)\n&quot;);
          END;
        END;
        Wr.PutText(twr, &quot;)\n&quot;);
        RETURN Sx.Read(TextRd.New(TextWr.ToText(twr)));
      END;
    EXCEPT
    | ZeusClass.Error, Rd.EndOfFile, Sx.ReadError =&gt;
        ZeusPanel.ReportError(&quot;Trouble writing data snapshot&quot;);
        RETURN NIL;
    END;
  END GrabDataList;

PROCEDURE <A NAME="RestoreData"><procedure>RestoreData</procedure></A>(panel: ZeusPanelPrivate.T; list: RefList.T) =
  &lt;* LL = VBT.mu *&gt;
  VAR l, sesslist: RefList.T;
      sess: ZeusPanelPrivate.Session; wr: TextWr.T;
  BEGIN
    TRY
      IF (list # NIL) AND ISTYPE(list.head, RefList.T) THEN
        l := RefListUtils.Pop(list);
      ELSE
        RAISE BadSnapshot(&quot;Bad format (1)&quot;);
      END;
      TRY
        wr := TextWr.New();
        Sx.Print(wr, l);
        panel.fv.restore(TextRd.New(TextWr.ToText(wr)));
      EXCEPT
        Sx.PrintError, FormsVBT.Mismatch =&gt;
          RAISE BadSnapshot(&quot;Bad format (2)&quot;);
      END;
      ZeusPanelPrivate.LoadFromPanel(panel);
      sesslist := panel.sessions;
      WHILE (list # NIL) AND (sesslist # NIL) DO
        sess := RefListUtils.Pop(sesslist);
        l := RefListUtils.Pop(list);
        IF ISTYPE(l, RefList.T) THEN
          WHILE l # NIL DO
            WITH lfirst = RefListUtils.Pop(l) DO
              IF (lfirst # NIL) AND ISTYPE(lfirst, RefList.T) THEN
                TYPECASE NARROW(lfirst, RefList.T).head OF
                | Atom.T (sxs) =&gt;
                    IF Text.Equal(Atom.ToText(sxs), &quot;Session&quot;) THEN
                      IF NOT Text.Equal(RefList.Nth(lfirst, 1), sess.name) THEN
                        RAISE BadSnapshot(&quot;Session name mismatch&quot;);
                      END;
                    ELSIF Text.Equal(Atom.ToText(sxs), &quot;FV&quot;) THEN
                      GetSessFV(sess, lfirst);
                    ELSE
                      RAISE BadSnapshot(&quot;Unknown keyword&quot;);
                    END;
                | RefList.T (ll) =&gt;
                    IF ISTYPE(ll.head, Atom.T) THEN
                      GetAlg(sess, lfirst, FALSE);
                    ELSE
                      RAISE BadSnapshot(&quot;Bad format (3)&quot;);
                    END;
                ELSE RAISE BadSnapshot(&quot;Bad format (4)&quot;);
                END (* TYPECASE *);
              ELSE
                RAISE BadSnapshot(&quot;Bad format (5)&quot;);
              END;
            END (* WITH *);
          END (* WHILE *);   (* for each session sublist *)
        ELSE
          RAISE BadSnapshot(&quot;Bad format (6)&quot;);
        END;
      END (* WHILE *);    (* for each session *)
      IF (list # NIL) OR (sesslist # NIL) THEN
        RAISE BadSnapshot(&quot;Wrong number of sessions&quot;);
      END;
    EXCEPT
      BadSnapshot(msg) =&gt;
        ZeusPanel.ReportError(&quot;Data snapshot error: &quot; &amp; msg);
    ELSE
        ZeusPanel.ReportError(&quot;Data snapshot error&quot;);
    END (* TRY *);
  END RestoreData;
</PRE>********** Utilities **********

<P><PRE>PROCEDURE <A NAME="KeywordCheck"><procedure>KeywordCheck</procedure></A> (arg: REFANY; t: TEXT) RAISES {BadSnapshot} =
  (* LL = arbitrary *)
  BEGIN
    TRY
      ZeusUtil.KeywordCheck(arg, t);
    EXCEPT
      ZeusUtil.BadSnapshot (msg) =&gt; RAISE BadSnapshot(msg);
    END;
  END KeywordCheck;

PROCEDURE <A NAME="StateDirFile"><procedure>StateDirFile</procedure></A> (file: TEXT): Pathname.T =
  &lt;* LL = arbitrary *&gt;
  &lt;* FATAL Pathname.Invalid *&gt;
  VAR path := Pathname.Decompose(Env.Get(HomeDir));
  BEGIN
    path.addhi(StateDir);
    MakeStateDir(Pathname.Compose(path));
    path.addhi(file);
    RETURN Pathname.Compose(path)
  END StateDirFile;

PROCEDURE <A NAME="MakeStateDir"><procedure>MakeStateDir</procedure></A> (path: Pathname.T) =
  &lt;* LL = arbitrary *&gt;
  VAR
    status: File.Status;
    exists: BOOLEAN := TRUE;
  BEGIN
    TRY
      TRY status := FS.Status(path) EXCEPT
        OSError.E =&gt; exists := FALSE;
      END;
      IF NOT exists OR NOT status.type = FS.DirectoryFileType THEN
        IF exists AND status.type = RegularFile.FileType THEN
          FS.DeleteFile(path)
        END;
        FS.CreateDirectory(path);
      END;
    EXCEPT
    | OSError.E =&gt; ZeusPanel.ReportError(&quot;Can't create &quot; &amp; path);
    END;
  END MakeStateDir;
</PRE> **************** Mainline **************** 

<P><PRE>BEGIN
END ZeusSnapshot.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
