<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus/src/ZeusUtil.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus/src/ZeusUtil.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ZeusUtil.i3">ZeusUtil</A></implements></module>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../types/src/ASCII.i3">ASCII</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>,
       <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>;

&lt;*PRAGMA LL*&gt;
&lt;*FATAL TrestleComm.Failure*&gt;

PROCEDURE <A NAME="KeywordCheck"><procedure>KeywordCheck</procedure></A> (arg: REFANY; t: TEXT) RAISES {BadSnapshot} =
  (* arg should be a list whose first element is an Atom.T whose name
     is t.  If it isn't, complain. *)
  BEGIN
    IF ISTYPE(arg, RefList.T) AND (arg # NIL)
         AND ISTYPE(RefList.Nth(arg, 0), Atom.T) THEN
      IF NOT Text.Equal(Atom.ToText(RefList.Nth(arg, 0)), t) THEN
        RAISE BadSnapshot(&quot;keyword mismatch: &quot; &amp; t);
      END;
    ELSE
      RAISE BadSnapshot(&quot;Bad snapshot at keyword: &quot; &amp; t);
    END
  END KeywordCheck;

PROCEDURE <A NAME="ScreenPosOK"><procedure>ScreenPosOK</procedure></A> (scr: Trestle.ScreenID; pt: Point.T): BOOLEAN =
  &lt;* LL = VBT.mu *&gt;
  (* RETURN TRUE iff the screen exists and pt is on it. *)
  VAR screens := Trestle.GetScreens();
  BEGIN
    FOR i := 0 TO LAST(screens^) DO
      IF (scr = screens^[i].id) AND Rect.Member(pt, screens^[i].dom) THEN
        RETURN TRUE
      END;
    END;
    RETURN FALSE;
  END ScreenPosOK;

PROCEDURE <A NAME="RdToList"><procedure>RdToList</procedure></A> (rd: Rd.T): RefList.T =
  &lt;* LL = arbitrary *&gt;
  (* read one s-expression from rd.  If it's a list, return it, else return
     NIL.  Catch any exceptions and return NIL if one occurs. *)
  BEGIN
    IF rd = NIL THEN RETURN NIL END;
    TRY
      WITH ra = Sx.Read(rd) DO
        TYPECASE ra OF | RefList.T (l) =&gt; RETURN l; ELSE RETURN NIL; END;
      END;
    EXCEPT
    | Sx.ReadError, Rd.EndOfFile, Thread.Alerted =&gt; RETURN NIL;
    END;
  END RdToList;

PROCEDURE <A NAME="EatChar"><procedure>EatChar</procedure></A> (rd: Rd.T; c: CHAR): BOOLEAN =
  (* If the next non-white-space character in rd is c, swallow it and
     return TRUE.  Otherwise push it back on the reader and return
     FALSE. *)
  VAR next: CHAR;
  BEGIN
    TRY
      LOOP
        next := Rd.GetChar(rd);
        IF NOT (next IN ASCII.Spaces) THEN EXIT END;
      END;
      IF next = c THEN RETURN TRUE ELSE Rd.UnGetChar(rd); RETURN FALSE END;
    EXCEPT
    | Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN FALSE;
    END;
  END EatChar;

BEGIN
END ZeusUtil.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
