<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/CameraManager.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/CameraManager.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="CameraManager.i3">CameraManager</A></implements></module>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../anim3D/src/CameraGO.i3">CameraGO</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../anim3D/src/OrthoCameraGO.i3">OrthoCameraGO</A>, <A HREF="../../anim3D/src/PerspCameraGO.i3">PerspCameraGO</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>,
       <A HREF="../../anim3D/src/PointProp.i3">PointProp</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../anim3D/src/RealProp.i3">RealProp</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../fmtlex/src/Scan.i3">Scan</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View3D.i3">View3D</A>,
       <A HREF="View3DPrivate.i3">View3DPrivate</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>;

&lt;* FATAL FormsVBT.Error, FormsVBT.Unimplemented *&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    view      : View3D.T;  (* associated View3D.T *)
    from      : PointProp.Val;
    to        : PointProp.Val;
    up        : PointProp.Val;
    aspect    : RealProp.Val;
    height    : RealProp.Val;
    fovy      : RealProp.Val;
    cam       : CameraGO.T;      (* either ocam or pcam *)
    ocam      : OrthoCameraGO.T;
    pcam      : PerspCameraGO.T;
  METHODS
    selectOrtho () := SelectOrtho;   (* select the orthographics camera *)
    selectPersp () := SelectPersp;   (* select the perspective camera *)
  OVERRIDES
    init      := Init;
    snapshot  := Snapshot;
    restore   := Restore;
    getCamera := GetCamera;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; v : View3D.T) : T =
  &lt;* FATAL Prop.BadMethod *&gt;
  CONST
    from     = Point3.T{0.0, 0.0, 100.0};
    to       = Point3.T{0.0, 0.0, 0.0};
    up       = Point3.T{0.0, 1.0, 0.0};
    fovy     =   0.1;
    aspect   =   1.0;
    height   =  10.0;   (* i.e. the visible region is 10 by 10 units *)
  BEGIN
    self.view := v;

    self.from   := PointProp.NewConst (from);
    self.to     := PointProp.NewConst (to);
    self.up     := PointProp.NewConst (up);
    self.aspect := RealProp.NewConst (aspect);
    self.height := RealProp.NewConst (height);
    self.fovy   := RealProp.NewConst (fovy);

    WITH cam = NEW (OrthoCameraGO.T).init () DO
      self.ocam := cam;
      cam.setProp (CameraGO.From.bind (self.from));
      cam.setProp (CameraGO.To.bind (self.to));
      cam.setProp (CameraGO.Up.bind (self.up));
      cam.setProp (CameraGO.Aspect.bind (self.aspect));
      cam.setProp (OrthoCameraGO.Height.bind (self.height));
    END;

    WITH cam = NEW (PerspCameraGO.T).init () DO
      self.pcam := cam;
      cam.setProp (CameraGO.From.bind (self.from));
      cam.setProp (CameraGO.To.bind (self.to));
      cam.setProp (CameraGO.Up.bind (self.up));
      cam.setProp (CameraGO.Aspect.bind (self.aspect));
      cam.setProp (PerspCameraGO.Fovy.bind (self.fovy));
    END;

    (*** put the camera parameters onto the camera-editor form ***)
    WITH form = v.form DO

      FormsVBT.PutBoolean (form, &quot;PerspCameraChoice&quot;, TRUE);
      FormsVBT.PutInteger (form, &quot;CameraTSplit&quot;, 0);
      self.cam := self.pcam;

      PutPointOntoForm (form, &quot;CameraFrom&quot;,   self.from.get ());
      PutPointOntoForm (form, &quot;CameraTo&quot;,     self.to.get ());
      PutPointOntoForm (form, &quot;CameraUp&quot;,     self.up.get ());
      PutRealOntoForm  (form, &quot;CameraAspect&quot;, self.aspect.get ());
      PutRealOntoForm  (form, &quot;CameraHeight&quot;, self.height.get ());
      PutRealOntoForm  (form, &quot;CameraFovy&quot;,   self.fovy.get ());

      (*** Attach the callbacks ***)
      FormsVBT.AttachProc (form, &quot;OrthoCameraChoice&quot;, OrthoCallback);
      FormsVBT.AttachProc (form, &quot;PerspCameraChoice&quot;, PerspCallback);

      AttachPointCallback (form, &quot;CameraFrom&quot;,     ValueCallback);
      AttachPointCallback (form, &quot;CameraTo&quot;,       ValueCallback);
      AttachPointCallback (form, &quot;CameraUp&quot;,       ValueCallback);
      FormsVBT.AttachProc (form, &quot;CameraAspect&quot;,   ValueCallback);
      FormsVBT.AttachProc (form, &quot;CameraHeight&quot;,   ValueCallback);
      FormsVBT.AttachProc (form, &quot;CameraFovy&quot;,     ValueCallback);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="GetCamera"><procedure>GetCamera</procedure></A> (self : T) : CameraGO.T =
  BEGIN
    RETURN self.cam;
  END GetCamera;

PROCEDURE <A NAME="SelectOrtho"><procedure>SelectOrtho</procedure></A> (self : T) =
  BEGIN
    FormsVBT.PutInteger (self.view.form, &quot;CameraTSplit&quot;, 1);
    self.cam := self.ocam;
    self.view.root.changeCamera (self.cam);
  END SelectOrtho;

PROCEDURE <A NAME="SelectPersp"><procedure>SelectPersp</procedure></A> (self : T) =
  BEGIN
    FormsVBT.PutInteger (self.view.form, &quot;CameraTSplit&quot;, 0);
    self.cam := self.pcam;
    self.view.root.changeCamera (self.cam);
  END SelectPersp;

PROCEDURE <A NAME="OrthoCallback"><procedure>OrthoCallback</procedure></A> (             form  : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c     : REFANY;
                         &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    NARROW (form, View3D.Form).view.camMgr.selectOrtho ();
  END OrthoCallback;

PROCEDURE <A NAME="PerspCallback"><procedure>PerspCallback</procedure></A> (             form  : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c     : REFANY;
                         &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    NARROW (form, View3D.Form).view.camMgr.selectPersp ();
  END PerspCallback;

PROCEDURE <A NAME="SetPointProp"><procedure>SetPointProp</procedure></A> (pv : PointProp.Val; p : Point3.T) =
  BEGIN
    pv.beh := NEW (PointProp.ConstBeh).init (p);
  END SetPointProp;

PROCEDURE <A NAME="SetRealProp"><procedure>SetRealProp</procedure></A> (pv : RealProp.Val; r : REAL) =
  BEGIN
    pv.beh := NEW (RealProp.ConstBeh).init (r);
  END SetRealProp;

PROCEDURE <A NAME="ValueCallback"><procedure>ValueCallback</procedure></A> (             form  : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c     : REFANY;
                         &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =

  BEGIN
    WITH camMgr = NARROW (form, View3D.Form).view.camMgr DO
      SetPointProp (camMgr.from,   GetPointFromForm (form, &quot;CameraFrom&quot;));
      SetPointProp (camMgr.to,     GetPointFromForm (form, &quot;CameraTo&quot;));
      SetPointProp (camMgr.up,     GetPointFromForm (form, &quot;CameraUp&quot;));
      SetRealProp  (camMgr.aspect, GetRealFromForm  (form, &quot;CameraAspect&quot;));
      SetRealProp  (camMgr.height, GetRealFromForm  (form, &quot;CameraHeight&quot;));
      SetRealProp  (camMgr.fovy,   GetRealFromForm  (form, &quot;CameraFovy&quot;));
    END;
  END ValueCallback;

PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (self : T; wr : Wr.T) RAISES {ZeusClass.Error} =
  VAR
    t : TEXT;
  BEGIN
    IF FormsVBT.GetBoolean (self.view.form, &quot;OrthoCameraChoice&quot;) THEN
      t := &quot;OrthoCamera &quot;;
    ELSE
      t := &quot;PerspCamera &quot;;
    END;
    Wr.PutText (wr,
                &quot;(&quot; &amp; t &amp; &quot; &quot; &amp;
                Fmt.Real (self.height.get ()) &amp; &quot; &quot; &amp;
                Fmt.Real (self.fovy.get ()) &amp; &quot; &quot; &amp;
                Fmt.Real (self.aspect.get ()) &amp; &quot; &quot; &amp;
                PointToText (self.from.get ()) &amp; &quot; &quot; &amp;
                PointToText (self.to.get ()) &amp; &quot; &quot; &amp;
                PointToText (self.up.get ()) &amp; &quot;)&quot;);
  END Snapshot;

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (self : T; rd : Rd.T) RAISES {ZeusClass.Error} =
  BEGIN
    WITH sx = Sx.Read (rd) DO
      TYPECASE sx OF
      | RefList.T (list) =&gt;
        &lt;* ASSERT RefList.Length (list) = 7 *&gt;
        TYPECASE list.head OF
        | Atom.T (a) =&gt;
          WITH height   = RealFromSx  (RefList.Nth (list, 1)),
               fovy     = RealFromSx  (RefList.Nth (list, 2)),
               aspect   = RealFromSx  (RefList.Nth (list, 3)),
               from     = PointFromSx (RefList.Nth (list, 4)),
               to       = PointFromSx (RefList.Nth (list, 5)),
               up       = PointFromSx (RefList.Nth (list, 6)) DO
            SetPointProp (self.from, from);
            SetPointProp (self.to, to);
            SetPointProp (self.up, up);
            SetRealProp (self.height, height);
            SetRealProp (self.fovy, fovy);
            SetRealProp (self.aspect, aspect);
            IF a = Atom.FromText (&quot;OrthoCamera&quot;) THEN
              FormsVBT.PutBoolean (self.view.form, &quot;OrthoCameraChoice&quot;, TRUE);
              self.selectOrtho ();
            ELSIF a = Atom.FromText (&quot;PerspCamera&quot;) THEN
              FormsVBT.PutBoolean (self.view.form, &quot;PerspCameraChoice&quot;, TRUE);
              self.selectPersp ();
            ELSE
              RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
            END;
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    END;
  END Restore;
</PRE>***************************************************************************
** CODE DUPLICATION -- MOVE OUT TO AUX FILE                              **
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="PutPointOntoForm"><procedure>PutPointOntoForm</procedure></A> (form : FormsVBT.T; prefix : TEXT; p : Point3.T) =
  BEGIN
    FormsVBT.PutText (form, prefix &amp; &quot;X&quot;, Fmt.Real (p.x));
    FormsVBT.PutText (form, prefix &amp; &quot;Y&quot;, Fmt.Real (p.y));
    FormsVBT.PutText (form, prefix &amp; &quot;Z&quot;, Fmt.Real (p.z));
  END PutPointOntoForm;

PROCEDURE <A NAME="PutRealOntoForm"><procedure>PutRealOntoForm</procedure></A> (form : FormsVBT.T; name : TEXT; v : REAL) =
  BEGIN
     FormsVBT.PutText (form, name, Fmt.Real (v));
  END PutRealOntoForm;

PROCEDURE <A NAME="GetPointFromForm"><procedure>GetPointFromForm</procedure></A> (form : FormsVBT.T; prefix : TEXT) : Point3.T =
  BEGIN
    WITH x = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;X&quot;  )),
         y = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;Y&quot;  )),
         z = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;Z&quot;  )) DO
      RETURN Point3.T {x, y, z};
    END;
  END GetPointFromForm;

PROCEDURE <A NAME="GetRealFromForm"><procedure>GetRealFromForm</procedure></A> (form  : FormsVBT.T; name : TEXT) : REAL =
  BEGIN
    RETURN Scan.Real (FormsVBT.GetText (form, name));
  END GetRealFromForm;

PROCEDURE <A NAME="AttachPointCallback"><procedure>AttachPointCallback</procedure></A> (form   : FormsVBT.T;
                               prefix : TEXT;
                               proc   : FormsVBT.Proc) =
  BEGIN
    FormsVBT.AttachProc (form, prefix &amp; &quot;X&quot;, proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Y&quot;, proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Z&quot;, proc);
  END AttachPointCallback;

PROCEDURE <A NAME="PointToText"><procedure>PointToText</procedure></A> (p : Point3.T) : TEXT =
  BEGIN
     RETURN &quot;(Point &quot; &amp;
            Fmt.Real (p.x) &amp; &quot; &quot; &amp;
            Fmt.Real (p.y) &amp; &quot; &quot; &amp;
            Fmt.Real (p.z) &amp; &quot;)&quot;;
  END PointToText;

PROCEDURE <A NAME="PointFromSx"><procedure>PointFromSx</procedure></A> (sx : Sx.T) : Point3.T RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | RefList.T (list) =&gt;
      &lt;* ASSERT RefList.Length(list) = 4 *&gt;
      TYPECASE list.head OF
      | Atom.T (a) =&gt;
        IF a = Atom.FromText (&quot;Point&quot;) THEN
          WITH x = RealFromSx (RefList.Nth (list, 1)),
               y = RealFromSx (RefList.Nth (list, 2)),
               z = RealFromSx (RefList.Nth (list, 3)) DO
            RETURN Point3.T {x, y, z};
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END PointFromSx;

PROCEDURE <A NAME="RealFromSx"><procedure>RealFromSx</procedure></A> (sx : Sx.T) : REAL RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | REF REAL (rr) =&gt;
      RETURN rr^;
    | REF INTEGER (ri) =&gt;
      RETURN FLOAT(ri^);
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END RealFromSx;

BEGIN
END CameraManager.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
