<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/ColorMenu.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/ColorMenu.m3</H2></A><HR>
<inModule>
<PRE></PRE>***************************************************************************
 ColorMenu                                                                 
                                                                           
***************************************************************************

<P><PRE>MODULE <module><implements><A HREF="ColorMenu.i3">ColorMenu</A></implements></module>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../anim3D/src/Colour.i3">Colour</A>, <A HREF="../../rw/src/Common/IO.i3">IO</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../text/src/Text.i3">Text</A>;

TYPE
  ColorTextEntry = RECORD
    color : Color.T;
    text : TEXT
  END;

CONST
  colorTextMap = ARRAY OF ColorTextEntry {
                             ColorTextEntry {Colour.Black     , &quot;black&quot;},
                             ColorTextEntry {Colour.White     , &quot;white&quot;},
                             ColorTextEntry {Colour.Grey      , &quot;grey&quot;},
                             ColorTextEntry {Colour.Red       , &quot;red&quot;},
                             ColorTextEntry {Colour.Blue      , &quot;blue&quot;},
                             ColorTextEntry {Colour.Lightgreen, &quot;lightGreen&quot;},
                             ColorTextEntry {Colour.Lightblue , &quot;lightBlue&quot;},
                             ColorTextEntry {Colour.Darkblue  , &quot;darkBlue&quot;},
                             ColorTextEntry {Colour.Darkgrey  , &quot;darkGrey&quot;},
                             ColorTextEntry {Colour.Orange    , &quot;orange&quot;},
                             ColorTextEntry {Colour.Yellow    , &quot;yellow&quot;}};

PROCEDURE <A NAME="ColorAsText"><procedure>ColorAsText</procedure></A> (col : Color.T) : TEXT =
  BEGIN
    FOR i := FIRST (colorTextMap) TO LAST (colorTextMap) DO
      IF colorTextMap[i].color = col THEN
        RETURN colorTextMap[i].text;
      END;
    END;
    RETURN &quot;custom&quot;;
  END ColorAsText;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (form : FormsVBT.T; color : Color.T) =
  BEGIN
    FormsVBT.PutChoice (form, &quot;colorChoice&quot;,
                        ColorAsText (color));
    FormsVBT.PutInteger (form, &quot;colorRedComponent&quot;,
                         ROUND (color.r * 100.0));
    FormsVBT.PutInteger (form, &quot;colorGreenComponent&quot;,
                         ROUND (color.g * 100.0));
    FormsVBT.PutInteger (form, &quot;colorBlueComponent&quot;,
                         ROUND (color.b * 100.0));
  END Put;

PROCEDURE <A NAME="GetValue"><procedure>GetValue</procedure></A> (form : FormsVBT.T) : Color.T =
  BEGIN
    WITH r = FLOAT(FormsVBT.GetInteger (form, &quot;colorRedComponent&quot;))   / 100.0,
         g = FLOAT(FormsVBT.GetInteger (form, &quot;colorGreenComponent&quot;)) / 100.0,
         b = FLOAT(FormsVBT.GetInteger (form, &quot;colorBlueComponent&quot;))  / 100.0,
         col = Color.T {r, g, b} DO
      FormsVBT.PutChoice (form, &quot;colorChoice&quot;, ColorAsText (col));
      RETURN col;
    END;
  END GetValue;

PROCEDURE <A NAME="GetChoice"><procedure>GetChoice</procedure></A> (form : FormsVBT.T) : Color.T =
  VAR
    text : TEXT;
  BEGIN
    text := FormsVBT.GetChoice (form, &quot;colorChoice&quot;);
    IF Text.Equal (text, &quot;custom&quot;) THEN
      (* simply return the present values of the scrollers *)
      WITH r = FLOAT(FormsVBT.GetInteger(form,&quot;colorRedComponent&quot;))  /100.0,
           g = FLOAT(FormsVBT.GetInteger(form,&quot;colorGreenComponent&quot;))/100.0,
           b = FLOAT(FormsVBT.GetInteger(form,&quot;colorBlueComponent&quot;)) /100.0,
           col = Color.T {r, g, b} DO
        RETURN col;
      END;
    ELSE
      FOR i := FIRST (colorTextMap) TO LAST (colorTextMap) DO
        IF Text.Equal (colorTextMap[i].text, text) THEN
          WITH color = colorTextMap[i].color DO
            Put (form, color);
            RETURN color;
          END;
        END;
      END;
      IO.Put (&quot;Warning: unknown color name: &quot; &amp; text &amp; &quot;\n&quot;);
      RETURN Color.Black;
    END;
  END GetChoice;

BEGIN
END ColorMenu.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
