<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/LightManager.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/LightManager.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> A LightManager manages the light-sources associated with the G.Window or
 * G.Viewer of a View3D.T. There is one LightManager per View3D.T.
 

<P><PRE>INTERFACE <interface><A HREF="LightManager.m3">LightManager</A></interface>;

IMPORT <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="View3D.i3">View3D</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>;

TYPE
  <A HREF="LightManager.m3#T">T</A> &lt;: Public;
  Public = OBJECT
  METHODS
    (* Init creates a new LightManager.T. Initially, there are no light
     * sources attached to it.
     *
     * Note: I pass the View3D.T to init, because I believe that I need
     * to call v.win.render (v.cam, v.scene) when the light state changes.
     * If it turns out that it is sufficient to call win.show (), then I
     * could simply pass a G.Window or a G.Viewer, and thereby make this
     * code more widely reusable.
     *)
    init (v : View3D.T) : T;

    (* snapshot writes a list of the existing light sources and their state
       onto a writer wr. *)
    snapshot (wr : Wr.T) RAISES {ZeusClass.Error};

    (* restore reads a list of light sources and their state from a reader
       rd, and adds them to its associated G.Window or G.Viewer. *)
    restore (rd : Rd.T) RAISES {ZeusClass.Error};

    (* addLight adds a light source to the list of lights managed by the
       LightManager. The LightManager will add the light to the G.Window
       or G.Viewer. *)
    addLight (l : LightGO.T);
  END;

END LightManager.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
