<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/LightManager.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/LightManager.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="LightManager.i3">LightManager</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/AmbientLightGO.i3">AmbientLightGO</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../anim3D/src/BooleanProp.i3">BooleanProp</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>, <A HREF="../../anim3D/src/ColorProp.i3">ColorProp</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>,
       <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="../../anim3D/src/GroupGO.i3">GroupGO</A>, <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../anim3D/src/PointLightGO.i3">PointLightGO</A>, <A HREF="../../anim3D/src/PointProp.i3">PointProp</A>,
       <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../anim3D/src/RealProp.i3">RealProp</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../fmtlex/src/Scan.i3">Scan</A>, <A HREF="../../anim3D/src/SpotLightGO.i3">SpotLightGO</A>, <A HREF="../../sx/src/Sx.i3">Sx</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../anim3D/src/VectorLightGO.i3">VectorLightGO</A>,
       <A HREF="View3D.i3">View3D</A>, <A HREF="View3DPrivate.i3">View3DPrivate</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>;

EXCEPTION FatalError (TEXT);

&lt;* FATAL FatalError *&gt;
&lt;* FATAL FormsVBT.Unimplemented, FormsVBT.Error *&gt;
&lt;* FATAL GO.PropUndefined *&gt;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    lights    : REF ARRAY OF LightWrapper;
    numlights : INTEGER;   (* index of next free light *)
    current   : INTEGER;   (* index of selected light; -1 if none selected *)
    view      : View3D.T;  (* associated View3D.T *)
    nextid    : INTEGER;   (* next unused id *)
  OVERRIDES
    init     := Init;
    snapshot := Snapshot;
    restore  := Restore;
    addLight := AddLight;
  END;

TYPE
  LightWrapper = RECORD
    button : TEXT;
    blabel : TEXT;
    switch : TEXT;
    title  : TEXT;
    light  : LightGO.T;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; v : View3D.T) : T =
  BEGIN
    self.lights := NEW (REF ARRAY OF LightWrapper, 10);
    self.numlights := 0;
    self.view := v;
    self.nextid := 1;
    self.current := -1;
    FormsVBT.MakeVanish (v.form, &quot;SelectedLightSplit&quot;);

    FormsVBT.AttachProc (v.form, &quot;AddLight&quot;, AddLightCallback);
    FormsVBT.AttachProc (v.form, &quot;DeleteLight&quot;, DeleteLightCallback);
    FormsVBT.AttachProc (v.form, &quot;LightChoice&quot;, LightChoiceCallback);

    AttachColorCallback (v.form, &quot;AmbientLight&quot;  , AmbientLightCallback);

    AttachColorCallback (v.form, &quot;VectorLight&quot;   , VectorLightCallback);
    AttachPointCallback (v.form, &quot;VectorLightDir&quot;, VectorLightCallback);

    AttachColorCallback (v.form, &quot;PointLight&quot;    , PointLightCallback);
    AttachPointCallback (v.form, &quot;PointLightOrig&quot;, PointLightCallback);
    FormsVBT.AttachProc (v.form, &quot;PointLightAtt0&quot;, PointLightCallback);
    FormsVBT.AttachProc (v.form, &quot;PointLightAtt1&quot;, PointLightCallback);

    AttachColorCallback (v.form, &quot;SpotLight&quot;      , SpotLightCallback);
    AttachPointCallback (v.form, &quot;SpotLightDir&quot;   , SpotLightCallback);
    AttachPointCallback (v.form, &quot;SpotLightOrig&quot;  , SpotLightCallback);
    FormsVBT.AttachProc (v.form, &quot;SpotLightAtt0&quot;  , SpotLightCallback);
    FormsVBT.AttachProc (v.form, &quot;SpotLightAtt1&quot;  , SpotLightCallback);
    FormsVBT.AttachProc (v.form, &quot;SpotLightConc&quot;  , SpotLightCallback);
    FormsVBT.AttachProc (v.form, &quot;SpotLightSpread&quot;, SpotLightCallback);

    RETURN self;
  END Init;

PROCEDURE <A NAME="Snapshot"><procedure>Snapshot</procedure></A> (self : T; wr : Wr.T) RAISES {ZeusClass.Error} =
  BEGIN
    Wr.PutText (wr, &quot;(&quot;);
    FOR i := 0 TO self.numlights - 1 DO
      SnapshotLight (self.lights[i].light, wr);
    END;
    Wr.PutText (wr, &quot;)&quot;);
  END Snapshot;

PROCEDURE <A NAME="SnapshotLight"><procedure>SnapshotLight</procedure></A> (light : LightGO.T; wr : Wr.T)
    RAISES {ZeusClass.Error} =
  &lt;* FATAL Prop.BadMethod *&gt;
  VAR
    color  : Color.T;
    switch : BOOLEAN;
    t      : TEXT;
  BEGIN
    color  := NARROW (light.getProp (LightGO.Colour), ColorProp.Val).get ();
    switch := NARROW (light.getProp (LightGO.Switch), BooleanProp.Val).get ();
    TYPECASE light OF
    | AmbientLightGO.T =&gt;
      t := &quot;(AmbientLight &quot; &amp;
               ColorToText (color) &amp; &quot; &quot; &amp;
               Fmt.Bool (switch) &amp; &quot;)&quot;;
    | VectorLightGO.T =&gt;
      WITH dir = NARROW (light.getProp (VectorLightGO.Direction),
                         PointProp.Val).get () DO
        t := &quot;(VectorLight &quot; &amp;
                 ColorToText (color) &amp; &quot; &quot; &amp;
                 PointToText (dir) &amp; &quot; &quot; &amp;
                 Fmt.Bool (switch) &amp; &quot;)&quot;;
      END;
    | PointLightGO.T =&gt;
      WITH orig = NARROW (light.getProp (PointLightGO.Origin),
                          PointProp.Val).get (),
           att0 = NARROW (light.getProp (PointLightGO.Attenuation0),
                          RealProp.Val).get (),
           att1 = NARROW (light.getProp (PointLightGO.Attenuation1),
                          RealProp.Val).get () DO
        t := &quot;(PointLight &quot; &amp;
                 ColorToText (color) &amp; &quot; &quot; &amp;
                 PointToText (orig) &amp; &quot; &quot; &amp;
                 Fmt.Real (att0) &amp; &quot; &quot; &amp;
                 Fmt.Real (att1) &amp; &quot; &quot; &amp;
                 Fmt.Bool (switch) &amp; &quot;)&quot;;
      END;
    | SpotLightGO.T =&gt;
      WITH orig = NARROW (light.getProp (SpotLightGO.Origin),
                          PointProp.Val).get (),
           dir = NARROW (light.getProp (SpotLightGO.Direction),
                         PointProp.Val).get (),
           spread = NARROW (light.getProp (SpotLightGO.SpreadAngle),
                            RealProp.Val).get (),
           conc = NARROW (light.getProp (SpotLightGO.Concentration),
                          RealProp.Val).get (),
           att0 = NARROW (light.getProp (SpotLightGO.Attenuation0),
                          RealProp.Val).get (),
           att1 = NARROW (light.getProp (SpotLightGO.Attenuation1),
                          RealProp.Val).get () DO
        t := &quot;(SpotLight &quot; &amp;
                 ColorToText (color) &amp; &quot; &quot; &amp;
                 PointToText (orig) &amp; &quot; &quot; &amp;
                 PointToText (dir) &amp; &quot; &quot; &amp;
                 Fmt.Real (conc) &amp; &quot; &quot; &amp;
                 Fmt.Real (spread) &amp; &quot; &quot; &amp;
                 Fmt.Real (att0) &amp; &quot; &quot; &amp;
                 Fmt.Real (att1) &amp; &quot; &quot; &amp;
                 Fmt.Bool (switch) &amp; &quot;)&quot;;
      END;
    ELSE
      RAISE FatalError (&quot;SnapshotLight: Unexpected light type&quot;);
    END;
    Wr.PutText (wr, t);
  END SnapshotLight;

PROCEDURE <A NAME="ColorToText"><procedure>ColorToText</procedure></A> (c : Color.T) : TEXT =
  BEGIN
     RETURN &quot;(Color &quot; &amp;
            Fmt.Real (c.r) &amp; &quot; &quot; &amp;
            Fmt.Real (c.g) &amp; &quot; &quot; &amp;
            Fmt.Real (c.b) &amp; &quot;)&quot;;
  END ColorToText;

PROCEDURE <A NAME="PointToText"><procedure>PointToText</procedure></A> (p : Point3.T) : TEXT =
  BEGIN
     RETURN &quot;(Point &quot; &amp;
            Fmt.Real (p.x) &amp; &quot; &quot; &amp;
            Fmt.Real (p.y) &amp; &quot; &quot; &amp;
            Fmt.Real (p.z) &amp; &quot;)&quot;;
  END PointToText;

PROCEDURE <A NAME="Restore"><procedure>Restore</procedure></A> (self : T; rd : Rd.T) RAISES {ZeusClass.Error} =
  BEGIN
    WITH sx = Sx.Read (rd) DO
      TYPECASE sx OF
      | RefList.T (list) =&gt;
        WHILE list # NIL DO
          AddLight (self, LightFromSx (list.head));
          list := list.tail;
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    END;
  END Restore;

PROCEDURE <A NAME="LightFromSx"><procedure>LightFromSx</procedure></A> (sx : Sx.T) : LightGO.T RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | RefList.T (list) =&gt;
      &lt;* ASSERT list # NIL *&gt;
      TYPECASE list.head OF
      | Atom.T (a) =&gt;
        IF a = Atom.FromText (&quot;AmbientLight&quot;) THEN
          &lt;* ASSERT RefList.Length (list) = 3 *&gt;
          WITH color  = ColorFromSx (RefList.Nth (list, 1)),
               status = BoolFromSx (RefList.Nth (list, 2)),
               light  = AmbientLightGO.New (color) DO
            light.setProp (LightGO.Switch.bind (BooleanProp.NewConst (status)));
            RETURN light;
          END;
        ELSIF a = Atom.FromText (&quot;VectorLight&quot;) THEN
          &lt;* ASSERT RefList.Length (list) = 4 *&gt;
          WITH color  = ColorFromSx (RefList.Nth (list, 1)),
               dir    = PointFromSx (RefList.Nth (list, 2)),
               status = BoolFromSx (RefList.Nth (list, 3)),
               light  = VectorLightGO.New (color, dir) DO
            light.setProp (LightGO.Switch.bind (BooleanProp.NewConst (status)));
            RETURN light;
          END;
        ELSIF a = Atom.FromText (&quot;PointLight&quot;) THEN
          &lt;* ASSERT RefList.Length (list) = 6 *&gt;
          WITH color  = ColorFromSx (RefList.Nth (list, 1)),
               origin = PointFromSx  (RefList.Nth (list, 2)),
               att0   = RealFromSx   (RefList.Nth (list, 3)),
               att1   = RealFromSx   (RefList.Nth (list, 4)),
               status = BoolFromSx   (RefList.Nth (list, 5)),
               light  = PointLightGO.New (color, origin, att0, att1) DO
            light.setProp (LightGO.Switch.bind (BooleanProp.NewConst (status)));
            RETURN light;
          END;
        ELSIF a = Atom.FromText (&quot;SpotLight&quot;) THEN
          &lt;* ASSERT RefList.Length (list) = 9 *&gt;
          WITH color  = ColorFromSx (RefList.Nth (list, 1)),
               origin = PointFromSx  (RefList.Nth (list, 2)),
               dir    = PointFromSx  (RefList.Nth (list, 3)),
               conc   = RealFromSx   (RefList.Nth (list, 4)),
               spread = RealFromSx   (RefList.Nth (list, 5)),
               att0   = RealFromSx   (RefList.Nth (list, 6)),
               att1   = RealFromSx   (RefList.Nth (list, 7)),
               status = BoolFromSx   (RefList.Nth (list, 8)),
               light  = SpotLightGO.New (color, origin, dir,
                                         conc, spread, att0, att1) DO
            light.setProp (LightGO.Switch.bind (BooleanProp.NewConst (status)));
            RETURN light;
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END LightFromSx;

PROCEDURE <A NAME="ColorFromSx"><procedure>ColorFromSx</procedure></A> (sx : Sx.T) : Color.T RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | RefList.T (list) =&gt;
      &lt;* ASSERT RefList.Length(list) = 4 *&gt;
      TYPECASE list.head OF
      | Atom.T (a) =&gt;
        IF a = Atom.FromText (&quot;Color&quot;) THEN
          WITH r = RealFromSx (RefList.Nth (list, 1)),
               g = RealFromSx (RefList.Nth (list, 2)),
               b = RealFromSx (RefList.Nth (list, 3)) DO
            RETURN Color.T {r,g, b};
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END ColorFromSx;

PROCEDURE <A NAME="PointFromSx"><procedure>PointFromSx</procedure></A> (sx : Sx.T) : Point3.T RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | RefList.T (list) =&gt;
      &lt;* ASSERT RefList.Length(list) = 4 *&gt;
      TYPECASE list.head OF
      | Atom.T (a) =&gt;
        IF a = Atom.FromText (&quot;Point&quot;) THEN
          WITH x = RealFromSx (RefList.Nth (list, 1)),
               y = RealFromSx (RefList.Nth (list, 2)),
               z = RealFromSx (RefList.Nth (list, 3)) DO
            RETURN Point3.T {x, y, z};
          END;
        ELSE
          RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
        END;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END PointFromSx;

PROCEDURE <A NAME="RealFromSx"><procedure>RealFromSx</procedure></A> (sx : Sx.T) : REAL RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | REF REAL (rr) =&gt;
      RETURN rr^;
    | REF INTEGER (ri) =&gt;
      RETURN FLOAT(ri^);
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END RealFromSx;

PROCEDURE <A NAME="BoolFromSx"><procedure>BoolFromSx</procedure></A> (sx : Sx.T) : BOOLEAN RAISES {ZeusClass.Error} =
  BEGIN
    TYPECASE sx OF
    | Atom.T (a) =&gt;
      IF a = Sx.True THEN
        RETURN TRUE;
      ELSIF a = Sx.False THEN
        RETURN FALSE;
      ELSE
        RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
      END;
    ELSE
      RAISE ZeusClass.Error (&quot;Illformed Sx&quot;);
    END;
  END BoolFromSx;

PROCEDURE <A NAME="AddLight"><procedure>AddLight</procedure></A> (self : T; l : LightGO.T) =
  BEGIN
    (*** add the light to the root ***)
    self.view.root.add (l);

    (*** grow the light array if necessary ***)
    IF self.numlights = NUMBER (self.lights^) THEN
      WITH newlights = NEW (REF ARRAY OF LightWrapper,
                            2 * NUMBER (self.lights^)) DO
        SUBARRAY (newlights^, 0, self.numlights) := self.lights^;
        self.lights := newlights;
      END;
    END;

    (*** Also add the light source to the Light-Editor form. ***)
    WITH form = self.view.form,
         id = Fmt.Int (self.nextid),
         switch = &quot;LightSwitch&quot; &amp; id,
         button = &quot;LightButton&quot; &amp; id,
         blabel = &quot;LightButtonLabel&quot; &amp; id,
         title  = &quot;\&quot;Light &quot; &amp; id &amp; &quot;\&quot;&quot;,
         desc = &quot;(Rim (Pen 2) (HBox (Boolean %&quot; &amp; switch &amp; &quot; (HBox)) (Button %&quot; &amp; button &amp; &quot; (Text %&quot; &amp; blabel &amp; title &amp; &quot;)) (Glue 20)))&quot; DO
      EVAL FormsVBT.Insert (form, &quot;LightArray&quot;, desc, self.numlights);
      INC (self.nextid);

      (*** add a new LightWrapper to the light-array ***)
      self.lights[self.numlights].switch := switch;
      self.lights[self.numlights].button := button;
      self.lights[self.numlights].blabel := blabel;
      self.lights[self.numlights].title  := title;
      self.lights[self.numlights].light  := l;
      INC (self.numlights);

      (*** attach the callbacks ***)
      FormsVBT.AttachProc (form, switch, LightSwitchCallback);
      FormsVBT.AttachProc (form, button, LightButtonCallback);

      (*** Set the switch according to the status of the light ***)
      WITH onoff = NARROW (l.getProp (LightGO.Switch), BooleanProp.Val).get () DO
        FormsVBT.PutBoolean (form, switch, onoff);
      END;

      (*** Finally, simulate a button-press event ***)
      FormsVBT.MakeEvent (form, button, 0);
    END;

  END AddLight;

PROCEDURE <A NAME="LightButtonCallback"><procedure>LightButtonCallback</procedure></A> (             form  : FormsVBT.T;
                                            event : TEXT;
                               &lt;* UNUSED *&gt; c     : REFANY;
                               &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  VAR
    lw : LightWrapper;
  BEGIN
    (*** extract the lightmanager ***)
    WITH form = NARROW (form, View3D.Form),
         view = form.view,
         self = view.lightMgr DO

      (*** Unhighlight the previously selected light (if any) ***)
      IF self.current # -1 THEN
        WITH color = FormsVBT.GetColorProperty (form, &quot;LightArray&quot;, &quot;BgColor&quot;),
             blabel = self.lights[self.current].blabel DO
          FormsVBT.PutColorProperty (form, blabel, &quot;BgColor&quot;, color);
          self.current := -1;
        END;
      END;

      (*** find out which button was pressed ***)
      FOR i := 0 TO self.numlights DO
        IF Text.Equal (event, self.lights[i].button) THEN
          lw := self.lights[i];
          self.current := i;
          EXIT;
        END;
      END;
      &lt;* ASSERT self.current # -1 *&gt;

      WITH lw = self.lights[self.current] DO

        (*** Highlight the button. ***)
        WITH color = ColorName.ToRGB (&quot;LightBlue&quot;) DO
          FormsVBT.PutColorProperty (form, lw.blabel, &quot;BgColor&quot;, color);
        END;

        (*** update the form with the values of the light ***)
        FormsVBT.MakeActive (form, &quot;SelectedLightSplit&quot;);
        FormsVBT.PutText (form, &quot;LightName&quot;, lw.title);

        (*** make the light the current one ***)
        PutLightParamsOntoForm (lw.light, form);
      END;
    END;
  END LightButtonCallback;

PROCEDURE <A NAME="PutLightParamsOntoForm"><procedure>PutLightParamsOntoForm</procedure></A> (l : LightGO.T; form : FormsVBT.T) =
  BEGIN
    TYPECASE l OF
    | AmbientLightGO.T (l) =&gt;
      FormsVBT.PutBoolean (form, &quot;AmbientLightChoice&quot;, TRUE);
      FormsVBT.PutInteger (form, &quot;LightTSplit&quot;, 0);
      ColorPVUpdatesForm (l, LightGO.Colour, form, &quot;AmbientLight&quot;);
    | VectorLightGO.T (l) =&gt;
      FormsVBT.PutBoolean (form, &quot;VectorLightChoice&quot;, TRUE);
      FormsVBT.PutInteger (form, &quot;LightTSplit&quot;, 1);
      ColorPVUpdatesForm (l, LightGO.Colour, form, &quot;VectorLight&quot;);
      PointPVUpdatesForm (l, VectorLightGO.Direction, form, &quot;VectorLightDir&quot;);
    | PointLightGO.T (l) =&gt;
      FormsVBT.PutBoolean (form, &quot;PointLightChoice&quot;, TRUE);
      FormsVBT.PutInteger (form, &quot;LightTSplit&quot;, 2);
      ColorPVUpdatesForm (l, LightGO.Colour, form, &quot;PointLight&quot;);
      PointPVUpdatesForm (l, PointLightGO.Origin, form, &quot;PointLightOrig&quot;);
      RealPVUpdatesForm (l, PointLightGO.Attenuation0, form, &quot;PointLightAtt0&quot;);
      RealPVUpdatesForm (l, PointLightGO.Attenuation1, form, &quot;PointLightAtt1&quot;);
    | SpotLightGO.T (l) =&gt;
      FormsVBT.PutBoolean (form, &quot;SpotLightChoice&quot;, TRUE);
      FormsVBT.PutInteger (form, &quot;LightTSplit&quot;, 3);
      ColorPVUpdatesForm (l, LightGO.Colour, form, &quot;SpotLight&quot;);
      PointPVUpdatesForm (l, SpotLightGO.Origin, form, &quot;SpotLightOrig&quot;);
      PointPVUpdatesForm (l, SpotLightGO.Direction, form, &quot;SpotLightDir&quot;);
      RealPVUpdatesForm (l, SpotLightGO.Concentration, form, &quot;SpotLightConc&quot;);
      RealPVUpdatesForm (l, SpotLightGO.SpreadAngle, form, &quot;SpotLightSpread&quot;);
      RealPVUpdatesForm (l, SpotLightGO.Attenuation0, form, &quot;SpotLightAtt0&quot;);
      RealPVUpdatesForm (l, SpotLightGO.Attenuation1, form, &quot;SpotLightAtt1&quot;);
    ELSE
      RAISE FatalError (&quot;Unexpected type of light&quot;);
    END;
  END PutLightParamsOntoForm;

PROCEDURE <A NAME="AttachColorCallback"><procedure>AttachColorCallback</procedure></A> (form : FormsVBT.T;
                               prefix : TEXT;
                               proc   : FormsVBT.Proc) =
  BEGIN
    FormsVBT.AttachProc (form, prefix &amp; &quot;Red&quot;,   proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Green&quot;, proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Blue&quot;,  proc);
  END AttachColorCallback;

PROCEDURE <A NAME="AttachPointCallback"><procedure>AttachPointCallback</procedure></A> (form   : FormsVBT.T;
                               prefix : TEXT;
                               proc   : FormsVBT.Proc) =
  BEGIN
    FormsVBT.AttachProc (form, prefix &amp; &quot;X&quot;, proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Y&quot;, proc);
    FormsVBT.AttachProc (form, prefix &amp; &quot;Z&quot;, proc);
  END AttachPointCallback;

PROCEDURE <A NAME="CurrentLight"><procedure>CurrentLight</procedure></A> (form : FormsVBT.T) : LightGO.T =
  BEGIN
    WITH form  = NARROW (form, View3D.Form),
         lmgr  = form.view.lightMgr DO
      RETURN lmgr.lights[lmgr.current].light;
    END;
  END CurrentLight;

PROCEDURE <A NAME="AmbientLightCallback"><procedure>AmbientLightCallback</procedure></A> (             form  : FormsVBT.T;
                                &lt;* UNUSED *&gt; event : TEXT;
                                &lt;* UNUSED *&gt; c     : REFANY;
                                &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH light = CurrentLight (form) DO
      ColorFormUpdatesPV (form, &quot;AmbientLight&quot;, light, LightGO.Colour);
    END;
  END AmbientLightCallback;

PROCEDURE <A NAME="VectorLightCallback"><procedure>VectorLightCallback</procedure></A> (             form  : FormsVBT.T;
                               &lt;* UNUSED *&gt; event : TEXT;
                               &lt;* UNUSED *&gt; c     : REFANY;
                               &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH light = CurrentLight (form) DO
      ColorFormUpdatesPV (form, &quot;VectorLight&quot;, light, LightGO.Colour);
      PointFormUpdatesPV (form, &quot;VectorLightDir&quot;,
                          light, VectorLightGO.Direction);
    END;
  END VectorLightCallback;

PROCEDURE <A NAME="PointLightCallback"><procedure>PointLightCallback</procedure></A> (             form  : FormsVBT.T;
                              &lt;* UNUSED *&gt; event : TEXT;
                              &lt;* UNUSED *&gt; c     : REFANY;
                              &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH light = CurrentLight (form) DO
      ColorFormUpdatesPV (form, &quot;PointLight&quot;, light, LightGO.Colour);
      PointFormUpdatesPV (form, &quot;PointLightOrig&quot;, light, PointLightGO.Origin);
      RealFormUpdatesPV (form, &quot;PointLightAtt0&quot;,
                         light, PointLightGO.Attenuation0);
      RealFormUpdatesPV (form, &quot;PointLightAtt1&quot;,
                         light, PointLightGO.Attenuation1);
    END;
  END PointLightCallback;

PROCEDURE <A NAME="SpotLightCallback"><procedure>SpotLightCallback</procedure></A> (             form  : FormsVBT.T;
                             &lt;* UNUSED *&gt; event : TEXT;
                             &lt;* UNUSED *&gt; c     : REFANY;
                             &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH light = CurrentLight (form) DO
      ColorFormUpdatesPV (form, &quot;SpotLight&quot;, light, LightGO.Colour);
      PointFormUpdatesPV (form, &quot;SpotLightOrig&quot;, light, SpotLightGO.Origin);
      PointFormUpdatesPV (form, &quot;SpotLightDir&quot;, light, SpotLightGO.Direction);
      RealFormUpdatesPV (form, &quot;SpotLightAtt0&quot;,
                         light, SpotLightGO.Attenuation0);
      RealFormUpdatesPV (form, &quot;SpotLightAtt1&quot;,
                         light, SpotLightGO.Attenuation1);
      RealFormUpdatesPV (form, &quot;SpotLightConc&quot;,
                         light, SpotLightGO.Concentration);
      RealFormUpdatesPV (form, &quot;SpotLightSpread&quot;,
                         light, SpotLightGO.SpreadAngle);
    END;
  END SpotLightCallback;

PROCEDURE <A NAME="LightSwitchCallback"><procedure>LightSwitchCallback</procedure></A> (             form  : FormsVBT.T;
                                            event : TEXT;
                               &lt;* UNUSED *&gt; c     : REFANY;
                               &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  VAR
    lw : LightWrapper;
  BEGIN
    (*** extract the lightmanager ***)
    WITH form = NARROW (form, View3D.Form),
         view = form.view,
         self = view.lightMgr DO

      (*** find out which switch was pressed ***)
      FOR i := 0 TO self.numlights DO
        IF Text.Equal (event, self.lights[i].switch) THEN
          lw := self.lights[i];
          EXIT;
        END;
      END;

      (*** update the light and re-render the scene ***)
      WITH switch = FormsVBT.GetBoolean (form, event) DO
        lw.light.setProp (LightGO.Switch.bind (BooleanProp.NewConst (switch)));
      END;
    END;
  END LightSwitchCallback;

PROCEDURE <A NAME="AddLightCallback"><procedure>AddLightCallback</procedure></A> (             form  : FormsVBT.T;
                            &lt;* UNUSED *&gt; event : TEXT;
                            &lt;* UNUSED *&gt; c     : REFANY;
                            &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH form = NARROW (form, View3D.Form),
         view = form.view,
         lmgr = view.lightMgr,
         light = AmbientLightGO.New (Color.White) DO
      lmgr.addLight (light);
    END;
  END AddLightCallback;

PROCEDURE <A NAME="DeleteLightCallback"><procedure>DeleteLightCallback</procedure></A> (             form  : FormsVBT.T;
                               &lt;* UNUSED *&gt; event : TEXT;
                               &lt;* UNUSED *&gt; c     : REFANY;
                               &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  &lt;* FATAL GroupGO.BadElement *&gt;
  BEGIN
    WITH form = NARROW (form, View3D.Form),
         view = form.view,
         lmgr = view.lightMgr,
         light = lmgr.lights[lmgr.current].light DO

      (*** remove the light ***)
      view.root.remove (light);

      (*** remove the current switch/button widget from the viewport ***)
      &lt;* ASSERT lmgr.current &gt;= 0 AND lmgr.current &lt; lmgr.numlights *&gt;
      FormsVBT.Delete (form, &quot;LightArray&quot;, lmgr.current);

      (*** Pack the light-array ***)
      FOR i := lmgr.current + 1 TO lmgr.numlights - 1 DO
        lmgr.lights[i-1] := lmgr.lights[i];
      END;
      DEC (lmgr.numlights);
      lmgr.current := -1;

      (*** Hide the light-adjustment portion of the popup menu ***)
      FormsVBT.MakeVanish (view.form, &quot;SelectedLightSplit&quot;);
    END;
  END DeleteLightCallback;

PROCEDURE <A NAME="LightChoiceCallback"><procedure>LightChoiceCallback</procedure></A> (             form  : FormsVBT.T;
                               &lt;* UNUSED *&gt; event : TEXT;
                               &lt;* UNUSED *&gt; c     : REFANY;
                               &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  &lt;* FATAL GroupGO.BadElement *&gt;
  VAR
    light : LightGO.T;
    choice := FormsVBT.GetChoice (form, &quot;LightChoice&quot;);
  BEGIN
    IF Text.Equal (choice, &quot;AmbientLightChoice&quot;) THEN
      light := AmbientLightGO.New (Color.White);
    ELSIF Text.Equal (choice, &quot;VectorLightChoice&quot;) THEN
      light := VectorLightGO.New (Color.White,
                                         Point3.T {1.0, 0.0, 0.0});
    ELSIF Text.Equal (choice, &quot;PointLightChoice&quot;) THEN
      light := PointLightGO.New (Color.White,
                                        Point3.T {0.0, 0.0, 0.0},
                                        1.0,
                                        1.0);
    ELSIF Text.Equal (choice, &quot;SpotLightChoice&quot;) THEN
      light := SpotLightGO.New (Color.White,
                                Point3.T {0.0, 0.0, 0.0},
                                Point3.T {1.0, 0.0, 0.0},
                                1.0,
                                1.57,
                                1.0,
                                1.0);
    ELSE
      RAISE FatalError (&quot;LightChoiceCallback: Unexpected Choice&quot;);
    END;

    WITH form = NARROW (form, View3D.Form),
         view = form.view,
         lmgr = view.lightMgr DO

      (*** replace the light ***)
      view.root.remove (lmgr.lights[lmgr.current].light);
      view.root.add (light);
      lmgr.lights[lmgr.current].light := light;

      (*** update the light-adjustment portion of the popup menu ***)
      PutLightParamsOntoForm (light, form);
    END;
  END LightChoiceCallback;
</PRE>***************************************************************************
 Connecting Property Values to Forms                                       
***************************************************************************

<P><PRE>PROCEDURE <A NAME="ColorFormUpdatesPV"><procedure>ColorFormUpdatesPV</procedure></A> (form : FormsVBT.T;
                               name : TEXT;
                               go   : GO.T;
                               pn   : Prop.Name) =
  BEGIN
    WITH color = GetColorFromForm (form, name),
         pv    = NARROW (go.getProp (pn), ColorProp.Val),
         beh   = NARROW (pv.beh, ColorProp.ConstBeh) DO
      beh.set (color);
    END;
  END ColorFormUpdatesPV;

PROCEDURE <A NAME="PointFormUpdatesPV"><procedure>PointFormUpdatesPV</procedure></A> (form : FormsVBT.T;
                              name : TEXT;
                              go   : GO.T;
                              pn   : Prop.Name) =
  BEGIN
    WITH point = GetPointFromForm (form, name),
         pv    = NARROW (go.getProp (pn), PointProp.Val),
         beh   = NARROW (pv.beh, PointProp.ConstBeh) DO
      beh.set (point);
    END;
  END PointFormUpdatesPV;

PROCEDURE <A NAME="RealFormUpdatesPV"><procedure>RealFormUpdatesPV</procedure></A> (form : FormsVBT.T;
                              name : TEXT;
                              go   : GO.T;
                              pn   : Prop.Name) =
  BEGIN
    WITH real = GetRealFromForm (form, name),
         pv   = NARROW (go.getProp (pn), RealProp.Val),
         beh  = NARROW (pv.beh, RealProp.ConstBeh) DO
      beh.set (real);
    END;
  END RealFormUpdatesPV;

PROCEDURE <A NAME="ColorPVUpdatesForm"><procedure>ColorPVUpdatesForm</procedure></A> (go   : GO.T;
                               pn   : Prop.Name;
                               form : FormsVBT.T;
                               name : TEXT) =
  BEGIN
    WITH color = NARROW (go.getProp (pn), ColorProp.Val).get () DO
      PutColorOntoForm (form, name, color);
    END;
  END ColorPVUpdatesForm;

PROCEDURE <A NAME="PointPVUpdatesForm"><procedure>PointPVUpdatesForm</procedure></A> (go   : GO.T;
                              pn   : Prop.Name;
                              form : FormsVBT.T;
                              name : TEXT) =
  BEGIN
    WITH point = NARROW (go.getProp (pn), PointProp.Val).get () DO
      PutPointOntoForm (form, name, point);
    END;
  END PointPVUpdatesForm;

PROCEDURE <A NAME="RealPVUpdatesForm"><procedure>RealPVUpdatesForm</procedure></A> (go   : GO.T;
                             pn   : Prop.Name;
                             form : FormsVBT.T;
                             name : TEXT) =
  BEGIN
    WITH real = NARROW (go.getProp (pn), RealProp.Val).get () DO
      PutRealOntoForm (form, name, real);
    END;
  END RealPVUpdatesForm;

PROCEDURE <A NAME="PutColorOntoForm"><procedure>PutColorOntoForm</procedure></A> (form : FormsVBT.T; prefix : TEXT; col : Color.T) =
  BEGIN
    FormsVBT.PutInteger (form, prefix &amp; &quot;Red&quot;,   ROUND (col.r * 100.0));
    FormsVBT.PutInteger (form, prefix &amp; &quot;Green&quot;, ROUND (col.g * 100.0));
    FormsVBT.PutInteger (form, prefix &amp; &quot;Blue&quot;,  ROUND (col.b * 100.0));
  END PutColorOntoForm;

PROCEDURE <A NAME="PutPointOntoForm"><procedure>PutPointOntoForm</procedure></A> (form : FormsVBT.T; prefix : TEXT; p : Point3.T) =
  BEGIN
    FormsVBT.PutText (form, prefix &amp; &quot;X&quot;, Fmt.Real (p.x));
    FormsVBT.PutText (form, prefix &amp; &quot;Y&quot;, Fmt.Real (p.y));
    FormsVBT.PutText (form, prefix &amp; &quot;Z&quot;, Fmt.Real (p.y));
  END PutPointOntoForm;

PROCEDURE <A NAME="PutRealOntoForm"><procedure>PutRealOntoForm</procedure></A> (form : FormsVBT.T; name : TEXT; v : REAL) =
  BEGIN
     FormsVBT.PutText (form, name, Fmt.Real (v));
  END PutRealOntoForm;

PROCEDURE <A NAME="GetPointFromForm"><procedure>GetPointFromForm</procedure></A> (form : FormsVBT.T; prefix : TEXT) : Point3.T =
  BEGIN
    WITH x      = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;X&quot;  )),
         y      = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;Y&quot;  )),
         z      = Scan.Real (FormsVBT.GetText (form, prefix &amp; &quot;Z&quot;  )) DO
      RETURN Point3.T {x, y, z};
    END;
  END GetPointFromForm;

PROCEDURE <A NAME="GetColorFromForm"><procedure>GetColorFromForm</procedure></A> (form  : FormsVBT.T; prefix : TEXT) : Color.T =
  BEGIN
    WITH r = FLOAT (FormsVBT.GetInteger (form, prefix &amp; &quot;Red&quot;  )) / 100.0,
         g = FLOAT (FormsVBT.GetInteger (form, prefix &amp; &quot;Green&quot;)) / 100.0,
         b = FLOAT (FormsVBT.GetInteger (form, prefix &amp; &quot;Blue&quot; )) / 100.0 DO
      RETURN Color.T {r, g, b};
    END;
  END GetColorFromForm;

PROCEDURE <A NAME="GetRealFromForm"><procedure>GetRealFromForm</procedure></A> (form  : FormsVBT.T; name : TEXT) : REAL =
  BEGIN
    RETURN Scan.Real (FormsVBT.GetText (form, name));
  END GetRealFromForm;

BEGIN
END LightManager.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
