<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/NG_Proxy.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/NG_Proxy.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module>NG_Proxy</module> EXPORTS <implements>Proxy</implements>;

IMPORT Aux;
IMPORT Camera;
IMPORT <A HREF="../../color/src/Color.i3">Color</A>;
IMPORT <A HREF="../../anim3D/src/Clock.i3">Clock</A>;
IMPORT <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>;
IMPORT G;
IMPORT <A HREF="../../anim3D/src/GO.i3">GO</A>;
IMPORT Light;
IMPORT <A HREF="../../geometry/src/Point.i3">Point</A>;
IMPORT <A HREF="../../vbtkitutils/src/Rsrc.i3">Rsrc</A>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
IMPORT <A HREF="../derived/View3DBundle.i3">View3DBundle</A>;
IMPORT <A HREF="View3D.i3">View3D</A>;
IMPORT <A HREF="View3DPrivate.i3">View3DPrivate</A>;
IMPORT <A HREF="../../zeus/src/View.i3">View</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    win : G.Viewer;
  OVERRIDES
    init                := Init;
    render              := Render;
    show                := Show;
    changeClock         := ChangeClock;
    setBackground       := SetBackground;
    setDepthCueValue    := SetDepthCueValue;
    activateDepthCueing := ActivateDepthCueing;
    addLight            := AddLight;
    replaceLight        := ReplaceLight;
    removeLight         := RemoveLight;
    transform           := Transform;
    translate_x         := Translate_x;
    translate_y         := Translate_y;
    translate_z         := Translate_z;
    rotate_x            := Rotate_x;
    rotate_y            := Rotate_y;
    rotate_z            := Rotate_z;
    scale_x             := Scale_x;
    scale_y             := Scale_y;
    scale_z             := Scale_z;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T;
                view : View3D.T;
                title : TEXT;
                winx, winy, winw, winh : INTEGER) : T =
  BEGIN
    (*** read in the top-level control form ***)
    view.form := NEW (View3D.Form, view := view).initFromRsrc (
                                         &quot;NG-GenericCtrls.fv&quot;,
                                         Rsrc.BuildPath (View3DBundle.Get ()));

    EVAL View.T.init (view, view.form);

    self.win := NEW (MyViewer, view := view);
    self.scene_mutex := self.win.scene_mutex;
    FormsVBT.PutGeneric (view.form,
                         &quot;Canvas&quot;,
                         self.win.create (title, winx, winy, winw, winh));

    (*** start spinning thread ***)
    view.renderthread := Thread.Fork (NEW (SpinLoopClosure,
                                           view := view,
                                           win := self.win));

    RETURN self;
  END Init;

PROCEDURE <A NAME="Render"><procedure>Render</procedure></A> (self : T; cam : Camera.T; go : GO.T) =
  BEGIN
    self.win.render (cam, go);
  END Render;

PROCEDURE <A NAME="Show"><procedure>Show</procedure></A> (self : T) =
  BEGIN
    self.win.show ();
  END Show;

PROCEDURE <A NAME="ChangeClock"><procedure>ChangeClock</procedure></A> (self : T; clock : Clock.T) =
  BEGIN
    self.win.changeClock (clock);
  END ChangeClock;

PROCEDURE <A NAME="SetBackground"><procedure>SetBackground</procedure></A> (self : T; col : Color.T) =
  BEGIN
    self.win.setBackground (col);
  END SetBackground;

PROCEDURE <A NAME="SetDepthCueValue"><procedure>SetDepthCueValue</procedure></A> (self : T;
                            frPlane, bkPlane, frScale, bkScale : REAL;
                            c : Color.T) =
  BEGIN
    self.win.setDepthCueValue (frPlane, bkPlane, frScale, bkScale, c);
  END SetDepthCueValue;

PROCEDURE <A NAME="ActivateDepthCueing"><procedure>ActivateDepthCueing</procedure></A> (self : T; on : BOOLEAN) =
  BEGIN
    self.win.activateDepthCueing (on);
  END ActivateDepthCueing;

PROCEDURE <A NAME="AddLight"><procedure>AddLight</procedure></A> (self : T; l : Light.T) =
  BEGIN
    self.win.addLight (l);
  END AddLight;

PROCEDURE <A NAME="ReplaceLight"><procedure>ReplaceLight</procedure></A> (self : T; old, new : Light.T) =
  BEGIN
    self.win.replaceLight (old, new);
  END ReplaceLight;

PROCEDURE <A NAME="RemoveLight"><procedure>RemoveLight</procedure></A> (self : T; l : Light.T) =
  BEGIN
    self.win.removeLight (l);
  END RemoveLight;

PROCEDURE <A NAME="Transform"><procedure>Transform</procedure></A> (self : T; tx, ty, tz, sx, sy, sz, rx, ry, rz : REAL) =
  BEGIN
    self.win.transform (tx, ty, tz, sx, sy, sz, rx, ry, rz);
  END Transform;

PROCEDURE <A NAME="Translate_x"><procedure>Translate_x</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.translate_x (r);
  END Translate_x;

PROCEDURE <A NAME="Translate_y"><procedure>Translate_y</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.translate_y (r);
  END Translate_y;

PROCEDURE <A NAME="Translate_z"><procedure>Translate_z</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.translate_z (r);
  END Translate_z;

PROCEDURE <A NAME="Rotate_x"><procedure>Rotate_x</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.rotate_x (r);
  END Rotate_x;

PROCEDURE <A NAME="Rotate_y"><procedure>Rotate_y</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.rotate_y (r);
  END Rotate_y;

PROCEDURE <A NAME="Rotate_z"><procedure>Rotate_z</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.rotate_z (r);
  END Rotate_z;

PROCEDURE <A NAME="Scale_x"><procedure>Scale_x</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.scale_x (r);
  END Scale_x;

PROCEDURE <A NAME="Scale_y"><procedure>Scale_y</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.scale_y (r);
  END Scale_y;

PROCEDURE <A NAME="Scale_z"><procedure>Scale_z</procedure></A> (self : T; r : REAL) =
  BEGIN
    self.win.scale_z (r);
  END Scale_z;
</PRE>***************************************************************************
 CLASS SpinLoopClosure                                                     
***************************************************************************

<P><PRE>TYPE
  SpinLoopClosure = Thread.Closure OBJECT
    view : View3D.T;
    win  : G.Viewer;
  OVERRIDES
    apply := SpinLoop;
  END;

PROCEDURE <A NAME="SpinLoop"><procedure>SpinLoop</procedure></A> (self : SpinLoopClosure) : REFANY =
  VAR
    v   : View3D.T := self.view;
    win : G.Viewer := self.win;
  BEGIN
    LOOP
      LOCK VBT.mu DO
        (* The alert-test is protected by VBT.mu. Alerts are issued
         * by T.discard, which is also protected by VBT.mu.
         *)
        IF Thread.TestAlert() THEN
          EXIT;
        END;
        IF v.spin THEN
          win.rotate_x (v.spin_x);
          win.rotate_y (v.spin_y);
          win.rotate_z (v.spin_z);
        END;
        win.show();
      END;
      Thread.Pause (0.2d0);  (* suspend for 0.2 seconds *)
    END;
    RETURN NIL;
  END SpinLoop;

TYPE
  MyViewer = G.Viewer OBJECT
    view         : View3D.T;
    lastPress    : VBT.Button;
    last         : Point.T;
    buttonIsDown := FALSE;
  OVERRIDES
    mouse    := Mouse;
    position := Position;
  END;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (v : MyViewer; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      v.lastPress := cd.whatChanged;
      v.last := cd.cp.pt;
      v.buttonIsDown := TRUE;
      VBT.SetCage (v, VBT.CageFromPosition (cd.cp));
      IF NOT VBT.Modifier.Control IN cd.modifiers THEN
        v.view.spin := FALSE;
        v.view.spin_x := 0.0;
        v.view.spin_y := 0.0;
        v.view.spin_z := 0.0;
      END;
    ELSIF cd.clickType = VBT.ClickType.LastUp THEN
      v.buttonIsDown := FALSE;
      VBT.SetCage (v, VBT.EverywhereCage);
    END;
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (v : MyViewer; READONLY cd: VBT.PositionRec) =
  CONST
    tx_factor : REAL = 0.05;
    ty_factor : REAL = 0.05;
    tz_factor : REAL = 0.05;
    sc_factor : REAL = 0.05;
    rx_factor : REAL = 0.05;
    ry_factor : REAL = 0.05;
    rz_factor : REAL = 0.05;
  VAR
    shiftDown   := VBT.Modifier.Shift IN cd.modifiers;
    controlDown := VBT.Modifier.Control IN cd.modifiers;
    delta_h     := FLOAT(cd.cp.pt.h - v.last.h);
    delta_v     := FLOAT(cd.cp.pt.v - v.last.v);
  BEGIN
    (*** This is a workaround for a bug in G (when using X windows) ***)
    IF cd.cp.gone THEN
      RETURN;
    END;

    VBT.SetCage (v, VBT.CageFromPosition (cd.cp));

    IF v.buttonIsDown THEN
      WITH style = FormsVBT.GetChoice (v.view.form, &quot;mousestyle&quot;) DO
        IF Text.Equal(style,&quot;mhbmouse&quot;) THEN
          CASE v.lastPress OF
          | VBT.Modifier.MouseL =&gt;
            IF controlDown THEN
              v.view.spin := TRUE;
              v.view.spin_x := delta_h * rx_factor;
            ELSE
              v.rotate_x(delta_h * rx_factor);
            END;
          | VBT.Modifier.MouseM =&gt;
            IF controlDown THEN
              v.view.spin := TRUE;
              v.view.spin_y := delta_h * ry_factor;
            ELSE
              v.rotate_y(delta_h * ry_factor);
            END;
          | VBT.Modifier.MouseR =&gt;
            IF controlDown THEN
              v.view.spin := TRUE;
              v.view.spin_z := delta_h * rz_factor;
            ELSE
              v.rotate_z(delta_h * rz_factor);
            END;
          ELSE
            (* ignore *)
          END;
        ELSIF Text.Equal(style,&quot;manmouse&quot;) THEN
          CASE v.lastPress OF
          | VBT.Modifier.MouseL =&gt;
            IF shiftDown THEN
              v.translate_z(delta_h * tz_factor);
            ELSE
              v.translate_x ( delta_h * tx_factor);
              v.translate_y (-delta_v * ty_factor);
            END;
          | VBT.Modifier.MouseM =&gt;
            IF controlDown THEN
              v.view.spin := TRUE;
              IF shiftDown THEN
                v.view.spin_z := delta_h * rz_factor;
              ELSE
                v.view.spin_x := delta_v * rx_factor;
                v.view.spin_y := delta_h * ry_factor;
              END;
            ELSE
              IF shiftDown THEN
                v.rotate_z(delta_h * rz_factor);
              ELSE
                v.rotate_x (delta_v * rx_factor);
                v.rotate_y (delta_h * ry_factor);
              END;
            END;
          | VBT.Modifier.MouseR =&gt;
            v.scale_x (1.0 + delta_h * sc_factor);
            v.scale_y (1.0 + delta_h * sc_factor);
            v.scale_z (1.0 + delta_h * sc_factor);
          ELSE
            (* ignore *)
          END;
        ELSE
          Aux.Abort(&quot;View3D: Internal error&quot;);
        END;
      END;
      v.last := cd.cp.pt;
    END; (* IF v.buttonIsDown *)
  END Position;

BEGIN
END NG_Proxy.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
