<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/OrientGuide.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/OrientGuide.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module><implements><A HREF="OrientGuide.i3">OrientGuide</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/Anim3D.i3">Anim3D</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="../../anim3D/src/GroupGO.i3">GroupGO</A>, <A HREF="../../anim3D/src/LineGO.i3">LineGO</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="View3D.i3">View3D</A>,
       <A HREF="View3DPrivate.i3">View3DPrivate</A>, <A HREF="../../zeus/src/ZeusClass.i3">ZeusClass</A>;

&lt;* FATAL FormsVBT.Unimplemented *&gt;
&lt;* FATAL FormsVBT.Error *&gt;

TYPE
  Origin = {UpFront, DownFront, UpBack, DownBack};
  LabelOrient = {XY, XZ, YZ};

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    guide          : GroupGO.T;
    axissize       : REAL;
    origin         : Origin;
    yup            : BOOLEAN; (* axis labelled y goes &quot;up&quot; on the screen *)
    labelorient    : LabelOrient;
    view           : View3D.T;
  OVERRIDES
    init            := Init;
    setFormDefaults := SetFormDefaults;
    getFormState    := GetFormState;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; v : View3D.T) : T =
  BEGIN
    FormsVBT.AttachProc (v.form,&quot;OrientGuideNone&quot;, UpdateOrientGuideNone);
    FormsVBT.AttachProc (v.form,&quot;OrientGuideCube&quot;, UpdateOrientGuideCube);
    FormsVBT.AttachProc (v.form,&quot;OrientGuideAxes&quot;, UpdateOrientGuideAxes);

    FormsVBT.AttachProc (v.form,&quot;SystemSize&quot;, UpdateSystemSize);
    FormsVBT.AttachProc (v.form,&quot;OriginUpFront&quot;, OriginUpFront);
    FormsVBT.AttachProc (v.form,&quot;OriginDownFront&quot;, OriginDownFront);
    FormsVBT.AttachProc (v.form,&quot;OriginUpBack&quot;, OriginUpBack);
    FormsVBT.AttachProc (v.form,&quot;OriginDownBack&quot;, OriginDownBack);
    FormsVBT.AttachProc (v.form,&quot;LabelYUp&quot;, LabelYUp);
    FormsVBT.AttachProc (v.form,&quot;LabelZUp&quot;, LabelZUp);
    FormsVBT.AttachProc (v.form,&quot;LabelParXY&quot;, LabelParXY);
    FormsVBT.AttachProc (v.form,&quot;LabelParXZ&quot;, LabelParXZ);
    FormsVBT.AttachProc (v.form,&quot;LabelParYZ&quot;, LabelParYZ);
    FormsVBT.AttachProc (v.form,&quot;LabelXOn&quot;, LabelOnOff);
    FormsVBT.AttachProc (v.form,&quot;LabelYOn&quot;, LabelOnOff);
    FormsVBT.AttachProc (v.form,&quot;LabelZOn&quot;, LabelOnOff);

    (*** Set some defaults for the orientation guide.                    ***)
    (*** Note: I use buttons instead of booleans/choicers here,          ***)
    (*** therefore I do not restore their state. This should be changed! ***)
    self.origin := Origin.UpFront;
    self.yup := TRUE;
    self.labelorient := LabelOrient.XY;
    self.axissize := 0.0;
    self.guide := NEW (GroupGO.T).init ();
    self.view := v;

    v.spinGroup.add (self.guide);

    RETURN self;
  END Init;

PROCEDURE <A NAME="SetFormDefaults"><procedure>SetFormDefaults</procedure></A> (self : T) =
  BEGIN
    WITH form = self.view.form DO
      FormsVBT.PutChoice  (form, &quot;OrientGuideChoice&quot;, &quot;OrientGuideNone&quot;);
      FormsVBT.PutInteger (form, &quot;SystemSize&quot;, 30);
      FormsVBT.PutBoolean (form, &quot;LabelXOn&quot;, TRUE);
      FormsVBT.PutBoolean (form, &quot;LabelYOn&quot;, TRUE);
      FormsVBT.PutBoolean (form, &quot;LabelZOn&quot;, TRUE);
    END;
  END SetFormDefaults;

PROCEDURE <A NAME="GetFormState"><procedure>GetFormState</procedure></A> (self : T) RAISES {ZeusClass.Error} =
  BEGIN
    WITH form = self.view.form DO
      self.axissize := FLOAT(FormsVBT.GetInteger(form,&quot;SystemSize&quot;)) / 10.0;
      IF    FormsVBT.GetBoolean (form, &quot;OrientGuideNone&quot;) THEN
        self.guide.flush ();
      ELSIF FormsVBT.GetBoolean (form, &quot;OrientGuideCube&quot;) THEN
        self.guide.flush ();
        self.guide.add (wfc);
      ELSIF FormsVBT.GetBoolean (form, &quot;OrientGuideAxes&quot;) THEN
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      ELSE
        RAISE ZeusClass.Error (&quot;Radio 'OrientGuideChoice' has bad state&quot;);
      END;
    END;
  END GetFormState;

PROCEDURE <A NAME="UpdateOrientGuideNone"><procedure>UpdateOrientGuideNone</procedure></A> (form : FormsVBT.T;
                                 &lt;* UNUSED *&gt; event : TEXT;
                                 &lt;* UNUSED *&gt; c : REFANY;
                                 &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.guide.flush ();
    END;
  END UpdateOrientGuideNone;

PROCEDURE <A NAME="UpdateOrientGuideCube"><procedure>UpdateOrientGuideCube</procedure></A> (form : FormsVBT.T;
                                 &lt;* UNUSED *&gt; event : TEXT;
                                 &lt;* UNUSED *&gt; c : REFANY;
                                 &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add(wfc);
      END;
    END;
  END UpdateOrientGuideCube;

PROCEDURE <A NAME="UpdateOrientGuideAxes"><procedure>UpdateOrientGuideAxes</procedure></A> (form : FormsVBT.T;
                                 &lt;* UNUSED *&gt; event : TEXT;
                                 &lt;* UNUSED *&gt; c : REFANY;
                                 &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END UpdateOrientGuideAxes;

PROCEDURE <A NAME="UpdateSystemSize"><procedure>UpdateSystemSize</procedure></A> (form : FormsVBT.T;
                            &lt;* UNUSED *&gt; event : TEXT;
                            &lt;* UNUSED *&gt; c : REFANY;
                            &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.axissize := FLOAT (FormsVBT.GetInteger (form, &quot;SystemSize&quot;)) / 10.0;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END UpdateSystemSize;

PROCEDURE <A NAME="OriginUpFront"><procedure>OriginUpFront</procedure></A> (form : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c : REFANY;
                         &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.origin := Origin.UpFront;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END OriginUpFront;

PROCEDURE <A NAME="OriginDownFront"><procedure>OriginDownFront</procedure></A> (form : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c : REFANY;
                         &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.origin := Origin.DownFront;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END OriginDownFront;

PROCEDURE <A NAME="OriginUpBack"><procedure>OriginUpBack</procedure></A> (form : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c : REFANY;
                         &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.origin := Origin.UpBack;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END OriginUpBack;

PROCEDURE <A NAME="OriginDownBack"><procedure>OriginDownBack</procedure></A> (form : FormsVBT.T;
                         &lt;* UNUSED *&gt; event : TEXT;
                         &lt;* UNUSED *&gt; c : REFANY;
                         &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.origin := Origin.DownBack;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END OriginDownBack;

PROCEDURE <A NAME="LabelYUp"><procedure>LabelYUp</procedure></A> (form : FormsVBT.T;
                    &lt;* UNUSED *&gt; event : TEXT;
                    &lt;* UNUSED *&gt; c : REFANY;
                    &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.yup := TRUE;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelYUp;

PROCEDURE <A NAME="LabelZUp"><procedure>LabelZUp</procedure></A> (form : FormsVBT.T;
                    &lt;* UNUSED *&gt; event : TEXT;
                    &lt;* UNUSED *&gt; c : REFANY;
                    &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.yup := FALSE;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelZUp;

PROCEDURE <A NAME="LabelParXY"><procedure>LabelParXY</procedure></A> (form : FormsVBT.T;
                      &lt;* UNUSED *&gt; event : TEXT;
                      &lt;* UNUSED *&gt; c : REFANY;
                      &lt;* UNUSED *&gt; ts : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.labelorient := LabelOrient.XY;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelParXY;

PROCEDURE <A NAME="LabelParXZ"><procedure>LabelParXZ</procedure></A> (             form  : FormsVBT.T;
                      &lt;* UNUSED *&gt; event : TEXT;
                      &lt;* UNUSED *&gt; c     : REFANY;
                      &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.labelorient := LabelOrient.XZ;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelParXZ;

PROCEDURE <A NAME="LabelParYZ"><procedure>LabelParYZ</procedure></A> (             form  : FormsVBT.T;
                      &lt;* UNUSED *&gt; event : TEXT;
                      &lt;* UNUSED *&gt; c     : REFANY;
                      &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      self.labelorient := LabelOrient.YZ;
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelParYZ;

PROCEDURE <A NAME="LabelOnOff"><procedure>LabelOnOff</procedure></A> (             form  : FormsVBT.T;
                      &lt;* UNUSED *&gt; event : TEXT;
                      &lt;* UNUSED *&gt; c     : REFANY;
                      &lt;* UNUSED *&gt; ts    : VBT.TimeStamp) =
  BEGIN
    WITH top = NARROW (form, View3D.Form), v = top.view, self = v.guide DO
      LOCK Anim3D.lock DO
        self.guide.flush ();
        self.guide.add (MkAxes (self));
      END;
    END;
  END LabelOnOff;

PROCEDURE <A NAME="MkAxes"><procedure>MkAxes</procedure></A> (self : T) : GO.T =

  PROCEDURE MkLetterX (p : Point3.T; sc : REAL) : GO.T =
    VAR
      g : GroupGO.T;
    BEGIN
      g := NEW (GroupGO.T).init ();
      IF FormsVBT.GetBoolean (self.view.form, &quot;LabelXOn&quot;) THEN
        CASE self.labelorient OF
        | LabelOrient.XY =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y - sc, p.z},
                             Point3.T {p.x + sc, p.y + sc, p.z}));
          g.add (LineGO.New (Point3.T {p.x + sc, p.y - sc, p.z},
                             Point3.T {p.x - sc, p.y + sc, p.z}));
        | LabelOrient.XZ =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y, p.z - sc},
                             Point3.T {p.x + sc, p.y, p.z + sc}));
          g.add (LineGO.New (Point3.T {p.x + sc, p.y, p.z - sc},
                             Point3.T {p.x - sc, p.y, p.z + sc}));
        | LabelOrient.YZ =&gt;
          g.add (LineGO.New (Point3.T {p.x, p.y - sc, p.z - sc},
                             Point3.T {p.x, p.y + sc, p.z + sc}));
          g.add (LineGO.New (Point3.T {p.x, p.y + sc, p.z - sc},
                             Point3.T {p.x, p.y - sc, p.z + sc}));
        END;
      END;
      RETURN g;
    END MkLetterX;

  PROCEDURE MkLetterY (p : Point3.T; sc : REAL) : GO.T =
    VAR
      g : GroupGO.T;
    BEGIN
      g := NEW (GroupGO.T).init ();
      IF FormsVBT.GetBoolean (self.view.form, &quot;LabelYOn&quot;) THEN
        CASE self.labelorient OF
        | LabelOrient.XY =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y + sc, p.z},
                             Point3.T {p.x     , p.y     , p.z}));
          g.add (LineGO.New (Point3.T {p.x + sc, p.y + sc, p.z},
                             Point3.T {p.x     , p.y     , p.z}));
          g.add (LineGO.New (Point3.T {p.x     , p.y     , p.z},
                             Point3.T {p.x     , p.y - sc, p.z}));
        | LabelOrient.XZ =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y, p.z + sc},
                             Point3.T {p.x     , p.y, p.z     }));
          g.add (LineGO.New (Point3.T {p.x + sc, p.y, p.z + sc},
                             Point3.T {p.x     , p.y, p.z     }));
          g.add (LineGO.New (Point3.T {p.x     , p.y, p.z     },
                             Point3.T {p.x     , p.y, p.z - sc}));
        | LabelOrient.YZ =&gt;
          g.add (LineGO.New (Point3.T {p.x, p.y - sc, p.z + sc},
                             Point3.T {p.x, p.y     , p.z     }));
          g.add (LineGO.New (Point3.T {p.x, p.y + sc, p.z + sc},
                             Point3.T {p.x, p.y     , p.z     }));
          g.add (LineGO.New (Point3.T {p.x, p.y     , p.z     },
                             Point3.T {p.x, p.y     , p.z - sc}));
        END;
      END;
      RETURN g;
    END MkLetterY;

  PROCEDURE MkLetterZ (p : Point3.T; sc : REAL) : GO.T =
    VAR
      g : GroupGO.T;
    BEGIN
      g := NEW (GroupGO.T).init ();
      IF FormsVBT.GetBoolean (self.view.form, &quot;LabelZOn&quot;) THEN
        CASE self.labelorient OF
        | LabelOrient.XY =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y - sc, p.z},
                             Point3.T {p.x + sc, p.y - sc, p.z}));
          g.add (LineGO.New (Point3.T {p.x - sc, p.y + sc, p.z},
                             Point3.T {p.x + sc, p.y + sc, p.z}));
          g.add (LineGO.New (Point3.T {p.x - sc, p.y - sc, p.z},
                             Point3.T {p.x + sc, p.y + sc, p.z}));
        | LabelOrient.XZ =&gt;
          g.add (LineGO.New (Point3.T {p.x - sc, p.y, p.z - sc},
                             Point3.T {p.x + sc, p.y, p.z - sc}));
          g.add (LineGO.New (Point3.T {p.x - sc, p.y, p.z + sc},
                             Point3.T {p.x + sc, p.y, p.z + sc}));
          g.add (LineGO.New (Point3.T {p.x - sc, p.y, p.z - sc},
                             Point3.T {p.x + sc, p.y, p.z + sc}));
        | LabelOrient.YZ =&gt;
          g.add (LineGO.New (Point3.T {p.x, p.y - sc, p.z - sc},
                             Point3.T {p.x, p.y + sc, p.z - sc}));
          g.add (LineGO.New (Point3.T {p.x, p.y - sc, p.z + sc},
                             Point3.T {p.x, p.y + sc, p.z + sc}));
          g.add (LineGO.New (Point3.T {p.x, p.y - sc, p.z - sc},
                             Point3.T {p.x, p.y + sc, p.z + sc}));
        END;
      END;
      RETURN g;
    END MkLetterZ;

  CONST
    LIGHTBLUE  = Color.T{0.7, 0.7, 1.0};
  VAR
    po, px, py, pz : Point3.T;
    center : Point3.T;
    g : GroupGO.T;
  BEGIN
    g := NEW(GroupGO.T).init();
    LineGO.SetColour (g, LIGHTBLUE);

    WITH a = self.axissize DO
      CASE self.origin OF
      | Origin.UpFront =&gt;
        po := Point3.T{-2.5,  2.5, -2.5};
        px := Point3.T{   a, po.y, po.z};
        py := Point3.T{po.x,   -a, po.z};
        pz := Point3.T{po.x, po.y,    a};
      | Origin.DownFront =&gt;
        po := Point3.T{-2.5, -2.5, -2.5};
        px := Point3.T{   a, po.y, po.z};
        py := Point3.T{po.x,    a, po.z};
        pz := Point3.T{po.x, po.y,    a};
      | Origin.UpBack =&gt;
        po := Point3.T{-2.5,  2.5,  2.5};
        px := Point3.T{   a, po.y, po.z};
        py := Point3.T{po.x,   -a, po.z};
        pz := Point3.T{po.x, po.y,   -a};
      | Origin.DownBack =&gt;
        po := Point3.T{-2.5, -2.5,  2.5};
        px := Point3.T{   a, po.y, po.z};
        py := Point3.T{po.x,    a, po.z};
        pz := Point3.T{po.x, po.y,   -a};
      END;
    END;

    g.add(LineGO.New (po, px));
    g.add(LineGO.New (po, py));
    g.add(LineGO.New (po, pz));

    (* A hack to create three stroke-font characters.
     * Of course, the right thing to do would be to
     * add text support to G ...
     *)
    CASE self.labelorient OF
    | LabelOrient.XY =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.95,
                         po.y + (py.y - po.y) * 0.05,
                         po.z};
    | LabelOrient.XZ =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.95,
                         po.y,
                         po.z + (pz.z - po.z) * 0.05};
    | LabelOrient.YZ =&gt;
      center := Point3.T {px.x,
                         po.y + (py.y - po.y) * 0.05,
                         po.z + (pz.z - po.z) * 0.05};
    END;
    g.add (MkLetterX (center, 0.1));

    CASE self.labelorient OF
    | LabelOrient.XY =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.05,
                         po.y + (py.y - po.y) * 0.95,
                         po.z};
    | LabelOrient.XZ =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.05,
                         py.y,
                         po.z + (pz.z - po.z) * 0.05};
    | LabelOrient.YZ =&gt;
      center := Point3.T {po.x,
                         po.y + (py.y - po.y) * 0.95,
                         po.z + (pz.z - po.z) * 0.05};
    END;
    IF self.yup THEN
      g.add (MkLetterY (center, 0.1));
    ELSE
      g.add (MkLetterZ (center, 0.1));
    END;

    CASE self.labelorient OF
    | LabelOrient.XY =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.05,
                         po.y + (py.y - po.y) * 0.05,
                         pz.z};
    | LabelOrient.XZ =&gt;
      center := Point3.T {po.x + (px.x - po.x) * 0.05,
                         po.y,
                         po.z + (pz.z - po.z) * 0.95};
    | LabelOrient.YZ =&gt;
      center := Point3.T {po.x,
                         po.y + (py.y - po.y) * 0.05,
                         po.z + (pz.z - po.z) * 0.95};
    END;
    IF self.yup THEN
      g.add (MkLetterZ (center, 0.1));
    ELSE
      g.add (MkLetterY (center, 0.1));
    END;

    RETURN g;

  END MkAxes;

VAR
  wfc := MkWireFrameCube();

PROCEDURE <A NAME="MkWireFrameCube"><procedure>MkWireFrameCube</procedure></A>() : GO.T =
  CONST
    LIGHTBLUE  = Color.T{0.7, 0.7, 1.0};
  VAR
    mmm := Point3.T{-3.0,-3.0,-3.0}; (* minus minus minus *)
    mmp := Point3.T{-3.0,-3.0, 3.0};
    mpm := Point3.T{-3.0, 3.0,-3.0};
    mpp := Point3.T{-3.0, 3.0, 3.0};
    pmm := Point3.T{ 3.0,-3.0,-3.0};
    pmp := Point3.T{ 3.0,-3.0, 3.0};
    ppm := Point3.T{ 3.0, 3.0,-3.0};
    ppp := Point3.T{ 3.0, 3.0, 3.0};
    g : GroupGO.T;
  BEGIN
    g := NEW(GroupGO.T).init();
    LineGO.SetColour (g, LIGHTBLUE);
    g.add(LineGO.New(mmm,mmp));
    g.add(LineGO.New(mpm,mpp));
    g.add(LineGO.New(pmm,pmp));
    g.add(LineGO.New(ppm,ppp));
    g.add(LineGO.New(mmm,mpm));
    g.add(LineGO.New(mmp,mpp));
    g.add(LineGO.New(pmm,ppm));
    g.add(LineGO.New(pmp,ppp));
    g.add(LineGO.New(mmm,pmm));
    g.add(LineGO.New(mmp,pmp));
    g.add(LineGO.New(mpm,ppm));
    g.add(LineGO.New(mpp,ppp));
    RETURN g;
  END MkWireFrameCube;

BEGIN
END OrientGuide.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
