<HTML>
<HEAD>
<TITLE>SRC Modula-3: zeus3D/src/View3D.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>zeus3D/src/View3D.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="View3D.m3">View3D</A></interface>;

IMPORT <A HREF="../../anim3D/src/AnimHandle.i3">AnimHandle</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../anim3D/src/ColorProp.i3">ColorProp</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="../../anim3D/src/GroupGO.i3">GroupGO</A>, <A HREF="../../zeus/src/View.i3">View</A>;

EXCEPTION Error;

TYPE
  <A HREF="View3D.m3#T">T</A> &lt;: Public;
  Public = View.T OBJECT
    scene  : GroupGO.T;
    form   : Form;
    ah     : AnimHandle.T;
  METHODS
    init (title : TEXT) : T;
    (* Initialize the 3D view. Use some &quot;reasonable&quot; default values window
       size, camera type, position, and direction, light type, color,
       position, and direction, depth cueing, etc.  Ultimately, the user
       should be able to override those choices. *)

    changeTitle (title : TEXT);
    (* Changes the title of the rendering window to &quot;title&quot;. *)

    findName (name : TEXT) : GO.T;
    (* Returns &quot;self.root.findName(name)&quot;, where &quot;self.root&quot;
       is the (private) &quot;RootGO&quot; of the view. *)

    installSubForm (file : TEXT);

    setWcs (xmin, xmax, ymin, ymax, zmin, zmax : REAL);
    (* Set the world coordinate system.
       Assumes that caller holds &quot;self.lock&quot;. *)

    pause (duration : REAL);
    (* Pause the view for &quot;duration&quot;. The actual length of &quot;duration&quot;
       depends on the value of the animation speed scroller. *)

    defineColor (menu : TEXT; initial : Color.T) : ColorProp.Val;
    (* Create a menu item for a color property value. *)

    getColor (menu : TEXT) : ColorProp.Val RAISES {Error};
    (* get the color property value associated with a menu item *)

    rotate (a, b, c : REAL);
    (* Rotate the scene. Typically used during setup. *)

    addRotationButton (title : TEXT; a, b, c : REAL);
    (* Add a button to perform a specific rotation *)
  END;

TYPE
  Form = FormsVBT.T OBJECT
    view : T;
  END;

END View3D.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
